/*
 * Decompiled with CFR 0.152.
 */
package jet.api;

import java.util.Hashtable;
import jet.api.MergeInfo;
import jet.api.MultiUserDesigner;
import jet.api.Resources;

public class MergeInfos {
    int length;
    MergeInfo[] mInfo;
    Hashtable[] info = new Hashtable[9];
    MultiUserDesigner src;
    MultiUserDesigner dest;
    String rpthandle;
    String uID;
    Resources[] rsc;

    MergeInfos() {
        int n = 9;
        while (--n >= 0) {
            this.info[n] = new Hashtable();
        }
    }

    public MergeInfos(MultiUserDesigner multiUserDesigner, MultiUserDesigner multiUserDesigner2, String string, String string2) {
        this();
        this.src = multiUserDesigner;
        this.dest = multiUserDesigner2;
        this.rpthandle = string;
        this.uID = string2;
    }

    public MergeInfos(MergeInfo[] mergeInfoArray) {
        this();
        this.mInfo = mergeInfoArray;
        this.length = mergeInfoArray.length;
    }

    public void add(MergeInfo mergeInfo) {
        this.insert(mergeInfo, this.length);
    }

    public boolean insert(MergeInfo mergeInfo, int n) {
        if (n >= 0 && n <= this.length) {
            if (this.mInfo == null) {
                this.mInfo = new MergeInfo[4];
            }
            if (this.mInfo.length == this.length) {
                MergeInfo[] mergeInfoArray = new MergeInfo[this.length + this.length];
                System.arraycopy(this.mInfo, 0, mergeInfoArray, 0, this.length);
                this.mInfo = mergeInfoArray;
            }
            if (n != this.length) {
                System.arraycopy(this.mInfo, n, this.mInfo, n + 1, this.length - n);
                this.mInfo[n] = mergeInfo;
                ++this.length;
            } else {
                this.mInfo[this.length++] = mergeInfo;
            }
            this.info[mergeInfo.type].put(mergeInfo.oName, this.mInfo);
            return true;
        }
        return false;
    }

    public MergeInfo remove(MergeInfo mergeInfo) {
        return this.remove(this.indexOf(mergeInfo)) ? mergeInfo : null;
    }

    public boolean remove(int n) {
        if (n >= 0 && n < this.length) {
            MergeInfo mergeInfo = this.mInfo[n];
            this.info[mergeInfo.type].remove(mergeInfo.oName);
            if (n < this.length - 1) {
                System.arraycopy(this.mInfo, n + 1, this.mInfo, n, this.length - n - 1);
            }
            --this.length;
            return true;
        }
        return false;
    }

    public boolean setInfo(MergeInfo mergeInfo, int n) {
        if (n >= 0 && n < this.length) {
            this.mInfo[n] = mergeInfo;
            this.info[mergeInfo.type].put(mergeInfo.oName, this.mInfo);
            return true;
        }
        if (n == this.length) {
            this.add(mergeInfo);
            return true;
        }
        return false;
    }

    public MergeInfo getInfo(int n) {
        if (n >= 0 && n < this.length) {
            return this.mInfo[n];
        }
        return null;
    }

    public int getLength() {
        return this.length;
    }

    public int indexOf(MergeInfo mergeInfo) {
        int n = this.length;
        while (--n >= 0) {
            if (mergeInfo != this.mInfo[n]) continue;
            return n;
        }
        return -1;
    }

    public boolean hasConflict() {
        boolean bl = false;
        int n = this.length;
        while (--n >= 0) {
            bl |= this.mInfo[n].conflict;
        }
        return bl;
    }
}

