/*
 * Decompiled with CFR 0.152.
 */
package jet.api;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.api.CatalogAPI;
import jet.api.FormulaInfo;
import jet.api.ParameterInfo;
import jet.api.QueryAndInfo;
import jet.api.QueryFieldInfo;
import jet.api.QueryJoinInfo;
import jet.api.QueryQBEInfo;
import jet.api.QueryTableInfo;
import jet.api.SubQueryInfo;
import jet.api.SummaryInfo;
import jet.api.UnionInfo;
import jet.api.UnionInfos;
import jet.api.UserData;
import jet.connect.DbColDesc;
import jet.controls.JetObject;
import jet.exception.ParseFormulaFailedException;
import jet.formula.SumaryFuncs;
import jet.jetc.ReadFailureException;
import jet.jetc.WriteFailureException;
import jet.universe.JetUCompColQueryField;
import jet.universe.JetUConnection;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUDatabase;
import jet.universe.JetUField;
import jet.universe.JetUFileQuery;
import jet.universe.JetUFormula;
import jet.universe.JetUParameter;
import jet.universe.JetUProcedure;
import jet.universe.JetUQueriable;
import jet.universe.JetUQuery;
import jet.universe.JetUResourceContainer;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;
import jet.universe.JetUTable;
import jet.universe.JetUTableView;
import jet.universe.JetUUniverse;
import jet.universe.JetUUserDataSource;
import jet.universe.JetUView;
import jet.universe.JetUWherePortion;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.FMLFileException;
import jet.universe.exception.FormulaHasGrammarError;
import jet.universe.exception.UniverseFileException;
import jet.universe.psql.BadFileQueryException;
import jet.universe.psql.FileQuery;
import jet.universe.psql.RptPsqlQuery;
import jet.util.IntKeyHashtable;
import jet.util.UnionVerifier;
import toolkit.db.PsqlColumn;
import toolkit.db.PsqlJoin;
import toolkit.db.PsqlSelColumn;
import toolkit.db.PsqlTable;

public class MultiUserCatalogAPI
extends CatalogAPI {
    JetUUniverse editCat;
    Hashtable lockList = new Hashtable();
    Hashtable userList = new Hashtable();

    MultiUserCatalogAPI(JetUUniverse jetUUniverse, JetUUniverse jetUUniverse2, String string, String string2) {
        super(jetUUniverse, string, string2);
        this.editCat = jetUUniverse2;
    }

    MultiUserCatalogAPI(JetUUniverse jetUUniverse, JetUUniverse jetUUniverse2, String string, String string2, String string3) {
        super(jetUUniverse, string, string2, string3);
        this.editCat = jetUUniverse2;
    }

    MultiUserCatalogAPI(String string, String string2) throws ReadFailureException, UniverseFileException {
        super(string, string2);
        JetUUniverse.setUniverse(null);
        this.editCat = JetUUniverse.LoadNoCache(string, string2);
        this.editCat.setFullFileName(new File(string, string2));
        JetUUniverse.setUniverse(this.cat);
    }

    MultiUserCatalogAPI(String string, String string2, String string3) throws ReadFailureException, UniverseFileException {
        super(string, string2, string3);
        JetUUniverse.setUniverse(null);
        this.editCat = JetUUniverse.LoadNoCache(string, string2);
        this.editCat.setFullFileName(new File(string, string2));
        JetUUniverse.setUniverse(this.cat);
    }

    public boolean save(String string) throws WriteFailureException, FMLFileException {
        return this.save1(string, "");
    }

    boolean save1(String string, String string2) throws WriteFailureException, FMLFileException {
        if (this.update1(string, string2)) {
            return this.save();
        }
        return false;
    }

    public boolean saveCatalog(String string, String string2) throws WriteFailureException, FMLFileException {
        if (this.updateObject(string2, string)) {
            return this.save();
        }
        return false;
    }

    public boolean save(String string, String string2) throws WriteFailureException, FMLFileException {
        if (this.update(string, string2)) {
            return this.save();
        }
        return false;
    }

    public boolean save(String string, String string2, String string3) throws WriteFailureException, FMLFileException {
        if (this.updateObject(string, string2, string3)) {
            return this.save();
        }
        return false;
    }

    public boolean hasLock(String string) {
        if (string != null) {
            return this.userList.get(string) != null;
        }
        return false;
    }

    public boolean isLock() {
        return !this.lockList.isEmpty();
    }

    public boolean isLock(String string) {
        return this.lockList.get(string) != null;
    }

    public boolean isLock(String string, String string2) {
        if (string != null) {
            UserData userData = (UserData)this.lockList.get(string);
            return userData != null && userData.uID.equals(string2);
        }
        return false;
    }

    public boolean lock(String string, String string2) {
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            UserData userData = (UserData)this.lockList.get(string);
            if (userData == null) {
                this.lock(string, string2, this.copy((JetUDBTreeNode)jetObject));
                return true;
            }
            return userData.uID.equals(string2);
        }
        return false;
    }

    void lock(String string, String string2, JetUDBTreeNode jetUDBTreeNode) {
        this.lockList.put(string, new UserData(string2, jetUDBTreeNode));
        Vector<String> vector = (Vector<String>)this.userList.get(string2);
        if (vector == null) {
            vector = new Vector<String>();
            this.userList.put(string2, vector);
        }
        if (!vector.contains(string)) {
            vector.addElement(string);
        }
    }

    public boolean unlock(String string, String string2) {
        return this.unlock("", string, string2);
    }

    public boolean unlock(String string, String string2, String string3) {
        if (this.isLock(string2, string3)) {
            Vector vector = (Vector)this.userList.get(string3);
            vector.removeElement(string2);
            if (vector.isEmpty()) {
                this.userList.remove(string3);
            }
            this.unlock(string, string2, (UserData)this.lockList.remove(string2));
            return true;
        }
        return false;
    }

    public boolean unlock(String string) {
        return this.unlocked("", string);
    }

    public boolean unlocked(String string, String string2) {
        Vector vector = (Vector)this.userList.remove(string2);
        if (vector != null) {
            int n = vector.size();
            while (--n >= 0) {
                String string3 = (String)vector.elementAt(n);
                this.unlock(string, string3, (UserData)this.lockList.remove(string3));
            }
            return true;
        }
        return false;
    }

    void unlock(String string, String string2, UserData userData) {
        JetUDBTreeNode jetUDBTreeNode = (JetUDBTreeNode)this.handles.get(string2);
        if (jetUDBTreeNode == null) {
            this.editCat.getDatabase(string).remove(userData.obj);
        } else {
            this.copy(jetUDBTreeNode);
        }
    }

    public boolean update(String string, String string2) {
        if (this.isLock(string, string2)) {
            UserData userData = (UserData)this.lockList.get(string);
            this.handles.put(string, this.copyback(userData));
            this.unlock(string, string2);
            return true;
        }
        return false;
    }

    public boolean update(String string) {
        return this.update1(string, "");
    }

    boolean update1(String string, String string2) {
        Vector vector = (Vector)this.userList.remove(string);
        if (vector != null) {
            int n = vector.size();
            while (--n >= 0) {
                String string3 = (String)vector.elementAt(n);
                UserData userData = (UserData)this.lockList.get(string3);
                if (userData == null) continue;
                userData.obj = this.copyback(userData, string2);
                if (userData.obj == null) continue;
                this.handles.put(userData.obj.getQualifyName(), userData.obj);
                this.lockList.remove(string3);
            }
            return true;
        }
        return false;
    }

    public boolean updateObject(String string, String string2, String string3) {
        if (this.isLock(string2, string3)) {
            UserData userData = (UserData)this.lockList.get(string2);
            this.handles.put(string2, this.copyback(userData, string));
            this.unlock(string2, string3);
            return true;
        }
        return false;
    }

    public boolean updateObject(String string, String string2) {
        Vector vector = (Vector)this.userList.remove(string2);
        if (vector != null) {
            int n = vector.size();
            while (--n >= 0) {
                String string3 = (String)vector.elementAt(n);
                UserData userData = (UserData)this.lockList.get(string3);
                if (userData == null) continue;
                userData.obj = this.copyback(userData, string);
                if (userData.obj == null) continue;
                this.handles.put(userData.obj.getQualifyName(), userData.obj);
                this.lockList.remove(string3);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getNewQueryName(String string) {
        return this.FormulaModified("", string);
    }

    public String getNewQueryName(String string, String string2) {
        return this.FormulaModified(string, string2);
    }

    public String getNewParameterName(String string) {
        this.GetQueryByResourceName("", string);
        return "Parameter" + String.valueOf(++this.paramidx);
    }

    public String getNewParameterName(String string, String string2) {
        this.GetQueryByResourceName(string, string2);
        return "Parameter" + String.valueOf(++this.paramidx);
    }

    public String getNewSummaryName(String string) {
        this.GetTableOrViewByRealName("", string);
        return "Summary" + String.valueOf(++this.summaryidx);
    }

    public String getNewSummaryName(String string, String string2) {
        this.GetTableOrViewByRealName(string, string2);
        return "Summary" + String.valueOf(++this.summaryidx);
    }

    @Override
    public String getNewFormulaName(String string) {
        this.GetTableOrViewByResourceName("", string);
        return "Formula" + String.valueOf(++this.formulaidx);
    }

    public String getNewFormulaName(String string, String string2) {
        this.GetTableOrViewByResourceName(string, string2);
        return "Formula" + String.valueOf(++this.formulaidx);
    }

    protected JetUQuery getQuery(String string, String string2, String string3) {
        UserData userData;
        String string4 = this.getHandle(string, string2, 5, string3);
        if (string4 != null && (userData = (UserData)this.lockList.get(string4)) != null && userData.obj instanceof JetUQuery && userData.uID.equals(string3)) {
            return (JetUQuery)userData.obj;
        }
        return this.cat.getDatabase(string).GetQueryByResourceName(string2);
    }

    protected JetUQueriable getQueriable(String string, String string2, String string3) {
        Vector vector = (Vector)this.userList.get(string3);
        if (vector != null) {
            int n = vector.size();
            while (--n >= 0) {
                String string4 = (String)vector.elementAt(n);
                UserData userData = (UserData)this.lockList.get(string4);
                switch (this.getClassType(userData.obj)) {
                    case 6: 
                    case 7: 
                    case 8: {
                        return (JetUQueriable)((Object)userData.obj);
                    }
                }
            }
        }
        return this.cat.getDatabase(string).getQueriableByResourceName(string2);
    }

    public String insert(String string, int n, String string2) {
        return this.insert("", string, n, string2);
    }

    public String insert(String string, String string2, int n, String string3) {
        this.clearMsg();
        String string4 = null;
        if (this.isNameExist(string, string2, this.editCat)) {
            this.setError("insert(\"" + string2 + "\",\"" + n + "\",\"" + string3 + "\")" + string2 + " already exists.");
            return null;
        }
        JetUDBTreeNode jetUDBTreeNode = this.insertObject(string2, n, this.editCat.getDatabase(string));
        if (jetUDBTreeNode != null) {
            string4 = jetUDBTreeNode.getQualifyName();
            this.lock(string4, string3, jetUDBTreeNode);
        }
        return string4;
    }

    public String insert(String string, QueryFieldInfo queryFieldInfo, QueryJoinInfo queryJoinInfo, QueryQBEInfo queryQBEInfo, QueryAndInfo queryAndInfo, String string2) {
        return this.insert("", string, queryFieldInfo, queryJoinInfo, queryQBEInfo, queryAndInfo, string2);
    }

    public String insert(String string, String string2, QueryFieldInfo queryFieldInfo, QueryJoinInfo queryJoinInfo, QueryQBEInfo queryQBEInfo, QueryAndInfo queryAndInfo, String string3) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        if (this.editCat.getDatabase(string).getQueriableByResourceName(string2) != null) {
            this.setError("insert(" + string2 + "\" queryFieldInfo, queryJoinInfo, queryQBEInfo, queryAndInfo \"):query \"" + string2 + "\"has exist in the catalog");
            return null;
        }
        JetUConnection jetUConnection = this.getConnection(string, string3);
        if (jetUConnection == null) {
            this.setError("insert(" + string2 + "\" queryFieldInfo, queryJoinInfo, queryQBEInfo, queryAndInfo \"):there is not a connection in current universe. Please insert a connection first.");
            return null;
        }
        if (queryFieldInfo == null) {
            this.setError("insert(" + string2 + "\" queryFieldInfo, queryJoinInfo, queryQBEInfo, queryAndInfo \"):user must specify tables and fields in queryFieldInfo ");
            return null;
        }
        JetUQuery jetUQuery = this.createQuery(string, string2, queryFieldInfo, queryJoinInfo, queryQBEInfo, queryAndInfo, null);
        if (jetUQuery != null) {
            this.editCat.getDatabase(string).addQuery(jetUQuery);
            string2 = jetUQuery.getQualifyName();
            this.lock(string2, string3, jetUQuery);
            return string2;
        }
        return null;
    }

    @Override
    public boolean deleteQuery(String string, String string2) {
        return this.deleteQuery("", string, string2);
    }

    public boolean deleteQuery(String string, String string2, String string3) {
        JetUUniverse.setUniverse(this.editCat);
        JetUDatabase jetUDatabase = this.editCat.getDatabase(string);
        String string4 = this.getHandle(string, string2, 5, string3);
        if (string4 != null) {
            this.lockList.remove(string4);
        }
        return jetUDatabase.removeQuery(string2);
    }

    public boolean deleteTable(String string, String string2, String string3) {
        return this.deleteTable("", string, string2, string3);
    }

    public boolean deleteTable(String string, String string2, String string3, String string4) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string5 = this.getHandle(string, string2, 5, string4);
        UserData userData = (UserData)this.lockList.get(string5 != null ? string5 : "");
        if (userData != null && userData.uID.equals(string4)) {
            return this.delete(this.editCat, userData.obj, string3);
        }
        return false;
    }

    public boolean deleteColumn(String string, String string2, String string3, String string4) {
        return this.deleteColumn("", string, string2, string3, string4);
    }

    public boolean deleteColumn(String string, String string2, String string3, String string4, String string5) {
        UserData userData;
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string6 = this.getHandle(string, string2, 5, string5);
        if (string6 != null && (userData = (UserData)this.lockList.get(string6)) != null && userData.uID.equals(string5)) {
            return this.delete(userData.obj, string3, string4);
        }
        return false;
    }

    public boolean deleteJoin(String string, int n, String string2) {
        return this.deleteJoin("", string, n, string2);
    }

    public boolean deleteJoin(String string, String string2, int n, String string3) {
        UserData userData;
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string4 = this.getHandle(string, string2, 5, string3);
        if (string4 != null && (userData = (UserData)this.lockList.get(string4)) != null && userData.uID.equals(string3)) {
            return this.delete(userData.obj, n);
        }
        return false;
    }

    public boolean delete(String string, UnionInfo unionInfo, String string2) {
        return this.delete("", string, unionInfo, string2);
    }

    public boolean delete(String string, String string2, UnionInfo unionInfo, String string3) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUQuery jetUQuery = this.getQuery(string, string2, string3);
        return this.delete(jetUQuery, unionInfo.getQueryName(), unionInfo.getUnionStatus());
    }

    @Override
    public boolean delete(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return this.delete("", string, string2, string3, string4, string5, string6, string7);
    }

    public boolean delete(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        UserData userData;
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string9 = this.getHandle(string, string2, 5, string8);
        if (string9 != null && (userData = (UserData)this.lockList.get(string9)) != null && userData.uID.equals(string8)) {
            return this.delete(userData.obj, string3, string4, string5, string6, string7);
        }
        return false;
    }

    @Override
    public boolean deleteQBE(String string, String string2, String string3, String string4, String string5) {
        return this.deleteQBE("", string, string2, string3, string4, string5);
    }

    public boolean deleteQBE(String string, String string2, String string3, String string4, String string5, String string6) {
        UserData userData;
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string7 = this.getHandle(string, string2, 5, string6);
        if (string7 != null && (userData = (UserData)this.lockList.get(string7)) != null && userData.uID.equals(string6)) {
            return this.delete(userData.obj, string3, string4, string5);
        }
        return false;
    }

    public boolean deleteAND(String string, String string2, String string3, String string4, String string5, String string6) {
        return this.deleteAND("", string, string2, string3, string4, string5, string6);
    }

    public boolean deleteAND(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        UserData userData;
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string8 = this.getHandle(string, string2, 5, string7);
        if (string8 != null && (userData = (UserData)this.lockList.get(string8)) != null && userData.uID.equals(string7)) {
            return this.delete(userData.obj, string3, string4, string5, string6);
        }
        return false;
    }

    public boolean set(String string, String string2, boolean bl, String string3) {
        return this.setNewTable("", string, string2, bl, string3);
    }

    public boolean setNewTable(String string, String string2, String string3, boolean bl, String string4) {
        UserData userData;
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string5 = this.getHandle(string, string2, 5, string4);
        if (string5 != null && (userData = (UserData)this.lockList.get(string5)) != null && userData.uID.equals(string4)) {
            return this.set(string, userData.obj, string3, false, bl);
        }
        return false;
    }

    public boolean set(String string, String string2, String string3, boolean bl, String string4) {
        return this.set("", string, string2, string3, bl, string4);
    }

    public boolean set(String string, String string2, String string3, String string4, boolean bl, String string5) {
        UserData userData;
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string6 = this.getHandle(string, string2, 5, string5);
        if (string6 != null && (userData = (UserData)this.lockList.get(string6)) != null && userData.uID.equals(string5)) {
            return this.set("", userData.obj, string3, string4, bl, false);
        }
        return false;
    }

    public boolean set(String string, String string2, String string3, String string4, String string5, String string6, int n, String string7) {
        return this.set("", string, string2, string3, string4, string5, string6, n, string7);
    }

    public boolean set(String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, String string8) {
        UserData userData;
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string9 = this.getHandle(string, string2, 5, string8);
        if (string9 != null && (userData = (UserData)this.lockList.get(string9)) != null && userData.uID.equals(string8)) {
            return this.set((JetUQuery)userData.obj, string3, string4, string5, string6, string7, true, 0, n);
        }
        return false;
    }

    public boolean set(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, int n, int n2, String string7) {
        return this.set("", string, string2, string3, string4, string5, string6, bl, n, n2, string7);
    }

    public boolean set(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, int n, int n2, String string8) {
        UserData userData;
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string9 = this.getHandle(string, string2, 5, string8);
        if (string9 != null && (userData = (UserData)this.lockList.get(string9)) != null && userData.uID.equals(string8)) {
            return this.set((JetUQuery)userData.obj, string3, string4, string5, string6, string7, bl, n, n2);
        }
        return false;
    }

    String addColumn(String string, String string2, RptPsqlQuery rptPsqlQuery, String string3, String string4) {
        JetUDatabase jetUDatabase = this.getDatabase(string, this.editCat);
        JetUConnection jetUConnection = null;
        if (jetUDatabase != null) {
            jetUConnection = string2 == null ? jetUDatabase.getConnection() : jetUDatabase.getConnectionByResourceName(string2);
        }
        if (jetUConnection == null) {
            return null;
        }
        JetUTableView jetUTableView = jetUConnection.GetTableOrViewByRealName(string3);
        if (jetUTableView != null) {
            Vector vector = jetUTableView.getFields();
            for (int i = 0; i < vector.size(); ++i) {
                JetUField jetUField = (JetUField)vector.elementAt(i);
                if (!jetUField.getFldName().equalsIgnoreCase(string4)) continue;
                String string5 = jetUField.getResourceName();
                rptPsqlQuery.addUFieldByName(string5).setMappingName(string5);
                return string5;
            }
        }
        return null;
    }

    private boolean set(JetUQuery jetUQuery, String string, String string2, String string3, String string4, String string5, boolean bl, int n, int n2) {
        boolean bl2;
        block11: {
            bl2 = false;
            if (jetUQuery != null) {
                if (string != null && string2 != null && string4 != null && string5 != null && string3 != null) {
                    RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
                    Vector vector = rptPsqlQuery.getSelColsVector();
                    Vector vector2 = rptPsqlQuery.getPsqlJoinsVector();
                    try {
                        PsqlSelColumn psqlSelColumn = PsqlSelColumn.getSelColByName(vector, string + '.' + string2, false);
                        PsqlSelColumn psqlSelColumn2 = PsqlSelColumn.getSelColByName(vector, string4 + '.' + string5, false);
                        if (psqlSelColumn == null) {
                            this.addColumn(null, null, rptPsqlQuery, string, string2);
                        }
                        if (psqlSelColumn2 == null) {
                            this.addColumn(null, null, rptPsqlQuery, string4, string5);
                        }
                        PsqlJoin psqlJoin = new PsqlJoin(rptPsqlQuery.getPsqlTablesVector(), PsqlTable.getTableByWitchName(rptPsqlQuery.getPsqlTablesVector(), string, false), PsqlTable.getTableByWitchName(rptPsqlQuery.getPsqlTablesVector(), string4, false), PsqlSelColumn.getSelColByName(vector, string + '.' + string2, false), PsqlSelColumn.getSelColByName(vector, string4 + '.' + string5, false), string3);
                        psqlJoin.setSql92(bl);
                        psqlJoin.setOuterJoin(n);
                        if (n2 >= 0) {
                            if (n2 < vector2.size()) {
                                vector2.set(n2, psqlJoin);
                            } else {
                                vector2.add(psqlJoin);
                            }
                            rptPsqlQuery.setPsqlJoinsVector(vector2);
                            rptPsqlQuery.setResolved(false);
                            rptPsqlQuery.resolveAll(jetUQuery.getDatabase().getUniverse());
                            bl2 = true;
                            break block11;
                        }
                        this.setError("set(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + string5 + "\",\"" + n2 + "\"):void index.");
                    }
                    catch (Exception exception) {
                        this.setError("set(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + string5 + "\",\"" + n2 + "\"):void join info.");
                    }
                } else {
                    this.setError("set(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + string5 + "\",\"" + n2 + "\"):void join info.");
                }
            } else {
                this.setError("set(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\",\"" + string4 + "\",\"" + string5 + "\",\"" + n2 + "\"):void qryName.");
            }
        }
        return bl2;
    }

    public boolean set(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return this.set("", string, string2, string3, string4, string5, string6, string7);
    }

    public boolean set(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        UserData userData;
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string9 = this.getHandle(string, string2, 5, string8);
        if (string9 != null && (userData = (UserData)this.lockList.get(string9)) != null && userData.uID.equals(string8)) {
            return this.set((JetUQuery)userData.obj, string3, string4, string5, string6, string7, true, 0, null);
        }
        return false;
    }

    @Override
    public boolean setQBE(String string, String string2, String string3, String string4, String string5) {
        return this.setQBE("", string, string2, string3, string4, string5);
    }

    public boolean setQBE(String string, String string2, String string3, String string4, String string5, String string6) {
        UserData userData;
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string7 = this.getHandle(string, string2, 5, string6);
        if (string7 != null && (userData = (UserData)this.lockList.get(string7)) != null && userData.uID.equals(string6)) {
            return this.set((JetUQuery)userData.obj, string3, string4, string5);
        }
        return false;
    }

    public boolean set(String string, String string2, String string3, String string4, int n, String string5) {
        return this.setQBE("", string, string2, string3, string4, n, string5);
    }

    public boolean setQBE(String string, String string2, String string3, String string4, String string5, int n, String string6) {
        UserData userData;
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string7 = this.getHandle(string, string2, 5, string6);
        if (string7 != null && (userData = (UserData)this.lockList.get(string7)) != null && userData.uID.equals(string6)) {
            return this.set((JetUQuery)userData.obj, string3, string4, string5, n);
        }
        return false;
    }

    public boolean setAND(String string, String string2, String string3, String string4, String string5, String string6) {
        return this.setAND("", string, string2, string3, string4, string5, string6);
    }

    public boolean setAND(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        UserData userData;
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string8 = this.getHandle(string, string2, 5, string7);
        if (string8 != null && (userData = (UserData)this.lockList.get(string8)) != null && userData.uID.equals(string7)) {
            return this.set((JetUQuery)userData.obj, string3, string4, string5, string6);
        }
        return false;
    }

    public boolean set(String string, String string2, String string3, String string4, String string5, int n, String string6) {
        return this.setCondition("", string, string2, string3, string4, string5, n, string6);
    }

    public boolean setCondition(String string, String string2, String string3, String string4, String string5, String string6, int n, String string7) {
        UserData userData;
        this.clearMsg();
        String string8 = this.getHandle(string, string2, 5, string7);
        if (string8 != null && (userData = (UserData)this.lockList.get(string8)) != null && userData.uID.equals(string7)) {
            JetUUniverse.setUniverse(this.editCat);
            return this.set((JetUQuery)userData.obj, string3, string4, string5, string6, n);
        }
        return false;
    }

    @Override
    boolean set(JetUQuery jetUQuery, String string, String string2, String string3, String string4, int n) {
        boolean bl = false;
        if (jetUQuery != null) {
            Vector vector;
            RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
            if (rptPsqlQuery.vSCGrps == null) {
                rptPsqlQuery.vSCGrps = new Vector();
                rptPsqlQuery.vSCGrps.addElement(new Vector());
            } else if (rptPsqlQuery.vSCGrps.size() == 0) {
                rptPsqlQuery.vSCGrps.addElement(new Vector());
            }
            if (rptPsqlQuery.vSCGrps.size() > 0) {
                vector = (Vector)rptPsqlQuery.vSCGrps.elementAt(0);
            } else {
                vector = new Vector();
                rptPsqlQuery.vSCGrps.addElement(vector);
            }
            if (n >= 0) {
                if (n < vector.size()) {
                    vector.setElementAt(new String[]{string, string2, string3, string4}, n);
                } else {
                    vector.addElement(new String[]{string, string2, string3, string4});
                }
                rptPsqlQuery.setResolved(false);
                rptPsqlQuery.resolveAll(this.editCat);
                bl = true;
            } else {
                this.setError("set(\"" + string4 + "\",\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\"):void qryName.");
            }
        } else {
            this.setError("set(\"" + string4 + "\",\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\"):void qryName.");
        }
        return bl;
    }

    public boolean set(String string, ParameterInfo parameterInfo, String string2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        if (this.isLock(string, string2)) {
            return this.set(((UserData)this.lockList.get((Object)string)).obj, parameterInfo);
        }
        this.setError("set(" + string + ", \"ParameterInfo\", " + string2 + ")error: this object should be locked by user \"" + string2 + "\" before it can be edited");
        return false;
    }

    public ParameterInfo getParameterInfo(String string, String string2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        if (this.isLock(string, string2)) {
            return this.getParameterInfo(((UserData)this.lockList.get((Object)string)).obj);
        }
        return this.getParameterInfo(this.getObj(string));
    }

    public SummaryInfo getSummaryInfo(String string, String string2) {
        this.clearMsg();
        if (this.isLock(string, string2)) {
            JetUUniverse.setUniverse(this.editCat);
            return this.getSummaryInfo(((UserData)this.lockList.get((Object)string)).obj);
        }
        return this.getSummaryInfo(this.getObj(string));
    }

    public FormulaInfo getFormulaInfo(String string, String string2) {
        this.clearMsg();
        if (this.isLock(string, string2)) {
            JetUUniverse.setUniverse(this.editCat);
            return this.getFormulaInfo(((UserData)this.lockList.get((Object)string)).obj);
        }
        return this.getFormulaInfo(this.getObj(string));
    }

    public boolean set(String string, SummaryInfo summaryInfo, String string2) {
        this.clearMsg();
        if (this.isLock(string, string2)) {
            return this.set(((UserData)this.lockList.get((Object)string)).obj, summaryInfo, this.editCat);
        }
        this.setError("set(" + string + ", \"SummaryInfo\"" + ", " + string2 + ")this object should be locked by user \"" + string2 + "\" before it can be edited");
        return false;
    }

    public boolean set(String string, FormulaInfo formulaInfo, String string2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        boolean bl = false;
        if (this.isLock(string, string2)) {
            UserData userData = (UserData)this.lockList.get(string);
            bl = this.set(userData.obj, formulaInfo, this.editCat);
        } else {
            this.setError("set(" + string + ", \"FormulaInfo\"" + ", " + string2 + ")this object should be locked by user \"" + string2 + "\" before it can be edited.");
        }
        return bl;
    }

    public String parseFormula(FormulaInfo formulaInfo, String string) {
        return this.parseFormula("", formulaInfo, string);
    }

    public String parseFormula(String string, FormulaInfo formulaInfo, String string2) {
        Object object;
        String string3 = null;
        JetUUniverse jetUUniverse = this.cat.copy();
        JetUDatabase jetUDatabase = jetUUniverse.getDatabase(string);
        Vector vector = (Vector)this.userList.get(string2);
        if (vector != null) {
            int n = vector.size();
            while (--n >= 0) {
                object = (UserData)this.lockList.get((String)vector.elementAt(n));
                if (((UserData)object).obj instanceof JetUFormula && ((JetUDBTreeNode)((UserData)object).obj).getResourceName().equals(formulaInfo.getName())) continue;
                this.replace(this.dup((JetUDBTreeNode)((UserData)object).obj), jetUUniverse);
            }
        }
        try {
            if (formulaInfo != null) {
                if (jetUDatabase.getFormulaByResourceName(formulaInfo.getName()) != null) {
                    jetUDatabase.removeFormula(jetUDatabase.getFormulaByResourceName(formulaInfo.getName()));
                }
                object = new JetUFormula(formulaInfo.getName(), formulaInfo.getDescription(), formulaInfo.getExpression());
                jetUDatabase.addFormula((JetUFormula)object);
            }
            jetUDatabase.parseFormulas(true, true);
        }
        catch (ParseFormulaFailedException parseFormulaFailedException) {
            string3 = parseFormulaFailedException.toString();
        }
        JetUUniverse.setUniverse(this.editCat);
        return string3;
    }

    public boolean set(String string, UnionInfo unionInfo, String string2) {
        return this.set("", string, unionInfo, string2);
    }

    public boolean set(String string, String string2, UnionInfo unionInfo, String string3) {
        this.clearMsg();
        JetUQuery jetUQuery = this.getQuery(string, string2, string3);
        if (jetUQuery != null) {
            return this.set(jetUQuery, unionInfo.getQueryName(), unionInfo.getUnionStatus());
        }
        this.setError("set(\"" + string2 + "\",\"" + unionInfo + "\"):void query name.");
        return false;
    }

    public boolean set(String string, SubQueryInfo subQueryInfo, String string2) {
        return this.set("", string, subQueryInfo, string2);
    }

    public boolean set(String string, String string2, SubQueryInfo subQueryInfo, String string3) {
        this.clearMsg();
        JetUQuery jetUQuery = this.getQuery(string, string2, string3);
        if (jetUQuery != null) {
            return this.set(jetUQuery, subQueryInfo.getExpression1(), subQueryInfo.getOperator(), subQueryInfo.getQueryname(), subQueryInfo.getLogic());
        }
        this.setError("set(\"" + string2 + "\",\"" + subQueryInfo + "\"):void query name.");
        return false;
    }

    @Override
    public boolean isNameExist(String string, String string2) {
        this.clearMsg();
        return this.isNameExist("", string, this.editCat);
    }

    public boolean isNameExist(String string, String string2, String string3) {
        this.clearMsg();
        return this.isNameExist(string, string2, this.editCat);
    }

    public boolean deleteObject(String string, String string2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        if (this.isLock(string, string2)) {
            return this.delete((JetObject)((JetUDBTreeNode)((UserData)this.lockList.get((Object)string)).obj), this.editCat, false);
        }
        return false;
    }

    @Override
    public String[] getDBFields(String string, String string2) {
        return this.getDBFields("", string, string2);
    }

    public String[] getDBFields(String string, String string2, String string3) {
        UserData userData;
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string4 = this.getHandle(string, string2, 5, string3);
        if (string4 != null && (userData = (UserData)this.lockList.get(string4)) != null && userData.uID.equals(string3)) {
            return this.getDBFields(userData.obj);
        }
        return new String[0];
    }

    @Override
    public String[] getFormulae(String string) {
        return this.getFormulae("", string);
    }

    public String[] getFormulae(String string, String string2) {
        String string3;
        this.clearMsg();
        int n = 0;
        String[] stringArray = new String[this.lockList.size()];
        Enumeration enumeration = this.lockList.elements();
        while (enumeration.hasMoreElements()) {
            UserData userData = (UserData)enumeration.nextElement();
            if (!userData.uID.equals(string2) || !(userData.obj instanceof JetUFormula) || userData.obj instanceof JetUSummary) continue;
            stringArray[n++] = ((JetUFormula)userData.obj).getResourceName();
        }
        JetUUniverse.setUniverse(this.cat);
        Vector vector = this.cat.getFormulasInDatabase(string);
        int n2 = vector.size();
        String[] stringArray2 = new String[n2 + n];
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        int n3 = n2;
        while (--n3 >= 0) {
            stringArray2[n3] = string3 = ((JetUFormula)vector.elementAt(n3)).getResourceName();
            hashtable.put(string3, stringArray);
        }
        for (n3 = 0; n3 < n; ++n3) {
            string3 = stringArray[n3];
            if (hashtable.get(string3) != null) continue;
            stringArray2[n2++] = string3;
        }
        if (n2 < stringArray2.length) {
            stringArray = new String[n2];
            System.arraycopy(stringArray2, 0, stringArray, 0, n2);
            stringArray2 = stringArray;
        }
        return stringArray2;
    }

    Vector getFormulaeAndSummaries(String string, String string2) {
        String string3;
        this.clearMsg();
        Vector<JetObject> vector = new Vector<JetObject>();
        String[] stringArray = new String[this.lockList.size()];
        Enumeration enumeration = this.lockList.elements();
        while (enumeration.hasMoreElements()) {
            UserData userData = (UserData)enumeration.nextElement();
            if (!userData.uID.equals(string2) || !(userData.obj instanceof JetUFormula)) continue;
            vector.addElement(userData.obj);
        }
        JetUUniverse.setUniverse(this.cat);
        Vector vector2 = this.cat.getDatabase(string).getFormulasAndSummaries();
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        int n = vector.size();
        while (--n >= 0) {
            string3 = ((JetUFormula)vector.elementAt(n)).getResourceName();
            hashtable.put(string3, stringArray);
        }
        for (n = 0; n < vector2.size(); ++n) {
            string3 = ((JetUFormula)vector2.elementAt(n)).getResourceName();
            if (hashtable.get(string3) != null) continue;
            vector.addElement((JetObject)vector2.elementAt(n));
        }
        return vector;
    }

    @Override
    public String[] getSummaries(String string) {
        return this.getSummaries("", string);
    }

    public String[] getSummaries(String string, String string2) {
        String string3;
        this.clearMsg();
        int n = 0;
        String[] stringArray = new String[this.lockList.size()];
        Enumeration enumeration = this.lockList.elements();
        while (enumeration.hasMoreElements()) {
            UserData userData = (UserData)enumeration.nextElement();
            if (!userData.uID.equals(string2) || !(userData.obj instanceof JetUSummary)) continue;
            stringArray[n++] = ((JetUSummary)userData.obj).getResourceName();
        }
        JetUUniverse.setUniverse(this.cat);
        Vector vector = this.cat.getDatabase(string).getSummaries();
        int n2 = vector.size();
        String[] stringArray2 = new String[n2 + n];
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        int n3 = n2;
        while (--n3 >= 0) {
            stringArray2[n3] = string3 = ((JetUSummary)vector.elementAt(n3)).getResourceName();
            hashtable.put(string3, stringArray);
        }
        for (n3 = 0; n3 < n; ++n3) {
            string3 = stringArray[n3];
            if (hashtable.get(string3) != null) continue;
            stringArray2[n2++] = string3;
        }
        if (n2 < stringArray2.length) {
            stringArray = new String[n2];
            System.arraycopy(stringArray2, 0, stringArray, 0, n2);
            stringArray2 = stringArray;
        }
        return stringArray2;
    }

    @Override
    public String[] getSQLs(String string) {
        return this.getSQLs("", string);
    }

    public String[] getSQLs(String string, String string2) {
        String[] stringArray;
        JetUUniverse.setUniverse(this.editCat);
        JetUConnection jetUConnection = this.editCat.getDatabase(string).getConnection();
        if (jetUConnection != null) {
            Vector vector = jetUConnection.getFileQueries();
            stringArray = new String[vector.size()];
            int n = stringArray.length;
            while (--n >= 0) {
                stringArray[n] = ((JetUFileQuery)vector.elementAt(n)).getResourceName();
            }
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    @Override
    public String[] getUDSs(String string) {
        return this.getUDSs("", string);
    }

    public String[] getUDSs(String string, String string2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        Vector vector = this.editCat.getDatabase(string).getDataSources();
        String[] stringArray = new String[vector.size()];
        int n = stringArray.length;
        while (--n >= 0) {
            stringArray[n] = ((JetUUserDataSource)vector.elementAt(n)).getResourceName();
        }
        return stringArray;
    }

    @Override
    public String[] getParameter(String string) {
        return this.getParameter("", string);
    }

    public String[] getParameter(String string, String string2) {
        String string3;
        this.clearMsg();
        int n = 0;
        String[] stringArray = new String[this.lockList.size()];
        Enumeration enumeration = this.lockList.elements();
        while (enumeration.hasMoreElements()) {
            UserData userData = (UserData)enumeration.nextElement();
            if (!userData.uID.equals(string2) || !(userData.obj instanceof JetUParameter)) continue;
            stringArray[n++] = ((JetUParameter)userData.obj).getResourceName();
        }
        JetUUniverse.setUniverse(this.cat);
        Vector vector = this.cat.getParameters(string);
        int n2 = vector.size();
        String[] stringArray2 = new String[n2 + n];
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        int n3 = n2;
        while (--n3 >= 0) {
            stringArray2[n3] = string3 = ((JetUParameter)vector.elementAt(n3)).getResourceName();
            hashtable.put(string3, stringArray);
        }
        for (n3 = 0; n3 < n; ++n3) {
            string3 = stringArray[n3];
            if (hashtable.get(string3) != null) continue;
            stringArray2[n2++] = string3;
        }
        if (n2 < stringArray2.length) {
            stringArray = new String[n2];
            System.arraycopy(stringArray2, 0, stringArray, 0, n2);
            stringArray2 = stringArray;
        }
        return stringArray2;
    }

    @Override
    public String[] getQueries(String string) {
        return this.getQueries("", string);
    }

    public String[] getQueries(String string, String string2) {
        String string3;
        this.clearMsg();
        int n = 0;
        String[] stringArray = new String[this.lockList.size()];
        Enumeration enumeration = this.lockList.elements();
        while (enumeration.hasMoreElements()) {
            UserData userData = (UserData)enumeration.nextElement();
            if (!(userData.obj instanceof JetUQueriable) || !userData.uID.equals(string2)) continue;
            stringArray[n++] = ((JetUQueriable)((Object)userData.obj)).getResourceName();
        }
        JetUUniverse.setUniverse(this.cat);
        Vector vector = this.cat.getQueriables(string);
        int n2 = vector.size();
        int n3 = 0;
        String[] stringArray2 = new String[n2 + n];
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        int n4 = n2;
        while (--n4 >= 0) {
            JetObject jetObject = (JetObject)vector.elementAt(n4);
            if (!(jetObject instanceof JetUQuery)) continue;
            string3 = ((JetUQuery)jetObject).getResourceName();
            stringArray2[n3++] = string3;
            hashtable.put(string3, stringArray);
        }
        for (n4 = 0; n4 < n; ++n4) {
            string3 = stringArray[n4];
            if (hashtable.get(string3) != null) continue;
            stringArray2[n3++] = string3;
        }
        if (n3 < stringArray2.length) {
            stringArray = new String[n3];
            System.arraycopy(stringArray2, 0, stringArray, 0, n3);
            stringArray2 = stringArray;
        }
        return stringArray2;
    }

    @Override
    public String[] getTables(String string) {
        return this.getTables("", string);
    }

    public String[] getTables(String string, String string2) {
        JetUUniverse.setUniverse(this.editCat);
        Vector vector = this.getTablesInCurrentConnection(string, string2);
        String[] stringArray = new String[vector.size()];
        int n = stringArray.length;
        while (--n >= 0) {
            stringArray[n] = ((JetUTableView)vector.elementAt(n)).getResourceName();
        }
        return stringArray;
    }

    Vector getTablesInCurrentConnection(String string, String string2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        Vector vector = new Vector();
        JetUConnection jetUConnection = this.editCat.getDatabase(string).getConnection();
        if (jetUConnection != null) {
            vector = jetUConnection.getTableViews();
        }
        return vector;
    }

    public QueryTableInfo getColumns(String string, boolean bl, String string2) {
        return this.getColumns("", string, bl, string2);
    }

    public QueryTableInfo getColumns(String string, String string2, boolean bl, String string3) {
        UserData userData;
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string4 = this.getHandle(string, string2, 5, string3);
        UserData userData2 = userData = string4 == null ? null : (UserData)this.lockList.get(string4);
        if (userData != null && userData.uID.equals(string3)) {
            return this.getColumns((JetUQuery)userData.obj, bl);
        }
        return super.getColumns(string, string2, bl);
    }

    public QueryTableInfo getMapColumns(String string, boolean bl, String string2) {
        return this.getMapColumns("", string, bl, string2);
    }

    public QueryTableInfo getMapColumns(String string, String string2, boolean bl, String string3) {
        UserData userData;
        this.clearMsg();
        String string4 = this.getHandle(string, string2, 5, string3);
        if (string4 != null && (userData = (UserData)this.lockList.get(string4)) != null && userData.uID.equals(string3)) {
            return this.getMapColumns((JetUQuery)userData.obj);
        }
        return super.getMapColumns(string, string2);
    }

    @Override
    public String[] getCompColumns(String string, String string2) {
        return this.getCompColumns("", string, string2);
    }

    public String[] getCompColumns(String string, String string2, String string3) {
        this.clearMsg();
        String string4 = this.getHandle(string, string2, 5, string3);
        if (string4 != null) {
            UserData userData = (UserData)this.lockList.get(string4);
            if (userData != null && userData.uID.equals(string3)) {
                return this.getCompColumns((JetUQuery)userData.obj);
            }
            return super.getCompColumns(string, string2);
        }
        return new String[0];
    }

    @Override
    public String[][] getJoins(String string, String string2) {
        return this.getJoins("", string, string2);
    }

    public String[][] getJoins(String string, String string2, String string3) {
        this.clearMsg();
        String string4 = this.getHandle(string, string2, 5, string3);
        if (this.isLock(string4, string3)) {
            UserData userData = (UserData)this.lockList.get(string4);
            if (userData.uID.equals(string3)) {
                return this.getJoins((JetUQuery)userData.obj);
            }
        } else {
            return super.getJoins(this.cat.getDatabase(string).GetQueryByResourceName(string2));
        }
        return new String[0][0];
    }

    @Override
    public String[][] getQBEInfo(String string, String string2) {
        return this.getQBEInfo("", string, string2);
    }

    public String[][] getQBEInfo(String string, String string2, String string3) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string4 = this.getHandle(string, string2, 5, string3);
        if (this.isLock(string4, string3)) {
            UserData userData = (UserData)this.lockList.get(string4);
            if (userData.uID.equals(string3)) {
                return this.getQBEInfo((JetUQuery)userData.obj);
            }
        } else {
            return super.getQBEInfo(string, string2);
        }
        return new String[0][0];
    }

    @Override
    public String[][] getAndConditions(String string, String string2) {
        return this.getAndConditions("", string, string2);
    }

    public String[][] getAndConditions(String string, String string2, String string3) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string4 = this.getHandle(string, string2, 5, string3);
        if (this.isLock(string4, string3)) {
            UserData userData = (UserData)this.lockList.get(string4);
            return this.getAndConditions((JetUQuery)userData.obj);
        }
        return super.getAndConditions(string, string2);
    }

    @Override
    public String[] getColumnMappingnames(String string, String string2) {
        return this.getColumnMappingnames("", string, string2);
    }

    public String[] getColumnMappingnames(String string, String string2, String string3) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string4 = this.getHandle(string, string2, 5, string3);
        if (this.isLock(string4, string3)) {
            UserData userData = (UserData)this.lockList.get(string4);
            return this.getColumnMappingnames((JetUQuery)userData.obj);
        }
        return super.getColumnMappingnames(string, string2);
    }

    @Override
    public QueryTableInfo getColumnsCanBeGroupedBy(String string, String string2) {
        return this.getColumnsCanBeGroupedBy("", string, string2);
    }

    public QueryTableInfo getColumnsCanBeGroupedBy(String string, String string2, String string3) {
        UserData userData;
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string4 = this.getHandle(string, string2, 5, string3);
        if (string4 != null && (userData = (UserData)this.lockList.get(string4)) != null && userData.uID.equals(string3)) {
            return this.getColumnsCanBeGroupedBy((JetUQueriable)((Object)userData.obj));
        }
        return super.getColumnsCanBeGroupedBy(string, string2);
    }

    @Override
    public String[] getFormulaeForQuery(String string, String string2) {
        return this.getFormulaeForQuery("", string, string2);
    }

    public String[] getFormulaeForQuery(String string, String string2, String string3) {
        Object object;
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string4 = this.getHandle(string, string2, 5, string3);
        if (string4 != null && (object = (UserData)this.lockList.get(string4)) != null && ((UserData)object).uID.equals(string3)) {
            return this.getFormulaeForQuery((JetUQueriable)((Object)((UserData)object).obj), this.editCat, this.editCat.getDatabase(string));
        }
        object = this.editCat.getDatabase(string).getQueriableByResourceName(string2);
        return this.getFormulaeForQuery((JetUQueriable)object, this.editCat, this.editCat.getDatabase(string));
    }

    @Override
    public String[] getSummariesForQuery(String string, String string2) {
        return this.getSummariesForQuery("", string, string2);
    }

    public String[] getSummariesForQuery(String string, String string2, String string3) {
        Object object;
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string4 = this.getHandle(string, string2, 5, string3);
        if (string4 != null && (object = (UserData)this.lockList.get(string4)) != null && ((UserData)object).uID.equals(string3)) {
            return this.getSummariesForQuery((JetUQueriable)((Object)((UserData)object).obj), this.editCat, this.editCat.getDatabase(string));
        }
        object = this.editCat.getDatabase(string).getQueriableByResourceName(string2);
        return this.getSummariesForQuery((JetUQueriable)object, this.editCat, this.editCat.getDatabase(string));
    }

    public String[] getFmlCanBeGroupedBy(String string, String string2) {
        return this.getFmlCanBeGroupedBy("", string, string2);
    }

    public String[] getFmlCanBeGroupedBy(String string, String string2, String string3) {
        Object object;
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string4 = this.getHandle(string, string2, 5, string3);
        if (string4 != null && (object = (UserData)this.lockList.get(string4)) != null && ((UserData)object).uID.equals(string3)) {
            JetObject jetObject = ((UserData)object).obj;
            return this.getFormulaeCanBeGroupedBy((JetUQueriable)((Object)jetObject), this.editCat, this.editCat.getDatabase(string));
        }
        object = this.editCat.getDatabase(string).getQueriableByResourceName(string2);
        return this.getFormulaeCanBeGroupedBy((JetUQueriable)object, this.editCat, this.editCat.getDatabase(string));
    }

    @Override
    public String[] getFormulaeCanBeGroupedBy(String string, String string2, String string3) {
        return this.getFormulaeCanBeGroupedBy("", string, string2, string3);
    }

    public String[] getFormulaeCanBeGroupedBy(String string, String string2, String string3, String string4) {
        UserData userData;
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string5 = this.getHandle(string, string2, 5, string4);
        if (string5 != null && (userData = (UserData)this.lockList.get(string5)) != null && userData.uID.equals(string4)) {
            JetObject jetObject = userData.obj;
            return this.getFormulaeCanBeGroupedBy((JetUQueriable)((Object)jetObject), string3, this.editCat.getDatabase(string));
        }
        return super.getFormulaeCanBeGroupedBy(string, string2, string3);
    }

    @Override
    public String[] getChartFunctions(String string, String string2, String string3) {
        return this.getChartFunctions("", string, string2, string3);
    }

    public String[] getChartFunctions(String string, String string2, String string3, String string4) {
        Object object;
        JetUUniverse.setUniverse(this.editCat);
        String string5 = this.getHandle(string, string2, 5, string4);
        if (string5 != null && (object = (UserData)this.lockList.get(string5)) != null && ((UserData)object).uID.equals(string4)) {
            JetObject jetObject = ((UserData)object).obj;
            return this.getChartFunctions((JetUQueriable)((Object)jetObject), string3, string4);
        }
        object = this.editCat.getDatabase(string).getQueriableByResourceName(string2);
        return this.getChartFunctions((JetUQueriable)object, string3, string4);
    }

    String[] getChartFunctions(JetUQueriable jetUQueriable, String string, String string2) {
        if (jetUQueriable == null) {
            return new String[0];
        }
        Vector vector = this.getGroupFormula(jetUQueriable, string, string2);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    Vector getGroupFormula(JetUQueriable jetUQueriable, String string, String string2) {
        Vector<String> vector = new Vector<String>(10);
        Vector vector2 = this.getGroupByFormula(jetUQueriable.getDatabase().getResourceName(), string, jetUQueriable, string2);
        int n = vector2.size();
        JetUFormula jetUFormula = null;
        block3: for (int i = 0; i < n; ++i) {
            jetUFormula = (JetUFormula)vector2.elementAt(i);
            DbColDesc dbColDesc = jetUFormula.getColDesc();
            switch (dbColDesc.getSqlType()) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (jetUFormula.formulainfo.isGlobal) continue block3;
                    vector.addElement(((JetUFormula)vector2.elementAt(i)).getResourceName());
                }
            }
        }
        return vector;
    }

    Vector getGroupByFormula(String string, String string2, JetUQueriable jetUQueriable, String string3) {
        Vector<JetUFormula> vector = new Vector<JetUFormula>();
        Vector vector2 = this.getFormulaeAndSummaries(string, string3);
        int n = vector2.size();
        try {
            for (int i = 0; i < n; ++i) {
                JetUFormula jetUFormula = (JetUFormula)vector2.elementAt(i);
                if (!jetUFormula.isGroupBy(string2) || !jetUQueriable.isFieldValidToQuery(this.editCat, jetUFormula.getResourceName(), string)) continue;
                vector.addElement(jetUFormula);
            }
        }
        catch (FormulaHasGrammarError formulaHasGrammarError) {
        }
        catch (CannotFindFrmlRefFld cannotFindFrmlRefFld) {
        }
        catch (CannotFindEntity cannotFindEntity) {
            // empty catch block
        }
        return vector;
    }

    @Override
    public String[] getParameterCanBeGroupedBy(String string) {
        return this.getParameterCanBeGroupedBy("", string);
    }

    public String[] getParameterCanBeGroupedBy(String string, String string2) {
        JetUUniverse.setUniverse(this.editCat);
        int n = 0;
        Vector vector = this.editCat.getDatabase(string).getChildren();
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            JetObject jetObject = (JetObject)vector.elementAt(i);
            if (!(jetObject instanceof JetUParameter) || ((JetUParameter)jetObject).getColDesc().getSqlType() != 12) continue;
            stringArray[n++] = ((JetUParameter)jetObject).getResourceName();
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        stringArray = stringArray2;
        return stringArray;
    }

    @Override
    public String[] getSummaryCanBeSortedBy(String string, String string2, String string3) {
        return this.getSummaryCanBeSortedBy("", string, string2, string3);
    }

    public String[] getSummaryCanBeSortedBy(String string, String string2, String string3, String string4) {
        String[] stringArray;
        UserData userData;
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        String string5 = this.getHandle(string2, 5, string4);
        UserData userData2 = userData = string5 == null ? null : (UserData)this.lockList.get(string5);
        if (userData != null && userData.uID.equals(string4)) {
            JetObject jetObject = userData.obj;
            return this.getSummaryCanBeSortedBy((JetUQueriable)((Object)jetObject), string3, this.editCat);
        }
        boolean bl = false;
        Enumeration enumeration = this.lockList.elements();
        Vector<String> vector = new Vector<String>();
        JetUQueriable jetUQueriable = this.cat.getDatabase(string).getQueriableByResourceName(string2);
        while (enumeration.hasMoreElements()) {
            stringArray = ((UserData)enumeration.nextElement()).obj;
            try {
                if (!(stringArray instanceof JetUSummary) || !jetUQueriable.isFieldValidToQuery(this.cat, (JetUResourceEntity)stringArray, string) || !((JetUSummary)stringArray).isGroupBy(string3)) continue;
                vector.addElement(((JetUSummary)stringArray).getResourceName());
            }
            catch (CannotFindFrmlRefFld cannotFindFrmlRefFld) {
            }
            catch (FormulaHasGrammarError formulaHasGrammarError) {
            }
            catch (CannotFindEntity cannotFindEntity) {}
        }
        stringArray = super.getSummaryCanBeSortedBy(string, string2, string3);
        String[] stringArray2 = null;
        if (vector.size() > 0) {
            int n;
            for (n = 0; n < stringArray.length; ++n) {
                if (!vector.contains(stringArray[n])) continue;
                vector.remove(stringArray[n]);
            }
            stringArray2 = new String[stringArray.length + vector.size()];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            for (n = 0; n < vector.size(); ++n) {
                stringArray2[stringArray.length + n] = (String)vector.elementAt(n);
            }
            return stringArray2;
        }
        return stringArray;
    }

    JetUConnection getConnection(String string, String string2) {
        JetUUniverse.setUniverse(this.editCat);
        JetUDatabase jetUDatabase = this.editCat.getDatabase(string);
        if (jetUDatabase != null) {
            return jetUDatabase.getConnection();
        }
        return null;
    }

    protected JetUUniverse getCatalog(String string) {
        return this.editCat;
    }

    private String FormulaModified(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        int n = 1;
        while (this.cat.getQueriableByResourceName(string, "Query" + n) != null || this.GetFileQueryByResourceName("Query" + n)) {
            ++n;
        }
        return "Query" + n;
    }

    private boolean GetFileQueryByResourceName(String string) {
        Enumeration enumeration = this.lockList.elements();
        while (enumeration.hasMoreElements()) {
            UserData userData = (UserData)enumeration.nextElement();
            if (!(userData.obj instanceof JetUQueriable) || !((JetUQueriable)((Object)userData.obj)).getResourceName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private void GetQueryByResourceName(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        String[] stringArray = this.getParameter(string, string2);
        int n = stringArray.length;
        while (--n >= 0) {
            int n2;
            if (stringArray[n].length() <= 9 || !stringArray[n].substring(0, 9).equalsIgnoreCase("Parameter")) continue;
            try {
                n2 = Integer.parseInt(stringArray[n].substring(9, stringArray[n].length()));
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            this.paramidx = Math.max(n2, this.paramidx);
        }
    }

    private void GetTableOrViewByRealName(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        String[] stringArray = this.getSummaries(string, string2);
        int n = stringArray.length;
        while (--n >= 0) {
            int n2;
            if (stringArray[n].length() <= 7 || !stringArray[n].substring(0, 7).equalsIgnoreCase("Summary")) continue;
            try {
                n2 = Integer.parseInt(stringArray[n].substring(7, stringArray[n].length()));
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            this.summaryidx = Math.max(n2, this.summaryidx);
        }
    }

    private void GetTableOrViewByResourceName(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        String[] stringArray = this.getFormulae(string, string2);
        int n = stringArray.length;
        while (--n >= 0) {
            int n2;
            if (stringArray[n].length() <= 7 || !stringArray[n].substring(0, 7).equalsIgnoreCase("Formula")) continue;
            try {
                n2 = Integer.parseInt(stringArray[n].substring(7, stringArray[n].length()));
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            this.formulaidx = Math.max(n2, this.formulaidx);
        }
    }

    @Override
    public boolean isModified() {
        JetUUniverse.setUniverse(this.cat);
        return this.cat.IsModified();
    }

    public boolean isModified(String string) {
        return this.userList.get(string) != null;
    }

    @Override
    public void setModified(boolean bl) {
        JetUUniverse.setUniverse(this.cat);
        this.cat.setModified(bl);
    }

    public void setModified(boolean bl, String string) {
        JetUUniverse.setUniverse(this.editCat);
        this.editCat.setModified(bl);
    }

    private Vector I(Vector vector, String string, String string2, String string3) {
        JetUUniverse.setUniverse(this.cat);
        Vector<PsqlTable> vector2 = new Vector<PsqlTable>();
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            PsqlTable psqlTable = (PsqlTable)vector.elementAt(i);
            if (!psqlTable.getName().equals(string3)) continue;
            String string4 = psqlTable.getQualifier();
            if (string4 == null) {
                string4 = "";
            }
            if (string4.trim().length() == 0) {
                string4 = "";
            }
            if (!string4.equals(string)) continue;
            String string5 = psqlTable.getOwner();
            if (string5 == null) {
                string5 = "";
            }
            if (string5.trim().length() == 0) {
                string5 = "";
            }
            if (!string5.equals(string2)) continue;
            vector2.addElement(psqlTable);
        }
        return vector2;
    }

    private boolean IsModified(PsqlColumn psqlColumn, PsqlColumn psqlColumn2) {
        JetUUniverse.setUniverse(this.cat);
        boolean bl = false;
        if (psqlColumn.getType() == psqlColumn2.getType()) {
            bl = this.isVarCharTypes(psqlColumn.getType()) ? psqlColumn.length == psqlColumn2.length : true;
        }
        return bl;
    }

    private boolean SEDU(Vector vector, PsqlJoin psqlJoin) {
        JetUUniverse.setUniverse(this.cat);
        boolean bl = false;
        int n = vector.size();
        while (--n >= 0) {
            PsqlJoin psqlJoin2 = (PsqlJoin)vector.elementAt(n);
            if (!psqlJoin2.getTableFrom().getName().equals(psqlJoin.getTableFrom().getName()) || !psqlJoin2.getColumnFrom().getName().equals(psqlJoin.getColumnFrom().getName()) || !psqlJoin2.getTableTo().getName().equals(psqlJoin.getTableTo().getName()) || !psqlJoin2.getColumnTo().getName().equals(psqlJoin.getColumnTo().getName()) || !psqlJoin2.getOperator().equals(psqlJoin.getOperator())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    JetUDBTreeNode copyback(UserData userData) {
        return this.copyback1(userData, "");
    }

    JetUDBTreeNode copyback1(UserData userData, String string) {
        if (userData != null) {
            JetUDBTreeNode jetUDBTreeNode = (JetUDBTreeNode)userData.obj;
            Vector vector = jetUDBTreeNode instanceof JetUTableView ? ((JetUTableView)jetUDBTreeNode).getFields() : null;
            if ((jetUDBTreeNode = this.replace(this.dup(jetUDBTreeNode), this.cat, string)) instanceof JetUTableView) {
                JetUTableView jetUTableView = (JetUTableView)jetUDBTreeNode;
                for (int i = 0; i < vector.size(); ++i) {
                    JetUField jetUField = (JetUField)vector.elementAt(i);
                    String string2 = jetUField.getInstName();
                    String string3 = jetUField.getQualifyName();
                    jetUField = (JetUField)this.dup(jetUField);
                    jetUTableView.addField(jetUField);
                    jetUField.setInstName(string2);
                    this.handles.put(string3, jetUField);
                }
            }
            return jetUDBTreeNode;
        }
        return null;
    }

    JetUDBTreeNode copyback(UserData userData, String string) {
        if (userData != null) {
            JetUDBTreeNode jetUDBTreeNode = (JetUDBTreeNode)userData.obj;
            Vector vector = jetUDBTreeNode instanceof JetUTableView ? ((JetUTableView)jetUDBTreeNode).getFields() : null;
            if ((jetUDBTreeNode = this.replace(this.dup(jetUDBTreeNode), this.cat, string)) instanceof JetUTableView) {
                JetUTableView jetUTableView = (JetUTableView)jetUDBTreeNode;
                for (int i = 0; i < vector.size(); ++i) {
                    JetUField jetUField = (JetUField)vector.elementAt(i);
                    String string2 = jetUField.getInstName();
                    String string3 = jetUField.getQualifyName();
                    jetUField = (JetUField)this.dup(jetUField);
                    jetUTableView.addField(jetUField);
                    jetUField.setInstName(string2);
                    this.handles.put(string3, jetUField);
                }
            }
            return jetUDBTreeNode;
        }
        return null;
    }

    JetUDBTreeNode copy(JetUDBTreeNode jetUDBTreeNode) {
        Vector vector = jetUDBTreeNode instanceof JetUTableView ? ((JetUTableView)jetUDBTreeNode).getFields() : null;
        if ((jetUDBTreeNode = this.replace(this.dup(jetUDBTreeNode), this.editCat)) instanceof JetUTableView) {
            JetUTableView jetUTableView = (JetUTableView)jetUDBTreeNode;
            for (int i = 0; i < vector.size(); ++i) {
                JetUField jetUField = (JetUField)vector.elementAt(i);
                String string = jetUField.getInstName();
                String string2 = jetUField.getQualifyName();
                jetUField = (JetUField)this.dup(jetUField);
                jetUTableView.addField(jetUField);
                jetUField.setInstName(string);
                this.handles.put(string2, jetUField);
            }
        }
        return jetUDBTreeNode;
    }

    JetUDBTreeNode dup(JetUDBTreeNode jetUDBTreeNode) {
        String string = jetUDBTreeNode.getResourceName();
        if (jetUDBTreeNode instanceof JetUQuery) {
            return new JetUQuery(string, ((JetUQuery)jetUDBTreeNode).getPsqlQuery().getCopy());
        }
        if (jetUDBTreeNode instanceof JetUParameter) {
            return ((JetUParameter)jetUDBTreeNode).createNew();
        }
        if (jetUDBTreeNode instanceof JetUSummary) {
            return (JetUSummary)((JetUSummary)jetUDBTreeNode).createNew();
        }
        if (jetUDBTreeNode instanceof JetUFormula) {
            try {
                return ((JetUFormula)jetUDBTreeNode).createNew();
            }
            catch (Exception exception) {
            }
        } else {
            if (jetUDBTreeNode instanceof JetUTableView) {
                return ((JetUTableView)jetUDBTreeNode).createNew();
            }
            if (jetUDBTreeNode instanceof JetUField) {
                return ((JetUField)jetUDBTreeNode).createNew();
            }
            if (jetUDBTreeNode instanceof JetUProcedure) {
                return ((JetUProcedure)jetUDBTreeNode).cloneEntity();
            }
            if (jetUDBTreeNode instanceof JetUFileQuery) {
                return ((JetUFileQuery)jetUDBTreeNode).getCopy();
            }
            if (jetUDBTreeNode instanceof JetUUserDataSource) {
                return ((JetUUserDataSource)jetUDBTreeNode).cloneEntity();
            }
            if (jetUDBTreeNode instanceof JetUCompColQueryField) {
                return ((JetUCompColQueryField)jetUDBTreeNode).copy();
            }
        }
        return null;
    }

    JetUDBTreeNode replace(JetUDBTreeNode jetUDBTreeNode, JetUUniverse jetUUniverse) {
        return this.replace(jetUDBTreeNode, jetUUniverse, "");
    }

    JetUDBTreeNode replace(JetUDBTreeNode jetUDBTreeNode, JetUUniverse jetUUniverse, String string) {
        if (jetUDBTreeNode != null) {
            String string2 = jetUDBTreeNode.getResourceName();
            String string3 = null;
            JetUUniverse.setUniverse(jetUUniverse);
            JetUDatabase jetUDatabase = jetUUniverse.getDatabase(string);
            JetUConnection jetUConnection = jetUDatabase.getConnection();
            if (jetUDBTreeNode instanceof JetUQuery) {
                JetUQuery jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
                RptPsqlQuery rptPsqlQuery = ((JetUQuery)jetUDBTreeNode).getPsqlQuery();
                rptPsqlQuery.setUniverse(jetUUniverse);
                if (jetUQuery != null) {
                    string3 = jetUQuery.getInstName();
                    jetUDatabase.removeQuery(string2);
                }
                try {
                    jetUDatabase.addQuery((JetUQuery)jetUDBTreeNode);
                }
                catch (Exception exception) {}
            } else if (jetUDBTreeNode instanceof JetUParameter) {
                JetUParameter jetUParameter = jetUDatabase.getParameterByResourceName(string2);
                if (jetUParameter != null) {
                    string3 = jetUParameter.getInstName();
                    jetUDatabase.removeParameter(jetUParameter);
                }
                jetUDatabase.addParameter((JetUParameter)jetUDBTreeNode);
            } else if (jetUDBTreeNode instanceof JetUSummary) {
                JetUSummary jetUSummary = jetUDatabase.getSummaryByResourceName(string2);
                if (jetUSummary != null) {
                    string3 = jetUSummary.getInstName();
                    jetUDatabase.removeSummary(jetUSummary);
                }
                jetUDatabase.addSummary((JetUSummary)jetUDBTreeNode);
                jetUDatabase.setFormulaModified(true);
                try {
                    jetUDatabase.parseSummary((JetUSummary)jetUDBTreeNode);
                }
                catch (ParseFormulaFailedException parseFormulaFailedException) {
                    this.setError(parseFormulaFailedException);
                }
            } else if (jetUDBTreeNode instanceof JetUFormula) {
                JetUFormula jetUFormula = jetUDatabase.getFormulaByResourceName(string2);
                if (jetUFormula != null) {
                    string3 = jetUFormula.getInstName();
                    jetUDatabase.removeFormula(jetUFormula);
                }
                jetUDatabase.addFormula((JetUFormula)jetUDBTreeNode);
                jetUDatabase.FormulaModified();
            } else if (jetUDBTreeNode instanceof JetUField) {
                JetUTableView jetUTableView = (JetUTableView)jetUDBTreeNode.getParent();
                JetUField jetUField = (jetUTableView = jetUConnection.GetTableOrViewByResourceName(jetUTableView.getResourceName())).getFieldByResourceName(string2);
                if (jetUField != null) {
                    string3 = jetUField.getInstName();
                    jetUTableView.removeField(jetUField);
                }
                jetUTableView.addField((JetUField)jetUDBTreeNode);
            } else if (jetUDBTreeNode instanceof JetUTableView) {
                JetUTableView jetUTableView = jetUConnection.GetTableOrViewByResourceName(string2);
                if (jetUTableView != null) {
                    string3 = jetUTableView.getInstName();
                    jetUConnection.removeTableView(string2);
                }
                jetUConnection.addTableView((JetUTableView)jetUDBTreeNode);
            } else if (jetUDBTreeNode instanceof JetUProcedure) {
                JetUProcedure jetUProcedure = jetUConnection.getProcedureByResourceName(string2);
                if (jetUProcedure != null) {
                    string3 = jetUProcedure.getInstName();
                    jetUConnection.removeProcedure(jetUProcedure);
                }
                jetUConnection.addProcedure((JetUProcedure)jetUDBTreeNode);
            } else if (jetUDBTreeNode instanceof JetUUserDataSource) {
                JetUUserDataSource jetUUserDataSource = jetUDatabase.getDataSourceByResourceName(string2);
                if (jetUUserDataSource != null) {
                    string3 = jetUUserDataSource.getInstName();
                    jetUDatabase.removeDataSource(jetUUserDataSource);
                }
                jetUDatabase.addDataSource((JetUUserDataSource)jetUDBTreeNode);
            } else if (jetUDBTreeNode instanceof JetUFileQuery) {
                JetUFileQuery jetUFileQuery = jetUConnection.GetFileQueryByResourceName(string2);
                if (jetUFileQuery != null) {
                    string3 = jetUFileQuery.getInstName();
                    jetUConnection.removeFileQuery(jetUFileQuery);
                }
                if (!jetUConnection.isQueryNameExist(string2)) {
                    jetUConnection.add((JetUFileQuery)jetUDBTreeNode);
                }
            } else {
                jetUDBTreeNode = null;
            }
            if (jetUDBTreeNode != null) {
                jetUDBTreeNode.setResourceName(string2);
                if (string3 != null) {
                    jetUDBTreeNode.setInstName(string3);
                }
            }
        }
        return jetUDBTreeNode;
    }

    private String Z(String string, String string2, int n, JetUUniverse jetUUniverse) {
        JetUUniverse.setUniverse(jetUUniverse);
        switch (n) {
            case 1: {
                JetUConnection jetUConnection = jetUUniverse.getConnectionByResourceName(string, string2);
                return jetUConnection != null ? jetUConnection.getQualifyName() : null;
            }
            case 5: {
                JetUQuery jetUQuery = jetUUniverse.GetQueryByResourceName(string, string2);
                return jetUQuery != null ? jetUQuery.getQualifyName() : null;
            }
            case 6: {
                JetUQueriable jetUQueriable = jetUUniverse.getQueriableByResourceName(string, string2);
                return jetUQueriable != null && jetUQueriable instanceof JetUProcedure ? ((JetUProcedure)jetUQueriable).getQualifyName() : null;
            }
            case 8: {
                JetUQueriable jetUQueriable = jetUUniverse.getQueriableByResourceName(string, string2);
                return jetUQueriable != null && jetUQueriable instanceof JetUUserDataSource ? ((JetUUserDataSource)jetUQueriable).getQualifyName() : null;
            }
            case 7: {
                JetUQueriable jetUQueriable = jetUUniverse.getQueriableByResourceName(string, string2);
                return jetUQueriable != null && jetUQueriable instanceof JetUFileQuery ? ((JetUFileQuery)jetUQueriable).getQualifyName() : null;
            }
            case 10: {
                JetUSummary jetUSummary = jetUUniverse.getDatabase(string).getSummaryByResourceName(string2);
                return jetUSummary != null ? jetUSummary.getQualifyName() : null;
            }
            case 9: {
                JetUFormula jetUFormula = jetUUniverse.getDatabase(string).getFormulaByResourceName(string2);
                return jetUFormula != null ? jetUFormula.getQualifyName() : null;
            }
            case 11: {
                JetUParameter jetUParameter = jetUUniverse.getDatabase(string).getParameterByResourceName(string2);
                return jetUParameter != null ? jetUParameter.getQualifyName() : null;
            }
            case 12: {
                JetUWherePortion jetUWherePortion = jetUUniverse.getDatabase(string).getWherePortionByResourceName(string2);
                return jetUWherePortion != null ? jetUWherePortion.getQualifyName() : null;
            }
            case 3: {
                JetUView jetUView = (JetUView)jetUUniverse.getDatabase(string).getConnection().getTableViewsByResourceName(string2, 2);
                return jetUView != null ? jetUView.getQualifyName() : null;
            }
            case 2: {
                JetUTable jetUTable = (JetUTable)jetUUniverse.getDatabase(string).getConnection().getTableViewsByResourceName(string2, 2);
                return jetUTable != null ? jetUTable.getQualifyName() : null;
            }
        }
        JetUResourceEntity jetUResourceEntity = jetUUniverse.getDatabase(string).getResourceByName(string2);
        if (jetUResourceEntity != null) {
            return jetUResourceEntity.getQualifyName();
        }
        JetUResourceContainer jetUResourceContainer = (JetUResourceContainer)((Object)jetUUniverse.getDatabase(string).getQueriableByResourceName(string2));
        if (jetUResourceContainer != null) {
            return jetUResourceContainer.getQualifyName();
        }
        jetUResourceContainer = jetUUniverse.getDatabase(string).getConnection().GetTableOrViewByResourceName(string2);
        if (jetUResourceContainer != null) {
            return jetUResourceContainer.getQualifyName();
        }
        return null;
    }

    public String getHandle(String string, String string2) {
        return this.getHandle("", string, string2);
    }

    public String getHandle(String string, String string2, String string3) {
        String string4 = null;
        JetUResourceEntity jetUResourceEntity = this.cat.getDatabase(string).getResourceByName(string2);
        if (jetUResourceEntity == null) {
            jetUResourceEntity = this.editCat.getDatabase(string).getResourceByName(string2);
            if (jetUResourceEntity != null && this.isLock(jetUResourceEntity.getQualifyName(), string3)) {
                string4 = jetUResourceEntity.getQualifyName();
            }
        } else {
            string4 = jetUResourceEntity.getQualifyName();
        }
        if (string4 == null) {
            Object object;
            int n;
            Hashtable<String, JetUQuery> hashtable = new Hashtable<String, JetUQuery>();
            Vector vector = (Vector)this.userList.get(string3);
            if (vector != null) {
                n = vector.size();
                while (--n >= 0) {
                    object = (UserData)this.lockList.get((String)vector.elementAt(n));
                    if (!(((UserData)object).obj instanceof JetUQuery)) continue;
                    JetUQuery jetUQuery = (JetUQuery)((UserData)object).obj;
                    hashtable.put(jetUQuery.getResourceName(), jetUQuery);
                    string4 = this.getHandle(jetUQuery, string2);
                    if (string4 == null) continue;
                    hashtable.clear();
                    return string4;
                }
            }
            vector = this.cat.getDatabase(string).getQueries();
            n = vector.size();
            while (--n >= 0) {
                object = (JetUQuery)vector.elementAt(n);
                if (hashtable.get(((JetUDBTreeNode)object).getResourceName()) != null || (string4 = this.getHandle((JetUQuery)object, string2)) == null) continue;
                hashtable.clear();
                return string4;
            }
        }
        return string4;
    }

    String getHandle(JetUQuery jetUQuery, String string) {
        Vector vector = jetUQuery.getFields();
        int n = vector.size();
        while (--n >= 0) {
            JetUDBTreeNode jetUDBTreeNode = (JetUDBTreeNode)vector.elementAt(n);
            if (!jetUDBTreeNode.getResourceName().equalsIgnoreCase(string)) continue;
            return jetUDBTreeNode.getQualifyName();
        }
        return null;
    }

    public String getHandle(String string, int n, String string2) {
        return this.getHandle("", string, n, string2);
    }

    public String getHandle(String string, String string2, int n, String string3) {
        UserData userData;
        String string4;
        if (string3 != null && (string4 = this.Z(string, string2, n, this.editCat)) != null && (userData = (UserData)this.lockList.get(string4)) != null && userData.uID.equals(string3)) {
            return string4;
        }
        return this.Z(string, string2, n, this.cat);
    }

    @Override
    public String getHandle(String string, int n) {
        return this.Z("", string, n, this.cat);
    }

    @Override
    public String getHandle(String string, String string2, int n) {
        return this.Z(string, string2, n, this.cat);
    }

    @Override
    public String[] getFunctions(String string) {
        return this.getFunctionsBySourceName("", string);
    }

    public String[] getFunctionsBySourceName(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        JetUResourceEntity jetUResourceEntity = this.cat.getDatabase(string).getResourceByName(string2);
        if (jetUResourceEntity != null) {
            int n = jetUResourceEntity.getColDesc().getSqlType();
            return this.getFunctions(n);
        }
        return null;
    }

    @Override
    public String[] getFunctions(String string, String string2) {
        return this.getFunctions("", string, string2);
    }

    public String[] getFunctions(String string, String string2, String string3) {
        JetUUniverse.setUniverse(this.editCat);
        JetUResourceEntity jetUResourceEntity = this.editCat.getDatabase(string).getResourceByName(string2);
        if (jetUResourceEntity != null) {
            int n = jetUResourceEntity.getColDesc().getSqlType();
            return this.getFunctions(n);
        }
        return null;
    }

    @Override
    public String[] getFunctions(int n) {
        Vector<String> vector = new Vector<String>();
        if (SumaryFuncs.justify("COUNT", n)) {
            vector.add("Count");
            vector.add("DistinctCount");
        }
        if (SumaryFuncs.justify("SUM", n)) {
            vector.add("Sum");
        }
        if (SumaryFuncs.justify("AVERAGE", n)) {
            vector.add("Average");
        }
        if (SumaryFuncs.justify("MAXIMUM", n)) {
            vector.add("Maximum");
        }
        if (SumaryFuncs.justify("MINIMUM", n)) {
            vector.add("Minimum");
        }
        if (SumaryFuncs.justify("POPULATIONSTDDEV", n)) {
            vector.add("PopulationStdDev");
        }
        if (SumaryFuncs.justify("POPULATIONVARIANCE", n)) {
            vector.add("PopulationVariance");
        }
        if (SumaryFuncs.justify("STDDEV", n)) {
            vector.add("StdDev");
        }
        if (SumaryFuncs.justify("VARIANCE", n)) {
            vector.add("Variance");
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    JetObject getObj(String string, String string2) {
        UserData userData = (UserData)this.lockList.get(string);
        return userData == null || !userData.uID.equals(string2) ? this.getObj(string) : userData.obj;
    }

    String[] getConditionMappingnames(JetUQuery jetUQuery, String string) {
        String string2;
        int n;
        String[] stringArray;
        String[][] stringArray2 = this.getAndConditions(jetUQuery);
        String string3 = jetUQuery.getDatabase().getResourceName();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n2 = stringArray2.length;
        while (--n2 >= 0) {
            stringArray = stringArray2[n2];
            for (n = 0; n < stringArray.length; ++n) {
                int n3;
                String string4 = stringArray[n];
                int n4 = n3 = string4.indexOf(64) == -1 ? string4.indexOf(58) : string4.indexOf(64);
                if (n3 != -1) {
                    while (n3 != -1) {
                        string2 = this.getMappingName(string4);
                        string4 = string4.substring(n3 + string2.length() + 1);
                        if (this.isNameExist(string3, string2, string)) {
                            hashtable.put(string2, string2);
                        }
                        n3 = string4.indexOf(64) == -1 ? string4.indexOf(58) : string4.indexOf(64);
                    }
                    continue;
                }
                string2 = this.getMappingName(stringArray[n]);
                if (string2 == null || !this.isNameExist(string3, string2, string)) continue;
                hashtable.put(string2, string2);
            }
        }
        stringArray2 = this.getQBEInfo(jetUQuery);
        n2 = stringArray2.length;
        while (--n2 >= 0) {
            stringArray = stringArray2[n2];
            n = stringArray.length;
            while (--n >= 2) {
                if (stringArray[n] == null || (string2 = this.getMappingName(stringArray[n])) == null || !this.isNameExist(string3, string2, string)) continue;
                hashtable.put(string2, string2);
            }
        }
        String[] stringArray3 = new String[hashtable.size()];
        n2 = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            stringArray3[n2++] = (String)enumeration.nextElement();
        }
        return stringArray3;
    }

    @Override
    public int getSQLType(String string, String string2) {
        return this.getSQLType("", string, string2, "");
    }

    public int getSQLType(String string, String string2, String string3, String string4) {
        Vector vector = (Vector)this.userList.get(string4);
        if (vector != null) {
            UserData userData;
            String string5 = this.getHandle(string, string3, 4, string4);
            if (string5 == null) {
                string5 = this.getHandle(string, string3, 9, string4);
            }
            if ((userData = (UserData)this.lockList.get(string5)) != null && userData.uID.equals(string4)) {
                return ((JetUFormula)userData.obj).sqlType.get();
            }
        }
        return super.getSQLType(string, string2, string3);
    }

    @Override
    public String[] getUnionableQueries(String string, String string2) {
        return this.getUnionableQueries("", string, string2);
    }

    public String[] getUnionableQueries(String string, String string2, String string3) {
        this.clearMsg();
        JetUQuery jetUQuery = this.getQuery(string, string2, string3);
        if (jetUQuery != null) {
            JetUQuery jetUQuery2;
            RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
            IntKeyHashtable intKeyHashtable = UnionVerifier.getQueryInfo(rptPsqlQuery);
            Enumeration enumeration = this.lockList.elements();
            Vector<JetObject> vector = new Vector<JetObject>();
            Vector vector2 = this.cat.getDatabase(string).getQueries();
            int n = vector2.size();
            while (enumeration.hasMoreElements()) {
                UserData userData = (UserData)enumeration.nextElement();
                if (!(userData.obj instanceof JetUQuery) || !userData.uID.equals(string3)) continue;
                vector.add(userData.obj);
            }
            int n2 = n;
            while (--n2 >= 0) {
                jetUQuery2 = (JetUQuery)vector2.elementAt(n2);
                if (!this.add(vector, jetUQuery2) && UnionVerifier.verify(intKeyHashtable, string2, jetUQuery2)) continue;
                vector2.removeElementAt(n2);
            }
            n2 = vector.size();
            while (--n2 >= 0) {
                jetUQuery2 = (JetUQuery)vector.elementAt(n2);
                if (!UnionVerifier.verify(intKeyHashtable, string2, jetUQuery2)) continue;
                vector2.addElement(jetUQuery2);
            }
            String[] stringArray = new String[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                stringArray[i] = ((JetUQuery)vector2.elementAt(i)).getResourceName();
            }
            return stringArray;
        }
        this.setError("getUnionableQueries(\"" + string2 + ", " + string3 + "\"):void query name.");
        return new String[0];
    }

    private boolean add(Vector vector, JetUQuery jetUQuery) {
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            if (!((JetUQuery)vector.elementAt(i)).getResourceName().equalsIgnoreCase(jetUQuery.getResourceName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public UnionInfos getUnionInfos(String string, String string2) {
        return this.getUnionInfos("", string, string2);
    }

    public UnionInfos getUnionInfos(String string, String string2, String string3) {
        this.clearMsg();
        JetUQuery jetUQuery = this.getQuery(string, string2, string3);
        if (jetUQuery == null) {
            this.setError("getUnionInfos(" + string2 + "): invalid query name");
        }
        return this.getUnionInfos(jetUQuery);
    }

    @Override
    public String[] getUnionQueries(String string, String string2) {
        return this.getUnionQueries("", string, string2);
    }

    public String[] getUnionQueries(String string, String string2, String string3) {
        this.clearMsg();
        JetUQuery jetUQuery = this.getQuery(string, string2, string3);
        if (jetUQuery == null) {
            this.setError("getUnionQueries(" + string2 + "," + string3 + "): invalid query name");
        }
        return this.getUnionQueries(jetUQuery);
    }

    public String[] getUnionQueries(String string, boolean bl, String string2) {
        return this.getUnionQueries("", string, bl, string2);
    }

    public String[] getUnionQueries(String string, String string2, boolean bl, String string3) {
        this.clearMsg();
        JetUQuery jetUQuery = this.getQuery(string, string2, string3);
        if (jetUQuery == null) {
            this.setError("getUnionQueries(" + string2 + "," + bl + "," + string3 + "): invalid query name");
        }
        return this.getUnionQueries(jetUQuery, bl);
    }

    @Override
    public String[] getSubQueries(String string, String string2) {
        return this.getSubQueries("", string, string2);
    }

    public String[] getSubQueries(String string, String string2, String string3) {
        JetUUniverse.setUniverse(this.cat);
        JetUQuery jetUQuery = this.getQuery(string, string2, string3);
        if (jetUQuery == null) {
            this.setError("getSubQueries(" + string2 + "," + string3 + "): invalid query name");
        }
        return this.getSubQueries(jetUQuery, string3);
    }

    String[] getSubQueries(JetUQuery jetUQuery, String string) {
        Vector vector = new Vector();
        if (jetUQuery != null) {
            int n;
            String[] stringArray;
            String[] stringArray2;
            String[] stringArray3 = this.getQueries(string);
            RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
            Vector vector2 = null;
            if (vector2 != null && vector2.size() != 0) {
                stringArray2 = (String[])vector2.elementAt(0);
                stringArray = null;
                for (n = 0; n < stringArray2.size(); ++n) {
                    stringArray = (String[])stringArray2.elementAt(n);
                    this.parseSubquery(vector, stringArray3, stringArray[0]);
                    this.parseSubquery(vector, stringArray3, stringArray[2]);
                }
            } else {
                vector2 = rptPsqlQuery.getAndExpressionVector();
                if (vector2 != null && vector2.size() != 0) {
                    int n2 = 0;
                    int n3 = vector2.size() / 4;
                    for (int i = 0; i < n3; ++i) {
                        int n4 = ++n2;
                        ++n2;
                        String string2 = (String)vector2.elementAt(n4);
                        int n5 = ++n2;
                        ++n2;
                        String string3 = (String)vector2.elementAt(n5);
                        this.parseSubquery(vector, stringArray3, string2);
                        this.parseSubquery(vector, stringArray3, string3);
                    }
                }
            }
            stringArray2 = new String[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                stringArray = (String[])vector.elementAt(n);
                stringArray2[n] = stringArray.substring(1);
            }
            return stringArray2;
        }
        this.setError("getSubQueries( ): void qryName");
        return new String[0];
    }

    public String rename(String string, String string2, int n, String string3) {
        return this.rename("", string, string2, n, string3);
    }

    public String rename(String string, String string2, String string3, int n, String string4) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        JetUDBTreeNode jetUDBTreeNode = null;
        Object var8_7 = null;
        if (!this.isNameExist(string, string3, this.editCat)) {
            switch (n) {
                case 5: {
                    jetUDBTreeNode = this.getQuery(string, string2, string4);
                }
            }
            if (jetUDBTreeNode != null) {
                jetUDBTreeNode.setResourceName(string3);
                return string3;
            }
            this.setError("rename(\"" + string2 + "\",\"" + string3 + "\",\"" + n + "\"): void resource name " + "[" + string2 + "]");
        } else {
            this.setError("rename(\"" + string2 + "\",\"" + string3 + "\",\"" + n + "\"):  resource name is existed");
        }
        return null;
    }

    @Override
    public String getSQLString(String string, String string2) {
        return this.getSQLString("", string, string2);
    }

    public String getSQLString(String string, String string2, String string3) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        JetUQueriable jetUQueriable = this.getQuery(string, string2, string3);
        if (jetUQueriable == null) {
            jetUQueriable = this.editCat.getQueriableByResourceName(string, string2);
        }
        if (jetUQueriable == null) {
            this.setError("getSQLString(" + string2 + "," + string3 + "):void resource name");
            return null;
        }
        return this.getSQLString(jetUQueriable);
    }

    @Override
    public String insertCompCol(String string, String string2, String string3, String string4) {
        return this.insertCompCol("", string, string2, string3, string4);
    }

    public String insertCompCol(String string, String string2, String string3, String string4, String string5) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        JetUQuery jetUQuery = this.getQuery(string, string2, string5);
        if (jetUQuery == null) {
            this.setError("insert(" + string2 + "," + string3 + "," + string4 + "," + string5 + "):invalid query name.");
        } else {
            String[] stringArray = this.getCompColumns(jetUQuery);
            if (this.exist(stringArray, string3)) {
                this.setError("insertCompCol(" + string2 + "," + string3 + "," + string4 + "," + string5 + "):" + string3 + " is existed.");
            } else {
                this.insertCompCol(jetUQuery, string3, string4);
                JetUResourceEntity jetUResourceEntity = jetUQuery.getFieldByResourceName(string3);
                if (jetUResourceEntity != null) {
                    this.handles.put(jetUResourceEntity.getQualifyName(), jetUResourceEntity);
                    this.lock(jetUResourceEntity.getQualifyName(), string5, jetUResourceEntity);
                    this.handles.put(jetUQuery.getQualifyName(), jetUQuery);
                    this.lock(jetUQuery.getQualifyName(), string5, jetUQuery);
                    return jetUResourceEntity.getQualifyName();
                }
            }
        }
        return null;
    }

    @Override
    public boolean deleteCompCol(String string, String string2, String string3) {
        return this.deleteCompCol("", string, string2, string3);
    }

    public boolean deleteCompCol(String string, String string2, String string3, String string4) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        JetUQuery jetUQuery = this.getQuery(string, string2, string4);
        if (jetUQuery == null) {
            this.setError("deleteCompCol(" + string2 + "," + string3 + "," + string4 + "):invalid query name.");
        } else {
            JetUResourceEntity jetUResourceEntity = jetUQuery.getFieldByResourceName(string3);
            if (jetUResourceEntity != null) {
                String string5 = jetUResourceEntity.getQualifyName();
                this.deleteCompCol(jetUQuery, string3);
                this.handles.remove(string5);
                return true;
            }
            this.setError("deleteCompCol(" + string2 + "," + string3 + "," + string4 + "):invalid column name.");
        }
        return false;
    }

    @Override
    public boolean setCompCol(String string, String string2, String string3, String string4) {
        return this.setCompCol("", string, string2, string3, string4);
    }

    public boolean setCompCol(String string, String string2, String string3, String string4, String string5) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUQuery jetUQuery = this.getQuery(string, string2, string5);
        if (jetUQuery == null) {
            this.setError("setCompCol(" + string2 + "," + string3 + ", " + string4 + "," + string5 + "):invalid query name.");
        } else {
            JetUResourceEntity jetUResourceEntity = jetUQuery.getFieldByResourceName(string3);
            if (jetUResourceEntity != null) {
                return this.setCompCol(jetUQuery, string3, string4);
            }
            this.setError("setCompCol(" + string2 + "," + string3 + ", " + string4 + "," + string5 + "):invalid column name.");
        }
        return false;
    }

    @Override
    public String insertSql(String string, String string2, String string3, String string4) {
        Object object;
        this.clearMsg();
        JetUUniverse.setUniverse(this.editCat);
        try {
            object = new FileReader(string3);
            ((InputStreamReader)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.setError("insert(\"" + string2 + "\",\"" + string3 + "\"):File " + string3 + " cannot be found. Please verify the path and name");
            return null;
        }
        catch (IOException iOException) {
            this.setError("insert(\"" + string2 + "\",\"" + string3 + "\"):File " + string3 + " cannot be load.");
            return null;
        }
        try {
            object = this.getConnection(string, string4);
            if (object == null) {
                this.setError("insert(\"" + string2 + "\",\"" + string3 + "\"):there is not connection in current universe. Please insert a connection first.");
                return null;
            }
            FileQuery fileQuery = FileQuery.createFileQuery(string3, this.editCat, string, null, null, null);
            JetUFileQuery jetUFileQuery = ((JetUConnection)object).addFileQuery(string2, fileQuery);
            if (jetUFileQuery != null) {
                String string5 = jetUFileQuery.getQualifyName();
                this.lock(string5, string4, jetUFileQuery);
                return string5;
            }
            this.setError("insert(\"" + string2 + "\",\"" + string3 + "\"):can not insert this SQL file into connection.");
        }
        catch (BadFileQueryException badFileQueryException) {
            String string6 = "insert(\"" + string2 + "\",\"" + string3 + "\"):" + string3 + " is not a valid  SQL file.\n";
            string6 = string6 + badFileQueryException.getMessage();
            this.setError(string6);
            return null;
        }
        return null;
    }

    class ReportFilter
    implements FilenameFilter {
        private final String SEDU = ".cls";
        final /* synthetic */ MultiUserCatalogAPI this$0;

        @Override
        public boolean accept(File file, String string) {
            return string.toLowerCase().endsWith(".cls");
        }
    }
}

