/*
 * Decompiled with CFR 0.152.
 */
package jet.api;

import guitools.GuiUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import jet.Env;
import jet.JResource;
import jet.api.CTAggFieldInfo;
import jet.api.CTRowColFieldInfo;
import jet.api.ChartHandler;
import jet.api.ChartLabelInfo;
import jet.api.ChartLegendInfo;
import jet.api.CrosstabHandler;
import jet.api.Designer;
import jet.api.DesignerUserInfo;
import jet.api.MultiUserCatalogAPI;
import jet.api.UserData;
import jet.connect.DbColDesc;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.jetc.ReadFailureException;
import jet.report.JRObjectTemplate;
import jet.report.JetRptBarcode;
import jet.report.JetRptCTAggField;
import jet.report.JetRptCTCrossTab;
import jet.report.JetRptCTDBField;
import jet.report.JetRptChartPlatform;
import jet.report.JetRptDBField;
import jet.report.JetRptDataSource;
import jet.report.JetRptDetailPanel;
import jet.report.JetRptGroupFooterPanel;
import jet.report.JetRptGroupHeaderPanel;
import jet.report.JetRptGroupPanel;
import jet.report.JetRptObject;
import jet.report.JetRptPageFooterPanel;
import jet.report.JetRptPageHeaderPanel;
import jet.report.JetRptPagePanel;
import jet.report.JetRptParameterField;
import jet.report.JetRptReportFooterPanel;
import jet.report.JetRptReportHeaderPanel;
import jet.report.JetRptReportPanel;
import jet.report.JetRptSection;
import jet.report.JetRptTextObject;
import jet.reportset.DataSet;
import jet.rptservice.util.ReportTools;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUFormula;
import jet.universe.JetUQueriable;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;
import jet.universe.JetUUniverse;
import jet.universe.exception.UniverseFileException;

public class MultiUserDesigner
extends Designer {
    MultiUserDesigner(MultiUserCatalogAPI multiUserCatalogAPI) {
        super(multiUserCatalogAPI);
        this.iType = 3;
    }

    public MultiUserDesigner(String string, String string2) throws ReadFailureException, UniverseFileException {
        this(string, string2, (DesignerUserInfo)null);
    }

    public MultiUserDesigner(String string, String string2, DesignerUserInfo designerUserInfo) throws ReadFailureException, UniverseFileException {
        File file;
        this.iType = 3;
        Env.checkEnv(null);
        if (designerUserInfo != null) {
            if (designerUserInfo.key == null && designerUserInfo.uid != null && (designerUserInfo.uid.equals("Pasdf56q890weB2s5fC43fDE") || designerUserInfo.uid.equals("89Sfdswer470eGs190dfew324C"))) {
                this.callerid = designerUserInfo.uid;
            } else {
                this.uid = designerUserInfo.uid;
                this.key = designerUserInfo.key;
            }
        }
        if (this.uid != null && this.key != null || this.callerid != null) {
            this.checkUser();
        }
        if (this.getReporthome() == null || this.getReporthome().length() == 0) {
            this.setWarning("Please set valid report home.");
        }
        if ((file = new File(string, string2)).exists()) {
            this.catapi = new MultiUserCatalogAPI(string, string2);
        } else {
            file = new File(string, string2 + ".cat");
            if (file.exists()) {
                this.catapi = new MultiUserCatalogAPI(string, string2 + ".cat");
            } else if (!string2.endsWith(".cat") && !string2.endsWith(".cat.xml")) {
                this.catapi = new MultiUserCatalogAPI(JetUUniverse.BuildDefaultUniverse(string + File.separatorChar + string2 + ".cat"), JetUUniverse.BuildDefaultUniverse(string + File.separatorChar + string2 + ".cat"), string, string2);
            } else {
                JetUUniverse jetUUniverse = JetUUniverse.BuildDefaultUniverse(string + File.separatorChar + string2);
                JetUUniverse jetUUniverse2 = JetUUniverse.BuildDefaultUniverse(string + File.separatorChar + string2);
                String string3 = ".cat";
                if (string2.endsWith(".cat")) {
                    string2 = string2.substring(0, string2.indexOf(".cat"));
                } else if (string2.endsWith(".cat.xml")) {
                    string2 = string2.substring(0, string2.indexOf(".cat.xml"));
                    string3 = ".cat.xml";
                }
                this.catapi = new MultiUserCatalogAPI(jetUUniverse, jetUUniverse2, string, string2, string3);
            }
        }
    }

    public MultiUserCatalogAPI getMultiUserCatalogAPI() {
        this.checkUser();
        if (this.isOK) {
            return (MultiUserCatalogAPI)this.catapi;
        }
        this.setError(this.errorinfo);
        return null;
    }

    @Override
    public String create(String string, String string2, String string3) {
        return this.create(string, this.catapi.getDefaultDataSourceName(), string2, string3);
    }

    public String create(String string, String string2, String string3, String string4) {
        this.checkUser();
        if (this.isOK) {
            String string5 = this.getReportHandle(string);
            File file = new File(this.getReportFileName(string5));
            this.clearMsg();
            if (this.handles.get(string5) != null || file.exists()) {
                this.setError("create(\"" + string + "\",\"" + string3 + "\"): Report " + string + " has existed in current catalog.");
            } else if ((string5 = this.create(file, string5, string2, string3, string4)) != null) {
                return string5;
            }
        } else {
            this.setError(this.errorinfo);
        }
        return null;
    }

    String create(File file, String string, String string2, String string3, String string4) {
        String[] stringArray = string4 == null ? this.getQueries(string2) : ((MultiUserCatalogAPI)this.catapi).getQueries(string2, string4);
        return this.create(file, string, string3, stringArray, string2, ((MultiUserCatalogAPI)this.catapi).editCat);
    }

    public String insert(String string, String string2, int n, String string3, String string4) {
        this.clearMsg();
        if (n == 0 || n == 1) {
            this.setError("insert(\"" + string2 + "\"," + n + ",\"" + string3 + "\"): The " + CLASSNAME[n] + " can not insert any parent.");
            return null;
        }
        JetObject jetObject = (JetObject)this.handles.get(string2);
        if (jetObject != null) {
            if (jetObject instanceof JetContainable) {
                Object object;
                Object object2;
                JetRptObject jetRptObject = null;
                switch (n) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        this.setError("insert(\"" + string + "\"," + string2 + "\"," + n + ",\"" + string3 + "\",\"" + string4 + "\"): Insert " + CLASSNAME[n] + " unnecessary mapping name.");
                        break;
                    }
                    case 2: {
                        Object object3;
                        object2 = null;
                        if (jetObject instanceof JetRptPagePanel || jetObject instanceof JetRptGroupPanel) {
                            jetRptObject = new JetRptGroupPanel();
                            ((JetRptGroupPanel)jetRptObject).setEditable();
                            ((JetRptGroupPanel)jetRptObject).groupBy.set(string4);
                        } else {
                            this.setError("insert(\"" + string + "\"," + string2 + "\"," + n + ",\"" + string3 + "\"): Cannont insert group into " + string2 + ", because of the " + string2 + " is not a page or group instance.");
                        }
                        object = ((JetContainable)((Object)jetObject)).getChildren();
                        for (int i = 0; i < ((Vector)object).size(); ++i) {
                            object2 = (JetObject)((Vector)object).elementAt(i);
                            if (!(object2 instanceof JetRptDetailPanel) && !(object2 instanceof JetRptGroupPanel)) continue;
                            object3 = ((JetObject)object2).getQualifyName();
                            this.handles.remove(object3);
                            this.destroyHandles((JetContainable)object2, (String)object3);
                            ((JetContainable)((Object)jetObject)).remove((JetObject)object2);
                            ((JetContainable)((Object)jetRptObject)).add((JetObject)object2);
                        }
                        JetRptGroupHeaderPanel jetRptGroupHeaderPanel = new JetRptGroupHeaderPanel();
                        jetRptGroupHeaderPanel.setInstName("GroupHeader");
                        ((JetContainable)((Object)jetRptObject)).add(jetRptGroupHeaderPanel);
                        object3 = new JetRptGroupFooterPanel();
                        ((JetObject)object3).setInstName("GroupFooter");
                        ((JetContainable)((Object)jetRptObject)).add((JetObject)object3);
                        break;
                    }
                    case 11: {
                        if (jetObject instanceof JetRptSection || jetObject instanceof JetRptTextObject) {
                            if (this.checkMappingName(this.getDBFields(string2, string), string4)) {
                                jetRptObject = new JetRptDBField();
                                ((JetRptDBField)jetRptObject).setEditable();
                                ((JetRptDBField)jetRptObject).columnName.set(string4);
                                ((JetRptDBField)jetRptObject).format.set(this.getFormat(jetObject, string4));
                                break;
                            }
                            this.setError("insert(\"" + string + "\"," + string2 + "\"," + n + ",\"" + string3 + "\",\"" + string4 + "\"): Mapping name " + string4 + " of DBField cannot be used in current query.");
                            break;
                        }
                        this.setError("insert(\"" + string + "\"," + string2 + "\"," + n + ",\"" + string3 + "\",\"" + string4 + "\"): Cannont insert database field into " + string2 + ", because of the " + string2 + " is not a section or text object.");
                        break;
                    }
                    case 60: {
                        if (jetObject instanceof JetRptSection || jetObject instanceof JetRptTextObject) {
                            jetRptObject = new JetRptBarcode();
                            ((JetRptDBField)jetRptObject).setEditable();
                            if (!this.checkMappingName(this.getDBFields(string2), string4)) break;
                            ((JetRptDBField)jetRptObject).columnName.set(string4);
                            break;
                        }
                        this.setError("insert(\"" + string + "\"," + string2 + "\"," + n + ",\"" + string3 + "\",\"" + string4 + "\"): Cannont insert barcode field into " + string2 + ", because of the " + string2 + " is not a section or text object.");
                        break;
                    }
                    case 13: {
                        if (jetObject instanceof JetRptSection || jetObject instanceof JetRptTextObject) {
                            if (this.checkMappingName(this.getFormulae(string2, string), string4)) {
                                jetRptObject = new JetRptDBField();
                                ((JetRptDBField)jetRptObject).setEditable();
                                ((JetRptDBField)jetRptObject).columnName.set(string4);
                                ((JetRptDBField)jetRptObject).format.set(this.getFormat(this.CHARTTYPE(jetObject), jetObject, string4, 9, string));
                                break;
                            }
                            this.setError("insert(\"" + string + "\"," + string2 + "\"," + n + ",\"" + string3 + "\",\"" + string4 + "\"): Mapping name " + string4 + " of formula cannot be used in current query.");
                            break;
                        }
                        this.setError("insert(\"" + string + "\"," + string2 + "\"," + n + ",\"" + string3 + "\",\"" + string4 + "\"): Cannont insert formula into " + string2 + ", because of the " + string2 + " is not a section or text object.");
                        break;
                    }
                    case 14: {
                        if (jetObject instanceof JetRptSection || jetObject instanceof JetRptTextObject) {
                            if (this.checkMappingName(this.getSummaries(string2, string), string4)) {
                                if (jetObject instanceof JetRptPageHeaderPanel || jetObject instanceof JetRptPageFooterPanel) {
                                    this.setError("insert(\"" + string + "\"," + string2 + "\"," + n + ",\"" + string3 + "\",\"" + string4 + "\"): " + JResource.getMessage("RPT_CANNOT_INS_AGG") + ' ' + string2 + '.');
                                    break;
                                }
                                if (jetObject instanceof JetRptDetailPanel || this.checkGroupby1(jetObject, string4, string)) {
                                    jetRptObject = new JetRptDBField();
                                    ((JetRptDBField)jetRptObject).setEditable();
                                    ((JetRptDBField)jetRptObject).columnName.set(string4);
                                    ((JetRptDBField)jetRptObject).format.set(this.getFormat(this.CHARTTYPE(jetObject), jetObject, string4, 10, string));
                                    break;
                                }
                                this.setError("insert(\"" + string + "\"," + string2 + "\"," + n + ",\"" + string3 + "\",\"" + string4 + "\"): " + JResource.getMessage("RPT_CANNOT_INS_AGG") + ' ' + string2 + '.');
                                break;
                            }
                            this.setError("insert(\"" + string + "\"," + string2 + "\"," + n + ",\"" + string3 + "\",\"" + string4 + "\"): Mapping name " + string4 + " of summary cannot be used in current query.");
                            break;
                        }
                        this.setError("insert(\"" + string + "\"," + string2 + "\"," + n + ",\"" + string3 + "\",\"" + string4 + "\"): Cannont insert summary into " + string2 + ", because of the " + string2 + " is not a section or text object.");
                        break;
                    }
                    case 15: {
                        if (jetObject instanceof JetRptSection || jetObject instanceof JetRptTextObject) {
                            if (this.checkMappingName(this.getParameter(string), string4)) {
                                jetRptObject = new JetRptParameterField();
                                ((JetRptParameterField)jetRptObject).setEditable();
                                ((JetRptParameterField)jetRptObject).param.set(string4);
                                ((JetRptParameterField)jetRptObject).format.set(this.getFormat(this.CHARTTYPE(jetObject), jetObject, string4, 11, string));
                                break;
                            }
                            this.setError("insert(\"" + string + "\"," + string2 + "\"," + n + ",\"" + string3 + "\",\"" + string4 + "\"): Illegal mapping name of parameter.");
                            break;
                        }
                        this.setError("insert(\"" + string + "\"," + string2 + "\"," + n + ",\"" + string3 + "\",\"" + string4 + "\"): Cannont insert parameter into " + string2 + ", because of the " + string2 + " is not a section or text object.");
                        break;
                    }
                    case 12: {
                        if (jetObject instanceof JetRptSection || jetObject instanceof JetRptTextObject) {
                            if (this.checkMappingName(this.getDBFields(string2), string4)) {
                                jetRptObject = new JetRptDBField();
                                ((JetRptDBField)jetRptObject).setEditable();
                                ((JetRptDBField)jetRptObject).columnName.set(string4);
                                ((JetRptDBField)jetRptObject).format.set(this.getFormat(jetObject, string4));
                                break;
                            }
                            this.setError("insert(\"" + string + "\"," + string2 + "\"," + n + ",\"" + string3 + "\",\"" + string4 + "\"): Illegal mapping name of parameter.");
                            break;
                        }
                        this.setError("insert(\"" + string + "\"," + string2 + "\"," + n + ",\"" + string3 + "\",\"" + string4 + "\"): Cannont insert parameter into " + string2 + ", because of the " + string2 + " is not a section or text object.");
                        break;
                    }
                    case 10: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: {
                        this.setError("insert(\"" + string + "\"," + string2 + "\"," + n + ",\"" + string3 + "\",\"" + string4 + "\"): Insert " + CLASSNAME[n] + " unnecessary mapping name.");
                        break;
                    }
                    default: {
                        this.setError("insert(\"" + string + "\"," + string2 + "\"," + n + ",\"" + string3 + "\",\"" + string4 + "\"): Illegal class type.");
                    }
                }
                if (jetRptObject != null) {
                    if (this.checkName((JetContainable)((Object)jetObject), string3)) {
                        this.setWarning("insert(\"" + string + "\"," + string2 + "\"," + n + ",\"" + string3 + "\",\"" + string4 + "\"): The " + string3 + " has existed in " + string2 + '.');
                        string3 = null;
                    }
                    if (string3 != null && string3.length() > 0) {
                        jetRptObject.setInstName(string3);
                    }
                    if (jetObject instanceof JetRptSection) {
                        ((JetRptSection)jetObject).add(jetRptObject, 0);
                    } else {
                        ((JetContainable)((Object)jetObject)).add(jetRptObject);
                    }
                    object2 = jetRptObject.getQualifyName();
                    this.handles.put(object2, jetRptObject);
                    if (jetRptObject instanceof JetRptGroupPanel) {
                        this.createHandles((JetContainable)((Object)jetRptObject), (String)object2);
                    }
                    if (jetRptObject instanceof JRObjectTemplate) {
                        object = (JRObjectTemplate)this.handles.get(object2);
                        ((JetRptObject)object).afterInit();
                    }
                    return object2;
                }
            } else {
                this.setError("insert(\"" + string + "\"," + string2 + "\"," + n + ",\"" + string3 + "\",\"" + string4 + "\"): The " + string2 + " is not a container.");
            }
        } else {
            this.setError("insert(\"" + string + "\"," + string2 + "\"," + n + ",\"" + string3 + "\",\"" + string4 + "\"): Illegal handle " + string2 + '.');
        }
        return null;
    }

    public String insert(String string, String string2, String string3, int n, String string4, String string5, String string6, ChartLegendInfo chartLegendInfo, ChartLabelInfo chartLabelInfo, String string7) {
        return this.BuildDefaultUniverse(string, string2, string3, n, string4, string5, string6, chartLegendInfo, chartLabelInfo, string7, true);
    }

    private String BuildDefaultUniverse(String string, String string2, String string3, int n, String string4, String string5, String string6, ChartLegendInfo chartLegendInfo, ChartLabelInfo chartLabelInfo, String string7, boolean bl) {
        ArrayList arrayList = MultiUserDesigner.mapChartType(n);
        if (arrayList == null || arrayList.size() == 0) {
            String string8 = CHARTTYPE[0];
            for (int i = 1; i < CHARTTYPE.length; ++i) {
                string8 = string8 + ", " + CHARTTYPE[i];
            }
            string8 = string8 + '.';
            this.setError("insert chart: Illegal chart type " + n + ". The type must be one of the " + string8 + " that have been defined in the Designer.");
            return null;
        }
        int n2 = -1;
        int n3 = -1;
        boolean bl2 = false;
        if (arrayList.size() == 1) {
            n2 = (Integer)arrayList.get(0);
        } else {
            n2 = (Integer)arrayList.get(0);
            n3 = (Integer)arrayList.get(1);
            bl2 = true;
        }
        String[] stringArray = new String[]{string6};
        return this.C(string, string2, string3, bl2, n2, n3, string4, string5, stringArray, chartLegendInfo, chartLabelInfo, string7, bl);
    }

    private String C(String string, String string2, String string3, boolean bl, int n, int n2, String string4, String string5, String[] stringArray, ChartLegendInfo chartLegendInfo, ChartLabelInfo chartLabelInfo, String string6, boolean bl2) {
        JetObject jetObject;
        this.clearMsg();
        if (string5 != null && string5.length() == 0) {
            string5 = null;
        }
        if ((jetObject = (JetObject)this.handles.get(string)) != null) {
            if (jetObject instanceof JetRptReportHeaderPanel || jetObject instanceof JetRptReportFooterPanel || jetObject instanceof JetRptGroupHeaderPanel || jetObject instanceof JetRptGroupFooterPanel) {
                boolean bl3 = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (this.checkMappingName(this.getSummaries(string, string6), stringArray[i]) || this.checkMappingName(this.getFormulae(string, string6), stringArray[i])) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) {
                    new Exception("Illegal").printStackTrace();
                    this.setError("insert chart: Illegal aggregate function mapping name " + stringArray + '.');
                } else if (string4 == null || string4.length() == 0 || string4.equalsIgnoreCase("report")) {
                    this.setError("insert chart: The parameter group1 can not be null, blank or report.");
                } else if (this.checkMappingName(this.getDBFields(string, string6), string4) || this.checkMappingName(this.getFormulae(string, string6), string4)) {
                    int n3;
                    boolean bl4;
                    ChartHandler chartHandler = null;
                    if (string5 != null && string5.equalsIgnoreCase("report")) {
                        this.setError("insert chart: The parameter group2 can not be report.");
                    } else if (string5 == null) {
                        if (this.checkGroupby(jetObject, string4, string5)) {
                            bl4 = false;
                            for (n3 = 0; n3 < stringArray.length; ++n3) {
                                if (this.checkGroupby(string, string4, stringArray[n3], string6)) continue;
                                bl4 = true;
                                break;
                            }
                            if (!bl4) {
                                chartHandler = new ChartHandler();
                            } else {
                                this.setError("insert chart: " + stringArray + " is not a aggregate function grouped by " + string4 + '.');
                            }
                        } else {
                            this.setError("insert chart: The " + string4 + " is not a group of " + string + '.');
                        }
                    } else if (this.checkMappingName(this.getDBFields(string, string6), string5) || this.checkMappingName(this.getFormulae(string, string6), string5)) {
                        if (this.checkGroupby(jetObject, string4, string5)) {
                            bl4 = false;
                            for (n3 = 0; n3 < stringArray.length; ++n3) {
                                if (this.checkGroupby(string, string5, stringArray[n3], string6)) continue;
                                bl4 = true;
                                break;
                            }
                            if (!bl4) {
                                chartHandler = new ChartHandler();
                            } else {
                                this.setError("insert chart: The " + stringArray + " is not a aggregate function grouped by " + string5 + '.');
                            }
                        } else {
                            this.setError("insert chart: The " + string4 + " is not a group of " + string + " or " + string5 + " is not a group of " + string4 + '.');
                        }
                    } else {
                        this.setError("insert chart: Illegal mapping name " + string5 + '.');
                    }
                    if (chartHandler != null) {
                        String string7;
                        String string8;
                        if (string5 == null) {
                            string8 = string4;
                            string7 = string5;
                        } else {
                            string8 = string5;
                            string7 = string4;
                        }
                        JetRptChartPlatform jetRptChartPlatform = chartHandler.create(((JetRptReportPanel)JetObject.getRoot(jetObject)).getDataSource(null), string3, bl, n, n2, string8, string7, stringArray, chartLegendInfo, chartLabelInfo, bl2);
                        ((JetContainable)((Object)jetObject)).add(jetRptChartPlatform);
                        if (this.checkName((JetContainable)((Object)jetObject), string2)) {
                            this.setWarning("insert chart: The " + string2 + " has existed in " + string + '.');
                            string2 = null;
                        }
                        if (string2 != null && string2.length() > 0) {
                            jetRptChartPlatform.setInstName(string2);
                        }
                        String string9 = jetRptChartPlatform.getQualifyName();
                        this.handles.put(string9, jetRptChartPlatform);
                        this.createHandles(jetRptChartPlatform, string9);
                        return string9;
                    }
                } else {
                    this.setError("insert chart: Illegal mapping name " + string4 + '.');
                }
            } else {
                this.setError("insert chart: The chart can not be put into the " + string + '.' + " Because  it only can be put in the header/footer of report or group.");
            }
        } else {
            this.setError("insert chart: Illegal handle " + string + '.');
        }
        return null;
    }

    public String insert(String string, String string2, CTRowColFieldInfo[] cTRowColFieldInfoArray, CTRowColFieldInfo[] cTRowColFieldInfoArray2, CTAggFieldInfo[] cTAggFieldInfoArray, String string3) {
        this.clearMsg();
        JetUUniverse.setUniverse(((MultiUserCatalogAPI)this.catapi).editCat);
        if (cTAggFieldInfoArray == null || cTAggFieldInfoArray.length == 0) {
            this.setError("insert(\"" + string + "\",\"" + string2 + "\"," + this.ctChildrenInfo("CTRowColFieldInfo", cTRowColFieldInfoArray) + ',' + this.ctChildrenInfo("CTRowColFieldInfo", cTRowColFieldInfoArray2) + ',' + this.ctChildrenInfo("CTAggFieldInfo", cTAggFieldInfoArray) + "): In a crosstab at least there is a aggregate field.");
            return null;
        }
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof JetContainable) {
                if (jetObject instanceof JetRptReportHeaderPanel || jetObject instanceof JetRptReportFooterPanel || jetObject instanceof JetRptGroupHeaderPanel || jetObject instanceof JetRptGroupFooterPanel) {
                    String[] stringArray = this.getDBFields(string, string3);
                    String[] stringArray2 = this.getFormulae(string, string3);
                    if ((this.checkMappingName(stringArray, cTRowColFieldInfoArray) || this.checkMappingName(stringArray2, cTRowColFieldInfoArray)) && (this.checkMappingName(stringArray, cTRowColFieldInfoArray2) || this.checkMappingName(stringArray2, cTRowColFieldInfoArray2)) && (this.checkMappingName(stringArray, cTAggFieldInfoArray) || this.checkMappingName(stringArray2, cTAggFieldInfoArray))) {
                        if (this.cthandler == null) {
                            this.cthandler = new CrosstabHandler();
                        }
                        JetRptCTCrossTab jetRptCTCrossTab = this.cthandler.create(((JetRptReportPanel)JetObject.getRoot(jetObject)).getDataSource(null), cTRowColFieldInfoArray, cTRowColFieldInfoArray2, cTAggFieldInfoArray);
                        if (string2 != null && string2.length() > 0) {
                            jetRptCTCrossTab.setInstName(string2);
                        }
                        ((JetContainable)((Object)jetObject)).add(jetRptCTCrossTab);
                        Vector vector = jetRptCTCrossTab.getChildren();
                        for (int i = 0; i < vector.size(); ++i) {
                            JetObject jetObject2 = (JetObject)vector.elementAt(i);
                            if (!(jetObject2 instanceof JetRptCTDBField)) continue;
                            if (jetObject2 instanceof JetRptCTAggField) {
                                ((JetRptCTDBField)jetObject2).format.set("#,###.00");
                                continue;
                            }
                            ((JetRptCTDBField)jetObject2).format.set(this.getFormats(jetObject2, ((MultiUserCatalogAPI)this.catapi).cat)[0]);
                        }
                        String string4 = jetRptCTCrossTab.getQualifyName();
                        this.handles.put(string4, jetRptCTCrossTab);
                        this.createHandles(jetRptCTCrossTab, string4);
                        jetRptCTCrossTab.setEditable();
                        return string4;
                    }
                    this.setError("insert(\"" + string + "\",\"" + string2 + "\"," + this.ctChildrenInfo("CTRowColFieldInfo", cTRowColFieldInfoArray) + ',' + this.ctChildrenInfo("CTRowColFieldInfo", cTRowColFieldInfoArray2) + ',' + this.ctChildrenInfo("CTAggFieldInfo", cTAggFieldInfoArray) + "): Mapping name cannot be used in current query or the summary or parameter mapping name are beening used. Because of summary and parameter can not be put in the crosstab.");
                } else {
                    this.setError("insert(\"" + string + "\",\"" + string2 + "\"," + this.ctChildrenInfo("CTRowColFieldInfo", cTRowColFieldInfoArray) + ',' + this.ctChildrenInfo("CTRowColFieldInfo", cTRowColFieldInfoArray2) + ',' + this.ctChildrenInfo("CTAggFieldInfo", cTAggFieldInfoArray) + "): The crosstab can not be put in the " + jetObject.getInstName() + ". Because of it only is put in the header/footer of page or group.");
                }
            } else {
                this.setError("insert(\"" + string + "\",\"" + string2 + "\"," + this.ctChildrenInfo("CTRowColFieldInfo", cTRowColFieldInfoArray) + ',' + this.ctChildrenInfo("CTRowColFieldInfo", cTRowColFieldInfoArray2) + ',' + this.ctChildrenInfo("CTAggFieldInfo", cTAggFieldInfoArray) + "): The " + string + " is not a container.");
            }
        } else {
            this.setError("insert(\"" + string + "\",\"" + string2 + "\"," + this.ctChildrenInfo("CTRowColFieldInfo", cTRowColFieldInfoArray) + ',' + this.ctChildrenInfo("CTRowColFieldInfo", cTRowColFieldInfoArray2) + ',' + this.ctChildrenInfo("CTAggFieldInfo", cTAggFieldInfoArray) + "): Illegal handle " + string + '.');
        }
        return null;
    }

    public String insert(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, CTRowColFieldInfo[] cTRowColFieldInfoArray, CTRowColFieldInfo[] cTRowColFieldInfoArray2, CTAggFieldInfo[] cTAggFieldInfoArray, String string3) {
        this.clearMsg();
        if (cTAggFieldInfoArray == null || cTAggFieldInfoArray.length == 0) {
            this.setError("insert(\"" + string + "\",\"" + string2 + "\"," + this.ctChildrenInfo("CTRowColFieldInfo", cTRowColFieldInfoArray) + ',' + this.ctChildrenInfo("CTRowColFieldInfo", cTRowColFieldInfoArray2) + ',' + this.ctChildrenInfo("CTAggFieldInfo", cTAggFieldInfoArray) + ',' + string3 + "): In a crosstab at least there is a aggregate field.");
            return null;
        }
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof JetContainable) {
                if (jetObject instanceof JetRptReportHeaderPanel || jetObject instanceof JetRptReportFooterPanel || jetObject instanceof JetRptGroupHeaderPanel || jetObject instanceof JetRptGroupFooterPanel) {
                    String[] stringArray = this.getDBFields(string, string3);
                    String[] stringArray2 = this.getFormulae(string, string3);
                    if ((this.checkMappingName(stringArray, cTRowColFieldInfoArray) || this.checkMappingName(stringArray2, cTRowColFieldInfoArray)) && (this.checkMappingName(stringArray, cTRowColFieldInfoArray2) || this.checkMappingName(stringArray2, cTRowColFieldInfoArray2)) && (this.checkMappingName(stringArray, cTAggFieldInfoArray) || this.checkMappingName(stringArray2, cTAggFieldInfoArray))) {
                        if (this.cthandler == null) {
                            this.cthandler = new CrosstabHandler();
                        }
                        JetRptCTCrossTab jetRptCTCrossTab = this.cthandler.create(((JetRptReportPanel)JetObject.getRoot(jetObject)).getDataSource(null), cTRowColFieldInfoArray, cTRowColFieldInfoArray2, cTAggFieldInfoArray);
                        jetRptCTCrossTab.setEditable();
                        jetRptCTCrossTab.boundaryValue.set(n);
                        jetRptCTCrossTab.rowTotalOnTop.set(bl3);
                        jetRptCTCrossTab.columnTotalOnLeft.set(bl2);
                        jetRptCTCrossTab.repeatRowHeader.set(bl4);
                        jetRptCTCrossTab.verticalLayout.set(bl5);
                        jetRptCTCrossTab.avoidOrphanHeader.set(bl);
                        if (string2 != null && string2.length() > 0) {
                            jetRptCTCrossTab.setInstName(string2);
                        }
                        ((JetContainable)((Object)jetObject)).add(jetRptCTCrossTab);
                        Vector vector = jetRptCTCrossTab.getChildren();
                        for (int i = 0; i < vector.size(); ++i) {
                            JetObject jetObject2 = (JetObject)vector.elementAt(i);
                            if (!(jetObject2 instanceof JetRptCTDBField)) continue;
                            if (jetObject2 instanceof JetRptCTAggField) {
                                ((JetRptCTDBField)jetObject2).format.set("#,###.00");
                                continue;
                            }
                            ((JetRptCTDBField)jetObject2).format.set(this.getFormats(jetObject2, ((MultiUserCatalogAPI)this.catapi).editCat)[0]);
                        }
                        String string4 = jetRptCTCrossTab.getQualifyName();
                        this.handles.put(string4, jetRptCTCrossTab);
                        this.createHandles(jetRptCTCrossTab, string4);
                        return string4;
                    }
                    this.setError("insert(\"" + string + "\",\"" + string2 + "\"," + this.ctChildrenInfo("CTRowColFieldInfo", cTRowColFieldInfoArray) + ',' + this.ctChildrenInfo("CTRowColFieldInfo", cTRowColFieldInfoArray2) + ',' + this.ctChildrenInfo("CTAggFieldInfo", cTAggFieldInfoArray) + ',' + string3 + "): Mapping name cannot be used in current query or the summary or parameter mapping name are beening used. Because of summary and parameter can not be put in the crosstab.");
                } else {
                    this.setError("insert(\"" + string + "\",\"" + string2 + "\"," + this.ctChildrenInfo("CTRowColFieldInfo", cTRowColFieldInfoArray) + ',' + this.ctChildrenInfo("CTRowColFieldInfo", cTRowColFieldInfoArray2) + ',' + this.ctChildrenInfo("CTAggFieldInfo", cTAggFieldInfoArray) + ',' + string3 + "): The crosstab can not be put in the " + jetObject.getInstName() + ". Because of it only is put in the header/footer of page or group.");
                }
            } else {
                this.setError("insert(\"" + string + "\",\"" + string2 + "\"," + this.ctChildrenInfo("CTRowColFieldInfo", cTRowColFieldInfoArray) + ',' + this.ctChildrenInfo("CTRowColFieldInfo", cTRowColFieldInfoArray2) + ',' + this.ctChildrenInfo("CTAggFieldInfo", cTAggFieldInfoArray) + ',' + string3 + "): The " + string + " is not a container.");
            }
        } else {
            this.setError("insert(\"" + string + "\",\"" + string2 + "\"," + this.ctChildrenInfo("CTRowColFieldInfo", cTRowColFieldInfoArray) + ',' + this.ctChildrenInfo("CTRowColFieldInfo", cTRowColFieldInfoArray2) + ',' + this.ctChildrenInfo("CTAggFieldInfo", cTAggFieldInfoArray) + ',' + string3 + "): Illegal handle " + string + '.');
        }
        return null;
    }

    public String[] getDBFields(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            String string3 = this.CLASSNAME(jetObject);
            String string4 = this.CHARTTYPE(jetObject);
            if (string2 != null) {
                return ((MultiUserCatalogAPI)this.catapi).getColumnMappingnames(string4, string3, string2);
            }
            return ((MultiUserCatalogAPI)this.catapi).getColumnMappingnames(string4, string3);
        }
        this.setError("getDBFields(\"" + string + ", " + string2 + "\"): Illegal handle " + string + '.');
        return null;
    }

    public String[] getFormulae(String string, String string2) {
        String[] stringArray = this.getFormulae(string);
        String string3 = null;
        String string4 = this.CHARTTYPE(this.getObj(string));
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            string4 = this.CHARTTYPE(jetObject);
        }
        if (string2 != null && ((MultiUserCatalogAPI)this.catapi).hasLock(string2)) {
            int n;
            Object object;
            Vector vector = (Vector)((MultiUserCatalogAPI)this.catapi).userList.get(string2);
            Vector<String> vector2 = new Vector<String>();
            int n2 = vector.size();
            while (--n2 >= 0) {
                string = (String)vector.elementAt(n2);
                if (((MultiUserCatalogAPI)this.catapi).getClassType(((MultiUserCatalogAPI)this.catapi).getObj(string, string2)) == 9 && !this.isInSet(stringArray, string3 = ((JetUDBTreeNode)((UserData)((MultiUserCatalogAPI)this.catapi).lockList.get((Object)string)).obj).getResourceName())) {
                    vector2.addElement(string3);
                }
                if (((MultiUserCatalogAPI)this.catapi).getClassType(((MultiUserCatalogAPI)this.catapi).getObj(string, string2)) != 5) continue;
                string3 = ((JetUDBTreeNode)((UserData)((MultiUserCatalogAPI)this.catapi).lockList.get((Object)string)).obj).getResourceName();
                object = ((MultiUserCatalogAPI)this.catapi).editCat.getDatabase(string4).getAllFomulasValidToQuery(string3);
                if (object == null) continue;
                n = ((Vector)object).size();
                while (--n >= 0) {
                    string3 = ((JetUFormula)((Vector)object).elementAt(n)).getResourceName();
                    if (this.isInSet(stringArray, string3)) continue;
                    vector2.addElement(string3);
                }
            }
            int n3 = vector2.size();
            if (n3 > 0) {
                n2 = stringArray.length;
                object = new String[n2 + n3];
                System.arraycopy(stringArray, 0, object, 0, n2);
                stringArray = object;
                n = n3;
                while (--n >= 0) {
                    stringArray[n2++] = (String)vector2.elementAt(n);
                }
            }
        }
        return stringArray;
    }

    public String[] getSummaries(String string, String string2) {
        String[] stringArray = this.getSummaries(string);
        String string3 = null;
        String string4 = this.CHARTTYPE(this.getObj(string));
        if (string2 != null && ((MultiUserCatalogAPI)this.catapi).hasLock(string2)) {
            int n;
            Object object;
            Vector vector = (Vector)((MultiUserCatalogAPI)this.catapi).userList.get(string2);
            Vector<String> vector2 = new Vector<String>();
            int n2 = vector.size();
            while (--n2 >= 0) {
                string = (String)vector.elementAt(n2);
                if (((MultiUserCatalogAPI)this.catapi).getClassType(((MultiUserCatalogAPI)this.catapi).getObj(string, string2)) == 10 && !this.isInSet(stringArray, string3 = ((JetUDBTreeNode)((UserData)((MultiUserCatalogAPI)this.catapi).lockList.get((Object)string)).obj).getResourceName())) {
                    vector2.addElement(string3);
                }
                if (((MultiUserCatalogAPI)this.catapi).getClassType(((MultiUserCatalogAPI)this.catapi).getObj(string, string2)) != 5) continue;
                string3 = ((JetUDBTreeNode)((UserData)((MultiUserCatalogAPI)this.catapi).lockList.get((Object)string)).obj).getResourceName();
                object = ((MultiUserCatalogAPI)this.catapi).editCat.getDatabase(string4).getAllSumsValidToQuery(string3);
                n = ((Vector)object).size();
                while (--n >= 0) {
                    string3 = ((JetUSummary)((Vector)object).elementAt(n)).getResourceName();
                    if (this.isInSet(stringArray, string3) || vector2.contains(string3)) continue;
                    vector2.addElement(string3);
                }
            }
            int n3 = vector2.size();
            if (n3 > 0) {
                n2 = stringArray.length;
                object = new String[n2 + n3];
                System.arraycopy(stringArray, 0, object, 0, n2);
                stringArray = object;
                n = n3;
                while (--n >= 0) {
                    stringArray[n2++] = (String)vector2.elementAt(n);
                }
            }
        }
        return stringArray;
    }

    boolean checkGroupby(String string, String string2, String string3, String string4) {
        JetObject jetObject = (JetObject)this.handles.get(string);
        boolean bl = false;
        String string5 = this.CLASSNAME(jetObject);
        String string6 = this.CHARTTYPE(jetObject);
        JetUResourceEntity jetUResourceEntity = ((MultiUserCatalogAPI)this.catapi).editCat.getResourceByName(string6, string5, string3);
        if (jetUResourceEntity instanceof JetUSummary) {
            bl = ((JetUSummary)jetUResourceEntity).getGroupByFld().equalsIgnoreCase(string2);
        } else if (jetUResourceEntity instanceof JetUFormula) {
            bl = ((JetUFormula)jetUResourceEntity).isGroupBy(string2);
        }
        return bl;
    }

    public String[] getParameter(String string) {
        String[] stringArray = this.getParameter();
        if (string != null && ((MultiUserCatalogAPI)this.catapi).hasLock(string)) {
            Vector vector = (Vector)((MultiUserCatalogAPI)this.catapi).userList.get(string);
            Vector<String> vector2 = new Vector<String>();
            int n = vector.size();
            while (--n >= 0) {
                String string2;
                String string3 = (String)vector.elementAt(n);
                if (!((MultiUserCatalogAPI)this.catapi).hasLock(string) || ((MultiUserCatalogAPI)this.catapi).getClassType(((MultiUserCatalogAPI)this.catapi).getObj(string3, string)) != 11 || this.isInSet(stringArray, string2 = ((JetUDBTreeNode)((UserData)((MultiUserCatalogAPI)this.catapi).lockList.get((Object)string3)).obj).getResourceName())) continue;
                vector2.addElement(string2);
            }
            int n2 = vector2.size();
            if (n2 > 0) {
                n = stringArray.length;
                String[] stringArray2 = new String[n + n2];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                stringArray = stringArray2;
                int n3 = n2;
                while (--n3 >= 0) {
                    stringArray[n++] = (String)vector2.elementAt(n3);
                }
            }
        }
        return stringArray;
    }

    @Override
    public String[] getQueries(String string) {
        String[] stringArray = this.getQueries();
        if (string != null && ((MultiUserCatalogAPI)this.catapi).hasLock(string)) {
            Vector vector = (Vector)((MultiUserCatalogAPI)this.catapi).userList.get(string);
            Vector<String> vector2 = new Vector<String>();
            int n = vector.size();
            while (--n >= 0) {
                String string2;
                String string3 = (String)vector.elementAt(n);
                if (!((MultiUserCatalogAPI)this.catapi).hasLock(string) || ((MultiUserCatalogAPI)this.catapi).getClassType(((MultiUserCatalogAPI)this.catapi).getObj(string3, string)) != 5 || this.isInSet(stringArray, string2 = ((JetUDBTreeNode)((UserData)((MultiUserCatalogAPI)this.catapi).lockList.get((Object)string3)).obj).getResourceName())) continue;
                vector2.addElement(string2);
            }
            int n2 = vector2.size();
            if (n2 > 0) {
                n = stringArray.length;
                String[] stringArray2 = new String[n + n2];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                stringArray = stringArray2;
                int n3 = n2;
                while (--n3 >= 0) {
                    stringArray[n++] = (String)vector2.elementAt(n3);
                }
            }
        }
        return stringArray;
    }

    public String saveTo(String string, String string2, MultiUserDesigner multiUserDesigner) {
        return this.saveTo(string, string2, multiUserDesigner, true);
    }

    public String saveTo(String string, String string2, MultiUserDesigner multiUserDesigner, boolean bl) {
        try {
            JetRptReportPanel jetRptReportPanel = (JetRptReportPanel)this.handles.get(string);
            this.handles.remove(string);
            this.destroyHandles(jetRptReportPanel, string);
            string = this.getReportHandle(string2);
            jetRptReportPanel.setInstName(string);
            jetRptReportPanel.getDataSource(null).setUniverse(null, ((MultiUserCatalogAPI)multiUserDesigner.catapi).cat);
            multiUserDesigner.handles.put(string, jetRptReportPanel);
            multiUserDesigner.createHandles(jetRptReportPanel, string);
            if (bl) {
                multiUserDesigner.save(string);
            }
            return string;
        }
        catch (Exception exception) {
            this.setError(exception);
            return null;
        }
    }

    protected JetUUniverse getEditCatalog() {
        return ((MultiUserCatalogAPI)this.catapi).editCat;
    }

    String getFormat(String string, JetObject jetObject, String string2, int n, String string3) {
        return this.getFormat(jetObject, string2, ((MultiUserCatalogAPI)this.catapi).isLock(((MultiUserCatalogAPI)this.catapi).getHandle(string, string2, n, string3), string3) ? ((MultiUserCatalogAPI)this.catapi).editCat : ((MultiUserCatalogAPI)this.catapi).cat);
    }

    public String[] getFormats(String string, String string2) {
        JetObject jetObject = this.getObj(string);
        return this.getFormats(jetObject, ((MultiUserCatalogAPI)this.catapi).editCat);
    }

    public String[] getChangedByFields(String string, String string2, String string3) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            try {
                Vector vector = this.getChangedByFields(jetObject, string2);
                Object[] objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                return objectArray;
            }
            catch (Exception exception) {}
        } else {
            this.setError("getChangedByFields(\"" + string + "\", \"" + string2 + "\", \"" + string3 + "\"): void handle");
        }
        return new String[0];
    }

    boolean checkGroupby1(JetObject jetObject, String string, String string2) {
        String string3 = this.CLASSNAME(jetObject);
        String string4 = this.CHARTTYPE(jetObject);
        JetUResourceEntity jetUResourceEntity = ((MultiUserCatalogAPI)this.catapi).editCat.getResourceByName(string4, string3, string);
        String string5 = jetObject instanceof JetRptReportHeaderPanel || jetObject instanceof JetRptReportFooterPanel ? "REPORT" : ((JetRptGroupPanel)jetObject.getParent()).groupBy.get();
        return jetUResourceEntity == null ? false : ((JetUFormula)jetUResourceEntity).isGroupBy(string5);
    }

    public String[] getControlFields(String string, String string2, String string3) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            if (jetProperty != null) {
                if (jetProperty.canChangeByOthers()) {
                    int n = 0;
                    int[] nArray = jetProperty.getMatchingSqlType();
                    JetRptDataSource jetRptDataSource = ((JetRptReportPanel)JetObject.getRoot(jetObject)).getDataSource(null);
                    String string4 = this.CLASSNAME(jetObject);
                    String string5 = this.CHARTTYPE(jetObject);
                    try {
                        int n2;
                        String string6;
                        int n3;
                        Object object;
                        Object object2;
                        Vector<JetUSummary> vector;
                        Vector<JetUFormula> vector2;
                        Vector vector3;
                        string = ((MultiUserCatalogAPI)this.catapi).getHandle(string5, string4, 5, string3);
                        if (string == null) {
                            vector3 = jetRptDataSource.getAllColumnsInCurQry(null);
                            vector2 = jetRptDataSource.getAllFomulasInCurQuery(null);
                            vector = jetRptDataSource.getSummariesInCurQuery(null);
                        } else {
                            JetUQueriable jetUQueriable;
                            object2 = (UserData)((MultiUserCatalogAPI)this.catapi).lockList.get(string);
                            if (object2 != null && ((UserData)object2).uID.equals(string3)) {
                                jetUQueriable = (JetUQueriable)((Object)((UserData)object2).obj);
                                vector3 = jetUQueriable.getFields();
                            } else {
                                jetUQueriable = jetRptDataSource.getUniverse(null).getDatabase(string5).getQueriableByResourceName(string4);
                                vector3 = jetRptDataSource.getAllColumnsInCurQry(null);
                            }
                            object = ((MultiUserCatalogAPI)this.catapi).getFormulaeForQuery(string5, string4, string3);
                            vector2 = new Vector<JetUFormula>();
                            int n4 = ((String[])object).length;
                            while (--n4 >= 0) {
                                vector2.addElement(((MultiUserCatalogAPI)this.catapi).editCat.getDatabase(string5).getFormulaByResourceName(object[n4]));
                            }
                            vector = new Vector<JetUSummary>();
                            String[] stringArray = ((MultiUserCatalogAPI)this.catapi).getSummariesForQuery(string5, string4, string3);
                            n3 = stringArray.length;
                            while (--n3 >= 0) {
                                vector.addElement(((MultiUserCatalogAPI)this.catapi).editCat.getDatabase(string5).getSummaryByResourceName(stringArray[n3]));
                            }
                        }
                        String[] stringArray = new String[(vector3 == null ? 0 : vector3.size()) + (vector2 == null ? 0 : vector2.size()) + (vector == null ? 0 : vector.size())];
                        while (jetObject != null && !(jetObject instanceof JetRptGroupPanel)) {
                            jetObject = (JetObject)((Object)jetObject.getParent());
                        }
                        if (jetObject != null) {
                            string6 = ((JetRptGroupPanel)jetObject).groupBy.get();
                            if (string6 != null && string6.trim().length() == 0) {
                                string6 = null;
                            }
                        } else {
                            string6 = null;
                        }
                        n3 = n2 = vector2 == null ? 0 : vector2.size();
                        while (--n3 >= 0) {
                            object = (JetUFormula)vector2.elementAt(n3);
                            object2 = ((JetUFormula)object).getColDesc();
                            if (object2 == null) continue;
                            if (object instanceof JetUSummary) {
                                int n5;
                                Vector vector4 = ((JetUFormula)object).getGroupByVector();
                                int n6 = n5 = vector4 == null ? 0 : vector4.size();
                                if (n5 == 0 && string6 != null || n5 != 0 && string6 == null || n5 > 1 || string6 != null && !string6.equalsIgnoreCase(vector4.elementAt(0).toString())) continue;
                            }
                            if (!this.validType(nArray, ((DbColDesc)object2).getSqlType())) continue;
                            stringArray[n++] = ((JetUDBTreeNode)object).getResourceName();
                        }
                        int n7 = n2 = vector == null ? 0 : vector.size();
                        while (--n7 >= 0) {
                            String string7;
                            JetUSummary jetUSummary = (JetUSummary)vector.elementAt(n7);
                            object2 = jetUSummary.getColDesc();
                            if (object2 == null || !GuiUtil.areEqualIgnoreCase(string6, string7 = jetUSummary.getGroupByFld()) || !this.validType(nArray, ((DbColDesc)object2).getSqlType())) continue;
                            stringArray[n++] = jetUSummary.getResourceName();
                        }
                        int n8 = n2 = vector3 == null ? 0 : vector3.size();
                        while (--n8 >= 0) {
                            JetUResourceEntity jetUResourceEntity = (JetUResourceEntity)vector3.elementAt(n8);
                            if (!this.validType(nArray, jetUResourceEntity.getColDesc().getSqlType())) continue;
                            stringArray[n++] = jetUResourceEntity.getResourceName();
                        }
                        String[] stringArray2 = new String[n];
                        System.arraycopy(stringArray, 0, stringArray2, 0, n);
                        return stringArray2;
                    }
                    catch (Exception exception) {
                        this.setError(exception);
                    }
                } else {
                    this.setWarning("getControlFields(\"" + string + "\",\"" + string2 + "\"): Property " + string2 + " of " + string + " cannot be changed at runtime.");
                }
            } else {
                this.setError("getControlFields(\"" + string + "\",\"" + string2 + "\"): " + string2 + " is not a property in " + string + '.');
            }
        } else {
            this.setError("getControlFields(\"" + string + "\",\"" + string2 + "\"): Illegal handle " + string + '.');
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean setControlFields(String string, String string2, String string3, String string4) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject == null) {
            this.setError("setControlFields(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\"): Illegal handle " + string + '.');
            return false;
        }
        String[] stringArray = jetObject.nameToProperty(string2);
        if (stringArray == null) {
            this.setError("setControlFields(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\"): " + string2 + " is not a property in " + string + '.');
            return false;
        }
        if (!stringArray.canChangeByOthers()) {
            this.setWarning("setControlFields(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\"): Property " + string2 + " of " + string + " cannot be changed at runtime.");
            return false;
        }
        stringArray = this.getControlFields(string, string2, string4);
        if (stringArray != null) {
            int n = stringArray.length;
            while (--n >= 0) {
                if (!string3.equals(stringArray[n])) continue;
                ((JetObject)this.handles.get(string)).nameToProperty(string2).setChangeByObject(string3);
                return true;
            }
        }
        this.setError("setControlFields(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\"): Illegal field name " + string3 + '.');
        return false;
    }

    private String CHARTTYPE(JetObject jetObject) {
        if (this.getReport(jetObject.getQualifyName()) != null) {
            DataSet dataSet = ReportTools.getDataSet((JetRptObject)jetObject);
            return dataSet.getDataSourceName();
        }
        if (this.getReportPanel(jetObject.getQualifyName()) != null) {
            JetRptDataSource jetRptDataSource = this.getReportPanel(jetObject.getQualifyName()).getDataSource(null);
            return jetRptDataSource.sourceName.get();
        }
        return null;
    }

    private String CLASSNAME(JetObject jetObject) {
        if (this.getReport(jetObject.getQualifyName()) != null) {
            DataSet dataSet = ReportTools.getDataSet((JetRptObject)jetObject);
            return dataSet.getQueryName();
        }
        if (this.getReportPanel(jetObject.getQualifyName()) != null) {
            JetRptDataSource jetRptDataSource = this.getReportPanel(jetObject.getQualifyName()).getDataSource(null);
            return jetRptDataSource.uQueryName.get();
        }
        return null;
    }
}

