/*
 * Decompiled with CFR 0.152.
 */
package jet.api;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.security.api.Permissions;
import java.security.acl.Permission;
import java.util.Hashtable;
import java.util.Vector;
import jet.api.BLCategoryInfo;
import jet.api.BLDetailInfo;
import jet.api.BLDimensionInfo;
import jet.api.BLFilterInformation;
import jet.api.BLHierarchyInfo;
import jet.api.BLMeasureInfo;
import jet.api.BLNodeInformation;
import jet.api.BVAggregationInfo;
import jet.api.BVDetailInfo;
import jet.api.BVGroupInfo;
import jet.api.BusinessViewCategoryInfo;
import jet.api.CatalogAPI;
import jet.api.DesignerErrorException;
import jet.api.ExpressionGroupInfo;
import jet.api.ExpressionInfo;
import jet.api.ExpressionNode;
import jet.api.ObjectInfo;
import jet.connect.DbColDesc;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.xml.MetadataContainerImpl;
import jet.icontrols.QueryInfo;
import jet.jetc.ReadFailureException;
import jet.jetc.WriteFailureException;
import jet.reportLogic.objectLogic.resourceLogic.ResourceTool;
import jet.universe.JetUCompColQueryField;
import jet.universe.JetUConnection;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUDatabase;
import jet.universe.JetUDemandQuery;
import jet.universe.JetUField;
import jet.universe.JetUFileQuery;
import jet.universe.JetUFileQueryField;
import jet.universe.JetUFormula;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUParameter;
import jet.universe.JetUProcField;
import jet.universe.JetUProcedure;
import jet.universe.JetUQueriable;
import jet.universe.JetUQuery;
import jet.universe.JetUQueryField;
import jet.universe.JetUResourceContainer;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;
import jet.universe.JetUTable;
import jet.universe.JetUTableView;
import jet.universe.JetUUDSField;
import jet.universe.JetUUniverse;
import jet.universe.JetUUserDataSource;
import jet.universe.JetUView;
import jet.universe.JetUWherePortion;
import jet.universe.JetUXMLConnection;
import jet.universe.RefResourceException;
import jet.universe.businesslogic.AggregationInfo;
import jet.universe.businesslogic.BLContainer;
import jet.universe.businesslogic.BLDupleNameException;
import jet.universe.businesslogic.BLIlegalNameException;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.CategoryInfo;
import jet.universe.businesslogic.DTInformation;
import jet.universe.businesslogic.DetailInformation;
import jet.universe.businesslogic.DimensionInfo;
import jet.universe.businesslogic.FilterInfo;
import jet.universe.businesslogic.HierarchyContainer;
import jet.universe.businesslogic.HierarchyInfo;
import jet.universe.businesslogic.JUnifiedBusinessView;
import jet.universe.businesslogic.MeasureInfo;
import jet.universe.businesslogic.MemberSecurityEntry;
import jet.universe.businesslogic.impl.Aggregation;
import jet.universe.businesslogic.impl.BLContainerImpl;
import jet.universe.businesslogic.impl.Category;
import jet.universe.businesslogic.impl.DataElement;
import jet.universe.businesslogic.impl.Detail;
import jet.universe.businesslogic.impl.DetailInfo;
import jet.universe.businesslogic.impl.Dimension;
import jet.universe.businesslogic.impl.Group;
import jet.universe.businesslogic.impl.Hierarchy;
import jet.universe.businesslogic.impl.HierarchyContainerImpl;
import jet.universe.businesslogic.impl.Measure;
import jet.universe.businesslogic.impl.Prefilter;
import jet.universe.businesslogic.impl.UnifiedBusinessView;
import jet.universe.exception.FMLFileException;
import jet.universe.exception.UniverseFileException;
import jet.universe.psql.RptPsqlQuery;
import jet.universe.psql.RptPsqlTools;
import toolkit.db.PsqlColumn;
import toolkit.db.PsqlSelColumn;
import toolkit.db.PsqlTable;

public class MultipliedCatalogAPI
extends CatalogAPI {
    final int iCurVersionNumber = 17;
    boolean isquery = false;

    MultipliedCatalogAPI(JetUUniverse jetUUniverse, String string, String string2, String string3) {
        super(jetUUniverse, string, string2, string3);
    }

    public MultipliedCatalogAPI(String string, String string2, String string3) throws ReadFailureException, UniverseFileException {
        if (string3 == null || string3.length() == 0) {
            string2 = string2 + ".cat";
            this.suffix = ".cat";
        } else if (!string2.endsWith(".cat") && !string2.endsWith(".cat.xml")) {
            if (string3.indexOf(".") == -1) {
                string2 = string2 + "." + string3;
                this.suffix = "." + string3;
            } else {
                string2 = string2 + string3;
                this.suffix = string3;
            }
        }
        JetUUniverse.setUniverse(null);
        this.cat = JetUUniverse.LoadNoCache(string, string2, 17);
        JetUUniverse.setUniverse(this.cat);
        String string4 = this.cat.getQualifyName();
        this.handles.put(string4, this.cat);
        this.createHandles(this.cat, string4);
        this.lookForCurrentReportIndex(string);
    }

    @Override
    public boolean save() throws WriteFailureException, FMLFileException {
        JetUUniverse.setUniverse(this.cat);
        boolean bl = this.cat.Save();
        if (this.referResource != null) {
            try {
                this.referResource.saveCatalog();
            }
            catch (RefResourceException refResourceException) {
                // empty catch block
            }
        }
        return bl;
    }

    @Override
    public boolean saveAs(String string, String string2) {
        JetUUniverse.setUniverse(this.cat);
        this.clearMsg();
        boolean bl = false;
        try {
            bl = this.cat.Save(string, string2);
        }
        catch (Exception exception) {
            this.setError(exception);
        }
        return bl;
    }

    @Override
    int getClassType(JetObject jetObject) {
        if (jetObject != null) {
            if (jetObject instanceof JetUUniverse) {
                return 0;
            }
            if (jetObject instanceof JetUDatabase) {
                return 15;
            }
            if (jetObject instanceof JetUXMLConnection) {
                return 26;
            }
            if (jetObject instanceof JetUConnection) {
                return 1;
            }
            if (jetObject instanceof MetadataContainerImpl) {
                return 27;
            }
            if (jetObject instanceof JetUDemandQuery) {
                return 25;
            }
            if (jetObject instanceof JetUQuery) {
                return 5;
            }
            if (jetObject instanceof JetUProcedure) {
                return 6;
            }
            if (jetObject instanceof JetUUserDataSource) {
                return 8;
            }
            if (jetObject instanceof JetUFileQuery) {
                return 7;
            }
            if (jetObject instanceof JetUSummary) {
                return 10;
            }
            if (jetObject instanceof JetUFormula) {
                return 9;
            }
            if (jetObject instanceof JetUParameter) {
                return 11;
            }
            if (jetObject instanceof JetUWherePortion) {
                return 12;
            }
            if (jetObject instanceof JetUTableView) {
                if (((JetUTableView)jetObject).isTable()) {
                    return 2;
                }
                if (((JetUTableView)jetObject).isView()) {
                    return 3;
                }
                if (((JetUTableView)jetObject).isSynonym()) {
                    return 13;
                }
                if (((JetUTableView)jetObject).isAlias()) {
                    return 14;
                }
            } else {
                if (jetObject instanceof JetUFileQueryField || jetObject instanceof JetUProcField || jetObject instanceof JetUQueryField || jetObject instanceof JetUUDSField || jetObject instanceof JetUField) {
                    return 4;
                }
                if (jetObject instanceof JetUHierDataSource) {
                    return 16;
                }
                if (jetObject instanceof JUnifiedBusinessView) {
                    return 31;
                }
                if (jetObject instanceof Category) {
                    return 18;
                }
                if (jetObject instanceof Group) {
                    return 28;
                }
                if (jetObject instanceof AggregationInfo) {
                    return 29;
                }
                if (jetObject instanceof Detail) {
                    return 30;
                }
                if (jetObject instanceof Hierarchy) {
                    return 23;
                }
                if (jetObject instanceof HierarchyContainerImpl) {
                    return 24;
                }
            }
        }
        return -1;
    }

    private String GetQueryByResourceName(String string, String string2, int n, JetUUniverse jetUUniverse) {
        JetUUniverse.setUniverse(jetUUniverse);
        JetUDatabase jetUDatabase = this.getDatabase(string, jetUUniverse);
        if (jetUDatabase == null) {
            return null;
        }
        if (n == 15) {
            return jetUDatabase != null ? jetUDatabase.getQualifyName() : null;
        }
        switch (n) {
            case 1: {
                JetUConnection jetUConnection = jetUDatabase.getConnectionByResourceName(string2);
                return jetUConnection != null ? jetUConnection.getQualifyName() : null;
            }
            case 26: {
                JetUXMLConnection jetUXMLConnection = (JetUXMLConnection)jetUDatabase.getConnectionByResourceName(string2);
                return jetUXMLConnection != null ? jetUXMLConnection.getQualifyName() : null;
            }
            case 5: {
                JetUQuery jetUQuery = jetUDatabase.GetQueryByResourceName(string2);
                return jetUQuery != null ? jetUQuery.getQualifyName() : null;
            }
            case 6: {
                JetUQueriable jetUQueriable = jetUDatabase.getQueriableByResourceName(string2);
                return jetUQueriable != null && jetUQueriable instanceof JetUProcedure ? ((JetUProcedure)jetUQueriable).getQualifyName() : null;
            }
            case 8: {
                JetUQueriable jetUQueriable = jetUDatabase.getQueriableByResourceName(string2);
                return jetUQueriable != null && jetUQueriable instanceof JetUUserDataSource ? ((JetUUserDataSource)jetUQueriable).getQualifyName() : null;
            }
            case 7: {
                JetUQueriable jetUQueriable = jetUDatabase.getQueriableByResourceName(string2);
                return jetUQueriable != null && jetUQueriable instanceof JetUFileQuery ? ((JetUFileQuery)jetUQueriable).getQualifyName() : null;
            }
            case 10: {
                JetUSummary jetUSummary = jetUDatabase.getSummaryByResourceName(string2);
                return jetUSummary != null ? jetUSummary.getQualifyName() : null;
            }
            case 9: {
                JetUFormula jetUFormula = jetUDatabase.getFormulaByResourceName(string2);
                return jetUFormula != null ? jetUFormula.getQualifyName() : null;
            }
            case 11: {
                JetUParameter jetUParameter = jetUDatabase.getParameterByResourceName(string2);
                return jetUParameter != null ? jetUParameter.getQualifyName() : null;
            }
            case 12: {
                JetUWherePortion jetUWherePortion = jetUDatabase.getWherePortionByResourceName(string2);
                return jetUWherePortion != null ? jetUWherePortion.getQualifyName() : null;
            }
            case 3: {
                JetUTableView jetUTableView = jetUDatabase.getConnection().getTableViewsByResourceName(string2, 2);
                return jetUTableView != null ? jetUTableView.getQualifyName() : null;
            }
            case 2: {
                JetUTableView jetUTableView = jetUDatabase.getConnection().getTableViewsByResourceName(string2, 1);
                return jetUTableView != null ? jetUTableView.getQualifyName() : null;
            }
            case 17: 
            case 31: 
            case 32: {
                Vector<UnifiedBusinessView> vector = jetUDatabase.getBvs();
                for (int i = 0; i < vector.size(); ++i) {
                    if (!vector.get(i).getQualifyDisplayName().equalsIgnoreCase(string2)) continue;
                    return ((JetObject)vector.get(i)).getQualifyName();
                }
                return null;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                return null;
            }
        }
        JetUResourceEntity jetUResourceEntity = jetUDatabase.getResourceByName(string2);
        if (jetUResourceEntity != null) {
            return jetUResourceEntity.getQualifyName();
        }
        JetUResourceContainer jetUResourceContainer = (JetUResourceContainer)((Object)jetUDatabase.getQueriableByResourceName(string2));
        if (jetUResourceContainer != null) {
            return jetUResourceContainer.getQualifyName();
        }
        JetUConnection jetUConnection = jetUDatabase.getConnection();
        if (jetUConnection != null) {
            jetUResourceContainer = jetUConnection.GetTableOrViewByResourceName(string2);
        }
        if (jetUResourceContainer != null) {
            return jetUResourceContainer.getQualifyName();
        }
        return null;
    }

    @Override
    public String getHandle(String string, int n) {
        return this.GetQueryByResourceName(this.getDefaultDataSourceName(), string, n, this.cat);
    }

    @Override
    public String getHandle(String string, String string2, int n) {
        return this.GetQueryByResourceName(string, string2, n, this.cat);
    }

    @Override
    public void rename(String string, String string2, int n) {
        this.clearMsg();
        JetUDBTreeNode jetUDBTreeNode = null;
        switch (n) {
            case 15: {
                jetUDBTreeNode = this.getDatabase(string, this.cat);
                break;
            }
            case 1: {
                jetUDBTreeNode = this.cat.getConnectionByResourceName(string);
                break;
            }
            case 5: {
                jetUDBTreeNode = this.cat.GetQueryByResourceName(string);
                break;
            }
            case 6: {
                jetUDBTreeNode = (JetUDBTreeNode)((Object)this.cat.getQueriableByResourceName(string));
                break;
            }
            case 8: {
                jetUDBTreeNode = (JetUDBTreeNode)((Object)this.cat.getQueriableByResourceName(string));
                break;
            }
            case 7: {
                jetUDBTreeNode = (JetUDBTreeNode)((Object)this.cat.getQueriableByResourceName(string));
                break;
            }
            case 10: {
                jetUDBTreeNode = this.cat.getDatabase().getSummaryByResourceName(string);
                break;
            }
            case 9: {
                jetUDBTreeNode = this.cat.getDatabase().getFormulaByResourceName(string);
                break;
            }
            case 11: {
                jetUDBTreeNode = this.cat.getDatabase().getParameterByResourceName(string);
                break;
            }
            case 12: {
                jetUDBTreeNode = this.cat.getDatabase().getWherePortionByResourceName(string);
                break;
            }
            case 3: {
                jetUDBTreeNode = (JetUView)this.cat.getDatabase().getConnection().getTableViewsByResourceName(string, 2);
                break;
            }
            case 2: {
                jetUDBTreeNode = (JetUTable)this.cat.getDatabase().getConnection().getTableViewsByResourceName(string, 2);
                break;
            }
            case 4: {
                jetUDBTreeNode = this.cat.getResourceByName(string);
            }
        }
        if (jetUDBTreeNode != null) {
            if (this.referResource != null) {
                try {
                    this.referResource.renameRefBeforeAction(jetUDBTreeNode, string2, true, new Hashtable(), false);
                }
                catch (RefResourceException refResourceException) {
                    this.setError("rename(\"" + string + "\",\"" + string2 + "\",\"" + n + "\"): rename resource name " + "[" + string + "] failed.");
                    this.setError(refResourceException);
                }
            }
            if (n == 15) {
                ((JetUDatabase)jetUDBTreeNode).rename(string2);
            } else {
                jetUDBTreeNode.setResourceName(string2);
            }
        } else {
            this.setError("rename(\"" + string + "\",\"" + string2 + "\",\"" + n + "\"): void resource name " + "[" + string + "]");
        }
    }

    @Override
    public void rename(String string, String string2, String string3, int n) {
        this.clearMsg();
        JetUDBTreeNode jetUDBTreeNode = null;
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            return;
        }
        switch (n) {
            case 15: {
                jetUDBTreeNode = jetUDatabase;
                break;
            }
            case 1: {
                jetUDBTreeNode = jetUDatabase.getConnectionByResourceName(string2);
                break;
            }
            case 5: {
                jetUDBTreeNode = jetUDatabase.GetQueryByResourceName(string2);
                break;
            }
            case 6: {
                jetUDBTreeNode = (JetUDBTreeNode)((Object)jetUDatabase.getQueriableByResourceName(string2));
                break;
            }
            case 8: {
                jetUDBTreeNode = (JetUDBTreeNode)((Object)jetUDatabase.getQueriableByResourceName(string2));
                break;
            }
            case 7: {
                jetUDBTreeNode = (JetUDBTreeNode)((Object)jetUDatabase.getQueriableByResourceName(string2));
                break;
            }
            case 10: {
                jetUDBTreeNode = jetUDatabase.getSummaryByResourceName(string2);
                break;
            }
            case 9: {
                jetUDBTreeNode = jetUDatabase.getFormulaByResourceName(string2);
                break;
            }
            case 11: {
                jetUDBTreeNode = jetUDatabase.getParameterByResourceName(string2);
                break;
            }
            case 12: {
                jetUDBTreeNode = jetUDatabase.getWherePortionByResourceName(string2);
                break;
            }
            case 3: {
                jetUDBTreeNode = (JetUView)jetUDatabase.getConnection().getTableViewsByResourceName(string2, 2);
                break;
            }
            case 2: {
                jetUDBTreeNode = (JetUTable)jetUDatabase.getConnection().getTableViewsByResourceName(string2, 2);
                break;
            }
            case 4: {
                jetUDBTreeNode = jetUDatabase.getResourceByName(string2);
            }
        }
        if (jetUDBTreeNode != null) {
            try {
                this.referResource.renameRefBeforeAction(jetUDBTreeNode, string3, true, new Hashtable(), false);
            }
            catch (RefResourceException refResourceException) {
                this.setError("rename(\"" + string2 + "\",\"" + string3 + "\",\"" + n + "\"): rename resource name " + "[" + string2 + "] failed.");
                this.setError(refResourceException);
            }
            if (n == 15) {
                ((JetUDatabase)jetUDBTreeNode).rename(string3);
            } else {
                jetUDBTreeNode.setResourceName(string3);
            }
        } else {
            this.setError("rename(\"" + string2 + "\",\"" + string3 + "\",\"" + n + "\"): void resource name " + "[" + string2 + "]");
        }
    }

    @Override
    public ObjectInfo getObjectInfo(String string, int n) {
        String string2 = this.getHandle(string, n);
        if (string2 != null) {
            return this.getObjectInfo(string2);
        }
        this.setError("getObjectInfo(" + string + "," + n + ") void resourceName or type.");
        return null;
    }

    @Override
    public ObjectInfo getObjectInfo(String string, String string2, int n) {
        String string3 = this.getHandle(string, string2, n);
        if (string3 != null) {
            return this.getObjectInfo(string3);
        }
        this.setError("getObjectInfo(" + string2 + "," + n + ") void resourceName or type.");
        return null;
    }

    @Override
    public ObjectInfo getObjectInfo(String string) {
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            Hashtable hashtable = jetObject.getProperties();
            ObjectInfo objectInfo = new ObjectInfo();
            objectInfo.setInfo(hashtable);
            return objectInfo;
        }
        this.setError("getObjectInfo(" + string + ") void handle.");
        return null;
    }

    public String getBLNodeQualifyDisplayName(String string) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof BLNode) {
                return ((BLNode)((Object)jetObject)).getQualifyDisplayName();
            }
            this.setError("getBLNodeQualifyDisplayName(" + string + "): invalid handle " + string);
        } else {
            this.setError("getBLNodeQualifyDisplayName(" + string + "): invalid handle " + string);
        }
        return null;
    }

    @Override
    boolean hasPermission(String string, BLNode bLNode) {
        JUnifiedBusinessView jUnifiedBusinessView = bLNode.getUbv();
        MemberSecurityEntry memberSecurityEntry = jUnifiedBusinessView.getMemberSecurityEntry();
        boolean bl = false;
        MemberSecurityEntry memberSecurityEntry2 = null;
        if (this.securityProvider != null) {
            QueryInfo queryInfo = ResourceTool.getQueryInfo(jUnifiedBusinessView);
            memberSecurityEntry2 = this.securityProvider.getMemberSecurity(queryInfo);
        }
        bl = memberSecurityEntry.checkPermission_visible(secData, string, bLNode.getQualifyDisplayName(), memberSecurityEntry2);
        return bl;
    }

    @Override
    public String insertPredefinedBLFilterInfo(String string, BLFilterInformation bLFilterInformation) throws DesignerErrorException {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        String string2 = null;
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null && jetObject instanceof JUnifiedBusinessView) {
            IExpression iExpression = null;
            ExpressionNode expressionNode = bLFilterInformation.getExpression();
            String string3 = bLFilterInformation.getDisplayName();
            try {
                if (expressionNode instanceof ExpressionGroupInfo) {
                    iExpression = this.buildConditionExpression((ExpressionGroupInfo)expressionNode);
                } else if (expressionNode instanceof ExpressionInfo) {
                    iExpression = this.buildConditionExpression((ExpressionInfo)expressionNode);
                }
                if (iExpression != null) {
                    Prefilter prefilter = new Prefilter();
                    prefilter.setTitle(string3);
                    prefilter.setDesc(bLFilterInformation.getDescription());
                    prefilter.setFilter(iExpression);
                    FilterInfo filterInfo = ((JUnifiedBusinessView)((Object)jetObject)).addPrefilter(prefilter);
                    string2 = prefilter.getQualifyName();
                    this.handles.put(string2, filterInfo);
                    return string2;
                }
            }
            catch (Exception exception) {
                throw new DesignerErrorException(exception);
            }
        }
        return null;
    }

    @Override
    public String[] getPredifinedFilterHandles(String string) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof JUnifiedBusinessView) {
                FilterInfo[] filterInfoArray = ((JUnifiedBusinessView)((Object)jetObject)).getPrefilterInfo();
                int n = filterInfoArray == null ? 0 : filterInfoArray.length;
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = ((JetObject)((Object)filterInfoArray[i])).getQualifyName();
                }
                return stringArray;
            }
            this.setError("getPredifinedFilterHandles(" + string + "): invalid handle " + string);
        } else {
            this.setError("getPredifinedFilterHandles(" + string + "): invalid handle " + string);
        }
        return new String[0];
    }

    @Override
    public String getBLNodeQualifyName(String string) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof BLNode) {
                return ((BLNode)((Object)jetObject)).getBLQualifyName();
            }
            this.setError("getBLNodeQualifyName(" + string + "): invalid handle " + string);
        } else {
            this.setError("getBLNodeQualifyName(" + string + "): invalid handle " + string);
        }
        return null;
    }

    private Vector GetTableOrViewByResourceName(JetUDatabase jetUDatabase, String string, Permission permission) {
        Vector<UnifiedBusinessView> vector = jetUDatabase.getBvs();
        Vector<UnifiedBusinessView> vector2 = new Vector<UnifiedBusinessView>();
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            UnifiedBusinessView unifiedBusinessView = vector.get(i);
            if (unifiedBusinessView == null || !this.hasPermission(string, unifiedBusinessView)) continue;
            vector2.add(unifiedBusinessView);
        }
        return vector2;
    }

    @Override
    public String[] getBusinesViewCategoryHandles(String string) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof CategoryInfo) {
                BLNode[] bLNodeArray = ((BLContainer)((Object)jetObject)).getBLChildren();
                String[] stringArray = new String[bLNodeArray.length];
                int n = 0;
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 3) continue;
                    stringArray[n] = ((JetObject)((Object)bLNodeArray[i])).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
            this.setError("getBusinesViewCategoryHandles(" + string + "): invalid handle " + string);
        } else {
            this.setError("getBLCategoryHandles(" + string + "): invalid handle " + string);
        }
        return new String[0];
    }

    @Override
    public String[] getBLHierarchyHandles(String string) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof UnifiedBusinessView) {
                HierarchyContainer hierarchyContainer = ((UnifiedBusinessView)jetObject).getHierarchyContainer();
                HierarchyInfo[] hierarchyInfoArray = hierarchyContainer.getAllHierarchies();
                String[] stringArray = new String[hierarchyInfoArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = ((JetObject)((Object)hierarchyInfoArray[i])).getQualifyName();
                }
                return stringArray;
            }
            this.setError("getBLHierarchyHandles(" + string + "): invalid handle " + string);
        } else {
            this.setError("getBLHierarchyHandles(" + string + "): invalid handle " + string);
        }
        return new String[0];
    }

    @Override
    public String[] getBusinessViewDetailHandles(String string) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof CategoryInfo || jetObject instanceof Group) {
                BLNode[] bLNodeArray = ((BLContainer)((Object)jetObject)).getBLChildren();
                String[] stringArray = new String[bLNodeArray.length];
                int n = 0;
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 7) continue;
                    stringArray[n] = ((JetObject)((Object)bLNodeArray[i])).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
            this.setError("getBusinessViewDetailHandles(" + string + "): invalid handle " + string);
        } else {
            this.setError("getBusinessViewDetailHandles(" + string + "): invalid handle " + string);
        }
        return new String[0];
    }

    @Override
    public String[] getBLDimensionHandles(String string) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof CategoryInfo) {
                BLNode[] bLNodeArray = ((BLContainer)((Object)jetObject)).getBLChildren();
                String[] stringArray = new String[bLNodeArray.length];
                int n = 0;
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 4) continue;
                    stringArray[n] = ((JetObject)((Object)bLNodeArray[i])).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
            this.setError("getBLDimensionHandles(" + string + "): invalid handle " + string);
        } else {
            this.setError("getBLDimensionHandles(" + string + "): invalid handle " + string);
        }
        return new String[0];
    }

    @Override
    public String[] getBusinessViewGroupHandles(String string) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof CategoryInfo) {
                BLNode[] bLNodeArray = ((BLContainer)((Object)jetObject)).getBLChildren();
                String[] stringArray = new String[bLNodeArray.length];
                int n = 0;
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 4) continue;
                    stringArray[n] = ((JetObject)((Object)bLNodeArray[i])).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
            this.setError("getBusinessViewGroupHandles(" + string + "): invalid handle " + string);
        } else {
            this.setError("getBusinessViewGroupHandles(" + string + "): invalid handle " + string);
        }
        return new String[0];
    }

    @Override
    public String[] getBusinessViewAggregationHandles(String string) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof CategoryInfo) {
                BLNode[] bLNodeArray = ((BLContainer)((Object)jetObject)).getBLChildren();
                String[] stringArray = new String[bLNodeArray.length];
                int n = 0;
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 5) continue;
                    stringArray[n] = ((JetObject)((Object)bLNodeArray[i])).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
            this.setError("getBusinessViewAggregationHandles(" + string + "): invalid handle " + string);
        } else {
            this.setError("getBusinessViewAggregationHandles(" + string + "): invalid handle " + string);
        }
        return new String[0];
    }

    @Override
    public String[] getBLViewHandles(String string) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            this.setError("getBLViewHandles(\"" + string + "\")Invalid data source name.");
            return new String[0];
        }
        Vector<UnifiedBusinessView> vector = jetUDatabase.getBvs();
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((JetObject)vector.get(i)).getQualifyName();
        }
        return stringArray;
    }

    @Override
    public String[] getBusinessViewHandles(String string) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            this.setError("getBusinessViewHandles(\"" + string + "\")Invalid data source name.");
            return new String[0];
        }
        Vector<UnifiedBusinessView> vector = jetUDatabase.getBvs();
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((JetObject)vector.get(i)).getQualifyName();
        }
        return stringArray;
    }

    @Override
    public String[] getBLViewHandles(String string, int n) {
        this.clearMsg();
        String[] stringArray = new String[]{};
        return stringArray;
    }

    @Override
    public String[] getBusinessViewHandles(String string, int n) {
        return new String[0];
    }

    @Override
    public String[] getBLViewNames(String string) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            this.setError("getBLViewNames(\"" + string + "\")Invalid data source name.");
            return new String[0];
        }
        Vector<UnifiedBusinessView> vector = jetUDatabase.getBvs();
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = vector.get(i).getQualifyDisplayName();
        }
        return stringArray;
    }

    @Override
    public String[] getBusinessViewNames(String string) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            this.setError("getBusinessViewNames(\"" + string + "\")Invalid data source name.");
            return new String[0];
        }
        Vector<UnifiedBusinessView> vector = jetUDatabase.getBvs();
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = vector.get(i).getQualifyDisplayName();
        }
        return stringArray;
    }

    @Override
    public String[] getBLViewNames(String string, int n) {
        this.clearMsg();
        return new String[0];
    }

    @Override
    public String[] getBusinessViewNames(String string, int n) {
        this.clearMsg();
        return new String[0];
    }

    @Override
    public String[] getBusinessNodeNames(String string, String string2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        String[] stringArray = new String[]{};
        if (jetUDatabase == null) {
            this.setError("getBusinessNodeNames(\"" + string + "," + string2 + "\")Invalid data source name.");
            return stringArray;
        }
        UnifiedBusinessView unifiedBusinessView = jetUDatabase.getBusinessView(string2);
        if (unifiedBusinessView != null) {
            BLNode[] bLNodeArray = unifiedBusinessView.getBLChildren();
            stringArray = new String[bLNodeArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = bLNodeArray[i].getName();
            }
        }
        return stringArray;
    }

    @Override
    public String insertBusinessView(String string, String string2, String string3) {
        try {
            return this.insertBusinessView(string, string2, string3, true);
        }
        catch (Throwable throwable) {
            this.setError(throwable.toString());
            return null;
        }
    }

    @Override
    public String insertBusinessView(String string, String string2, String string3, boolean bl) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        String string4 = null;
        try {
            JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
            if (jetUDatabase == null) {
                this.setError("insertBusinessView(" + string + "," + string3 + ")Invalid data source name.");
                return string4;
            }
            JetUQueriable jetUQueriable = jetUDatabase.getQueriableByResourceName(string2);
            if (jetUQueriable != null) {
                UnifiedBusinessView unifiedBusinessView = new UnifiedBusinessView();
                unifiedBusinessView.setDisplayName(string3);
                jetUDatabase.add(unifiedBusinessView);
                unifiedBusinessView.setParent(jetUDatabase);
                RptPsqlQuery rptPsqlQuery = new RptPsqlQuery();
                rptPsqlQuery.setMappingName("");
                rptPsqlQuery.setUniverse(jetUDatabase.getUniverse(), jetUDatabase.getResourceName());
                JetUDemandQuery jetUDemandQuery = new JetUDemandQuery("", rptPsqlQuery.getCopy());
                unifiedBusinessView.add(jetUDemandQuery);
                jetUDemandQuery.setParent(unifiedBusinessView);
                PsqlTable psqlTable = RptPsqlTools.UQueryToPsqlTable(jetUQueriable);
                this.P_VISIBLE(rptPsqlQuery, psqlTable);
                jetUDemandQuery.setPsqlQuery(rptPsqlQuery);
                string4 = unifiedBusinessView.getQualifyName();
                this.handles.put(string4, unifiedBusinessView);
            } else {
                string4 = this.insertBusinessView(string, string3);
            }
        }
        catch (Throwable throwable) {
            this.setError(throwable.toString());
        }
        return string4;
    }

    private void LoadNoCache(RptPsqlQuery rptPsqlQuery, PsqlTable psqlTable, String string, String string2) {
        PsqlColumn psqlColumn = psqlTable.getColumnByMappingName(string2);
        PsqlSelColumn psqlSelColumn = rptPsqlQuery.addUFieldEntity(psqlTable, psqlColumn);
        psqlSelColumn.setMappingName(string2);
        psqlSelColumn.setHide(false);
    }

    private void P_VISIBLE(RptPsqlQuery rptPsqlQuery, PsqlTable psqlTable) {
        PsqlColumn psqlColumn;
        int n;
        Object object;
        int n2;
        Vector<String> vector = new Vector<String>();
        int n3 = rptPsqlQuery.getPsqlTables().size();
        Vector vector2 = (Vector)rptPsqlQuery.getPsqlTables().clone();
        for (n2 = 0; n2 < n3; ++n2) {
            object = (PsqlTable)vector2.elementAt(n2);
            vector.addElement(((PsqlTable)object).getMappingName());
        }
        if (psqlTable != null && !vector.contains(psqlTable.getMappingName())) {
            rptPsqlQuery.vTables.addElement(psqlTable);
            Vector vector3 = psqlTable.getColumns();
            int n4 = vector3.size();
            for (int i = 0; i < n4; ++i) {
                PsqlColumn psqlColumn2 = (PsqlColumn)vector3.get(i);
                this.LoadNoCache(rptPsqlQuery, psqlTable, psqlTable.getMappingName(), psqlColumn2.getMappingName());
            }
            return;
        }
        n2 = rptPsqlQuery.getSelColsVector().size();
        object = rptPsqlQuery.getSelColsVector();
        Vector<String> vector4 = new Vector<String>();
        for (n = 0; n < n2; ++n) {
            psqlColumn = (PsqlColumn)((Vector)object).elementAt(n);
            JetUDatabase jetUDatabase = rptPsqlQuery.getDatabase();
            JetUResourceEntity jetUResourceEntity = jetUDatabase.getResourceByName(psqlColumn.getMappingName());
            if (jetUResourceEntity == null) {
                ((Vector)object).remove(n);
                --n2;
                --n;
                continue;
            }
            vector4.addElement(psqlColumn.getMappingName());
        }
        for (n = 0; n < psqlTable.getColumns().size(); ++n) {
            psqlColumn = (PsqlColumn)psqlTable.getColumns().get(n);
            if (vector4.contains(psqlColumn.getMappingName())) continue;
            this.LoadNoCache(rptPsqlQuery, psqlTable, psqlTable.getMappingName(), psqlColumn.getMappingName());
            vector4.addElement(psqlColumn.getMappingName());
        }
    }

    public String insertBusinessView(String string, String string2) throws DesignerErrorException {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        String string3 = null;
        if (jetUDatabase == null) {
            this.setError("insertBusinessView(" + string + "," + string2 + ")Invalid data source name.");
            return string3;
        }
        try {
            UnifiedBusinessView unifiedBusinessView = jetUDatabase.createBusinessView(string2);
            string3 = unifiedBusinessView.getQualifyName();
            this.handles.put(string3, unifiedBusinessView);
            this.notifyReference(unifiedBusinessView, 0);
        }
        catch (BLIlegalNameException bLIlegalNameException) {
            this.setError(bLIlegalNameException);
            throw new DesignerErrorException(bLIlegalNameException);
        }
        catch (BLDupleNameException bLDupleNameException) {
            this.setError(bLDupleNameException);
            throw new DesignerErrorException(bLDupleNameException);
        }
        return string3;
    }

    @Override
    public String insertBLCategory(String string, BLCategoryInfo bLCategoryInfo) throws DesignerErrorException {
        this.clearMsg();
        throw new DesignerErrorException(new UnsupportedOperationException());
    }

    @Override
    public String insertBusinessViewCategory(String string, BLCategoryInfo bLCategoryInfo) throws DesignerErrorException {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        String string2 = null;
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject == null || !(jetObject instanceof CategoryInfo)) {
            this.setError("insertBLCategory(" + string + "," + bLCategoryInfo + "\")Invalid handle.");
            return string2;
        }
        try {
            Category category = this.createCategory(this.SEDU(jetObject), bLCategoryInfo);
            ((CategoryInfo)((Object)jetObject)).addCategory(category);
            this.createCategoryChildren(this.SEDU(jetObject), bLCategoryInfo, category);
            string2 = category.getQualifyName();
            this.handles.put(string2, category);
            this.createHandles(category, string2);
        }
        catch (BLDupleNameException bLDupleNameException) {
            this.setError("insertBLCategory(" + string2 + "," + bLCategoryInfo + "\"):Invalid category info: name already exists.");
            throw new DesignerErrorException(bLDupleNameException);
        }
        catch (BLIlegalNameException bLIlegalNameException) {
            this.setError("insertBLCategory(" + string2 + "," + bLCategoryInfo + "\"):Invalid category info: illegal Name.");
            throw new DesignerErrorException(bLIlegalNameException);
        }
        return string2;
    }

    boolean isFieldExistsInQuery(RptPsqlQuery rptPsqlQuery, String string) {
        boolean bl = true;
        Vector vector = rptPsqlQuery.getSelColsVector();
        for (int i = 0; i < vector.size(); ++i) {
            if (!((PsqlSelColumn)vector.get(i)).getMappingName().equalsIgnoreCase(string)) continue;
            return bl;
        }
        return false;
    }

    @Override
    void addRefTables(DataElement dataElement) {
        JUnifiedBusinessView jUnifiedBusinessView = dataElement.getUbv();
        JetUDemandQuery jetUDemandQuery = jUnifiedBusinessView.getQuery();
        if (jetUDemandQuery instanceof JetUDemandQuery) {
            JetUDatabase jetUDatabase = jetUDemandQuery.getDatabase();
            RptPsqlQuery rptPsqlQuery = jetUDemandQuery.getPsqlQuery();
            String string = dataElement.getRefMappingName();
            JetUResourceEntity jetUResourceEntity = jetUDatabase.getResourceByName(string);
            JetUTableView jetUTableView = null;
            if (jetUResourceEntity != null) {
                if (this.isFieldExistsInQuery(rptPsqlQuery, string)) {
                    return;
                }
                if (jetUResourceEntity instanceof JetUFormula) {
                    Vector vector = new Vector();
                    RptPsqlTools.getColumnsOfFormula(jetUDemandQuery.getUniverse(), (JetUFormula)jetUResourceEntity, vector);
                    int n = vector.size();
                    for (int i = 0; i < n; ++i) {
                        string = (String)vector.get(i);
                        jetUResourceEntity = jetUDatabase.getResourceByName(string);
                        if (jetUResourceEntity == null) continue;
                        if (jetUResourceEntity instanceof JetUField) {
                            if (this.isFieldExistsInQuery(rptPsqlQuery, string)) continue;
                            jetUTableView = ((JetUField)jetUResourceEntity).getTable();
                            this.addRefTable(jetUDemandQuery, jetUTableView, string);
                            continue;
                        }
                        this.setWarning("addRefTables: unknown field[" + jetUResourceEntity + "]");
                    }
                } else if (jetUResourceEntity instanceof JetUField) {
                    jetUTableView = ((JetUField)jetUResourceEntity).getTable();
                    this.addRefTable(jetUDemandQuery, jetUTableView, string);
                }
            }
            jetUDemandQuery.setPsqlQuery(rptPsqlQuery);
        }
    }

    @Override
    public String insertBusinessViewCategory(String string, BusinessViewCategoryInfo businessViewCategoryInfo) throws DesignerErrorException {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        String string2 = null;
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject == null || !(jetObject instanceof CategoryInfo)) {
            this.setError("insertBLCategory(" + string + "," + businessViewCategoryInfo + "\")Invalid handle.");
            return string2;
        }
        try {
            Category category = this.createCategory(this.SEDU(jetObject), businessViewCategoryInfo);
            ((CategoryInfo)((Object)jetObject)).addCategory(category);
            this.createCategoryChildren(this.SEDU(jetObject), businessViewCategoryInfo, category);
            string2 = category.getQualifyName();
            this.handles.put(string2, category);
            this.createHandles(category, string2);
        }
        catch (BLDupleNameException bLDupleNameException) {
            this.setError("insertBLCategory(" + string2 + "," + businessViewCategoryInfo + "\"):Invalid category info: name already exists.");
            throw new DesignerErrorException(bLDupleNameException);
        }
        catch (BLIlegalNameException bLIlegalNameException) {
            this.setError("insertBLCategory(" + string2 + "," + businessViewCategoryInfo + "\"):Invalid category info: illegal Name.");
            throw new DesignerErrorException(bLIlegalNameException);
        }
        return string2;
    }

    public boolean insertBusinessViewTable(String string, String string2) throws DesignerErrorException {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        boolean bl = false;
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject == null || !(jetObject instanceof JUnifiedBusinessView)) {
            this.setError("insertBusinessViewTable(" + string + "," + string2 + "\")Invalid handle.");
            return bl;
        }
        try {
            JetUDatabase jetUDatabase = this.SEDU(jetObject);
            if (jetUDatabase != null) {
                JetUDemandQuery jetUDemandQuery = ((JUnifiedBusinessView)((Object)jetObject)).getQuery();
                if (jetUDemandQuery != null) {
                    RptPsqlQuery rptPsqlQuery = jetUDemandQuery.getPsqlQuery();
                    Vector vector = rptPsqlQuery.getPsqlTablesVector();
                    int n = vector.size();
                    while (--n >= 0) {
                        if (!((PsqlTable)vector.elementAt(n)).getMappingName().equalsIgnoreCase(string2)) continue;
                        this.setError("insertBusinessViewTable(\"" + string + "\",\"" + string2 + "\"):table \"" + string2 + "\"already exists in the query");
                        return bl;
                    }
                    JetUTableView jetUTableView = null;
                    jetUTableView = this.getTableOrViewByResourceName(jetUDatabase, string2);
                    PsqlTable psqlTable = RptPsqlTools.UTableToPsqlTable(jetUTableView, false);
                    if (psqlTable != null) {
                        rptPsqlQuery.addPsqlTable(psqlTable);
                        Vector vector2 = jetUTableView.getFields();
                        for (int i = 0; i < vector2.size(); ++i) {
                            JetUField jetUField = (JetUField)vector2.elementAt(i);
                            String string3 = jetUField.getResourceName();
                            rptPsqlQuery.addUFieldByName(string3).setMappingName(string3);
                        }
                        this.getJoinLineWithForeignKeys(jetUDatabase, rptPsqlQuery);
                        jetUDemandQuery.setPsqlQuery(rptPsqlQuery);
                        this.notifyReference(jetUDemandQuery, 2);
                        bl = true;
                    } else {
                        this.setError("insertBusinessViewTable(\"" + string + "\",\"" + string2 + "\"):void table Name(" + string2 + ").");
                    }
                } else {
                    this.setError("insertBusinessViewTable(\"" + string + "\",\"" + string2 + "\"):void BusinessView for there is no query.");
                }
            }
        }
        catch (Exception exception) {
            throw new DesignerErrorException(exception);
        }
        return bl;
    }

    public String getUBusinessViewQueryName(String string) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        String string2 = null;
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject == null || !(jetObject instanceof JUnifiedBusinessView)) {
            this.setError("getUBusinessViewQueryName(" + string + "\")Invalid handle.");
            return string2;
        }
        JetUDemandQuery jetUDemandQuery = ((JUnifiedBusinessView)((Object)jetObject)).getQuery();
        if (jetUDemandQuery != null) {
            string2 = ((JetUDBTreeNode)jetUDemandQuery).getResourceName();
        } else {
            this.setError("getUBusinessViewQueryName(\"" + string + "\"):void BusinessView for there is no query.");
        }
        return string2;
    }

    @Override
    public String insertBLDetail(String string, BLDetailInfo bLDetailInfo) throws DesignerErrorException {
        this.clearMsg();
        throw new DesignerErrorException(new UnsupportedOperationException());
    }

    @Override
    public String insertBusinessViewDetail(String string, BVDetailInfo bVDetailInfo) throws DesignerErrorException {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        String string2 = null;
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject == null || !(jetObject instanceof BLContainer)) {
            this.setError("insertBusinessViewDetail(" + string + "," + bVDetailInfo + "\")Invalid handle.");
            return string2;
        }
        try {
            DetailInfo detailInfo = this.createDetail(bVDetailInfo);
            if (jetObject instanceof Category) {
                ((Category)jetObject).addDetail((DTInformation)((Object)detailInfo));
            }
            string2 = detailInfo.getQualifyName();
            this.handles.put(string2, detailInfo);
            this.notifyReference(detailInfo, 0);
        }
        catch (BLDupleNameException bLDupleNameException) {
            this.setError("insertMeasure(" + string2 + "," + bVDetailInfo + "\"):Invalid category info: name already exists.");
            throw new DesignerErrorException(bLDupleNameException);
        }
        catch (BLIlegalNameException bLIlegalNameException) {
            this.setError("insertBLMeasure(" + string2 + "," + bVDetailInfo + "\"):Invalid category info: illegal Name.");
            throw new DesignerErrorException(bLIlegalNameException);
        }
        return string2;
    }

    private JetUDatabase SEDU(JetObject jetObject) {
        JetContainable jetContainable = jetObject.getParent();
        while (jetContainable != null) {
            if (jetContainable instanceof JetUDatabase) {
                return (JetUDatabase)jetContainable;
            }
            jetContainable = ((JetObject)((Object)jetContainable)).getParent();
        }
        return null;
    }

    @Override
    public String insertBLMeasure(String string, BLMeasureInfo bLMeasureInfo) throws DesignerErrorException {
        this.clearMsg();
        throw new DesignerErrorException(new UnsupportedOperationException());
    }

    @Override
    public String insertBusinessViewAggregation(String string, BVAggregationInfo bVAggregationInfo) throws DesignerErrorException {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        String string2 = null;
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject == null || !(jetObject instanceof CategoryInfo)) {
            this.setError("insertBLMeasure(" + string + "," + bVAggregationInfo + "\")Invalid handle.");
            return string2;
        }
        try {
            Measure measure = this.createMeasure(this.SEDU(jetObject), bVAggregationInfo);
            ((CategoryInfo)((Object)jetObject)).addAggregation((Aggregation)measure);
            string2 = measure.getQualifyName();
            this.handles.put(string2, measure);
            this.notifyReference(measure, 0);
        }
        catch (BLDupleNameException bLDupleNameException) {
            this.setError("insertMeasure(" + string2 + "," + bVAggregationInfo + "\"):Invalid category info: name already exists.");
            throw new DesignerErrorException(bLDupleNameException);
        }
        catch (BLIlegalNameException bLIlegalNameException) {
            this.setError("insertBLMeasure(" + string2 + "," + bVAggregationInfo + "\"):Invalid category info: illegal Name.");
            throw new DesignerErrorException(bLIlegalNameException);
        }
        return string2;
    }

    @Override
    public String insertBLDimension(String string, BLDimensionInfo bLDimensionInfo) throws DesignerErrorException {
        this.clearMsg();
        throw new DesignerErrorException(new UnsupportedOperationException());
    }

    @Override
    public String insertBusinessViewGroup(String string, BVGroupInfo bVGroupInfo) throws DesignerErrorException {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        String string2 = null;
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject == null || !(jetObject instanceof CategoryInfo)) {
            this.setError("insertDimension(" + string + "," + bVGroupInfo + "\")Invalid handle.");
            return string2;
        }
        try {
            Dimension dimension = this.createDimension(bVGroupInfo);
            ((CategoryInfo)((Object)jetObject)).addGroup((Group)dimension);
            string2 = dimension.getQualifyName();
            this.handles.put(string2, dimension);
            this.notifyReference(dimension, 0);
        }
        catch (BLDupleNameException bLDupleNameException) {
            this.setError("insertBLDimension(" + string2 + "," + bVGroupInfo + "\"):Invalid category info: name already exists.");
            throw new DesignerErrorException(bLDupleNameException);
        }
        catch (BLIlegalNameException bLIlegalNameException) {
            this.setError("insertBLDimension(" + string2 + "," + bVGroupInfo + "\"):Invalid category info: illegal Name.");
            throw new DesignerErrorException(bLIlegalNameException);
        }
        return string2;
    }

    @Override
    public String insertBLHierarchy(String string, BLHierarchyInfo bLHierarchyInfo) throws DesignerErrorException {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        String string2 = null;
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject == null || !(jetObject instanceof JUnifiedBusinessView)) {
            this.setError("insertBLHierarchy(" + string + "," + bLHierarchyInfo + "\")Invalid handle.");
            return string2;
        }
        try {
            Hierarchy hierarchy = this.Save(bLHierarchyInfo);
            ((BLContainerImpl)jetObject).addChild(hierarchy);
            string2 = hierarchy.getQualifyName();
            this.handles.put(string2, hierarchy);
            this.notifyReference(hierarchy, 0);
        }
        catch (BLDupleNameException bLDupleNameException) {
            this.setError("insertBLHierarchy(" + string2 + "," + bLHierarchyInfo + "\"):Invalid Hierarchy info: name already exists.");
            throw new DesignerErrorException(bLDupleNameException);
        }
        catch (BLIlegalNameException bLIlegalNameException) {
            this.setError("insertBLHierarchy(" + string2 + "," + bLHierarchyInfo + "\"):Invalid Hierarchy info: illegal Name.");
            throw new DesignerErrorException(bLIlegalNameException);
        }
        return string2;
    }

    private Hierarchy Save(BLHierarchyInfo bLHierarchyInfo) throws BLDupleNameException, BLIlegalNameException {
        Hierarchy hierarchy = new Hierarchy();
        hierarchy.setDescription(bLHierarchyInfo.getDescription());
        hierarchy.setName(bLHierarchyInfo.getName());
        hierarchy.setDimensions(bLHierarchyInfo.getDimensionQualifyNames());
        return hierarchy;
    }

    @Override
    protected void createHandles(JetContainable jetContainable, String string) {
        String string2;
        JetObject jetObject;
        Vector vector = jetContainable.getChildren();
        string = string + '.';
        if (this.isquery) {
            Vector vector2 = ((JetUQuery)jetContainable).getFields();
            int n = vector2.size();
            while (--n >= 0) {
                jetObject = (JetObject)vector2.elementAt(n);
                if (!(jetObject instanceof JetUCompColQueryField)) continue;
                string2 = string + jetObject.getInstName();
                this.handles.put(string2, jetObject);
            }
            this.isquery = false;
        }
        int n = vector.size();
        while (--n >= 0) {
            jetObject = (JetObject)vector.elementAt(n);
            string2 = string + jetObject.getInstName();
            this.handles.put(string2, jetObject);
            if (!(jetObject instanceof JetContainable)) continue;
            if (jetObject instanceof JetUQuery) {
                this.isquery = true;
            }
            this.createHandles((JetContainable)((Object)jetObject), string2);
        }
    }

    @Override
    public String[] getBLCategoryHandles(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof CategoryInfo) {
                BLNode[] bLNodeArray = ((BLContainer)((Object)jetObject)).getBLChildren();
                String[] stringArray = new String[bLNodeArray.length];
                int n = 0;
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 3 || !this.hasPermission(string2, bLNodeArray[i])) continue;
                    stringArray[n] = ((JetObject)((Object)bLNodeArray[i])).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
            this.setError("getBLCategoryHandles(" + string + "," + string2 + "): invalid handle " + string);
        } else {
            this.setError("getBLCategoryHandles(" + string + "," + string2 + "): invalid handle " + string);
        }
        return new String[0];
    }

    @Override
    public String[] getBLDetailHandles(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof CategoryInfo || jetObject instanceof DimensionInfo) {
                BLNode[] bLNodeArray = ((BLContainer)((Object)jetObject)).getBLChildren();
                String[] stringArray = new String[bLNodeArray.length];
                int n = 0;
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 7 || !this.hasPermission(string2, bLNodeArray[i])) continue;
                    stringArray[n] = ((JetObject)((Object)bLNodeArray[i])).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
            this.setError("getBLDetailHandles(" + string + "): invalid handle " + string);
        } else {
            this.setError("getBLDetailHandles(" + string + "): invalid handle " + string);
        }
        return new String[0];
    }

    @Override
    public String[] getBLMeasureHandles(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null) {
            if (jetObject instanceof CategoryInfo) {
                BLNode[] bLNodeArray = ((BLContainer)((Object)jetObject)).getBLChildren();
                String[] stringArray = new String[bLNodeArray.length];
                int n = 0;
                for (int i = 0; i < bLNodeArray.length; ++i) {
                    if (bLNodeArray[i].getElementType() != 5 || !this.hasPermission(string2, bLNodeArray[i])) continue;
                    stringArray[n] = ((JetObject)((Object)bLNodeArray[i])).getQualifyName();
                    ++n;
                }
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                return stringArray2;
            }
            this.setError("getBLMeasureHandles(" + string + "): invalid handle " + string);
        } else {
            this.setError("getBLMeasureHandles(" + string + "): invalid handle " + string);
        }
        return new String[0];
    }

    @Override
    public String[] getBLViewHandles(String string, String string2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            this.setError("getBLViewHandles(\"" + string + "\")Invalid data source name.");
            return new String[0];
        }
        Vector vector = this.GetTableOrViewByResourceName(jetUDatabase, string2, Permissions.P_VISIBLE);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((JetObject)vector.get(i)).getQualifyName();
        }
        return stringArray;
    }

    @Override
    public String[] getBusinessViewHandles(String string, String string2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            this.setError("getBLViewHandles(\"" + string + "\"," + "\"" + string2 + "\")Invalid data source name.");
            return new String[0];
        }
        Vector vector = this.GetTableOrViewByResourceName(jetUDatabase, string2, Permissions.P_VISIBLE);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((JetObject)vector.get(i)).getQualifyName();
        }
        return stringArray;
    }

    @Override
    public String getBusinessLogicHandle(String string, String string2, boolean bl, String string3) {
        this.clearMsg();
        return null;
    }

    @Override
    public String[] getBLViewHandles(String string, int n, String string2) {
        this.clearMsg();
        String[] stringArray = new String[]{};
        return stringArray;
    }

    @Override
    public String[] getBLViewNames(String string, int n, String string2) {
        this.clearMsg();
        return new String[0];
    }

    @Override
    public String[] getBLViewNames(String string, String string2) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        if (jetUDatabase == null) {
            this.setError("getBLViewNames(\"" + string + ", " + string2 + "\")Invalid data source name.");
            return new String[0];
        }
        Vector vector = this.GetTableOrViewByResourceName(jetUDatabase, string2, Permissions.P_VISIBLE);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((UnifiedBusinessView)vector.get(i)).getQualifyDisplayName();
        }
        return stringArray;
    }

    @Override
    public String[] getBusinessNodeNames(String string, String string2, String string3) {
        this.clearMsg();
        JetUUniverse.setUniverse(this.cat);
        JetUDatabase jetUDatabase = this.getDatabase(string, this.cat);
        String[] stringArray = new String[]{};
        if (jetUDatabase == null) {
            this.setError("getBusinessNodeNames(\"" + string + "," + string2 + "\")Invalid data source name.");
            return stringArray;
        }
        Vector vector = this.GetTableOrViewByResourceName(jetUDatabase, string3, Permissions.P_VISIBLE);
        BLContainerImpl bLContainerImpl = null;
        for (int i = 0; i < vector.size(); ++i) {
            if (!((UnifiedBusinessView)vector.get(i)).getQualifyDisplayName().equalsIgnoreCase(string2)) continue;
            bLContainerImpl = (UnifiedBusinessView)vector.get(i);
            break;
        }
        if (bLContainerImpl != null) {
            BLNode[] bLNodeArray = bLContainerImpl.getBLChildren();
            String[] stringArray2 = new String[bLNodeArray.length];
            stringArray = new String[bLNodeArray.length];
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.hasPermission(string3, bLNodeArray[i])) continue;
                stringArray2[n] = bLNodeArray[i].getName();
                ++n;
            }
            System.arraycopy(stringArray2, 0, stringArray, 0, n);
        }
        return stringArray;
    }

    @Override
    public BLFilterInformation[] getBLFilterInfos(String string) {
        FilterInfo[] filterInfoArray;
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null && jetObject instanceof UnifiedBusinessView && (filterInfoArray = ((UnifiedBusinessView)jetObject).getPrefilterInfo()) != null) {
            BLFilterInformation[] bLFilterInformationArray = new BLFilterInformation[filterInfoArray.length];
            BLFilterInformation bLFilterInformation = null;
            for (int i = 0; i < filterInfoArray.length; ++i) {
                bLFilterInformationArray[i] = bLFilterInformation = this.getBLFilterInfo(filterInfoArray[i]);
            }
            return bLFilterInformationArray;
        }
        return null;
    }

    @Override
    public BLNodeInformation getBLNodeInformation(String string) {
        JetObject jetObject = (JetObject)this.handles.get(string);
        BLNodeInformation bLNodeInformation = null;
        if (jetObject != null) {
            return this.UQueryToPsqlTable(jetObject);
        }
        return bLNodeInformation;
    }

    @Override
    public BLNodeInformation[] getBLNodeInformations(String string, String string2) {
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject instanceof BLContainer) {
            BLNode[] bLNodeArray = ((BLContainer)((Object)jetObject)).getBLChildren();
            BLNodeInformation[] bLNodeInformationArray = new BLNodeInformation[bLNodeArray.length];
            int n = 0;
            for (int i = 0; i < bLNodeArray.length; ++i) {
                if (!this.hasPermission(string2, bLNodeArray[i])) continue;
                bLNodeInformationArray[n] = this.UQueryToPsqlTable((JetObject)((Object)bLNodeArray[i]));
                ++n;
            }
            BLNodeInformation[] bLNodeInformationArray2 = new BLNodeInformation[n];
            System.arraycopy(bLNodeInformationArray, 0, bLNodeInformationArray2, 0, n);
            return bLNodeInformationArray2;
        }
        return null;
    }

    private BLNodeInformation UQueryToPsqlTable(JetObject jetObject) {
        BLNodeInformation bLNodeInformation = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = -1;
        int n2 = -1;
        boolean bl = false;
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty("Description");
            if (jetObject instanceof BLNode) {
                BLNode bLNode = (BLNode)((Object)jetObject);
                if (jetObject instanceof CategoryInfo) {
                    string = bLNode.getBLQualifyName();
                    string2 = bLNode.getDisplayName();
                    string4 = bLNode.getQualifyDisplayName();
                    string3 = ((JetString)jetProperty).get();
                    n2 = 18;
                } else if (jetObject instanceof DimensionInfo) {
                    string = bLNode.getBLQualifyName();
                    string2 = bLNode.getDisplayName();
                    string4 = bLNode.getQualifyDisplayName();
                    string3 = ((JetString)jetProperty).get();
                    n = this.UTableToPsqlTable((DataElement)jetObject);
                    JetUResourceEntity jetUResourceEntity = this.getRefObj((DataElement)jetObject);
                    if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUFormula) {
                        bl = true;
                    }
                    n2 = jetObject instanceof Group ? 28 : 19;
                } else if (jetObject instanceof MeasureInfo) {
                    string = bLNode.getBLQualifyName();
                    string2 = bLNode.getDisplayName();
                    string4 = bLNode.getQualifyDisplayName();
                    string3 = ((JetString)jetProperty).get();
                    n = this.UTableToPsqlTable((DataElement)jetObject);
                    n2 = jetObject instanceof Aggregation ? 29 : 20;
                } else if (jetObject instanceof DetailInformation) {
                    string = bLNode.getBLQualifyName();
                    string2 = bLNode.getDisplayName();
                    string4 = bLNode.getQualifyDisplayName();
                    string3 = ((JetString)jetProperty).get();
                    n = this.UTableToPsqlTable((DataElement)jetObject);
                    JetUResourceEntity jetUResourceEntity = this.getRefObj((DataElement)jetObject);
                    if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUFormula) {
                        bl = true;
                    }
                    n2 = jetObject instanceof Detail ? 30 : 22;
                }
            }
            bLNodeInformation = new BLNodeInformation(string, string2, string3, n);
            bLNodeInformation.setIsFormula(bl);
            bLNodeInformation.setElementType(n2);
            bLNodeInformation.setHandle(jetObject.getQualifyName());
            bLNodeInformation.setQualifiedDisplayName(string4);
        }
        return bLNodeInformation;
    }

    private int UTableToPsqlTable(DataElement dataElement) {
        JetContainable jetContainable = dataElement.getParent();
        int n = -1;
        while (jetContainable != null && !((JetObject)((Object)jetContainable) instanceof JetUDatabase)) {
            jetContainable = ((JetObject)((Object)jetContainable)).getParent();
        }
        if (jetContainable == null) {
            return -1;
        }
        JetUResourceEntity jetUResourceEntity = ((JetUDatabase)jetContainable).getResourceByName(dataElement.getRefMappingName());
        if (jetUResourceEntity != null) {
            DbColDesc dbColDesc = jetUResourceEntity.getColDesc();
            if (dbColDesc != null) {
                n = dbColDesc.getSqlType();
            }
            if (dataElement instanceof MeasureInfo) {
                n = Types.getFuncSqlType(((MeasureInfo)((Object)dataElement)).getAggFunction(), n);
            }
        }
        return n;
    }

    @Override
    public JetUUniverse getCatalog() {
        return this.cat;
    }
}

