/*
 * Decompiled with CFR 0.152.
 */
package jet.api;

public class ParameterInfo {
    public static final int MIN = 0;
    public static final int MAX = 1;
    public static final int UNKNOWN = -1;
    public static final int BETWEEN = 1;
    String name;
    String desc;
    String prompt;
    String type;
    String format;
    String value;
    String[] values = new String[8];
    String[] limits = new String[2];
    String[] bindValues = new String[8];
    int valueLength = 0;
    int index;
    int operator;
    boolean isBindColumn = false;

    public ParameterInfo() {
    }

    public ParameterInfo(String string, String string2, String string3, String string4) {
        this.name = string;
        this.desc = string2;
        this.prompt = string3;
        this.type = "Decimal".equalsIgnoreCase(string4) ? "Number" : string4;
    }

    public ParameterInfo(String string, String string2, String[] stringArray, String string3) {
        this.name = string;
        this.value = string2;
        this.values = stringArray;
        this.prompt = string3;
        if (stringArray != null) {
            this.valueLength = stringArray.length;
        }
    }

    public ParameterInfo(String string, String string2, String[] stringArray, String[] stringArray2, String string3) {
        this.name = string;
        this.value = string2;
        this.values = stringArray;
        this.prompt = string3;
        this.bindValues = stringArray2;
        if (stringArray != null) {
            this.valueLength = stringArray.length;
        }
    }

    public ParameterInfo(String string, String string2, String string3, String string4, String string5, int n, int n2) {
        this(string, string2, string4, string3);
        this.format = string5;
        this.operator = n;
        this.index = n2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.desc;
    }

    public void setDescription(String string) {
        this.desc = string;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String string) {
        this.prompt = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = "Decimal".equalsIgnoreCase(string) ? "Number" : string;
    }

    public String[] getDefaultValues() {
        return this.values;
    }

    public void setDefaultValue(String string) {
        if (this.valueLength <= this.values.length) {
            String[] stringArray = new String[this.valueLength + 8];
            System.arraycopy(this.values, 0, stringArray, 0, this.valueLength);
            this.values = stringArray;
        }
        for (int i = 0; i < this.valueLength; ++i) {
            if (!this.values[i].equals(string)) continue;
            return;
        }
        if (string != null) {
            this.values[this.valueLength] = string;
            ++this.valueLength;
        }
    }

    public boolean deleteDefaultValue(String string) {
        boolean bl = false;
        int n = string.indexOf("GMT ");
        if (n >= 0) {
            string = new StringBuffer(string).replace(n, n + 4, "GMT+").toString();
        }
        for (int i = 0; i < this.valueLength; ++i) {
            if (!this.values[i].equals(string)) continue;
            bl = this.deleteDefaultValue(i);
            break;
        }
        return bl;
    }

    public boolean deleteDefaultValue(int n) {
        if (this.valueLength <= n || n < 0) {
            return false;
        }
        String[] stringArray = new String[this.valueLength - 1];
        System.arraycopy(this.values, 0, stringArray, 0, n);
        System.arraycopy(this.values, n + 1, stringArray, n, this.valueLength - n - 1);
        this.values = stringArray;
        --this.valueLength;
        return true;
    }

    public String[] getLimit() {
        return this.limits;
    }

    public String getLimit(int n) {
        if (n >= 0 && n < 2) {
            return this.limits[n];
        }
        return null;
    }

    public void setLimit(String string, int n) {
        if (n >= 0 && n < 2) {
            this.limits[n] = string;
        }
    }

    public boolean deleteLimit(String string) {
        boolean bl = false;
        for (int i = 0; i < 2; ++i) {
            if (this.limits[i] == null || !this.limits[i].equals(string)) continue;
            bl = this.deleteLimit(i);
        }
        return bl;
    }

    public boolean deleteLimit(int n) {
        if (n == 1 || n == 0) {
            this.limits[n] = null;
            return true;
        }
        return false;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public int getOperator() {
        return this.operator;
    }

    public void setOperator(int n) {
        this.operator = n;
    }

    public int getValueLength() {
        return this.valueLength;
    }

    public void clearDefaultValue() {
        this.values = new String[0];
        this.valueLength = 0;
    }

    public String[] getBindValues() {
        return this.bindValues;
    }

    public void setBindValues(String[] stringArray) {
        this.bindValues = stringArray;
    }

    public boolean getIsBindColumn() {
        return this.isBindColumn;
    }

    public void setIsBindColumn(boolean bl) {
        this.isBindColumn = bl;
    }
}

