/*
 * Decompiled with CFR 0.152.
 */
package jet.api;

import jet.api.SortInfo;

public class ReportSortInfo {
    boolean needTopN;
    int topN;
    int length;
    SortInfo[] sortInfo;

    public ReportSortInfo(boolean bl, int n) {
        this.needTopN = bl;
        this.topN = n;
    }

    public ReportSortInfo(boolean bl, int n, SortInfo[] sortInfoArray) {
        this.needTopN = bl;
        this.topN = n;
        this.setSortInfo(sortInfoArray);
    }

    public boolean getNeedTopN() {
        return this.needTopN;
    }

    public int getTopN() {
        return this.topN;
    }

    public void setTopN(int n) {
        this.topN = n;
    }

    public void setNeedTopN(boolean bl) {
        this.needTopN = bl;
    }

    public void setSortInfo(SortInfo[] sortInfoArray) {
        if (sortInfoArray == null || sortInfoArray.length == 0) {
            this.sortInfo = null;
            this.length = 0;
        } else {
            this.sortInfo = sortInfoArray;
            this.length = sortInfoArray.length;
        }
    }

    public void addSortInfo(SortInfo sortInfo) {
        this.insertSortInfo(sortInfo, this.length);
    }

    public boolean insertSortInfo(SortInfo sortInfo, int n) {
        if (n >= 0 && n <= this.length) {
            if (this.sortInfo == null) {
                this.sortInfo = new SortInfo[4];
            }
            if (this.sortInfo.length == this.length) {
                SortInfo[] sortInfoArray = new SortInfo[this.length + this.length];
                System.arraycopy(this.sortInfo, 0, sortInfoArray, 0, this.length);
                this.sortInfo = sortInfoArray;
            }
            if (n == this.length) {
                this.sortInfo[this.length++] = sortInfo;
            } else {
                System.arraycopy(this.sortInfo, n, this.sortInfo, n + 1, this.length - n);
                this.sortInfo[n] = sortInfo;
                ++this.length;
            }
            return true;
        }
        return false;
    }

    public void removeSortInfo(SortInfo sortInfo) {
        this.removeSortInfo(this.indexOfSortInfo(sortInfo));
    }

    public void removeSortInfo(String string) {
        this.removeSortInfo(this.indexOfSortInfo(string));
    }

    public void removeSortInfo(int n) {
        if (n >= 0 && n < this.length) {
            if (n < this.length - 1) {
                System.arraycopy(this.sortInfo, n + 1, this.sortInfo, n, this.length - n - 1);
            }
            --this.length;
            if (this.length < this.sortInfo.length / 2) {
                SortInfo[] sortInfoArray = new SortInfo[this.length + 1];
                System.arraycopy(this.sortInfo, 0, sortInfoArray, 0, this.length);
                this.sortInfo = sortInfoArray;
            }
        }
    }

    public int indexOfSortInfo(String string) {
        int n = this.length;
        while (--n >= 0) {
            if (!string.equalsIgnoreCase(this.sortInfo[n].getSortBy())) continue;
            return n;
        }
        return -1;
    }

    public int indexOfSortInfo(SortInfo sortInfo) {
        int n = this.length;
        while (--n >= 0) {
            if (sortInfo != this.sortInfo[n]) continue;
            return n;
        }
        return -1;
    }

    public void upSortInfo(int n) {
        if (n > 0 && n < this.length) {
            SortInfo sortInfo = this.sortInfo[n];
            this.sortInfo[n] = this.sortInfo[n - 1];
            this.sortInfo[n - 1] = sortInfo;
        }
    }

    public void downSortInfo(int n) {
        if (n >= 0 && n < this.length - 1) {
            SortInfo sortInfo = this.sortInfo[n];
            this.sortInfo[n] = this.sortInfo[n + 1];
            this.sortInfo[n + 1] = sortInfo;
        }
    }

    public boolean isSortIn(String string) {
        int n = this.length;
        while (--n >= 0) {
            if (!string.equalsIgnoreCase(this.sortInfo[n].getSortBy())) continue;
            return true;
        }
        return false;
    }

    public SortInfo[] getSortInfo() {
        SortInfo[] sortInfoArray = new SortInfo[this.length];
        if (this.length > 0) {
            System.arraycopy(this.sortInfo, 0, sortInfoArray, 0, this.length);
        }
        return sortInfoArray;
    }
}

