/*
 * Decompiled with CFR 0.152.
 */
package jet.api;

import java.util.Hashtable;
import jet.universe.JetUDBTreeNode;

class Resources {
    int length = 0;
    JetUDBTreeNode[] rscs = new JetUDBTreeNode[4];
    Hashtable info = new Hashtable();

    public void add(JetUDBTreeNode jetUDBTreeNode) {
        this.insert(jetUDBTreeNode, this.length);
    }

    public JetUDBTreeNode remove(JetUDBTreeNode jetUDBTreeNode) {
        return this.remove(this.indexOf(jetUDBTreeNode)) ? jetUDBTreeNode : null;
    }

    public boolean remove(int n) {
        if (n >= 0 && n < this.length) {
            JetUDBTreeNode jetUDBTreeNode = this.rscs[n];
            this.info.remove(jetUDBTreeNode.getResourceName());
            if (n < this.length - 1) {
                System.arraycopy(this.rscs, n + 1, this.rscs, n, this.length - n);
            }
            --this.length;
            return true;
        }
        return false;
    }

    public boolean insert(JetUDBTreeNode jetUDBTreeNode, int n) {
        if (this.info.get(jetUDBTreeNode.getResourceName().toUpperCase()) == null && n >= 0 && n <= this.length) {
            if (this.rscs == null) {
                this.rscs = new JetUDBTreeNode[4];
            }
            if (this.rscs.length == this.length) {
                JetUDBTreeNode[] jetUDBTreeNodeArray = new JetUDBTreeNode[this.length == 0 ? 4 : this.length + this.length];
                System.arraycopy(this.rscs, 0, jetUDBTreeNodeArray, 0, this.length);
                this.rscs = jetUDBTreeNodeArray;
            }
            if (n != this.length) {
                System.arraycopy(this.rscs, n, this.rscs, n + 1, this.length - n);
                this.rscs[n] = jetUDBTreeNode;
                ++this.length;
            } else {
                this.rscs[this.length++] = jetUDBTreeNode;
            }
            this.info.put(jetUDBTreeNode.getResourceName().toUpperCase(), jetUDBTreeNode);
            return true;
        }
        return false;
    }

    public boolean set(JetUDBTreeNode jetUDBTreeNode, int n) {
        if (n >= 0 && n < this.length) {
            this.rscs[n] = jetUDBTreeNode;
            this.info.put(jetUDBTreeNode.getResourceName().toUpperCase(), jetUDBTreeNode);
            return true;
        }
        if (n == this.length) {
            this.add(jetUDBTreeNode);
            return true;
        }
        return false;
    }

    public JetUDBTreeNode get(int n) {
        if (n >= 0 && n < this.length) {
            return this.rscs[n];
        }
        return null;
    }

    public int getLength() {
        return this.length;
    }

    public int indexOf(JetUDBTreeNode jetUDBTreeNode) {
        int n = this.length;
        while (--n >= 0) {
            if (jetUDBTreeNode != this.rscs[n]) continue;
            return n;
        }
        return -1;
    }

    public void clear() {
        this.rscs = new JetUDBTreeNode[4];
        this.info.clear();
    }
}

