/*
 * Decompiled with CFR 0.152.
 */
package jet.bean;

import java.io.File;
import java.sql.SQLException;
import java.util.Vector;
import jet.ReportEnv;
import jet.bean.JRCatalogException;
import jet.jetc.ReadFailureException;
import jet.jetc.WriteFailureException;
import jet.log.JRLogger;
import jet.log.JRLoggingUtil;
import jet.universe.ConnectionDesc;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUFileQuery;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUUniverse;
import jet.universe.JetUWherePortion;
import jet.universe.exception.AddTableViewException;
import jet.universe.exception.FMLFileException;
import jet.universe.exception.UniverseFileException;
import jet.universe.psql.BadFileQueryException;
import jet.universe.psql.FileQuery;

public class JRCatalog {
    public static final int vOff = 0;
    public static final int vDebug = 1;
    public static final int vError = 4;
    public static final int TYPE_TABLE = 1;
    public static final int TYPE_VIEW = 2;
    private String BuildDefaultUniverse = "";
    private String GetFileQueryByResourceName = "";
    protected boolean bInitialized = false;
    protected JetUUniverse unvs = null;
    protected JetUDatabase udb = null;
    private static JRLogger IsConnectionNameOK = JRLogger.getLogger(JRCatalog.class.getName());

    protected void initialize() throws JRCatalogException {
        String string = ReportEnv.checkEnv(this.BuildDefaultUniverse);
        if (string != null) {
            throw new JRCatalogException(0, string);
        }
        this.bInitialized = true;
    }

    public String getReportHome() {
        return this.BuildDefaultUniverse;
    }

    public void setReportHome(String string) {
        this.BuildDefaultUniverse = string;
    }

    public void setCatName(String string) {
        this.GetFileQueryByResourceName = string;
        if (string != null) {
            if (!string.endsWith(".cat")) {
                this.GetFileQueryByResourceName = this.GetFileQueryByResourceName + ".cat";
            }
            this.GetFileQueryByResourceName = new File(this.GetFileQueryByResourceName).getAbsolutePath();
        }
    }

    public String getCatName() {
        return this.GetFileQueryByResourceName;
    }

    JetUUniverse getCatalog() {
        return this.unvs;
    }

    public void newCatalog() throws JRCatalogException {
        if (!this.bInitialized) {
            this.initialize();
        }
        if (this.GetFileQueryByResourceName == null || this.GetFileQueryByResourceName.equals("")) {
            throw new JRCatalogException(1);
        }
        if (!JetUUniverse.canCreateCatalog(this.GetFileQueryByResourceName)) {
            throw new JRCatalogException(2);
        }
        this.unvs = JetUUniverse.BuildDefaultUniverse(this.GetFileQueryByResourceName);
        this.udb = this.unvs.getDatabase();
        this.saveCatalog();
    }

    public void loadCatalog() throws JRCatalogException {
        if (!this.bInitialized) {
            this.initialize();
        }
        if (this.GetFileQueryByResourceName == null || this.GetFileQueryByResourceName.equals("")) {
            throw new JRCatalogException(1);
        }
        try {
            this.unvs = JetUUniverse.LoadUniverse(this.GetFileQueryByResourceName);
            this.udb = this.unvs.getDatabase();
        }
        catch (ReadFailureException readFailureException) {
            throw new JRCatalogException(3, readFailureException.getMessage());
        }
        catch (UniverseFileException universeFileException) {
            throw new JRCatalogException(3, universeFileException.getMessage());
        }
    }

    public void saveCatalog() throws JRCatalogException {
        if (this.unvs == null) {
            throw new JRCatalogException(5);
        }
        try {
            this.unvs.Save();
        }
        catch (WriteFailureException writeFailureException) {
            throw new JRCatalogException(4, writeFailureException.getMessage());
        }
        catch (FMLFileException fMLFileException) {
            throw new JRCatalogException(4, fMLFileException.getMessage());
        }
    }

    public void saveCatalogAs(String string) throws JRCatalogException {
        if (this.unvs == null) {
            throw new JRCatalogException(5);
        }
        try {
            if (string == null) {
                throw new JRCatalogException(1);
            }
            if (!string.endsWith(".cat")) {
                string = string + ".cat";
            }
            File file = new File(string);
            this.unvs.Save(file.getParent(), file.getName());
        }
        catch (WriteFailureException writeFailureException) {
            throw new JRCatalogException(4, writeFailureException.getMessage());
        }
        catch (FMLFileException fMLFileException) {
            throw new JRCatalogException(4, fMLFileException.getMessage());
        }
    }

    public void closeCatalog() {
        if (this.unvs != null) {
            this.unvs.clearMem();
            this.unvs = null;
        }
    }

    public void addWherePortion(String string, String string2, String string3) throws JRCatalogException {
        if (this.unvs == null) {
            throw new JRCatalogException(5);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.udb.IsWherePortionNameOK(string, stringBuffer)) {
            throw new JRCatalogException(6, stringBuffer.toString());
        }
        JetUWherePortion jetUWherePortion = new JetUWherePortion(string, "", string3);
        jetUWherePortion.setQueryName(string2);
        this.udb.addWherePortion(jetUWherePortion);
    }

    public void addWherePortion(String string, String string2, Vector vector) throws JRCatalogException {
        if (this.unvs == null) {
            throw new JRCatalogException(5);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.udb.IsWherePortionNameOK(string, stringBuffer)) {
            throw new JRCatalogException(6, stringBuffer.toString());
        }
        JetUWherePortion jetUWherePortion = new JetUWherePortion(string, "", vector);
        jetUWherePortion.setQueryName(string2);
        this.udb.addWherePortion(jetUWherePortion);
    }

    public void modifyWherePortion(String string, String string2, String string3) throws JRCatalogException {
        if (this.unvs == null) {
            throw new JRCatalogException(5);
        }
        JetUWherePortion jetUWherePortion = this.udb.getWherePortionByResourceName(string);
        if (jetUWherePortion == null) {
            throw new JRCatalogException(7);
        }
        jetUWherePortion.setWherePortion(string3);
        jetUWherePortion.setQueryName(string2);
    }

    public void modifyWherePortion(String string, String string2, Vector vector) throws JRCatalogException {
        if (this.unvs == null) {
            throw new JRCatalogException(5);
        }
        JetUWherePortion jetUWherePortion = this.udb.getWherePortionByResourceName(string);
        if (jetUWherePortion == null) {
            throw new JRCatalogException(7);
        }
        jetUWherePortion.setGroups(vector);
        jetUWherePortion.setQueryName(string2);
    }

    public void deleteWherePortion(String string) throws JRCatalogException {
        if (this.unvs == null) {
            throw new JRCatalogException(5);
        }
        JetUWherePortion jetUWherePortion = this.udb.getWherePortionByResourceName(string);
        if (jetUWherePortion == null) {
            throw new JRCatalogException(7);
        }
        this.udb.removeWherePortion(jetUWherePortion);
    }

    public String getWherePortionsSQL(String string) throws JRCatalogException {
        if (this.unvs == null) {
            throw new JRCatalogException(5);
        }
        JetUWherePortion jetUWherePortion = this.udb.getWherePortionByResourceName(string);
        if (jetUWherePortion == null) {
            throw new JRCatalogException(7);
        }
        return jetUWherePortion.getWherePortion();
    }

    public void addFileQuery(String string, File file) throws JRCatalogException {
        if (this.unvs == null) {
            throw new JRCatalogException(5);
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        JetUConnection jetUConnection = this.udb.getConnection();
        if (jetUConnection == null) {
            throw new JRCatalogException(13);
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        if (!this.udb.IsFileQueryNameOK(string, stringBuffer2)) {
            throw new JRCatalogException(11);
        }
        try {
            FileQuery fileQuery = FileQuery.createFileQuery(file.getPath(), this.unvs, null, null, null, null);
            jetUConnection.addFileQuery(string, fileQuery);
        }
        catch (BadFileQueryException badFileQueryException) {
            throw new JRCatalogException(12, badFileQueryException.getMessage());
        }
    }

    public Vector addTableViews(String string, String string2, String string3, int n) throws JRCatalogException {
        if (this.unvs == null) {
            throw new JRCatalogException(5);
        }
        Vector vector = null;
        try {
            vector = this.unvs.addTableViews(string, this.udb.getResourceName(), string2, string3, n);
        }
        catch (AddTableViewException addTableViewException) {
            switch (addTableViewException.getErrorType()) {
                case 0: {
                    throw new JRCatalogException(15, addTableViewException.getMessage());
                }
                case 1: {
                    throw new JRCatalogException(17);
                }
                case 2: {
                    throw new JRCatalogException(13);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JRCatalogException(10, classNotFoundException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new JRCatalogException(10, sQLException.getMessage());
        }
        return vector;
    }

    public void deleteFileQuery(String string) throws JRCatalogException {
        if (this.unvs == null) {
            throw new JRCatalogException(5);
        }
        JetUConnection jetUConnection = this.udb.getConnection();
        if (jetUConnection == null) {
            throw new JRCatalogException(13);
        }
        JetUFileQuery jetUFileQuery = jetUConnection.GetFileQueryByResourceName(string);
        if (jetUFileQuery == null) {
            throw new JRCatalogException(14);
        }
        jetUConnection.removeFileQuery(jetUFileQuery);
    }

    public String getFileQuerySQL(String string) throws JRCatalogException {
        if (this.unvs == null) {
            throw new JRCatalogException(5);
        }
        JetUConnection jetUConnection = this.udb.getConnection();
        if (jetUConnection == null) {
            throw new JRCatalogException(13);
        }
        JetUFileQuery jetUFileQuery = jetUConnection.GetFileQueryByResourceName(string);
        if (jetUFileQuery == null) {
            throw new JRCatalogException(14);
        }
        return jetUFileQuery.getSQLString();
    }

    public boolean removeSFDataSource(String string) throws JRCatalogException {
        if (this.unvs == null) {
            throw new JRCatalogException(5);
        }
        return this.udb.removeDataSource(string);
    }

    public void addConnection(ConnectionDesc connectionDesc) throws JRCatalogException {
        if (this.unvs == null) {
            throw new JRCatalogException(5);
        }
        if (this.udb.getConnections().size() > 0) {
            throw new JRCatalogException(8);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.udb.IsConnectionNameOK(connectionDesc.strName, stringBuffer)) {
            throw new JRCatalogException(9);
        }
        try {
            JetUJDBCConnection jetUJDBCConnection = new JetUJDBCConnection(connectionDesc.strName, "", connectionDesc.strURL, connectionDesc.strUser, connectionDesc.strPassword, 0, connectionDesc.strDriver);
            this.udb.addConnection(jetUJDBCConnection);
        }
        catch (SQLException sQLException) {
            throw new JRCatalogException(10, sQLException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JRCatalogException(10, classNotFoundException.getMessage());
        }
    }

    public void modifyConnection(ConnectionDesc connectionDesc) throws JRCatalogException {
        this.modifyConnection(connectionDesc, true);
    }

    public void modifyConnection(ConnectionDesc connectionDesc, boolean bl) throws JRCatalogException {
        if (this.unvs == null) {
            throw new JRCatalogException(5);
        }
        JetUJDBCConnection jetUJDBCConnection = (JetUJDBCConnection)this.udb.getConnection();
        if (jetUJDBCConnection == null) {
            throw new JRCatalogException(13);
        }
        jetUJDBCConnection.setResourceName(connectionDesc.strName);
        jetUJDBCConnection.setURL(connectionDesc.strURL);
        jetUJDBCConnection.setUID(connectionDesc.strUser);
        jetUJDBCConnection.setPSWD(connectionDesc.strPassword);
        jetUJDBCConnection.setJdbcDriver(connectionDesc.strDriver);
        if (bl) {
            try {
                jetUJDBCConnection.fetchSupportInfo();
            }
            catch (SQLException sQLException) {
                throw new JRCatalogException(10, sQLException.getMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JRCatalogException(10, classNotFoundException.getMessage());
            }
        }
    }

    public void modifyUserInfo(String string, String string2) throws JRCatalogException {
        if (string == null || string2 == null) {
            throw new JRCatalogException(16);
        }
        if (this.unvs == null) {
            throw new JRCatalogException(5);
        }
        JetUJDBCConnection jetUJDBCConnection = (JetUJDBCConnection)this.udb.getConnection();
        if (jetUJDBCConnection == null) {
            throw new JRCatalogException(13);
        }
        jetUJDBCConnection.setUID(string);
        jetUJDBCConnection.setPSWD(string2);
    }

    public void deleteConnection() throws JRCatalogException {
        if (this.unvs == null) {
            throw new JRCatalogException(5);
        }
        JetUJDBCConnection jetUJDBCConnection = (JetUJDBCConnection)this.udb.getConnection();
        if (jetUJDBCConnection == null) {
            throw new JRCatalogException(13);
        }
        this.udb.removeConnection(jetUJDBCConnection);
    }

    public ConnectionDesc getConnectionDesc() throws JRCatalogException {
        if (this.unvs == null) {
            throw new JRCatalogException(5);
        }
        ConnectionDesc connectionDesc = null;
        JetUJDBCConnection jetUJDBCConnection = (JetUJDBCConnection)this.udb.getConnection();
        if (jetUJDBCConnection != null) {
            connectionDesc = new ConnectionDesc();
            connectionDesc.strName = jetUJDBCConnection.getResourceName();
            connectionDesc.strURL = jetUJDBCConnection.getURL();
            connectionDesc.strUser = jetUJDBCConnection.getUID();
            connectionDesc.strDriver = jetUJDBCConnection.getJdbcDriver();
            return connectionDesc;
        }
        return null;
    }

    public void setShowInfoLevel(int n) {
        JRLogger.setDebugLevel(n);
    }

    public boolean setLogFile(String string) {
        return JRLoggingUtil.configLog(string);
    }

    public void setCurrentDataSource(String string) {
        this.udb = this.unvs.getDatabase(string);
    }
}

