/*
 * Decompiled with CFR 0.152.
 */
package jet.client.api;

import guitools.swing.dialog.ShowMessageDialog;
import guitools.toolkit.JDebug;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import jet.Env;
import jet.JCliResource;
import jet.client.ClientUtil;
import jet.client.api.APIUtil;
import jet.client.api.Active;
import jet.client.api.BaseJRClient;
import jet.client.api.Completed;
import jet.client.api.JRResponseException;
import jet.client.api.NodeInfo;
import jet.client.api.NodeProp;
import jet.client.api.ResourcePathInfo;
import jet.client.api.TimeoutException;
import jet.client.api.VersionRecord;
import jet.client.api.misc.DownloadNodeInfo;
import jet.client.api.misc.JCliCompletedPublishRecord;
import jet.client.api.misc.JCliCompletedResultRecord;
import jet.client.api.misc.JReportClientRunner;
import jet.client.api.misc.ScriptFileSubmitView;
import jet.cs.CSMail;
import jet.cs.CSUtil;
import jet.cs.CustomTaskManager;
import jet.cs.JRMail;
import jet.cs.Param;
import jet.cs.ParamCanceledException;
import jet.cs.ParseParamValuesException;
import jet.cs.RptSheet;
import jet.cs.ui.ParamsDialog;
import jet.cs.ui.ParamsTookit;
import jet.cs.util.APIConst;
import jet.net2.URL;
import jet.net2.www.protocol.http.HttpURLConnection;
import jet.util.EncodingSupport;

public class JRClient
extends BaseJRClient {
    private static final int INFO = 0;
    private static final int P_TASK_DISK = 1;
    private static final int P_TASK_MAIL = 2;

    public static void setShowInfoLevel(int n) {
        int n2 = 0;
        JDebug.setDebugLevel(n2 |= n);
    }

    public static boolean setLogFile(String string) {
        boolean bl = true;
        if (string == null) {
            JDebug.setLog(string);
            return bl;
        }
        if (string.equals("")) {
            string = "JReport.log";
        } else {
            int n = string.lastIndexOf("\\");
            String string2 = string.substring(n + 1, string.length());
            if (string2.equals("")) {
                string = string.substring(0, n) + "\\" + "JReport.log";
            }
        }
        JDebug.setLog(string);
        return bl;
    }

    public static boolean getKeepAlive() {
        return BaseJRClient.getKeepAlive();
    }

    public static void setKeepAlive(boolean bl) {
        BaseJRClient.setKeepAlive(bl);
    }

    public static boolean ifUsePostAsDefaultMethod() {
        return usePost;
    }

    public static void useGetAsDefaultMethod() {
        usePost = false;
    }

    public static void usePostAsDefaultMethod() {
        usePost = true;
    }

    public static void close(URLConnection uRLConnection) {
        BaseJRClient.close(uRLConnection);
    }

    public static URLConnection openConnection(Frame frame, String string) throws MalformedURLException, IOException {
        int n = string.indexOf("?");
        String string2 = CSUtil.replWithEsc(string.substring(0, n), ".=_-|;&<>$/:?\"") + string.substring(n);
        java.net.URL uRL = new java.net.URL(string2);
        return JRClient.openConnection(frame, uRL);
    }

    public static URLConnection openConnection(Frame frame, java.net.URL uRL) throws IOException {
        URLConnection uRLConnection = JRClient.getConnection(uRL);
        return JRClient.openConnection(frame, uRLConnection);
    }

    public static URLConnection openConnection(Frame frame, URLConnection uRLConnection) throws IOException {
        return JRClient.openConnection(frame, uRLConnection, true);
    }

    public static URLConnection openConnection(Frame frame, URLConnection uRLConnection, boolean bl) throws IOException {
        return JRClient.openConnection(frame, uRLConnection, bl, false);
    }

    public static String getCurrentUser(Frame frame, String string) {
        String string2 = null;
        try {
            String string3 = string;
            int n = string3.indexOf("?");
            if (n > 0) {
                string3 = string3.substring(0, n);
            }
            string3 = string3 + "?jrs.cmd=jrs.get_current_user";
            URLConnection uRLConnection = JRClient.openConnection(frame, string3);
            APIUtil.checkResponseOK(uRLConnection);
            string2 = uRLConnection.getHeaderField("jrs.currentuser");
        }
        catch (MalformedURLException malformedURLException) {
            JDebug.WARNING(malformedURLException);
        }
        catch (ProtocolException protocolException) {
            JDebug.WARNING(protocolException);
        }
        catch (IOException iOException) {
            JDebug.WARNING(iOException);
        }
        catch (JRResponseException jRResponseException) {
            JDebug.WARNING(jRResponseException);
        }
        return string2;
    }

    public static String getUser() {
        return BaseJRClient.getUser();
    }

    public static void setUser(String string) {
        BaseJRClient.setUser(string);
    }

    public static void setPassword(String string) {
        BaseJRClient.setPassword(string);
    }

    public static String getPassword() {
        return BaseJRClient.getPassword();
    }

    public static void setProxyUser(String string) {
        _proxyUser = string;
        if (string == null) {
            _proxyUser = "";
        }
        _reset = true;
    }

    public static void setProxyPassword(String string) {
        _proxyPassword = string;
        if (string == null) {
            _proxyPassword = "";
        }
        _reset = true;
    }

    private static void clear() {
        _realm = null;
        _user = "";
        _pswd = "";
    }

    public static void setSocketTimeout(int n) {
        BaseJRClient.setSocketTimeout(n);
    }

    public static int getSocketTimeout() {
        return BaseJRClient.getSocketTimeout();
    }

    public static void setProxy(String string, String string2) throws Exception {
        BaseJRClient.setProxy(string, string2);
    }

    public static String getProxyHost() {
        String string = useSSL ? System.getProperty("https.proxyHost") : System.getProperty("http.proxyHost");
        return string;
    }

    public static String getProxyPort() {
        String string = useSSL ? System.getProperty("https.proxyPort") : System.getProperty("http.proxyPort");
        return string;
    }

    public static URLConnection getConnection(java.net.URL uRL) throws IOException {
        URLConnection uRLConnection = new URL(uRL).openConnection();
        if (uRLConnection != null) {
            BaseJRClient.setUserAgent(uRLConnection);
        }
        if (usePost && uRLConnection instanceof java.net.HttpURLConnection) {
            java.net.HttpURLConnection httpURLConnection = (java.net.HttpURLConnection)uRLConnection;
            httpURLConnection.setRequestMethod("POST");
        }
        return uRLConnection;
    }

    public static void login(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        BaseJRClient.login(frame, string);
    }

    public static void login(Frame frame, String string, String string2, String string3) throws MalformedURLException, IOException, JRResponseException {
        if (_user != null && !_user.equals("")) {
            try {
                JRClient.logout(string);
            }
            catch (Exception exception) {
                JDebug.WARNING(exception);
            }
        }
        JRClient.setUser(string2);
        JRClient.setPassword(string3);
        JRClient.login(frame, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logout(String string) throws MalformedURLException, IOException, JRResponseException {
        String string2 = APIUtil.formatServerURL(string);
        int n = string2.indexOf("?");
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        string2 = string2 + "?jrs.cmd=jrs.logout";
        try {
            URLConnection uRLConnection = JRClient.openConnection(null, JRClient.getConnection(new java.net.URL(string2)), true, true);
            APIUtil.checkResponseOK(uRLConnection);
            if (uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).removeAuthInfoFromCache(_realm);
            }
            JRClient.close(uRLConnection);
        }
        finally {
            JRClient.clear();
        }
    }

    public static boolean isWaitUser(String string) throws MalformedURLException, IOException, JRResponseException {
        String string2 = APIUtil.formatServerURL(string);
        int n = string2.indexOf("?");
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        URLConnection uRLConnection = JRClient.openConnection(null, JRClient.getConnection(new java.net.URL(string2 + "?" + "jrs.cmd" + "=" + "jrs.is_wait_user")), true, true);
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string3 = bufferedReader.readLine();
        if (string3 == null) {
            return false;
        }
        return string3.indexOf("isWaitUser=true") >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSplitPDF(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        boolean bl = false;
        String string2 = "?jrs.cmd=jrs.is_split_pdf";
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string2, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string3 = null;
        try {
            string3 = bufferedReader.readLine();
            if (string3 != null) {
                bl = CSUtil.getBoolean(string3);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return bl;
    }

    public static Properties getMailConfigInfo(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException, ClassNotFoundException {
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.mail_config_info");
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        ObjectInputStream objectInputStream = new ObjectInputStream(uRLConnection.getInputStream());
        Properties properties = (Properties)objectInputStream.readObject();
        objectInputStream.close();
        JRClient.close(uRLConnection);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getScheduleFiles(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        Vector<String> vector;
        block10: {
            vector = null;
            String string2 = "?jrs.cmd=jrs.get_schedule_files";
            String string3 = string + string2;
            java.net.URL uRL = new java.net.URL(string3);
            URLConnection uRLConnection = null;
            uRLConnection = JRClient.openConnection(frame, string3);
            APIUtil.checkResponseOK(uRLConnection);
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                String string4 = bufferedReader.readLine();
                int n = Integer.parseInt(string4);
                if (n <= 0) break block10;
                vector = new Vector<String>(n);
                int n2 = 0;
                while (n2 < n) {
                    string4 = bufferedReader.readLine();
                    if (string4 == null) {
                        break;
                    }
                    vector.addElement(string4);
                }
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {
                        JDebug.WARNING(exception);
                    }
                }
            }
        }
        return vector;
    }

    public static void exportTasks(String string, String string2, String string3) throws MalformedURLException, IOException, JRResponseException {
        String string4 = APIUtil.formatServerURL(string);
        int n = string4.indexOf("?");
        if (n > 0) {
            string4 = string4.substring(0, n);
        }
        URLConnection uRLConnection = JRClient.openConnection(null, JRClient.getConnection(new java.net.URL(string4 + "?" + "jrs.cmd" + "=" + "jrs.export_schedule_to_file" + "&exportfile=" + string2 + "&d1=" + CSUtil.replWithEsc(string3))), true, true);
        APIUtil.checkResponseOK(uRLConnection);
        JRClient.close(uRLConnection);
    }

    public static void importTasks(String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        String string3 = APIUtil.formatServerURL(string);
        int n = string3.indexOf("?");
        if (n > 0) {
            string3 = string3.substring(0, n);
        }
        URLConnection uRLConnection = JRClient.openConnection(null, JRClient.getConnection(new java.net.URL(string3 + "?" + "jrs.cmd" + "=" + "jrs.import_schedule_from_file" + "&importfile=" + string2)), true, true);
        APIUtil.checkResponseOK(uRLConnection);
        JRClient.close(uRLConnection);
    }

    public static String importScriptTask(File file, String string) throws MalformedURLException, IOException, JRResponseException {
        String string2 = null;
        if (file.isFile()) {
            ScriptFileSubmitView scriptFileSubmitView = new ScriptFileSubmitView(file, JRClient.getUser(), string);
            string2 = scriptFileSubmitView.getOutMessage();
        } else {
            string2 = "no this file: " + file.toString();
        }
        return string2;
    }

    public static boolean hasPermissionOk(Frame frame, String string, String string2, String string3) throws MalformedURLException, IOException, JRResponseException {
        String string4;
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.export_permission_is");
        hashtable.put("jrs.catalog", string2);
        hashtable.put("jrs.report", string3);
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        String string5 = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        int n = uRLConnection.getContentLength();
        for (int i = 0; (n < 0 || i < n) && null != (string4 = bufferedReader.readLine()); i += string4.length() + 2) {
            string5 = string4;
        }
        JRClient.close(uRLConnection);
        return CSUtil.getBoolean(string5, false);
    }

    public static void changePassword(Frame frame, String string, String string2, String string3, String string4, String string5) throws MalformedURLException, IOException, JRResponseException {
        BaseJRClient.changePassword(frame, string, string2, string3, string4, string5);
    }

    public static void deleteVersion(Frame frame, String string, String string2, Properties properties) throws MalformedURLException, IOException, JRResponseException {
        JRClient.deleteRstVersion(frame, string, string2, null, properties);
    }

    public static void deleteRstVersion(Frame frame, String string, String string2, String string3, Properties properties) throws MalformedURLException, IOException, JRResponseException {
        if (properties == null) {
            properties = new Properties();
        }
        if (string3 == null) {
            string3 = "";
        }
        boolean bl = false;
        String string4 = "?jrs.cmd=jrs.del_rst_ver&jrs.version_id=" + CSUtil.replWithEsc(string2) + "&" + "jrs.report" + "=" + string3;
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string4, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        JRClient.close(uRLConnection);
    }

    public static void deleteRptVersion(Frame frame, String string, String string2, String string3) throws MalformedURLException, IOException, JRResponseException {
        if (string3 == null) {
            string3 = "";
        }
        boolean bl = false;
        String string4 = "?jrs.cmd=jrs.del_rpt_ver&jrs.version_id=" + CSUtil.replWithEsc(string2) + "&" + "jrs.report" + "=" + string3;
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, string4);
        APIUtil.checkResponseOK(uRLConnection);
        JRClient.close(uRLConnection);
    }

    public static void deleteRptVersion(Frame frame, String string, String string2, String string3, Properties properties) throws MalformedURLException, IOException, JRResponseException {
        if (properties == null) {
            properties = new Properties();
        }
        if (string3 == null) {
            string3 = "";
        }
        boolean bl = false;
        String string4 = "?jrs.cmd=jrs.del_rpt_ver&jrs.version_id=" + CSUtil.replWithEsc(string2) + "&" + "jrs.report" + "=" + string3;
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string4, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        JRClient.close(uRLConnection);
    }

    public static void deleteRstDocVersion(Frame frame, String string, String string2, String string3) throws MalformedURLException, IOException, JRResponseException {
        if (string3 == null) {
            string3 = "";
        }
        boolean bl = false;
        String string4 = "?jrs.cmd=jrs.del_rstdoc_ver&jrs.version_id=" + string2 + "&" + "jrs.result" + "=" + string3;
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string4, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        JRClient.close(uRLConnection);
    }

    public static void deleteCatVersion(Frame frame, String string, String string2, String string3, Properties properties) throws MalformedURLException, IOException, JRResponseException {
        if (properties == null) {
            properties = new Properties();
        }
        if (string3 == null) {
            string3 = "";
        }
        boolean bl = false;
        String string4 = "?jrs.cmd=jrs.del_cat_ver&jrs.version_id=" + CSUtil.replWithEsc(string2) + "&" + "jrs.catalog" + "=" + string3;
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string4, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        JRClient.close(uRLConnection);
    }

    public static void deleteTempResult(Frame frame, String string, String string2) {
        BaseJRClient.deleteTempResult(frame, string, string2);
    }

    public static String getCatalogOfReport(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.getResourcePathInfo(frame, string).getCatalog();
    }

    public static String getServletPath(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.getResourcePathInfo(frame, string).getServletPath();
    }

    public static ResourcePathInfo getResourcePathInfo(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        String string2 = CSUtil.replaceSubstrings(string, "%20", " ");
        URLConnection uRLConnection = JRClient.sendQuery(frame, string2, "?jrs.cmd=jrs.get_catalog_of_report");
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String[] stringArray = new String[]{"jrs.jrservlet_path=", "jrs.path=", "jrs.catalog=", "jrs.report="};
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n = uRLConnection.getContentLength();
        if (n > 0) {
            String string7;
            while (null != (string7 = bufferedReader.readLine())) {
                if (string7.startsWith(stringArray[0])) {
                    string3 = string7.substring(stringArray[0].length());
                    continue;
                }
                if (string7.startsWith(stringArray[1])) {
                    string4 = string7.substring(stringArray[1].length());
                    continue;
                }
                if (string7.startsWith(stringArray[2])) {
                    string5 = string7.substring(stringArray[2].length());
                    continue;
                }
                if (!string7.startsWith(stringArray[3])) continue;
                string6 = string7.substring(stringArray[3].length());
            }
        } else {
            String string8;
            for (int i = 0; i < n && null != (string8 = bufferedReader.readLine()); i += string8.length() + 2) {
                if (string8.startsWith(stringArray[0])) {
                    string3 = string8.substring(stringArray[0].length());
                    continue;
                }
                if (string8.startsWith(stringArray[1])) {
                    string4 = string8.substring(stringArray[1].length());
                    continue;
                }
                if (string8.startsWith(stringArray[2])) {
                    string5 = string8.substring(stringArray[2].length());
                    continue;
                }
                if (!string8.startsWith(stringArray[3])) continue;
                string6 = string8.substring(stringArray[3].length());
            }
        }
        JRClient.close(uRLConnection);
        return new ResourcePathInfo(string3, string4, string5, string6);
    }

    private static URLConnection INFO(Frame frame, String string, Hashtable hashtable) throws MalformedURLException, IOException {
        return JRClient.sendQuery(frame, string, CSUtil.makeQuery(hashtable));
    }

    public static void removeResource(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        if (string2 == null) {
            string2 = "";
        }
        boolean bl = false;
        String string3 = "?jrs.cmd=jrs.delete_resource&jrs.path=" + string2;
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string3, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        JRClient.close(uRLConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getAllUsers(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        String string3 = "?jrs.cmd=jrs.get_all_users&jrs.uid=" + string2;
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string3, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string4 = null;
        try {
            int n = uRLConnection.getContentLength();
            string4 = null;
            if (n > 0) {
                while (null != (string4 = bufferedReader.readLine())) {
                    stringBuffer.append(string4);
                }
            } else {
                for (int i = 0; i < n && null != (string4 = bufferedReader.readLine()); i += string4.length() + 2) {
                    stringBuffer.append(string4);
                }
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        String string5 = stringBuffer.substring(1, stringBuffer.length() - 1);
        Vector<String> vector = new Vector<String>();
        if (string5 == null || string5.length() <= 0) {
            return vector;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string5, ",", false);
        String string6 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string6 = stringTokenizer.nextToken();
            vector.addElement(string6.trim());
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getReferRoles(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        String string3 = "?jrs.cmd=jrs.get_refer_roles&jrs.uid=" + string2;
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string3, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string4 = null;
        try {
            int n = uRLConnection.getContentLength();
            string4 = null;
            if (n > 0) {
                while (null != (string4 = bufferedReader.readLine())) {
                    stringBuffer.append(string4);
                }
            } else {
                for (int i = 0; i < n && null != (string4 = bufferedReader.readLine()); i += string4.length() + 2) {
                    stringBuffer.append(string4);
                }
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        String string5 = stringBuffer.substring(1, stringBuffer.length() - 1);
        Vector<String> vector = new Vector<String>();
        if (string5 == null || string5.length() <= 0) {
            return vector;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string5, ",", false);
        String string6 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string6 = stringTokenizer.nextToken();
            vector.addElement(string6.trim());
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getReferGroups(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        String string3 = "?jrs.cmd=jrs.get_refer_groups&jrs.uid=" + string2;
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string3, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string4 = null;
        try {
            int n = uRLConnection.getContentLength();
            string4 = null;
            if (n > 0) {
                while (null != (string4 = bufferedReader.readLine())) {
                    stringBuffer.append(string4);
                }
            } else {
                for (int i = 0; i < n && null != (string4 = bufferedReader.readLine()); i += string4.length() + 2) {
                    stringBuffer.append(string4);
                }
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        String string5 = stringBuffer.substring(1, stringBuffer.length() - 1);
        Vector<String> vector = new Vector<String>();
        if (string5 == null || string5.length() <= 0) {
            return vector;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string5, ",", false);
        String string6 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string6 = stringTokenizer.nextToken();
            vector.addElement(string6.trim());
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getReferUsers(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        String string3 = "?jrs.cmd=jrs.get_refer_users&jrs.uid=" + string2;
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string3, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string4 = null;
        try {
            int n = uRLConnection.getContentLength();
            string4 = null;
            if (n > 0) {
                while (null != (string4 = bufferedReader.readLine())) {
                    stringBuffer.append(string4);
                }
            } else {
                for (int i = 0; i < n && null != (string4 = bufferedReader.readLine()); i += string4.length() + 2) {
                    stringBuffer.append(string4);
                }
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        String string5 = stringBuffer.substring(1, stringBuffer.length() - 1);
        Vector<String> vector = new Vector<String>();
        if (string5 == null || string5.length() <= 0) {
            return vector;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string5, ",", false);
        String string6 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string6 = stringTokenizer.nextToken();
            vector.addElement(string6.trim());
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getAllRoles(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        String string3 = "?jrs.cmd=jrs.get_all_roles&jrs.uid=" + string2;
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string3, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string4 = null;
        try {
            int n = uRLConnection.getContentLength();
            string4 = null;
            if (n > 0) {
                while (null != (string4 = bufferedReader.readLine())) {
                    stringBuffer.append(string4);
                }
            } else {
                for (int i = 0; i < n && null != (string4 = bufferedReader.readLine()); i += string4.length() + 2) {
                    stringBuffer.append(string4);
                }
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        String string5 = stringBuffer.substring(1, stringBuffer.length() - 1);
        Vector<String> vector = new Vector<String>();
        if (string5 == null || string5.length() <= 0) {
            return vector;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string5, ",", false);
        String string6 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string6 = stringTokenizer.nextToken();
            vector.addElement(string6.trim());
        }
        return vector;
    }

    public static void saveResourceProp(Frame frame, String string, Hashtable hashtable) throws MalformedURLException, IOException, JRResponseException {
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
        }
        hashtable.put("jrs.cmd", "jrs.save_node_prop");
        URLConnection uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        String string2 = uRLConnection.getHeaderField("errorMsg");
        JRClient.close(uRLConnection);
        if (string2 != null) {
            throw new IOException(string2);
        }
    }

    public static String sendCmdRunAndView(Frame frame, String string, Hashtable hashtable) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.sendCmdRunAndView(frame, string, hashtable, null, null);
    }

    public static String sendCmdRunAndView(Frame frame, String string, Hashtable hashtable, String string2, String string3) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.sendCmdRunAndView(frame, string, hashtable, string2, string3, null, null);
    }

    public static String sendCmdRunAndView(Frame frame, String string, Hashtable hashtable, String string2, String string3, String string4, String string5) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.sendCmdRunAndView(frame, string, hashtable, string2, string3, null, string4, string5);
    }

    public static String sendCmdRunAndView(Frame frame, String string, Hashtable hashtable, String string2, String string3, String string4, String string5, String string6) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.sendCmdRunAndView(frame, string, hashtable, string2, string3, string4, string5, string6, null, null);
    }

    public static String sendCmdRunAndView(Frame frame, String string, Hashtable hashtable, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.sendCmdRunAndView(frame, string, hashtable, string2, string3, string4, string5, string6, null, null, string7, string8);
    }

    public static String sendCmdRunAndView(Frame frame, String string, Hashtable hashtable, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.sendCmdRunAndView(frame, string, hashtable, string2, string3, string4, string5, string6, string7, string8, false, string9, string10);
    }

    public static String sendCmdRunAndView(Frame frame, String string, Hashtable hashtable, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, String string9, String string10) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.sendCmdRunAndView(frame, string, hashtable, string2, string3, string4, string5, string6, string7, string8, false, string9, string10, null);
    }

    public static String sendCmdRunAndView(Frame frame, String string, Hashtable hashtable, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, String string9, String string10, String string11) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.sendCmdRunAndView(frame, string, hashtable, string2, string3, string4, string5, string6, string7, string8, bl, string9, null, string10, string11);
    }

    public static String sendCmdRunAndView(Frame frame, String string, Hashtable hashtable, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, String string9, String string10, String string11, String string12) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.sendCmdRunAndView(frame, string, hashtable, string2, string3, string4, string5, string6, string7, string8, bl, string9, string10, string11, null, string12);
    }

    public static String sendCmdRunAndView(Frame frame, String string, Hashtable hashtable, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, String string9, String string10, String string11, String string12, String string13) throws MalformedURLException, IOException, JRResponseException {
        Hashtable hashtable2;
        Object var16_16 = null;
        Hashtable hashtable3 = hashtable2 = hashtable == null ? new Hashtable() : (Hashtable)hashtable.clone();
        if (hashtable != null && hashtable.size() > 0) {
            hashtable2.put("jrs.param_file", "true");
        }
        JRClient.P_TASK_DISK(hashtable2, string2, string3, string4, string5, string6, string7, string8, bl, string9, string10, string11, string12, string13);
        return JRClient.sendCmdRunAndViewEx(frame, string, hashtable2);
    }

    private static void P_TASK_DISK(Hashtable hashtable, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, String string8, String string9, String string10, String string11, String string12) throws MalformedURLException, IOException, JRResponseException {
        if (string != null && string.length() > 0) {
            hashtable.put("jrs.wp", string);
        }
        if (string2 != null && string2.length() > 0) {
            hashtable.put("jrs.named_wp", string2);
        }
        if (string3 != null) {
            hashtable.put("jrs.wc", string3);
        }
        if (string4 != null) {
            hashtable.put("jrs.db_user", string4);
        }
        if (string5 != null) {
            hashtable.put("jrs.db_pswd", string5);
        }
        if (string6 != null) {
            hashtable.put("jrs.jdbc_url", string6);
        }
        if (string7 != null) {
            hashtable.put("jrs.jdbc_driver", string7);
        }
        hashtable.put("jrs.jdbc_get_support_info", String.valueOf(bl));
        if (string8 != null) {
            hashtable.put("jrs.rpt_language", string8);
        }
        if (string9 != null) {
            hashtable.put("jrs.rpt_country", string9);
        }
        if (string10 != null) {
            hashtable.put("jrs.rpt_encoding", string10);
        }
        if (string11 != null) {
            hashtable.put("jrs.style_group", string11);
        }
        if (string12 != null && string12.length() != 0) {
            hashtable.put("jrs.has_task_listener", String.valueOf(true));
            hashtable.put("jrs.task_listener_class", string12);
        }
    }

    private static String P_TASK_MAIL(Frame frame, String string, Hashtable hashtable) throws MalformedURLException, IOException, JRResponseException {
        String string2;
        URLConnection uRLConnection = JRClient.INFO(frame, string, hashtable);
        int n = APIUtil.getResponseCode(uRLConnection);
        if (n != 201) {
            APIUtil.checkResponseOK(uRLConnection);
        }
        if ((string2 = uRLConnection.getHeaderField("Content-Location")) == null && uRLConnection.getContent() != null) {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            int n2 = 0;
            String string4 = "Content-Location";
            int n3 = string4.length();
            int n4 = uRLConnection.getContentLength();
            for (int i = 0; (n4 < 0 || i < n4) && null != (string3 = bufferedReader.readLine()); i += string3.length() + 2) {
                n2 = string3.indexOf(string4);
                if (n2 < 0) continue;
                string2 = CSUtil.convertEscapes(string3.substring(n2 + n3));
                if (!string2.endsWith("\">")) break;
                string2 = string2.substring(0, string2.length() - 2);
                break;
            }
        }
        JRClient.close(uRLConnection);
        return string2;
    }

    public static String sendCmdRunAndView(Frame frame, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.sendCmdRunAndView(frame, string, string2, string3, string4, string5, string6, string7, null, null);
    }

    public static String sendCmdRunAndView(Frame frame, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.sendCmdRunAndView(frame, string, string2, string3, string4, string5, string6, string7, null, null, string8, string9);
    }

    public static String sendCmdRunAndView(Frame frame, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.sendCmdRunAndView(frame, string, string2, string3, string4, string5, string6, string7, string8, string9, false, string10, string11);
    }

    public static String sendCmdRunAndView(Frame frame, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl, String string10, String string11) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.sendCmdRunAndView(frame, string, string2, string3, string4, string5, string6, string7, string8, string9, false, string10, string11, null);
    }

    public static String sendCmdRunAndView(Frame frame, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl, String string10, String string11, String string12) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.sendCmdRunAndView(frame, string, string2, string3, string4, string5, string6, string7, string8, string9, bl, string10, null, string11, string12);
    }

    public static String sendCmdRunAndView(Frame frame, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl, String string10, String string11, String string12, String string13) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.sendCmdRunAndView(frame, string, string2, string3, string4, string5, string6, string7, string8, string9, bl, string10, string11, string12, null, string13);
    }

    public static String sendCmdRunAndView(Frame frame, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl, String string10, String string11, String string12, String string13, String string14) throws MalformedURLException, IOException, JRResponseException {
        Object var16_16 = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (string2 != null && string2.length() > 0) {
            hashtable.put("jrs.param_values", string2);
        }
        JRClient.P_TASK_DISK(hashtable, string3, string4, string5, string6, string7, string8, string9, bl, string10, string11, string12, string13, string14);
        return JRClient.sendCmdRunAndViewEx(frame, string, hashtable);
    }

    public static String sendCmdRunAndViewEx(Frame frame, String string, Hashtable hashtable) throws MalformedURLException, IOException, JRResponseException {
        ResourcePathInfo resourcePathInfo;
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        if ((resourcePathInfo = JRClient.P_TASK_PRINT(frame, string, hashtable)) != null) {
            string = string.substring(0, string.indexOf(resourcePathInfo.getServletPath())) + resourcePathInfo.getServletPath() + hashtable.get("jrs.report");
        }
        return JRClient.P_TASK_MAIL(frame, string, JRClient._reset(hashtable));
    }

    private static ResourcePathInfo P_TASK_PRINT(Frame frame, String string, Hashtable hashtable) throws MalformedURLException, IOException, JRResponseException {
        ResourcePathInfo resourcePathInfo = JRClient.getResourcePathInfo(frame, string);
        String string2 = (String)hashtable.get("jrs.catalog");
        string2 = string2 == null || string2.trim().length() == 0 ? resourcePathInfo.getCatalog() : string2;
        String string3 = (String)hashtable.get("jrs.report");
        String string4 = string3 = string3 == null || string3.trim().length() == 0 ? resourcePathInfo.getReport() : string3;
        if (string2 == null || string2.equals("/")) {
            return null;
        }
        if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (!string2.endsWith(".cat")) {
            return null;
        }
        if (string2 != null) {
            hashtable.put("jrs.catalog", string2);
        }
        if (string3 != null) {
            if (string3.indexOf("/") < 0) {
                hashtable.put("jrs.report", string2.substring(0, string2.lastIndexOf("/") + 1) + string3);
            } else {
                hashtable.put("jrs.report", string3);
            }
        }
        return resourcePathInfo;
    }

    public static String submitTask(Frame frame, String string, Hashtable hashtable) throws MalformedURLException, IOException, JRResponseException {
        String string2;
        String string3;
        File file;
        String string4;
        Hashtable hashtable2;
        int n;
        boolean bl;
        Object object;
        Object object2;
        String string5;
        if (CSUtil.getBoolean((String)hashtable.get("jrs.to_version"), false) && CSUtil.getBoolean((String)hashtable.get("jrs.to_version_pdf"), false) && CSUtil.getBoolean((String)hashtable.get("jrs.version_pdf_sign"), true) && (string5 = (String)hashtable.get("jrs.version_pdf_digital_path")) != null && ((File)(object2 = new File(string5))).exists() && !((File)object2).isDirectory()) {
            object = String.valueOf(System.currentTimeMillis()) + ".pfx";
            JRClient.addUrlPaths("ReadFile", string, (File)object2, (String)object, null);
            hashtable.put("jrs.version_pdf_digital_path", object);
        }
        if (CSUtil.getBoolean((String)hashtable.get("jrs.to_disk"), false) && CSUtil.getBoolean((String)hashtable.get("jrs.to_pdf"), false) && CSUtil.getBoolean((String)hashtable.get("jrs.disk_pdf_sign"), true) && (string5 = (String)hashtable.get("jrs.pdf_digital_path")) != null && ((File)(object2 = new File(string5))).exists() && !((File)object2).isDirectory()) {
            object = String.valueOf(System.currentTimeMillis()) + ".pfx";
            JRClient.addUrlPaths("ReadFile", string, (File)object2, (String)object, null);
            hashtable.put("jrs.pdf_digital_path", object);
        }
        boolean bl2 = bl = hashtable == null ? false : CSUtil.getBoolean((String)hashtable.get("jrs.has_nonbursting_result"), false);
        if (CSUtil.getBoolean((String)hashtable.get("jrs.to_mail"), false) && ((Vector)(object2 = CSMail.getMails(hashtable, bl))).size() > 0) {
            object = new Vector();
            for (n = 0; n < ((Vector)object2).size(); ++n) {
                JRMail jRMail = (JRMail)((Vector)object2).elementAt(n);
                hashtable2 = jRMail.toProperties(null, bl);
                if (CSUtil.getBoolean(((Properties)hashtable2).getProperty("jrs.to_mail_pdf"), false) && CSUtil.getBoolean(((Properties)hashtable2).getProperty("jrs.mail_pdf_sign"), false) && (string4 = (String)hashtable.get("jrs.mail_pdf_digital_path")) != null && (file = new File(string4)).exists() && !file.isDirectory()) {
                    string3 = String.valueOf(System.currentTimeMillis()) + ".pfx";
                    JRClient.addUrlPaths("ReadFile", string, file, string3, null);
                    hashtable.put("jrs.pdf_digital_path", string3);
                }
                ((Vector)object).add(new JRMail(hashtable2, bl));
            }
            hashtable.putAll(CSMail.toProperties(object, null, bl));
        }
        if (CSUtil.getBoolean((String)hashtable.get("jrs.to_FTP"), false) && ((Vector)(object2 = CSUtil.getFTPs(hashtable, bl))).size() > 0) {
            object = new Vector();
            int n2 = ((Vector)object2).size();
            for (n = 0; n < n2; ++n) {
                hashtable2 = (Hashtable)((Vector)object2).elementAt(n);
                if (CSUtil.getBoolean((String)hashtable2.get("jrs.ftpPdf"), false) && CSUtil.getBoolean((String)hashtable2.get("jrs.ftpPdfSgn"), false) && (string4 = (String)hashtable2.get("jrs.ftpPdfDP")) != null && (file = new File(string4)).exists() && !file.isDirectory()) {
                    string3 = String.valueOf(System.currentTimeMillis()) + ".pfx";
                    JRClient.addUrlPaths("ReadFile", string, file, string3, null);
                    hashtable2.put("jrs.ftpPdfDP", string3);
                }
                ((Vector)object).add(hashtable2);
            }
            hashtable.putAll(CSUtil.toProperties((Vector)object, null, bl));
        }
        object2 = JRClient.sendQuery(frame, string, "?jrs.cmd=jrs.submit_schedule&" + CSUtil.makeNoHeadQuery(hashtable));
        APIUtil.checkResponseOK((URLConnection)object2);
        object = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((URLConnection)object2).getInputStream()));
        int n3 = ((URLConnection)object2).getContentLength();
        int n4 = 0;
        if ((n3 < 0 || n4 < n3) && null != (string2 = bufferedReader.readLine())) {
            n4 += string2.length() + 2;
            object = string2;
        }
        JRClient.close((URLConnection)object2);
        return object;
    }

    public static String runTask(Frame frame, String string, Hashtable hashtable) throws MalformedURLException, IOException, JRResponseException {
        String string2;
        URLConnection uRLConnection = JRClient.sendQuery(frame, APIUtil.formatServerURL(string), "?jrs.cmd=jrs.run_task&" + CSUtil.makeNoHeadQuery(hashtable));
        APIUtil.checkResponseOK(uRLConnection);
        String string3 = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        int n = uRLConnection.getContentLength();
        int n2 = 0;
        if ((n < 0 || n2 < n) && null != (string2 = bufferedReader.readLine())) {
            n2 += string2.length() + 2;
            string3 = string2;
        }
        JRClient.close(uRLConnection);
        return string3;
    }

    public static Vector[] getParamDescAndGrpCols(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.getParamDescAndGrpCols(frame, string, null);
    }

    public static Vector[] getParamDescAndGrpCols(Frame frame, String string, Hashtable hashtable) throws MalformedURLException, IOException, JRResponseException {
        InputStream inputStream;
        ResourcePathInfo resourcePathInfo;
        Vector[] vectorArray = null;
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        if ((resourcePathInfo = JRClient.P_TASK_PRINT(frame, string, hashtable)) != null) {
            string = string.substring(0, string.indexOf(resourcePathInfo.getServletPath())) + resourcePathInfo.getServletPath() + hashtable.get("jrs.report");
        }
        if ((inputStream = JRClient.getParamDescStream(frame, string, hashtable)) != null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            vectorArray = JRClient.Z(bufferedReader, null);
            bufferedReader.close();
        }
        return vectorArray;
    }

    public static Vector getParamDescVct(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.getParamDescVct(frame, string, null);
    }

    public static Vector getParamDescVct(Frame frame, String string, Hashtable hashtable) throws MalformedURLException, IOException, JRResponseException {
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        JRClient.P_TASK_PRINT(frame, string, hashtable);
        Vector vector = null;
        Vector[] vectorArray = JRClient.getParamDescAndGrpCols(frame, string, hashtable);
        if (vectorArray != null) {
            vector = vectorArray[0];
        }
        return vector == null ? new Vector() : vector;
    }

    public static Hashtable getParamValues(Frame frame, String string) throws ParseParamValuesException, ParamCanceledException, MalformedURLException, IOException, JRResponseException {
        return JRClient.getParamValues(frame, string, null);
    }

    public static Hashtable getParamValues(Frame frame, String string, String string2) throws ParseParamValuesException, ParamCanceledException, MalformedURLException, IOException, JRResponseException {
        return JRClient.getParamValues(frame, string, string2, null);
    }

    public static Hashtable getParamValues(Frame frame, String string, String string2, Locale locale) throws ParseParamValuesException, ParamCanceledException, MalformedURLException, IOException, JRResponseException {
        return JRClient.getParamValues(frame, string, string2, locale, null);
    }

    public static Hashtable getParamValues(Frame frame, String string, String string2, Locale locale, Hashtable hashtable) throws ParseParamValuesException, ParamCanceledException, MalformedURLException, IOException, JRResponseException {
        int n;
        Hashtable hashtable2 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        Object var9_9 = null;
        boolean bl = false;
        Vector vector = null;
        boolean bl2 = false;
        Vector vector2 = null;
        Vector vector3 = null;
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        JRClient.P_TASK_PRINT(frame, string, hashtable);
        Vector[] vectorArray = JRClient.getParamDescAndGrpCols(frame, string, hashtable);
        if (vectorArray != null) {
            vector = vectorArray[0];
            vector2 = vectorArray[1];
            vector3 = vectorArray[2];
        }
        int n2 = n = vector == null ? 0 : vector.size();
        if (n > 0) {
            if (string2 == null) {
                String string3 = (String)hashtable.get("jrs.report");
                ParamsTookit.setServerURL(string);
                vector = ParamsTookit.getReportParams(string, hashtable);
                Frame frame2 = frame == null ? new Frame() : frame;
                ParamsDialog paramsDialog = new ParamsDialog(frame2, string3 == null ? "" : string3, vector, vector3, true, locale == null ? Locale.getDefault() : locale, hashtable);
                ParamsTookit.removeParamEngine();
                if (frame == null) {
                    frame2.dispose();
                }
                if (paramsDialog.isCanceled()) {
                    throw new ParamCanceledException(JCliResource.getMessage("CLI_ERR_3"), paramsDialog);
                }
                hashtable2 = paramsDialog.getParamValuesInHashtable();
            } else {
                hashtable2 = JRClient._proxyPassword(string2, vector);
            }
        }
        return hashtable2;
    }

    public static Vector getParamVector(Frame frame, String string, String string2) throws ParseParamValuesException, ParamCanceledException, MalformedURLException, IOException, JRResponseException {
        return JRClient.getParamVector(frame, string, string2, null);
    }

    public static Vector getParamVector(Frame frame, String string, String string2, Locale locale) throws ParseParamValuesException, ParamCanceledException, MalformedURLException, IOException, JRResponseException {
        return JRClient.getParamVector(frame, string, string2, locale, null);
    }

    public static Vector getParamVector(Frame frame, String string, String string2, Locale locale, Hashtable hashtable) throws ParseParamValuesException, ParamCanceledException, MalformedURLException, IOException, JRResponseException {
        int n;
        Vector vector = null;
        Object var6_6 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        Object var9_9 = null;
        boolean bl = false;
        Vector vector2 = null;
        Object var12_12 = null;
        boolean bl2 = false;
        Vector vector3 = null;
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        JRClient.P_TASK_PRINT(frame, string, hashtable);
        Vector[] vectorArray = JRClient.getParamDescAndGrpCols(frame, string, hashtable);
        if (vectorArray != null) {
            vector2 = vectorArray[0];
            vector3 = vectorArray[2];
        }
        int n2 = n = vector2 == null ? 0 : vector2.size();
        if (n > 0) {
            if (string2 == null) {
                String string3 = null;
                try {
                    string3 = APIUtil.parseReportURL(string)[1];
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
                ParamsTookit.setServerURL(string);
                vector2 = ParamsTookit.getReportParams(string, hashtable);
                Frame frame2 = frame == null ? new Frame() : frame;
                ParamsDialog paramsDialog = new ParamsDialog(frame2, string3 == null ? "" : string3, vector2, vector3, true, locale == null ? Locale.getDefault() : locale, hashtable);
                ParamsTookit.removeParamEngine();
                if (frame == null) {
                    frame2.dispose();
                }
                if (paramsDialog.isCanceled()) {
                    throw new ParamCanceledException(JCliResource.getMessage("CLI_ERR_3"), paramsDialog);
                }
                vector = paramsDialog.getParamsVector();
            } else {
                vector = ClientUtil.parseParamValuesToVector(string2, vector2);
            }
        }
        return vector == null ? new Vector(1) : vector;
    }

    public static Vector getParamVector(Frame frame, String string) throws ParamCanceledException, MalformedURLException, IOException, JRResponseException {
        return JRClient.getParamVector(frame, string, (Locale)null);
    }

    public static Vector getParamVector(Frame frame, String string, Locale locale) throws ParamCanceledException, MalformedURLException, IOException, JRResponseException {
        int n;
        Vector vector = null;
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        boolean bl = false;
        Vector vector2 = null;
        Object var10_10 = null;
        boolean bl2 = false;
        Vector vector3 = null;
        Vector[] vectorArray = JRClient.getParamDescAndGrpCols(frame, string);
        if (vectorArray != null) {
            vector2 = vectorArray[0];
            vector3 = vectorArray[2];
        }
        int n2 = n = vector2 == null ? 0 : vector2.size();
        if (n > 0) {
            String string2 = null;
            String string3 = null;
            try {
                string2 = APIUtil.parseReportURL(string)[0];
                string3 = APIUtil.parseReportURL(string)[1];
            }
            catch (Exception exception) {
                JDebug.WARNING(exception);
            }
            ParamsTookit.setServerURL(string);
            vector2 = ParamsTookit.getReportParams(string, null);
            Properties properties = new Properties();
            if (string2 != null) {
                properties.put("jrs.catalog", string2);
            }
            if (string3 != null) {
                properties.put("jrs.report", string3);
            }
            Frame frame2 = frame == null ? new Frame() : frame;
            ParamsDialog paramsDialog = new ParamsDialog(frame2, string3 == null ? "" : string3, vector2, vector3, true, locale == null ? Locale.getDefault() : locale, properties);
            ParamsTookit.removeParamEngine();
            if (frame == null) {
                frame2.dispose();
            }
            if (paramsDialog.isCanceled()) {
                throw new ParamCanceledException(JCliResource.getMessage("CLI_ERR_3"), paramsDialog);
            }
            vector = paramsDialog.getParamsVector();
        }
        return vector == null ? new Vector(1) : vector;
    }

    public static InputStream getParamDescStream(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.getParamDescStream(frame, string, null);
    }

    public static InputStream getParamDescStream(Frame frame, String string, Hashtable hashtable) throws MalformedURLException, IOException, JRResponseException {
        InputStream inputStream = null;
        URLConnection uRLConnection = null;
        Hashtable hashtable2 = JRClient._realm(null, "jrs.get_rpt_params");
        if (hashtable != null) {
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            String string9 = (String)hashtable.get("jrs.catalog");
            if (string9 != null) {
                hashtable2.put("jrs.catalog", string9);
            }
            if ((string8 = (String)hashtable.get("jrs.report")) != null) {
                hashtable2.put("jrs.report", string8);
            }
            if ((string7 = (String)hashtable.get("jrs.cat_version")) != null) {
                hashtable2.put("jrs.cat_version", string7);
            }
            if ((string6 = (String)hashtable.get("jrs.rpt_version")) != null) {
                hashtable2.put("jrs.rpt_version", string6);
            }
            if ((string5 = (String)hashtable.get("jrs.jdbc_url")) != null) {
                hashtable2.put("jrs.jdbc_url", string5);
            }
            if ((string4 = (String)hashtable.get("jrs.db_user")) != null) {
                hashtable2.put("jrs.db_user", string4);
            }
            if ((string3 = (String)hashtable.get("jrs.db_pswd")) != null) {
                hashtable2.put("jrs.db_pswd", string3);
            }
            if ((string2 = (String)hashtable.get("jrs.jdbc_driver")) != null) {
                hashtable2.put("jrs.jdbc_driver", string2);
            }
        }
        uRLConnection = JRClient.INFO(frame, string, hashtable2);
        APIUtil.checkResponseOK(uRLConnection);
        inputStream = uRLConnection.getInputStream();
        return inputStream;
    }

    public static Vector getAvailableLanguages(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.getAvailableLanguages(frame, string, null);
    }

    public static Vector getAvailableLanguages(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.getAvailableLanguages(frame, string, string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getAvailableLanguages(Frame frame, String string, String string2, Hashtable hashtable) throws MalformedURLException, IOException, JRResponseException {
        String string3;
        Object object;
        Object object2;
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        ResourcePathInfo resourcePathInfo = JRClient.P_TASK_PRINT(frame, string, hashtable);
        StringBuffer stringBuffer = new StringBuffer();
        if (hashtable != null) {
            object2 = null;
            object = null;
            string3 = null;
            String string4 = null;
            stringBuffer.append("?").append("jrs.cmd").append("=").append("jrs.get_rpt_languages");
            if (string2 != null) {
                stringBuffer.append("&").append("jrs.uid").append("=").append(string2);
            }
            if ((object2 = (String)hashtable.get("jrs.catalog")) != null) {
                stringBuffer.append("&").append("jrs.catalog").append("=").append(CSUtil.escapeURLPath((String)object2));
            }
            if ((object = (String)hashtable.get("jrs.report")) != null) {
                stringBuffer.append("&").append("jrs.report").append("=").append(CSUtil.escapeURLPath((String)object));
            }
            if ((string3 = (String)hashtable.get("jrs.cat_version")) != null) {
                stringBuffer.append("&").append("jrs.cat_version").append("=").append(string3);
            }
            if ((string4 = (String)hashtable.get("jrs.rpt_version")) != null) {
                stringBuffer.append("&").append("jrs.rpt_version").append("=").append(string4);
            }
        }
        object2 = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(stringBuffer.toString(), ".=_-|;&<>$/:?\""));
        stringBuffer.delete(0, stringBuffer.length());
        APIUtil.checkResponseOK((URLConnection)object2);
        object = new BufferedReader(new InputStreamReader(((URLConnection)object2).getInputStream()));
        string3 = null;
        try {
            int n = ((URLConnection)object2).getContentLength();
            string3 = null;
            if (n > 0) {
                while (null != (string3 = ((BufferedReader)object).readLine())) {
                    stringBuffer.append(string3);
                }
            } else {
                for (int i = 0; i < n && null != (string3 = ((BufferedReader)object).readLine()); i += string3.length() + 2) {
                    stringBuffer.append(string3);
                }
            }
        }
        finally {
            if (object != null) {
                try {
                    ((BufferedReader)object).close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return CSUtil.parseURLEncodedStringToVector(stringBuffer.toString());
    }

    public static Vector getStyleGroupDisplayNames(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.getStyleGroupDisplayNames(frame, string, string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getStyleGroupDisplayNames(Frame frame, String string, String string2, Hashtable hashtable) throws MalformedURLException, IOException, JRResponseException {
        String string3;
        Object object;
        Object object2;
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        JRClient.P_TASK_PRINT(frame, string, hashtable);
        StringBuffer stringBuffer = new StringBuffer();
        if (hashtable != null) {
            object2 = null;
            object = null;
            string3 = null;
            String string4 = null;
            stringBuffer.append("?").append("jrs.cmd").append("=").append("jrs.get_rpt_style_groups");
            if (string2 != null) {
                stringBuffer.append("&").append("jrs.uid").append("=").append(string2);
            }
            if ((object2 = (String)hashtable.get("jrs.catalog")) != null) {
                stringBuffer.append("&").append("jrs.catalog").append("=").append(CSUtil.escapeURLPath((String)object2));
            }
            if ((object = (String)hashtable.get("jrs.report")) != null) {
                stringBuffer.append("&").append("jrs.report").append("=").append(CSUtil.escapeURLPath((String)object));
            }
            if ((string3 = (String)hashtable.get("jrs.cat_version")) != null) {
                stringBuffer.append("&").append("jrs.cat_version").append("=").append(string3);
            }
            if ((string4 = (String)hashtable.get("jrs.rpt_version")) != null) {
                stringBuffer.append("&").append("jrs.rpt_version").append("=").append(string4);
            }
        }
        object2 = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(stringBuffer.toString(), ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK((URLConnection)object2);
        stringBuffer.delete(0, stringBuffer.length());
        object = new BufferedReader(new InputStreamReader(((URLConnection)object2).getInputStream()));
        string3 = null;
        try {
            int n = ((URLConnection)object2).getContentLength();
            string3 = null;
            if (n > 0) {
                while (null != (string3 = ((BufferedReader)object).readLine())) {
                    stringBuffer.append(string3);
                }
            } else {
                for (int i = 0; i < n && null != (string3 = ((BufferedReader)object).readLine()); i += string3.length() + 2) {
                    stringBuffer.append(string3);
                }
            }
        }
        finally {
            if (object != null) {
                try {
                    ((BufferedReader)object).close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return CSUtil.parseURLEncodedStringToVector(stringBuffer.toString());
    }

    public static Vector getReportSheets(Frame frame, String string, String string2, Hashtable hashtable) throws MalformedURLException, IOException, JRResponseException {
        Object object;
        Object object2;
        Object object3;
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        JRClient.P_TASK_PRINT(frame, string, hashtable);
        StringBuffer stringBuffer = new StringBuffer();
        if (hashtable != null) {
            object3 = null;
            object2 = null;
            object = null;
            String string3 = null;
            stringBuffer.append("?").append("jrs.cmd").append("=").append("jrs.get_rpt_sheets");
            if (string2 != null) {
                stringBuffer.append("&").append("jrs.uid").append("=").append(string2);
            }
            if ((object3 = (String)hashtable.get("jrs.catalog")) != null) {
                stringBuffer.append("&").append("jrs.catalog").append("=").append(CSUtil.escapeURLPath((String)object3));
            }
            if ((object2 = (String)hashtable.get("jrs.report")) != null) {
                stringBuffer.append("&").append("jrs.report").append("=").append(CSUtil.escapeURLPath((String)object2));
            }
            if ((object = (String)hashtable.get("jrs.cat_version")) != null) {
                stringBuffer.append("&").append("jrs.cat_version").append("=").append((String)object);
            }
            if ((string3 = (String)hashtable.get("jrs.rpt_version")) != null) {
                stringBuffer.append("&").append("jrs.rpt_version").append("=").append(string3);
            }
        }
        object3 = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(stringBuffer.toString(), ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK((URLConnection)object3);
        stringBuffer.delete(0, stringBuffer.length());
        object2 = new BufferedReader(new InputStreamReader(((URLConnection)object3).getInputStream()));
        object = RptSheet.parseRptSheetStream((BufferedReader)object2);
        ((BufferedReader)object2).close();
        return object;
    }

    public static Vector getReportSheetsFromRst(Frame frame, String string, String string2, String string3) throws MalformedURLException, IOException, JRResponseException {
        if (string2 == null) {
            return null;
        }
        JRClient.P_TASK_PRINT(frame, string, new Hashtable());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("?").append("jrs.cmd").append("=").append("jrs.get_rpt_sheets_from_rst");
        if (string3 != null) {
            stringBuffer.append("&").append("jrs.uid").append("=").append(string3);
        }
        stringBuffer.append("&").append("jrs.file").append("=").append(string2);
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(stringBuffer.toString(), ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        stringBuffer.delete(0, stringBuffer.length());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        Vector vector = RptSheet.parseRptSheetStream(bufferedReader);
        bufferedReader.close();
        return vector;
    }

    public static Vector getScheduled(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.P_TASK_VALUE_TRIGGER(frame, string, 0);
    }

    public static void deleteScheduled(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        JRClient.SEDU(frame, string, 0, string2);
    }

    public static void enableScheduled(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        String string3 = "?jrs.cmd=";
        string3 = string3 + "jrs.enable_schedule&jrs.task_id=" + CSUtil.replWithEsc(string2);
        URLConnection uRLConnection = JRClient.sendQuery(frame, APIUtil.formatServerURL(string), string3);
        APIUtil.checkResponseOK(uRLConnection);
        JRClient.close(uRLConnection);
    }

    public static void disableScheduled(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        String string3 = "?jrs.cmd=";
        string3 = string3 + "jrs.disable_schedule&jrs.task_id=" + CSUtil.replWithEsc(string2);
        URLConnection uRLConnection = JRClient.sendQuery(frame, APIUtil.formatServerURL(string), string3);
        APIUtil.checkResponseOK(uRLConnection);
        JRClient.close(uRLConnection);
    }

    public static Vector getActive(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.P_TASK_VALUE_TRIGGER(frame, string, 1);
    }

    public static void stopActive(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        JRClient.SEDU(frame, string, 1, string2);
    }

    public static Vector getCompleted(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.P_TASK_VALUE_TRIGGER(frame, string, 2);
    }

    public static void deleteCompleted(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        JRClient.SEDU(frame, string, 2, string2);
    }

    public static void deleteAllCompleted(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        String string2 = "?jrs.cmd=";
        string2 = string2 + "jrs.del_all_completed";
        URLConnection uRLConnection = JRClient.sendQuery(frame, APIUtil.formatServerURL(string), string2);
        APIUtil.checkResponseOK(uRLConnection);
        JRClient.close(uRLConnection);
    }

    public static Vector getBooleanNames(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.getBooleanNames(frame, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getBooleanNames(Frame frame, String string, Hashtable hashtable) throws MalformedURLException, IOException, JRResponseException {
        String string2;
        Object object;
        CharSequence charSequence;
        Object var3_3 = null;
        URLConnection uRLConnection = null;
        Hashtable hashtable2 = JRClient._realm(null, "jrs.get_boolean_names");
        if (hashtable != null) {
            String string3;
            charSequence = (String)hashtable.get("jrs.catalog");
            if (charSequence != null) {
                hashtable2.put("jrs.catalog", charSequence);
            }
            if ((object = (String)hashtable.get("jrs.report")) != null) {
                hashtable2.put("jrs.report", object);
            }
            if ((string2 = (String)hashtable.get("jrs.cat_version")) != null) {
                hashtable2.put("jrs.cat_version", string2);
            }
            if ((string3 = (String)hashtable.get("jrs.rpt_version")) != null) {
                hashtable2.put("jrs.rpt_version", string3);
            }
        }
        uRLConnection = JRClient.INFO(frame, string, hashtable2);
        APIUtil.checkResponseOK(uRLConnection);
        charSequence = new StringBuffer();
        object = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        string2 = null;
        try {
            int n = uRLConnection.getContentLength();
            for (int i = 0; (n < 0 || i < n) && null != (string2 = ((BufferedReader)object).readLine()); i += string2.length() + 2) {
                ((StringBuffer)charSequence).append(string2);
            }
        }
        finally {
            if (object != null) {
                try {
                    ((BufferedReader)object).close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return CSUtil.parseURLEncodedStringToVector(((StringBuffer)charSequence).toString());
    }

    public static boolean hasPageSecurity(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.hasPageSecurity(frame, string, null, null);
    }

    public static boolean hasPageSecurity(Frame frame, String string, String string2, String string3) throws MalformedURLException, IOException, JRResponseException {
        String string4;
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.has_page_security");
        hashtable.put("jrs.catalog", string3);
        hashtable.put("jrs.report", string2);
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        String string5 = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        int n = uRLConnection.getContentLength();
        for (int i = 0; (n < 0 || i < n) && null != (string4 = bufferedReader.readLine()); i += string4.length() + 2) {
            string5 = string4;
        }
        JRClient.close(uRLConnection);
        return CSUtil.getBoolean(string5, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getPrintersOfServer(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        Object var2_2 = null;
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.get_printers");
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string2 = null;
        try {
            int n = uRLConnection.getContentLength();
            for (int i = 0; (n < 0 || i < n) && null != (string2 = bufferedReader.readLine()); i += string2.length() + 2) {
                stringBuffer.append(string2);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return CSUtil.parseURLEncodedStringToVector(stringBuffer.toString());
    }

    public static String getJDKVersionOfServer(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        Object var2_2 = null;
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.get_jdkverion");
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        String string2 = uRLConnection.getHeaderField("jrs.jdkverion");
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getSubNodesInfo(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        String string3 = CSUtil.addUrlPaths(string, string2);
        String string4 = "?jrs.cmd=jrs.get_subnodes&jrs.path=" + string2;
        boolean bl = false;
        BufferedReader bufferedReader = null;
        URLConnection uRLConnection = JRClient.sendQuery(frame, string3, CSUtil.replWithEsc(string4, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        Vector<NodeInfo> vector = new Vector<NodeInfo>();
        String string5 = null;
        Properties properties = null;
        try {
            string5 = bufferedReader.readLine();
            int n = Integer.parseInt(string5);
            for (int i = 0; null != (string5 = bufferedReader.readLine()) && i < n; ++i) {
                properties = CSUtil.parseQuery(string5);
                NodeInfo nodeInfo = JRClient._proxyUser(string3, properties);
                vector.addElement(nodeInfo);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return vector;
    }

    public static Vector getSubFileDirInfo(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.getSubNodesInfo(frame, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeInfo getNodeInfo(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        String string3 = APIUtil.addURLPath(string, string2);
        string3 = string3 + "?jrs.cmd=jrs.get_node_info";
        java.net.URL uRL = new java.net.URL(string3);
        Object var5_5 = null;
        BufferedReader bufferedReader = null;
        URLConnection uRLConnection = null;
        try {
            uRLConnection = JRClient.openConnection(frame, uRL);
            APIUtil.checkResponseOK(uRLConnection);
            bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            String string4 = bufferedReader.readLine();
            Properties properties = CSUtil.parseQuery(string4);
            string4 = bufferedReader.readLine();
            ((Hashtable)properties).putAll(CSUtil.parseQuery(string4));
            NodeInfo nodeInfo = JRClient._proxyUser(string, properties);
            return nodeInfo;
        }
        finally {
            if (uRLConnection != null) {
                try {
                    JRClient.close(uRLConnection);
                }
                catch (Throwable throwable) {
                    JDebug.WARNING(throwable);
                }
            }
        }
    }

    public static NodeInfo getNodeReferInfo(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.getNodeInfo(frame, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getReports(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        Vector<String> vector;
        block12: {
            vector = new Vector<String>();
            NodeInfo nodeInfo = JRClient.getNodeInfo(frame, string, string2);
            if (nodeInfo != null && nodeInfo.isCatalog()) {
                string2 = string2.substring(0, string2.lastIndexOf("/"));
            }
            String string3 = APIUtil.addURLPath(string, string2);
            String string4 = "?jrs.cmd=jrs.get_cat_rpts&jrs.path=" + string2;
            URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string4, ".=_-|;&<>$/:?\""));
            APIUtil.checkResponseOK(uRLConnection);
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                String string5 = bufferedReader.readLine();
                int n = Integer.parseInt(string5);
                if (n <= 0) break block12;
                vector = new Vector(n);
                int n2 = "jrs.node_name".length() + 1;
                int n3 = 0;
                while (n3 < n) {
                    string5 = bufferedReader.readLine();
                    if (string5 == null) {
                        break;
                    }
                    int n4 = string5.indexOf("jrs.node_name=");
                    int n5 = string5.indexOf("&jrs.node_share");
                    while (string2.endsWith("/")) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    if (n4 == -1 || n5 == -1) continue;
                    String string6 = string2 + "/" + URLDecoder.decode(string5.substring(n4 + n2, n5));
                    vector.addElement(string6);
                }
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {
                        JDebug.WARNING(exception);
                    }
                }
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setResultMaxVersionLimit(Frame frame, String string, boolean bl, int n) throws MalformedURLException, JRResponseException {
        String string2 = "?jrs.cmd=jrs.sub_maxversion&jrs.need_maxversion=" + String.valueOf(bl) + "&" + "jrs.maxversion" + "=" + String.valueOf(n);
        URLConnection uRLConnection = null;
        try {
            uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string2, ".=_-|;&<>$/:?\""));
            APIUtil.checkResponseOK(uRLConnection);
        }
        catch (Throwable throwable) {
            JDebug.WARNING(throwable);
        }
        finally {
            if (uRLConnection != null) {
                try {
                    JRClient.close(uRLConnection);
                }
                catch (Throwable throwable) {
                    JDebug.WARNING(throwable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getResultMaxVersionLimit(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        int n = 0;
        String string3 = "?jrs.cmd=jrs.get_maxversion";
        string3 = string3 + "&jrs.uid=" + string2;
        BufferedReader bufferedReader = null;
        try {
            URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string3, ".=_-|;&<>$/:?\""));
            APIUtil.checkResponseOK(uRLConnection);
            bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            String string4 = bufferedReader.readLine();
            if (string4 != null) {
                n = CSUtil.parseInt(string4, 0);
            }
            while (bufferedReader.readLine() != null) {
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return n;
    }

    public static void setMaxVersionLimit(Frame frame, String string, boolean bl, int n) throws MalformedURLException, JRResponseException {
        JRClient.setResultMaxVersionLimit(frame, string, bl, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setResultMaxVersionLimit(Frame frame, String string, boolean bl, int n, Hashtable hashtable) throws MalformedURLException, JRResponseException {
        String string2 = (String)hashtable.get("jrs.path");
        String string3 = "?jrs.cmd=jrs.sub_maxversion&jrs.need_maxversion=" + String.valueOf(bl) + "&" + "jrs.maxversion" + "=" + String.valueOf(n);
        if (string2 != null) {
            string3 = string3 + "&jrs.path=" + string2;
        }
        URLConnection uRLConnection = null;
        try {
            uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string3, ".=_-|;&<>$/:?\""));
            APIUtil.checkResponseOK(uRLConnection);
        }
        catch (Throwable throwable) {
            JDebug.WARNING(throwable);
        }
        finally {
            if (uRLConnection != null) {
                try {
                    JRClient.close(uRLConnection);
                }
                catch (Throwable throwable) {
                    JDebug.WARNING(throwable);
                }
            }
        }
    }

    public static int getMaxVersionLimit(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.getResultMaxVersionLimit(frame, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getResultMaxVersionLimit(Frame frame, String string, String string2, Hashtable hashtable) throws MalformedURLException, IOException, JRResponseException {
        int n = 0;
        String string3 = (String)hashtable.get("jrs.path");
        if (string3 != null) {
            string3 = CSUtil.escapeURLPath(string3);
        }
        String string4 = "?jrs.cmd=jrs.get_maxversion";
        string4 = string4 + "&jrs.uid=" + string2;
        string4 = string4 + "&jrs.path=" + string3;
        BufferedReader bufferedReader = null;
        try {
            URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string4, ".=_-|;&<>$/:?\""));
            APIUtil.checkResponseOK(uRLConnection);
            bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            String string5 = bufferedReader.readLine();
            if (string5 != null) {
                n = CSUtil.parseInt(string5, 0);
            }
            while (bufferedReader.readLine() != null) {
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return n;
    }

    public static boolean doesCatalogExist(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        if (string == null) {
            JDebug.INFO("Please input invlid host, when you call UiKit.isCatalogExits()");
            return false;
        }
        NodeInfo nodeInfo = JRClient.getNodeInfo(frame, string, string2);
        return nodeInfo.isCatalog();
    }

    public static boolean isCatalogExits(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        if (string == null) {
            JDebug.INFO("Please input invlid host, when you call UiKit.isCatalogExits()");
            return false;
        }
        NodeInfo nodeInfo = JRClient.getNodeInfo(frame, string, string2);
        return nodeInfo.isCatalog();
    }

    public static Vector getResultVersions(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        ResourcePathInfo resourcePathInfo = JRClient.getResourcePathInfo(frame, string);
        return JRClient.getResultVersions(frame, string, resourcePathInfo.getPathInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getResultVersions(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        Vector<VersionRecord> vector = new Vector<VersionRecord>();
        if (string2 == null) {
            string2 = "";
        }
        string2 = CSUtil.escapeURLPath(string2);
        String string3 = "?jrs.cmd=jrs.get_rst_vers&jrs.path=" + string2 + "&" + "jrs.report" + "=" + string2;
        BufferedReader bufferedReader = null;
        try {
            URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string3, ".=_-|;&<>$/:?\"\\"));
            APIUtil.checkResponseOK(uRLConnection);
            bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            String string4 = bufferedReader.readLine();
            VersionRecord versionRecord = null;
            int n = Integer.parseInt(string4);
            for (int i = 0; i < n; ++i) {
                string4 = bufferedReader.readLine();
                if (string4 == null) {
                    break;
                }
                versionRecord = JRClient._pswd(string4);
                if (versionRecord == null) continue;
                vector.addElement(versionRecord);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getReportVersions(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        Vector<VersionRecord> vector = new Vector<VersionRecord>();
        if (string2 == null) {
            string2 = "";
        }
        string2 = CSUtil.escapeURLPath(string2);
        String string3 = "?jrs.cmd=jrs.get_rpt_vers&jrs.path=" + string2 + "&" + "jrs.report" + "=" + string2;
        BufferedReader bufferedReader = null;
        try {
            URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string3, ".=_-|;&<>$/:?\""));
            APIUtil.checkResponseOK(uRLConnection);
            bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            String string4 = bufferedReader.readLine();
            VersionRecord versionRecord = null;
            int n = Integer.parseInt(string4);
            for (int i = 0; i < n; ++i) {
                string4 = bufferedReader.readLine();
                if (string4 == null) {
                    break;
                }
                versionRecord = JRClient._pswd(string4);
                if (versionRecord == null) continue;
                vector.addElement(versionRecord);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getResultDocVersions(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        Vector<VersionRecord> vector = new Vector<VersionRecord>();
        if (string2 == null) {
            string2 = "";
        }
        String string3 = "?jrs.cmd=jrs.get_rst_doc_vers&jrs.path=" + string2 + "&" + "jrs.result" + "=" + string2;
        BufferedReader bufferedReader = null;
        try {
            URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string3, ".=_-|;&<>$/:?\""));
            APIUtil.checkResponseOK(uRLConnection);
            bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            String string4 = bufferedReader.readLine();
            VersionRecord versionRecord = null;
            int n = Integer.parseInt(string4);
            for (int i = 0; i < n; ++i) {
                string4 = bufferedReader.readLine();
                if (string4 == null) {
                    break;
                }
                versionRecord = JRClient._pswd(string4);
                if (versionRecord == null) continue;
                vector.addElement(versionRecord);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getCatalogVersions(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        Vector<VersionRecord> vector = new Vector<VersionRecord>();
        if (string2 == null) {
            string2 = "";
        }
        string2 = CSUtil.escapeURLPath(string2);
        String string3 = "?jrs.cmd=jrs.get_cat_vers&jrs.catalog=" + string2;
        BufferedReader bufferedReader = null;
        try {
            URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string3, ".=_-|;&<>$/:?\""));
            APIUtil.checkResponseOK(uRLConnection);
            bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            String string4 = bufferedReader.readLine();
            VersionRecord versionRecord = null;
            int n = Integer.parseInt(string4);
            for (int i = 0; i < n; ++i) {
                string4 = bufferedReader.readLine();
                if (string4 == null) {
                    break;
                }
                versionRecord = JRClient._pswd(string4);
                if (versionRecord == null) continue;
                vector.addElement(versionRecord);
            }
        }
        catch (Exception exception) {
            JDebug.WARNING(exception);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeProp getNodeProperties(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        NodeProp nodeProp = null;
        Vector vector = new Vector();
        if (string2 == null) {
            string2 = "";
        }
        String string3 = "?jrs.cmd=jrs.get_node_prop&jrs.path=" + string2;
        BufferedReader bufferedReader = null;
        try {
            URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string3, ".=_-|;&<>$/:?\""));
            APIUtil.checkResponseOK(uRLConnection);
            bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            String string4 = bufferedReader.readLine();
            nodeProp = JRClient.P_TASK_PUBLISH(string4);
        }
        catch (Exception exception) {
            JDebug.WARNING(exception);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return nodeProp;
    }

    private static NodeProp P_TASK_PUBLISH(String string) {
        NodeProp nodeProp = null;
        if (string != null) {
            Properties properties = CSUtil.parseQuery(string);
            if (properties != null) {
                // empty if block
            }
            nodeProp = new NodeProp((String)((Hashtable)properties).get("jrs.report"), (String)((Hashtable)properties).get("jrs.node_type"), (String)((Hashtable)properties).get("jrs.node_desc"), (String)((Hashtable)properties).get("jrs.node_status"), (String)((Hashtable)properties).get("jrs.node_real_path"), CSUtil.getBoolean((String)((Hashtable)properties).get("jrs.enable_archive_policy"), false), CSUtil.getBoolean((String)((Hashtable)properties).get("jrs.archive_new_version"), false), CSUtil.parseInt((String)((Hashtable)properties).get("jrs.maxversion"), -1), CSUtil.getBoolean((String)((Hashtable)properties).get("jrs.define_permission"), false), CSUtil.parseQuery(CSUtil.convertEscapes((String)((Hashtable)properties).get("USER_PERMISSION"))), CSUtil.parseQuery(CSUtil.convertEscapes((String)((Hashtable)properties).get("ROLE_PERMISSION"))), CSUtil.parseQuery(CSUtil.convertEscapes((String)((Hashtable)properties).get("GROUP_PERMISSION"))), CSUtil.getBoolean((String)((Hashtable)properties).get("jrs.node_share"), false), CSUtil.getBoolean((String)((Hashtable)properties).get("jrs.enable_dynamic_resource"), false), CSUtil.getBoolean((String)((Hashtable)properties).get("jrs.enable.linked.catalog"), false), CSUtil.getBoolean((String)((Hashtable)properties).get("jrs.is.use.inherited"), false), (String)((Hashtable)properties).get("jrs.linked.catalog"), (String)((Hashtable)properties).get("jrs.inherited.linked.catalog"), CSUtil.parseQuery(CSUtil.convertEscapes((String)((Hashtable)properties).get("Field_Name_Values"))));
        }
        return nodeProp;
    }

    public static void setJDBCConnection(Frame frame, String string, String string2, String string3, String string4, String string5) throws MalformedURLException, IOException, JRResponseException {
        Hashtable hashtable = JRClient._realm(null, "jrs.set_jdbc_connection");
        if (string2 != null && string2.length() > 0) {
            hashtable.put("jrs.jdbc_url", string2);
        }
        if (string5 != null && string5.length() > 0) {
            hashtable.put("jrs.jdbc_driver", string5);
        }
        if (string3 != null) {
            hashtable.put("jrs.db_user", string3);
        }
        if (string4 != null) {
            hashtable.put("jrs.db_pswd", string4);
        }
        URLConnection uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        JRClient.close(uRLConnection);
    }

    public static String makeViewTempResultURL(String string, String string2) {
        return JRClient.makeViewTempResultURL(string, "", string2);
    }

    public static String makeViewTempResultURL(String string, String string2, String string3) {
        try {
            Hashtable hashtable = new Hashtable();
            ResourcePathInfo resourcePathInfo = JRClient.P_TASK_PRINT(null, string, hashtable);
            if (resourcePathInfo != null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string.substring(0, string.indexOf(resourcePathInfo.getServletPath()))).append(resourcePathInfo.getServletPath());
                Object v = hashtable.get("jrs.report");
                if (v != null) {
                    stringBuffer.append(v.toString());
                }
                string = stringBuffer.toString();
            }
        }
        catch (Exception exception) {
            JDebug.WARNING(exception);
        }
        return CSUtil.escapeURLPathWhenNeed(string) + "?" + "jrs.cmd" + "=" + "jrs.wait_temp_result" + "&" + "jrs.file" + "=" + CSUtil.replWithEsc(string3) + "&" + "jrs.report_sheet" + "=" + CSUtil.replWithEsc(string2);
    }

    public static String makeViewVersionURL(String string, String string2) {
        return string + "?" + "jrs.cmd" + "=" + "jrs.get_ver_rst" + "&" + "jrs.file" + "=" + CSUtil.replWithEsc(string2);
    }

    public static String makeViewVersionURL(String string, String string2, String string3) {
        return string + "?" + "jrs.cmd" + "=" + "jrs.get_ver_rst" + "&" + "jrs.file" + "=" + CSUtil.replWithEsc(string2) + "&" + "jrs.report_sheet" + "=" + string3;
    }

    protected static String getVersionParamValuesString(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        String string3 = "?jrs.cmd=jrs.get_ver_param&jrs.version_id=" + CSUtil.replWithEsc(string2);
        String string4 = JRClient.addURLQuery(string, string3);
        return JRClient.P_TASK_UPDATE(frame, string4);
    }

    protected static String getVersionParamValuesString(Frame frame, String string, String string2, String string3) throws MalformedURLException, IOException, JRResponseException {
        String string4 = "?jrs.cmd=jrs.get_ver_param&jrs.version_id=" + CSUtil.replWithEsc(string2) + "&" + "jrs.result_type" + "=" + "jrs.result" + "&" + "jrs.report" + "=" + string3;
        String string5 = JRClient.addURLQuery(string, string4);
        return JRClient.P_TASK_UPDATE(frame, string5);
    }

    protected static String getVersionParamValuesString(Frame frame, String string, Hashtable hashtable) throws MalformedURLException, IOException, JRResponseException {
        if (hashtable == null) {
            return null;
        }
        hashtable.put("jrs.cmd", "jrs.get_ver_param");
        String string2 = JRClient.addURLQuery(string, CSUtil.makeQuery(hashtable));
        return JRClient.P_TASK_UPDATE(frame, string2);
    }

    protected static String getScheduleParamValuesString(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        String string3 = "?jrs.cmd=jrs.get_schd_param&jrs.task_id=" + CSUtil.replWithEsc(string2);
        String string4 = JRClient.addURLQuery(string, string3);
        return JRClient.P_TASK_UPDATE(frame, string4);
    }

    protected static String getActiveParamValuesString(Frame frame, String string, String string2, String string3) throws MalformedURLException, IOException, JRResponseException {
        String string4 = "?jrs.cmd=jrs.get_active_param&jrs.task_id=" + CSUtil.replWithEsc(string3) + "&" + "jrs.param_file" + "=" + CSUtil.replWithEsc(string2);
        String string5 = JRClient.addURLQuery(string, string4);
        return JRClient.P_TASK_UPDATE(frame, string5);
    }

    private static String P_TASK_UPDATE(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        URLConnection uRLConnection = JRClient.openConnection(frame, string);
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        boolean bl = false;
        int n = uRLConnection.getContentLength();
        for (int i = 0; (n < 0 || i < n) && null != (string2 = bufferedReader.readLine()); i += string2.length() + 2) {
            stringBuffer.append(string2);
            stringBuffer.append("\n");
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    private static Vector P_TASK_VALUE_TRIGGER(Frame frame, String string, int n) throws MalformedURLException, IOException, JRResponseException {
        String string2;
        Vector<Object> vector = new Vector<Object>();
        String string3 = "?jrs.cmd=";
        switch (n) {
            case 0: {
                string3 = string3 + "jrs.get_schedules";
                break;
            }
            case 1: {
                string3 = string3 + "jrs.get_active";
                break;
            }
            case 2: {
                string3 = string3 + "jrs.get_completed";
            }
        }
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, string3);
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        int n2 = uRLConnection.getContentLength();
        int n3 = 0;
        while ((n2 < 0 || n3 < n2) && null != (string2 = bufferedReader.readLine())) {
            n3 += string2.length() + 2;
            switch (n) {
                case 0: {
                    vector.addElement(CSUtil.parseQuery(string2));
                    break;
                }
                case 1: {
                    vector.addElement(new Active(CSUtil.parseQuery(string2)));
                    break;
                }
                case 2: {
                    vector.addElement(new Completed(CSUtil.parseQuery(string2)));
                }
            }
        }
        JRClient.close(uRLConnection);
        return vector;
    }

    private static void SEDU(Frame frame, String string, int n, String string2) throws MalformedURLException, IOException, JRResponseException {
        String string3 = "?jrs.cmd=";
        switch (n) {
            case 0: {
                string3 = string3 + "jrs.del_schedule&jrs.task_id=" + CSUtil.replWithEsc(string2);
                break;
            }
            case 1: {
                string3 = string3 + "jrs.stop_task&jrs.task_id=" + CSUtil.replWithEsc(string2);
                break;
            }
            case 2: {
                string3 = string3 + "jrs.del_completed&jrs.id=" + CSUtil.replWithEsc(string2);
            }
        }
        URLConnection uRLConnection = JRClient.sendQuery(frame, APIUtil.formatServerURL(string), string3);
        APIUtil.checkResponseOK(uRLConnection);
        JRClient.close(uRLConnection);
    }

    private static Vector[] WARNING(BufferedReader bufferedReader) throws IOException {
        return JRClient.Z(bufferedReader, null);
    }

    private static Vector[] Z(BufferedReader bufferedReader, Hashtable hashtable) throws IOException {
        return Param.parseParamDescStream(bufferedReader, hashtable);
    }

    private static Hashtable _proxyPassword(String string, Vector vector) throws ParseParamValuesException {
        return ClientUtil.parseParamValues(string, vector);
    }

    private static NodeInfo _proxyUser(String string, Hashtable hashtable) {
        String string2 = CSUtil.convertEscapes((String)hashtable.get("path"));
        return new NodeInfo(string, CSUtil.convertEscapes((String)hashtable.get("jrs.node_name")), (String)hashtable.get("jrs.node_desc"), CSUtil.getBoolean((String)hashtable.get("jrs.node_share")), (byte)CSUtil.parseInt((String)hashtable.get("jrs.node_type")), CSUtil.getBoolean((String)hashtable.get("isSelf")), CSUtil.getBoolean((String)hashtable.get("hasSubnodes")), new Date(CSUtil.parseLong((String)hashtable.get("lastModifiedTime"))), CSUtil.getBoolean((String)hashtable.get("isDynamic"), false), (byte)CSUtil.parseInt((String)hashtable.get("jrs.node_status"), -1), string2);
    }

    private static VersionRecord _pswd(String string) {
        if (string == null) {
            return null;
        }
        VersionRecord versionRecord = null;
        if (string.startsWith("/?vEriD?/")) {
            int n = string.indexOf("/?vERrT?/");
            int n2 = string.indexOf("/?vERdT?/");
            int n3 = string.indexOf("/?vERdTsTr?/");
            int n4 = string.indexOf("/?vERpM?/");
            int n5 = string.indexOf("jrs.version_number");
            int n6 = string.indexOf("jrs.expired_time");
            int n7 = string.indexOf("jrs.auto_delete_method");
            int n8 = string.indexOf("jrs.report_result_types");
            int n9 = string.indexOf("jrs.version_files");
            int n10 = string.indexOf("SheetDisplayName:");
            int n11 = "/?vEriD?/".length();
            if (n > n11 && n2 > n && n3 > n2 && n4 > n3) {
                if (n9 > 0 && n8 < 0) {
                    Properties properties = CSUtil.parseQuery(string.substring(n9 + "jrs.version_files".length(), n10));
                    Properties properties2 = CSUtil.parseQuery(string.substring(n10 + "SheetDisplayName:".length()));
                    versionRecord = new VersionRecord(string.substring(n11, n), string.substring(n + "/?vERrT?/".length(), n2), string.substring(n4 + "/?vERpM?/".length(), n5), string.substring(n2 + "/?vERdT?/".length(), n3), string.substring(n3 + "/?vERdTsTr?/".length(), n4), string.substring(n5 + "jrs.version_number".length(), n6), string.substring(n6 + "jrs.expired_time".length(), n7), string.substring(n7 + "jrs.auto_delete_method".length(), n9), null, properties, properties2);
                } else {
                    versionRecord = n8 > 0 ? new VersionRecord(string.substring(n11, n), string.substring(n + "/?vERrT?/".length(), n2), string.substring(n4 + "/?vERpM?/".length(), n5), string.substring(n2 + "/?vERdT?/".length(), n3), string.substring(n3 + "/?vERdTsTr?/".length(), n4), string.substring(n5 + "jrs.version_number".length(), n6), string.substring(n6 + "jrs.expired_time".length(), n7), string.substring(n7 + "jrs.auto_delete_method".length(), n8), string.substring(n8 + "jrs.report_result_types".length())) : new VersionRecord(string.substring(n11, n), string.substring(n + "/?vERrT?/".length(), n2), string.substring(n4 + "/?vERpM?/".length(), n5), string.substring(n2 + "/?vERdT?/".length(), n3), string.substring(n3 + "/?vERdTsTr?/".length(), n4), string.substring(n5 + "jrs.version_number".length(), n6), string.substring(n6 + "jrs.expired_time".length(), n7), string.substring(n7 + "jrs.auto_delete_method".length()), null);
                }
            }
        }
        return versionRecord;
    }

    private static Hashtable _realm(Hashtable hashtable, String string) {
        Hashtable hashtable2;
        Hashtable hashtable3 = hashtable2 = hashtable == null ? new Hashtable() : hashtable;
        if (string != null) {
            hashtable2.put("jrs.cmd", string);
        }
        return hashtable2;
    }

    private static Hashtable _reset(Hashtable hashtable) {
        Hashtable hashtable2 = JRClient._realm(hashtable, "jrs.run_vw");
        hashtable2.put("jrs.task_class", "jet.server.schedule.jrtasks.ViewRptTask");
        hashtable2.put("jrs.result_type", String.valueOf(0));
        return hashtable2;
    }

    public static boolean[] exportTempResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, int n2, int n3, boolean bl11, boolean bl12, boolean bl13) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.exportTempResult(string, string2, string3, string4, string5, string6, string7, string8, string9, bl, bl2, c, bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, bl10, n2, n3, bl11, bl12, bl13, false, 20);
    }

    public static boolean[] exportTempResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, int n2, int n3, boolean bl11, boolean bl12, boolean bl13, boolean bl14, int n4) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.exportTempResult(string, string2, string3, string4, string5, string6, string7, string8, string9, null, bl, bl2, c, bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, bl10, n2, n3, bl11, bl12, bl13, bl14, n4, false, false, true, false);
    }

    public static boolean[] exportTempResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.exportTempResult(string, string2, string3, string4, string5, string6, string7, string8, string9, bl, bl2, c, bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, false, -1, -1, false, false, false, false, -1);
    }

    public static boolean[] exportTempResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.exportTempResult(string, string2, string3, string4, string5, string6, string7, string8, null, bl, bl2, c, bl3, bl4, bl5, bl6, false, false, 0, false);
    }

    public static boolean[] exportTempResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, int n2, int n3, boolean bl11, boolean bl12, boolean bl13, boolean bl14, boolean bl15) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.exportTempResult(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, bl, bl2, c, bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, bl10, n2, n3, bl11, bl12, bl13, false, -1, bl14, bl15, true, true);
    }

    public static boolean[] exportTempResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, int n2, int n3, boolean bl11, boolean bl12, boolean bl13, boolean bl14) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.exportTempResult(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, bl, bl2, c, bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, bl10, n2, n3, bl11, bl12, bl13, false, -1, bl14, true, true);
    }

    public static boolean[] exportTempResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, int n2, int n3, boolean bl11, boolean bl12, boolean bl13, boolean bl14, int n4, boolean bl15, boolean bl16, boolean bl17, boolean bl18) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.exportTempResult(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, bl, bl2, c, bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, bl10, n2, n3, bl11, bl12, bl13, bl14, n4, bl15, bl16, bl17, bl18, false);
    }

    public static boolean[] exportTempResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, int n2, int n3, boolean bl11, boolean bl12, boolean bl13, boolean bl14, int n4, boolean bl15, boolean bl16, boolean bl17) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.exportTempResult(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, bl, bl2, c, bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, bl10, n2, n3, bl11, bl12, bl13, bl14, n4, bl15, bl16, bl17, false);
    }

    public static boolean[] exportTempResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, int n2, int n3, boolean bl11, boolean bl12, boolean bl13, boolean bl14, int n4, boolean bl15, boolean bl16, boolean bl17, boolean bl18, boolean bl19) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.exportTempResult(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, bl, bl2, c, bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, bl10, false, n2, n3, bl11, bl12, bl13, false, -1, bl15, bl16, bl17, bl18, bl19, false);
    }

    public static boolean[] exportTempResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, boolean bl11, int n2, int n3, boolean bl12, boolean bl13, boolean bl14, boolean bl15, int n4, boolean bl16, boolean bl17, boolean bl18, boolean bl19, boolean bl20, boolean bl21) throws MalformedURLException, IOException, JRResponseException {
        String string11 = JRClient.makeViewTempResultURL(string, string2);
        Vector vector = JReportClientRunner.getExportList(string11, string3, string4, string5, string6, string7, string8, string9, string10, bl, bl2, String.valueOf(c), bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, bl10, bl11, n2, n3, bl12, bl13, bl14, bl15, n4, bl16, bl17, bl18, bl19, bl20, bl21);
        boolean[] blArray = JReportClientRunner.getExportFailedIDs(vector);
        JReportClientRunner.download(vector);
        JReportClientRunner.removeExportList(vector);
        return blArray;
    }

    public static boolean[] exportTempResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, boolean bl11, int n2, int n3, boolean bl12, boolean bl13, boolean bl14, boolean bl15, int n4, boolean bl16, boolean bl17, boolean bl18, boolean bl19, boolean bl20) throws MalformedURLException, IOException, JRResponseException {
        String string11 = JRClient.makeViewTempResultURL(string, string2);
        Vector vector = JReportClientRunner.getExportList(string11, string3, string4, string5, string6, string7, string8, string9, string10, bl, bl2, String.valueOf(c), bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, bl10, bl11, n2, n3, bl12, bl13, bl14, bl15, n4, bl16, bl17, bl18, bl19, bl20);
        boolean[] blArray = JReportClientRunner.getExportFailedIDs(vector);
        JReportClientRunner.download(vector);
        JReportClientRunner.removeExportList(vector);
        return blArray;
    }

    public static boolean[] exportTempResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, boolean bl11, int n2, int n3, boolean bl12, boolean bl13, boolean bl14, boolean bl15, int n4, boolean bl16, boolean bl17, boolean bl18, boolean bl19, boolean bl20, boolean bl21, boolean bl22, int n5, String string11, boolean bl23) throws MalformedURLException, IOException, JRResponseException {
        String string12 = JRClient.makeViewTempResultURL(string, string2);
        Vector vector = JReportClientRunner.getExportList(string12, string3, string4, string5, string6, string7, string8, string9, string10, bl, bl2, String.valueOf(c), bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, bl10, bl11, n2, n3, bl12, bl13, bl14, bl15, n4, bl17, bl18, bl19, bl20, bl21, bl22, n5, string11, bl23);
        boolean[] blArray = JReportClientRunner.getExportFailedIDs(vector);
        JReportClientRunner.download(vector);
        JReportClientRunner.removeExportList(vector);
        return blArray;
    }

    public static boolean[] exportTempResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, boolean bl11, int n2, int n3, boolean bl12, boolean bl13, boolean bl14, boolean bl15, int n4, boolean bl16, boolean bl17, boolean bl18, boolean bl19, boolean bl20, boolean bl21, boolean bl22, int n5, String string11, boolean bl23, boolean bl24, boolean bl25, int n6) throws MalformedURLException, IOException, JRResponseException {
        String string12 = JRClient.makeViewTempResultURL(string, string2);
        Vector vector = JReportClientRunner.getExportList(string12, string3, string4, string5, string6, string7, string8, string9, string10, bl, bl2, String.valueOf(c), bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, bl10, bl11, n2, n3, bl12, bl13, bl14, bl15, n4, bl17, bl18, bl19, bl20, bl21, bl22, n5, string11, bl23, bl24, bl25, n6);
        boolean[] blArray = JReportClientRunner.getExportFailedIDs(vector);
        JReportClientRunner.download(vector);
        JReportClientRunner.removeExportList(vector);
        return blArray;
    }

    public static boolean[] exportTempResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, boolean bl11, int n2, int n3, boolean bl12, boolean bl13, boolean bl14, boolean bl15, int n4, boolean bl16, boolean bl17, boolean bl18, boolean bl19, boolean bl20, boolean bl21, boolean bl22, int n5, String string11, boolean bl23, boolean bl24, boolean bl25, int n6, boolean bl26, int n7, boolean bl27, boolean bl28, boolean bl29) throws MalformedURLException, IOException, JRResponseException {
        String string12 = JRClient.makeViewTempResultURL(string, string2);
        Vector vector = JReportClientRunner.getExportList(string12, string3, string4, string5, string6, string7, string8, string9, string10, bl, bl2, String.valueOf(c), bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, bl10, bl11, n2, n3, bl12, bl13, bl14, bl15, n4, bl17, bl18, bl19, bl20, bl21, bl22, n5, string11, bl23, bl24, bl25, n6, bl26, n7, bl27, bl28, bl29, null);
        boolean[] blArray = JReportClientRunner.getExportFailedIDs(vector);
        JReportClientRunner.download(vector);
        JReportClientRunner.removeExportList(vector);
        return blArray;
    }

    public static boolean[] exportTempResultEx(String string, String string2, Hashtable hashtable, boolean bl) throws MalformedURLException, IOException, JRResponseException {
        String string3 = JRClient.makeViewTempResultURL(string, string2);
        String string4 = (String)hashtable.get("jrs.rst");
        String string5 = (String)hashtable.get("jrs.html");
        String string6 = (String)hashtable.get("jrs.pdf");
        String string7 = (String)hashtable.get("jrs.text");
        String string8 = (String)hashtable.get("jrs.excel");
        String string9 = (String)hashtable.get("jrs.ps");
        String string10 = (String)hashtable.get("jrs.rtf");
        String string11 = (String)hashtable.get("jrs.xml");
        boolean bl2 = CSUtil.getBoolean((String)hashtable.get("jrs.is_norm_txt"), true);
        boolean bl3 = CSUtil.getBoolean((String)hashtable.get("jrs.is_repeat"), false);
        String string12 = (String)hashtable.get("jrs.delimiter");
        boolean bl4 = CSUtil.getBoolean((String)hashtable.get("jrs.is_multi_files"), true);
        boolean bl5 = CSUtil.getBoolean((String)hashtable.get("jrs.is_applet_chart"), false);
        boolean bl6 = CSUtil.getBoolean((String)hashtable.get("jrs.has_hyperlink"), true);
        boolean bl7 = CSUtil.getBoolean((String)hashtable.get("jrs.has_page_number"), true);
        boolean bl8 = CSUtil.getBoolean((String)hashtable.get("jrs.use_table"), false);
        boolean bl9 = CSUtil.getBoolean((String)hashtable.get("jrs.relative_font_size"), false);
        int n = CSUtil.parseInt((String)hashtable.get("jrs.web_browser"), 0);
        boolean bl10 = CSUtil.getBoolean((String)hashtable.get("jrs.drilldown"), false);
        boolean bl11 = CSUtil.getBoolean((String)hashtable.get("jrs.no_margin_html"), false);
        boolean bl12 = CSUtil.getBoolean((String)hashtable.get("jrs.is_dhtml"), false);
        int n2 = CSUtil.parseInt((String)hashtable.get("jrs.udchar_width"), -1);
        int n3 = CSUtil.parseInt((String)hashtable.get("jrs.udchar_height"), -1);
        boolean bl13 = CSUtil.getBoolean((String)hashtable.get("jrs.no_margin_pdf"), false);
        boolean bl14 = CSUtil.getBoolean((String)hashtable.get("jrs.no_margin_ps"), false);
        boolean bl15 = CSUtil.getBoolean((String)hashtable.get("jrs.no_margin_rtf"), false);
        boolean bl16 = CSUtil.getBoolean((String)hashtable.get("jrs.print_mode_pdf"), false);
        int n4 = CSUtil.parseInt((String)hashtable.get("jrs.compress_image_pdf"), 20);
        boolean bl17 = CSUtil.getBoolean((String)hashtable.get("jrs.is_xml_multi_files"), false);
        boolean bl18 = CSUtil.getBoolean((String)hashtable.get("jrs.is_only_data"), true);
        boolean bl19 = CSUtil.getBoolean((String)hashtable.get("jrs.is_quotemark"), false);
        boolean bl20 = CSUtil.getBoolean((String)hashtable.get("jrs.hasHeadFoot"), false);
        boolean bl21 = CSUtil.getBoolean((String)hashtable.get("jrs.gif_transparent_pdf"), false);
        boolean bl22 = CSUtil.getBoolean((String)hashtable.get("jrs.txt_compress"), false);
        int n5 = CSUtil.parseInt((String)hashtable.get("jrs.is_wordwrap"), 0);
        String string13 = (String)hashtable.get("jrs.xsdfile");
        boolean bl23 = CSUtil.getBoolean((String)hashtable.get("jrs.excel2000"), false);
        boolean bl24 = CSUtil.getBoolean((String)hashtable.get("jrs.toc_pdf"), false);
        boolean bl25 = CSUtil.getBoolean((String)hashtable.get("jrs.drilldown_pdf"), false);
        int n6 = CSUtil.parseInt((String)hashtable.get("jrs.html_resolution"), -1);
        boolean bl26 = CSUtil.getBoolean((String)hashtable.get("jrs.txt_windows"), true);
        int n7 = CSUtil.parseInt((String)hashtable.get("jrs.text_overflow"), 0);
        boolean bl27 = CSUtil.getBoolean((String)hashtable.get("jrs.has_shapes"), false);
        boolean bl28 = CSUtil.getBoolean((String)hashtable.get("jrs.is_csv"), false);
        boolean bl29 = CSUtil.getBoolean((String)hashtable.get("jrs.is_tab"), false);
        String string14 = (String)hashtable.get("jrs.password_pdf");
        boolean bl30 = CSUtil.getBoolean((String)hashtable.get("jrs.pdf_encrypt"), false);
        boolean bl31 = CSUtil.getBoolean((String)hashtable.get("jrs.pdf_sign"), false);
        boolean bl32 = CSUtil.getBoolean((String)hashtable.get("jrs.pdf_compatibitly"), false);
        String string15 = (String)hashtable.get("jrs.pdf_permis_pasw");
        int n8 = CSUtil.parseInt((String)hashtable.get("jrs.pdf_printallow"), 0);
        int n9 = CSUtil.parseInt((String)hashtable.get("jrs.pdf_changallow"), 0);
        boolean bl33 = CSUtil.getBoolean((String)hashtable.get("jrs.pdf_check_enablecopy"), false);
        boolean bl34 = CSUtil.getBoolean((String)hashtable.get("jrs.pdf_check_enableaccess"), false);
        int n10 = CSUtil.parseInt((String)hashtable.get("jrs.pdf_sign_method"), 0);
        String string16 = (String)hashtable.get("jrs.pdf_digital_path");
        String string17 = (String)hashtable.get("jrs.pdf_user_pasw");
        String string18 = (String)hashtable.get("jrs.pdf_document_reson");
        String string19 = (String)hashtable.get("jrs.pdf_location");
        String string20 = (String)hashtable.get("jrs.pdf_contact_inf");
        int n11 = CSUtil.parseInt((String)hashtable.get("jrs.format_chart"), -1);
        Vector vector = JReportClientRunner.getExportList(string3, string4, string5, string6, string7, string8, string9, string10, string11, bl2, bl3, string12, bl4, bl5, bl6, bl7, bl8, bl9, n, bl10, bl11, bl12, n2, n3, bl13, bl14, bl15, bl16, n4, bl18, bl19, bl20, bl21, bl22, bl, n5, string13, bl23, bl24, bl25, n6, bl26, n7, bl27, bl28, bl29, string14, bl30, bl31, bl32, string15, n8, n9, bl33, bl34, n10, string16, string17, string18, string19, string20, n11);
        boolean[] blArray = JReportClientRunner.getExportFailedIDs(vector);
        JReportClientRunner.download(vector);
        JReportClientRunner.removeExportList(vector);
        return blArray;
    }

    public static boolean[] exportVersionResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, int n2, int n3, boolean bl11, boolean bl12, boolean bl13, boolean bl14, boolean bl15) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.exportVersionResult(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, bl, bl2, c, bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, bl10, n2, n3, bl11, bl12, bl13, false, -1, bl14, bl15, true, true);
    }

    public static boolean[] exportVersionResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, int n2, int n3, boolean bl11, boolean bl12, boolean bl13, boolean bl14) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.exportVersionResult(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, bl, bl2, c, bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, bl10, n2, n3, bl11, bl12, bl13, false, -1, bl14, true, true);
    }

    public static boolean[] exportVersionResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, int n2, int n3, boolean bl11, boolean bl12, boolean bl13, boolean bl14, int n4, boolean bl15, boolean bl16, boolean bl17, boolean bl18) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.exportVersionResult(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, bl, bl2, c, bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, bl10, false, n2, n3, bl11, bl12, bl13, false, -1, bl15, bl16, bl17, bl18, false);
    }

    public static boolean[] exportVersionResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, int n2, int n3, boolean bl11, boolean bl12, boolean bl13, boolean bl14, int n4, boolean bl15, boolean bl16, boolean bl17) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.exportVersionResult(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, bl, bl2, c, bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, bl10, n2, n3, bl11, bl12, bl13, false, -1, bl15, bl16, bl17, false);
    }

    public static boolean[] exportVersionResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, int n2, int n3, boolean bl11, boolean bl12, boolean bl13, boolean bl14, int n4, boolean bl15, boolean bl16, boolean bl17, boolean bl18, boolean bl19) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.exportVersionResult(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, bl, bl2, c, bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, bl10, false, n2, n3, bl11, bl12, bl13, bl14, n4, bl15, bl16, bl17, bl18, bl19, false);
    }

    public static boolean[] exportVersionResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, boolean bl11, int n2, int n3, boolean bl12, boolean bl13, boolean bl14, boolean bl15, int n4, boolean bl16, boolean bl17, boolean bl18, boolean bl19, boolean bl20, boolean bl21) throws MalformedURLException, IOException, JRResponseException {
        String string11 = JRClient.makeViewVersionURL(string, string2);
        Vector vector = JReportClientRunner.getExportList(string11, string3, string4, string5, string6, string7, string8, string9, string10, bl, bl2, String.valueOf(c), bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, bl10, bl11, n2, n3, bl12, bl13, bl14, bl15, n4, bl16, bl17, bl18, bl19, bl20, bl21);
        boolean[] blArray = JReportClientRunner.getExportFailedIDs(vector);
        JReportClientRunner.download(vector);
        JReportClientRunner.removeExportList(vector);
        return blArray;
    }

    public static boolean[] exportVersionResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, boolean bl11, int n2, int n3, boolean bl12, boolean bl13, boolean bl14, boolean bl15, int n4, boolean bl16, boolean bl17, boolean bl18, boolean bl19, boolean bl20) throws MalformedURLException, IOException, JRResponseException {
        String string11 = JRClient.makeViewVersionURL(string, string2);
        Vector vector = JReportClientRunner.getExportList(string11, string3, string4, string5, string6, string7, string8, string9, string10, bl, bl2, String.valueOf(c), bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, bl10, bl11, n2, n3, bl12, bl13, bl14, bl15, n4, bl16, bl17, bl18, bl19, bl20);
        boolean[] blArray = JReportClientRunner.getExportFailedIDs(vector);
        JReportClientRunner.download(vector);
        JReportClientRunner.removeExportList(vector);
        return blArray;
    }

    public static boolean[] exportVersionResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.exportVersionResult(string, string2, string3, string4, string5, string6, string7, string8, null, bl, bl2, c, bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, false, -1, -1, false, false, false, false, -1);
    }

    public static boolean[] exportVersionResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, int n2, int n3, boolean bl11, boolean bl12, boolean bl13) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.exportVersionResult(string, string2, string3, string4, string5, string6, string7, string8, string9, bl, bl2, c, bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, bl10, n2, n3, bl11, bl12, bl13, false, -1);
    }

    public static boolean[] exportVersionResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, int n2, int n3, boolean bl11, boolean bl12, boolean bl13, boolean bl14, int n4) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.exportVersionResult(string, string2, string3, string4, string5, string6, string7, string8, string9, null, bl, bl2, c, bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, bl10, n2, n3, bl11, bl12, bl13, bl14, n4, false, false, true, true);
    }

    public static boolean[] exportVersionResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws MalformedURLException, IOException, JRResponseException {
        return JRClient.exportVersionResult(string, string2, string3, string4, string5, string6, string7, string8, null, bl, bl2, c, bl3, bl4, bl5, bl6, false, false, 0, false, false, -1, -1, false, false, false, false, -1);
    }

    public static boolean[] exportVersionResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, boolean bl11, int n2, int n3, boolean bl12, boolean bl13, boolean bl14, boolean bl15, int n4, boolean bl16, boolean bl17, boolean bl18, boolean bl19, boolean bl20, boolean bl21, boolean bl22, int n5, String string11, boolean bl23) throws MalformedURLException, IOException, JRResponseException {
        String string12 = JRClient.makeViewVersionURL(string, string2);
        Vector vector = JReportClientRunner.getExportList(string12, string3, string4, string5, string6, string7, string8, string9, string10, bl, bl2, String.valueOf(c), bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, bl10, bl11, n2, n3, bl12, bl13, bl14, bl15, n4, bl17, bl18, bl19, bl20, bl21, bl22, n5, string11, bl23);
        boolean[] blArray = JReportClientRunner.getExportFailedIDs(vector);
        JReportClientRunner.download(vector);
        JReportClientRunner.removeExportList(vector);
        return blArray;
    }

    public static boolean[] exportVersionResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, boolean bl11, int n2, int n3, boolean bl12, boolean bl13, boolean bl14, boolean bl15, int n4, boolean bl16, boolean bl17, boolean bl18, boolean bl19, boolean bl20, boolean bl21, boolean bl22, int n5, String string11, boolean bl23, boolean bl24, boolean bl25, int n6) throws MalformedURLException, IOException, JRResponseException {
        String string12 = JRClient.makeViewVersionURL(string, string2);
        Vector vector = JReportClientRunner.getExportList(string12, string3, string4, string5, string6, string7, string8, string9, string10, bl, bl2, String.valueOf(c), bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, bl10, bl11, n2, n3, bl12, bl13, bl14, bl15, n4, bl17, bl18, bl19, bl20, bl21, bl22, n5, string11, bl23, bl24, bl25, n6);
        boolean[] blArray = JReportClientRunner.getExportFailedIDs(vector);
        JReportClientRunner.download(vector);
        JReportClientRunner.removeExportList(vector);
        return blArray;
    }

    public static boolean[] exportVersionResult(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, boolean bl9, boolean bl10, boolean bl11, int n2, int n3, boolean bl12, boolean bl13, boolean bl14, boolean bl15, int n4, boolean bl16, boolean bl17, boolean bl18, boolean bl19, boolean bl20, boolean bl21, boolean bl22, int n5, String string11, boolean bl23, boolean bl24, boolean bl25, int n6, boolean bl26, int n7, boolean bl27, boolean bl28, boolean bl29) throws MalformedURLException, IOException, JRResponseException {
        String string12 = JRClient.makeViewVersionURL(string, string2);
        Vector vector = JReportClientRunner.getExportList(string12, string3, string4, string5, string6, string7, string8, string9, string10, bl, bl2, String.valueOf(c), bl3, bl4, bl5, bl6, bl7, bl8, n, bl9, bl10, bl11, n2, n3, bl12, bl13, bl14, bl15, n4, bl17, bl18, bl19, bl20, bl21, bl22, n5, string11, bl23, bl24, bl25, n6, bl26, n7, bl27, bl28, bl29, null);
        boolean[] blArray = JReportClientRunner.getExportFailedIDs(vector);
        JReportClientRunner.download(vector);
        JReportClientRunner.removeExportList(vector);
        return blArray;
    }

    public static boolean[] exportVersionResultEx(String string, String string2, Hashtable hashtable, boolean bl) throws MalformedURLException, IOException, JRResponseException {
        String string3 = JRClient.makeViewVersionURL(string, string2);
        String string4 = (String)hashtable.get("jrs.rst");
        String string5 = (String)hashtable.get("jrs.html");
        String string6 = (String)hashtable.get("jrs.pdf");
        String string7 = (String)hashtable.get("jrs.text");
        String string8 = (String)hashtable.get("jrs.excel");
        String string9 = (String)hashtable.get("jrs.ps");
        String string10 = (String)hashtable.get("jrs.rtf");
        String string11 = (String)hashtable.get("jrs.xml");
        boolean bl2 = CSUtil.getBoolean((String)hashtable.get("jrs.is_norm_txt"), true);
        boolean bl3 = CSUtil.getBoolean((String)hashtable.get("jrs.is_repeat"), false);
        String string12 = (String)hashtable.get("jrs.delimiter");
        boolean bl4 = CSUtil.getBoolean((String)hashtable.get("jrs.is_multi_files"), true);
        boolean bl5 = CSUtil.getBoolean((String)hashtable.get("jrs.is_applet_chart"), false);
        boolean bl6 = CSUtil.getBoolean((String)hashtable.get("jrs.has_hyperlink"), true);
        boolean bl7 = CSUtil.getBoolean((String)hashtable.get("jrs.has_page_number"), true);
        boolean bl8 = CSUtil.getBoolean((String)hashtable.get("jrs.use_table"), false);
        boolean bl9 = CSUtil.getBoolean((String)hashtable.get("jrs.relative_font_size"), false);
        int n = CSUtil.parseInt((String)hashtable.get("jrs.web_browser"), 0);
        boolean bl10 = CSUtil.getBoolean((String)hashtable.get("jrs.drilldown"), false);
        boolean bl11 = CSUtil.getBoolean((String)hashtable.get("jrs.no_margin_html"), false);
        boolean bl12 = CSUtil.getBoolean((String)hashtable.get("jrs.is_dhtml"), false);
        int n2 = CSUtil.parseInt((String)hashtable.get("jrs.udchar_width"), -1);
        int n3 = CSUtil.parseInt((String)hashtable.get("jrs.udchar_height"), -1);
        boolean bl13 = CSUtil.getBoolean((String)hashtable.get("jrs.no_margin_pdf"), false);
        boolean bl14 = CSUtil.getBoolean((String)hashtable.get("jrs.no_margin_ps"), false);
        boolean bl15 = CSUtil.getBoolean((String)hashtable.get("jrs.no_margin_rtf"), false);
        boolean bl16 = CSUtil.getBoolean((String)hashtable.get("jrs.print_mode_pdf"), false);
        int n4 = CSUtil.parseInt((String)hashtable.get("jrs.compress_image_pdf"), 20);
        boolean bl17 = CSUtil.getBoolean((String)hashtable.get("jrs.is_xml_multi_files"), false);
        boolean bl18 = CSUtil.getBoolean((String)hashtable.get("jrs.is_only_data"), true);
        boolean bl19 = CSUtil.getBoolean((String)hashtable.get("jrs.is_quotemark"), false);
        boolean bl20 = CSUtil.getBoolean((String)hashtable.get("jrs.hasHeadFoot"), false);
        boolean bl21 = CSUtil.getBoolean((String)hashtable.get("jrs.gif_transparent_pdf"), false);
        boolean bl22 = CSUtil.getBoolean((String)hashtable.get("jrs.txt_compress"), false);
        int n5 = CSUtil.parseInt((String)hashtable.get("jrs.is_wordwrap"), 0);
        String string13 = (String)hashtable.get("jrs.xsdfile");
        boolean bl23 = CSUtil.getBoolean((String)hashtable.get("jrs.excel2000"), false);
        boolean bl24 = CSUtil.getBoolean((String)hashtable.get("jrs.toc_pdf"), false);
        boolean bl25 = CSUtil.getBoolean((String)hashtable.get("jrs.drilldown_pdf"), false);
        int n6 = CSUtil.parseInt((String)hashtable.get("jrs.html_resolution"), -1);
        boolean bl26 = CSUtil.getBoolean((String)hashtable.get("jrs.txt_windows"), true);
        int n7 = CSUtil.parseInt((String)hashtable.get("jrs.text_overflow"), 0);
        boolean bl27 = CSUtil.getBoolean((String)hashtable.get("jrs.has_shapes"), false);
        boolean bl28 = CSUtil.getBoolean((String)hashtable.get("jrs.is_csv"), false);
        boolean bl29 = CSUtil.getBoolean((String)hashtable.get("jrs.is_tab"), false);
        String string14 = (String)hashtable.get("jrs.password_pdf");
        boolean bl30 = CSUtil.getBoolean((String)hashtable.get("jrs.pdf_encrypt"), false);
        boolean bl31 = CSUtil.getBoolean((String)hashtable.get("jrs.pdf_sign"), false);
        boolean bl32 = CSUtil.getBoolean((String)hashtable.get("jrs.pdf_compatibitly"), false);
        String string15 = (String)hashtable.get("jrs.pdf_permis_pasw");
        int n8 = CSUtil.parseInt((String)hashtable.get("jrs.pdf_printallow"), 0);
        int n9 = CSUtil.parseInt((String)hashtable.get("jrs.pdf_changallow"), 0);
        boolean bl33 = CSUtil.getBoolean((String)hashtable.get("jrs.pdf_check_enablecopy"), false);
        boolean bl34 = CSUtil.getBoolean((String)hashtable.get("jrs.pdf_check_enableaccess"), false);
        int n10 = CSUtil.parseInt((String)hashtable.get("jrs.pdf_sign_method"), 0);
        String string16 = (String)hashtable.get("jrs.pdf_digital_path");
        String string17 = (String)hashtable.get("jrs.pdf_user_pasw");
        String string18 = (String)hashtable.get("jrs.pdf_document_reson");
        String string19 = (String)hashtable.get("jrs.pdf_location");
        String string20 = (String)hashtable.get("jrs.pdf_contact_inf");
        int n11 = CSUtil.parseInt((String)hashtable.get("jrs.format_chart"), -1);
        Vector vector = JReportClientRunner.getExportList(string3, string4, string5, string6, string7, string8, string9, string10, string11, bl2, bl3, String.valueOf(string12), bl4, bl5, bl6, bl7, bl8, bl9, n, bl10, bl11, bl12, n2, n3, bl13, bl14, bl15, bl16, n4, bl18, bl19, bl20, bl21, bl22, bl, n5, string13, bl23, bl24, bl25, n6, bl26, n7, bl27, bl28, bl29, string14, bl30, bl31, bl32, string15, n8, n9, bl33, bl34, n10, string16, string17, string18, string19, string20, n11);
        boolean[] blArray = JReportClientRunner.getExportFailedIDs(vector);
        JReportClientRunner.download(vector);
        JReportClientRunner.removeExportList(vector);
        return blArray;
    }

    public static boolean isTempResultReady(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        Object var3_3 = null;
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.is_temp_result_ready");
        hashtable.put("jrs.file", string2);
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        if (APIUtil.getResponseCode(uRLConnection) == 202) {
            JRClient.close(uRLConnection);
            return false;
        }
        APIUtil.checkResponseOK(uRLConnection);
        JRClient.close(uRLConnection);
        return true;
    }

    public static void waitTempResultReady(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException, TimeoutException {
        JRClient.waitTempResultReady(frame, string, string2, 0);
    }

    public static void waitTempResultReady(Frame frame, String string, String string2, int n) throws MalformedURLException, IOException, JRResponseException, TimeoutException {
        long l = System.currentTimeMillis();
        while (!JRClient.isTempResultReady(frame, string, string2)) {
            try {
                Thread.sleep(500L);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (n <= 0 || System.currentTimeMillis() - l <= (long)n) continue;
            throw new TimeoutException(810001);
        }
    }

    public static InputStream getTempResultInputStream(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException, TimeoutException {
        return JRClient.getTempResultInputStream(frame, string, string2, 0);
    }

    public static InputStream getTempResultInputStream(Frame frame, String string, String string2, int n) throws MalformedURLException, IOException, JRResponseException, TimeoutException {
        JRClient.waitTempResultReady(frame, string, string2, n);
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.get_temp_result");
        hashtable.put("jrs.file", string2);
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        return uRLConnection.getInputStream();
    }

    public static InputStream getFoldersInputStream(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException, TimeoutException {
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.refresh_folders");
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        return uRLConnection.getInputStream();
    }

    public static String downloadResultFiles(Frame frame, String string, String string2, String string3, String string4, String string5) throws MalformedURLException, IOException, JRResponseException, TimeoutException {
        String[] stringArray = null;
        stringArray = JRClient._user(frame, string, string2, string3, string4, null);
        int n = stringArray.length;
        String string6 = string5;
        for (int i = 0; i < n; ++i) {
            JRClient.add(frame, string, string2, string3, stringArray[i], string6 + stringArray[i]);
        }
        if (n < 1) {
            return null;
        }
        return string6 + stringArray[0];
    }

    public static String downloadResultFiles(Frame frame, String string, String string2, String string3, String string4, String string5, String string6) throws MalformedURLException, IOException, JRResponseException, TimeoutException {
        String[] stringArray = null;
        stringArray = JRClient._user(frame, string, string2, string3, string4, string6);
        int n = stringArray.length;
        String string7 = string5;
        for (int i = 0; i < n; ++i) {
            JRClient.add(frame, string, string2, string3, stringArray[i], string7 + stringArray[i]);
        }
        if (n < 1) {
            return null;
        }
        return string7 + stringArray[0];
    }

    public static boolean hasResultFiles(Frame frame, String string, String string2, String string3, String string4, String string5) throws MalformedURLException, IOException, JRResponseException, TimeoutException {
        String[] stringArray = null;
        stringArray = JRClient._user(frame, string, string2, string3, string4, null);
        return stringArray != null;
    }

    private static String[] _user(Frame frame, String string, String string2, String string3, String string4, String string5) throws IOException, JRResponseException {
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.get_file_list_of_this_type");
        hashtable.put("jrs.report", string2);
        hashtable.put("jrs.version_number", string3);
        hashtable.put("jrs.result_type", string4);
        if (string5 != null) {
            hashtable.put("jrs.report_sheet", string5);
        }
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        boolean bl = string4.equalsIgnoreCase("html");
        boolean bl2 = string4.equalsIgnoreCase("gif");
        boolean bl3 = string4.equalsIgnoreCase("jpg");
        boolean bl4 = string4.equalsIgnoreCase("jar");
        boolean bl5 = string4.equalsIgnoreCase("png");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string6 = null;
        int n = 0;
        try {
            string6 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            JDebug.WARNING(iOException);
            JOptionPane.showMessageDialog(null, iOException.getMessage(), "Error", 0);
        }
        n = Integer.parseInt(string6);
        String[] stringArray = null;
        if (n > 1 || bl || bl3 || bl4 || bl2 || bl5) {
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                try {
                    stringArray[i] = bufferedReader.readLine();
                    continue;
                }
                catch (IOException iOException) {
                    JDebug.WARNING(iOException);
                    JOptionPane.showMessageDialog(null, iOException.getMessage(), "Error", 0);
                }
            }
        } else if (n == 1) {
            stringArray = new String[]{bufferedReader.readLine()};
        }
        JRClient.close(uRLConnection);
        return stringArray;
    }

    private static void add(Frame frame, String string, String string2, String string3, String string4, String string5) throws MalformedURLException, IOException, JRResponseException, TimeoutException {
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.get_report_any_result");
        hashtable.put("jrs.report", string2);
        hashtable.put("jrs.version_number", string3);
        hashtable.put("jrs.result", string4);
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        InputStream inputStream = uRLConnection.getInputStream();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string5);
            byte[] byArray = new byte[65535];
            int n = 0;
            while ((n = inputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            JDebug.WARNING(exception);
            JOptionPane.showMessageDialog(null, exception.getMessage(), "Error", 0);
        }
        JRClient.close(uRLConnection);
    }

    public static InputStream getSelectedFolderComment(Frame frame, String string) throws IOException, JRResponseException {
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.get_folder_files");
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        return uRLConnection.getInputStream();
    }

    public static Vector getEnabledCustomFieldNames(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException, ClassNotFoundException {
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.get_custom_field_names");
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        ObjectInputStream objectInputStream = new ObjectInputStream(uRLConnection.getInputStream());
        Vector vector = (Vector)objectInputStream.readObject();
        objectInputStream.close();
        JRClient.close(uRLConnection);
        return vector;
    }

    public static Vector getCatRptsInfos(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        Vector vector = new Vector();
        String string3 = "?jrs.cmd=jrs.get_folder_cats_rpts&jrs.path=" + string2;
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string3, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        vector = DownloadNodeInfo.parseNodeInfoStream(bufferedReader);
        bufferedReader.close();
        return vector;
    }

    public static Vector getCatLCsInfos(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        Vector vector = new Vector();
        String string3 = "?jrs.cmd=jrs.get_folder_cats_lcs&jrs.path=" + string2;
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string3, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        vector = DownloadNodeInfo.parseNodeInfoStream(bufferedReader);
        bufferedReader.close();
        return vector;
    }

    public static String[] getSupportedEncodingNames() {
        return EncodingSupport.getSupportedEncodingNames();
    }

    public static boolean getSSL() {
        return useSSL;
    }

    public static boolean setSSL(boolean bl) {
        boolean bl2 = true;
        if (useSSL != bl) {
            useSSL = bl;
            if (bl) {
                try {
                    Security.addProvider((Provider)Class.forName("com.sun.net.ssl.internal.ssl.Provider").newInstance());
                    Properties properties = System.getProperties();
                    properties.put("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                    System.setProperties(properties);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Frame frame = new Frame();
                    ShowMessageDialog.showMessageDialog(frame, JCliResource.getMessage("CS_MSG_182"));
                    bl2 = false;
                }
                catch (InstantiationException instantiationException) {
                    JDebug.WARNING(instantiationException.getMessage());
                    bl2 = false;
                }
                catch (IllegalAccessException illegalAccessException) {
                    JDebug.WARNING(illegalAccessException.getMessage());
                    bl2 = false;
                }
            }
        }
        return bl2;
    }

    public static boolean isNoLoginDialog() {
        return BaseJRClient.isNoLoginDialog();
    }

    public static void setNoLoginDialog(boolean bl) {
        BaseJRClient.setNoLoginDialog(bl);
    }

    private static Hashtable addElement(String string, String string2) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            if (string2 == null || string2.trim().length() == 0) {
                return hashtable;
            }
            String string3 = string2 + ",";
            int n = string3.indexOf("]],");
            n = n >= 0 ? n : (string3.length() > 0 ? string3.length() : 0);
            n = n > 0 ? n + 2 : n;
            String string4 = string3;
            string4 = string3.substring(0, n).trim();
            n = n > 0 ? n + 1 : n;
            string3 = string3.substring(n);
            while (string4 != null && string4.length() > 0) {
                int n2 = string4.indexOf("=");
                String string5 = string4.substring(0, n2);
                String string6 = string4.substring(n2 + 1).trim();
                string6 = string6.substring(1, string6.length() - 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string6, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string7 = stringTokenizer.nextToken().trim();
                    if (string7.equals("JPermission[read : -1]")) {
                        hashtable.put(string + "$" + string5 + "." + "read", "true");
                        continue;
                    }
                    if (string7.equals("JPermission[write : -1]")) {
                        hashtable.put(string + "$" + string5 + "." + "write", "true");
                        continue;
                    }
                    if (string7.equals("JPermission[delete : -1]")) {
                        hashtable.put(string + "$" + string5 + "." + "delete", "true");
                        continue;
                    }
                    if (string7.equals("JPermission[visible : -1]")) {
                        hashtable.put(string + "$" + string5 + "." + "visible", "true");
                        continue;
                    }
                    if (string7.equals("JPermission[execute : -1]")) {
                        hashtable.put(string + "$" + string5 + "." + "execute", "true");
                        continue;
                    }
                    if (string7.equals("JPermission[schedule : -1]")) {
                        hashtable.put(string + "$" + string5 + "." + "schedule", "true");
                        continue;
                    }
                    if (!string7.equals("JPermission[grant : -1]")) continue;
                    hashtable.put(string + "$" + string5 + "." + "grant", "true");
                }
                n = string3.indexOf("]],");
                n = n >= 0 ? n : (string3.length() > 0 ? string3.length() : 0);
                n = n > 0 ? n + 2 : n;
                string4 = string3.substring(0, n).trim();
                n = n > 0 ? n + 1 : n;
                string3 = string3.substring(n);
            }
        }
        catch (Exception exception) {
            JDebug.WARNING(exception);
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getVersionProperties(Frame frame, String string, Hashtable hashtable) throws IOException, JRResponseException {
        Hashtable<String, Hashtable> hashtable2 = new Hashtable<String, Hashtable>();
        String string2 = null;
        int n = CSUtil.parseInt((String)hashtable.get("type"));
        if (n == 0 || n == 4) {
            string2 = "jrs.get_rpt_ver_prop";
        } else if (n == 1) {
            string2 = "jrs.get_rst_ver_prop";
        } else if (n == 2 || n == 3) {
            string2 = "jrs.get_rstdoc_ver_prop";
        }
        String string3 = APIUtil.makeQuery(hashtable);
        string3 = "?jrs.cmd=" + string2 + "&" + string3;
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, string3);
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string4 = null;
        Properties properties = null;
        try {
            string4 = bufferedReader.readLine();
            if (string4 != null) {
                properties = CSUtil.parseQuery(string4);
                String string5 = (String)((Hashtable)properties).get("USER_PERMISSION");
                if (string5 != null && string5.startsWith("{") && string5.endsWith("}")) {
                    string5 = string5.substring(1, string5.length() - 1);
                }
                hashtable2.put("USER_PERMISSION", JRClient.addElement("jrs.user_permission", string5));
                string5 = (String)((Hashtable)properties).get("ROLE_PERMISSION");
                if (string5 != null && string5.startsWith("{") && string5.endsWith("}")) {
                    string5 = string5.substring(1, string5.length() - 1);
                }
                hashtable2.put("ROLE_PERMISSION", JRClient.addElement("jrs.role_permission", string5));
                string5 = (String)((Hashtable)properties).get("GROUP_PERMISSION");
                if (string5 != null && string5.startsWith("{") && string5.endsWith("}")) {
                    string5 = string5.substring(1, string5.length() - 1);
                }
                hashtable2.put("GROUP_PERMISSION", JRClient.addElement("jrs.group_permission", string5));
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return hashtable2;
    }

    public static void saveVersionProperties(Frame frame, String string, Hashtable hashtable) throws IOException, JRResponseException {
        Hashtable hashtable2 = new Hashtable();
        String string2 = null;
        String string3 = null;
        int n = CSUtil.parseInt((String)hashtable.get("type"));
        if (n == 0) {
            string2 = "jrs.save_rpt_ver_prop";
            hashtable.remove("jrs.result");
            string3 = (String)hashtable.get("jrs.report");
            hashtable.put("jrs.path", string3);
        } else if (n == 1) {
            string2 = "jrs.save_rst_ver_prop";
            hashtable.remove("jrs.result");
            string3 = (String)hashtable.get("jrs.report");
            hashtable.put("resultInReportProp", "true");
            hashtable.put("jrs.path", string3);
        } else if (n == 2 || n == 3) {
            string2 = "jrs.save_rstdoc_ver_prop";
            hashtable.remove("jrs.report");
            string3 = (String)hashtable.get("jrs.result");
            hashtable.put("jrs.path", string3);
        }
        String string4 = APIUtil.makeQuery(hashtable);
        string4 = "?jrs.cmd=" + string2 + "&" + string4;
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, string4);
        APIUtil.checkResponseOK(uRLConnection);
        JRClient.close(uRLConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkPermission(Frame frame, String string, String string2, String string3, String string4) throws IOException, JRResponseException {
        boolean bl = false;
        string3 = CSUtil.escapeURLPath(string3);
        String string5 = "?jrs.cmd=jrs.check_permission&jrs.user=" + string2 + "&" + "jrs.path" + "=" + string3 + "&" + "jrs.permission_values" + "=" + string4;
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string5, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string6 = null;
        try {
            string6 = bufferedReader.readLine();
            if (string6 != null) {
                bl = CSUtil.getBoolean(string6);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOnlyContainBurstRpt(Frame frame, String string, String string2, String string3, String string4) throws IOException, JRResponseException {
        boolean bl = false;
        String string5 = "?jrs.cmd=jrs.check_reportset&jrs.user=" + string2 + "&" + "jrs.catalog" + "=" + string3 + "&" + "jrs.report" + "=" + string4;
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string5, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string6 = null;
        try {
            string6 = bufferedReader.readLine();
            if (string6 != null) {
                bl = CSUtil.getBoolean(string6);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNoBurstRpt(Frame frame, String string, String string2, Hashtable hashtable) throws IOException, JRResponseException {
        boolean bl = true;
        if (hashtable != null) {
            String string3 = (String)hashtable.get("jrs.catalog");
            String string4 = (String)hashtable.get("jrs.report");
            String string5 = (String)hashtable.get("jrs.cat_version");
            String string6 = (String)hashtable.get("jrs.rpt_version");
            if (string3 != null && string4 != null) {
                String string7 = "?jrs.cmd=jrs.check_noburst&jrs.user=" + string2 + "&" + "jrs.catalog" + "=" + string3 + "&" + "jrs.report" + "=" + string4 + "&" + "jrs.cat_version" + string5 + "&" + "jrs.rpt_version" + string6;
                URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string7, ".=_-|;&<>$/:?\""));
                APIUtil.checkResponseOK(uRLConnection);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                String string8 = null;
                try {
                    string8 = bufferedReader.readLine();
                    if (string8 != null) {
                        bl = CSUtil.getBoolean(string8);
                    }
                }
                finally {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception) {
                            JDebug.WARNING(exception);
                        }
                    }
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean currentRptIsBursting(Frame frame, String string, String string2, String string3, String string4) throws IOException, JRResponseException {
        boolean bl = false;
        String string5 = "?jrs.cmd=jrs.check_currentreport&jrs.user=" + string2 + "&" + "jrs.catalog" + "=" + string3 + "&" + "jrs.report" + "=" + string4;
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string5, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string6 = null;
        try {
            string6 = bufferedReader.readLine();
            if (string6 != null) {
                bl = CSUtil.getBoolean(string6);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkPrivilege(Frame frame, String string, String string2, String string3) throws IOException, JRResponseException {
        boolean bl = false;
        String string4 = "?jrs.cmd=jrs.check_privilege&jrs.user=" + string2 + "&" + "jrs.permission_values" + "=" + string3;
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string4, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string5 = null;
        try {
            string5 = bufferedReader.readLine();
            if (string5 != null) {
                bl = CSUtil.getBoolean(string5);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAdminUser(Frame frame, String string, String string2) throws IOException, JRResponseException {
        boolean bl = false;
        String string3 = "?jrs.cmd=jrs.is_admin_user&jrs.user=" + string2;
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string3, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string4 = null;
        try {
            string4 = bufferedReader.readLine();
            if (string4 != null) {
                bl = CSUtil.getBoolean(string4);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEnableDuration(Frame frame, String string) throws IOException, JRResponseException {
        boolean bl = false;
        String string2 = "?jrs.cmd=jrs.is_enable_duration";
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string2, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string3 = null;
        try {
            string3 = bufferedReader.readLine();
            if (string3 != null) {
                bl = CSUtil.getBoolean(string3);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return bl;
    }

    private static void addProvider(Frame frame, String string, Hashtable hashtable) throws IOException, JRResponseException {
        Object object;
        Object object2;
        boolean bl = CSUtil.getBoolean((String)hashtable.get("jrs.is_deploy_locally"), false);
        String string2 = (String)hashtable.get("jrs.deploy_from_file");
        int n = CSUtil.parseInt((String)hashtable.get("jrs.node_type"));
        boolean bl2 = CSUtil.getBoolean((String)hashtable.get("jrs.folder_with_contents"), true);
        boolean bl3 = CSUtil.getBoolean((String)hashtable.get("jrs.only_deploy_files_and_subfolders"), false);
        boolean bl4 = CSUtil.getBoolean((String)hashtable.get("jrs.only_deploy_files"), false);
        if (n == 0 || n == 2) {
            object2 = new File(string2);
            object = ((File)object2).getParentFile();
            string2 = ((File)object).getPath();
        }
        if (!bl && string2 != null && string2 != null && string2.trim().length() > 0 && (n != 3 || bl2 || bl3 || bl4)) {
            object2 = JRClient.addURLQuery(frame, string, string2, hashtable, "", null);
            hashtable.put("jrs.deploy_key", object2);
        }
        hashtable.put("FileSeparator", File.separator);
        hashtable.put("jrs.cmd", "jrs.import_resource");
        hashtable.put("jrs.is_plain", "true");
        if (hashtable.get("jrs.is_advance_deploy") == null) {
            hashtable.put("jrs.is_advance_deploy", "false");
        }
        object2 = (java.net.HttpURLConnection)new URL(new java.net.URL(string)).openConnection();
        ((java.net.HttpURLConnection)object2).setRequestMethod("POST");
        JRClient.setUserAgent((URLConnection)object2);
        ((URLConnection)object2).setRequestProperty("jrs.cmd", "jrs.import_resource");
        ((URLConnection)object2).setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        ((URLConnection)object2).setDoOutput(true);
        object = new BufferedWriter(new OutputStreamWriter(((URLConnection)object2).getOutputStream()));
        String string3 = CSUtil.makeNoHeadQuery(hashtable);
        ((Writer)object).write(string3);
        ((BufferedWriter)object).close();
        APIUtil.checkResponseOK((URLConnection)object2);
        JRClient.close((URLConnection)object2);
    }

    public static void advancedDeploy(Frame frame, String string, Hashtable hashtable) throws IOException, JRResponseException {
        hashtable.put("jrs.is_advance_deploy", "true");
        hashtable.put("jrs.node_type", String.valueOf(3));
        JRClient.addProvider(frame, string, hashtable);
    }

    public static void deploy(Frame frame, String string, Hashtable hashtable) throws IOException, JRResponseException {
        hashtable.put("jrs.is_advance_deploy", "false");
        JRClient.addProvider(frame, string, hashtable);
    }

    public static Hashtable getRptReferFilesInfo(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException, ClassNotFoundException {
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.get_rpt_files_info");
        hashtable.put("jrs.node_real_path", string2);
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        ObjectInputStream objectInputStream = new ObjectInputStream(uRLConnection.getInputStream());
        Hashtable hashtable2 = (Hashtable)objectInputStream.readObject();
        objectInputStream.close();
        JRClient.close(uRLConnection);
        return hashtable2;
    }

    public static Hashtable getLCReferFilesInfo(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException, ClassNotFoundException {
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.get_lc_files_info");
        hashtable.put("jrs.node_real_path", string2);
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        ObjectInputStream objectInputStream = new ObjectInputStream(uRLConnection.getInputStream());
        Hashtable hashtable2 = (Hashtable)objectInputStream.readObject();
        objectInputStream.close();
        JRClient.close(uRLConnection);
        return hashtable2;
    }

    public static Hashtable getCatReferFilesInfo(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException, ClassNotFoundException {
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.get_cat_files_info");
        hashtable.put("jrs.node_real_path", string2);
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        ObjectInputStream objectInputStream = new ObjectInputStream(uRLConnection.getInputStream());
        Hashtable hashtable2 = (Hashtable)objectInputStream.readObject();
        objectInputStream.close();
        JRClient.close(uRLConnection);
        return hashtable2;
    }

    private static String addURLPath(String string, String string2, String string3) {
        if (string.endsWith(string3)) {
            return string + string2;
        }
        return string + string3 + string2;
    }

    private static String addURLQuery(Frame frame, String string, String string2, Hashtable hashtable, String string3, String string4) throws IOException, JRResponseException {
        System.gc();
        Vector vector = null;
        if ((string4 == null || string4.trim().length() == 0) && (vector = JRClient.addUrlPaths("CreateFolder", string, null, null, null)) != null) {
            string4 = (String)vector.get(1);
        }
        if (string4 != null) {
            String string5 = string4;
            File file = new File(string2);
            if (file != null && file.exists()) {
                File[] fileArray = file.listFiles();
                string3 = string3 == null || string3.trim().length() == 0 ? File.separator : string3;
                string3 = string3.trim();
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    String string6 = JRClient.addURLPath(string3, file2.getName(), File.separator);
                    if (file2.isDirectory()) {
                        JRClient.addURLQuery(frame, string, file2.getPath(), hashtable, string6, string4);
                        continue;
                    }
                    JRClient.addUrlPaths("ReadFile", string, file2, string6, string5);
                }
            }
        }
        if (vector == null) {
            return null;
        }
        return (String)vector.get(0);
    }

    private static Vector addUrlPaths(String string, String string2, File file, String string3, String string4) throws IOException {
        if (string == null) {
            return null;
        }
        System.gc();
        java.net.HttpURLConnection httpURLConnection = (java.net.HttpURLConnection)new URL(new java.net.URL(string2)).openConnection();
        httpURLConnection.setRequestMethod("POST");
        JRClient.setUserAgent(httpURLConnection);
        String string5 = "-----------------------------" + Long.toHexString(System.currentTimeMillis());
        httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string5.substring(2));
        httpURLConnection.setDoOutput(true);
        string = string.trim();
        if (string.equalsIgnoreCase("CreateFolder")) {
            httpURLConnection.setRequestProperty("DeployUploadCmd", string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            Vector<String> vector = new Vector<String>();
            String string6 = bufferedReader.readLine();
            vector.add(0, string6);
            string6 = bufferedReader.readLine();
            vector.add(1, string6);
            bufferedReader.close();
            return vector;
        }
        if (string.equalsIgnoreCase("ReadFile")) {
            int n;
            string3 = string3 == null ? File.separator : string3;
            string = string + string4;
            httpURLConnection.setRequestProperty("DeployUploadCmd", string);
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            byte[] byArray = new byte[1024];
            ZipEntry zipEntry = new ZipEntry(string3);
            ZipOutputStream zipOutputStream = new ZipOutputStream(httpURLConnection.getOutputStream());
            zipOutputStream.putNextEntry(zipEntry);
            while ((n = bufferedInputStream.read(byArray, 0, 1024)) >= 0) {
                zipOutputStream.write(byArray, 0, n);
            }
            zipOutputStream.close();
            bufferedInputStream.close();
            fileInputStream.close();
        }
        JRClient.close(httpURLConnection);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getCustomizeControlNames(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "?jrs.cmd=jrs.get_customize_control_names";
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string2, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string3 = null;
        try {
            while (null != (string3 = bufferedReader.readLine())) {
                arrayList.add(string3);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List downloadCustomizeControls(Frame frame, String string, List list, File file) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (String string2 : list) {
                String string3 = "?jrs.cmd=jrs.download_customize_control&jrs.file=" + string2;
                URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string3, ".=_-|;&<>$/:?\""));
                int n = APIUtil.getResponseCode(uRLConnection);
                if (n != 200) {
                    throw new Exception(JCliResource.getMessage("CLI_ERR_15", (Object)String.valueOf(n)) + "!\n" + string.toString());
                }
                File file2 = new File(file, string2);
                DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
                int n2 = uRLConnection.getContentLength();
                int n3 = 0;
                int n4 = 8192;
                byte[] byArray = new byte[n4];
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                try {
                    int n5 = 0;
                    int n6 = n2 - n5;
                    while (n6 > 0 && (n3 = dataInputStream.read(byArray, 0, n6 > n4 ? n4 : n6)) > 0) {
                        fileOutputStream.write(byArray, 0, n3);
                        n6 = n2 - (n5 += n3);
                    }
                    arrayList.add(string2);
                }
                finally {
                    fileOutputStream.close();
                    dataInputStream.close();
                }
            }
        }
        return arrayList;
    }

    public static void connect(Frame frame, String string, int n, String string2, boolean bl, String string3, String string4) throws MalformedURLException, IOException, JRResponseException {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException(JCliResource.getMessage("CLI_ERR_100_HOSTISNULL"));
        }
        JRClient.setSSL(bl);
        String string5 = "http";
        if (bl) {
            string5 = "https";
        }
        String string6 = string2 = string2 == null ? "" : string2;
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        java.net.URL uRL = new java.net.URL(string5, string, n, string2);
        if (string3 == null || string3.equals("")) {
            JRClient.login(frame, uRL.toString());
        } else {
            JRClient.login(frame, uRL.toString(), string3, string4);
        }
    }

    public static String getRealPath(Frame frame, String string, String string2, int n, int n2) throws IOException, JRResponseException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("jrs.cmd", "jrs.get_real_path");
        hashtable.put("jrs.node_name", string2);
        hashtable.put("jrs.version_number", String.valueOf(n));
        hashtable.put("jrs.node_type", String.valueOf(n2));
        URLConnection uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string3 = null;
        string3 = bufferedReader.readLine();
        JRClient.close(uRLConnection);
        return string3;
    }

    public static int getLatestVersionNumber(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        if (string2 == null || string2.trim().length() == 0) {
            return -1;
        }
        string2 = CSUtil.escapeURLPath(string2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("?").append("jrs.cmd").append("=").append("jrs.get_latest_version_number");
        stringBuffer.append("&").append("jrs.path").append("=").append(string2);
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(stringBuffer.toString(), ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string3 = null;
        string3 = bufferedReader.readLine();
        bufferedReader.close();
        JRClient.close(uRLConnection);
        return CSUtil.parseInt(string3, -1);
    }

    public static boolean canExportDhtmlResult(Frame frame, String string, Hashtable hashtable) throws MalformedURLException, IOException, JRResponseException {
        if (hashtable == null) {
            return false;
        }
        Object v = hashtable.get("jrs.report");
        Object v2 = hashtable.get("jrs.catalog");
        Object v3 = hashtable.get("jrs.rpt_version");
        Object v4 = hashtable.get("jrs.cat_version");
        if (v == null) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("?").append("jrs.cmd").append("=").append("jrs.can_export_dhtml_result");
        if (v != null) {
            stringBuffer.append("&").append("jrs.report").append("=").append((String)v);
        }
        if (v2 != null) {
            stringBuffer.append("&").append("jrs.catalog").append("=").append((String)v2);
        }
        if (v3 != null) {
            stringBuffer.append("&").append("jrs.rpt_version").append("=").append((String)v3);
        }
        if (v4 != null) {
            stringBuffer.append("&").append("jrs.cat_version").append("=").append((String)v4);
        }
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(stringBuffer.toString(), ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string2 = null;
        string2 = bufferedReader.readLine();
        bufferedReader.close();
        JRClient.close(uRLConnection);
        return CSUtil.getBoolean(string2, false);
    }

    public static Hashtable getCompletedPublishRecords(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException {
        if (string2 == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("?").append("jrs.cmd").append("=").append("jrs.get_succ_info");
        stringBuffer.append("&").append("jrs.id").append("=").append(string2);
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(stringBuffer.toString(), ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string3 = null;
        string3 = bufferedReader.readLine();
        Hashtable hashtable = new Hashtable();
        while (string3 != null) {
            Vector<JCliCompletedPublishRecord> vector = new Vector<JCliCompletedPublishRecord>();
            Properties properties = CSUtil.parseQuery(string3);
            String string4 = (String)((Hashtable)properties).get("jrs.report_sheet");
            int n = CSUtil.parseInt((String)((Hashtable)properties).get("count"), 0);
            for (int i = 0; i < n; ++i) {
                Vector<JCliCompletedResultRecord> vector2 = new Vector<JCliCompletedResultRecord>();
                String string5 = (String)((Hashtable)properties).get("type" + i);
                int n2 = CSUtil.parseInt((String)((Hashtable)properties).get("rCounts" + i), 0);
                for (int j = 0; j < n2; ++j) {
                    String string6 = (String)((Hashtable)properties).get("rType_" + i + "_" + j);
                    int n3 = CSUtil.parseInt((String)((Hashtable)properties).get("rStatus_" + i + "_" + j), 2);
                    String string7 = (String)((Hashtable)properties).get("rDetail_" + i + "_" + j);
                    vector2.add(new JCliCompletedResultRecord(string6, n3, string7));
                }
                vector.add(new JCliCompletedPublishRecord(string5, vector2, null));
            }
            if (string4 != null) {
                hashtable.put(string4, vector);
            }
            string3 = bufferedReader.readLine();
        }
        bufferedReader.close();
        JRClient.close(uRLConnection);
        return hashtable;
    }

    public static boolean[] getEnableDisplayPermissions(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.enable_display_permissions");
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string2 = bufferedReader.readLine();
        boolean[] blArray = new boolean[3];
        int n = 0;
        for (n = 0; n < 3; ++n) {
            blArray[n] = CSUtil.getBoolean(string2.trim());
            string2 = bufferedReader.readLine();
        }
        JRClient.close(uRLConnection);
        return blArray;
    }

    public static Hashtable[] getInheritedPermissions(Frame frame, String string, String string2, int n) throws MalformedURLException, IOException, JRResponseException, ClassNotFoundException {
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.get_inherit_permission");
        hashtable.put("jrs.path", string2);
        hashtable.put("jrs.version_number", String.valueOf(n));
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        ObjectInputStream objectInputStream = new ObjectInputStream(uRLConnection.getInputStream());
        Hashtable hashtable2 = (Hashtable)objectInputStream.readObject();
        Hashtable[] hashtableArray = new Hashtable[3];
        if (hashtable2 != null) {
            hashtableArray[0] = (Hashtable)hashtable2.get("jrs.role_permission");
            hashtableArray[1] = (Hashtable)hashtable2.get("jrs.user_permission");
            hashtableArray[2] = (Hashtable)hashtable2.get("jrs.group_permission");
        }
        objectInputStream.close();
        JRClient.close(uRLConnection);
        return hashtableArray;
    }

    public static Hashtable[] getPermissions(Frame frame, String string, String string2, int n) throws MalformedURLException, IOException, JRResponseException, ClassNotFoundException {
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.get_permission");
        hashtable.put("jrs.path", string2);
        hashtable.put("jrs.version_number", String.valueOf(n));
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        ObjectInputStream objectInputStream = new ObjectInputStream(uRLConnection.getInputStream());
        Hashtable hashtable2 = (Hashtable)objectInputStream.readObject();
        Hashtable[] hashtableArray = new Hashtable[3];
        if (hashtable2 != null) {
            hashtableArray[0] = (Hashtable)hashtable2.get("jrs.role_permission");
            hashtableArray[1] = (Hashtable)hashtable2.get("jrs.user_permission");
            hashtableArray[2] = (Hashtable)hashtable2.get("jrs.group_permission");
        }
        objectInputStream.close();
        JRClient.close(uRLConnection);
        return hashtableArray;
    }

    public static String getExportScripts(Frame frame, String string, String[] stringArray) throws MalformedURLException, IOException, JRResponseException {
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.export_schedule_to_script_file");
        int n = stringArray.length;
        int n2 = 0;
        hashtable.put("COUNT", String.valueOf(n));
        for (n2 = 0; n2 < n; ++n2) {
            hashtable.put(String.valueOf(n2), String.valueOf(stringArray[n2]));
        }
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string2 = null;
        string2 = bufferedReader.readLine();
        int n3 = uRLConnection.getContentLength();
        String string3 = bufferedReader.readLine();
        for (int i = 0; i < n3 && null != (string2 = bufferedReader.readLine()); ++i) {
            string3 = string3 + "\n" + string2;
        }
        bufferedReader.close();
        JRClient.close(uRLConnection);
        return string3;
    }

    public static Properties[] getParseScrips(Frame frame, String string, String string2) throws MalformedURLException, IOException, JRResponseException, ClassNotFoundException {
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.import_schedule_from_script_file");
        hashtable.put("jrs.import_schedule_scripts", string2);
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        ObjectInputStream objectInputStream = new ObjectInputStream(uRLConnection.getInputStream());
        Hashtable hashtable2 = (Hashtable)objectInputStream.readObject();
        int n = CSUtil.parseInt((String)hashtable2.get("COUNT"));
        Properties[] propertiesArray = new Properties[n];
        if (hashtable2 != null) {
            for (int i = 0; i < n; ++i) {
                propertiesArray[i] = CSUtil.parseQuery((String)hashtable2.get(String.valueOf(i)));
            }
        }
        objectInputStream.close();
        JRClient.close(uRLConnection);
        return propertiesArray;
    }

    public static String[] submitTasks(Frame frame, String string, Properties[] propertiesArray) throws MalformedURLException, IOException, JRResponseException {
        Object object;
        Object object2;
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.import_schedule_from_script_file_submit");
        int n = propertiesArray.length;
        int n2 = 0;
        hashtable.put("COUNT", String.valueOf(n));
        for (n2 = 0; n2 < n; ++n2) {
            String string2;
            File file;
            String string3;
            Hashtable hashtable2;
            int n3;
            boolean bl;
            Object object3;
            String string4;
            object2 = propertiesArray[n2];
            if (CSUtil.getBoolean((String)((Properties)object2).get("jrs.to_version"), false) && CSUtil.getBoolean((String)((Properties)object2).get("jrs.to_version_pdf"), false) && CSUtil.getBoolean((String)((Properties)object2).get("jrs.version_pdf_sign"), true) && (string4 = (String)((Properties)object2).get("jrs.version_pdf_digital_path")) != null && ((File)(object = new File(string4))).exists() && !((File)object).isDirectory()) {
                object3 = String.valueOf(System.currentTimeMillis()) + ".pfx";
                JRClient.addUrlPaths("ReadFile", string, (File)object, (String)object3, null);
                ((Properties)object2).put("jrs.version_pdf_digital_path", object3);
            }
            if (CSUtil.getBoolean((String)((Properties)object2).get("jrs.to_disk"), false) && CSUtil.getBoolean((String)((Properties)object2).get("jrs.to_pdf"), false) && CSUtil.getBoolean((String)((Properties)object2).get("jrs.disk_pdf_sign"), true) && (string4 = (String)((Properties)object2).get("jrs.pdf_digital_path")) != null && ((File)(object = new File(string4))).exists() && !((File)object).isDirectory()) {
                object3 = String.valueOf(System.currentTimeMillis()) + ".pfx";
                JRClient.addUrlPaths("ReadFile", string, (File)object, (String)object3, null);
                ((Properties)object2).put("jrs.pdf_digital_path", object3);
            }
            boolean bl2 = bl = object2 == null ? false : CSUtil.getBoolean((String)((Properties)object2).get("jrs.has_nonbursting_result"), false);
            if (CSUtil.getBoolean((String)((Properties)object2).get("jrs.to_mail"), false) && ((Vector)(object = CSMail.getMails((Hashtable)object2, bl))).size() > 0) {
                object3 = new Vector();
                for (n3 = 0; n3 < ((Vector)object).size(); ++n3) {
                    JRMail jRMail = (JRMail)((Vector)object).elementAt(n3);
                    hashtable2 = jRMail.toProperties(null, bl);
                    if (CSUtil.getBoolean(((Properties)hashtable2).getProperty("jrs.to_mail_pdf"), false) && CSUtil.getBoolean(((Properties)hashtable2).getProperty("jrs.mail_pdf_sign"), false) && (string3 = (String)((Properties)object2).get("jrs.mail_pdf_digital_path")) != null && (file = new File(string3)).exists() && !file.isDirectory()) {
                        string2 = String.valueOf(System.currentTimeMillis()) + ".pfx";
                        JRClient.addUrlPaths("ReadFile", string, file, string2, null);
                        ((Properties)object2).put("jrs.pdf_digital_path", string2);
                    }
                    ((Vector)object3).add(new JRMail(hashtable2, bl));
                }
                ((Properties)object2).putAll((Map<?, ?>)CSMail.toProperties(object3, null, bl));
            }
            if (CSUtil.getBoolean((String)((Properties)object2).get("jrs.to_FTP"), false) && ((Vector)(object = CSUtil.getFTPs((Hashtable)object2, bl))).size() > 0) {
                object3 = new Vector();
                int n4 = ((Vector)object).size();
                for (n3 = 0; n3 < n4; ++n3) {
                    hashtable2 = (Hashtable)((Vector)object).elementAt(n3);
                    if (CSUtil.getBoolean((String)hashtable2.get("jrs.ftpPdf"), false) && CSUtil.getBoolean((String)hashtable2.get("jrs.ftpPdfSgn"), false) && (string3 = (String)hashtable2.get("jrs.ftpPdfDP")) != null && (file = new File(string3)).exists() && !file.isDirectory()) {
                        string2 = String.valueOf(System.currentTimeMillis()) + ".pfx";
                        JRClient.addUrlPaths("ReadFile", string, file, string2, null);
                        hashtable2.put("jrs.ftpPdfDP", string2);
                    }
                    ((Vector)object3).add(hashtable2);
                }
                ((Properties)object2).putAll((Map<?, ?>)CSUtil.toProperties((Vector)object3, null, bl));
            }
            hashtable.put(String.valueOf(n2), CSUtil.makeQuery((Hashtable)object2));
        }
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        object2 = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string5 = null;
        string5 = ((BufferedReader)object2).readLine();
        object = new String[n];
        n2 = 0;
        while (string5 != null) {
            object[n2] = string5;
            string5 = ((BufferedReader)object2).readLine();
            ++n2;
        }
        ((BufferedReader)object2).close();
        JRClient.close(uRLConnection);
        return object;
    }

    public static boolean[] getActionEditPermissions(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.adaptor_edit_permissions");
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string2 = bufferedReader.readLine();
        boolean[] blArray = new boolean[3];
        int n = 0;
        for (n = 0; n < 3; ++n) {
            blArray[n] = CSUtil.getBoolean(string2.trim());
            string2 = bufferedReader.readLine();
        }
        JRClient.close(uRLConnection);
        return blArray;
    }

    public static String[] getAllCoditionTrggersName(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        String[] stringArray = null;
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.get_all_conditon_triggers_name");
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string2 = null;
        string2 = bufferedReader.readLine();
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n++] = stringTokenizer.nextToken();
            }
        }
        JRClient.close(uRLConnection);
        return stringArray;
    }

    public static void createConditionTrigger(Frame frame, String string, String string2, String string3) throws MalformedURLException, IOException, JRResponseException {
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.create_condition_trigger");
        if (string2 != null) {
            hashtable.put("TriggerName", string2);
        }
        if (string3 != null) {
            hashtable.put("TriggerDescription", string3);
        }
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        JRClient.close(uRLConnection);
    }

    public static boolean IsEnableDynamicResource(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.admin_enable_dynamic_resource");
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string2 = bufferedReader.readLine();
        boolean bl = CSUtil.getBoolean(string2.trim());
        JRClient.close(uRLConnection);
        return bl;
    }

    public static Hashtable getMediaTray(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException, ClassNotFoundException {
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.get_mediatray");
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        ObjectInputStream objectInputStream = new ObjectInputStream(uRLConnection.getInputStream());
        Hashtable hashtable2 = (Hashtable)objectInputStream.readObject();
        objectInputStream.close();
        JRClient.close(uRLConnection);
        return hashtable2;
    }

    public static String[] getPaperList(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.get_paperlist");
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String[] stringArray = null;
        String string2 = bufferedReader.readLine();
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n++] = stringTokenizer.nextToken();
            }
        }
        bufferedReader.close();
        JRClient.close(uRLConnection);
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int checkValidation(Frame frame, String string, String string2) throws IOException, JRResponseException {
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string2, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = null;
        String string3 = null;
        int n = -1;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            string3 = bufferedReader.readLine();
            if (string3 != null) {
                try {
                    n = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPromptTaskQueueFull(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        boolean bl = false;
        String string2 = "?jrs.cmd=jrs.cmd_is_prompt_task_queue_full";
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string2, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string3 = null;
        try {
            string3 = bufferedReader.readLine();
            if (string3 != null) {
                bl = CSUtil.getBoolean(string3);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTaskQueueFull(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        boolean bl = false;
        String string2 = "?jrs.cmd=jrs.cmd_is_task_queue_full";
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string2, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string3 = null;
        try {
            string3 = bufferedReader.readLine();
            if (string3 != null) {
                bl = CSUtil.getBoolean(string3);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return bl;
    }

    public static Properties getGlobalNLS(Frame frame, String string, Locale locale) throws MalformedURLException, IOException, JRResponseException, ClassNotFoundException {
        URLConnection uRLConnection = null;
        Hashtable hashtable = JRClient._realm(null, "jrs.get_global_nls");
        hashtable.put("locale", locale.toString());
        uRLConnection = JRClient.INFO(frame, string, hashtable);
        APIUtil.checkResponseOK(uRLConnection);
        ObjectInputStream objectInputStream = new ObjectInputStream(uRLConnection.getInputStream());
        Properties properties = (Properties)objectInputStream.readObject();
        objectInputStream.close();
        JRClient.close(uRLConnection);
        return properties;
    }

    public static boolean isReportExist(Frame frame, String string, String string2) {
        try {
            NodeInfo nodeInfo = JRClient.getNodeInfo(frame, string, string2);
            return nodeInfo.isReport();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean doesReportExist(Frame frame, String string, String string2) {
        try {
            NodeInfo nodeInfo = JRClient.getNodeInfo(frame, string, string2);
            return nodeInfo.isReport();
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isClusterEnabled(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        boolean bl = false;
        String string2 = "?jrs.cmd=jrs.is_cluster_enabled";
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string2, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string3 = null;
        try {
            string3 = bufferedReader.readLine();
            if (string3 != null) {
                bl = CSUtil.getBoolean(string3);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDashBoardEnabled(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        boolean bl = false;
        String string2 = "?jrs.cmd=jrs.is_dashboard_enabled";
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string2, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string3 = null;
        try {
            string3 = bufferedReader.readLine();
            if (string3 != null) {
                bl = CSUtil.getBoolean(string3);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMultiTenancyEnabled(Frame frame, String string) throws MalformedURLException, IOException, JRResponseException {
        boolean bl = false;
        String string2 = "?jrs.cmd=jrs.is_multitenacny_enabled";
        URLConnection uRLConnection = JRClient.sendQuery(frame, string, CSUtil.replWithEsc(string2, ".=_-|;&<>$/:?\""));
        APIUtil.checkResponseOK(uRLConnection);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string3 = null;
        try {
            string3 = bufferedReader.readLine();
            if (string3 != null) {
                bl = CSUtil.getBoolean(string3);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCheckSecurity(Frame frame, String string) {
        boolean bl = true;
        BufferedReader bufferedReader = null;
        String string2 = "?jrs.cmd=jrs.is_check_security";
        try {
            URLConnection uRLConnection = JRClient.sendQuery(frame, string, string2);
            APIUtil.checkResponseOK(uRLConnection);
            bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            String string3 = null;
            string3 = bufferedReader.readLine();
            if (string3 != null) {
                bl = CSUtil.getBoolean(string3);
            }
        }
        catch (MalformedURLException malformedURLException) {
            JDebug.WARNING(malformedURLException);
        }
        catch (IOException iOException) {
            JDebug.WARNING(iOException);
        }
        catch (JRResponseException jRResponseException) {
            JDebug.WARNING(jRResponseException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
        }
        return bl;
    }

    static {
        try {
            CustomTaskManager.registerCustomTask(CSUtil.P_TASK_UPDATE, "jet.server.schedule.jrtasks.UpdateRptTask", null);
            CustomTaskManager.registerCustomTask(CSUtil.P_TASK_DISK, "jet.server.schedule.jrtasks.PublishToDiskTask", null);
            CustomTaskManager.registerCustomTask(CSUtil.P_TASK_MAIL, "jet.server.schedule.jrtasks.SendJRMailTask", null);
            CustomTaskManager.registerCustomTask(CSUtil.P_TASK_PRINT, "jet.server.schedule.jrtasks.PrintRptTask", null);
            CustomTaskManager.registerCustomTask(APIConst.P_TASK_PUBLISH, "jet.server.schedule.jrtasks.PublishRptTask", null);
            CustomTaskManager.registerCustomTask(CSUtil.P_TASK_VALUE_TRIGGER, "jet.server.schedule.jrtasks.ValueTriggerTask", null);
        }
        catch (Throwable throwable) {
            JDebug.WARNING(throwable);
        }
        try {
            Env.checkEnv(null);
        }
        catch (Throwable throwable) {
            JDebug.WARNING(throwable);
        }
    }
}

