/*
 * Decompiled with CFR 0.152.
 */
package jet.client.api.misc;

import guitools.GuiUtil;
import guitools.UIResource;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;

public class ProgressBar
extends Canvas {
    int percent = 0;

    public ProgressBar() {
        this.setBackground(UIResource.getColor("Window Background"));
        this.setForeground(UIResource.getColor("Window Foreground"));
    }

    public synchronized void setPercent(int n) {
        this.percent = n;
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paint(graphics);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        GuiUtil.draw3DRect(0, 0, dimension.width, dimension.height, false, graphics);
        graphics.setColor(Color.white);
        graphics.fillRect(2, 2, dimension.width - 4, dimension.height - 4);
        graphics.setColor(SystemColor.activeCaption);
        int n = this.percent * (dimension.width - 4) / 100;
        graphics.fillRect(2, 2, n, dimension.height - 4);
        if (this.percent >= 48) {
            graphics.setColor(SystemColor.activeCaptionText);
        } else {
            graphics.setColor(SystemColor.activeCaption);
        }
        ProgressBar.drawString(String.valueOf(this.percent) + " %", 0, 0, dimension.width, dimension.height, true, graphics);
    }

    public static void drawString(String string, int n, int n2, int n3, int n4, boolean bl, Graphics graphics) {
        if (string == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = fontMetrics.stringWidth(string);
        int n6 = fontMetrics.getHeight() - 3;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        n7 = bl ? (n3 - n5) / 2 : n3 - n5;
        n8 = n7 > 0 ? n7 : 0;
        n7 = (n4 - n6) / 2 + 1;
        n9 = n4 < n6 ? n4 : n4 - n7;
        graphics.drawString(string, n + n8, n2 + n9 - 1);
    }
}

