/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import com.jinfonet.api.datatypes.Array;
import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import jet.connect.DbBigInt;
import jet.connect.DbBit;
import jet.connect.DbColDesc;
import jet.connect.DbDateTime;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbReal;
import jet.connect.DbSmallInt;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.datasource.JRHierarchicalDataset;
import jet.formula.DataTypeDef;
import jet.formula.fArray;
import jet.universe.resultfile.JArray;
import toolkit.db.gui.MappingSQLType;

public class DbArray
extends DbValue {
    private Object I = null;
    int[] nanos = null;

    public DbArray() {
    }

    public DbArray(DbColDesc dbColDesc) {
        super(dbColDesc);
    }

    public void set(int n, Object object) {
        if (this.desc.sqlType == 2003) {
            this.desc.setSqlType(MappingSQLType.mapColType(n));
        }
        if (object != null) {
            this.bNull = false;
        }
        this.I = object;
    }

    public void set(Array array) throws DSException {
        if (array == null) {
            this.bNull = true;
            return;
        }
        this.bNull = false;
        Object object = array.getArray();
        int n = array.getBaseType();
        switch (n) {
            case 91: {
                JinfonetDate[] jinfonetDateArray = (JinfonetDate[])object;
                long[] lArray = new long[jinfonetDateArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    lArray[i] = jinfonetDateArray[i].getTime();
                }
                this.I = lArray;
                break;
            }
            case 92: {
                JinfonetTime[] jinfonetTimeArray = (JinfonetTime[])object;
                long[] lArray = new long[jinfonetTimeArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    lArray[i] = jinfonetTimeArray[i].getTime();
                }
                this.I = lArray;
                break;
            }
            case 93: {
                JinfonetTimeStamp[] jinfonetTimeStampArray = (JinfonetTimeStamp[])object;
                long[] lArray = new long[jinfonetTimeStampArray.length];
                int[] nArray = new int[jinfonetTimeStampArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    lArray[i] = jinfonetTimeStampArray[i].getTime();
                    nArray[i] = jinfonetTimeStampArray[i].getNanos();
                }
                this.setNanos(nArray);
                this.I = lArray;
                break;
            }
            default: {
                this.I = object;
            }
        }
    }

    public void set(java.sql.Array array) throws SQLException {
        if (array == null) {
            this.bNull = true;
            return;
        }
        this.bNull = false;
        switch (this.desc.sqlType) {
            case -7: {
                this.I = ((boolean[])array.getArray()).clone();
                break;
            }
            case -6: {
                this.I = ((byte[])array.getArray()).clone();
                break;
            }
            case 5: {
                this.I = ((short[])array.getArray()).clone();
                break;
            }
            case 4: {
                this.I = ((int[])array.getArray()).clone();
                break;
            }
            case -5: {
                this.I = ((long[])array.getArray()).clone();
                break;
            }
            case 91: {
                Date[] dateArray = (Date[])array.getArray();
                this.I = new long[dateArray.length];
                for (int i = 0; i < dateArray.length; ++i) {
                    ((long[])this.I)[i] = dateArray[i].getTime();
                }
                break;
            }
            case 92: {
                Time[] timeArray = (Time[])array.getArray();
                this.I = new long[timeArray.length];
                for (int i = 0; i < timeArray.length; ++i) {
                    ((long[])this.I)[i] = timeArray[i].getTime();
                }
                break;
            }
            case 93: {
                Timestamp[] timestampArray = (Timestamp[])array.getArray();
                this.I = new long[timestampArray.length];
                this.nanos = new int[timestampArray.length];
                for (int i = 0; i < timestampArray.length; ++i) {
                    ((long[])this.I)[i] = timestampArray[i].getTime();
                    this.nanos[i] = timestampArray[i].getNanos();
                }
                break;
            }
            case 7: {
                this.I = ((float[])array.getArray()).clone();
                break;
            }
            case 6: 
            case 8: {
                this.I = ((double[])array.getArray()).clone();
                break;
            }
            case 2: 
            case 3: {
                this.I = ((BigDecimal[])array.getArray()).clone();
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.I = ((String[])array.getArray()).clone();
                break;
            }
        }
    }

    @Override
    public String toString() {
        if (this.bNull) {
            return "";
        }
        String string = "[ ";
        switch (this.desc.sqlType) {
            case -7: {
                boolean[] blArray = (boolean[])this.I;
                for (int i = 0; i < blArray.length; ++i) {
                    string = string + blArray[i] + " ";
                }
                break;
            }
            case -6: {
                byte[] byArray = (byte[])this.I;
                for (int i = 0; i < byArray.length; ++i) {
                    string = string + byArray[i] + " ";
                }
                break;
            }
            case 5: {
                short[] sArray = (short[])this.I;
                for (int i = 0; i < sArray.length; ++i) {
                    string = string + sArray[i] + " ";
                }
                break;
            }
            case 4: {
                int[] nArray = (int[])this.I;
                for (int i = 0; i < nArray.length; ++i) {
                    string = string + nArray[i] + " ";
                }
                break;
            }
            case -5: {
                long[] lArray = (long[])this.I;
                for (int i = 0; i < lArray.length; ++i) {
                    string = string + lArray[i] + " ";
                }
                break;
            }
            case 91: 
            case 92: {
                long[] lArray = (long[])this.I;
                for (int i = 0; i < lArray.length; ++i) {
                    string = string + new Date(lArray[i]) + " ";
                }
                break;
            }
            case 93: {
                long[] lArray = (long[])this.I;
                if (this.nanos != null && lArray.length == this.nanos.length) {
                    for (int i = 0; i < lArray.length; ++i) {
                        string = string + new Date(lArray[i] + (long)(this.nanos[i] / 1000000)) + " ";
                    }
                } else {
                    for (int i = 0; i < lArray.length; ++i) {
                        string = string + new Date(lArray[i]) + " ";
                    }
                }
                break;
            }
            case 7: {
                float[] fArray2 = (float[])this.I;
                for (int i = 0; i < fArray2.length; ++i) {
                    string = string + fArray2[i] + " ";
                }
                break;
            }
            case 6: 
            case 8: {
                double[] dArray = (double[])this.I;
                for (int i = 0; i < dArray.length; ++i) {
                    string = string + dArray[i] + " ";
                }
                break;
            }
            case 2: 
            case 3: {
                BigDecimal[] bigDecimalArray = (BigDecimal[])this.I;
                for (int i = 0; i < bigDecimalArray.length; ++i) {
                    string = string + bigDecimalArray[i] + " ";
                }
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                String[] stringArray = (String[])this.I;
                for (int i = 0; i < stringArray.length; ++i) {
                    string = string + stringArray[i] + " ";
                }
                break;
            }
        }
        return string + ']';
    }

    @Override
    public void set(ResultSet resultSet, int n) throws SQLException {
        java.sql.Array array = resultSet.getArray(n);
        if (resultSet.wasNull()) {
            this.bNull = true;
        } else {
            if (this.desc.sqlType == 2003) {
                this.desc.setSqlType(MappingSQLType.mapColType(array.getBaseType()));
            }
            this.set(array);
            this.bNull = false;
        }
    }

    @Override
    public void set(JRHierarchicalDataset jRHierarchicalDataset, int n) throws SQLException {
        java.sql.Array array = jRHierarchicalDataset.getArray(n);
        if (jRHierarchicalDataset.wasNull()) {
            this.bNull = true;
        } else {
            this.set(array);
            this.bNull = false;
        }
    }

    @Override
    public void set(DbValue dbValue) {
        this.bNull = dbValue.bNull;
        if (this.bNull) {
            return;
        }
        if (dbValue instanceof DbArray) {
            this.I = ((DbArray)dbValue).I;
            this.nanos = ((DbArray)dbValue).nanos;
            this.desc.sqlType = dbValue.desc.sqlType;
        } else if (dbValue instanceof fArray) {
            if (this.desc.getSqlType() != 93) {
                this.I = ((fArray)dbValue).getArray(DataTypeDef.SqlToFml(this.desc.sqlType, this.desc.isCurrency()) + 11, true);
            } else {
                Timestamp[] timestampArray = (Timestamp[])((fArray)dbValue).getArray(DataTypeDef.SqlToFml(this.desc.sqlType, this.desc.isCurrency()) + 11);
                this.I = new long[timestampArray.length];
                this.nanos = new int[timestampArray.length];
                for (int i = 0; i < timestampArray.length; ++i) {
                    ((long[])this.I)[i] = timestampArray[i].getTime();
                    this.nanos[i] = timestampArray[i].getNanos();
                    ((long[])this.I)[i] = ((long[])this.I)[i] - (long)(this.nanos[i] / 1000000);
                }
            }
        }
    }

    @Override
    public boolean equals(DbValue dbValue) {
        if (!(dbValue instanceof DbArray)) {
            return false;
        }
        DbArray dbArray = (DbArray)dbValue;
        if (this.bNull != dbValue.bNull) {
            return false;
        }
        if (this == dbValue || this.bNull) {
            return true;
        }
        if (this.desc == null || dbValue.desc == null || this.desc.sqlType != dbValue.desc.sqlType) {
            return false;
        }
        if (this.I == dbArray.I) {
            return true;
        }
        if (this.I == null || dbArray.I == null) {
            return false;
        }
        try {
            switch (this.desc.sqlType) {
                case -7: {
                    boolean[] blArray = (boolean[])this.I;
                    boolean[] blArray2 = (boolean[])dbArray.I;
                    if (blArray.length != blArray2.length) {
                        return false;
                    }
                    int n = blArray.length;
                    while (n-- > 0) {
                        if (blArray[n] == blArray2[n]) continue;
                        return false;
                    }
                    break;
                }
                case -6: {
                    byte[] byArray = (byte[])this.I;
                    byte[] byArray2 = (byte[])dbArray.I;
                    if (byArray.length != byArray2.length) {
                        return false;
                    }
                    int n = byArray.length;
                    while (n-- > 0) {
                        if (byArray[n] == byArray2[n]) continue;
                        return false;
                    }
                    break;
                }
                case 5: {
                    short[] sArray = (short[])this.I;
                    short[] sArray2 = (short[])dbArray.I;
                    if (sArray.length != sArray2.length) {
                        return false;
                    }
                    int n = sArray.length;
                    while (n-- > 0) {
                        if (sArray[n] == sArray2[n]) continue;
                        return false;
                    }
                    break;
                }
                case 4: {
                    int[] nArray = (int[])this.I;
                    int[] nArray2 = (int[])dbArray.I;
                    if (nArray.length != nArray2.length) {
                        return false;
                    }
                    int n = nArray.length;
                    while (n-- > 0) {
                        if (nArray[n] == nArray2[n]) continue;
                        return false;
                    }
                    break;
                }
                case -5: {
                    long[] lArray = (long[])this.I;
                    long[] lArray2 = (long[])dbArray.I;
                    if (lArray.length != lArray2.length) {
                        return false;
                    }
                    int n = lArray.length;
                    while (n-- > 0) {
                        if (lArray[n] == lArray2[n]) continue;
                        return false;
                    }
                    break;
                }
                case 91: {
                    long[] lArray = (long[])this.I;
                    long[] lArray3 = (long[])dbArray.I;
                    if (lArray.length != lArray3.length) {
                        return false;
                    }
                    int n = lArray.length;
                    while (n-- > 0) {
                        if (lArray[n] == lArray3[n]) continue;
                        return false;
                    }
                    break;
                }
                case 92: {
                    long[] lArray = (long[])this.I;
                    long[] lArray4 = (long[])dbArray.I;
                    if (lArray.length != lArray4.length) {
                        return false;
                    }
                    int n = lArray.length;
                    while (n-- > 0) {
                        if (lArray[n] == lArray4[n]) continue;
                        return false;
                    }
                    break;
                }
                case 93: {
                    long[] lArray = (long[])this.I;
                    long[] lArray5 = (long[])dbArray.I;
                    if (lArray.length != lArray5.length) {
                        return false;
                    }
                    int n = lArray.length;
                    while (n-- > 0) {
                        int n2;
                        int n3 = this.nanos == null || n >= this.nanos.length ? 0 : this.nanos[n];
                        int n4 = n2 = dbArray.nanos == null || n >= dbArray.nanos.length ? 0 : dbArray.nanos[n];
                        if (n3 != n2) {
                            return false;
                        }
                        if (lArray[n] == lArray5[n]) continue;
                        return false;
                    }
                    break;
                }
                case 7: {
                    float[] fArray2 = (float[])this.I;
                    float[] fArray3 = (float[])dbArray.I;
                    if (fArray2.length != fArray3.length) {
                        return false;
                    }
                    int n = fArray2.length;
                    while (n-- > 0) {
                        if (fArray2[n] == fArray3[n]) continue;
                        return false;
                    }
                    break;
                }
                case 6: 
                case 8: {
                    double[] dArray = (double[])this.I;
                    double[] dArray2 = (double[])dbArray.I;
                    if (dArray.length != dArray2.length) {
                        return false;
                    }
                    int n = dArray.length;
                    while (n-- > 0) {
                        if (dArray[n] == dArray2[n]) continue;
                        return false;
                    }
                    break;
                }
                case 2: 
                case 3: {
                    BigDecimal[] bigDecimalArray = (BigDecimal[])this.I;
                    BigDecimal[] bigDecimalArray2 = (BigDecimal[])dbArray.I;
                    if (bigDecimalArray.length != bigDecimalArray2.length) {
                        return false;
                    }
                    int n = bigDecimalArray.length;
                    while (n-- > 0) {
                        if (bigDecimalArray[n] == bigDecimalArray2[n]) continue;
                        if (bigDecimalArray[n] == null || bigDecimalArray2[n] == null) {
                            return false;
                        }
                        if (bigDecimalArray[n].equals(bigDecimalArray2[n])) continue;
                        return false;
                    }
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    String[] stringArray = (String[])this.I;
                    String[] stringArray2 = (String[])dbArray.I;
                    if (stringArray.length != stringArray2.length) {
                        return false;
                    }
                    int n = stringArray.length;
                    while (n-- > 0) {
                        if (stringArray[n].equals(stringArray2[n])) continue;
                        if (stringArray[n] == null || stringArray2[n] == null) {
                            return false;
                        }
                        if (stringArray[n].equals(stringArray2[n])) continue;
                        return false;
                    }
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(DbValue dbValue) {
        return 0;
    }

    @Override
    public void setValue(String string) {
    }

    public void setValue(Object object, int n) {
        this.I = object;
        this.bNull = n <= 0;
    }

    public void setNanos(int[] nArray) {
        this.nanos = nArray;
    }

    public Object getValue() {
        return this.I;
    }

    public int[] getNanos() {
        return this.nanos;
    }

    public java.sql.Array toSqlArray() {
        Date[] dateArray = null;
        switch (this.desc.sqlType) {
            case 91: {
                long[] lArray = (long[])this.I;
                Date[] dateArray2 = new Date[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    dateArray2[i] = new Date(lArray[i]);
                }
                dateArray = dateArray2;
                break;
            }
            case 92: {
                long[] lArray = (long[])this.I;
                Time[] timeArray = new Time[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    timeArray[i] = new Time(lArray[i]);
                }
                dateArray = timeArray;
                break;
            }
            case 93: {
                long[] lArray = (long[])this.I;
                Timestamp[] timestampArray = new Timestamp[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    timestampArray[i] = new Timestamp(lArray[i]);
                    if (this.nanos == null || this.nanos.length <= i) continue;
                    timestampArray[i].setNanos(this.nanos[i]);
                }
                dateArray = timestampArray;
                break;
            }
            default: {
                dateArray = this.I;
            }
        }
        return new JArray(dateArray, this.desc.sqlType);
    }

    @Override
    public Object clone() {
        DbArray dbArray = new DbArray(this.desc);
        dbArray.bNull = this.bNull;
        if (!this.bNull) {
            Object object = null;
            switch (this.desc.sqlType) {
                case -7: {
                    object = ((boolean[])this.I).clone();
                    break;
                }
                case -6: {
                    object = ((byte[])this.I).clone();
                    break;
                }
                case 5: {
                    object = ((short[])this.I).clone();
                    break;
                }
                case 4: {
                    object = ((int[])this.I).clone();
                    break;
                }
                case -5: 
                case 91: 
                case 92: {
                    object = ((long[])this.I).clone();
                    break;
                }
                case 93: {
                    object = ((long[])this.I).clone();
                    dbArray.nanos = (int[])this.nanos.clone();
                    break;
                }
                case 7: {
                    object = ((float[])this.I).clone();
                    break;
                }
                case 6: 
                case 8: {
                    object = ((double[])this.I).clone();
                    break;
                }
                case 2: 
                case 3: {
                    object = ((BigDecimal[])this.I).clone();
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    object = ((String[])this.I).clone();
                    break;
                }
            }
            dbArray.I = object;
        } else {
            dbArray.I = null;
        }
        return dbArray;
    }

    public void setValues(String[] stringArray, String string) throws ParseException {
        if (stringArray == null || stringArray.length == 0) {
            this.bNull = true;
        } else {
            this.bNull = false;
            this.desc.setArray(false);
            DbValue dbValue = DbValue.makeDbValue(this.desc);
            switch (this.desc.sqlType) {
                case -7: {
                    boolean[] blArray = new boolean[stringArray.length];
                    if (!(dbValue instanceof DbBit)) break;
                    DbBit dbBit = (DbBit)dbValue;
                    for (int i = 0; i < stringArray.length; ++i) {
                        dbBit.setValue(stringArray[i]);
                        blArray[i] = dbBit.get();
                    }
                    this.I = blArray;
                    break;
                }
                case -6: {
                    byte[] byArray = new byte[stringArray.length];
                    if (dbValue instanceof DbTinyInt) {
                        DbTinyInt dbTinyInt = (DbTinyInt)dbValue;
                        for (int i = 0; i < stringArray.length; ++i) {
                            dbTinyInt.setValue(stringArray[i]);
                            byArray[i] = dbTinyInt.byteValue();
                        }
                    }
                    this.I = byArray;
                    break;
                }
                case 5: {
                    short[] sArray = new short[stringArray.length];
                    if (dbValue instanceof DbSmallInt) {
                        DbSmallInt dbSmallInt = (DbSmallInt)dbValue;
                        for (int i = 0; i < stringArray.length; ++i) {
                            dbSmallInt.setValue(stringArray[i]);
                            sArray[i] = dbSmallInt.shortValue();
                        }
                    }
                    this.I = sArray;
                    break;
                }
                case 4: {
                    int[] nArray = new int[stringArray.length];
                    if (dbValue instanceof DbInteger) {
                        DbInteger dbInteger = (DbInteger)dbValue;
                        for (int i = 0; i < stringArray.length; ++i) {
                            dbInteger.setValue(stringArray[i]);
                            nArray[i] = dbInteger.intValue();
                        }
                    }
                    this.I = nArray;
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    long[] lArray = new long[stringArray.length];
                    int[] nArray = new int[stringArray.length];
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
                    if (dbValue instanceof DbTimestamp) {
                        DbTimestamp dbTimestamp = (DbTimestamp)dbValue;
                        for (int i = 0; i < stringArray.length; ++i) {
                            dbTimestamp.set(simpleDateFormat.parse(stringArray[i]).getTime());
                            lArray[i] = dbTimestamp.get();
                            nArray[i] = dbTimestamp.getNanos();
                        }
                        this.nanos = nArray;
                    } else if (dbValue instanceof DbDateTime) {
                        DbDateTime dbDateTime = (DbDateTime)dbValue;
                        for (int i = 0; i < stringArray.length; ++i) {
                            dbDateTime.set(simpleDateFormat.parse(stringArray[i]).getTime());
                            lArray[i] = dbDateTime.get();
                        }
                    }
                    this.I = lArray;
                    break;
                }
                case -5: {
                    long[] lArray = new long[stringArray.length];
                    if (dbValue instanceof DbBigInt) {
                        DbBigInt dbBigInt = (DbBigInt)dbValue;
                        for (int i = 0; i < stringArray.length; ++i) {
                            dbBigInt.setValue(stringArray[i]);
                            lArray[i] = dbBigInt.get();
                        }
                    }
                    this.I = lArray;
                    break;
                }
                case 7: {
                    float[] fArray2 = new float[stringArray.length];
                    if (dbValue instanceof DbReal) {
                        DbReal dbReal = (DbReal)dbValue;
                        for (int i = 0; i < stringArray.length; ++i) {
                            dbReal.setValue(stringArray[i]);
                            fArray2[i] = dbReal.floatValue();
                        }
                    }
                    this.I = fArray2;
                    break;
                }
                case 6: 
                case 8: {
                    double[] dArray = new double[stringArray.length];
                    if (dbValue instanceof DbDouble) {
                        DbDouble dbDouble = (DbDouble)dbValue;
                        for (int i = 0; i < stringArray.length; ++i) {
                            dbDouble.setValue(stringArray[i]);
                            dArray[i] = dbDouble.doubleValue();
                        }
                    }
                    this.I = dArray;
                    break;
                }
                case 2: 
                case 3: {
                    BigDecimal[] bigDecimalArray = new BigDecimal[stringArray.length];
                    if (dbValue instanceof DbDecimal) {
                        DbDecimal dbDecimal = (DbDecimal)dbValue;
                        for (int i = 0; i < stringArray.length; ++i) {
                            dbDecimal.setValue(stringArray[i]);
                            bigDecimalArray[i] = dbDecimal.get();
                        }
                    }
                    this.I = bigDecimalArray;
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    this.I = stringArray;
                    break;
                }
            }
        }
        this.desc.setArray(true);
    }

    @Override
    public String toStringValue() {
        return this.toString();
    }
}

