/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import jet.connect.DbBuffer;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbDecimal;
import jet.connect.DbValue;

public class DbBigDecimalColumnBuffer
extends DbColumnBuffer {
    byte[][] buffer;
    int length = 0;
    byte[] pos;
    byte[] nav;
    byte[] temp;

    public byte[][] getBuffer() {
        return this.buffer;
    }

    public DbBigDecimalColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.length = DbBuffer.decimalNeedBytes(dbColDesc);
        this.pos = new byte[this.length];
        this.nav = new byte[this.length];
        this.temp = new byte[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.pos[i] = 0;
            this.nav[i] = -1;
        }
        this.buffer = new byte[n][this.length];
    }

    @Override
    public void updateCell(int n, DbValue dbValue) {
        if (((DbDecimal)dbValue).get() == null) {
            System.arraycopy(this.pos, 0, this.buffer[n], 0, this.length);
        } else {
            byte[] byArray = ((DbDecimal)dbValue).get().movePointRight(this.coldesc.getScale()).toBigInteger().toByteArray();
            if ((byArray[0] & 0x80) != 128) {
                System.arraycopy(this.pos, 0, this.buffer[n], 0, this.length);
            } else {
                System.arraycopy(this.nav, 0, this.buffer[n], 0, this.length);
            }
            System.arraycopy(byArray, 0, this.buffer[n], this.length - byArray.length, byArray.length);
        }
    }

    @Override
    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbDecimal)dbValue).set(new BigDecimal(new BigInteger(this.buffer[n]), this.coldesc.getScale()));
    }

    @Override
    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < this.buffer.length; ++i) {
            dataOutput.write(this.buffer[i]);
        }
    }

    @Override
    protected void readValueFromFile(DataInput dataInput) throws IOException {
        for (int i = 0; i < this.buffer.length; ++i) {
            dataInput.readFully(this.buffer[i]);
        }
    }

    @Override
    public void clearMem() {
        super.clearMem();
        this.buffer = null;
        this.pos = null;
        this.nav = null;
        this.temp = null;
    }
}

