/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbBinary;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbValue;

public class DbBinaryColumnBuffer
extends DbColumnBuffer {
    byte[][] buffer;

    public byte[][] getBuffer() {
        return this.buffer;
    }

    public DbBinaryColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.buffer = new byte[n][];
    }

    @Override
    public void updateCell(int n, DbValue dbValue) {
        this.buffer[n] = ((DbBinary)dbValue).get();
    }

    @Override
    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbBinary)dbValue).set(this.buffer[n]);
    }

    @Override
    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < this.buffer.length; ++i) {
            dataOutput.write(this.buffer[i]);
        }
    }

    @Override
    protected void readValueFromFile(DataInput dataInput) throws IOException {
        for (int i = 0; i < this.buffer.length; ++i) {
            if (this.buffer[i].length == 0) {
                this.buffer[i] = new byte[this.coldesc.precision];
            }
            dataInput.readFully(this.buffer[i]);
        }
    }

    @Override
    public void clearMem() {
        super.clearMem();
        this.buffer = null;
    }
}

