/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbBit;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbValue;

public class DbBooleanColumnBuffer
extends DbColumnBuffer {
    boolean[] buffer;

    public boolean[] getBuffer() {
        return this.buffer;
    }

    public DbBooleanColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.buffer = new boolean[n];
    }

    @Override
    public void updateCell(int n, DbValue dbValue) {
        this.buffer[n] = ((DbBit)dbValue).get();
    }

    @Override
    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbBit)dbValue).set(this.buffer[n]);
    }

    @Override
    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < this.buffer.length; ++i) {
            dataOutput.writeBoolean(this.buffer[i]);
        }
    }

    @Override
    protected void readValueFromFile(DataInput dataInput) throws IOException {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = dataInput.readBoolean();
        }
    }

    @Override
    public void clearMem() {
        super.clearMem();
        this.buffer = null;
    }
}

