/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import com.jinfonet.jdbc.UnsupportedException;
import com.jinfonet.util.JRLog;
import guitools.toolkit.JDebug;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import jet.Env;
import jet.connect.AdMetaData;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbColumn;
import jet.connect.DbDateTime;
import jet.connect.DbDecimal;
import jet.connect.DbLongColumnBuffer;
import jet.connect.DbLongVariable;
import jet.connect.DbNumber;
import jet.connect.DbPage;
import jet.connect.DbRecordModel;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.exception.EndOfRecordsException;
import jet.exception.NoRecordsFoundException;
import jet.ie.io.FileBlockOutputStream;
import jet.log.JRLogger;
import jet.log.JRLoggingUtil;
import jet.util.IntKeyHashtable;
import jet.util.RAFile;
import jet.util.RandomOutputable;
import jet.util.TempFile;
import jet.util.intChain;

public class DbBuffer
implements Runnable,
ResultSet {
    public static final int BYTE = 1;
    public static final int BOOLEAN = 1;
    public static final int CHAR = 2;
    public static final int SHORT = 2;
    public static final int INT = 4;
    public static final int LONG = 8;
    public static final int FLOAT = 4;
    public static final int DOUBLE = 8;
    public static final int TIME = 8;
    public static final int TIMESTAMP = 12;
    public static final int BUFFER_SIZE = 4096;
    public static final int PAGE_COUNT = 500;
    int recordSize;
    protected int recordPerPage;
    int largestPageSize;
    protected int currentEnd;
    protected boolean finished;
    private Hashtable SEDU;
    protected DbRecordModel recordModel;
    private IntKeyHashtable WARNING;
    private intChain addElement;
    protected DbPage lastPage;
    protected TempFile tempFile;
    protected File file;
    protected RAFile bufFile;
    protected boolean isFetchingWaited;
    protected int currentReadingRow;
    private int addRecord;
    private Vector append;
    private Vector bigDecimalLength;
    protected Hashtable descToBlobFiles;
    protected boolean cacheToFile;
    protected boolean bNeedWaitFetch;
    protected long offsetBegine;
    private boolean buffer;
    private boolean byteValue;
    private Object cacheThePage;
    private int clear;
    protected int halfCacheRecords;
    private Vector clearMem;
    boolean singleThread;
    int id;
    boolean bFastPass;
    private Record clone;
    private AdMetaData close;
    private boolean columns;
    private static JRLogger createRecord = JRLogger.getLogger(DbBuffer.class.getName());
    private String createTempFile;
    Thread fopt;

    public DbBuffer() {
        this.SEDU = new Hashtable(10);
        this.WARNING = new IntKeyHashtable();
        this.addElement = new intChain();
        this.append = new Vector(3);
        this.bigDecimalLength = new Vector(3);
        this.cacheToFile = true;
        this.bNeedWaitFetch = true;
        this.cacheThePage = new Object();
        this.clear = -1;
        this.clearMem = new Vector(10);
        this.bFastPass = false;
        this.columns = false;
        this.fopt = null;
        this.createTempFile = JRLoggingUtil.getNDC();
    }

    public DbBuffer(DbRecordModel dbRecordModel) {
        this(dbRecordModel, new Hashtable(3));
        this.initFile();
    }

    public DbBuffer(DbRecordModel dbRecordModel, boolean bl) {
        block4: {
            this(dbRecordModel, new Hashtable(3));
            this.cacheToFile = bl;
            if (bl) {
                this.initFile();
            } else {
                try {
                    this.lastPage = new DbPage(this, 0);
                }
                catch (IOException iOException) {
                    if (!createRecord.isErrorEnabled()) break block4;
                    createRecord.error("", iOException);
                }
            }
        }
    }

    public DbBuffer(boolean bl, DbRecordModel dbRecordModel, int n, int n2, int n3) {
        this(bl, dbRecordModel, new Hashtable(3), n, n2, n3);
        this.cacheToFile = true;
        this.initFile();
    }

    public DbBuffer(DbRecordModel dbRecordModel, Hashtable hashtable) {
        this(false, dbRecordModel, hashtable, 0, 0, 0);
    }

    protected DbBuffer(boolean bl, DbRecordModel dbRecordModel, Hashtable hashtable) {
        this(bl, dbRecordModel, hashtable, 0, 0, 0);
    }

    protected DbBuffer(boolean bl, DbRecordModel dbRecordModel, Hashtable hashtable, int n, int n2, int n3) {
        this.SEDU = new Hashtable(10);
        this.WARNING = new IntKeyHashtable();
        this.addElement = new intChain();
        this.append = new Vector(3);
        this.bigDecimalLength = new Vector(3);
        this.cacheToFile = true;
        this.bNeedWaitFetch = true;
        this.cacheThePage = new Object();
        this.clear = -1;
        this.clearMem = new Vector(10);
        this.bFastPass = false;
        this.columns = false;
        this.fopt = null;
        this.createTempFile = JRLoggingUtil.getNDC();
        this.id = n;
        this.recordModel = dbRecordModel;
        this.descToBlobFiles = hashtable;
        this.singleThread = bl;
        if (n2 > 0) {
            this.recordPerPage = n2;
        }
        if (n3 > 0) {
            this.largestPageSize = n3;
        }
        dbRecordModel.setDbBuffer(this);
        this.makeRecordPerPage();
        this.halfCacheRecords = n2 * n3 / 2;
        this.clone = dbRecordModel.createRecord();
        this.close = new AdMetaData(dbRecordModel);
    }

    public boolean isFastPass() {
        return this.bFastPass;
    }

    public void setFastPass(boolean bl) {
        this.bFastPass = bl;
    }

    public void setSingleThread(boolean bl) {
        this.singleThread = bl;
    }

    public boolean getSingleThread() {
        return this.singleThread;
    }

    public void setPageCount(int n) {
        this.largestPageSize = n >= 3 ? n : 3;
    }

    public void setRecPerPage(int n) {
        if (n > 0) {
            this.recordPerPage = n;
        }
    }

    public synchronized boolean restart() {
        if (!this.singleThread) {
            while (!this.finished) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.currentReadingRow = 0;
            this.notifyAll();
            return true;
        }
        if (this.finished) {
            this.currentReadingRow = 0;
            return true;
        }
        return false;
    }

    public void initFile() {
        try {
            this.lastPage = new DbPage(this, 0);
        }
        catch (Exception exception) {
            this.cacheToFile = false;
        }
    }

    protected void createTempFile() {
        try {
            this.tempFile = new TempFile(Env.getTemporaryPath(), "buffer");
            this.file = this.tempFile.createTempFile();
            this.bufFile = new RAFile(this.file, "rw");
        }
        catch (IOException iOException) {
            this.cacheToFile = false;
        }
    }

    public final int getPageNumberByRowNumber(int n) {
        return n / this.recordPerPage;
    }

    public final int getRealRowNumberByRowNumber(int n) {
        return n % this.recordPerPage;
    }

    public final DbColDesc[] getColDescs() {
        return this.recordModel.getColDescs();
    }

    public int indexOfCell(String string) {
        return this.recordModel.indexOfCell(string);
    }

    public int countColumns() {
        return this.recordModel.getColDescs().length;
    }

    public synchronized int countRecords() {
        if (!this.singleThread) {
            while (!this.finished) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    JDebug.WARNING(exception);
                }
            }
            this.notifyAll();
        }
        return this.currentEnd;
    }

    public int getRecords() {
        return this.currentEnd;
    }

    public void setOptimizeFetch(boolean bl) {
        this.buffer = bl;
    }

    public void startOptimizeFetch() {
    }

    public synchronized void finish() {
        this.finished = true;
        if (!this.singleThread) {
            this.notifyAll();
        }
    }

    public boolean finished() {
        return this.finished;
    }

    public synchronized void nextRecord(Record record) throws SQLException {
        this.nextRecord(record, true);
    }

    public synchronized void nextRecord(Record record, boolean bl) throws SQLException {
        if (this.currentReadingRow >= this.currentEnd && this.finished) {
            if (this.currentEnd != 0) {
                throw new EndOfRecordsException();
            }
            throw new NoRecordsFoundException();
        }
        while (this.currentReadingRow >= this.currentEnd && !this.singleThread) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                JDebug.WARNING(exception);
            }
            if (!this.finished) continue;
            if (this.currentReadingRow >= this.currentEnd && this.currentEnd != 0) {
                if (!this.singleThread) {
                    this.notifyAll();
                }
                throw new EndOfRecordsException();
            }
            if (this.currentEnd != 0) continue;
            if (!this.singleThread) {
                this.notifyAll();
            }
            throw new NoRecordsFoundException();
        }
        record.setRecordIndex(this.currentReadingRow++);
        this.refreshRecord(record, bl);
        if (!this.singleThread) {
            this.notifyAll();
        }
    }

    public synchronized void addRecord(Record record) {
        int n = this.getRealRowNumberByRowNumber(this.currentEnd);
        if (this.currentEnd != 0 && n == 0) {
            if (this.bNeedWaitFetch && this.addElement.size() == this.largestPageSize) {
                int n2;
                int n3;
                int n4 = this.addElement.lastElement();
                if (this.currentReadingRow > 0) {
                    n3 = this.getPageNumberByRowNumber(this.currentReadingRow - 1);
                    n2 = this.getRealRowNumberByRowNumber(this.currentReadingRow - 1);
                } else {
                    n3 = this.getPageNumberByRowNumber(this.currentReadingRow);
                    n2 = this.getRealRowNumberByRowNumber(this.currentReadingRow);
                }
                while ((n3 = this.getPageNumberByRowNumber(this.currentReadingRow > 0 ? this.currentReadingRow - 1 : this.currentReadingRow)) == n4 && (n2 = this.getRealRowNumberByRowNumber(this.currentReadingRow > 0 ? this.currentReadingRow - 1 : this.currentReadingRow)) < this.recordPerPage && this.WARNING.size() == this.largestPageSize && !this.singleThread) {
                    try {
                        this.isFetchingWaited = true;
                        this.wait();
                    }
                    catch (Exception exception) {
                        JDebug.WARNING(exception);
                    }
                }
                this.isFetchingWaited = false;
            }
            DbPage dbPage = this.lastPage;
            this.cacheThePage(dbPage);
            this.lastPage = this.makeNewPage(dbPage.getPageNumber());
        }
        record.setRecordIndex(this.currentEnd++);
        this.lastPage.updateRecord(n, record);
        if (!this.singleThread) {
            this.notifyAll();
        }
    }

    public synchronized void updateRecord(Record record) {
        try {
            int n = record.getRecordIndex();
            int n2 = this.getRealRowNumberByRowNumber(n);
            DbPage dbPage = this.getPageOfTheRow(n);
            dbPage.updateRecord(n2, record);
        }
        catch (IOException iOException) {
            JDebug.WARNING(iOException);
        }
    }

    public synchronized void updateRecord(Record record, int n) {
        try {
            int n2 = record.getRecordIndex();
            int n3 = this.getRealRowNumberByRowNumber(n2);
            DbPage dbPage = this.getPageOfTheRow(n2);
            dbPage.updateRecord(n3, record, n);
        }
        catch (IOException iOException) {
            JDebug.WARNING(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRecord(Record record, boolean bl) {
        try {
            int n = 0;
            DbBuffer dbBuffer = this;
            synchronized (dbBuffer) {
                n = record.getRecordIndex();
                assert (n < this.currentEnd || !this.finished) : "Out of buffer.";
                int n2 = this.getRealRowNumberByRowNumber(n);
                DbPage dbPage = this.getPageOfTheRow(n);
                dbPage.refreshRecord(n2, record, bl);
            }
        }
        catch (IOException iOException) {
            JDebug.WARNING(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRecord(Record record, int n) {
        try {
            int n2 = 0;
            DbBuffer dbBuffer = this;
            synchronized (dbBuffer) {
                n2 = record.getRecordIndex();
                assert (n2 < this.currentEnd || !this.finished) : "Out of buffer.";
                int n3 = this.getRealRowNumberByRowNumber(n2);
                DbPage dbPage = this.getPageOfTheRow(n2);
                dbPage.refreshRecord(n3, record, n);
            }
        }
        catch (IOException iOException) {
            JDebug.WARNING(iOException);
        }
    }

    public DbColDesc getColDesc(int n) {
        return this.recordModel.getColDesc(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbPage makeNewPage(int n) {
        DbPage dbPage = null;
        Vector vector = this.clearMem;
        synchronized (vector) {
            if (this.clearMem.size() != 0) {
                dbPage = (DbPage)this.clearMem.lastElement();
                dbPage.setPageNumber(n + 1);
                this.clearMem.removeElement(dbPage);
            }
        }
        try {
            if (dbPage == null) {
                dbPage = new DbPage(this, n + 1);
            }
        }
        catch (IOException iOException) {
            JDebug.WARNING(iOException);
        }
        return dbPage;
    }

    DbColumn[] makeDbColumnBuffer(DbPage dbPage) throws IOException {
        DbColDesc[] dbColDescArray = this.recordModel.getColDescs();
        DbColumn[] dbColumnArray = new DbColumn[dbColDescArray.length];
        for (int i = 0; i < dbColDescArray.length; ++i) {
            if (dbColDescArray[i].isGroupable() || dbColDescArray[i].isConstant()) {
                dbColumnArray[i] = (DbColumn)this.SEDU.get(dbColDescArray[i]);
                if (dbColumnArray[i] != null) continue;
            }
            dbColumnArray[i] = DbColumn.makeDbColumn(dbColDescArray[i], this.recordPerPage);
            if (dbColDescArray[i].isGroupable() || dbColDescArray[i].isConstant()) {
                this.SEDU.put(dbColDescArray[i], dbColumnArray[i]);
                continue;
            }
            if (!(dbColumnArray[i] instanceof DbLongVariable)) continue;
            if (this.cacheToFile) {
                Object object = this.descToBlobFiles.get(dbColDescArray[i]);
                if (object == null) {
                    object = ((DbLongVariable)((Object)dbColumnArray[i])).createTempFile();
                    this.bigDecimalLength.addElement(object);
                    this.append.addElement(((DbLongVariable)((Object)dbColumnArray[i])).getFile());
                    this.descToBlobFiles.put(dbColDescArray[i], object);
                    continue;
                }
                ((DbLongVariable)((Object)dbColumnArray[i])).setBufFile((RAFile)object);
                continue;
            }
            ((DbLongVariable)((Object)dbColumnArray[i])).setCacheToFile(false);
        }
        return dbColumnArray;
    }

    protected void makeRecordPerPage() {
        DbColDesc[] dbColDescArray = this.recordModel.getColDescs();
        block21: for (int i = 0; i < dbColDescArray.length; ++i) {
            if (dbColDescArray[i].isGroupable() || dbColDescArray[i].isConstant() || dbColDescArray[i].isGroupLevel()) {
                switch (dbColDescArray[i].getSqlType()) {
                    case 2: 
                    case 3: {
                        dbColDescArray[i].bigDecimalLength = DbBuffer.decimalNeedBytes(dbColDescArray[i]);
                    }
                }
                continue;
            }
            if (dbColDescArray[i].isArray()) {
                switch (dbColDescArray[i].getSqlType()) {
                    case 2: 
                    case 3: {
                        dbColDescArray[i].bigDecimalLength = DbBuffer.decimalNeedBytes(dbColDescArray[i]);
                    }
                }
                this.recordSize += 8;
                ++this.addRecord;
                continue;
            }
            ++this.recordSize;
            switch (dbColDescArray[i].getSqlType()) {
                case -6: {
                    ++this.recordSize;
                    continue block21;
                }
                case 5: {
                    this.recordSize += 2;
                    continue block21;
                }
                case 4: {
                    this.recordSize += 4;
                    continue block21;
                }
                case -5: {
                    this.recordSize += 8;
                    continue block21;
                }
                case 6: 
                case 7: {
                    this.recordSize += 8;
                    continue block21;
                }
                case 2: 
                case 3: {
                    dbColDescArray[i].bigDecimalLength = DbBuffer.decimalNeedBytes(dbColDescArray[i]);
                    this.recordSize += dbColDescArray[i].bigDecimalLength;
                    continue block21;
                }
                case 8: {
                    this.recordSize += 8;
                    continue block21;
                }
                case -7: {
                    this.recordSize += 4;
                    continue block21;
                }
                case 91: {
                    this.recordSize += 8;
                    continue block21;
                }
                case 92: {
                    this.recordSize += 8;
                    continue block21;
                }
                case 93: {
                    this.recordSize += 12;
                    continue block21;
                }
                case -3: 
                case -2: 
                case 1: 
                case 12: {
                    this.recordSize += 4 + dbColDescArray[i].getPrecision() * 1;
                    continue block21;
                }
                case -4: 
                case -1: 
                case 2004: 
                case 2005: {
                    this.recordSize += 8;
                    ++this.addRecord;
                    continue block21;
                }
                default: {
                    if (!JRLog.isAd()) continue block21;
                    JRLog.print(new Exception("unknow sql type : " + dbColDescArray[i].getSqlType() + " of the column " + dbColDescArray[i].getColName()));
                }
            }
        }
        if (this.recordSize == 0) {
            this.recordSize = 1;
        }
        if (this.recordPerPage <= 0) {
            this.recordPerPage = 4096 / this.recordSize;
            if (this.recordPerPage < 10) {
                this.recordPerPage = 10;
            }
        }
        if (this.largestPageSize <= 0) {
            this.largestPageSize = 2048000 / (this.recordSize * this.recordPerPage);
            if (this.largestPageSize == 0) {
                this.largestPageSize = 3;
            }
        }
        if (createRecord.isDebugEnabled()) {
            createRecord.debug("Trace info \n" + this.toString() + "record size is " + this.recordSize);
            createRecord.debug("Trace info \n" + this.toString() + "records in per page " + this.recordPerPage);
            createRecord.debug("Trace info \n" + this.toString() + "maximum pages " + this.largestPageSize);
        }
    }

    public static int decimalNeedBytes(DbColDesc dbColDesc) {
        int n = dbColDesc.getPrecision() + dbColDesc.getScale();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("9");
        }
        BigInteger bigInteger = new BigInteger(stringBuffer.toString());
        byte[] byArray = bigInteger.toByteArray();
        return byArray.length;
    }

    protected void finalize() {
        this.clearMem();
    }

    public void clearMem() {
        int n;
        this.SEDU = null;
        this.byteValue = false;
        this.recordModel = null;
        if (this.addElement == null) {
            return;
        }
        int[] nArray = this.addElement.elements();
        for (n = 0; n < nArray.length; ++n) {
            DbPage dbPage = (DbPage)this.WARNING.get(nArray[n]);
            dbPage.clearMem();
        }
        if (this.lastPage != null) {
            this.lastPage.clearMem();
            this.lastPage = null;
        }
        this.WARNING.clear();
        this.WARNING = null;
        this.clearMem = null;
        this.addElement = null;
        this.lastPage = null;
        if (this.file != null) {
            try {
                this.bufFile.close();
            }
            catch (IOException iOException) {
                JDebug.WARNING(iOException);
            }
            this.file.delete();
        }
        n = this.append.size();
        for (int i = 0; i < n; ++i) {
            try {
                ((RAFile)this.bigDecimalLength.elementAt(i)).close();
                ((File)this.append.elementAt(i)).delete();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheThePage(DbPage dbPage) {
        try {
            int n;
            block17: {
                block15: {
                    int n2;
                    DbPage dbPage2;
                    block16: {
                        if (this.bFastPass) break block15;
                        if (!this.cacheToFile) break block16;
                        if (this.WARNING.size() == this.largestPageSize) {
                            n = this.addElement.removeLastElement();
                            DbPage dbPage3 = (DbPage)this.WARNING.remove(n);
                            if (dbPage3 != null) {
                                if (this.bufFile == null) {
                                    this.createTempFile();
                                }
                                if (this.cacheToFile) {
                                    dbPage3.refreshToFile(this.bufFile);
                                    dbPage3.discard();
                                    Vector vector = this.clearMem;
                                    synchronized (vector) {
                                        this.clearMem.addElement(dbPage3);
                                    }
                                }
                            } else {
                                JDebug.WARNING("DbBuffer.cacheThePage()::discardPage is null!(thePage=" + dbPage + " LRU.removeLastElement()=" + n + " largestPageSize=" + this.largestPageSize);
                            }
                        }
                        break block17;
                    }
                    if (!this.$assertionsDisabled() || this.WARNING.size() != this.largestPageSize || (dbPage2 = (DbPage)this.WARNING.remove(n2 = this.addElement.removeLastElement())) == null) break block17;
                    dbPage2.clearMem();
                    break block17;
                }
                while (this.WARNING.size() == this.largestPageSize) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        JDebug.WARNING(interruptedException);
                    }
                }
            }
            if (this.WARNING.get(n = dbPage.getPageNumber()) == null) {
                this.addElement.insertElementAt(n, 0);
            }
            this.WARNING.put(n, dbPage);
            if (this.bFastPass) {
                this.notifyAll();
            }
        }
        catch (IOException iOException) {
            JDebug.WARNING(iOException);
        }
    }

    public synchronized void removeDbPage(int n) {
        int[] nArray = this.addElement.elements();
        boolean bl = false;
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n2 = nArray[i];
            if (this.recordPerPage * (n2 + 1) > n) continue;
            this.addElement.removeElement(n2);
            DbPage dbPage = (DbPage)this.WARNING.remove(n2);
            dbPage.clearMem();
            bl = true;
        }
        if (bl) {
            this.notifyAll();
        }
    }

    private boolean $assertionsDisabled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DbPage SEDU(int n) throws IOException {
        DbPage dbPage = null;
        Vector vector = this.clearMem;
        synchronized (vector) {
            if (this.clearMem.size() != 0) {
                dbPage = (DbPage)this.clearMem.lastElement();
                this.clearMem.removeElement(dbPage);
            }
        }
        if (dbPage == null) {
            dbPage = new DbPage(this, n);
        } else {
            dbPage.setPageNumber(n);
        }
        if (this.bufFile == null) {
            this.createTempFile();
        }
        this.bufFile.seek(this.offsetBegine + (long)this.recordSize * (long)this.recordPerPage * (long)n);
        dbPage.readFromFile(this.bufFile);
        return dbPage;
    }

    private void WARNING(DbPage dbPage) {
        if (this.addElement.firstElement() != dbPage.getPageNumber()) {
            int n = dbPage.getPageNumber();
            this.addElement.removeElement(n);
            this.addElement.insertElementAt(n, 0);
        }
    }

    protected DbPage getPageOfTheRow(int n) throws IOException {
        int n2 = this.getPageNumberByRowNumber(n);
        DbPage dbPage = null;
        if (this.lastPage != null && n2 == this.lastPage.getPageNumber()) {
            dbPage = this.lastPage;
        } else {
            dbPage = (DbPage)this.WARNING.get(n2);
            if (dbPage == null) {
                dbPage = this.SEDU(n2);
                this.cacheThePage(dbPage);
            } else if (this.finished) {
                this.WARNING(dbPage);
            }
        }
        return dbPage;
    }

    public DbRecordModel getRecordModel() {
        return this.recordModel;
    }

    public void setRecordModel(DbRecordModel dbRecordModel) {
        this.recordModel = dbRecordModel;
        this.close = new AdMetaData(dbRecordModel);
    }

    public void setMetaData(AdMetaData adMetaData) {
        this.close = adMetaData;
    }

    public void setNeedWaitFetch(boolean bl) {
        this.bNeedWaitFetch = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAllToFile() throws IOException {
        if (!this.cacheToFile) {
            return;
        }
        if (this.bufFile == null) {
            this.createTempFile();
        }
        if (!this.cacheToFile) {
            return;
        }
        RAFile rAFile = this.bufFile;
        synchronized (rAFile) {
            int[] nArray = this.addElement.elements();
            for (int i = 0; i < nArray.length; ++i) {
                DbPage dbPage = (DbPage)this.WARNING.get(nArray[i]);
                dbPage.refreshToFile(this.bufFile);
            }
            if (this.lastPage != null) {
                this.lastPage.refreshToFile(this.bufFile);
            }
        }
    }

    public void saveTo(RandomOutputable randomOutputable) throws IOException {
        if (this.bufFile != null) {
            this.refreshAllToFile();
            this.bufFile.saveTo(new FileBlockOutputStream(randomOutputable));
        } else {
            long l = randomOutputable.getPosition();
            int[] nArray = this.addElement.elements();
            for (int i = 0; i < nArray.length; ++i) {
                DbPage dbPage = (DbPage)this.WARNING.get(nArray[i]);
                dbPage.write(randomOutputable, l);
            }
            if (this.lastPage != null) {
                this.lastPage.write(randomOutputable, l);
            }
        }
    }

    public int countPage() {
        return this.currentEnd / this.recordPerPage + (this.currentEnd % this.recordPerPage != 0 ? 1 : 0);
    }

    public DbPage fetchPage(DbPage dbPage, int n) throws IOException {
        if (this.cacheToFile) {
            if (dbPage == null) {
                dbPage = new DbPage(this, n);
            } else {
                dbPage.setPageNumber(n);
            }
            dbPage.readFromFile(this.bufFile);
            return dbPage;
        }
        if (this.lastPage != null && n == this.lastPage.getPageNumber()) {
            return this.lastPage;
        }
        return (DbPage)this.WARNING.get(n);
    }

    public int getBlobCount() {
        return this.addRecord;
    }

    public final int getRecordPerPage() {
        return this.recordPerPage;
    }

    public final int getRecordSize() {
        return this.recordSize;
    }

    public final Vector getBlobFiles() {
        return this.bigDecimalLength;
    }

    protected long[] getBlobEntrys(int n) throws IOException {
        long[] lArray = null;
        DbPage dbPage = this.getPageOfTheRow(n);
        int n2 = this.getRealRowNumberByRowNumber(n);
        if (this.addRecord != 0) {
            lArray = new long[this.addRecord];
            int n3 = 0;
            for (int i = 1; i < dbPage.columns.length; ++i) {
                if (!(dbPage.columns[i] instanceof DbLongVariable)) continue;
                lArray[n3++] = ((DbLongColumnBuffer)dbPage.columns[i]).buffer[n2];
            }
        }
        return lArray;
    }

    public int getCurrentEnd() {
        return this.currentEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n;
        boolean bl = false;
        if (this.createTempFile != null && !this.createTempFile.equals(JRLoggingUtil.getNDC())) {
            JRLoggingUtil.setNDC(this.createTempFile);
            bl = true;
        }
        if ((n = this.getPageNumberByRowNumber(this.currentEnd - 1)) <= this.largestPageSize) {
            return;
        }
        while (this.byteValue) {
            Object object;
            if (this.clear == -1 && !this.singleThread) {
                object = this.cacheThePage;
                synchronized (object) {
                    try {
                        this.cacheThePage.wait(2000L);
                        this.cacheThePage.notify();
                    }
                    catch (InterruptedException interruptedException) {
                        createRecord.error("", interruptedException);
                    }
                    continue;
                }
            }
            int n2 = this.getPageNumberByRowNumber(this.clear);
            if (n2 == n - 1) break;
            try {
                for (int i = n2; i < this.largestPageSize + n2 && i != n - 1; ++i) {
                    object = this.WARNING;
                    synchronized (object) {
                        DbPage dbPage = (DbPage)this.WARNING.get(i);
                        if (dbPage == null) {
                            dbPage = this.SEDU(i);
                            this.cacheThePage(dbPage);
                            if (!this.singleThread) {
                                try {
                                    this.WARNING.notify();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        continue;
                    }
                }
            }
            catch (Exception exception) {
            }
        }
    }

    public void setID(int n) {
        this.id = n;
    }

    public String toString() {
        return super.toString() + '@' + this.id;
    }

    public int getReadCursor() {
        return this.currentReadingRow;
    }

    public void setReadCursor(int n) {
        this.currentReadingRow = n;
    }

    public Object clone() {
        DbRecordModel dbRecordModel = (DbRecordModel)this.recordModel.clone();
        DbBuffer dbBuffer = new DbBuffer(this.singleThread, dbRecordModel, (Hashtable)this.descToBlobFiles.clone(), this.id, this.recordPerPage, this.largestPageSize);
        dbBuffer.cacheToFile = this.cacheToFile;
        dbBuffer.currentReadingRow = 0;
        dbBuffer.initFile();
        this.currentReadingRow = 0;
        try {
            Record record = null;
            while (this.currentReadingRow < this.currentEnd) {
                record = this.recordModel.createRecord();
                this.nextRecord(record, false);
                dbBuffer.addRecord(record);
            }
            dbBuffer.finished = true;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return dbBuffer;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        if (n > 0) {
            if (n < this.currentEnd) {
                this.currentReadingRow = n - 1;
                this.nextRecord(this.clone, false);
                return true;
            }
            this.currentReadingRow = this.currentEnd;
            return false;
        }
        if (n < 0) {
            if (-n > this.currentEnd - 1) {
                this.currentReadingRow = 0;
                this.nextRecord(this.clone, false);
                return true;
            }
            this.currentReadingRow = this.currentEnd - n;
            this.nextRecord(this.clone, false);
            return true;
        }
        return false;
    }

    @Override
    public boolean first() throws SQLException {
        if (this.currentEnd > 0 && this.finished) {
            this.clone = this.recordModel.createRecord();
            this.currentReadingRow = 0;
            this.nextRecord(this.clone, false);
            return true;
        }
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        this.currentReadingRow = this.currentEnd - 1;
        this.clone = this.recordModel.createRecord();
        this.nextRecord(this.clone, false);
        return true;
    }

    @Override
    public boolean next() throws SQLException {
        this.clone = this.recordModel.createRecord();
        if (this.currentReadingRow < this.currentEnd) {
            this.nextRecord(this.clone, false);
            return true;
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        --this.currentReadingRow;
        if (this.currentReadingRow >= 0) {
            this.clone = this.recordModel.createRecord();
            this.nextRecord(this.clone, false);
            return true;
        }
        return false;
    }

    @Override
    public boolean relative(int n) throws SQLException {
        int n2 = this.currentReadingRow + n;
        if (n2 < 0) {
            this.currentReadingRow = 0;
            this.clone = this.recordModel.createRecord();
            this.nextRecord(this.clone, false);
            return false;
        }
        if (n2 >= this.currentEnd) {
            this.currentReadingRow = this.currentEnd;
            return false;
        }
        this.currentReadingRow = n2;
        this.clone = this.recordModel.createRecord();
        this.nextRecord(this.clone, false);
        return true;
    }

    @Override
    public void afterLast() throws SQLException {
        this.currentReadingRow = this.currentEnd;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.currentReadingRow == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.currentReadingRow == this.currentEnd - 1 && this.finished;
    }

    @Override
    public int findColumn(String string) throws SQLException {
        return this.indexOfCell(string);
    }

    @Override
    public Array getArray(int n) throws SQLException {
        return null;
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return null;
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        throw new SQLException();
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        throw new SQLException();
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        DbValue dbValue = this.clone.getCell(n);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbDecimal) {
            return ((DbDecimal)dbValue).get();
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.getBigDecimal(n);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        DbValue dbValue = this.clone.getCell(string);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbDecimal) {
            return ((DbDecimal)dbValue).get();
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(string);
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        throw new SQLException();
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        throw new SQLException();
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        throw new SQLException();
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        throw new SQLException();
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        DbValue dbValue = this.clone.getCell(n);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbBit) {
            return ((DbBit)dbValue).get();
        }
        return false;
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        DbValue dbValue = this.clone.getCell(string);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbDecimal) {
            return ((DbBit)dbValue).get();
        }
        return false;
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        throw new SQLException();
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        throw new SQLException();
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        throw new SQLException();
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        throw new SQLException();
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public String getCursorName() throws SQLException {
        return null;
    }

    @Override
    public Date getDate(int n) throws SQLException {
        DbValue dbValue = this.clone.getCell(n);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbDateTime) {
            return (Date)((DbDateTime)dbValue).toSqlDate();
        }
        return null;
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        throw new SQLException();
    }

    @Override
    public Date getDate(String string) throws SQLException {
        DbValue dbValue = this.clone.getCell(string);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbDateTime) {
            return (Date)((DbDateTime)dbValue).toSqlDate();
        }
        return null;
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw new SQLException();
    }

    @Override
    public float getFloat(int n) throws SQLException {
        DbValue dbValue = this.clone.getCell(n);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).floatValue();
        }
        return 0.0f;
    }

    @Override
    public float getFloat(String string) throws SQLException {
        DbValue dbValue = this.clone.getCell(string);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).floatValue();
        }
        return 0.0f;
    }

    @Override
    public int getInt(int n) throws SQLException {
        DbValue dbValue = this.clone.getCell(n);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).intValue();
        }
        if (dbValue instanceof DbTimestamp) {
            return ((DbTimestamp)dbValue).getNanos();
        }
        return 0;
    }

    @Override
    public int getInt(String string) {
        DbValue dbValue = this.clone.getCell(string);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).intValue();
        }
        if (dbValue instanceof DbTimestamp) {
            return ((DbTimestamp)dbValue).getNanos();
        }
        return 0;
    }

    @Override
    public long getLong(int n) throws SQLException {
        DbValue dbValue = this.clone.getCell(n);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).longValue();
        }
        if (dbValue instanceof DbDateTime) {
            return ((DbDateTime)dbValue).get();
        }
        return 0L;
    }

    @Override
    public long getLong(String string) throws SQLException {
        DbValue dbValue = this.clone.getCell(string);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).longValue();
        }
        if (dbValue instanceof DbDateTime) {
            return ((DbDateTime)dbValue).get();
        }
        return 0L;
    }

    @Override
    public double getDouble(int n) throws SQLException {
        DbValue dbValue = this.clone.getCell(n);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).doubleValue();
        }
        return 0.0;
    }

    @Override
    public double getDouble(String string) throws SQLException {
        DbValue dbValue = this.clone.getCell(string);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).doubleValue();
        }
        return 0.0;
    }

    @Override
    public short getShort(int n) throws SQLException {
        DbValue dbValue = this.clone.getCell(n);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).shortValue();
        }
        return 0;
    }

    @Override
    public short getShort(String string) throws SQLException {
        DbValue dbValue = this.clone.getCell(string);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).shortValue();
        }
        return 0;
    }

    @Override
    public byte getByte(int n) throws SQLException {
        DbValue dbValue = this.clone.getCell(n);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).byteValue();
        }
        return 0;
    }

    @Override
    public byte getByte(String string) throws SQLException {
        DbValue dbValue = this.clone.getCell(string);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).byteValue();
        }
        return 0;
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        DbValue dbValue = this.clone.getCell(n);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbChar) {
            return ((DbChar)dbValue).getRaw();
        }
        return null;
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        DbValue dbValue = this.clone.getCell(string);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbChar) {
            return ((DbChar)dbValue).getRaw();
        }
        return null;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1003;
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new SQLException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.close;
    }

    @Override
    public Object getObject(int n) throws SQLException {
        DbValue dbValue = this.clone.getCell(n);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbBinary) {
            return ((DbBinary)dbValue).get();
        }
        if (dbValue instanceof DbBit) {
            return new Boolean(((DbBit)dbValue).get());
        }
        if (dbValue instanceof DbChar) {
            return ((DbChar)dbValue).get();
        }
        if (dbValue instanceof DbDateTime) {
            return ((DbDateTime)dbValue).toSqlDate();
        }
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).toString();
        }
        return null;
    }

    @Override
    public Object getObject(String string) throws SQLException {
        DbValue dbValue = this.clone.getCell(string);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbBinary) {
            return ((DbBinary)dbValue).get();
        }
        if (dbValue instanceof DbBit) {
            return new Boolean(((DbBit)dbValue).get());
        }
        if (dbValue instanceof DbChar) {
            return ((DbChar)dbValue).get();
        }
        if (dbValue instanceof DbDateTime) {
            return ((DbDateTime)dbValue).toSqlDate();
        }
        if (dbValue instanceof DbNumber) {
            return ((DbNumber)dbValue).toString();
        }
        return null;
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw new SQLException();
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw new SQLException();
    }

    @Override
    public int getRow() throws SQLException {
        return this.currentReadingRow + 1;
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new SQLException();
    }

    @Override
    public String getString(int n) throws SQLException {
        DbValue dbValue = this.clone.getCell(n);
        this.columns = dbValue.isNull();
        return this.clone.getCell(n).toString();
    }

    @Override
    public String getString(String string) throws SQLException {
        DbValue dbValue = this.clone.getCell(string);
        this.columns = dbValue.isNull();
        return dbValue.toString();
    }

    @Override
    public Time getTime(int n) throws SQLException {
        DbValue dbValue = this.clone.getCell(n);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbTime) {
            return ((DbTime)dbValue).getTime();
        }
        return null;
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        throw new SQLException();
    }

    @Override
    public Time getTime(String string) throws SQLException {
        DbValue dbValue = this.clone.getCell(string);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbTime) {
            return ((DbTime)dbValue).getTime();
        }
        return null;
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw new SQLException();
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        DbValue dbValue = this.clone.getCell(n);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbTimestamp) {
            return ((DbTimestamp)dbValue).getTimestamp();
        }
        return null;
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw new SQLException();
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        DbValue dbValue = this.clone.getCell(string);
        this.columns = dbValue.isNull();
        if (dbValue instanceof DbTimestamp) {
            return ((DbTimestamp)dbValue).getTimestamp();
        }
        return null;
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw new SQLException();
    }

    @Override
    public int getType() throws SQLException {
        return 0;
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        throw new SQLException();
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        throw new SQLException();
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw new SQLException();
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw new SQLException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.currentReadingRow >= this.currentEnd;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.currentEnd > 0) {
            return this.currentReadingRow == 0;
        }
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.columns;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
    }

    @Override
    public void moveToInsertRow() throws SQLException {
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
    }

    @Override
    public void updateNull(int n) throws SQLException {
    }

    @Override
    public void updateNull(String string) throws SQLException {
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
    }

    @Override
    public void updateRow() throws SQLException {
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
    }

    @Override
    public void updateTime(int n, Time time2) throws SQLException {
    }

    @Override
    public void updateTime(String string, Time time2) throws SQLException {
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
    }

    @Override
    public void refreshRow() throws SQLException {
    }

    @Override
    public void insertRow() throws SQLException {
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
        this.clearMem();
        this.clone = null;
        this.close = null;
    }

    @Override
    public void deleteRow() throws SQLException {
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.currentReadingRow = 0;
        if (this.currentEnd > 0 && this.finished) {
            this.finished = false;
        }
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
    }

    public Object unwrap(Class clazz) throws SQLException {
        throw new UnsupportedException();
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        throw new UnsupportedException();
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new UnsupportedException();
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public String getNString(int n) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public String getNString(String string) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        throw new UnsupportedException();
    }
}

