/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;

public class DbByteColumnBuffer
extends DbColumnBuffer {
    byte[] buffer;

    public byte[] getBuffer() {
        return this.buffer;
    }

    public DbByteColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.buffer = new byte[n];
    }

    @Override
    public void updateCell(int n, DbValue dbValue) {
        this.buffer[n] = (byte)((DbTinyInt)dbValue).get();
    }

    @Override
    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbTinyInt)dbValue).set(this.buffer[n]);
    }

    @Override
    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < this.buffer.length; ++i) {
            dataOutput.writeByte(this.buffer[i]);
        }
    }

    @Override
    protected void readValueFromFile(DataInput dataInput) throws IOException {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = dataInput.readByte();
        }
    }

    @Override
    public void clearMem() {
        super.clearMem();
        this.buffer = null;
    }
}

