/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import jet.connect.Db;
import jet.util.ColumnIndexable;

public class DbColDesc
implements ColumnIndexable,
Externalizable {
    private static final long serialVersionUID = -2302355524900996201L;
    public static final int CURRENCY = 1;
    public static final int CONSTANT = 2;
    public static final int GROUPABLE = 4;
    public static final int USER_DEFINED = 8;
    public static final int PARAMETER = 16;
    public static final int GLOBAL = 32;
    public static final int IGNORECASE = 64;
    public static final int NOTAUTOENCODE = 128;
    public static final int ENCODE = 256;
    public static final int GROUPLEVEL = 512;
    public static final int ARRAY = 1024;
    public String colName;
    public int sqlType;
    public int precision;
    public int scale;
    public int nullable;
    int colIndex = -1;
    private int SEDU = 0;
    private String append = "8859_1";
    public int bigDecimalLength = 0;
    private String equals = null;
    private boolean getColName = true;
    int fromEncoding = -1;
    int toEncoding = -1;

    public DbColDesc() {
        this(null, 0, 0, 0, 2);
    }

    public DbColDesc(String string, int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            this.SEDU |= 1;
        }
        if (n == 2003) {
            this.SEDU |= 0x400;
        }
        this.colName = string;
        this.sqlType = n;
        this.precision = n2;
        this.scale = n3;
        if (this.scale < 0) {
            this.scale = 0;
        }
        this.nullable = n4;
    }

    public DbColDesc(String string, int n, int n2, int n3, int n4) {
        this(string, n, n2, n3, n4, false);
    }

    public DbColDesc(DbColDesc dbColDesc) {
        this.colName = dbColDesc.colName;
        this.sqlType = dbColDesc.sqlType;
        this.precision = dbColDesc.precision;
        this.scale = dbColDesc.scale;
        this.nullable = dbColDesc.nullable;
        this.colIndex = dbColDesc.colIndex;
        this.SEDU = dbColDesc.SEDU;
        this.fromEncoding = dbColDesc.fromEncoding;
        this.toEncoding = dbColDesc.toEncoding;
    }

    public void setConvertEncoding(int n, int n2) {
        this.toEncoding = n2;
        this.fromEncoding = n;
    }

    public int getFlag() {
        return this.SEDU;
    }

    public void setFlag(int n) {
        this.SEDU = n;
    }

    public final void setGroupable(boolean bl) {
        this.SEDU = bl ? (this.SEDU |= 4) : (this.SEDU &= 0xFFFFFFFB);
    }

    public final boolean isGroupable() {
        return (this.SEDU & 4) != 0;
    }

    public void setConstant(boolean bl) {
        this.SEDU = bl ? (this.SEDU |= 2) : (this.SEDU &= 0xFFFFFFFD);
    }

    public boolean isConstant() {
        return (this.SEDU & 2) != 0;
    }

    public void setCurrency(boolean bl) {
        this.SEDU = bl ? (this.SEDU |= 1) : (this.SEDU &= 0xFFFFFFFE);
    }

    public boolean isCurrency() {
        return (this.SEDU & 1) != 0;
    }

    public void setUserDef(boolean bl) {
        this.SEDU = bl ? (this.SEDU |= 8) : (this.SEDU &= 0xFFFFFFF7);
    }

    public boolean isUserDef() {
        return (this.SEDU & 8) != 0;
    }

    public void setGlobal(boolean bl) {
        this.SEDU = bl ? (this.SEDU |= 0x20) : (this.SEDU &= 0xFFFFFFDF);
    }

    public boolean isGlobal() {
        return (this.SEDU & 0x20) != 0;
    }

    public void setParameter(boolean bl) {
        this.SEDU = bl ? (this.SEDU |= 0x10) : (this.SEDU &= 0xFFFFFFEF);
    }

    public boolean isParameter() {
        return (this.SEDU & 0x10) != 0;
    }

    public void setIgnoreCase(boolean bl) {
        this.SEDU = bl ? (this.SEDU |= 0x40) : (this.SEDU &= 0xFFFFFFBF);
    }

    public boolean isIgnoreCase() {
        return (this.SEDU & 0x40) != 0;
    }

    public void setNotAutoEncode(boolean bl) {
        this.SEDU = bl ? (this.SEDU |= 0x80) : (this.SEDU &= 0xFFFFFF7F);
    }

    public boolean isNotAutoEncode() {
        return (this.SEDU & 0x80) != 0;
    }

    public void setEncode(boolean bl) {
        this.SEDU = bl ? (this.SEDU |= 0x100) : (this.SEDU &= 0xFFFFFEFF);
    }

    public boolean isEncode() {
        return (this.SEDU & 0x100) != 0;
    }

    public void setGroupLevel(boolean bl) {
        this.SEDU = bl ? (this.SEDU |= 0x200) : (this.SEDU &= 0xFFFFFDFF);
    }

    public boolean isGroupLevel() {
        return (this.SEDU & 0x200) != 0;
    }

    public void setArray(boolean bl) {
        this.SEDU = bl ? (this.SEDU |= 0x400) : (this.SEDU &= 0xFFFFFBFF);
    }

    public boolean isArray() {
        return (this.SEDU & 0x400) != 0;
    }

    public void setEncodingName(String string) {
        this.append = string;
    }

    public String getEncodingName() {
        return this.append;
    }

    public void setColIndex(int n) {
        this.colIndex = n;
    }

    @Override
    public int getColIndex() {
        return this.colIndex;
    }

    public String getColName() {
        return this.colName;
    }

    public void setColName(String string) {
        this.colName = string;
    }

    public void setRealColName(String string) {
        this.equals = string;
    }

    public String getRealColName() {
        return this.equals;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(int n) {
        this.sqlType = n;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public int getNullable() {
        return this.nullable;
    }

    public Object clone() {
        return new DbColDesc(this);
    }

    public boolean typeEquals(DbColDesc dbColDesc) {
        return this.sqlType == dbColDesc.sqlType && this.precision == dbColDesc.precision && this.scale == dbColDesc.scale && this.nullable == dbColDesc.nullable;
    }

    public String toString() {
        return "DbColDesc[colName: " + this.colName + "/" + "sqlType: " + Db.toTypeString(this.sqlType) + "/" + "precision: " + this.precision + "/" + "scale: " + this.scale + "/" + "nullable: " + this.nullable + "/colIndex: " + this.colIndex + "]";
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this.colName.equals(((DbColDesc)object).getColName())) {
            bl = true;
        }
        return bl;
    }

    public boolean isReadOnly() {
        return this.getColName;
    }

    public void setReadOnly(boolean bl) {
        this.getColName = bl;
    }

    public int getToEncoding() {
        return this.toEncoding;
    }

    public int getFromEncoding() {
        return this.fromEncoding;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.colName = (String)objectInput.readObject();
        this.sqlType = objectInput.readInt();
        this.precision = objectInput.readInt();
        this.scale = objectInput.readInt();
        this.nullable = objectInput.readInt();
        this.SEDU = objectInput.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.colName);
        objectOutput.writeInt(this.sqlType);
        objectOutput.writeInt(this.precision);
        objectOutput.writeInt(this.scale);
        objectOutput.writeInt(this.nullable);
        objectOutput.writeInt(this.SEDU);
    }
}

