/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbArrayColumnBuffer;
import jet.connect.DbBigDecimalColumnBuffer;
import jet.connect.DbBinaryColumnBuffer;
import jet.connect.DbBooleanColumnBuffer;
import jet.connect.DbByteColumnBuffer;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbConstantColumn;
import jet.connect.DbDateColumnBuffer;
import jet.connect.DbDoubleColumnBuffer;
import jet.connect.DbFloatColumnBuffer;
import jet.connect.DbGroupColumnBuffer;
import jet.connect.DbIntegerColumnBuffer;
import jet.connect.DbLongColumnBuffer;
import jet.connect.DbLongVarBinaryColumnBuffer;
import jet.connect.DbLongVarCharColumnBuffer;
import jet.connect.DbShortColumnBuffer;
import jet.connect.DbStringColumnBuffer;
import jet.connect.DbTimeColumnBuffer;
import jet.connect.DbTimestampColumnBuffer;
import jet.connect.DbValue;

public abstract class DbColumn {
    static byte NOTNULL = 1;
    DbColDesc coldesc;

    public DbColumn(DbColDesc dbColDesc) {
        this.coldesc = dbColDesc;
    }

    public abstract void updateCell(int var1, DbValue var2);

    public abstract void refreshFromCell(int var1, DbValue var2);

    public abstract void updateValue(int var1, DbValue var2);

    public abstract void refreshValue(int var1, DbValue var2);

    public abstract boolean isNull(int var1);

    public abstract void writeToFile(DataOutput var1) throws IOException;

    public abstract void readFromFile(DataInput var1) throws IOException;

    public abstract void reset();

    public void clearMem() {
        this.coldesc = null;
    }

    public DbColDesc getColDesc() {
        return this.coldesc;
    }

    public static DbColumn makeDbColumn(DbColDesc dbColDesc, int n) {
        DbColumn dbColumn = null;
        if (dbColDesc.isConstant()) {
            dbColumn = new DbConstantColumn(dbColDesc);
        } else if (dbColDesc.isGroupable() || dbColDesc.isGroupLevel()) {
            dbColumn = new DbGroupColumnBuffer(dbColDesc);
        } else if (dbColDesc.isArray()) {
            dbColumn = new DbArrayColumnBuffer(dbColDesc, n);
        } else {
            switch (dbColDesc.sqlType) {
                case -6: {
                    dbColumn = new DbByteColumnBuffer(dbColDesc, n);
                    break;
                }
                case 5: {
                    dbColumn = new DbShortColumnBuffer(dbColDesc, n);
                    break;
                }
                case 4: {
                    dbColumn = new DbIntegerColumnBuffer(dbColDesc, n);
                    break;
                }
                case -5: {
                    dbColumn = new DbLongColumnBuffer(dbColDesc, n);
                    break;
                }
                case 6: 
                case 7: {
                    dbColumn = new DbFloatColumnBuffer(dbColDesc, n);
                    break;
                }
                case 2: 
                case 3: {
                    dbColumn = new DbBigDecimalColumnBuffer(dbColDesc, n);
                    break;
                }
                case 8: {
                    dbColumn = new DbDoubleColumnBuffer(dbColDesc, n);
                    break;
                }
                case -7: {
                    dbColumn = new DbBooleanColumnBuffer(dbColDesc, n);
                    break;
                }
                case 91: {
                    dbColumn = new DbDateColumnBuffer(dbColDesc, n);
                    break;
                }
                case 92: {
                    dbColumn = new DbTimeColumnBuffer(dbColDesc, n);
                    break;
                }
                case 93: {
                    dbColumn = new DbTimestampColumnBuffer(dbColDesc, n);
                    break;
                }
                case 1: 
                case 12: {
                    dbColumn = new DbStringColumnBuffer(dbColDesc, n);
                    break;
                }
                case -1: 
                case 2005: {
                    dbColumn = new DbLongVarCharColumnBuffer(dbColDesc, n);
                    break;
                }
                case -3: 
                case -2: {
                    dbColumn = new DbBinaryColumnBuffer(dbColDesc, n);
                    break;
                }
                case -4: 
                case 2004: {
                    dbColumn = new DbLongVarBinaryColumnBuffer(dbColDesc, n);
                    break;
                }
            }
        }
        if (dbColumn instanceof DbColumnBuffer) {
            ((DbColumnBuffer)dbColumn).flags = new byte[n];
        }
        return dbColumn;
    }
}

