/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbDouble;
import jet.connect.DbReal;
import jet.connect.DbValue;

public class DbFloatColumnBuffer
extends DbColumnBuffer {
    float[] buffer;

    public float[] getBuffer() {
        return this.buffer;
    }

    public DbFloatColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.buffer = new float[n];
    }

    @Override
    public void updateCell(int n, DbValue dbValue) {
        this.buffer[n] = ((DbReal)dbValue).get();
    }

    @Override
    public void refreshFromCell(int n, DbValue dbValue) {
        if (dbValue instanceof DbReal) {
            ((DbReal)dbValue).set(this.buffer[n]);
        } else {
            ((DbDouble)dbValue).set(this.buffer[n]);
        }
    }

    @Override
    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < this.buffer.length; ++i) {
            dataOutput.writeFloat(this.buffer[i]);
        }
    }

    @Override
    protected void readValueFromFile(DataInput dataInput) throws IOException {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = dataInput.readFloat();
        }
    }

    @Override
    public void clearMem() {
        super.clearMem();
        this.buffer = null;
    }
}

