/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbInteger;
import jet.connect.DbValue;

public class DbIntegerColumnBuffer
extends DbColumnBuffer {
    int[] buffer;

    public int[] getBuffer() {
        return this.buffer;
    }

    public DbIntegerColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.buffer = new int[n];
    }

    @Override
    public void updateCell(int n, DbValue dbValue) {
        this.buffer[n] = ((DbInteger)dbValue).get();
    }

    @Override
    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbInteger)dbValue).set(this.buffer[n]);
    }

    @Override
    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < this.buffer.length; ++i) {
            dataOutput.writeInt(this.buffer[i]);
        }
    }

    @Override
    protected void readValueFromFile(DataInput dataInput) throws IOException {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = dataInput.readInt();
        }
    }

    @Override
    public void clearMem() {
        super.clearMem();
        this.buffer = null;
    }
}

