/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.File;
import java.io.IOException;
import jet.Env;
import jet.connect.DbBinary;
import jet.connect.DbColDesc;
import jet.connect.DbLongColumnBuffer;
import jet.connect.DbLongVariable;
import jet.connect.DbValue;
import jet.log.JRLogger;
import jet.util.RAFile;
import jet.util.TempFile;

public class DbLongVarBinaryColumnBuffer
extends DbLongColumnBuffer
implements DbLongVariable {
    private static JRLogger SEDU = JRLogger.getLogger(DbLongVarBinaryColumnBuffer.class.getName());
    private RAFile clearMem;
    private File createTempFile;
    private boolean delete = true;
    private byte[][] error;
    TempFile tempFile;

    public DbLongVarBinaryColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
    }

    @Override
    public RAFile createTempFile() throws IOException {
        this.tempFile = new TempFile(Env.getTemporaryPath(), "lonvarbin");
        this.createTempFile = this.tempFile.createTempFile();
        this.clearMem = new RAFile(this.createTempFile, "rw");
        return this.clearMem;
    }

    @Override
    public File getFile() {
        return this.createTempFile;
    }

    @Override
    public void setBufFile(RAFile rAFile) {
        this.clearMem = rAFile;
    }

    @Override
    public void setCacheToFile(boolean bl) {
        this.delete = bl;
        this.error = new byte[this.buffer.length][];
    }

    @Override
    public void updateCell(int n, DbValue dbValue) {
        block8: {
            try {
                byte[] byArray = ((DbBinary)dbValue).get();
                if (this.delete) {
                    if (!this.isReady(n)) {
                        this.buffer[n] = this.clearMem.length();
                    } else {
                        this.clearMem.seek(this.buffer[n]);
                        int n2 = 0;
                        try {
                            this.clearMem.readInt();
                        }
                        catch (Exception exception) {
                            SEDU.error("", exception);
                        }
                        if (n2 < byArray.length) {
                            this.buffer[n] = this.clearMem.length();
                        }
                    }
                    this.clearMem.seek(this.buffer[n]);
                    this.clearMem.writeInt(byArray.length);
                    this.clearMem.write(byArray);
                    break block8;
                }
                this.error[n] = byArray;
            }
            catch (IOException iOException) {
                SEDU.error("", iOException);
            }
        }
    }

    @Override
    public void refreshFromCell(int n, DbValue dbValue) {
        try {
            byte[] byArray;
            if (this.delete) {
                this.clearMem.seek(this.buffer[n]);
                int n2 = this.clearMem.readInt();
                byArray = new byte[n2];
                this.clearMem.read(byArray);
            } else {
                byArray = this.error[n];
            }
            ((DbBinary)dbValue).set(byArray);
        }
        catch (IOException iOException) {
            SEDU.error("", iOException);
        }
    }

    protected void finalize() {
        if (this.createTempFile != null) {
            this.createTempFile.delete();
        }
    }

    @Override
    public void setByteRow(byte[] byArray, int n) {
        int n2 = n % this.buffer.length;
        this.error[n2] = byArray;
    }

    @Override
    public void clearMem() {
        super.clearMem();
        this.error = null;
    }
}

