/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbBuffer;
import jet.connect.DbColumn;
import jet.connect.DbInteger;
import jet.connect.DbLongVariable;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.datastream.RandomByteArrayOutputStream;
import jet.ie.io.PJFDataOutput;
import jet.util.RandomInputable;
import jet.util.RandomOutputable;

public class DbPage {
    int pageNumber = -1;
    DbColumn[] columns;
    private DbBuffer I;
    private boolean J = true;
    int currentGroupNumber = -1;
    DbValue[] currentGroupValue;

    public DbColumn[] getColumns() {
        return this.columns;
    }

    public DbColumn[] getBlobColumns() {
        int n = this.I.getBlobCount();
        DbColumn[] dbColumnArray = null;
        if (n != 0) {
            dbColumnArray = new DbColumn[n];
            int n2 = 0;
            for (int i = 0; i < this.columns.length; ++i) {
                if (!(this.columns[i] instanceof DbLongVariable)) continue;
                dbColumnArray[n2++] = this.columns[i];
            }
        }
        return dbColumnArray;
    }

    public DbPage(DbBuffer dbBuffer, int n) throws IOException {
        this.pageNumber = n;
        this.I = dbBuffer;
        this.columns = dbBuffer.makeDbColumnBuffer(this);
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int n) {
        this.pageNumber = n;
    }

    void updateRecord(int n, Record record) {
        DbValue[] dbValueArray = record.getValueArray();
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i].updateValue(n, dbValueArray[i]);
        }
        this.J = true;
    }

    void updateRecord(int n, Record record, int n2) {
        DbValue[] dbValueArray = record.getValueArray();
        this.columns[n2].updateValue(n, dbValueArray[n2]);
        this.J = true;
    }

    void refreshRecord(int n, Record record, int n2) {
        DbValue[] dbValueArray = record.getValueArray();
        this.columns[n2].refreshValue(n, dbValueArray[n2]);
    }

    void refreshRecord(int n, Record record, boolean bl) {
        DbValue[] dbValueArray = record.getValueArray();
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i].refreshValue(n, dbValueArray[i]);
        }
        if (!bl && this.I.recordModel.groupable != null) {
            if (dbValueArray[0].isNull()) {
                this.I.recordModel.groupable.getValuesByRecordNumber(record);
            } else {
                this.I.recordModel.groupable.getValues(((DbInteger)dbValueArray[0]).value, record);
            }
        }
    }

    void discard() {
        this.pageNumber = -1;
        this.currentGroupValue = null;
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i].reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshToFile(RandomOutputable randomOutputable) throws IOException {
        if (!this.J) {
            return;
        }
        RandomOutputable randomOutputable2 = randomOutputable;
        synchronized (randomOutputable2) {
            long l = this.I.offsetBegine + (long)this.I.recordSize * (long)this.I.recordPerPage * (long)this.pageNumber;
            long l2 = randomOutputable.length();
            if (l2 < l) {
                long l3 = l - l2;
                randomOutputable.seek(l2);
                randomOutputable.write(new byte[(int)l3]);
            } else {
                randomOutputable.seek(l);
            }
            this.write(randomOutputable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(RandomOutputable randomOutputable, long l) throws IOException {
        RandomOutputable randomOutputable2 = randomOutputable;
        synchronized (randomOutputable2) {
            long l2 = this.I.offsetBegine + (long)this.I.recordSize * (long)this.I.recordPerPage * (long)this.pageNumber + l;
            randomOutputable.seek(l2);
            this.write(randomOutputable);
        }
    }

    public void write(DataOutput dataOutput) throws IOException {
        RandomByteArrayOutputStream randomByteArrayOutputStream = new RandomByteArrayOutputStream(128);
        PJFDataOutput pJFDataOutput = new PJFDataOutput(randomByteArrayOutputStream);
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i].writeToFile(pJFDataOutput);
        }
        dataOutput.write(randomByteArrayOutputStream.toByteArray());
        randomByteArrayOutputStream.close();
        pJFDataOutput.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromFile(RandomInputable randomInputable) throws IOException {
        RandomInputable randomInputable2 = randomInputable;
        synchronized (randomInputable2) {
            long l = this.I.offsetBegine + (long)this.I.recordSize * (long)this.I.recordPerPage * (long)this.pageNumber;
            long l2 = randomInputable.length();
            if (l2 >= l) {
                randomInputable.seek(l);
            }
            this.read(randomInputable);
            this.J = false;
        }
    }

    public void read(DataInput dataInput) throws IOException {
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i].readFromFile(dataInput);
        }
    }

    public void finalize() {
        this.clearMem();
    }

    void clearMem() {
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                if (this.columns[i] == null) continue;
                this.columns[i].clearMem();
            }
            this.columns = null;
        }
        this.currentGroupValue = null;
    }
}

