/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.connect.AdMetaData;
import jet.connect.DbBuffer;
import jet.connect.DbColDesc;
import jet.connect.DbRecordModel;
import jet.connect.Record;

public class DbParallelBuffer
extends DbBuffer {
    Vector branchNames = new Vector();
    DbBuffer[] dbBuffers;
    int[] indexs;

    public DbParallelBuffer(DbRecordModel dbRecordModel) {
        Hashtable hashtable = dbRecordModel.getAllRM();
        int n = hashtable.size();
        this.dbBuffers = new DbBuffer[n];
        this.indexs = new int[n];
        int n2 = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            DbRecordModel dbRecordModel2 = (DbRecordModel)hashtable.get(string);
            this.branchNames.addElement(string);
            this.dbBuffers[n2] = new DbBuffer(dbRecordModel2);
            this.indexs[n2] = n2;
            dbRecordModel2.setDbBuffer(this.dbBuffers[n2++]);
        }
        this.recordModel = dbRecordModel;
        this.setMetaData(new AdMetaData(dbRecordModel));
    }

    public DbParallelBuffer(DbRecordModel dbRecordModel, Vector vector) {
        Hashtable hashtable = dbRecordModel.getAllRM();
        int n = hashtable.size();
        this.dbBuffers = new DbBuffer[n];
        this.indexs = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string = (String)vector.elementAt(i);
            DbRecordModel dbRecordModel2 = (DbRecordModel)hashtable.get(string);
            this.branchNames.addElement(string);
            this.dbBuffers[n2] = new DbBuffer(dbRecordModel2);
            this.indexs[n2] = n2;
            dbRecordModel2.setDbBuffer(this.dbBuffers[n2++]);
        }
        this.recordModel = dbRecordModel;
        this.setMetaData(new AdMetaData(dbRecordModel));
    }

    public DbParallelBuffer(boolean bl, DbRecordModel dbRecordModel, int n, int n2, int n3) {
        Hashtable hashtable = dbRecordModel.getAllRM();
        int n4 = hashtable.size();
        this.dbBuffers = new DbBuffer[n4];
        this.indexs = new int[n4];
        int n5 = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            DbRecordModel dbRecordModel2 = (DbRecordModel)hashtable.get(string);
            this.branchNames.addElement(string);
            this.dbBuffers[n5] = new DbBuffer(bl, dbRecordModel2, n, n2, n3);
            this.indexs[n5] = n5;
            dbRecordModel2.setDbBuffer(this.dbBuffers[n5++]);
        }
        this.recordModel = dbRecordModel;
        this.setMetaData(new AdMetaData(dbRecordModel));
    }

    @Override
    public void setPageCount(int n) {
        int n2 = this.dbBuffers.length;
        for (int i = 0; i < n2; ++i) {
            this.dbBuffers[i].setPageCount(n);
        }
    }

    @Override
    public void setRecPerPage(int n) {
        if (n > 0) {
            int n2 = this.dbBuffers.length;
            for (int i = 0; i < n2; ++i) {
                this.dbBuffers[i].setRecPerPage(n);
            }
        }
    }

    public synchronized void addRecord(Record record, String string) {
        int n = this.branchNames.indexOf(string);
        if (n == -1) {
            n = this.getIndexRev(string);
        }
        if (n != -1) {
            this.dbBuffers[n].addRecord(record);
        }
    }

    @Override
    public void clearMem() {
        int n = this.dbBuffers.length;
        for (int i = 0; i < n; ++i) {
            this.dbBuffers[i].clearMem();
        }
    }

    @Override
    public void setNeedWaitFetch(boolean bl) {
        int n = this.dbBuffers.length;
        for (int i = 0; i < n; ++i) {
            this.dbBuffers[i].setNeedWaitFetch(bl);
        }
    }

    public Vector getBranchs() {
        return this.branchNames;
    }

    public String getBranch(int n) {
        return (String)this.branchNames.elementAt(n);
    }

    public DbBuffer[] getBuffers() {
        return this.dbBuffers;
    }

    public int getBufferNum() {
        return this.dbBuffers.length;
    }

    public int getIndex(String string) {
        int n = this.branchNames.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)this.branchNames.elementAt(i);
            if (!string.equals(string2) && !string.startsWith(string2 + ".")) continue;
            return i;
        }
        return -1;
    }

    public DbBuffer getDbBuffer(String string) {
        int n = this.branchNames.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)this.branchNames.elementAt(i);
            if (!string.equals(string2) && !string.startsWith(string2 + ".")) continue;
            return this.dbBuffers[i];
        }
        return null;
    }

    public int getIndexRev(String string) {
        int n = this.branchNames.size();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            String string2 = (String)this.branchNames.elementAt(i);
            if (!string2.equals(string) && !string2.startsWith(string + ".")) continue;
            return i;
        }
        return -1;
    }

    public int[] getAllIndex() {
        return this.indexs;
    }

    public int getParallelSize() {
        return this.indexs.length;
    }

    public DbRecordModel getRecordModel(int n) {
        return this.dbBuffers[n].recordModel;
    }

    public DbRecordModel[] getRecordModels() {
        DbRecordModel[] dbRecordModelArray = new DbRecordModel[this.indexs.length];
        for (int i = 0; i < this.indexs.length; ++i) {
            dbRecordModelArray[i] = this.dbBuffers[i].recordModel;
        }
        return dbRecordModelArray;
    }

    public int getIndexByField(String string) {
        int n = this.branchNames.size();
        for (int i = 0; i < n; ++i) {
            if (!this.dbBuffers[i].recordModel.hasName(string)) continue;
            return i;
        }
        return -1;
    }

    public DbBuffer getBufferByField(String string) {
        int n = this.getIndexByField(string);
        if (n == -1) {
            return this.dbBuffers[0];
        }
        return this.dbBuffers[n];
    }

    public int getIndexByField(String string, String string2) {
        int n = this.branchNames.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)this.branchNames.elementAt(i);
            if (!this.dbBuffers[i].recordModel.hasName(string) || string2 != null && !string3.equals(string2) && !string3.startsWith(string2 + ".")) continue;
            return i;
        }
        return -1;
    }

    public int getIndexByField(DbColDesc dbColDesc) {
        int n = this.branchNames.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            DbColDesc[] dbColDescArray = this.dbBuffers[i].recordModel.getColDescs();
            if (dbColDescArray.length <= (n2 = dbColDesc.getColIndex()) || !dbColDescArray[n2].colName.equalsIgnoreCase(dbColDesc.colName)) continue;
            return i;
        }
        return -1;
    }

    public int getIndexByRM(DbRecordModel dbRecordModel) {
        int n = this.branchNames.size();
        for (int i = 0; i < n; ++i) {
            if (this.dbBuffers[i].recordModel != dbRecordModel) continue;
            return i;
        }
        return -1;
    }

    public int[] getIndexByFields(Vector vector) {
        int n;
        Vector<Integer> vector2 = new Vector<Integer>();
        int n2 = this.branchNames.size();
        for (int i = 0; i < n2; ++i) {
            n = 0;
            int n3 = vector.size();
            for (int j = 0; j < n3; ++j) {
                if (this.dbBuffers[i].recordModel.hasName((String)vector.elementAt(j))) continue;
                n = 1;
                break;
            }
            if (n != 0) continue;
            vector2.addElement(new Integer(i));
        }
        n2 = vector2.size();
        if (n2 == 0) {
            int[] nArray = new int[]{-1};
            return nArray;
        }
        int[] nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = (Integer)vector2.elementAt(n);
        }
        return nArray;
    }

    public int[] getAllIndexByField(String string) {
        Vector<Integer> vector = new Vector<Integer>();
        int n = this.branchNames.size();
        for (int i = 0; i < n; ++i) {
            if (!this.dbBuffers[i].recordModel.hasName(string)) continue;
            vector.addElement(new Integer(i));
        }
        n = vector.size();
        if (n == 0) {
            int[] nArray = new int[]{-1};
            return nArray;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (Integer)vector.elementAt(i);
        }
        return nArray;
    }

    @Override
    public int getRecords() {
        int n = 0;
        for (int i = 0; i < this.dbBuffers.length; ++i) {
            n += this.dbBuffers[i].getRecords();
        }
        return n;
    }

    @Override
    public Object clone() {
        DbRecordModel dbRecordModel = (DbRecordModel)this.recordModel.clone();
        DbParallelBuffer dbParallelBuffer = new DbParallelBuffer(dbRecordModel, this.getBranchs());
        dbParallelBuffer.cacheToFile = this.cacheToFile;
        dbParallelBuffer.currentReadingRow = 0;
        dbParallelBuffer.initFile();
        this.currentReadingRow = 0;
        try {
            for (int i = 0; i < this.dbBuffers.length; ++i) {
                this.copyDbBuffer(this.dbBuffers[i], dbParallelBuffer.dbBuffers[i]);
            }
            dbParallelBuffer.finished = true;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return dbParallelBuffer;
    }

    void copyDbBuffer(DbBuffer dbBuffer, DbBuffer dbBuffer2) throws SQLException {
        dbBuffer.setReadCursor(0);
        DbRecordModel dbRecordModel = dbBuffer.getRecordModel();
        Record record = null;
        for (int i = 0; i < dbBuffer.getRecords(); ++i) {
            record = dbRecordModel.createRecord();
            dbBuffer.nextRecord(record, true);
            dbBuffer2.addRecord(record);
        }
        dbBuffer2.finish();
        dbBuffer.setReadCursor(0);
    }
}

