/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import com.jinfonet.common.api.JdbcDriversConfig;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.connect.DbQuery;
import jet.log.JRLogger;
import toolkit.db.DateTimeFormat;
import toolkit.db.DbTools;
import toolkit.db.ParameterFormatInvalid;
import toolkit.db.ProcInfo;
import toolkit.db.ProcParaInfo;
import toolkit.db.SqlSupportInfo;
import toolkit.db.gui.JdbcDatabase;

public class DbProcedure {
    private JdbcDatabase SEDU;
    CallableStatement callstmt = null;
    ResultSet rs = null;
    String strCatalogName;
    String strSchemaName;
    String strName;
    Vector vecParams;
    int iNamePatten = 0;
    DateTimeFormat dateTimeFormat = null;
    String strExtraNameChar = "";
    String strExtraKeywords = "";
    String strCatalogSeparator = ".";
    String sQuoteChar = "\"";
    boolean bSuppCatInProc = false;
    boolean bSuppSchInProc = false;
    String strSQL = null;
    boolean bIsResultSetFresh = false;
    int updateCount;
    private JdbcDriversConfig add;
    private static JRLogger append = JRLogger.getLogger(DbProcedure.class.getName());
    private int bIsNull;
    private int cancel;
    private boolean close;
    private boolean closeStmt;
    private boolean connect = false;

    public DbProcedure(JdbcDatabase jdbcDatabase, String string, String string2, String string3, Vector vector, int n, DateTimeFormat dateTimeFormat) {
        this.SEDU = jdbcDatabase;
        this.strCatalogName = string;
        this.strSchemaName = string2;
        this.strName = string3;
        this.vecParams = vector;
        this.iNamePatten = n;
        this.dateTimeFormat = dateTimeFormat;
    }

    public void getSupportInfo(SqlSupportInfo sqlSupportInfo) {
        this.strCatalogSeparator = sqlSupportInfo.getQualifierSeparator();
        this.strExtraNameChar = sqlSupportInfo.getExtraNameChar();
        this.strExtraKeywords = sqlSupportInfo.getExtraKeywords();
        this.sQuoteChar = sqlSupportInfo.getQuoteChar();
        this.bSuppCatInProc = sqlSupportInfo.supportsCatalogsInProcedureCalls();
        this.bSuppSchInProc = sqlSupportInfo.supportsSchemasInProcedureCalls();
    }

    public DbProcedure(JdbcDatabase jdbcDatabase, ProcInfo procInfo, int n, DateTimeFormat dateTimeFormat) {
        this(jdbcDatabase, procInfo.getCatalog(), procInfo.getSchema(), procInfo.getName(), procInfo.getParameters(), n, dateTimeFormat);
    }

    public void setParameter(Vector vector) {
        this.vecParams = vector;
        this.bIsResultSetFresh = false;
    }

    public void setNamePatten(int n) {
        this.iNamePatten = n;
        this.bIsResultSetFresh = false;
    }

    public String getSqlStatement() {
        if (this.strSQL == null || !this.bIsResultSetFresh) {
            try {
                this.prepareSQLStatement();
            }
            catch (SQLException sQLException) {
                return null;
            }
        }
        return this.strSQL;
    }

    public ResultSet getResultSet() throws SQLException, ClassNotFoundException, ParameterFormatInvalid, JRStopEngineException {
        this.execute();
        return this.rs;
    }

    protected void prepareSQLStatement() throws SQLException {
        this.prepareSQLStatement(false);
    }

    protected void prepareSQLStatement(boolean bl) throws SQLException {
        if (this.strCatalogSeparator.equals("")) {
            this.strCatalogSeparator = ".";
        }
        int n = this.vecParams.size();
        this.strSQL = "{call ";
        String string = "";
        if ((this.strCatalogName != null && this.strCatalogName.length() > 0 || this.bSuppCatInProc) && this.iNamePatten == 2) {
            string = string + DbTools.quotedWhenNeed(this.strCatalogName, this.strExtraNameChar, this.sQuoteChar, this.strExtraKeywords) + this.strCatalogSeparator;
        }
        if ((this.strSchemaName != null && this.strSchemaName.length() > 0 || this.bSuppSchInProc) && (this.iNamePatten == 1 || this.iNamePatten == 2)) {
            string = string + DbTools.quotedWhenNeed(this.strSchemaName, this.strExtraNameChar, this.sQuoteChar, this.strExtraKeywords) + ".";
        }
        string = string + DbTools.quotedWhenNeed(this.strName, this.strExtraNameChar, this.sQuoteChar, this.strExtraKeywords);
        this.strSQL = this.strSQL + string;
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            string2 = string2 + ",?";
        }
        if (!string2.equals("")) {
            this.strSQL = this.strSQL + "(" + string2.substring(1) + ")";
        } else if (bl) {
            this.strSQL = this.strSQL + "(" + ")";
        }
        this.strSQL = this.strSQL + "}";
        if (append.isDebugEnabled()) {
            append.debug("SQL statement\n" + this.strSQL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws SQLException, ClassNotFoundException, ParameterFormatInvalid, JRStopEngineException {
        this.closeStmt();
        this.prepareSQLStatement();
        if (this.strCatalogName != null && !this.strCatalogName.equals("") && this.iNamePatten == 2) {
            this.SEDU.setDbCatalog(this.strCatalogName);
        }
        long l = System.currentTimeMillis();
        Connection connection = this.SEDU.getConnection();
        if (connection == null) {
            this.SEDU.connect();
            connection = this.SEDU.getConnection();
        }
        long l2 = System.currentTimeMillis();
        append.debug("ELAPSED : Get Connection Time for RDB Procedure : " + (l2 - l) + " (ms)", null);
        if (connection != null) {
            if (connection.getMetaData().getDatabaseProductName().toUpperCase().indexOf("MYSQL") != -1) {
                this.prepareSQLStatement(true);
            }
            int n = DbQuery.getFetchSize(connection, this.add);
            if (this.connect) {
                throw new JRStopEngineException();
            }
            if (n == 0) {
                this.callstmt = connection.prepareCall(this.strSQL);
            } else {
                this.callstmt = connection.prepareCall(this.strSQL, 1003, 1007);
                this.callstmt.setFetchSize(n);
            }
            CallableStatement callableStatement = this.callstmt;
            synchronized (callableStatement) {
                if (append.isDebugEnabled()) {
                    append.debug(this.getClass().getName() + "->Fetch Size:[" + this.callstmt.getFetchSize() + "]");
                }
                this.close = DbQuery.isSupportMaxDuration(connection, this.add);
                this.closeStmt = DbQuery.isSupportMaxRows(connection, this.add);
                if (this.close && this.bIsNull != -1) {
                    this.callstmt.setQueryTimeout(this.bIsNull);
                }
                append.debug(this.getClass().getName() + " pushDownMaxDuration:[" + this.close + "],size:[ " + this.bIsNull + "]");
                if (this.closeStmt && this.cancel != -1) {
                    this.callstmt.setMaxRows(this.cancel);
                }
                append.debug(this.getClass().getName() + " pushDowanMaxRows:[" + this.closeStmt + "],size:[ " + this.cancel + "]");
                this.prepareParameter();
            }
            boolean bl = false;
            if (this.connect) {
                throw new JRStopEngineException();
            }
            long l3 = System.currentTimeMillis();
            bl = this.callstmt.execute();
            long l4 = System.currentTimeMillis();
            if (this.connect) {
                throw new JRStopEngineException();
            }
            while (!bl) {
                if (this.callstmt.getUpdateCount() == -1) {
                    throw new SQLException("The Store procedure:[" + this.strSQL + "] dose not return any result set.");
                }
                bl = this.callstmt.getMoreResults();
            }
            if (this.connect) {
                throw new JRStopEngineException();
            }
            long l5 = System.currentTimeMillis();
            this.rs = this.callstmt.getResultSet();
            long l6 = System.currentTimeMillis();
            long l7 = l6 - l5 + (l4 - l3);
            append.debug("ELAPSED : Get ResultSet Time for RDB Procedure  : " + l7 + " (ms)", null);
            if (this.connect) {
                throw new JRStopEngineException();
            }
            this.bIsResultSetFresh = true;
        }
    }

    protected void prepareParameter() throws SQLException, ParameterFormatInvalid {
        int n;
        ProcParaInfo procParaInfo = null;
        int n2 = this.vecParams.size();
        ParameterFormatInvalid parameterFormatInvalid = new ParameterFormatInvalid();
        for (n = 0; n < n2; ++n) {
            procParaInfo = (ProcParaInfo)this.vecParams.elementAt(n);
            if (!procParaInfo.isINParameter() || procParaInfo.bIsNull || procParaInfo.isValueValid(this.dateTimeFormat)) continue;
            parameterFormatInvalid.add(procParaInfo);
        }
        if (parameterFormatInvalid.hasInvalidParameter()) {
            throw parameterFormatInvalid;
        }
        block27: for (int i = 1; i <= n2; ++i) {
            int n3;
            block32: {
                procParaInfo = (ProcParaInfo)this.vecParams.elementAt(i - 1);
                n = procParaInfo.getIndex();
                n3 = procParaInfo.getSQLType();
                if (procParaInfo.isINParameter()) {
                    if (procParaInfo.bIsNull) {
                        try {
                            this.callstmt.setNull(n, n3);
                            continue;
                        }
                        catch (SQLException sQLException) {
                            if (n3 == 91 || n3 == 92 || n3 == 93) {
                                this.callstmt.setNull(n, n3 - 82);
                                continue;
                            }
                            throw new SQLException(sQLException.getMessage());
                        }
                    }
                    try {
                        switch (n3) {
                            case -7: {
                                this.callstmt.setBoolean(n, procParaInfo.getValue().equals("1") || procParaInfo.getValue().equalsIgnoreCase("true") || procParaInfo.getValue().equalsIgnoreCase("T"));
                                break;
                            }
                            case -6: {
                                this.callstmt.setByte(n, Byte.parseByte(procParaInfo.getValue()));
                                break;
                            }
                            case 5: {
                                this.callstmt.setShort(n, Short.parseShort(procParaInfo.getValue()));
                                break;
                            }
                            case 4: {
                                this.callstmt.setInt(n, Integer.parseInt(procParaInfo.getValue()));
                                break;
                            }
                            case -5: {
                                this.callstmt.setLong(n, Long.parseLong(procParaInfo.getValue()));
                                break;
                            }
                            case -1: 
                            case 1: 
                            case 12: {
                                this.callstmt.setString(n, procParaInfo.getValue());
                                break;
                            }
                            case 7: {
                                this.callstmt.setFloat(n, new Float(procParaInfo.getValue()).floatValue());
                                break;
                            }
                            case 6: 
                            case 8: {
                                this.callstmt.setDouble(n, (double)new Double(procParaInfo.getValue()));
                                break;
                            }
                            case 2: 
                            case 3: {
                                this.callstmt.setBigDecimal(n, new BigDecimal(procParaInfo.getValue()));
                                break;
                            }
                            case 91: {
                                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.dateTimeFormat.getDateFormat());
                                java.util.Date date = simpleDateFormat.parse(procParaInfo.getValue());
                                this.callstmt.setDate(n, new Date(date.getTime()));
                                break;
                            }
                            case 92: {
                                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.dateTimeFormat.getTimeFormat());
                                java.util.Date date = simpleDateFormat.parse(procParaInfo.getValue());
                                this.callstmt.setTime(n, new Time(date.getTime()));
                                break;
                            }
                            case 93: {
                                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.dateTimeFormat.getTimestampFormat());
                                java.util.Date date = simpleDateFormat.parse(procParaInfo.getValue());
                                this.callstmt.setTimestamp(n, new Timestamp(date.getTime()));
                                break;
                            }
                            case -4: 
                            case -3: 
                            case -2: {
                                this.callstmt.setBytes(n, procParaInfo.getValue().getBytes());
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (ParseException parseException) {
                    }
                    catch (DataTruncation dataTruncation) {
                        if (!append.isDebugEnabled()) break block32;
                        append.debug("SQLWarning\n" + dataTruncation.getMessage());
                    }
                }
            }
            if (!procParaInfo.isOUTParameter()) continue;
            switch (n3) {
                case -7: 
                case -6: 
                case -5: 
                case -4: 
                case -3: 
                case -2: 
                case -1: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 91: 
                case 92: 
                case 93: {
                    this.callstmt.registerOutParameter(n, n3);
                    continue block27;
                }
                case 2: 
                case 3: {
                    this.callstmt.registerOutParameter(n, n3, (int)procParaInfo.getScale());
                    continue block27;
                }
                default: {
                    this.callstmt.registerOutParameter(n, 1111);
                }
            }
        }
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public void close() throws SQLException {
        block3: {
            this.closeStmt();
            if (this.SEDU != null && this.SEDU.getConnection() != null) {
                try {
                    this.SEDU.disconnect();
                }
                catch (Throwable throwable) {
                    if (!append.isErrorEnabled()) break block3;
                    append.error("", throwable);
                }
            }
        }
    }

    protected void closeStmt() throws SQLException {
        if (this.rs != null) {
            block6: {
                try {
                    this.rs.close();
                }
                catch (SQLException sQLException) {
                    if (!append.isDebugEnabled()) break block6;
                    append.debug("Catched SQLException\n" + sQLException.getMessage());
                }
            }
            this.rs = null;
        }
        if (this.callstmt != null) {
            block7: {
                try {
                    this.callstmt.close();
                }
                catch (Exception exception) {
                    if (!append.isDebugEnabled()) break block7;
                    append.debug("Catched SQLException\n" + exception.getMessage());
                }
            }
            this.callstmt = null;
        }
    }

    public void setJdbcDriversConfig(JdbcDriversConfig jdbcDriversConfig) {
        this.add = jdbcDriversConfig;
    }

    public JdbcDriversConfig getjdbcDriversConfig() {
        return this.add;
    }

    public long getMaxDuration() {
        return this.bIsNull;
    }

    public void setMaxDuration(long l) {
        this.bIsNull = (int)l;
    }

    public int getMaxRows() {
        return this.cancel;
    }

    public void setMaxRows(long l) {
        this.cancel = (int)l;
    }

    public boolean isPushDowanDuration() {
        return this.close;
    }

    public boolean isPushDowanMaxRows() {
        return this.closeStmt;
    }

    public boolean cancel() {
        block6: {
            Connection connection = this.SEDU.getConnection();
            if (this.callstmt == null) {
                this.connect = true;
                return this.connect;
            }
            try {
                if (!DbQuery.isSupportCancel(connection, this.add)) break block6;
                try {
                    this.callstmt.cancel();
                    if (append.isDebugEnabled()) {
                        append.debug(this.getClass().getName() + " is canceled!");
                    }
                }
                catch (SQLException sQLException) {
                    append.debug("SQLException has occured when cancel query execute.\n" + sQLException.getMessage());
                }
                this.connect = true;
                return this.connect;
            }
            catch (SQLException sQLException) {
                append.debug("SQLException has occured when cancel query execute.\n" + sQLException.getMessage());
            }
        }
        return false;
    }
}

