/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbValue;

public class DbStringColumnBuffer
extends DbColumnBuffer {
    String[] buffer;
    private final int SEDU;
    boolean isutf8 = false;

    public String[] getBuffer() {
        return this.buffer;
    }

    public DbStringColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.buffer = new String[n];
        if (dbColDesc.getEncodingName().equals("UTF8")) {
            this.isutf8 = true;
        }
        this.SEDU = dbColDesc.getPrecision();
    }

    @Override
    public void updateCell(int n, DbValue dbValue) {
        this.buffer[n] = ((DbChar)dbValue).get();
        if (this.buffer[n] != null && this.buffer[n].length() > this.SEDU) {
            this.buffer[n] = this.buffer[n].substring(0, this.SEDU);
        }
    }

    @Override
    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbChar)dbValue).set(this.buffer[n]);
    }

    @Override
    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        int n = this.coldesc.getPrecision();
        for (int i = 0; i < this.buffer.length; ++i) {
            byte[] byArray;
            if (this.isNull(i)) {
                dataOutput.writeInt(0);
                for (int j = 0; j < this.SEDU; ++j) {
                    dataOutput.write(0);
                }
                continue;
            }
            if (this.buffer[i] == null) {
                this.buffer[i] = "";
            }
            try {
                byArray = this.isutf8 ? this.buffer[i].getBytes("UTF8") : this.buffer[i].getBytes();
            }
            catch (Exception exception) {
                byArray = new byte[]{};
            }
            if (byArray.length < n) {
                dataOutput.writeInt(byArray.length);
                dataOutput.write(byArray);
                int n2 = n - byArray.length;
                for (int j = 0; j < n2; ++j) {
                    dataOutput.write(0);
                }
                continue;
            }
            dataOutput.writeInt(n);
            dataOutput.write(byArray, 0, n);
        }
    }

    @Override
    protected void readValueFromFile(DataInput dataInput) throws IOException {
        int n = this.coldesc.getPrecision();
        int n2 = 0;
        byte[] byArray = new byte[n];
        for (int i = 0; i < this.buffer.length; ++i) {
            n2 = dataInput.readInt();
            dataInput.readFully(byArray);
            if (!this.isNull(i) && n2 != 0) {
                if (this.isutf8) {
                    this.buffer[i] = new String(byArray, 0, n2, "UTF8");
                    continue;
                }
                this.buffer[i] = new String(byArray, 0, n2);
                continue;
            }
            this.buffer[i] = "";
        }
    }

    @Override
    public void clearMem() {
        super.clearMem();
        this.buffer = null;
    }
}

