/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbColDesc;
import jet.connect.DbLongColumnBuffer;
import jet.connect.DbTimestamp;
import jet.connect.DbValue;

public class DbTimestampColumnBuffer
extends DbLongColumnBuffer {
    int[] nanos;

    public int[] getNanos() {
        return this.nanos;
    }

    public DbTimestampColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.nanos = new int[n];
    }

    @Override
    public void updateCell(int n, DbValue dbValue) {
        this.buffer[n] = ((DbTimestamp)dbValue).get();
        this.nanos[n] = ((DbTimestamp)dbValue).getNanos();
    }

    @Override
    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbTimestamp)dbValue).set(this.buffer[n]);
        ((DbTimestamp)dbValue).setNanos(this.nanos[n]);
    }

    @Override
    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        super.writeValueToFile(dataOutput);
        for (int i = 0; i < this.nanos.length; ++i) {
            dataOutput.writeInt(this.nanos[i]);
        }
    }

    @Override
    protected void readValueFromFile(DataInput dataInput) throws IOException {
        super.readValueFromFile(dataInput);
        for (int i = 0; i < this.nanos.length; ++i) {
            this.nanos[i] = dataInput.readInt();
        }
    }

    @Override
    public void clearMem() {
        super.clearMem();
        this.nanos = null;
    }
}

