/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.text.SimpleDateFormat;
import java.util.Hashtable;
import jet.JResource;
import jet.connect.DbColDesc;
import jet.connect.DbDate;
import jet.connect.DbDateTime;
import jet.connect.DbTimestamp;
import jet.connect.DbValue;
import jet.connect.FilterNode;
import jet.connect.Record;
import jet.connect.RecordValueComparer;
import toolkit.db.DbTools;

public class RecordFilter {
    public static String orFlag = "||";
    public static String andFlag = "&&";
    public static char dbFlag = (char)64;
    public static char quoteFlag = (char)34;
    private final int SEDU = 0;
    private final int Z = 1;
    String dateFormat = "yyyy-MM-dd";
    String timestampFormat = "yyyy-MM-dd HH:mm:ss.SSS";
    String timeForma = "HH:mm:ss";
    Record record;
    FilterNode root;
    StringBuffer condition;
    Hashtable conHash = new Hashtable();
    Hashtable dbDescHash;
    Hashtable paramHash;
    Hashtable specFieldHash;

    public RecordFilter(String string, Hashtable hashtable, String string2, String string3, String string4) {
        this.condition = new StringBuffer(string);
        this.dbDescHash = hashtable;
        this.setDataFormate(string2, string3, string4);
        this.root = this.makeConditionTree();
    }

    public RecordFilter(String string, Hashtable hashtable) {
        this.condition = new StringBuffer(string);
        this.dbDescHash = hashtable;
        this.setDataFormate("yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss.SSS", "HH:mm:ss");
        this.root = this.makeConditionTree();
    }

    public boolean compare(Record record) {
        this.record = record;
        return this.compareNode(this.root);
    }

    public boolean compareNode(FilterNode filterNode) {
        boolean bl;
        if (filterNode.bLeaf) {
            if (filterNode.conInfo.length() > 0) {
                RecordValueComparer recordValueComparer = (RecordValueComparer)this.conHash.get(new Integer(filterNode.iNo));
                recordValueComparer.setParameters(this.paramHash);
                recordValueComparer.setSpecFields(this.specFieldHash);
                bl = recordValueComparer.compare(this.record);
            } else {
                bl = true;
            }
        } else {
            bl = filterNode.operator == 0 ? this.compareNode(filterNode.left) || this.compareNode(filterNode.right) : this.compareNode(filterNode.left) && this.compareNode(filterNode.right);
        }
        return bl;
    }

    FilterNode makeConditionTree() {
        FilterNode filterNode = this.disposeNode(this.condition);
        return filterNode;
    }

    FilterNode disposeNode(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString().trim());
        FilterNode filterNode = new FilterNode(stringBuffer2.toString());
        int n = this.SEDU(stringBuffer2, 0);
        if (n < 0) {
            int n2 = this.SEDU(stringBuffer2, 1);
            if (n2 < 0) {
                filterNode.bLeaf = true;
                RecordValueComparer recordValueComparer = this.parseCondition(stringBuffer2);
                if (recordValueComparer != null) {
                    this.conHash.put(new Integer(filterNode.iNo), recordValueComparer);
                }
            } else {
                String string = stringBuffer2.substring(0, n2);
                String string2 = stringBuffer2.substring(n2 + andFlag.length());
                filterNode.bLeaf = false;
                filterNode.operator = 1;
                filterNode.left = this.disposeNode(new StringBuffer(string));
                filterNode.right = this.disposeNode(new StringBuffer(string2));
            }
        } else {
            String string = stringBuffer2.substring(0, n);
            String string3 = stringBuffer2.substring(n + orFlag.length());
            filterNode.bLeaf = false;
            filterNode.operator = 0;
            filterNode.left = this.disposeNode(new StringBuffer(string));
            filterNode.right = this.disposeNode(new StringBuffer(string3));
        }
        return filterNode;
    }

    private int SEDU(StringBuffer stringBuffer, int n) {
        int n2 = -1;
        int n3 = 0;
        int n4 = stringBuffer.length();
        boolean bl = false;
        for (int i = 0; i < n4; ++i) {
            char c = stringBuffer.charAt(i);
            if (c == '(') {
                if (i == 0) {
                    bl = true;
                }
                ++n3;
                continue;
            }
            if (c == ')') {
                if (--n3 != 0) continue;
                if (i < n4 - 1) {
                    bl = false;
                    continue;
                }
                if (!bl) continue;
                stringBuffer.deleteCharAt(0);
                stringBuffer.deleteCharAt(n4 - 2);
                return this.SEDU(stringBuffer, n);
            }
            if (n == 0) {
                if (i + orFlag.length() >= n4 || !stringBuffer.substring(i, i + orFlag.length()).equalsIgnoreCase(orFlag) || n3 != 0) continue;
                n2 = i;
                break;
            }
            if (n != 1 || i + andFlag.length() >= n4 || !stringBuffer.substring(i, i + andFlag.length()).equalsIgnoreCase(andFlag) || n3 != 0) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    public void setDataFormate(String string, String string2, String string3) {
        this.dateFormat = string;
        this.timestampFormat = string2;
        this.timeForma = string3;
    }

    public RecordValueComparer parseCondition(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        String string = null;
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            int n2 = 32;
            if (i + 1 < n) {
                n2 = stringBuffer.charAt(i + 1);
            }
            if (c == '<') {
                if (n2 == 61) {
                    string3 = "<=";
                    string2 = stringBuffer.substring(i + 2).trim();
                } else {
                    string3 = "<";
                    string2 = stringBuffer.substring(i + 1).trim();
                }
            } else if (c == '>') {
                if (n2 == 61) {
                    string3 = ">=";
                    string2 = stringBuffer.substring(i + 2).trim();
                } else {
                    string3 = ">";
                    string2 = stringBuffer.substring(i + 1).trim();
                }
            } else if (c == '=') {
                if (n2 == 61) {
                    string3 = "==";
                    string2 = stringBuffer.substring(i + 2).trim();
                }
            } else if (c == '!') {
                if (n2 == 61) {
                    string3 = "!=";
                    string2 = stringBuffer.substring(i + 2).trim();
                }
            } else if (!(c != 'I' && c != 'i' || n2 != 78 && n2 != 110)) {
                string3 = "IN";
                string2 = stringBuffer.substring(i + 2).trim();
            }
            if (string3 == null) continue;
            string = stringBuffer.substring(0, i).trim();
            break;
        }
        if (string3 != null) {
            String string4 = null;
            DbColDesc dbColDesc = null;
            DbColDesc dbColDesc2 = null;
            string4 = this.getFieldName(string);
            if (string4 != null) {
                dbColDesc = (DbColDesc)this.dbDescHash.get(string4);
                string = string4.toUpperCase();
            }
            if ((string4 = this.getFieldName(string2)) != null) {
                dbColDesc2 = (DbColDesc)this.dbDescHash.get(string4);
                string2 = string4.toUpperCase();
            }
            RecordValueComparer recordValueComparer = new RecordValueComparer();
            recordValueComparer.opLeft = string;
            recordValueComparer.opRight = string2;
            recordValueComparer.operator = RecordValueComparer.getOperatorForName(string3);
            if (dbColDesc != null) {
                if (dbColDesc2 == null) {
                    recordValueComparer.valRight = this.setDBValue(DbValue.makeDbValue(dbColDesc), string2);
                }
            } else if (dbColDesc2 != null) {
                recordValueComparer.valLeft = this.setDBValue(DbValue.makeDbValue(dbColDesc2), string);
            } else {
                DbColDesc dbColDesc3 = null;
                if (string.startsWith("'") || string.startsWith("\"") || DbTools.isSpecialField(string) != -1) {
                    if (string2.startsWith("'") || string2.startsWith("\"") || DbTools.isSpecialField(string2) != -1) {
                        dbColDesc3 = new DbColDesc(null, 12, 255, 0, 2);
                        recordValueComparer.valLeft = this.setDBValue(DbValue.makeDbValue(dbColDesc3), string);
                        recordValueComparer.valRight = this.setDBValue(DbValue.makeDbValue(dbColDesc3), string2);
                    }
                } else {
                    dbColDesc3 = new DbColDesc(null, 3, 30, 2, 2);
                    recordValueComparer.valLeft = this.setDBValue(DbValue.makeDbValue(dbColDesc3), string);
                    recordValueComparer.valRight = this.setDBValue(DbValue.makeDbValue(dbColDesc3), string2);
                }
            }
            if (recordValueComparer.valLeft == null) {
                recordValueComparer.bLeftIsCol = true;
            }
            if (recordValueComparer.valRight == null) {
                recordValueComparer.bRightIsCol = true;
            }
            return recordValueComparer;
        }
        return null;
    }

    public DbValue setDBValue(DbValue dbValue, String string) {
        String string2 = string;
        if (string2.startsWith("'") || string2.startsWith("\"")) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        if (dbValue instanceof DbDateTime) {
            String string3 = dbValue instanceof DbDate ? this.dateFormat : (dbValue instanceof DbTimestamp ? this.timestampFormat : this.timeForma);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
            try {
                ((DbDateTime)dbValue).set(simpleDateFormat.parse(string2).getTime());
            }
            catch (Exception exception) {
                throw new Error(JResource.getMessage("setDBValue", (Object)string));
            }
        } else {
            dbValue.setValue(string2);
        }
        return dbValue;
    }

    public String getFieldName(String string) {
        String string2 = null;
        int n = string.length();
        if (n > 0 && string.charAt(0) == dbFlag && n > 1) {
            if (string.charAt(1) == quoteFlag) {
                if (n > 2 && string.charAt(n - 1) == quoteFlag) {
                    string2 = string.substring(2, n - 1);
                }
            } else {
                string2 = string.substring(1);
            }
        }
        return string2;
    }

    public void setParameters(Hashtable hashtable) {
        this.paramHash = hashtable;
    }

    public void setSpecFields(Hashtable hashtable) {
        this.specFieldHash = hashtable;
    }
}

