/*
 * Decompiled with CFR 0.152.
 */
package jet.controls;

import com.jinfonet.util.JRLog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import jet.controls.BytedProperty;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.convert.CustomerPropInfo;

public class JetCustomerProperty
extends JetProperty
implements BytedProperty,
CustomerPropInfo {
    String editor;

    public JetCustomerProperty() {
    }

    public JetCustomerProperty(JetObject jetObject, String string) {
        super(jetObject, string);
    }

    @Override
    public void set(String string) {
        this.value = string;
    }

    @Override
    public String get() {
        return this.value == null ? "" : this.value.toString();
    }

    @Override
    public String toString() {
        return this.get();
    }

    @Override
    public int[] getMatchingSqlType() {
        return new int[]{1111};
    }

    @Override
    public final boolean isEnableAutoValue() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeUTF(this.editor);
            boolean bl = this.value == null;
            objectOutputStream.writeBoolean(bl);
            if (!bl) {
                objectOutputStream.writeObject(this.value);
            }
            objectOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6200000, (Throwable)iOException);
            }
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    objectOutputStream = null;
                }
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    byteArrayOutputStream = null;
                }
            }
        }
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setByteArray(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            this.editor = objectInputStream.readUTF();
            boolean bl = objectInputStream.readBoolean();
            if (!bl) {
                this.value = objectInputStream.readObject();
            }
            objectInputStream.close();
            objectInputStream = null;
            byteArrayInputStream.close();
            byteArrayInputStream = null;
        }
        catch (Exception exception) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6200000, (Throwable)exception);
            }
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    objectInputStream = null;
                }
            }
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    byteArrayInputStream = null;
                }
            }
        }
    }

    public void setValue(Object object) {
        this.value = object;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    public PropertyEditor getEditor() {
        try {
            return (PropertyEditor)Class.forName(this.editor).newInstance();
        }
        catch (Exception exception) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6200000, (Throwable)exception);
            }
            return null;
        }
    }

    public void setEditor(String string) {
        String string2 = this.editor;
        this.editor = string;
        this.propertyChanged(new PropertyChangeEvent(this, this.name, string2, this.editor));
    }
}

