/*
 * Decompiled with CFR 0.152.
 */
package jet.controls;

import com.jinfonet.util.JRLog;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.convert.EnumerationInfo;
import jet.naming.EnumerationConstant;

public class JetEnumeration
extends JetProperty
implements EnumerationInfo {
    protected int enumType = -1;
    protected Hashtable enumeration = null;

    public JetEnumeration() {
        this.canChangeByOther = false;
        this.canChangeByBL = false;
        this.enumeration = new Hashtable();
    }

    public JetEnumeration(JetObject jetObject, String string) {
        this(jetObject, string, -1);
    }

    public JetEnumeration(JetObject jetObject, String string, int n) {
        super(jetObject, string);
        this.editorType = COMBO_EDITOR;
        this.canChangeByOther = false;
        this.canChangeByBL = false;
        this.enumType = n;
        if (n == -1) {
            this.enumeration = new Hashtable();
        }
    }

    public Object add(String string, Object object) {
        this.enumTypeToHash();
        return this.enumeration.put(string, object);
    }

    public Object remove(String string) {
        this.enumTypeToHash();
        return this.enumeration.remove(string);
    }

    protected synchronized void enumTypeToHash() {
        if (this.enumType == -1) {
            return;
        }
        if (this.enumeration == null) {
            this.enumeration = new Hashtable();
        }
        this.enumeration.clear();
        String[] stringArray = EnumerationConstant.ENUMTYPE_KEYS[this.enumType];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == EnumerationConstant.BLANK_SEPARATOR || stringArray[i].equals(EnumerationConstant.BLANK_SEPARATOR)) continue;
            this.enumeration.put(stringArray[i], i);
        }
        this.enumType = -1;
    }

    public void set(Object object) {
        this.setValue(object);
    }

    @Override
    public void set(String string) {
        this.setValue(string);
    }

    public void setValue(Object object) {
        if (object instanceof Integer) {
            if (this.enumType != -1) {
                String[] stringArray = EnumerationConstant.ENUMTYPE_KEYS[this.enumType];
                if ((Integer)object < stringArray.length && (Integer)object >= 0) {
                    this.BLANK_SEPARATOR(object);
                } else {
                    String string = this.name;
                    String string2 = "<UNKOWN2>";
                    if (this.name == null || this.name.length() == 0) {
                        string = "<UNKOWN2>";
                    }
                    if (this.parent != null) {
                        string2 = this.parent.getClass().getName();
                    }
                    if (JRLog.isError(2)) {
                        JRLog.error(2, 2200012, new Object[]{object, string, string2}, null);
                    }
                }
            } else {
                this.BLANK_SEPARATOR(object);
            }
        } else {
            this.BLANK_SEPARATOR(object);
        }
    }

    private void BLANK_SEPARATOR(Object object) {
        Object object2 = this.value;
        this.value = object;
        this.isnull = false;
        this.isAutoValue = false;
        this.propertyChanged(new PropertyChangeEvent(this, this.name, object2, this.value));
        this.propertyChanged();
    }

    public void setValue(String string) {
        Object object;
        if (string == null) {
            return;
        }
        Integer n = null;
        if (this.enumType != -1) {
            object = EnumerationConstant.ENUMTYPE_KEYS[this.enumType];
            n = null;
            for (int i = 0; i < ((String[])object).length; ++i) {
                if (object[i] == EnumerationConstant.BLANK_SEPARATOR || object[i].equals(EnumerationConstant.BLANK_SEPARATOR) || !object[i].equals(string)) continue;
                n = i;
                break;
            }
        } else {
            n = (Integer)this.enumeration.get(string);
        }
        if (n != null) {
            this.BLANK_SEPARATOR(n);
        } else {
            object = this.name;
            String string2 = "<UNKOWN>";
            if (this.name == null || this.name.length() == 0) {
                object = "<UNKOWN>";
            }
            if (this.parent != null) {
                string2 = this.parent.getClass().getName();
            }
            if (JRLog.isError(2)) {
                JRLog.error(2, 2200012, new Object[]{string, object, string2}, null);
            }
        }
    }

    public Object get() {
        return this.isnull ? this.defval : this.value;
    }

    @Override
    public String getCurKey() {
        Object object = this.get();
        if (this.enumType != -1) {
            String[] stringArray = EnumerationConstant.ENUMTYPE_KEYS[this.enumType];
            if (object != null) {
                String string = stringArray[(Integer)object];
                if (string != EnumerationConstant.BLANK_SEPARATOR && !string.equals(EnumerationConstant.BLANK_SEPARATOR)) {
                    return string;
                }
                return "";
            }
        } else if (object != null) {
            Enumeration enumeration = this.enumeration.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!this.enumeration.get(string).equals(object)) continue;
                return string;
            }
        }
        return "";
    }

    @Override
    public String toString() {
        String string;
        block3: {
            Object object;
            block2: {
                string = "";
                object = this.get();
                if (object == null) {
                    return string;
                }
                if (this.enumType == -1) break block2;
                String[] stringArray = EnumerationConstant.ENUMTYPE_KEYS[this.enumType];
                string = stringArray[(Integer)object];
                if (string != EnumerationConstant.BLANK_SEPARATOR && !string.equals(EnumerationConstant.BLANK_SEPARATOR)) break block3;
                string = "";
                break block3;
            }
            Enumeration enumeration = this.enumeration.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                if (!object.equals(this.enumeration.get(k))) continue;
                string = k.toString();
                break;
            }
        }
        return string;
    }

    @Override
    public int intValue() {
        Object object = this.get();
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return -1;
    }

    public void removeAll() {
        if (this.enumType != -1) {
            this.enumeration = new Hashtable(0);
            this.enumType = -1;
        } else {
            this.enumeration.clear();
        }
    }

    @Override
    public int getValue(Object object) {
        if (this.enumType != -1) {
            String[] stringArray = EnumerationConstant.ENUMTYPE_KEYS[this.enumType];
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == EnumerationConstant.BLANK_SEPARATOR || stringArray[i].equals(EnumerationConstant.BLANK_SEPARATOR) || !stringArray[i].equals(object)) continue;
                return i;
            }
            throw new NullPointerException();
        }
        return (Integer)this.enumeration.get(object);
    }

    public String getKeyByValue(int n) {
        if (this.enumType != -1) {
            String[] stringArray = EnumerationConstant.ENUMTYPE_KEYS[this.enumType];
            if (n < 0 || n >= stringArray.length || stringArray[n] == EnumerationConstant.BLANK_SEPARATOR || stringArray[n].equals(EnumerationConstant.BLANK_SEPARATOR)) {
                return null;
            }
            return stringArray[n];
        }
        Enumeration enumeration = this.enumeration.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Integer n2 = (Integer)this.enumeration.get(string);
            if (n2 != n) continue;
            return string;
        }
        return null;
    }

    @Override
    public Vector getPropertyChoice() {
        if (this.enumType != -1) {
            String[] stringArray = EnumerationConstant.ENUMTYPE_KEYS[this.enumType];
            Vector<String> vector = new Vector<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == EnumerationConstant.BLANK_SEPARATOR || stringArray[i].equals(EnumerationConstant.BLANK_SEPARATOR)) continue;
                vector.add(stringArray[i]);
            }
            return vector;
        }
        int n = 0;
        Vector vector = new Vector(this.enumeration.size());
        Vector<Integer> vector2 = new Vector<Integer>(this.enumeration.size());
        Enumeration enumeration = this.enumeration.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = this.enumeration.get(k);
            if (v instanceof Integer) {
                int n2;
                Integer n3 = (Integer)v;
                for (n2 = n; n2 > 0 && n3 < (Integer)vector2.elementAt(n2 - 1); --n2) {
                }
                if (n2 == n) {
                    vector.addElement(k);
                    vector2.addElement(n3);
                } else {
                    vector.insertElementAt(k, n2);
                    vector2.insertElementAt(n3, n2);
                }
                ++n;
                continue;
            }
            vector.addElement(k);
        }
        return vector;
    }

    @Override
    public Object getObject() {
        Enumeration enumeration;
        Object object = super.getObject();
        if (this.enumType == -1 && object == null && (enumeration = this.enumeration.keys()).hasMoreElements()) {
            object = this.enumeration.get(enumeration.nextElement());
        }
        return object;
    }

    public Hashtable getEnumerationSet() {
        if (this.enumType != -1) {
            String[] stringArray = EnumerationConstant.ENUMTYPE_KEYS[this.enumType];
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == EnumerationConstant.BLANK_SEPARATOR || stringArray[i].equals(EnumerationConstant.BLANK_SEPARATOR)) continue;
                hashtable.put(stringArray[i], i);
            }
            return hashtable;
        }
        return this.enumeration;
    }

    public void setEnumerationSet(Hashtable hashtable) {
        if (this.enumType != -1) {
            this.enumType = -1;
        }
        this.enumeration = hashtable;
    }

    public int getEnumerationType() {
        return this.enumType;
    }

    @Override
    public int[] getMatchingSqlType() {
        return new int[]{12, 1111};
    }
}

