/*
 * Decompiled with CFR 0.152.
 */
package jet.controls;

import java.awt.Image;
import java.io.IOException;
import javax.swing.ImageIcon;
import jet.controls.JetObject;
import jet.controls.JetResourceable;
import jet.controls.JetString;
import jet.convert.ImgInfo;
import jet.util.ImagePropertiable;
import jet.util.image.ImageProvider;
import jet.util.image.ImageProviderFactory;
import jet.util.image.ImageResource;
import jet.util.image.ImageResourceUtil;
import org.apache.commons.codec.binary.Base64;

public class JetImgProperty
extends JetString
implements JetResourceable,
ImagePropertiable,
ImgInfo {
    private static final String BLANK_IMAGERES = "EMBED\u0007";
    private ImageResource SEDU = ImageResource.BLANK_IMAGERES;
    private boolean append = false;
    int id = -1;

    public JetImgProperty() {
    }

    public JetImgProperty(JetObject jetObject, String string) {
        super(jetObject, string);
        this.value = "";
    }

    @Override
    public void set(String string) {
        super.set(string);
    }

    public void setEmbedImage(ImageResource imageResource) {
        this.append = true;
        this.SEDU = imageResource == null || imageResource == ImageResource.BLANK_IMAGERES ? ImageResource.BLANK_IMAGERES : new ImageResource(imageResource.getImage(), imageResource.getImageType());
        this.isAutoValue = false;
    }

    public void clearEmbed() {
        this.append = false;
        this.SEDU = ImageResource.BLANK_IMAGERES;
        this.isAutoValue = false;
    }

    @Override
    public boolean isEmbed() {
        return this.append;
    }

    @Override
    public String getInspValue() {
        return super.get();
    }

    @Override
    public String toString() {
        if (this.append) {
            byte[] byArray = ImageResourceUtil.imageToByte(this.SEDU.getImage(), this.SEDU.getImageType());
            return super.get() + BLANK_IMAGERES + new String(Base64.encodeBase64((byte[])byArray));
        }
        return super.toString();
    }

    @Override
    void setValue(String string) {
        if (string != null && string.indexOf(BLANK_IMAGERES) >= 0) {
            int n = string.indexOf(BLANK_IMAGERES);
            super.setValue(string.substring(0, n));
            string = string.substring(n + BLANK_IMAGERES.length());
            byte[] byArray = Base64.decodeBase64((byte[])string.getBytes());
            try {
                this.SEDU = ImageResourceUtil.loadImageResourceFromBytes(byArray);
            }
            catch (IOException iOException) {
                this.SEDU = ImageResource.BLANK_IMAGERES;
            }
            this.append = true;
        } else {
            super.setValue(string);
            this.append = false;
        }
        this.isAutoValue = false;
    }

    @Override
    public void setObject(Object object) {
        if (object instanceof Image) {
            this.append = true;
            this.SEDU = new ImageResource((Image)object, -100);
        } else if (object instanceof ImageResource) {
            this.append = true;
            this.SEDU = (ImageResource)object;
        } else {
            super.setObject(object);
        }
        this.isAutoValue = false;
    }

    @Override
    public ImageResource getImageResourceByID(String string) {
        ImageProvider imageProvider = ImageProviderFactory.createRegisteredImageProvider(string);
        return imageProvider.getImageResource(this);
    }

    @Override
    public ImageResource getEmbedImageResource() {
        if (this.append) {
            return this.SEDU;
        }
        return null;
    }

    @Override
    public int getResourceID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setResourceID(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getLocalPath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLocalPath(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getURL() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setURL(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getResource(String string) {
        if (this.append) {
            return this.SEDU;
        }
        return null;
    }

    @Override
    public Object getResource() {
        if (this.append) {
            return this.SEDU;
        }
        return null;
    }

    @Override
    public byte[] getGifBytes() throws IOException {
        if (this.append) {
            return ImageResourceUtil.imageToByte(this.SEDU.getImage(), 4);
        }
        return null;
    }

    @Override
    public Object getObject() {
        if (this.append) {
            return this.SEDU;
        }
        return super.getObject();
    }

    public ImageIcon getImageIcon(String string) throws IOException {
        if (this.append && this.SEDU.getImage() != null) {
            return new ImageIcon(this.SEDU.getImage());
        }
        return null;
    }

    public int getImageType() {
        return this.SEDU.getImageType();
    }
}

