/*
 * Decompiled with CFR 0.152.
 */
package jet.controls;

import java.beans.PropertyChangeEvent;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.util.JStringToolKit;

public class JetReferences
extends JetProperty {
    String referName;
    int length;

    public JetReferences() {
        this.value = new JetObject[4];
    }

    public JetReferences(JetObject jetObject, String string) {
        super(jetObject, string);
        this.value = new JetObject[4];
    }

    @Override
    public void set(String string) {
        this.SEDU(string);
    }

    public void set(String[] stringArray) {
        if (stringArray != null && stringArray.length != 0) {
            this.clear();
            int n = stringArray.length;
            while (--n >= 0) {
                this.Z(this.parent.nameToObject(stringArray[n]));
            }
        } else {
            this.clear();
        }
    }

    public void set(JetObject jetObject) {
        this.Z(jetObject);
    }

    public void setReference() {
        if (this.referName != null && this.getParent().isAfterInit()) {
            this.SEDU(this.referName);
            this.referName = null;
        }
    }

    private void SEDU(String string) {
        if (string != null) {
            if (this.getParent().isAfterInit()) {
                this.clear();
                if (string.length() == 0) {
                    return;
                }
                String[] stringArray = JStringToolKit.splitString(string, "\u0007");
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null) continue;
                    this.Z(this.parent.nameToObject(stringArray[i]));
                }
                this.isnull = false;
            } else {
                this.referName = string;
            }
        } else {
            this.clear();
            this.isnull = true;
        }
    }

    public JetObject[] get() {
        JetObject[] jetObjectArray = new JetObject[this.length];
        System.arraycopy(this.value, 0, jetObjectArray, 0, this.length);
        return jetObjectArray;
    }

    public String[] getRefNames() {
        JetObject[] jetObjectArray = this.get();
        if (jetObjectArray == null) {
            return null;
        }
        String[] stringArray = new String[jetObjectArray.length];
        int n = jetObjectArray.length;
        while (--n >= 0) {
            stringArray[n] = jetObjectArray[n].getInstName();
        }
        return stringArray;
    }

    public String getRefName(int n) {
        if (n >= 0 && n < this.length) {
            JetObject jetObject = this.getObject(n);
            return jetObject == null ? null : jetObject.getInstName();
        }
        return null;
    }

    private void Z(JetObject jetObject) {
        if (jetObject != null && !this.isIn(jetObject)) {
            JetObject[] jetObjectArray = (JetObject[])((JetObject[])this.value).clone();
            jetObject.addReferencer(this.parent);
            this.add(jetObject);
            this.propertyChanged(new PropertyChangeEvent(this, this.name, jetObjectArray, this.value));
            this.propertyChanged();
        }
    }

    public void removeReference(JetObject jetObject) {
        if (jetObject != null && this.isIn(jetObject)) {
            jetObject.removeReferencer(this.parent);
            this.remove(jetObject);
        }
    }

    @Override
    public String toString() {
        String string = "";
        JetObject[] jetObjectArray = this.get();
        if (jetObjectArray == null) {
            return string;
        }
        for (int i = 0; i < this.length; ++i) {
            string = string + jetObjectArray[i].getInstName();
            if (i == this.length - 1) continue;
            string = string + "\u0007";
        }
        return string;
    }

    @Override
    public final boolean isChangeByOther() {
        return false;
    }

    @Override
    public final boolean isEnableAutoValue() {
        return false;
    }

    public JetObject getObject(String string) {
        return this.getObject(this.indexOf(string));
    }

    public JetObject getObject(int n) {
        JetObject[] jetObjectArray = (JetObject[])this.value;
        if (jetObjectArray == null) {
            return null;
        }
        if (n >= 0 && n < jetObjectArray.length) {
            return jetObjectArray[n];
        }
        return null;
    }

    public boolean isIn(String string) {
        return this.isIn(this.parent.nameToObject(string));
    }

    public boolean isIn(JetObject jetObject) {
        JetObject[] jetObjectArray = (JetObject[])this.value;
        if (jetObjectArray == null) {
            return false;
        }
        int n = this.length;
        while (--n >= 0) {
            if (jetObjectArray[n] != jetObject) continue;
            return true;
        }
        return false;
    }

    private void add(JetObject jetObject) {
        this.addReferencer(jetObject, this.length);
    }

    private boolean addReferencer(JetObject jetObject, int n) {
        if (n >= 0 && n <= this.length) {
            JetObject[] jetObjectArray = (JetObject[])this.value;
            if (jetObjectArray == null) {
                jetObjectArray = new JetObject[4];
            }
            if (jetObjectArray.length == this.length) {
                JetObject[] jetObjectArray2 = new JetObject[this.length + this.length];
                System.arraycopy(jetObjectArray, 0, jetObjectArray2, 0, this.length);
                jetObjectArray = jetObjectArray2;
            }
            if (n == this.length) {
                jetObjectArray[this.length++] = jetObject;
            } else {
                System.arraycopy(jetObjectArray, n, jetObjectArray, n + 1, this.length - n);
                jetObjectArray[n] = jetObject;
                ++this.length;
            }
            this.value = jetObjectArray;
            return true;
        }
        return false;
    }

    private void remove(JetObject jetObject) {
        this.remove(this.indexOf(jetObject));
    }

    private void remove(int n) {
        if (n >= 0 && n < this.length) {
            JetObject[] jetObjectArray = (JetObject[])this.value;
            if (n < this.length - 1) {
                System.arraycopy(jetObjectArray, n + 1, jetObjectArray, n, this.length - n - 1);
            }
            --this.length;
            if (this.length < jetObjectArray.length / 2) {
                JetObject[] jetObjectArray2 = new JetObject[this.length + 1];
                System.arraycopy(jetObjectArray, 0, jetObjectArray2, 0, this.length);
                jetObjectArray = jetObjectArray2;
            }
            this.value = jetObjectArray;
        }
    }

    private void clear() {
        JetObject[] jetObjectArray = (JetObject[])this.value;
        for (int i = 0; i < jetObjectArray.length; ++i) {
            if (jetObjectArray[i] == null) continue;
            jetObjectArray[i].removeReferencer(this.parent);
        }
        this.value = new JetObject[4];
        this.length = 0;
    }

    public int indexOf(JetObject jetObject) {
        JetObject[] jetObjectArray = this.get();
        if (jetObjectArray == null) {
            return -1;
        }
        int n = this.length;
        while (--n >= 0) {
            if (jetObjectArray[n] != jetObject) continue;
            return n;
        }
        return -1;
    }

    public int indexOf(String string) {
        JetObject[] jetObjectArray = (JetObject[])this.value;
        int n = this.length;
        while (--n >= 0) {
            if (!jetObjectArray[n].getInstName().equals(string)) continue;
            return n;
        }
        return -1;
    }

    public int getLength() {
        return this.length;
    }
}

