/*
 * Decompiled with CFR 0.152.
 */
package jet.controls;

import guitools.toolkit.Unit;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import jet.controls.JetChangeBy;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.convert.UnitNumberInfo;

public class JetUnitNumber
extends JetNumber
implements UnitNumberInfo {
    public static int convertToPixel(String string, int n) {
        double d;
        try {
            d = new DecimalFormat().parse(string, new ParsePosition(0)).doubleValue();
        }
        catch (NullPointerException nullPointerException) {
            throw new NumberFormatException(string);
        }
        return n == 0 ? Unit.convertInchToPixel(d) : Unit.convertCentimeterToPixel(d);
    }

    public static String get(int n, int n2, int n3) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(n3);
        return decimalFormat.format(n2 == 0 ? Unit.convertPixelToInch(n) : Unit.convertPixelToCentimeter(n));
    }

    public static int convertToUnit(String string, int n) {
        double d;
        try {
            d = new DecimalFormat().parse(string, new ParsePosition(0)).doubleValue();
        }
        catch (NullPointerException nullPointerException) {
            throw new NumberFormatException(string);
        }
        return n == 0 ? Unit.convertInchToUnit(d) : Unit.convertCentimeterToUnit(d);
    }

    public static String getUnit(int n, int n2, int n3) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(n3);
        return decimalFormat.format(n2 == 0 ? Unit.convertUnitToInch(n) : Unit.convertUnitToCentimeter(n));
    }

    public JetUnitNumber() {
        this.setCanChangeByOthers(false);
    }

    public JetUnitNumber(JetObject jetObject, String string) {
        super(jetObject, string);
        this.setCanChangeByOthers(false);
    }

    public JetUnitNumber(JetObject jetObject, String string, int n) {
        super(jetObject, string, n);
        this.setCanChangeByOthers(false);
    }

    @Override
    public void set(int n) {
        super.set(Unit.convertPixelToUnit(n));
    }

    @Override
    public void set(long l) {
        super.set(Unit.convertPixelToUnit(l));
    }

    @Override
    public void set(float f) {
        super.set(Unit.convertPixelToUnit(f));
    }

    @Override
    public void set(double d) {
        super.set(Unit.convertPixelToUnit(d));
    }

    @Override
    public void set(String string) {
        super.set(Unit.convertPixelToUnit(Integer.parseInt(string)));
    }

    @Override
    public void setInt(int n) {
        super.setInt(n);
    }

    @Override
    public void setUnitValue(String string) {
        super.set(string);
    }

    public void setUnitValue(int n) {
        super.set(n);
    }

    @Override
    public int intValue() {
        return Unit.convertUnitToPixel(super.intValue());
    }

    @Override
    public long longValue() {
        return Unit.convertUnitToPixel(super.longValue());
    }

    @Override
    public float floatValue() {
        return Unit.convertUnitToPixel(super.floatValue());
    }

    @Override
    public double doubleValue() {
        return Unit.convertUnitToPixel(super.doubleValue());
    }

    @Override
    public int get() {
        return Unit.convertUnitToPixel(super.get());
    }

    @Override
    public int getUnit() {
        return super.get();
    }

    @Override
    public String getInspValue(int n, int n2) {
        int n3 = super.get();
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(n2);
        return decimalFormat.format(n == 0 ? Unit.convertUnitToInch(n3) : Unit.convertUnitToCentimeter(n3));
    }

    @Override
    public String getInspValue() {
        return this.toString();
    }

    @Override
    public String toInchString() {
        return Double.toString(Unit.convertUnitToInch(super.get()));
    }

    @Override
    public String toCentimeterString() {
        return Double.toString(Unit.convertUnitToCentimeter(super.get()));
    }

    @Override
    public String toUnitString() {
        return super.toString();
    }

    @Override
    public String toString() {
        return Integer.toString(this.get());
    }

    @Override
    public void setCanChangeByOthers(boolean bl) {
        super.setCanChangeByOthers(bl);
        this.byOther = bl ? new JetChangeBy(this.parent, this.name + "_by", this) : null;
    }

    @Override
    public Object getObject() {
        Object object = super.getObject();
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return object;
    }
}

