/*
 * Decompiled with CFR 0.152.
 */
package jet.crosstab;

import com.jinfonet.util.JRLog;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetVector;
import jet.crosstab.CTBlock;
import jet.crosstab.CTCrossTabDef;
import jet.crosstab.JCrossTabCreater;
import jet.crosstab.layout.CTBlockBuilder;
import jet.crosstab.layout.CTBlockManager;
import jet.crosstab.layout.CTCCUtil;
import jet.crosstab.layout.CTSpaceManager;
import jet.crosstab.layout.CTSplitManager;
import jet.crosstab.layout.CTTemplateObjects;
import jet.crosstab.layout.CrosstabVariables;
import jet.crosstab.layout.util.CTRuntimeTools;
import jet.dataengine.api.DSException;
import jet.dataengine.api.crosstabdata.CrosstabDataResult;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.DSCrossTab;
import jet.report.JetRptCTCrossTab;
import jet.rptengine.componentLayoutInfo.CrosstabLayoutInfo;
import jet.rptengine.creator.ExecuteEnv;
import jet.util.JRInterruptedException;

public class CrosstabLayoutEngine {
    private CTSpaceManager SEDU = null;
    private CrosstabVariables adjustWH = null;
    private CTBlockManager blockSplit = null;
    private CTBlockBuilder buildBlocks = null;
    private CTSplitManager currentColBlockIndex = null;
    private CTCCUtil currentRowBlockIndex = new CTCCUtil();
    private CrosstabDataResult error = null;
    private CTTemplateObjects get = null;
    private boolean getBlock = false;
    private boolean getBooleanPropertyByName = false;
    private CrosstabLayoutInfo getCTFMapDisplayNameWithRuntimeColName = null;

    public CrosstabLayoutEngine() {
    }

    public CrosstabLayoutEngine(ExecuteEnv executeEnv, CrosstabDataResult crosstabDataResult, CTCrossTabDef cTCrossTabDef, JRecord jRecord) {
        this.error = crosstabDataResult;
    }

    public void init(ExecuteEnv executeEnv, JCrossTabCreater jCrossTabCreater, JRecord jRecord) {
        this.adjustWH.setEnv(executeEnv);
        this.adjustWH.setRptCrosstab(jCrossTabCreater.getRptCrossTab());
        this.adjustWH.setLayoutInfo(this.getCTFMapDisplayNameWithRuntimeColName);
        this.SEDU();
        this.get = new CTTemplateObjects(jCrossTabCreater, this.SEDU, this.currentRowBlockIndex);
        this.get.setCtCrossTabDef(jCrossTabCreater);
        this.get.parseTemplate();
        this.currentRowBlockIndex.setRecord(jRecord);
        if (this.get.hasDimensionColorSetting()) {
            this.adjustWH.setDimensionColorSetting(this.get.getDimensionColorSetting());
        }
        CTRuntimeTools.setResolution(executeEnv.getResolution());
    }

    private void SEDU() {
        boolean bl;
        JetRptCTCrossTab jetRptCTCrossTab = this.adjustWH.getRptCrosstab();
        int n = this.currentRowBlockIndex.getIntPropertyByName("position", jetRptCTCrossTab);
        if (n == 2) {
            this.adjustWH.setBlockGap(CTRuntimeTools.adjustWH(this.currentRowBlockIndex.getIntPropertyByName("BlockGap", jetRptCTCrossTab)));
        }
        this.adjustWH.setRepeatColumnHeader(this.currentRowBlockIndex.getBooleanPropertyByName("RepeatRowHeader", jetRptCTCrossTab));
        this.adjustWH.setAvoidOrphanHeader(this.currentRowBlockIndex.getBooleanPropertyByName("AvoidOrphanHeader", jetRptCTCrossTab));
        this.adjustWH.setVerticalLayout(this.currentRowBlockIndex.getBooleanPropertyByName("VerticalLayout", jetRptCTCrossTab));
        this.adjustWH.setSuppressColumnHeader(this.currentRowBlockIndex.getBooleanPropertyByName("SuppressColumnHeader", jetRptCTCrossTab));
        this.adjustWH.setSuppressRowHeader(this.currentRowBlockIndex.getBooleanPropertyByName("SuppressRowHeader", jetRptCTCrossTab));
        this.adjustWH.setUseTableStyle(this.currentRowBlockIndex.getBooleanPropertyByName("isTableStyle", jetRptCTCrossTab));
        this.adjustWH.setOutsideAggregateTitle(this.currentRowBlockIndex.getBooleanPropertyByName("isOutSideAggTitle", jetRptCTCrossTab));
        this.adjustWH.setHorizontalGap(CTRuntimeTools.adjustWH(this.currentRowBlockIndex.getIntPropertyByName("HorizontalGap", jetRptCTCrossTab)));
        this.adjustWH.setVerticalGap(CTRuntimeTools.adjustWH(this.currentRowBlockIndex.getIntPropertyByName("VerticalGap", jetRptCTCrossTab)));
        this.adjustWH.setColumnTotalOnLeft(this.currentRowBlockIndex.getBooleanPropertyByName("ColumnTotalOnLeft", jetRptCTCrossTab));
        this.adjustWH.setRowTotalOnTop(this.currentRowBlockIndex.getBooleanPropertyByName("RowTotalOnTop", jetRptCTCrossTab));
        this.adjustWH.setRepeatAggregate(this.currentRowBlockIndex.getBooleanPropertyByName("repeatAgg", jetRptCTCrossTab));
        boolean bl2 = bl = (JetBoolean)jetRptCTCrossTab.getPropertyByName("EnableAlternativeLineColor") == null ? false : ((JetBoolean)jetRptCTCrossTab.getPropertyByName("EnableAlternativeLineColor")).get();
        if (bl) {
            this.adjustWH.setEnableAlternativeLineColor(true);
            int n2 = ((JetNumber)jetRptCTCrossTab.getPropertyByName("AlternativeLineColorDirection")).get();
            Vector vector = ((JetVector)jetRptCTCrossTab.getPropertyByName("AlternativeLineColorPatternList")).get();
            this.adjustWH.setLineColorDirection(n2);
            this.adjustWH.setLineColorList(vector);
        }
        if (this.getBooleanPropertyByName) {
            this.adjustWH.setRowPerBlock(jetRptCTCrossTab.itemsPerRowBlock.get());
            this.adjustWH.setColPerBlock(jetRptCTCrossTab.itemsPerColBlock.get());
            this.adjustWH.setRowBlockIndex(jetRptCTCrossTab.currentRowBlockIndex.get());
            this.adjustWH.setColBlockIndex(jetRptCTCrossTab.currentColBlockIndex.get());
        }
    }

    public void buildBlocks() throws DSException {
        if (this.buildBlocks == null) {
            this.buildBlocks = new CTBlockBuilder(this);
            this.buildBlocks.setRptObjects(this.get);
        }
        this.buildBlocks.buildBlocks();
    }

    public DSCrossTab blockSplit() {
        DSCrossTab dSCrossTab = null;
        if (this.blockSplit == null) {
            CTBlock cTBlock = this.buildBlocks.getBlock();
            if (cTBlock == null) {
                this.currentColBlockIndex = new CTSplitManager();
            } else {
                this.blockSplit = new CTBlockManager(this.buildBlocks.getBlock());
                this.currentColBlockIndex = new CTSplitManager(this.blockSplit, this.SEDU, this.adjustWH, this.currentRowBlockIndex);
            }
        }
        try {
            this.currentColBlockIndex.setHasSpecialField(this.get.isHasSpecialField());
            this.currentColBlockIndex.setPrepare(this.getBlock);
            this.currentColBlockIndex.setLogicMode(this.getBooleanPropertyByName);
            dSCrossTab = this.currentColBlockIndex.blockSplit();
        }
        catch (JRInterruptedException jRInterruptedException) {
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "Crosstab split error.", (Throwable)exception);
            }
            this.currentColBlockIndex.setSplitResult((short)0);
        }
        if (this.error != null && dSCrossTab != null) {
            dSCrossTab.setCtfNames(this.error.getCTFMapDisplayNameWithRuntimeColName());
        }
        return dSCrossTab;
    }

    public CrosstabVariables getCtps() {
        return this.adjustWH;
    }

    public CTSpaceManager getSpace() {
        return this.SEDU;
    }

    public void setSpace(CTSpaceManager cTSpaceManager) {
        this.SEDU = cTSpaceManager;
    }

    public void setCtps(CrosstabVariables crosstabVariables) {
        this.adjustWH = crosstabVariables;
    }

    public boolean needNewSpace() {
        return false;
    }

    public boolean isWidthBreak() {
        return false;
    }

    public boolean isBreak() {
        return false;
    }

    public CTCCUtil getPUtil() {
        return this.currentRowBlockIndex;
    }

    public CTSplitManager getSplitManager() {
        return this.currentColBlockIndex;
    }

    public void setSplitManager(CTSplitManager cTSplitManager) {
        this.currentColBlockIndex = cTSplitManager;
    }

    public boolean isPrepare() {
        return this.getBlock;
    }

    public void setPrepare(boolean bl) {
        this.getBlock = bl;
    }

    public boolean isLogicMode() {
        return this.getBooleanPropertyByName;
    }

    public void setLogicMode(boolean bl) {
        this.getBooleanPropertyByName = bl;
    }

    public void setLayoutInfo(CrosstabLayoutInfo crosstabLayoutInfo) {
        this.getCTFMapDisplayNameWithRuntimeColName = crosstabLayoutInfo;
    }

    public CrosstabDataResult getCursorResult() {
        return this.error;
    }
}

