/*
 * Decompiled with CFR 0.152.
 */
package jet.crosstab;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import jet.connect.DbBigInt;
import jet.connect.DbColDesc;
import jet.connect.DbValue;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataengine.api.query.AggResultInfo;
import jet.dataengine.api.query.CTFormula;
import jet.dataengine.util.DSLog;
import jet.formula.Aggregation;
import jet.formula.CompondAggregation;
import jet.formula.JetRptFormula;
import jet.formula.SQRSUM;
import jet.util.DbRecordable;
import jet.util.HashVector;
import jet.util.IntVector;

public class JCTAggregater {
    private DSLog SEDU = DSLog.getDSLog(this.getClass().getName());
    Vector aggs = new Vector();
    Vector accessList = new Vector();
    private int add = 0;
    Vector usedFormula = null;
    Vector usedFlyFormula = null;
    Vector usedCFFormula = null;
    IntVector specialPosition = null;
    HashVector allCTFs = null;
    HashVector allFMLs = null;
    private HashMap addElement = new HashMap();

    public JCTAggregater(Vector vector, Vector vector2, int n, Vector vector3, Vector vector4, Vector vector5, HashVector hashVector, HashVector hashVector2) {
        for (Aggregation[] aggregationArray : vector) {
            if (aggregationArray != null) {
                this.aggs.add(aggregationArray[0]);
                continue;
            }
            this.aggs.add(null);
        }
        this.accessList = vector2;
        this.add = n;
        this.usedFormula = vector3;
        this.usedFlyFormula = vector4;
        this.usedCFFormula = vector5;
        this.allCTFs = hashVector;
        this.allFMLs = hashVector2;
        this.SEDU();
    }

    private void SEDU() {
        if (this.aggs != null) {
            Vector vector = this.aggs;
            for (int i = 0; i < vector.size(); ++i) {
                Aggregation aggregation = (Aggregation)vector.get(i);
                if (aggregation == null) continue;
                int n = this.aggs.indexOf(aggregation);
                this.addElement.put(i, n);
                if (i <= n) continue;
                vector.set(i, null);
            }
            ArrayList<Aggregation> arrayList = new ArrayList<Aggregation>();
            for (int i = 0; i < vector.size(); ++i) {
                Aggregation aggregation = (Aggregation)vector.get(i);
                if (!(aggregation instanceof CompondAggregation)) continue;
                Aggregation[] aggregationArray = ((CompondAggregation)aggregation).getUsedAggs();
                for (int j = 0; j < aggregationArray.length; ++j) {
                    int n = this.aggs.indexOf(aggregationArray[j]);
                    if (n == -1) {
                        n = arrayList.indexOf(aggregationArray[j]);
                        if (n == -1) {
                            arrayList.add(aggregationArray[j]);
                            continue;
                        }
                        aggregationArray[j] = (Aggregation)arrayList.get(n);
                        continue;
                    }
                    aggregationArray[j] = (Aggregation)this.aggs.get(n);
                }
            }
            for (Aggregation aggregation : arrayList) {
                if (vector.contains(aggregation)) continue;
                vector.add(aggregation);
                this.accessList.add(true);
            }
        }
    }

    private JCTAggregater(int n) {
        this.aggs = new Vector(n);
    }

    public void resetFormulas(Vector vector, Vector vector2) {
        this.usedFormula = vector;
        this.usedFlyFormula = vector2;
    }

    public void reset() {
        throw new RuntimeException("Not implemented!");
    }

    public void aggregate(DbRecordable dbRecordable, AggResultInfo aggResultInfo) {
        int n = this.aggs.size();
        for (int i = 0; i < n; ++i) {
            if (this.aggs.elementAt(i) == null || this.aggs.elementAt(i) instanceof CompondAggregation) continue;
            if (aggResultInfo == null) {
                ((Aggregation)this.aggs.elementAt(i)).exec((JRecord)dbRecordable);
                continue;
            }
            if (aggResultInfo.size() == 0) {
                ((Aggregation)this.aggs.elementAt(i)).exec((JRecord)dbRecordable);
                continue;
            }
            int n2 = aggResultInfo.getAggInfo(((Aggregation)this.aggs.elementAt((int)i)).getAggDesc().aggCode, ((Aggregation)this.aggs.elementAt((int)i)).getAggDesc().fieldname);
            DbValue dbValue = (DbValue)dbRecordable.getValue(n2);
            if (!((Aggregation)this.aggs.elementAt(i)).isCountFunc()) {
                if (this.aggs.elementAt(i) instanceof SQRSUM) {
                    ((SQRSUM)this.aggs.elementAt(i)).setValue(dbValue);
                    continue;
                }
                ((Aggregation)this.aggs.elementAt(i)).exec(dbValue);
                continue;
            }
            if (((Aggregation)this.aggs.elementAt((int)i)).getAggDesc().aggCode == 1) {
                DbBigInt dbBigInt = (DbBigInt)dbValue;
                for (int j = 0; j < dbBigInt.intValue(); ++j) {
                    ((Aggregation)this.aggs.elementAt(i)).execute(dbBigInt);
                }
                continue;
            }
            if (((Aggregation)this.aggs.elementAt((int)i)).getAggDesc().aggCode != 5) continue;
        }
    }

    public DbValue[] getResults(boolean bl) {
        if (this.aggs == null) {
            return null;
        }
        int n = this.aggs.size();
        DbValue[] dbValueArray = new DbValue[n];
        for (int i = 0; i < n; ++i) {
            if (i > this.add - 1) {
                dbValueArray[i] = null;
                continue;
            }
            Integer n2 = (Integer)this.addElement.get(i);
            if (n2 == null) {
                dbValueArray[i] = null;
                continue;
            }
            if (bl) {
                if (Aggregation.isRunningTotal(((Aggregation)this.aggs.elementAt((int)n2.intValue())).getAggDesc().aggCode)) {
                    try {
                        dbValueArray[i] = ((Aggregation)this.aggs.elementAt(n2)).getValue();
                    }
                    catch (NullPointerException nullPointerException) {
                        dbValueArray[i] = null;
                    }
                    continue;
                }
                dbValueArray[i] = null;
                continue;
            }
            dbValueArray[i] = ((Aggregation)this.aggs.elementAt(n2)).getValue();
            if (!((Boolean)this.accessList.elementAt(n2)).booleanValue()) continue;
            dbValueArray[i].setNull();
        }
        return dbValueArray;
    }

    public DbColDesc getColDescByFmlName(String string) {
        if (this.allCTFs.get(string) != null) {
            return ((JetRptFormula)this.allCTFs.get(string)).getColDesc();
        }
        if (this.allFMLs.get(string) != null) {
            return ((JetRptFormula)this.allFMLs.get(string)).getColDesc();
        }
        return null;
    }

    public Object clone() {
        Aggregation[] aggregationArray;
        Aggregation aggregation;
        int n;
        int n2 = this.aggs.size();
        JCTAggregater jCTAggregater = new JCTAggregater(n2);
        jCTAggregater.addElement = this.addElement;
        for (n = 0; n < n2; ++n) {
            if (this.aggs.elementAt(n) == null) {
                jCTAggregater.aggs.addElement(null);
                continue;
            }
            aggregation = (Aggregation)this.aggs.elementAt(n);
            aggregationArray = (Aggregation[])aggregation.clone();
            jCTAggregater.aggs.addElement(aggregationArray);
        }
        for (n = 0; n < jCTAggregater.aggs.size(); ++n) {
            aggregation = (Aggregation)jCTAggregater.aggs.get(n);
            if (!(aggregation instanceof CompondAggregation)) continue;
            aggregationArray = ((CompondAggregation)aggregation).getUsedAggs();
            for (int i = 0; i < aggregationArray.length; ++i) {
                int n3 = jCTAggregater.aggs.indexOf(aggregationArray[i]);
                aggregationArray[i] = (Aggregation)jCTAggregater.aggs.get(n3);
            }
        }
        jCTAggregater.accessList = this.accessList;
        jCTAggregater.usedFormula = this.usedFormula;
        jCTAggregater.usedFlyFormula = this.usedFlyFormula;
        jCTAggregater.usedCFFormula = this.usedCFFormula;
        jCTAggregater.add = this.add;
        jCTAggregater.allCTFs = this.allCTFs;
        jCTAggregater.allFMLs = this.allFMLs;
        return jCTAggregater;
    }

    public Vector getAggs() {
        return this.aggs;
    }

    public int getShowAggSize() {
        return this.add;
    }

    public Vector getUsedFormula() {
        return this.usedFormula;
    }

    public Vector getUsedFlyFormula() {
        return this.usedFlyFormula;
    }

    public Vector getUsedCFFormula() {
        return this.usedCFFormula;
    }

    public IntVector getSpecialPosition() {
        return this.specialPosition;
    }

    public void debugInfo() {
        int n;
        if (this.SEDU.isDebugEnabled()) {
            this.SEDU.debug("JCTAggregater, ");
            this.SEDU.debug("Show aggregation size: " + String.valueOf(this.add));
            this.SEDU.debug("Aggregations: ");
        }
        for (n = 0; n < this.aggs.size(); ++n) {
            if (this.aggs.get(n) == null || !this.SEDU.isDebugEnabled()) continue;
            this.SEDU.debug(((Aggregation)this.aggs.get(n)).toString() + ", IsDeny: " + ((Boolean)this.accessList.get(n)).toString());
        }
        if (this.SEDU.isDebugEnabled()) {
            this.SEDU.debug("CT Formulas: ");
        }
        for (n = 0; n < this.usedFormula.size(); ++n) {
            if (this.usedFormula.get(n) == null || !this.SEDU.isDebugEnabled()) continue;
            this.SEDU.debug(((CTFormula)this.usedFormula.get((int)n)).getFormula().expr.toString());
        }
        if (this.SEDU.isDebugEnabled()) {
            this.SEDU.debug("Fly Formulas: ");
        }
        for (n = 0; n < this.usedFlyFormula.size(); ++n) {
            if (this.usedFlyFormula.get(n) == null || !this.SEDU.isDebugEnabled()) continue;
            this.SEDU.debug(((CTFormula)this.usedFlyFormula.get((int)n)).getFormula().expr.toString());
        }
        if (this.SEDU.isDebugEnabled()) {
            this.SEDU.debug("Condition Format Formulas: ");
        }
        for (n = 0; n < this.usedCFFormula.size(); ++n) {
            if (this.usedCFFormula.get(n) == null || !this.SEDU.isDebugEnabled()) continue;
            this.SEDU.debug(((CTFormula)this.usedCFFormula.get((int)n)).getFormula().expr.toString());
        }
    }
}

