/*
 * Decompiled with CFR 0.152.
 */
package jet.cs.ui.param;

import guitools.swing.dialog.CommonContainer;
import guitools.toolkit.JDebug;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jet.JDesgResource;
import jet.cs.Param;
import jet.cs.ui.param.ParamTabChangeListener;
import jet.cs.ui.param.ParameterChangedListener;
import jet.cs.ui.param.ParameterPage;
import jet.exception.InvalidParameterException;
import jet.formula.ParamDesc;

public class EnterParameterValuesDialog
extends CommonContainer
implements ActionListener,
ParamTabChangeListener {
    protected JScrollPane sPane = null;
    protected JDialog dialog = null;
    protected JButton okBtn = null;
    protected JButton defaultBtn = null;
    protected JButton cancelBtn = null;
    protected JButton helpBtn = null;
    protected boolean isOk = true;
    protected boolean isDefault = false;
    protected Locale locale = Locale.getDefault();
    protected Vector allParameterPages = new Vector();
    protected boolean isDef = false;
    protected ParameterChangedListener paramListener;
    protected Hashtable dynamicalValues = new Hashtable();
    protected boolean isShowDialog = true;
    protected Hashtable paramsHashtable;
    protected Hashtable tempHS = new Hashtable();
    protected Vector vSortParameters = null;
    protected Hashtable rptProps;

    public EnterParameterValuesDialog(Container container, Hashtable hashtable, Vector vector, Locale locale, ParameterChangedListener parameterChangedListener, Hashtable hashtable2) {
        super(container, new JDesgResource().getClass().getClassLoader().getResource("resource/dialog/EnterParameterValuesDialog.xml"));
        this.paramsHashtable = hashtable;
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            ParamDesc paramDesc = (ParamDesc)hashtable.get(iterator.next());
            if (!paramDesc.isMultipleValue() || !paramDesc.isAllowAll()) continue;
            paramDesc.setAllSelected(true);
        }
        if (locale != null) {
            this.locale = locale;
        }
        this.paramListener = parameterChangedListener;
        this.rptProps = hashtable2;
        if (vector != null) {
            this.vSortParameters = vector.size() == 0 ? null : vector;
        }
        this.tempHS = hashtable;
        this.IsParameters(ParamDesc.changedHashToVector(this.paramsHashtable));
        if (this.isShowDialog) {
            this.d.showDialog();
        }
    }

    private void IsParameters(Vector vector) {
        this.dialog = this.d.getDialog();
        this.sPane = (JScrollPane)this.d.getElement("sPane");
        this.sPane.setBorder(BorderFactory.createEmptyBorder());
        this.okBtn = (JButton)this.d.getElement("okBtn");
        this.okBtn.addActionListener(this);
        this.defaultBtn = (JButton)this.d.getElement("defaultBtn");
        this.defaultBtn.addActionListener(this);
        this.cancelBtn = (JButton)this.d.getElement("cancelBtn");
        this.cancelBtn.addActionListener(this);
        this.helpBtn = (JButton)this.d.getElement("helpBtn");
        this.helpBtn.addActionListener(this);
        this.SEDU(this.WARNING(vector));
    }

    private void SEDU(Vector vector) {
        Object object;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        int n = 0;
        this.allParameterPages.removeAllElements();
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = (Vector)vector.elementAt(i);
            object = new ParameterPage(this.dialog, vector2, Locale.getDefault(), this);
            if (((ParameterPage)object).pageIsHide()) continue;
            this.allParameterPages.addElement(object);
            if (((ParameterPage)object).getParameter() == null || !((ParameterPage)object).getParameter().isUseCurrentDate() && !((ParameterPage)object).getParameter().isUseCurrentDateWhenBlank()) continue;
            this.dynamicalValues.put(((ParameterPage)object).getParameter().getName(), ((ParameterPage)object).getDynamicalValue());
        }
        this.isShowDialog = this.allParameterPages.size() > 0;
        Vector vector3 = (Vector)this.allParameterPages.clone();
        if (vector3.size() > 0) {
            int n2;
            int n3 = this.vSortParameters.size();
            ParameterPage parameterPage = null;
            block1: for (n2 = 0; n2 < n3; ++n2) {
                object = (String)this.vSortParameters.elementAt(n2);
                for (int i = 0; i < vector3.size(); ++i) {
                    parameterPage = (ParameterPage)vector3.elementAt(i);
                    ParamDesc paramDesc = (ParamDesc)parameterPage.getParams().get(0);
                    if (!((String)object).equalsIgnoreCase(paramDesc.name)) continue;
                    parameterPage.setParamTabChangeListener(this);
                    jPanel.add(parameterPage);
                    n = (int)((double)n + parameterPage.getPreferredSize().getHeight());
                    vector3.remove(i);
                    continue block1;
                }
            }
            for (n2 = 0; n2 < vector3.size(); ++n2) {
                parameterPage = (ParameterPage)vector3.elementAt(n2);
                parameterPage.setParamTabChangeListener(this);
                jPanel.add(parameterPage);
                n = (int)((double)n + parameterPage.getPreferredSize().getHeight() * (double)vector3.size());
            }
        }
        jPanel.setPreferredSize(new Dimension(400, n));
        this.sPane.setViewportView(jPanel);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okBtn) {
            this.clickOk();
        } else if (actionEvent.getSource() == this.defaultBtn) {
            this.clickDefault();
        } else if (actionEvent.getSource() == this.helpBtn) {
            this.onClickHelp();
        } else {
            this.isOk = false;
            this.isDefault = false;
            this.dialog.dispose();
        }
    }

    protected void clickOk() {
    }

    protected void clickDefault() {
    }

    protected void onClickHelp() {
    }

    public boolean isOk() {
        return this.isOk;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    protected boolean checkReqValue() {
        int n = this.allParameterPages.size();
        Vector vector = new Vector();
        for (int i = 0; i < n; ++i) {
            ParameterPage parameterPage = (ParameterPage)this.allParameterPages.elementAt(i);
            boolean bl = false;
            vector = parameterPage.getParams();
            for (int j = 0; j < vector.size(); ++j) {
                ParamDesc paramDesc = (ParamDesc)vector.elementAt(j);
                if (paramDesc.getPrompt().endsWith("*") && this.isDef && paramDesc.getDefaultValues().size() > 0) {
                    try {
                        paramDesc.setValue((String)paramDesc.getDefaultValues().lastElement(), this.locale);
                    }
                    catch (InvalidParameterException invalidParameterException) {
                        JDebug.WARNING(invalidParameterException);
                    }
                }
                if (!paramDesc.isRequired() && !paramDesc.getPrompt().endsWith("*")) continue;
                if (!(this.isDef || parameterPage.getValue() != null && parameterPage.getValue().length() > 0)) {
                    bl = true;
                }
                if (this.isDef && paramDesc.getDefaultValues().size() <= 0) {
                    bl = true;
                }
                if (!bl) continue;
                JOptionPane.showMessageDialog(this.dialog, JDesgResource.getMessage("ERROR_MESSAGE_PARAMETER_REQUIRED_VALUE", (Object)paramDesc.getName()));
                return false;
            }
        }
        return true;
    }

    protected String serverValidateParam() {
        return null;
    }

    protected boolean validateParam() {
        boolean bl = false;
        if (this.checkReqValue() && this.getParamValue()) {
            String string = this.serverValidateParam();
            if (string != null) {
                JOptionPane.showMessageDialog(this.dialog.getParent(), string, JDesgResource.getMessage("WARNING"), 2);
                bl = false;
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public Hashtable getParamDescs() {
        if (this.isDefault()) {
            return this.paramsHashtable;
        }
        Hashtable<String, ParamDesc> hashtable = new Hashtable<String, ParamDesc>();
        for (int i = 0; i < this.allParameterPages.size(); ++i) {
            ParameterPage parameterPage = (ParameterPage)this.allParameterPages.elementAt(i);
            for (int j = 0; j < parameterPage.getParams().size(); ++j) {
                ParamDesc paramDesc = (ParamDesc)parameterPage.getParams().elementAt(j);
                hashtable.put(paramDesc.name, paramDesc);
            }
        }
        return hashtable;
    }

    public boolean getParamValue() {
        int n = this.allParameterPages.size();
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            ParameterPage parameterPage = (ParameterPage)this.allParameterPages.elementAt(i);
            Vector vector = parameterPage.getParams();
            for (int j = 0; j < vector.size(); ++j) {
                ParamDesc paramDesc = (ParamDesc)vector.elementAt(j);
                try {
                    if (paramDesc.isMultipleValue() && !paramDesc.isAllSelected()) {
                        paramDesc.setValue(parameterPage.getMultipleValues(paramDesc), this.locale);
                        continue;
                    }
                    paramDesc.check(parameterPage.getParameterValue(paramDesc), this.locale);
                    continue;
                }
                catch (InvalidParameterException invalidParameterException) {
                    bl = false;
                    JOptionPane.showMessageDialog(this.dialog.getParent(), paramDesc.name + ": \n" + invalidParameterException.getMessage(), JDesgResource.getMessage("WARNING"), 2);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    if (!this.checkReqValue()) continue;
                    this.isOk = false;
                    this.isDefault = true;
                    this.dialog.dispose();
                }
            }
        }
        return bl;
    }

    @Override
    public void ParamChange(ParamDesc paramDesc, Object object) {
        Vector<ParamDesc> vector = new Vector<ParamDesc>();
        if (this.paramListener != null && (paramDesc.IsParameters() || paramDesc.isReferedBy())) {
            ParamDesc paramDesc2;
            Vector vector2 = new Vector();
            vector2 = paramDesc.isMultipleValue() ? (paramDesc.isAllowAll() && paramDesc.isAllSelected() ? this.paramListener.paramValueChanged(paramDesc.name, new String[]{"\u0007"}) : this.paramListener.paramValueChanged(paramDesc.name, (String[])object)) : this.paramListener.paramValueChanged(paramDesc.name, object.toString());
            Vector vector3 = null;
            for (int i = 0; i < vector2.size(); ++i) {
                Param param = (Param)vector2.elementAt(i);
                paramDesc2 = Param.toParamDesc(param, this.locale);
                vector.addElement(paramDesc2);
                if (!paramDesc.getName().equals(param.getName())) continue;
                vector3 = param.getReferedBy();
            }
            Hashtable hashtable = this.getParamDescs();
            vector3 = vector3 == null ? new Vector() : vector3;
            for (int i = 0; i < vector.size(); ++i) {
                paramDesc2 = (ParamDesc)vector.get(i);
                if (paramDesc.getName().equals(paramDesc2.getName())) continue;
                if (vector3.contains(paramDesc2.getName())) {
                    if (!paramDesc2.isMultipleValue() || !paramDesc2.isAllowAll()) continue;
                    paramDesc2.setAllSelected(true);
                    continue;
                }
                ParamDesc paramDesc3 = (ParamDesc)hashtable.get(paramDesc2.getName());
                if (paramDesc3 == null) continue;
                if (paramDesc2.isMultipleValue()) {
                    paramDesc2.setAllSelected(paramDesc3.isAllSelected());
                    if (paramDesc2.isAllSelected()) continue;
                    try {
                        paramDesc2.setValue(paramDesc3.getMultiStrValue(), this.locale);
                    }
                    catch (InvalidParameterException invalidParameterException) {
                        JDebug.WARNING(invalidParameterException);
                    }
                    continue;
                }
                try {
                    paramDesc2.setValue(paramDesc3.getValue(), this.locale);
                    continue;
                }
                catch (InvalidParameterException invalidParameterException) {
                    JDebug.WARNING(invalidParameterException);
                }
            }
            this.sPane.getViewport().removeAll();
            this.tempHS = Param.changedVectorToHash(vector);
            this.SEDU(this.WARNING(vector));
        }
    }

    private Vector WARNING(Vector vector) {
        Vector vector2 = new Vector();
        if (vector == null) {
            return vector2;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Vector<ParamDesc> vector3;
            ParamDesc paramDesc = (ParamDesc)vector.elementAt(i);
            if (this.tempHS.get(paramDesc.getName()) == null) continue;
            if (paramDesc.isCascading()) {
                vector3 = new Vector<ParamDesc>();
                String string = this.add(paramDesc);
                ParamDesc paramDesc2 = (ParamDesc)this.tempHS.get(string);
                vector3.addElement(paramDesc2);
                this.tempHS.remove(string);
                String string2 = paramDesc2.getNextLevel();
                while (string2 != null && !string2.equals("") && (paramDesc2 = (ParamDesc)this.tempHS.get(string2)) != null) {
                    vector3.addElement(paramDesc2);
                    this.tempHS.remove(string2);
                    string2 = paramDesc2.getNextLevel();
                }
                vector2.addElement(vector3);
                continue;
            }
            vector3 = new Vector();
            vector3.addElement(paramDesc);
            this.tempHS.get(paramDesc.getName());
            vector2.addElement(vector3);
        }
        return vector2;
    }

    private String add(ParamDesc paramDesc) {
        String string = paramDesc.getPreviousLevel();
        if (string == null || string.equals("")) {
            return paramDesc.getName();
        }
        ParamDesc paramDesc2 = (ParamDesc)this.tempHS.get(string);
        String string2 = this.add(paramDesc2);
        return string2;
    }
}

