/*
 * Decompiled with CFR 0.152.
 */
package jet.css;

import com.jinfonet.dom.css.JCSSMediaRule;
import com.jinfonet.dom.css.JCSSPageRule;
import com.jinfonet.dom.css.JCSSProperty;
import com.jinfonet.dom.css.JCSSStyleRule;
import com.jinfonet.util.JRLog;
import java.io.File;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jet.controls.JetEnumeration;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetUnitNumber;
import jet.controls.JetVector;
import jet.css.CSSMemRule;
import jet.css.CSSRuleKey;
import jet.css.CssStyleSheetManager;
import jet.css.JCSSException;
import jet.log.JRLogger;
import jet.naming.PropertyNames;
import jet.report.JRObjectTemplate;
import jet.report.JetRptObject;
import jet.report.UpgradeName;
import jet.report.mode.JetRptMode;
import jet.reportLogic.objectLogic.paragraphLogic.Paragraph;
import jet.reportLogic.objectLogic.paragraphLogic.ReplaceElement;
import jet.util.MiscTools;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.stylesheets.MediaList;

public class CSSHandler {
    public static final int MEDIA_DEFAULT = 0;
    public static final int MEDIA_SCREEN = 1;
    public static final int MEDIA_PRINT = 2;
    public static final int MEDIA_TV = 3;
    public static final int MEDIA_RADIO = 4;
    public static final int MEDIA_AURAL = 5;
    private static final String[] BorderColor = new String[]{"default", "screen", "print", "tv", "radio", "aural"};
    private int[] BorderWidth;
    private Hashtable SEDU = new Hashtable();
    private Hashtable _mapStringToColor = new Hashtable();
    private Hashtable add = new Hashtable();
    private Hashtable append = new Hashtable();
    private Hashtable border_bottom_color = new Hashtable();
    private Hashtable border_bottom_width = new Hashtable();

    public CSSHandler(String string) throws JCSSException {
        CSSStyleSheet cSSStyleSheet = CssStyleSheetManager.getCSSStyleSheetManager().getCSSStyleSheet(new File(string));
        CSSRuleList cSSRuleList = null;
        if (cSSStyleSheet != null) {
            cSSRuleList = cSSStyleSheet.getCssRules();
            for (int i = 0; i < cSSRuleList.getLength(); ++i) {
                CSSRule cSSRule = cSSRuleList.item(i);
                this.BorderWidth(cSSRule, null);
                if (!JRLog.isTrace(4)) continue;
                JRLog.trace(4, cSSRule.toString());
            }
        }
    }

    public CSSHandler(CSSRuleList cSSRuleList) {
        for (int i = 0; i < cSSRuleList.getLength(); ++i) {
            CSSRule cSSRule = cSSRuleList.item(i);
            this.BorderWidth(cSSRule, null);
        }
    }

    private int BorderColor(String string) {
        if (string == null) {
            return 0;
        }
        for (int i = 1; i < BorderColor.length; ++i) {
            if (BorderColor[i].compareTo(string) != 0) continue;
            return i;
        }
        return 0;
    }

    private void BorderWidth(CSSRule cSSRule, String string) {
        switch (cSSRule.getType()) {
            case 1: {
                JCSSStyleRule jCSSStyleRule = (JCSSStyleRule)cSSRule;
                SelectorList selectorList = jCSSStyleRule.getSelectors();
                int n = selectorList.getLength();
                for (int i = 0; i < n; ++i) {
                    Object object;
                    int n2;
                    Vector vector;
                    Selector selector = selectorList.item(i);
                    CSSMemRule cSSMemRule = new CSSMemRule();
                    this.BorderWidth = new int[3];
                    cSSMemRule.setKey(this.clone(selector, new CSSRuleKey()));
                    Hashtable hashtable = jCSSStyleRule.getDeclarations();
                    String string2 = cSSMemRule.getKey().getSubject();
                    if (string2.equals("*")) {
                        vector = this.append(string);
                        for (n2 = 0; n2 < vector.size(); ++n2) {
                            object = (String)vector.elementAt(n2);
                            Vector vector2 = this.border_bottom_width(string, (String)object, cSSMemRule.getKey());
                            for (int j = 0; j < vector2.size(); ++j) {
                                CSSMemRule cSSMemRule2 = (CSSMemRule)vector2.elementAt(j);
                                this.SEDU(hashtable, cSSMemRule2);
                                if (cSSMemRule2.isAddUniDec()) continue;
                                cSSMemRule2.setAddUniDec(true);
                            }
                        }
                        this._mapStringToColor(hashtable, cSSMemRule, string);
                    } else {
                        vector = this.add(string, "*");
                        for (n2 = 0; n2 < vector.size(); ++n2) {
                            object = (CSSMemRule)vector.elementAt(n2);
                            if (!this.border_right_color(cSSMemRule.getKey(), ((CSSMemRule)object).getKey())) continue;
                            this.SEDU(((CSSMemRule)object).getDecls(), cSSMemRule);
                            this.SEDU(((CSSMemRule)object).getImportantDecls(), cSSMemRule);
                        }
                        cSSMemRule.setAddUniDec(true);
                        this._mapStringToColor(hashtable, cSSMemRule, string);
                    }
                    cSSMemRule.setPrioty(this.BorderWidth);
                }
                break;
            }
            case 4: {
                JCSSMediaRule jCSSMediaRule = (JCSSMediaRule)cSSRule;
                MediaList mediaList = jCSSMediaRule.getMedia();
                CSSRuleList cSSRuleList = jCSSMediaRule.getCssRules();
                for (int i = 0; i < cSSRuleList.getLength(); ++i) {
                    for (int j = 0; j < mediaList.getLength(); ++j) {
                        this.BorderWidth(cSSRuleList.item(i), mediaList.item(j));
                    }
                }
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                JCSSPageRule jCSSPageRule = (JCSSPageRule)cSSRule;
                CSSMemRule cSSMemRule = new CSSMemRule();
                CSSRuleKey cSSRuleKey = new CSSRuleKey();
                String string3 = "@page " + jCSSPageRule.getSelectorText();
                cSSRuleKey.setSubject(string3);
                Vector vector = cSSRuleKey.getPseudos();
                if (vector == null) {
                    vector = new Vector();
                }
                cSSRuleKey.setPseudos(vector);
                cSSMemRule.setKey(cSSRuleKey);
                int[] nArray = new int[3];
                if (vector != null) {
                    nArray[2] = vector.size();
                }
                cSSMemRule.setPrioty(nArray);
                CSSRule cSSRule2 = jCSSPageRule.getParentRule();
                if (cSSRule2 != null && cSSRule2.getType() == 4) {
                    JCSSMediaRule jCSSMediaRule = (JCSSMediaRule)cSSRule2;
                    MediaList mediaList = jCSSMediaRule.getMedia();
                    for (int i = 0; i < mediaList.getLength(); ++i) {
                        this._mapStringToColor(jCSSPageRule.getDeclarations(), cSSMemRule, mediaList.item(i));
                    }
                    break;
                }
                this._mapStringToColor(jCSSPageRule.getDeclarations(), cSSMemRule, null);
                break;
            }
        }
    }

    private void SEDU(Hashtable hashtable, CSSMemRule cSSMemRule) {
        Hashtable hashtable2 = cSSMemRule.getDecls();
        Hashtable hashtable3 = cSSMemRule.getImportantDecls();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            JCSSProperty jCSSProperty = (JCSSProperty)hashtable.get(string);
            if (jCSSProperty.isImportant()) {
                hashtable3.put(string, jCSSProperty.duplate());
                hashtable2.remove(string);
                continue;
            }
            hashtable2.put(string, jCSSProperty.duplate());
        }
    }

    private void _mapStringToColor(Hashtable hashtable, CSSMemRule cSSMemRule, String string) {
        String string2 = cSSMemRule.getKey().getSubject();
        CSSMemRule cSSMemRule2 = this.border_left_color(string, string2, cSSMemRule.getKey());
        if (cSSMemRule2 == null) {
            this.border_top_width(string, string2, cSSMemRule);
            this.SEDU(hashtable, cSSMemRule);
        } else {
            this.SEDU(hashtable, cSSMemRule2);
        }
    }

    private Vector add(String string, String string2) {
        Vector vector = null;
        int n = this.BorderColor(string);
        switch (n) {
            case 1: {
                vector = (Vector)this._mapStringToColor.get(string2);
                break;
            }
            case 2: {
                vector = (Vector)this.add.get(string2);
                break;
            }
            case 3: {
                vector = (Vector)this.append.get(string2);
                break;
            }
            case 4: {
                vector = (Vector)this.border_bottom_color.get(string2);
                break;
            }
            case 5: {
                vector = (Vector)this.border_bottom_width.get(string2);
                break;
            }
            default: {
                vector = (Vector)this.SEDU.get(string2);
            }
        }
        if (vector == null) {
            return new Vector();
        }
        return vector;
    }

    private Vector append(String string) {
        Vector vector = new Vector();
        Enumeration enumeration = null;
        int n = this.BorderColor(string);
        switch (n) {
            case 1: {
                enumeration = this._mapStringToColor.keys();
                break;
            }
            case 2: {
                enumeration = this.add.keys();
                break;
            }
            case 3: {
                enumeration = this.append.keys();
                break;
            }
            case 4: {
                enumeration = this.border_bottom_color.keys();
                break;
            }
            case 5: {
                enumeration = this.border_bottom_width.keys();
                break;
            }
            default: {
                enumeration = this.SEDU.keys();
            }
        }
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    private void border_bottom_color(String string, String string2, Vector vector) {
        int n = this.BorderColor(string);
        switch (n) {
            case 1: {
                this._mapStringToColor.put(string2, vector);
                break;
            }
            case 2: {
                this.add.put(string2, vector);
                break;
            }
            case 3: {
                this.append.put(string2, vector);
                break;
            }
            case 4: {
                this.border_bottom_color.put(string2, vector);
                break;
            }
            case 5: {
                this.border_bottom_width.put(string2, vector);
                break;
            }
            default: {
                this.SEDU.put(string2, vector);
            }
        }
    }

    private Vector border_bottom_width(String string, String string2, CSSRuleKey cSSRuleKey) {
        Vector<CSSMemRule> vector = new Vector<CSSMemRule>();
        Vector vector2 = this.add(string, string2);
        if (vector2 != null) {
            for (int i = 0; i < vector2.size(); ++i) {
                CSSMemRule cSSMemRule = (CSSMemRule)vector2.elementAt(i);
                if (!this.border_right_color(cSSMemRule.getKey(), cSSRuleKey)) continue;
                vector.add(cSSMemRule);
            }
        }
        return vector;
    }

    private CSSMemRule border_left_color(String string, String string2, CSSRuleKey cSSRuleKey) {
        Vector vector = this.add(string, string2);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                CSSMemRule cSSMemRule = (CSSMemRule)vector.elementAt(i);
                if (!this.border_left_width(cSSMemRule.getKey(), cSSRuleKey)) continue;
                return cSSMemRule;
            }
        }
        return null;
    }

    private boolean border_left_width(CSSRuleKey cSSRuleKey, CSSRuleKey cSSRuleKey2) {
        if (cSSRuleKey.getSubject().compareTo(cSSRuleKey2.getSubject()) != 0) {
            return false;
        }
        if (!this.border_right_width(cSSRuleKey.getConditions(), cSSRuleKey2.getConditions())) {
            return false;
        }
        if (cSSRuleKey.getAdjSibling() != null && cSSRuleKey2.getAdjSibling() != null) {
            return this.border_right_color(cSSRuleKey.getAdjSibling(), cSSRuleKey2.getAdjSibling());
        }
        if (cSSRuleKey.getAdjSibling() == null && cSSRuleKey2.getAdjSibling() == null) {
            if (cSSRuleKey.getParent() != null && cSSRuleKey2.getParent() != null) {
                return this.border_right_color(cSSRuleKey.getParent(), cSSRuleKey2.getParent());
            }
            if (cSSRuleKey.getParent() == null && cSSRuleKey2.getParent() == null) {
                if (cSSRuleKey.getAncestor() != null && cSSRuleKey2.getAncestor() != null) {
                    return this.border_right_color(cSSRuleKey.getAncestor(), cSSRuleKey2.getAncestor());
                }
                return cSSRuleKey.getAncestor() == null && cSSRuleKey2.getAncestor() == null;
            }
            return false;
        }
        return false;
    }

    private boolean border_right_color(CSSRuleKey cSSRuleKey, CSSRuleKey cSSRuleKey2) {
        if (!cSSRuleKey.getSubject().equals("*") && !cSSRuleKey2.getSubject().equals("*") && cSSRuleKey.getSubject().compareTo(cSSRuleKey2.getSubject()) != 0) {
            return false;
        }
        if (!this.border_right_width(cSSRuleKey.getConditions(), cSSRuleKey2.getConditions())) {
            return false;
        }
        if (cSSRuleKey.getAdjSibling() != null && cSSRuleKey2.getAdjSibling() != null) {
            return this.border_right_color(cSSRuleKey.getAdjSibling(), cSSRuleKey2.getAdjSibling());
        }
        if (cSSRuleKey.getAdjSibling() == null && cSSRuleKey2.getAdjSibling() == null) {
            if (cSSRuleKey.getParent() != null && cSSRuleKey2.getParent() != null) {
                return this.border_right_color(cSSRuleKey.getParent(), cSSRuleKey2.getParent());
            }
            if (cSSRuleKey.getParent() == null && cSSRuleKey2.getParent() == null) {
                if (cSSRuleKey.getAncestor() != null && cSSRuleKey2.getAncestor() != null) {
                    return this.border_right_color(cSSRuleKey.getAncestor(), cSSRuleKey2.getAncestor());
                }
                return cSSRuleKey.getAncestor() == null && cSSRuleKey2.getAncestor() == null;
            }
            return false;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean border_right_width(Condition condition, Condition condition2) {
        if (condition == null || condition2 == null) return condition == null && condition2 == null;
        if (condition.getConditionType() != condition2.getConditionType()) return false;
        switch (condition.getConditionType()) {
            case 0: {
                return this.border_right_width(((CombinatorCondition)condition).getFirstCondition(), ((CombinatorCondition)condition2).getFirstCondition()) && this.border_right_width(((CombinatorCondition)condition).getSecondCondition(), ((CombinatorCondition)condition2).getSecondCondition());
            }
            case 1: {
                return this.border_right_width(((CombinatorCondition)condition).getFirstCondition(), ((CombinatorCondition)condition2).getFirstCondition()) || this.border_right_width(((CombinatorCondition)condition).getSecondCondition(), ((CombinatorCondition)condition2).getSecondCondition());
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                AttributeCondition attributeCondition2 = (AttributeCondition)condition2;
                return this.border_top_color(attributeCondition, attributeCondition2, condition.getConditionType());
            }
            case 6: {
                LangCondition langCondition = (LangCondition)condition;
                LangCondition langCondition2 = (LangCondition)condition2;
                return langCondition.getLang().compareTo(langCondition2.getLang()) == 0;
            }
            case 3: {
                return true;
            }
        }
        JRLogger.getLogger(this.getClass()).warn("condition type = " + condition.getConditionType());
        return true;
    }

    private boolean border_top_color(AttributeCondition attributeCondition, AttributeCondition attributeCondition2, int n) {
        String string = attributeCondition.getLocalName();
        String string2 = attributeCondition2.getLocalName();
        if (string != null && string2 != null) {
            if (string.compareTo(string2) == 0) {
                return attributeCondition.getValue().compareTo(attributeCondition2.getValue()) == 0;
            }
            return false;
        }
        return attributeCondition.getValue().compareTo(attributeCondition2.getValue()) == 0;
    }

    private void border_top_width(String string, String string2, CSSMemRule cSSMemRule) {
        Vector<CSSMemRule> vector = this.add(string, string2);
        if (vector.size() == 0) {
            vector = new Vector<CSSMemRule>();
            this.border_bottom_color(string, string2, vector);
        }
        vector.add(cSSMemRule);
    }

    private CSSRuleKey clone(Selector selector, CSSRuleKey cSSRuleKey) {
        block8: while (true) {
            switch (selector.getSelectorType()) {
                case 11: {
                    DescendantSelector descendantSelector = (DescendantSelector)selector;
                    CSSRuleKey cSSRuleKey2 = new CSSRuleKey();
                    this.clone(descendantSelector.getAncestorSelector(), cSSRuleKey2);
                    this.clone((Selector)descendantSelector.getSimpleSelector(), cSSRuleKey);
                    cSSRuleKey.setParent(cSSRuleKey2);
                    return cSSRuleKey;
                }
                case 10: {
                    DescendantSelector descendantSelector = (DescendantSelector)selector;
                    CSSRuleKey cSSRuleKey3 = new CSSRuleKey();
                    this.clone(descendantSelector.getAncestorSelector(), cSSRuleKey3);
                    this.clone((Selector)descendantSelector.getSimpleSelector(), cSSRuleKey);
                    cSSRuleKey.setAncestor(cSSRuleKey3);
                    return cSSRuleKey;
                }
                case 12: {
                    SiblingSelector siblingSelector = (SiblingSelector)selector;
                    CSSRuleKey cSSRuleKey4 = new CSSRuleKey();
                    this.clone(siblingSelector.getSelector(), cSSRuleKey4);
                    this.clone((Selector)siblingSelector.getSiblingSelector(), cSSRuleKey);
                    cSSRuleKey.setAdjSibling(cSSRuleKey4);
                    return cSSRuleKey;
                }
                case 4: {
                    ElementSelector elementSelector = (ElementSelector)selector;
                    cSSRuleKey.setSubject(elementSelector.toString());
                    if (elementSelector.getLocalName() != null) {
                        this.BorderWidth[2] = this.BorderWidth[2] + 1;
                    }
                    return cSSRuleKey;
                }
                case 0: {
                    ConditionalSelector conditionalSelector = (ConditionalSelector)selector;
                    Condition condition = conditionalSelector.getCondition();
                    cSSRuleKey.setConditions(condition);
                    this.compareTo(condition);
                    selector = conditionalSelector.getSimpleSelector();
                    continue block8;
                }
                case 9: {
                    ElementSelector elementSelector = (ElementSelector)selector;
                    cSSRuleKey.setSubject(elementSelector.getLocalName());
                    return cSSRuleKey;
                }
            }
            break;
        }
        return cSSRuleKey;
    }

    private void compareTo(Condition condition) {
        switch (condition.getConditionType()) {
            case 0: 
            case 1: {
                this.compareTo(((CombinatorCondition)condition).getFirstCondition());
                this.compareTo(((CombinatorCondition)condition).getSecondCondition());
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.BorderWidth[1] = this.BorderWidth[1] + 1;
                break;
            }
            case 5: {
                this.BorderWidth[0] = this.BorderWidth[0] + 1;
                break;
            }
            case 6: {
                this.BorderWidth[1] = this.BorderWidth[1] + 1;
                break;
            }
            default: {
                System.out.println("[CSSH]condition type = " + condition.getConditionType());
            }
        }
    }

    public void applyCSS(JetRptObject jetRptObject, boolean bl) {
        this.contains(jetRptObject, bl, null, false);
        this.contains(jetRptObject, bl, null, true);
    }

    public void applyCSS(JetRptObject jetRptObject, boolean bl, boolean bl2) {
        this.contains(jetRptObject, bl, null, bl2);
    }

    private void contains(JetRptObject jetRptObject, boolean bl, String string, boolean bl2) {
        Hashtable hashtable = new Hashtable();
        hashtable = this.containsKey(jetRptObject, string, bl2);
        this.equals(hashtable, jetRptObject);
        if (bl) {
            Vector vector = jetRptObject.getChildren();
            if (vector == null) {
                return;
            }
            for (int i = 0; i < vector.size(); ++i) {
                this.contains((JetRptObject)vector.elementAt(i), bl, string, bl2);
            }
        }
    }

    public Collection getDeclareations(JetRptObject jetRptObject) {
        Hashtable hashtable = this.containsKey(jetRptObject, null, false);
        Hashtable hashtable2 = this.containsKey(jetRptObject, null, true);
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashtable.put(string, hashtable2.get(string));
        }
        return hashtable.values();
    }

    private Hashtable containsKey(JetRptObject jetRptObject, String string, boolean bl) {
        String string2 = this.getAncestor(jetRptObject);
        if (string == null) {
            string = BorderColor[0];
        }
        int n = 0;
        Vector vector = this.add(string, string2);
        Vector vector2 = this.add(string, "*");
        for (int i = 0; vector2 != null && i < vector2.size(); ++i) {
            if (vector.contains(vector2.elementAt(i))) continue;
            vector.add(vector2.elementAt(i));
        }
        Hashtable hashtable = new Hashtable();
        JetRptObject jetRptObject2 = this.getCSSStyleSheet(jetRptObject);
        if (jetRptObject2 != null) {
            hashtable = jetRptObject2.getProperties();
        }
        Hashtable hashtable2 = new Hashtable();
        int[] nArray = null;
        if (vector != null) {
            n = vector.size();
        }
        for (int i = 0; i < n; ++i) {
            CSSMemRule cSSMemRule = (CSSMemRule)vector.elementAt(i);
            CSSRuleKey cSSRuleKey = cSSMemRule.getKey();
            if (!this.getAncestorSelector(cSSRuleKey, jetRptObject)) continue;
            if (nArray == null) {
                nArray = cSSMemRule.getPrioty();
                if (bl) {
                    hashtable2 = (Hashtable)cSSMemRule.getImportantDecls().clone();
                    continue;
                }
                hashtable2 = (Hashtable)cSSMemRule.getDecls().clone();
                continue;
            }
            if (!this.duplate(hashtable2, cSSMemRule, hashtable, nArray, bl)) continue;
            nArray = cSSMemRule.getPrioty();
        }
        return hashtable2;
    }

    private boolean duplate(Hashtable hashtable, CSSMemRule cSSMemRule, Hashtable hashtable2, int[] nArray, boolean bl) {
        boolean bl2 = false;
        Hashtable hashtable3 = hashtable;
        Hashtable hashtable4 = cSSMemRule.getDecls();
        if (bl) {
            hashtable4 = cSSMemRule.getImportantDecls();
        }
        Enumeration enumeration = hashtable4.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            JCSSProperty jCSSProperty = (JCSSProperty)hashtable4.get(string);
            if ((!hashtable3.containsKey(string) || this.elementAt(cSSMemRule.getPrioty(), nArray) < 0) && hashtable3.containsKey(string)) continue;
            if (jCSSProperty.getValue().getCssText().equals("inherit")) {
                JetProperty jetProperty = (JetProperty)hashtable2.get(string);
                hashtable3.put(string, jetProperty);
            } else {
                hashtable3.put(string, jCSSProperty);
            }
            bl2 = true;
        }
        return bl2;
    }

    private int elementAt(int[] nArray, int[] nArray2) {
        if (nArray.length < 3 || nArray2.length < 3) {
            return -1;
        }
        if (nArray[0] == nArray2[0]) {
            if (nArray[1] == nArray2[1]) {
                if (nArray[2] == nArray2[2]) {
                    return 0;
                }
                if (nArray[2] > nArray2[2]) {
                    return 1;
                }
                return -1;
            }
            if (nArray[1] > nArray2[1]) {
                return 1;
            }
            return -1;
        }
        if (nArray[0] > nArray2[0]) {
            return 1;
        }
        return -1;
    }

    private void endsWith(Hashtable hashtable) {
        Object v = hashtable.get(PropertyNames.getDefinitionName(PropertyNames.BorderWidth));
        if (v != null) {
            hashtable.put(PropertyNames.getDefinitionName(PropertyNames.border_bottom_width), v);
            hashtable.put(PropertyNames.getDefinitionName(PropertyNames.border_top_width), v);
            hashtable.put(PropertyNames.getDefinitionName(PropertyNames.border_left_width), v);
            hashtable.put(PropertyNames.getDefinitionName(PropertyNames.border_right_width), v);
        }
        if ((v = hashtable.get(PropertyNames.getDefinitionName(PropertyNames.BorderColor))) != null) {
            hashtable.put(PropertyNames.getDefinitionName(PropertyNames.border_bottom_color), v);
            hashtable.put(PropertyNames.getDefinitionName(PropertyNames.border_top_color), v);
            hashtable.put(PropertyNames.getDefinitionName(PropertyNames.border_left_color), v);
            hashtable.put(PropertyNames.getDefinitionName(PropertyNames.border_right_color), v);
        }
    }

    private void equals(Hashtable hashtable, JetRptObject jetRptObject) {
        this.endsWith(hashtable);
        Hashtable hashtable2 = jetRptObject.getProperties();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            JetProperty jetProperty;
            Object object;
            Object object2;
            String string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            JCSSProperty jCSSProperty = null;
            JetProperty jetProperty2 = null;
            if (v instanceof JCSSProperty) {
                jCSSProperty = (JCSSProperty)v;
            } else {
                jetProperty2 = (JetProperty)v;
            }
            if (hashtable2.containsKey(string)) {
                object2 = (JetProperty)hashtable2.get(string);
                if (jCSSProperty != null) {
                    object = jCSSProperty.getValue();
                    this.getAdjSibling((JetProperty)object2, (CSSValue)object);
                    continue;
                }
                this.get((JetProperty)object2, jetProperty2);
                continue;
            }
            if (!(jetRptObject instanceof JRObjectTemplate) || (object2 = ((JRObjectTemplate)jetRptObject).getJetRptMode()) == null || (jetProperty = (object = ((JetRptMode)object2).getCurrentRender()) != null ? object.getRenderPropertyByName(string) : null) == null) continue;
            if (jCSSProperty != null) {
                this.getAdjSibling(jetProperty, jCSSProperty.getValue());
            } else {
                this.get(jetProperty, jetProperty2);
            }
            object.setRenderValueByProperty(jetProperty);
        }
    }

    private void get(JetProperty jetProperty, JetProperty jetProperty2) {
        jetProperty.setObject(jetProperty2.getValue());
    }

    private void getAdjSibling(JetProperty jetProperty, CSSValue cSSValue) {
        if (cSSValue.getCssValueType() == 1) {
            CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSValue;
            String string = cSSPrimitiveValue.getStringValue();
            if (string != null && string.length() > 3 && string.startsWith("@") && string.endsWith("@")) {
                jetProperty.setChangeByObject(string.substring(1, string.length() - 1));
                return;
            }
            short s = cSSPrimitiveValue.getPrimitiveType();
            switch (jetProperty.getPropType()) {
                case 6: 
                case 15: {
                    jetProperty.setObject(cSSPrimitiveValue.getStringValue());
                    break;
                }
                case 5: {
                    ((JetNumber)jetProperty).set(cSSPrimitiveValue.getFloatValue(cSSPrimitiveValue.getPrimitiveType()));
                    break;
                }
                case 4: {
                    int n = (int)cSSPrimitiveValue.getFloatValue(cSSPrimitiveValue.getPrimitiveType());
                    ((JetUnitNumber)jetProperty).setUnitValue(n);
                    break;
                }
                case 1: {
                    if (cSSPrimitiveValue.getStringValue().compareTo("true") == 0) {
                        jetProperty.setObject(new Boolean(true));
                        break;
                    }
                    if (cSSPrimitiveValue.getStringValue().compareTo("false") != 0) break;
                    jetProperty.setObject(new Boolean(false));
                    break;
                }
                case 2: {
                    if (s == 21) {
                        String string2 = cSSPrimitiveValue.getStringValue();
                        if (!string2.startsWith("#") && !string2.equals("Transparent")) break;
                        jetProperty.setObject(MiscTools._mapStringToColor(string2));
                        break;
                    }
                    if (s != 25) break;
                    RGBColor rGBColor = cSSPrimitiveValue.getRGBColorValue();
                    jetProperty.setObject(MiscTools._mapStringToColor(rGBColor.toString()));
                    break;
                }
                case 3: {
                    JetEnumeration jetEnumeration = (JetEnumeration)jetProperty;
                    jetEnumeration.setValue(cSSPrimitiveValue.getStringValue());
                    break;
                }
                case 9: {
                    String string3 = cSSPrimitiveValue.getStringValue();
                    string3 = string3.replaceAll("'", "\u0007");
                    int n = string3.indexOf("\u0007", 1);
                    string3 = string3.substring(n + 1);
                    ((JetVector)jetProperty).set(string3);
                    break;
                }
            }
            jetProperty.setCanChangeByOthers(false);
        }
    }

    private String getAncestor(JetRptObject jetRptObject) {
        String string = UpgradeName.getInstancePrefixTag(jetRptObject);
        return string;
    }

    private boolean getAncestorSelector(CSSRuleKey cSSRuleKey, JetRptObject jetRptObject) {
        if (!cSSRuleKey.getSubject().equals("*") && !cSSRuleKey.getSubject().equals(this.getAncestor(jetRptObject))) {
            return false;
        }
        if (!this.getCondition(cSSRuleKey.getConditions(), jetRptObject)) {
            return false;
        }
        CSSRuleKey cSSRuleKey2 = null;
        if (cSSRuleKey.getAdjSibling() != null) {
            cSSRuleKey2 = cSSRuleKey.getAdjSibling();
            JetRptObject jetRptObject2 = this.getClass(jetRptObject);
            if (jetRptObject2 == null) {
                return false;
            }
            String string = this.getAncestor(jetRptObject2);
            if (cSSRuleKey2.getSubject().equals("*") || cSSRuleKey2.getSubject().equals(string)) {
                return this.getAncestorSelector(cSSRuleKey2, jetRptObject2);
            }
            return false;
        }
        if (cSSRuleKey.getAncestor() != null) {
            cSSRuleKey2 = cSSRuleKey.getAncestor();
            JetRptObject jetRptObject3 = this.getCSSStyleSheet(jetRptObject);
            while (jetRptObject3 != null) {
                String string = this.getAncestor(jetRptObject3);
                if (cSSRuleKey2.getSubject().equals("*") || cSSRuleKey2.getSubject().equals(string)) {
                    return this.getAncestorSelector(cSSRuleKey2, jetRptObject3);
                }
                jetRptObject3 = this.getCSSStyleSheet(jetRptObject3);
            }
            return false;
        }
        if (cSSRuleKey.getParent() != null) {
            cSSRuleKey2 = cSSRuleKey.getParent();
            JetRptObject jetRptObject4 = this.getCSSStyleSheet(jetRptObject);
            if (jetRptObject4 == null) {
                return false;
            }
            String string = this.getAncestor(jetRptObject4);
            if (cSSRuleKey2.getSubject().equals("*") || cSSRuleKey2.getSubject().equals(string)) {
                return this.getAncestorSelector(cSSRuleKey2, jetRptObject4);
            }
            return false;
        }
        return true;
    }

    private JetRptObject getCSSStyleSheet(JetObject jetObject) {
        JetRptObject jetRptObject = (JetRptObject)((Object)jetObject.getParent());
        if (jetRptObject instanceof Paragraph) {
            return this.getCSSStyleSheet(jetRptObject);
        }
        if (jetRptObject instanceof ReplaceElement) {
            return this.getCSSStyleSheet(jetRptObject);
        }
        return jetRptObject;
    }

    private JetRptObject getCSSStyleSheetManager(JetRptObject jetRptObject) {
        JetRptObject jetRptObject2 = (JetRptObject)((Object)jetRptObject.getParent());
        if (jetRptObject2 instanceof ReplaceElement) {
            JetRptObject jetRptObject3;
            JetRptObject jetRptObject4 = (JetRptObject)((Object)jetRptObject2.getParent());
            Vector vector = jetRptObject4.getChildren();
            int n = vector.indexOf(jetRptObject2);
            if (n > 0 && (jetRptObject3 = this.getChildren(vector, n - 1)) != null) {
                return ((ReplaceElement)((Object)jetRptObject3)).getObject();
            }
            jetRptObject3 = (JetRptObject)((Object)jetRptObject4.getParent());
            vector = jetRptObject3.getChildren();
            n = vector.indexOf(jetRptObject4);
            for (int i = n - 1; i >= 0; --i) {
                JetRptObject jetRptObject5 = (JetRptObject)vector.get(i);
                if (jetRptObject5 instanceof Paragraph) {
                    JetRptObject jetRptObject6 = this.getChildren(jetRptObject5.getChildren(), -1);
                    if (jetRptObject6 == null) continue;
                    return ((ReplaceElement)((Object)jetRptObject6)).getObject();
                }
                return jetRptObject5;
            }
            return null;
        }
        Vector vector = jetRptObject2.getChildren();
        int n = vector.indexOf(jetRptObject);
        if (n == -1 || n == 0) {
            return null;
        }
        return (JetRptObject)vector.elementAt(n - 1);
    }

    private JetRptObject getChildren(List list, int n) {
        int n2;
        int n3 = list.size();
        for (int i = n2 = n < 0 || n > n3 - 1 ? n3 - 1 : n; i >= 0; --i) {
            JetRptObject jetRptObject = (JetRptObject)list.get(i);
            if (!(jetRptObject instanceof ReplaceElement)) continue;
            return jetRptObject;
        }
        return null;
    }

    private JetRptObject getClass(JetRptObject jetRptObject) {
        return this.getCSSStyleSheetManager(jetRptObject);
    }

    private boolean getCondition(Condition condition, JetRptObject jetRptObject) {
        if (condition == null) {
            return true;
        }
        switch (condition.getConditionType()) {
            case 0: {
                return this.getCondition(((CombinatorCondition)condition).getFirstCondition(), jetRptObject) && this.getCondition(((CombinatorCondition)condition).getSecondCondition(), jetRptObject);
            }
            case 1: {
                return this.getCondition(((CombinatorCondition)condition).getFirstCondition(), jetRptObject) || this.getCondition(((CombinatorCondition)condition).getSecondCondition(), jetRptObject);
            }
            case 4: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                String string = attributeCondition.getLocalName();
                String string2 = attributeCondition.getValue();
                return this.getConditionType(jetRptObject, string, string2, attributeCondition.getConditionType());
            }
            case 9: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                return this.getConditionType(jetRptObject, "class", attributeCondition.getValue(), attributeCondition.getConditionType());
            }
            case 5: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                return this.getConditionType(jetRptObject, "id", attributeCondition.getValue(), attributeCondition.getConditionType());
            }
            case 8: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                return this.getConditionType(jetRptObject, attributeCondition.getLocalName(), attributeCondition.getValue(), attributeCondition.getConditionType());
            }
            case 6: {
                LangCondition langCondition = (LangCondition)condition;
                return this.getConditionType(jetRptObject, "lang", langCondition.getLang(), langCondition.getConditionType());
            }
            case 10: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                return this.getConditionType(jetRptObject, attributeCondition.getValue(), "true", attributeCondition.getConditionType());
            }
            case 3: {
                return this.getCssRules(jetRptObject);
            }
            case 7: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                return this.getConditionType(jetRptObject, attributeCondition.getLocalName(), attributeCondition.getValue(), attributeCondition.getConditionType());
            }
        }
        System.out.println("[CSSHC]condition type = " + condition.getConditionType());
        return true;
    }

    private boolean getConditionType(JetRptObject jetRptObject, String string, String string2, int n) {
        JetProperty jetProperty = jetRptObject.nameToProperty(string);
        if (jetProperty == null) {
            return false;
        }
        String string3 = jetProperty.toUnitString();
        if (jetProperty != null) {
            switch (n) {
                case 7: {
                    return string3.indexOf(string2) != -1;
                }
                case 8: {
                    return string3.startsWith(string2 + "-");
                }
            }
            return string2.compareTo(string3) == 0;
        }
        return false;
    }

    private boolean getConditions(JetRptObject jetRptObject) {
        JetRptObject jetRptObject2 = (JetRptObject)((Object)jetRptObject.getParent());
        if (jetRptObject2 instanceof ReplaceElement) {
            JetRptObject jetRptObject3;
            JetRptObject jetRptObject4 = (JetRptObject)((Object)jetRptObject2.getParent());
            Vector vector = jetRptObject4.getChildren();
            int n = vector.indexOf(jetRptObject2);
            if (n > 0 && (jetRptObject3 = this.getChildren(vector, vector.indexOf(jetRptObject2) - 1)) != null) {
                return false;
            }
            jetRptObject3 = (JetRptObject)((Object)jetRptObject4.getParent());
            Vector vector2 = jetRptObject3.getChildren();
            n = vector2.indexOf(jetRptObject4);
            for (int i = n - 1; i >= 0; --i) {
                JetRptObject jetRptObject5 = (JetRptObject)vector2.get(i);
                if (jetRptObject5 instanceof Paragraph) {
                    JetRptObject jetRptObject6 = this.getChildren(jetRptObject5.getChildren(), -1);
                    if (jetRptObject6 == null) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        Vector vector = jetRptObject2.getChildren();
        return vector.indexOf(jetRptObject) == 0;
    }

    private boolean getCssRules(JetRptObject jetRptObject) {
        return this.getConditions(jetRptObject);
    }
}

