/*
 * Decompiled with CFR 0.152.
 */
package jet.css;

import com.jinfonet.css.regularlib.CSSRegulationLibV8;
import com.jinfonet.css.regularlib.CSSRegulationV8;
import com.jinfonet.css.regularlib.SelectorKeyWord;
import com.jinfonet.css.sac.impl.JRLexicalUnitImpl;
import com.jinfonet.css.sac.impl.JRSelectorListImpl;
import com.jinfonet.css.util.SupportColor;
import com.jinfonet.css.util.W3CStyleSheetConvert;
import com.jinfonet.dom.css.JCSSProperty;
import com.jinfonet.dom.css.JCSSRuleList;
import com.jinfonet.dom.css.JCSSStyleDeclaration;
import com.jinfonet.dom.css.JCSSStyleRule;
import com.jinfonet.dom.css.JCSSStyleSheet;
import com.jinfonet.dom.css.impl.CSSValueImpl;
import com.jinfonet.dom.css.impl.JCSSPropertyImpl;
import com.jinfonet.dom.css.impl.JCSSRuleListImpl;
import com.jinfonet.dom.css.impl.JCSSStyleDeclarationImpl;
import com.jinfonet.dom.css.impl.JCSSStyleRuleImpl;
import com.jinfonet.dom.css.impl.JCSSStyleSheetImpl;
import com.jinfonet.util.JRLog;
import com.jinfonet.validation.NoError;
import com.jinfonet.validation.ValidationContext;
import com.jinfonet.validation.ValidationError;
import com.jinfonet.validation.ValidationException;
import com.jinfonet.validation.Validator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.css.CSSStyleSheetValidateContext;
import jet.css.JCSSValidatorErrorHandler;
import jet.util.JStringToolKit;
import jet.util.ValueToUnit;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;
import org.w3c.dom.css.RGBColor;

public class CSSStyleSheetValidator
extends Validator {
    JCSSValidatorErrorHandler curErrHandler = null;
    static volatile Map regLib = null;
    static volatile CSSRegulationV8 universalReg = null;

    @Override
    protected ValidationError check(ValidationContext validationContext) {
        CSSStyleSheetValidateContext cSSStyleSheetValidateContext = (CSSStyleSheetValidateContext)validationContext;
        CSSStyleSheet cSSStyleSheet = cSSStyleSheetValidateContext.input;
        cSSStyleSheetValidateContext.output = this.validate(cSSStyleSheet);
        return NoError.getInstance();
    }

    @Override
    protected void handleValidationError(ValidationError validationError) throws ValidationException {
    }

    public CSSStyleSheetValidator() {
        if (regLib == null) {
            regLib = CSSRegulationLibV8.getRegulationLibHash();
        }
        if (universalReg == null) {
            universalReg = CSSRegulationLibV8.getUniversalRegulartion();
        }
    }

    public JCSSValidatorErrorHandler setValidateErrorHandler(JCSSValidatorErrorHandler jCSSValidatorErrorHandler) {
        JCSSValidatorErrorHandler jCSSValidatorErrorHandler2 = this.curErrHandler;
        this.curErrHandler = jCSSValidatorErrorHandler;
        return jCSSValidatorErrorHandler2;
    }

    public synchronized JCSSStyleSheet validate(CSSStyleSheet cSSStyleSheet) {
        Object object;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6205207, new String[]{String.valueOf(cSSStyleSheet)});
        }
        JCSSRuleListImpl jCSSRuleListImpl = new JCSSRuleListImpl();
        JCSSStyleSheet jCSSStyleSheet = null;
        if (cSSStyleSheet instanceof JCSSStyleSheet) {
            jCSSStyleSheet = (JCSSStyleSheet)cSSStyleSheet;
        } else if (cSSStyleSheet != null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6205208);
            }
            jCSSStyleSheet = (JCSSStyleSheet)new W3CStyleSheetConvert().convertW3CStyleSheet(cSSStyleSheet);
        } else {
            jCSSStyleSheet = null;
        }
        if (jCSSStyleSheet != null) {
            object = jCSSStyleSheet.getCssRules();
            int n = object.getLength();
            for (int i = 0; i < n; ++i) {
                CSSRule cSSRule = object.item(i);
                if (cSSRule.getType() != 1) {
                    if (this.curErrHandler != null) {
                        this.curErrHandler.unsupportedRule(cSSRule);
                    }
                    JRLog.trace(5, 5205005, new String[]{cSSRule.getCssText(), String.valueOf(cSSRule.getType())});
                    continue;
                }
                JCSSStyleRule jCSSStyleRule = (JCSSStyleRule)cSSRule;
                SelectorList selectorList = this.SEDU(jCSSStyleRule);
                if (selectorList.getLength() == 0) continue;
                this.addProperty(jCSSRuleListImpl, selectorList, jCSSStyleRule);
            }
        }
        object = new JCSSStyleSheetImpl();
        object.setRuleList(jCSSRuleListImpl);
        return object;
    }

    private SelectorList SEDU(JCSSStyleRule jCSSStyleRule) {
        SelectorList selectorList = jCSSStyleRule.getSelectors();
        JRSelectorListImpl jRSelectorListImpl = new JRSelectorListImpl();
        int n = selectorList.getLength();
        for (int i = 0; i < n; ++i) {
            Selector selector = selectorList.item(i);
            if (this.add(selector)) {
                jRSelectorListImpl.addSelector(selector);
                continue;
            }
            if (this.curErrHandler != null) {
                this.curErrHandler.unsupportedSelector(jCSSStyleRule, selector);
            }
            if (!JRLog.isTrace(5)) continue;
            JRLog.trace(5, 5205006, new String[]{selector.toString(), jCSSStyleRule.getCssText()});
        }
        return jRSelectorListImpl;
    }

    private boolean add(Selector selector) {
        switch (selector.getSelectorType()) {
            case 4: {
                ElementSelector elementSelector = (ElementSelector)selector;
                return SelectorKeyWord.getSelectorID(elementSelector.getLocalName() == null ? "*" : elementSelector.getLocalName()) != Integer.MIN_VALUE;
            }
            case 0: {
                return this.add((Selector)((ConditionalSelector)selector).getSimpleSelector());
            }
            case 12: {
                return this.add((Selector)((SiblingSelector)selector).getSiblingSelector()) && this.add(((SiblingSelector)selector).getSelector());
            }
            case 10: 
            case 11: {
                return this.add((Selector)((DescendantSelector)selector).getSimpleSelector()) && this.add(((DescendantSelector)selector).getAncestorSelector());
            }
        }
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, 5205008, new String[]{selector.toString(), String.valueOf(selector.getSelectorType())});
        }
        return false;
    }

    private int addAndMerge(Selector selector) {
        switch (selector.getSelectorType()) {
            case 4: {
                ElementSelector elementSelector = (ElementSelector)selector;
                return SelectorKeyWord.getSelectorID(elementSelector.getLocalName() == null ? "*" : elementSelector.getLocalName());
            }
            case 0: {
                return this.addAndMerge((Selector)((ConditionalSelector)selector).getSimpleSelector());
            }
            case 12: {
                return this.addAndMerge((Selector)((SiblingSelector)selector).getSiblingSelector());
            }
            case 10: 
            case 11: {
                return this.addAndMerge((Selector)((DescendantSelector)selector).getSimpleSelector());
            }
        }
        return Integer.MIN_VALUE;
    }

    private void addProperty(JCSSRuleList jCSSRuleList, SelectorList selectorList, JCSSStyleRule jCSSStyleRule) {
        int n;
        Vector<Integer> vector = new Vector<Integer>();
        Vector<JCSSStyleRuleImpl> vector2 = new Vector<JCSSStyleRuleImpl>();
        for (int i = 0; i < selectorList.getLength(); ++i) {
            Selector selector = selectorList.item(i);
            int n2 = this.addAndMerge(selector);
            JCSSStyleRuleImpl jCSSStyleRuleImpl = new JCSSStyleRuleImpl(null, null, selector);
            jCSSStyleRuleImpl.setStyle(new JCSSStyleDeclarationImpl(jCSSStyleRuleImpl));
            vector.add(n2);
            vector2.add(jCSSStyleRuleImpl);
        }
        JCSSStyleDeclaration jCSSStyleDeclaration = (JCSSStyleDeclaration)jCSSStyleRule.getStyle();
        for (n = 0; n < vector2.size(); ++n) {
            String string;
            JCSSProperty jCSSProperty;
            int n3;
            int n4;
            JCSSStyleRule jCSSStyleRule2 = (JCSSStyleRule)vector2.get(n);
            int n5 = (Integer)vector.get(n);
            CSSRegulationV8 cSSRegulationV8 = (CSSRegulationV8)CSSRegulationLibV8.getRegulationLibHash().get(n5);
            if (cSSRegulationV8 == null) {
                n4 = jCSSStyleDeclaration.getLength();
                for (n3 = 0; n3 < n4; ++n3) {
                    jCSSProperty = jCSSStyleDeclaration.itemAt(n3);
                    string = jCSSProperty.getName();
                    if (universalReg.getPropertyByName(string) != null) {
                        if (this.curErrHandler == null) continue;
                        this.curErrHandler.invalidProperty(jCSSStyleRule2, jCSSProperty);
                        continue;
                    }
                    if (this.curErrHandler == null) continue;
                    this.curErrHandler.unsupportedProperty(jCSSProperty);
                }
                continue;
            }
            n4 = jCSSStyleDeclaration.getLength();
            for (n3 = 0; n3 < n4; ++n3) {
                jCSSProperty = jCSSStyleDeclaration.itemAt(n3);
                string = jCSSProperty.getName();
                CSSRegulationV8.Property property = cSSRegulationV8.getPropertyByName(string);
                if (property != null) {
                    if (this.append(property.getPropertyType(), jCSSProperty.getValue())) {
                        this.convertPixelToUnit((JCSSStyleDeclaration)jCSSStyleRule2.getStyle(), jCSSProperty, property);
                        continue;
                    }
                    if (this.curErrHandler != null) {
                        this.curErrHandler.invalidValue(jCSSStyleRule2, jCSSProperty);
                    }
                    if (!JRLog.isTrace(5)) continue;
                    JRLog.trace(5, 5205004, new String[]{jCSSProperty.getValue().getCssText(), jCSSProperty.getName(), jCSSStyleRule2.getSelectorText()});
                    continue;
                }
                if (universalReg.getPropertyByName(string) != null) {
                    if (this.curErrHandler == null) continue;
                    this.curErrHandler.invalidProperty(jCSSStyleRule2, jCSSProperty);
                    continue;
                }
                if (this.curErrHandler == null) continue;
                this.curErrHandler.unsupportedProperty(jCSSProperty);
            }
        }
        for (n = 0; n < vector2.size(); ++n) {
            CSSStyleRule cSSStyleRule = (CSSStyleRule)vector2.get(n);
            if (cSSStyleRule.getStyle() == null || cSSStyleRule.getStyle().getLength() == 0) continue;
            jCSSRuleList.addAndMerge(cSSStyleRule);
        }
    }

    private boolean addSelector(int n, CSSValue cSSValue) {
        if (cSSValue.getCssValueType() == 1) {
            if ((n & 0x10) == 16) {
                return this.convertCentimeterToUnit((CSSPrimitiveValue)cSSValue);
            }
            if ((n & 0x40) == 64) {
                return this.convertInchToUnit((CSSPrimitiveValue)cSSValue);
            }
            if ((n & 0x20) == 32) {
                return this.convertMillimeterToUnit((CSSPrimitiveValue)cSSValue);
            }
            if ((n & 0x80) == 128) {
                return this.convertPicaToUnit((CSSPrimitiveValue)cSSValue);
            }
            return false;
        }
        return false;
    }

    private boolean append(int n, CSSValue cSSValue) {
        if ((n & 0x2000) == 8192) {
            return this.addSelector(n, cSSValue);
        }
        if ((n & 0x4000) == 16384) {
            if (cSSValue.getCssValueType() == 2) {
                CSSValueList cSSValueList = (CSSValueList)cSSValue;
                int n2 = cSSValueList.getLength();
                if ((n & 0x10) == 16) {
                    for (int i = 0; i < n2; ++i) {
                        CSSValue cSSValue2 = cSSValueList.item(i);
                        if (cSSValue2.getCssValueType() != 1) {
                            return false;
                        }
                        if (this.convertCentimeterToUnit((CSSPrimitiveValue)cSSValue2)) continue;
                        return false;
                    }
                    return true;
                }
                if ((n & 0x40) == 64) {
                    for (int i = 0; i < n2; ++i) {
                        CSSValue cSSValue3 = cSSValueList.item(i);
                        if (cSSValue3.getCssValueType() != 1) {
                            return false;
                        }
                        if (this.convertInchToUnit((CSSPrimitiveValue)cSSValue3)) continue;
                        return false;
                    }
                    return true;
                }
                if ((n & 0x20) == 32) {
                    for (int i = 0; i < n2; ++i) {
                        CSSValue cSSValue4 = cSSValueList.item(i);
                        if (cSSValue4.getCssValueType() != 1) {
                            return false;
                        }
                        if (this.convertMillimeterToUnit((CSSPrimitiveValue)cSSValue4)) continue;
                        return false;
                    }
                    return true;
                }
                if ((n & 0x80) == 128) {
                    for (int i = 0; i < n2; ++i) {
                        CSSValue cSSValue5 = cSSValueList.item(i);
                        if (cSSValue5.getCssValueType() != 1) {
                            return false;
                        }
                        if (this.convertPicaToUnit((CSSPrimitiveValue)cSSValue5)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return this.addSelector(n, cSSValue);
        }
        if ((n & 0x8000) == 32768) {
            return false;
        }
        return this.addSelector(n, cSSValue);
    }

    private boolean convertCentimeterToUnit(CSSPrimitiveValue cSSPrimitiveValue) {
        switch (cSSPrimitiveValue.getPrimitiveType()) {
            case 3: 
            case 4: {
                return false;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    private boolean convertInchToUnit(CSSPrimitiveValue cSSPrimitiveValue) {
        switch (cSSPrimitiveValue.getPrimitiveType()) {
            case 19: 
            case 21: {
                String string = cSSPrimitiveValue.getStringValue();
                return string.equalsIgnoreCase("Transparent") || SupportColor.isDefinedColorIdent(string);
            }
            case 25: {
                RGBColor rGBColor = cSSPrimitiveValue.getRGBColorValue();
                return rGBColor.getRed().getPrimitiveType() == 1 && rGBColor.getGreen().getPrimitiveType() == 1 && rGBColor.getBlue().getPrimitiveType() == 1;
            }
        }
        return false;
    }

    private boolean convertMillimeterToUnit(CSSPrimitiveValue cSSPrimitiveValue) {
        return cSSPrimitiveValue.getPrimitiveType() != 0;
    }

    private boolean convertPicaToUnit(CSSPrimitiveValue cSSPrimitiveValue) {
        switch (cSSPrimitiveValue.getPrimitiveType()) {
            case 19: 
            case 21: {
                String string = cSSPrimitiveValue.getStringValue();
                return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false");
            }
        }
        return false;
    }

    private void convertPixelToUnit(JCSSStyleDeclaration jCSSStyleDeclaration, JCSSProperty jCSSProperty, CSSRegulationV8.Property property) {
        int n = property.getPropertyType();
        CSSValue cSSValue = jCSSProperty.getValue();
        List list = property.getAdvanceMappingTo();
        if ((n & 0x2000) == 8192) {
            if (cSSValue.getCssValueType() == 1) {
                jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl((String)list.get(0), this.convertPointToUnit(n -= 8192, cSSValue), jCSSProperty.isImportant()));
            }
        } else if ((n & 0x4000) == 16384) {
            CSSValueList cSSValueList = (CSSValueList)cSSValue;
            switch (cSSValueList.getLength()) {
                case 1: {
                    jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl((String)list.get(0), this.convertPointToUnit(n, cSSValueList.item(0)), jCSSProperty.isImportant()));
                    jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl((String)list.get(1), this.convertPointToUnit(n, cSSValueList.item(0)), jCSSProperty.isImportant()));
                    jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl((String)list.get(2), this.convertPointToUnit(n, cSSValueList.item(0)), jCSSProperty.isImportant()));
                    jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl((String)list.get(3), this.convertPointToUnit(n, cSSValueList.item(0)), jCSSProperty.isImportant()));
                    break;
                }
                case 2: {
                    jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl((String)list.get(0), this.convertPointToUnit(n, cSSValueList.item(0)), jCSSProperty.isImportant()));
                    jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl((String)list.get(1), this.convertPointToUnit(n, cSSValueList.item(1)), jCSSProperty.isImportant()));
                    jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl((String)list.get(2), this.convertPointToUnit(n, cSSValueList.item(0)), jCSSProperty.isImportant()));
                    jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl((String)list.get(3), this.convertPointToUnit(n, cSSValueList.item(1)), jCSSProperty.isImportant()));
                    break;
                }
                case 3: {
                    jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl((String)list.get(0), this.convertPointToUnit(n, cSSValueList.item(0)), jCSSProperty.isImportant()));
                    jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl((String)list.get(1), this.convertPointToUnit(n, cSSValueList.item(1)), jCSSProperty.isImportant()));
                    jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl((String)list.get(2), this.convertPointToUnit(n, cSSValueList.item(2)), jCSSProperty.isImportant()));
                    jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl((String)list.get(3), this.convertPointToUnit(n, cSSValueList.item(1)), jCSSProperty.isImportant()));
                    break;
                }
                case 4: {
                    jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl((String)list.get(0), this.convertPointToUnit(n, cSSValueList.item(0)), jCSSProperty.isImportant()));
                    jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl((String)list.get(1), this.convertPointToUnit(n, cSSValueList.item(1)), jCSSProperty.isImportant()));
                    jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl((String)list.get(2), this.convertPointToUnit(n, cSSValueList.item(2)), jCSSProperty.isImportant()));
                    jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl((String)list.get(3), this.convertPointToUnit(n, cSSValueList.item(3)), jCSSProperty.isImportant()));
                }
            }
        } else if ((n & 0x8000) != 32768) {
            if (property.getPropertyID() == 332) {
                jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl("border-top-width", this.convertPointToUnit(17, cSSValue), jCSSProperty.isImportant()));
                jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl("border-left-width", this.convertPointToUnit(17, cSSValue), jCSSProperty.isImportant()));
                jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl("border-bottom-width", this.convertPointToUnit(17, cSSValue), jCSSProperty.isImportant()));
                jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl("border-right-width", this.convertPointToUnit(17, cSSValue), jCSSProperty.isImportant()));
                jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl("BorderWidth", this.convertPointToUnit(17, cSSValue), jCSSProperty.isImportant()));
            } else if (property.getPropertyID() == 329) {
                jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl("border-top-color", this.convertPointToUnit(64, cSSValue), jCSSProperty.isImportant()));
                jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl("border-left-color", this.convertPointToUnit(64, cSSValue), jCSSProperty.isImportant()));
                jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl("border-bottom-color", this.convertPointToUnit(64, cSSValue), jCSSProperty.isImportant()));
                jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl("border-right-color", this.convertPointToUnit(64, cSSValue), jCSSProperty.isImportant()));
                jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl("BorderColor", this.convertPointToUnit(64, cSSValue), jCSSProperty.isImportant()));
            } else {
                jCSSStyleDeclaration.addProperty(new JCSSPropertyImpl(jCSSProperty.getName(), this.convertPointToUnit(n, jCSSProperty.getValue()), jCSSProperty.isImportant()));
            }
        }
    }

    private CSSPrimitiveValue convertPointToUnit(int n, CSSValue cSSValue) {
        CSSPrimitiveValue cSSPrimitiveValue;
        if (cSSValue.getCssValueType() != 1) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2505025);
            }
            return new CSSValueImpl(JRLexicalUnitImpl.createIdent(null, cSSValue.toString()));
        }
        CSSPrimitiveValue cSSPrimitiveValue2 = cSSPrimitiveValue = (CSSPrimitiveValue)cSSValue;
        short s = cSSPrimitiveValue.getPrimitiveType();
        switch (s) {
            case 1: {
                cSSPrimitiveValue2 = new CSSValueImpl(JRLexicalUnitImpl.createIdent(null, cSSPrimitiveValue.getCssText()));
                break;
            }
            case 5: {
                float f = cSSPrimitiveValue.getFloatValue(s);
                String string = String.valueOf((int)ValueToUnit.convertPixelToUnit(f));
                cSSPrimitiveValue2 = new CSSValueImpl(JRLexicalUnitImpl.createIdent(null, string));
                break;
            }
            case 8: {
                float f = cSSPrimitiveValue.getFloatValue(s);
                String string = String.valueOf(ValueToUnit.convertInchToUnit(f));
                cSSPrimitiveValue2 = new CSSValueImpl(JRLexicalUnitImpl.createIdent(null, string));
                break;
            }
            case 6: {
                float f = cSSPrimitiveValue.getFloatValue(s);
                String string = String.valueOf(ValueToUnit.convertCentimeterToUnit(f));
                cSSPrimitiveValue2 = new CSSValueImpl(JRLexicalUnitImpl.createIdent(null, string));
                break;
            }
            case 7: {
                float f = cSSPrimitiveValue.getFloatValue(s);
                String string = String.valueOf((int)ValueToUnit.convertMillimeterToUnit(f));
                cSSPrimitiveValue2 = new CSSValueImpl(JRLexicalUnitImpl.createIdent(null, string));
                break;
            }
            case 9: {
                float f = cSSPrimitiveValue.getFloatValue(s);
                String string = String.valueOf((int)ValueToUnit.convertPointToUnit(f));
                cSSPrimitiveValue2 = new CSSValueImpl(JRLexicalUnitImpl.createIdent(null, string));
                break;
            }
            case 10: {
                float f = cSSPrimitiveValue.getFloatValue(s);
                String string = String.valueOf((int)ValueToUnit.convertPicaToUnit(f));
                cSSPrimitiveValue2 = new CSSValueImpl(JRLexicalUnitImpl.createIdent(null, string));
                break;
            }
            case 19: 
            case 21: {
                String string = cSSPrimitiveValue.getStringValue();
                if ((n & 0x40) == 64) {
                    if (string.equalsIgnoreCase("Transparent")) {
                        cSSPrimitiveValue2 = new CSSValueImpl(JRLexicalUnitImpl.createIdent(null, "Transparent"));
                        break;
                    }
                    cSSPrimitiveValue2 = new CSSValueImpl(JRLexicalUnitImpl.createIdent(null, SupportColor.toRGBHex(string)));
                    break;
                }
                if ((n & 0x22) == 34) {
                    int n2 = string.indexOf(39, 1);
                    string = string.substring(n2 + 1);
                    string = JStringToolKit.replaceAll(string, "'", String.valueOf('\u0007'));
                    cSSPrimitiveValue2 = new CSSValueImpl(JRLexicalUnitImpl.createIdent(null, SupportColor.toRGBHex(string)));
                    break;
                }
                cSSPrimitiveValue2 = new CSSValueImpl(JRLexicalUnitImpl.createIdent(null, string));
                break;
            }
            case 20: 
            case 22: {
                String string = cSSPrimitiveValue.getStringValue();
                cSSPrimitiveValue2 = new CSSValueImpl(JRLexicalUnitImpl.createIdent(null, string));
                break;
            }
            case 25: {
                RGBColor rGBColor = cSSPrimitiveValue.getRGBColorValue();
                String string = Integer.toHexString((int)rGBColor.getRed().getFloatValue((short)1));
                String string2 = Integer.toHexString((int)rGBColor.getGreen().getFloatValue((short)1));
                String string3 = Integer.toHexString((int)rGBColor.getBlue().getFloatValue((short)1));
                if (string.length() < 2) {
                    string = "0" + string;
                }
                if (string2.length() < 2) {
                    string2 = "0" + string2;
                }
                if (string3.length() < 2) {
                    string3 = "0" + string3;
                }
                cSSPrimitiveValue2 = new CSSValueImpl(JRLexicalUnitImpl.createIdent(null, "0x" + string + string2 + string3));
                break;
            }
            default: {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2205026);
                }
                cSSPrimitiveValue2 = new CSSValueImpl(JRLexicalUnitImpl.createIdent(null, cSSValue.toString()));
            }
        }
        return cSSPrimitiveValue2;
    }
}

