/*
 * Decompiled with CFR 0.152.
 */
package jet.css;

import com.jinfonet.css.sac.impl.parser.JCSSDOMParser;
import com.jinfonet.css.util.XSDStyleConvert;
import com.jinfonet.dom.css.JCSSStyleSheet;
import com.jinfonet.util.JRLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jet.ReportEnv;
import jet.controls.JetObject;
import jet.css.CSSStyleSheetValidator;
import jet.css.JCSSException;
import jet.css.util.GetModifiedProps;
import jet.css.util.GetUsedIdClsCondition;
import jet.report.JRObjectTemplate;
import jet.report.chart.JetRptChartLineNodePattern;
import jet.universe.JetUStyleGroup;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.css.CSSStyleSheet;
import org.xml.sax.SAXException;

public class CssStyleSheetManager {
    private static Hashtable Class = new Hashtable();
    private static Hashtable SEDU = new Hashtable();
    private static Hashtable add = new Hashtable();
    public static final String STYLEGROUP_TAG = "*";
    public static final String CSSSTYLE_TAG = "<CSS>";
    public static final String NONE_STYLEUSE = "None";
    static JCSSDOMParser parser = null;
    private XSDStyleConvert addAll = null;
    static volatile CssStyleSheetManager manager = null;

    public Hashtable getModifiedProperties(JCSSStyleSheet jCSSStyleSheet, JetObject jetObject) {
        return this.getModifiedProperties(jCSSStyleSheet, jetObject, true);
    }

    public Hashtable getModifiedProperties(JCSSStyleSheet jCSSStyleSheet, JetObject jetObject, boolean bl) {
        Hashtable hashtable = new Hashtable();
        Thread thread = new Thread((Runnable)new GetModifiedProps(hashtable, jCSSStyleSheet, jetObject), "GetModifiedProps");
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return hashtable;
    }

    public void fillIdClassCondition(JCSSStyleSheet jCSSStyleSheet, JRObjectTemplate jRObjectTemplate) {
        if (this.Class(jRObjectTemplate)) {
            return;
        }
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        new GetUsedIdClsCondition(hashSet, hashSet2, jCSSStyleSheet, jRObjectTemplate).run();
        jRObjectTemplate.id.setList(new Vector(hashSet));
        jRObjectTemplate.Class.setList(new Vector(hashSet2));
    }

    private boolean Class(JRObjectTemplate jRObjectTemplate) {
        return jRObjectTemplate instanceof JetRptChartLineNodePattern;
    }

    public Hashtable getModifiedProperties(Reader reader, JetObject jetObject) throws JCSSException {
        return this.getModifiedProperties(reader, jetObject, true);
    }

    public Hashtable getModifiedProperties(Reader reader, JetObject jetObject, boolean bl) throws JCSSException {
        JCSSStyleSheet jCSSStyleSheet = this.getCanUsedStyleSheet(reader);
        return this.getModifiedProperties(jCSSStyleSheet, jetObject, bl);
    }

    public boolean canUseThisStyle(File file) {
        try {
            JCSSStyleSheet jCSSStyleSheet = this.getCanUsedStyleSheet(file);
            return jCSSStyleSheet != null && jCSSStyleSheet.getCssRules() != null && jCSSStyleSheet.getCssRules().getLength() > 0;
        }
        catch (JCSSException jCSSException) {
            return false;
        }
    }

    public boolean canUseThisStyle(JetUStyleGroup jetUStyleGroup) {
        try {
            JCSSStyleSheet jCSSStyleSheet = this.SEDU(jetUStyleGroup);
            return jCSSStyleSheet != null && jCSSStyleSheet.getCssRules() != null && jCSSStyleSheet.getCssRules().getLength() > 0;
        }
        catch (JCSSException jCSSException) {
            return false;
        }
    }

    public JCSSStyleSheet getCanUsedStyleSheet(Reader reader) throws JCSSException {
        CSSStyleSheet cSSStyleSheet = this.getCSSStyleSheet(reader);
        CSSStyleSheetValidator cSSStyleSheetValidator = CssStyleSheetManager.createJCSSValidatorInstance();
        return cSSStyleSheetValidator.validate(cSSStyleSheet);
    }

    public JCSSStyleSheet getCanUsedStyleSheet(File file) throws JCSSException {
        JCSSStyleSheet jCSSStyleSheet = (JCSSStyleSheet)add.get(file);
        if (jCSSStyleSheet == null) {
            CSSStyleSheet cSSStyleSheet = this.getCSSStyleSheet(file);
            CSSStyleSheetValidator cSSStyleSheetValidator = CssStyleSheetManager.createJCSSValidatorInstance();
            jCSSStyleSheet = cSSStyleSheetValidator.validate(cSSStyleSheet);
            add.put(file, jCSSStyleSheet);
        } else {
            long l = file.lastModified();
            Long l2 = (Long)SEDU.get(file);
            if (l2 == null || l > l2) {
                CSSStyleSheet cSSStyleSheet = this.getCSSStyleSheet(file);
                CSSStyleSheetValidator cSSStyleSheetValidator = CssStyleSheetManager.createJCSSValidatorInstance();
                jCSSStyleSheet = cSSStyleSheetValidator.validate(cSSStyleSheet);
                add.put(file, jCSSStyleSheet);
            }
        }
        return jCSSStyleSheet;
    }

    private JCSSStyleSheet SEDU(JetUStyleGroup jetUStyleGroup) throws JCSSException {
        if (this.addAll == null) {
            this.addAll = XSDStyleConvert.newInstance();
        }
        return (JCSSStyleSheet)this.addAll.convertToCssStyleSheet(jetUStyleGroup);
    }

    public CSSStyleSheet getCSSStyleSheet(Reader reader) throws JCSSException {
        CSSStyleSheet cSSStyleSheet = null;
        try {
            cSSStyleSheet = parser.parseStyleSheet(new InputSource(reader));
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2205003, iOException.getMessage());
            }
            throw new JCSSException(210502);
        }
        return cSSStyleSheet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSSStyleSheet getCSSStyleSheet(File file) throws JCSSException {
        String string = file.getName();
        if (CssStyleSheetManager.add(string)) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6205200, new String[]{string});
            }
            CSSStyleSheet cSSStyleSheet = (CSSStyleSheet)Class.get(file);
            long l = file.lastModified();
            Long l2 = (Long)SEDU.get(file);
            if (cSSStyleSheet == null || l > l2) {
                FileReader fileReader = null;
                try {
                    fileReader = new FileReader(file);
                    cSSStyleSheet = parser.parseStyleSheet(new InputSource((Reader)fileReader));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, 2205006, string);
                    }
                }
                catch (IOException iOException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, 2205003);
                    }
                }
                finally {
                    if (fileReader != null) {
                        try {
                            ((Reader)fileReader).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (cSSStyleSheet != null) {
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, 6205201);
                    }
                    Class.put(file, cSSStyleSheet);
                    SEDU.put(file, new Long(l));
                    add.remove(file);
                }
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6205203, new String[]{string});
            }
            return cSSStyleSheet;
        }
        if (CssStyleSheetManager.addAll(string)) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6205204, new String[]{string});
            }
            CSSStyleSheet cSSStyleSheet = (CSSStyleSheet)Class.get(file);
            long l = file.lastModified();
            Long l3 = (Long)SEDU.get(file);
            if (cSSStyleSheet == null || l > l3) {
                block37: {
                    if (this.addAll == null) {
                        this.addAll = XSDStyleConvert.newInstance();
                    }
                    try {
                        if (JRLog.isTrace(6)) {
                            JRLog.trace(6, 6205205);
                        }
                        cSSStyleSheet = this.addAll.convertToCssStyleSheet(file.getAbsolutePath());
                    }
                    catch (SAXException sAXException) {
                        if (JRLog.isError(2)) {
                            JRLog.error(2, 2205005, sAXException.getMessage());
                        }
                    }
                    catch (IOException iOException) {
                        if (!JRLog.isError(2)) break block37;
                        JRLog.error(2, 2205004, iOException.getMessage());
                    }
                }
                if (cSSStyleSheet != null) {
                    Class.put(file, cSSStyleSheet);
                    SEDU.put(file, new Long(l));
                    add.remove(file);
                }
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, 6205206, new String[]{string});
            }
            return cSSStyleSheet;
        }
        if (JRLog.isTrace(6)) {
            JRLog.error(2, 2205006, string);
        }
        return null;
    }

    private static boolean add(String string) {
        return string.toLowerCase().endsWith(".css");
    }

    private static boolean addAll(String string) {
        return string.toLowerCase().endsWith("_stl.xsd");
    }

    public synchronized void refreshCSSStyleSheet(File file) {
        String string = file.getName();
        if (Class.containsKey(file)) {
            long l = file.lastModified();
            CSSStyleSheet cSSStyleSheet = null;
            if (CssStyleSheetManager.add(string)) {
                block17: {
                    try {
                        cSSStyleSheet = parser.parseStyleSheet(new InputSource((Reader)new FileReader(string)));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (JRLog.isError(2)) {
                            JRLog.error(2, 2205006, string);
                        }
                    }
                    catch (IOException iOException) {
                        if (!JRLog.isError(2)) break block17;
                        JRLog.error(2, 2205003);
                    }
                }
                if (cSSStyleSheet != null) {
                    Class.put(file, cSSStyleSheet);
                    SEDU.put(file, new Long(l));
                    add.remove(file);
                }
            } else if (CssStyleSheetManager.addAll(string)) {
                block18: {
                    if (this.addAll == null) {
                        this.addAll = XSDStyleConvert.newInstance();
                    }
                    try {
                        cSSStyleSheet = this.addAll.convertToCssStyleSheet(string);
                    }
                    catch (SAXException sAXException) {
                        if (JRLog.isError(2)) {
                            JRLog.error(2, 2205005, sAXException.getMessage());
                        }
                    }
                    catch (IOException iOException) {
                        if (!JRLog.isError(2)) break block18;
                        JRLog.error(2, 2205004, iOException.getMessage());
                    }
                }
                if (cSSStyleSheet != null) {
                    Class.put(file, cSSStyleSheet);
                    SEDU.put(file, new Long(l));
                    add.remove(file);
                }
            } else if (JRLog.isError(2)) {
                JRLog.error(2, 2205006, string);
            }
        }
    }

    public static CSSStyleSheetValidator createJCSSValidatorInstance() {
        return new CSSStyleSheetValidator();
    }

    public static List getSupportStyleNameList() {
        String string = ReportEnv.stylePath != null ? ReportEnv.stylePath : System.getProperty("reporthome") + File.separator + "style";
        File file = new File(string);
        File[] fileArray = file.listFiles();
        Vector<String> vector = new Vector<String>();
        vector.add(NONE_STYLEUSE);
        if (fileArray != null && fileArray.length > 0) {
            Vector<String> vector2 = new Vector<String>();
            Vector<String> vector3 = new Vector<String>();
            for (int i = 0; i < fileArray.length; ++i) {
                String string2;
                String string3 = fileArray[i].getName();
                if (CssStyleSheetManager.add(string3)) {
                    string2 = string3.substring(0, string3.length() - ".css".length());
                    vector3.add(string2.concat(CSSSTYLE_TAG));
                    continue;
                }
                if (!CssStyleSheetManager.addAll(string3)) continue;
                string2 = string3.substring(0, string3.length() - "_stl.xsd".length());
                vector2.add(string2.concat(STYLEGROUP_TAG));
            }
            vector.addAll(vector3);
            vector.addAll(vector2);
        } else if (JRLog.isError(2)) {
            JRLog.error(2, 2205024, file);
        }
        return vector;
    }

    public static String getSuportStyleFullPath(String string) {
        String string2;
        if (string.compareTo(NONE_STYLEUSE) == 0) {
            return null;
        }
        String string3 = "";
        string3 = string.endsWith(STYLEGROUP_TAG) ? string.substring(0, string.length() - STYLEGROUP_TAG.length()).concat("_stl.xsd") : string.substring(0, string.length() - CSSSTYLE_TAG.length()).concat(".css");
        String string4 = string2 = ReportEnv.stylePath != null ? ReportEnv.stylePath : System.getProperty("reporthome") + File.separator + "style";
        if (!string2.endsWith(File.separator)) {
            string2 = string2.concat(File.separator);
        }
        if (new File(string2 + string3).exists()) {
            return string2 + string3;
        }
        return null;
    }

    CssStyleSheetManager() {
        parser = JCSSDOMParser.newInstance();
    }

    public static CssStyleSheetManager getCSSStyleSheetManager() {
        if (manager == null) {
            manager = new CssStyleSheetManager();
        }
        return manager;
    }
}

