/*
 * Decompiled with CFR 0.152.
 */
package jet.css.util;

import com.jinfonet.css.regularlib.SelectorKeyWord;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetVector;
import jet.css.CSSLibraryTool;
import jet.css.util.SelectorPRI;
import jet.report.JetRptObject;
import jet.report.chart.JetRptChartPlatform;
import jet.report.paragraph.build.JetRptParaReplaceElement;
import jet.report.paragraph.build.JetRptParaStyleElement;
import jet.report.paragraph.build.JetRptParagraph;
import jet.reportLogic.objectLogic.paragraphLogic.Paragraph;
import jet.reportLogic.objectLogic.paragraphLogic.ReplaceElement;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SiblingSelector;

public class SelectorToolkit {
    protected static boolean isCanUsedTo(Selector selector, JetObject jetObject) {
        if (jetObject == null) {
            return false;
        }
        switch (selector.getSelectorType()) {
            case 11: {
                return SelectorToolkit.isCanUsedTo((Selector)((DescendantSelector)selector).getSimpleSelector(), jetObject) && SelectorToolkit.isCanUsedTo(((DescendantSelector)selector).getAncestorSelector(), SelectorToolkit.getCanUsedParent(jetObject));
            }
            case 10: {
                if (SelectorToolkit.isCanUsedTo((Selector)((DescendantSelector)selector).getSimpleSelector(), jetObject)) {
                    JetObject jetObject2 = SelectorToolkit.getCanUsedParent(jetObject);
                    Selector selector2 = ((DescendantSelector)selector).getAncestorSelector();
                    while (jetObject2 != null) {
                        if (SelectorToolkit.isCanUsedTo(selector2, jetObject2)) {
                            return true;
                        }
                        jetObject2 = SelectorToolkit.getCanUsedParent(jetObject2);
                    }
                    return false;
                }
                return false;
            }
            case 12: {
                return SelectorToolkit.isCanUsedTo((Selector)((SiblingSelector)selector).getSiblingSelector(), jetObject) && SelectorToolkit.isCanUsedTo(((SiblingSelector)selector).getSelector(), SelectorToolkit.getCanUsedBrother(jetObject));
            }
            case 4: {
                int n;
                String string = ((ElementSelector)selector).getLocalName();
                if (string == null) {
                    return true;
                }
                int n2 = CSSLibraryTool.getSelectorIDForJClass(jetObject.getClass().getName());
                return n2 == (n = SelectorKeyWord.getSelectorID(string));
            }
            case 0: {
                return SelectorToolkit.isCanUsedTo((Selector)((ConditionalSelector)selector).getSimpleSelector(), jetObject) && SelectorToolkit.isFitConditions(((ConditionalSelector)selector).getCondition(), jetObject);
            }
        }
        return false;
    }

    protected static boolean isFitConditions(Condition condition, JetObject jetObject) {
        short s = condition.getConditionType();
        if (condition instanceof AttributeCondition) {
            String string = ((AttributeCondition)condition).getLocalName();
            String string2 = ((AttributeCondition)condition).getValue();
            String string3 = null;
            if (s == 5) {
                string3 = SelectorToolkit.SEDU(jetObject, "id");
                return string3 != null && string3.equalsIgnoreCase(string2);
            }
            if (s == 9) {
                string3 = SelectorToolkit.SEDU(jetObject, "class");
                return string3 != null && string3.equalsIgnoreCase(string2);
            }
            if (s == 10) {
                return false;
            }
            JetProperty jetProperty = SelectorToolkit.getObjProperty(jetObject, string);
            switch (s) {
                case 4: {
                    return jetProperty != null && (string2 == null || !jetProperty.isChangeByOther() && string2.equals(jetProperty.toUnitString()));
                }
                case 8: {
                    if (jetProperty == null || jetProperty.isChangeByOther()) {
                        return false;
                    }
                    String string4 = jetProperty.toUnitString();
                    return string4.equals(string2) || string4.startsWith(string2 + "-");
                }
                case 7: {
                    if (jetProperty == null || jetProperty.isChangeByOther()) {
                        return false;
                    }
                    if (jetProperty.getObject() instanceof List) {
                        return ((List)jetProperty.getObject()).contains(string2);
                    }
                    return jetProperty.toUnitString().equals(string2);
                }
            }
            return false;
        }
        if (s == 0) {
            return SelectorToolkit.isFitConditions(((CombinatorCondition)condition).getFirstCondition(), jetObject) && SelectorToolkit.isFitConditions(((CombinatorCondition)condition).getSecondCondition(), jetObject);
        }
        return false;
    }

    protected static JetObject getCanUsedParent(JetObject jetObject) {
        JetObject jetObject2 = (JetObject)((Object)jetObject.getParent());
        if (jetObject2 instanceof JetRptParagraph || jetObject2 instanceof JetRptParaReplaceElement || jetObject2 instanceof JetRptParaStyleElement) {
            return SelectorToolkit.getCanUsedParent(jetObject2);
        }
        return jetObject2;
    }

    protected static JetObject getCanUsedBrother(JetObject jetObject) {
        JetObject jetObject2 = (JetObject)((Object)jetObject.getParent());
        if (jetObject2 instanceof JetRptParaReplaceElement) {
            JetRptObject jetRptObject;
            JetRptObject jetRptObject2 = (JetRptObject)((Object)jetObject2.getParent());
            Vector vector = jetRptObject2.getChildren();
            int n = vector.indexOf(jetObject2);
            if (n > 0 && (jetRptObject = SelectorToolkit.I(vector, n - 1)) != null) {
                return ((ReplaceElement)((Object)jetRptObject)).getObject();
            }
            jetRptObject = (JetRptObject)((Object)jetRptObject2.getParent());
            vector = jetRptObject.getChildren();
            n = vector.indexOf(jetRptObject2);
            for (int i = n - 1; i >= 0; --i) {
                JetRptObject jetRptObject3 = (JetRptObject)vector.get(i);
                if (jetRptObject3 instanceof Paragraph) {
                    JetRptObject jetRptObject4 = SelectorToolkit.I(jetRptObject3.getChildren(), -1);
                    if (jetRptObject4 == null) continue;
                    return ((ReplaceElement)((Object)jetRptObject4)).getObject();
                }
                return jetRptObject3;
            }
            return null;
        }
        Vector vector = jetObject2.getChildren();
        int n = vector.indexOf(jetObject);
        if (n <= 0) {
            return null;
        }
        return (JetRptObject)vector.elementAt(n - 1);
    }

    private static JetRptObject I(List list, int n) {
        int n2;
        int n3 = list.size();
        for (int i = n2 = n < 0 || n > n3 - 1 ? n3 - 1 : n; i >= 0; --i) {
            JetRptObject jetRptObject = (JetRptObject)list.get(i);
            if (!(jetRptObject instanceof ReplaceElement)) continue;
            return jetRptObject;
        }
        return null;
    }

    private static String SEDU(JetObject jetObject, String string) {
        JetProperty jetProperty = SelectorToolkit.getObjProperty(jetObject, string);
        return jetProperty == null ? null : (jetProperty.isChangeByOther() ? null : jetProperty.toUnitString());
    }

    protected static JetProperty getObjProperty(JetObject jetObject, String string) {
        if (string.equals("id") || string.equals("class")) {
            return jetObject.nameToProperty(string);
        }
        if (jetObject instanceof JetRptChartPlatform && string.equalsIgnoreCase("charttype")) {
            List list = ((JetRptChartPlatform)jetObject).getChartTypeAttributeValue();
            JetVector jetVector = new JetVector(null, "charttype");
            jetVector.setObject(list);
            return jetVector;
        }
        for (Map.Entry entry : jetObject.getProperties().entrySet()) {
            if (!string.equalsIgnoreCase((String)entry.getKey())) continue;
            return (JetProperty)entry.getValue();
        }
        return null;
    }

    protected static SelectorPRI parseSelectorPrority(Selector selector) {
        SelectorPRI selectorPRI = new SelectorPRI();
        SelectorToolkit.append(selector, selectorPRI);
        return selectorPRI;
    }

    private static void append(Selector selector, SelectorPRI selectorPRI) {
        switch (selector.getSelectorType()) {
            case 4: {
                if (((ElementSelector)selector).getLocalName() == null) break;
                ++selectorPRI.tagCondi;
                break;
            }
            case 0: {
                SelectorToolkit.append((Selector)((ConditionalSelector)selector).getSimpleSelector(), selectorPRI);
                SelectorToolkit.attrCondi(((ConditionalSelector)selector).getCondition(), selectorPRI);
                break;
            }
            case 12: {
                SelectorToolkit.append((Selector)((SiblingSelector)selector).getSiblingSelector(), selectorPRI);
                SelectorToolkit.append(((SiblingSelector)selector).getSelector(), selectorPRI);
                break;
            }
            case 10: 
            case 11: {
                SelectorToolkit.append((Selector)((DescendantSelector)selector).getSimpleSelector(), selectorPRI);
                SelectorToolkit.append(((DescendantSelector)selector).getAncestorSelector(), selectorPRI);
            }
        }
    }

    private static void attrCondi(Condition condition, SelectorPRI selectorPRI) {
        if (condition instanceof AttributeCondition) {
            if (condition.getConditionType() == 5) {
                ++selectorPRI.idCondi;
            } else {
                ++selectorPRI.attrCondi;
            }
        } else if (condition.getConditionType() == 0) {
            SelectorToolkit.attrCondi(((CombinatorCondition)condition).getFirstCondition(), selectorPRI);
            SelectorToolkit.attrCondi(((CombinatorCondition)condition).getSecondCondition(), selectorPRI);
        }
    }
}

