/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.api;

import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.ResultSetAdapterRelationData;
import com.jinfonet.resstore.DiskStore;
import com.jinfonet.resstore.OutOfSpaceException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import jet.dataengine.api.DSException;
import jet.dataengine.api.DataBlockSet;
import jet.dataengine.util.DSLog;
import jet.universe.resultfile.ResultSetTool;

public class DataBlock {
    DSLog log = DSLog.getDSLog(DataBlockSet.class.getName());
    private static String SEDU = "dat";
    private static String append = "Share";
    private String close;
    private DataInputStream createTempFile;
    private DiskStore debug;
    private String delete;
    private IRelationData desiredAssertionStatus;
    private Object getAbsolutePath = new Object();
    private Object getDSLog = new Object();
    private Object getMessage = new Object();

    public DataBlock(DataInputStream dataInputStream, String string, DiskStore diskStore) {
        this.createTempFile = dataInputStream;
        this.close = string;
        this.debug = diskStore;
    }

    public DataBlock(ResultSet resultSet, String string, DiskStore diskStore) throws DSException, OutOfSpaceException, IOException {
        this(resultSet, string, diskStore.createTempFile("DataBlock", ""));
    }

    public DataBlock(ResultSet resultSet, String string, File file) throws DSException {
        if (file == null) {
            throw new IllegalArgumentException("tempFile can not be null");
        }
        String string2 = file.getAbsolutePath();
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            ResultSetTool.writeResultSet(dataOutputStream, resultSet);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            throw new DSException(0, new Object[]{iOException.getMessage()}, (Throwable)iOException);
        }
        catch (SQLException sQLException) {
            throw new DSException(0, new Object[]{sQLException.getMessage()}, (Throwable)sQLException);
        }
        this.delete = string2;
        this.log.debug("Create temp file for DataBlock fileName = [" + this.delete + "]");
        this.close = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.getAbsolutePath;
        synchronized (object) {
            if (this.createTempFile != null) {
                try {
                    this.createTempFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.createTempFile = null;
            }
            if (this.delete != null) {
                this.log.debug("delete temp file fileName = [" + this.delete + "]");
                File file = new File(this.delete);
                file.delete();
            }
            if (this.desiredAssertionStatus != null) {
                try {
                    this.desiredAssertionStatus.close();
                }
                catch (DSException dSException) {
                    // empty catch block
                }
                this.desiredAssertionStatus = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getStream() throws IOException {
        Object object = this.getMessage;
        synchronized (object) {
            this.SEDU();
            DataInputStream dataInputStream = this.createTempFile;
            this.createTempFile = null;
            return dataInputStream;
        }
    }

    public ResultSet createResultSet() throws DSException {
        this.$assertionsDisabled();
        return new ResultSetAdapterRelationData(this.desiredAssertionStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $assertionsDisabled() throws DSException {
        Object object = this.getDSLog;
        synchronized (object) {
            if (this.desiredAssertionStatus != null) {
                return;
            }
            try {
                this.SEDU();
                this.desiredAssertionStatus = ResultSetTool.loadIRelationData(this.createTempFile, this.debug);
                this.createTempFile.close();
                this.createTempFile = null;
            }
            catch (IOException iOException) {
                throw new DSException(0, new Object[]{iOException.getMessage()}, (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SEDU() throws FileNotFoundException {
        Object object = this.getMessage;
        synchronized (object) {
            if (this.createTempFile != null) {
                return;
            }
            if (this.createTempFile == null && this.delete != null) {
                this.createTempFile = new DataInputStream(new BufferedInputStream(new FileInputStream(this.delete)));
            } else assert (false) : "the inputStream is null and the insistFileName also null";
        }
    }

    public String getDataSetName() {
        return this.close;
    }
}

