/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.api;

import com.jinfonet.util.JRLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import jet.connect.DbColDesc;
import jet.connect.DbInteger;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.Group;
import jet.dataengine.api.SortInfo;
import jet.dataengine.api.SortObject;
import jet.dataengine.api.config.DbBufferConfig;
import jet.dataengine.api.dbbuffer.JDbBufferCursor;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataengine.api.dbbuffer.RecordModelInfo;
import jet.dataengine.groupengine.GroupImpl;
import jet.dataengine.groupengine.GroupModel;
import jet.dataengine.groupengine.LeafGroup;
import jet.dataengine.groupengine.LeafGroupModel;
import jet.dataengine.groupengine.MidGroup;
import jet.dataengine.groupengine.ParaLeafGroupModel;
import jet.dataengine.util.DSLog;
import jet.dataengine.util.externalsort.MergerSort;
import jet.dataengine8.dbbuffer.RecordImpl;
import jet.dataengine8.dbbuffer.RecordTool;
import jet.util.IntKeyHashtable;
import jet.util.IntVector;

public class SortProcessor {
    public static final int GROUP_LEVL = 0;
    public static final int DETAIL_LEVL = 1;
    private IntKeyHashtable SEDU;
    private IntKeyHashtable add;
    private ArrayList addElement;
    private ArrayList append;
    private static DSLog appendRecord = DSLog.getDSLog(SortProcessor.class.getName());
    private int clone = -1;

    public void doSort(IntKeyHashtable[] intKeyHashtableArray, Group group, int n, DbBufferConfig dbBufferConfig) {
        this.clone = n;
        this.SEDU = intKeyHashtableArray[0];
        this.add = intKeyHashtableArray[1];
        if (this.SEDU.size() > 0) {
            this.addElement = new ArrayList();
        }
        if (this.add.size() > 0) {
            this.append = new ArrayList();
        }
        if (this.addElement != null || this.append != null) {
            group.getGroupModel().setDataChanged(true);
            this.add(group);
        }
        if (this.addElement != null) {
            this.groupSort();
        }
        if (this.append != null) {
            this.addElement(dbBufferConfig);
        }
        this.clear();
    }

    public void resetWholeGroup(Group group) {
        this.SEDU(group);
    }

    private void SEDU(Group group) {
        if (group.getGroupType() == 1) {
            ((LeafGroup)group).resetRecords();
        } else {
            ((MidGroup)group).resetSubgroups();
        }
        Vector vector = group.getSubgroups();
        int n = vector != null ? vector.size() : 0;
        for (int i = 0; i < n; ++i) {
            this.SEDU((Group)vector.elementAt(i));
        }
        Vector vector2 = group.getSiblings();
        int n2 = vector2 != null ? vector2.size() : 0;
        for (int i = 0; i < n2; ++i) {
            this.SEDU((Group)vector2.elementAt(i));
        }
    }

    private void clear() {
        this.addElement = null;
        this.SEDU = null;
        this.append = null;
        this.add = null;
    }

    private void add(Group group) {
        Vector vector;
        if (group.getGroupType() == 1) {
            ((LeafGroup)group).resetRecords();
        } else {
            ((MidGroup)group).resetSubgroups();
        }
        if (group.isAvail()) {
            int n = group.getGroupModel().getGroupIndex();
            if (this.addElement != null && this.SEDU.containsKey(n) && !this.addElement.contains(group)) {
                this.addElement.add(group);
            }
            if (this.append != null && this.add.containsKey(n)) {
                this.append.add(group);
            }
        }
        int n = (vector = group.getSubgroups()) != null ? vector.size() : 0;
        for (int i = 0; i < n; ++i) {
            this.add((Group)vector.elementAt(i));
        }
        Vector vector2 = group.getSiblings();
        int n2 = vector2 != null ? vector2.size() : 0;
        for (int i = 0; i < n2; ++i) {
            this.add((Group)vector2.elementAt(i));
        }
    }

    private void groupSort() {
        for (int i = 0; i < this.addElement.size(); ++i) {
            GroupImpl groupImpl = (GroupImpl)this.addElement.get(i);
            SortInfo sortInfo = (SortInfo)this.SEDU.get(groupImpl.getGroupModel().getGroupIndex());
            groupImpl.sortGroup(true, sortInfo.getSortType());
        }
    }

    private void addElement(DbBufferConfig dbBufferConfig) {
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < this.append.size(); ++i) {
            Object[] objectArray;
            LeafGroup leafGroup = (LeafGroup)this.append.get(i);
            int n = leafGroup.getRecordIndexs().size();
            SortInfo sortInfo = (SortInfo)this.add.get(leafGroup.getGroupModel().getGroupIndex());
            GroupModel groupModel = leafGroup.getGroupModel();
            DbColDesc[] dbColDescArray = sortInfo.getSortColDesc();
            GroupModel groupModel2 = groupModel.createSortGroupInLeaf(dbColDescArray, sortInfo.getSortType());
            JRecord jRecord = null;
            GroupModel groupModel3 = leafGroup.getGroupModel();
            jRecord = groupModel3.getType() != 5 ? ((LeafGroupModel)leafGroup.getGroupModel()).getTempRecordForOuter() : ((ParaLeafGroupModel)leafGroup.getGroupModel()).getTempRecordForOuter();
            if (this.clone == -1) {
                l = System.currentTimeMillis();
                objectArray = this.clone(leafGroup, jRecord, sortInfo);
                this.append(leafGroup, (SortObject[])objectArray);
                l2 += System.currentTimeMillis() - l;
            } else {
                SortObject[] sortObjectArray;
                RecordModelInfo recordModelInfo;
                int n2;
                int n3;
                int n4;
                DbColDesc dbColDesc;
                l = System.currentTimeMillis();
                objectArray = sortInfo.getSortColDesc();
                DbColDesc[] dbColDescArray2 = new DbColDesc[objectArray.length + 1];
                int[] nArray = sortInfo.getSortType();
                int[] nArray2 = new int[nArray.length];
                for (int j = 0; j < nArray2.length; ++j) {
                    nArray2[j] = nArray[j] == 0 ? 1 : -1;
                    dbColDescArray2[j] = (DbColDesc)((DbColDesc)objectArray[j]).clone();
                    if (!JRLog.isTrace(5)) continue;
                    JRLog.trace(5, "Sort Type " + j + " is:" + nArray2[j]);
                    JRLog.trace(5, "DbColDesc " + j + " is:" + dbColDescArray2[j].toString());
                }
                dbColDescArray2[nArray.length] = dbColDesc = new DbColDesc(null, 4, 255, 0, 2);
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, "DbColDesc of record position " + nArray.length + " is:" + dbColDesc.toString());
                }
                if ((n4 = (n3 = this.clone < 4 ? 4 : this.clone) * 1024 * 1024 / (n2 = RecordTool.getRecordLen((recordModelInfo = new RecordModelInfo(dbColDescArray2)).getColDescs()))) > n) {
                    sortObjectArray = this.clone(leafGroup, jRecord, sortInfo);
                    this.append(leafGroup, sortObjectArray);
                    l2 += System.currentTimeMillis() - l;
                } else {
                    sortObjectArray = new MergerSort(recordModelInfo, n3, nArray2, dbBufferConfig);
                    try {
                        JDbBufferCursor jDbBufferCursor = this.appendRecord((MergerSort)sortObjectArray, leafGroup, jRecord, recordModelInfo);
                        this.update(leafGroup, jDbBufferCursor);
                        sortObjectArray.close();
                    }
                    catch (DSException dSException) {
                        appendRecord.error(4152, dSException);
                    }
                    l2 += System.currentTimeMillis() - l;
                    if (JRLog.isTrace(5)) {
                        JRLog.trace(5, "MemorySize for sort tool:" + n3);
                    }
                }
            }
            if (!JRLog.isTrace(5)) continue;
            JRLog.trace(5, "Sort record counts are:" + n + " for leaf group(GroupValue):" + leafGroup.getGroupValue());
        }
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, "Sort detail action elapses:" + l2);
        }
    }

    private void append(LeafGroup leafGroup, SortObject[] sortObjectArray) {
        IntVector intVector = new IntVector();
        for (int i = 0; i < sortObjectArray.length; ++i) {
            intVector.addElement(sortObjectArray[i].getPos());
        }
        leafGroup.setRecordIndexs(intVector);
    }

    private JDbBufferCursor appendRecord(MergerSort mergerSort, LeafGroup leafGroup, JRecord jRecord, RecordModelInfo recordModelInfo) throws DSException {
        int n;
        IntVector intVector = leafGroup.getRecordIndexs();
        int n2 = intVector.size();
        DbColDesc[] dbColDescArray = recordModelInfo.getColDescs();
        RecordImpl recordImpl = null;
        DbValue dbValue = null;
        int[] nArray = new int[dbColDescArray.length - 1];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = jRecord.indexOfCell(dbColDescArray[n].getColName());
        }
        for (n = 0; n < n2; ++n) {
            jRecord.setPosition(intVector.elementAt(n));
            jRecord.refresh(true);
            recordImpl = new RecordImpl(recordModelInfo);
            for (int i = 0; i < dbColDescArray.length - 1; ++i) {
                dbValue = recordImpl.getCell(i);
                dbValue.set((DbValue)jRecord.getCell(nArray[i]).clone());
            }
            ((DbInteger)recordImpl.getCell(dbColDescArray.length - 1)).set(jRecord.getPosition());
            mergerSort.appendRecord(recordImpl);
        }
        return mergerSort.finish();
    }

    private void update(LeafGroup leafGroup, JDbBufferCursor jDbBufferCursor) throws DSException {
        JRecord jRecord = jDbBufferCursor.createRecord();
        int n = jRecord.columnCount() - 1;
        IntVector intVector = new IntVector();
        int n2 = 0;
        while (jDbBufferCursor.next()) {
            jRecord.setPosition(jDbBufferCursor.getPosition());
            jRecord.refresh(true);
            n2 = ((DbInteger)jRecord.getCell(n)).get();
            intVector.addElement(n2);
        }
        leafGroup.setRecordIndexs(intVector);
    }

    private SortObject[] clone(LeafGroup leafGroup, JRecord jRecord, SortInfo sortInfo) {
        int n;
        IntVector intVector = leafGroup.getRecordIndexs();
        int n2 = intVector.size();
        Object[] objectArray = new SortObject[n2];
        int[] nArray = sortInfo.getSortType();
        int n3 = nArray.length;
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        DbColDesc[] dbColDescArray = sortInfo.getSortColDesc();
        for (n = 0; n < nArray.length; ++n) {
            nArray2[n] = nArray[n] == 0 ? 1 : -1;
            nArray3[n] = jRecord.getCell(dbColDescArray[n].getColName()).getColDesc().getColIndex();
        }
        for (n = 0; n < n2; ++n) {
            jRecord.setPosition(intVector.elementAt(n));
            jRecord.refresh(true);
            DbValue[] dbValueArray = new DbValue[n3];
            for (int i = 0; i < dbValueArray.length; ++i) {
                dbValueArray[i] = (DbValue)jRecord.getCell(nArray3[i]).clone();
            }
            objectArray[n] = new SortObject(dbValueArray, nArray2, jRecord.getPosition());
        }
        Arrays.sort(objectArray);
        return objectArray;
    }
}

