/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.api;

import com.jinfonet.util.JRLog;
import jet.formula.SpecFormulaDateTime;
import jet.formula.SpecFormulaInfo;
import jet.formula.SpecFormulaNum;
import jet.formula.SpecFormulaString;
import jet.formula.SpecFormulaValueChange;
import jet.report.specialFunc.SpecialFunction;
import jet.report.specialFunc.grpByRange.DateTimeIntervalGrpBy;
import jet.report.specialFunc.grpByRange.GroupByRange;
import jet.report.specialFunc.grpByRange.NumbericIntervalGrpBy;
import jet.report.specialFunc.grpByRange.StringIntervalGrpBy;

public class SpecialFormulaTools {
    public static SpecFormulaInfo buildSpecFormulaInfo(SpecialFunction specialFunction) {
        SpecFormulaInfo specFormulaInfo = null;
        int n = specialFunction.getFunctionType();
        if (n == 1) {
            GroupByRange groupByRange = (GroupByRange)specialFunction;
            Number number = groupByRange.getInterval();
            int n2 = groupByRange.getGroupByRangeType();
            if (n2 == 1) {
                StringIntervalGrpBy stringIntervalGrpBy = (StringIntervalGrpBy)groupByRange;
                SpecFormulaString specFormulaString = new SpecFormulaString();
                specFormulaString.setIntervalType(stringIntervalGrpBy.getStartLineType());
                specFormulaString.setLength(number.intValue());
                specFormulaString.setConvertGroupName(stringIntervalGrpBy.getFormatOfGrpName());
                specFormulaString.setCaseSensitive(stringIntervalGrpBy.getCaseSensitive());
                specFormulaInfo = specFormulaString;
            } else if (n2 == 2) {
                NumbericIntervalGrpBy numbericIntervalGrpBy = (NumbericIntervalGrpBy)groupByRange;
                if (numbericIntervalGrpBy.isValueChangedInterval()) {
                    SpecFormulaValueChange specFormulaValueChange = new SpecFormulaValueChange();
                    specFormulaValueChange.setIncrease(numbericIntervalGrpBy.isIncreasedInterval());
                    specFormulaValueChange.setTolerance(numbericIntervalGrpBy.getInterval().intValue());
                    specFormulaInfo = specFormulaValueChange;
                } else {
                    SpecFormulaNum specFormulaNum = new SpecFormulaNum();
                    specFormulaNum.setInterval(number);
                    specFormulaNum.setStartPoint(numbericIntervalGrpBy.getStartLine());
                    specFormulaInfo = specFormulaNum;
                }
            } else if (n2 == 3) {
                DateTimeIntervalGrpBy dateTimeIntervalGrpBy = (DateTimeIntervalGrpBy)groupByRange;
                SpecFormulaDateTime specFormulaDateTime = new SpecFormulaDateTime();
                specFormulaDateTime.setBenchmarkPoint(dateTimeIntervalGrpBy.getStartLine().longValue());
                specFormulaDateTime.setInterval(dateTimeIntervalGrpBy.getInterval().intValue());
                specFormulaDateTime.setZoneOffset(dateTimeIntervalGrpBy.getTimeZoneOffset());
                specFormulaDateTime.setUnit(dateTimeIntervalGrpBy.getIntervalUnit());
                specFormulaDateTime.setFirstDayOfWeek(dateTimeIntervalGrpBy.getFirstDayOfWeek());
                specFormulaInfo = specFormulaDateTime;
            } else if (JRLog.isError(2)) {
                JRLog.error(2, "Invalidate special function! ", null);
            }
            specFormulaInfo.setKeepNullGroup(groupByRange.isGroupingToOthers());
            specFormulaInfo.setOtherGroupName(groupByRange.getOthersGroupingName());
        }
        return specFormulaInfo;
    }
}

