/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.api;

import jet.dataengine.api.DSException;
import jet.formula.Functions;
import jet.formula.SpecFormulaDateTime;
import jet.formula.SpecFormulaInfo;
import jet.formula.SpecFormulaNum;
import jet.formula.SpecFormulaString;
import jet.formula.SpecFormulaValueChange;
import jet.universe.summary.JetUSpecFuncDateTime;
import jet.universe.summary.JetUSpecFuncInfo;
import jet.universe.summary.JetUSpecFuncNum;
import jet.universe.summary.JetUSpecFuncString;
import jet.universe.summary.JetUSpecFuncValChan;

public class SumrySpecKeyTool {
    public static final int EACH = 1;
    public static final String DELIM = ";";
    public static final char SPACE = ' ';
    public static final String UPTO = "Up to";

    public static String getSpecKey(String string) throws DSException {
        if (string.indexOf(DELIM) != -1) {
            return string;
        }
        JetUSpecFuncDateTime jetUSpecFuncDateTime = null;
        int n = Functions.getSpecFuncByName(string);
        switch (n) {
            case 0: {
                jetUSpecFuncDateTime = new JetUSpecFuncDateTime();
                jetUSpecFuncDateTime.setInterNum(String.valueOf(1));
                jetUSpecFuncDateTime.setUnit(13);
                break;
            }
            case 1: {
                jetUSpecFuncDateTime = new JetUSpecFuncDateTime();
                jetUSpecFuncDateTime.setInterNum(String.valueOf(1));
                jetUSpecFuncDateTime.setUnit(12);
                break;
            }
            case 2: {
                jetUSpecFuncDateTime = new JetUSpecFuncDateTime();
                jetUSpecFuncDateTime.setInterNum(String.valueOf(1));
                jetUSpecFuncDateTime.setUnit(10);
                break;
            }
            case 10: {
                jetUSpecFuncDateTime = new JetUSpecFuncDateTime();
                jetUSpecFuncDateTime.setInterNum(String.valueOf(1));
                jetUSpecFuncDateTime.setUnit(5);
                break;
            }
            case 11: {
                jetUSpecFuncDateTime = new JetUSpecFuncDateTime();
                jetUSpecFuncDateTime.setInterNum(String.valueOf(1));
                jetUSpecFuncDateTime.setUnit(24);
                break;
            }
            case 17: {
                jetUSpecFuncDateTime = new JetUSpecFuncDateTime();
                jetUSpecFuncDateTime.setInterNum(String.valueOf(1));
                jetUSpecFuncDateTime.setUnit(23);
                break;
            }
            case 12: {
                jetUSpecFuncDateTime = new JetUSpecFuncDateTime();
                jetUSpecFuncDateTime.setInterNum(String.valueOf(1));
                jetUSpecFuncDateTime.setUnit(21);
                break;
            }
            case 13: {
                jetUSpecFuncDateTime = new JetUSpecFuncDateTime();
                jetUSpecFuncDateTime.setInterNum(String.valueOf(1));
                jetUSpecFuncDateTime.setUnit(2);
                break;
            }
            case 14: {
                jetUSpecFuncDateTime = new JetUSpecFuncDateTime();
                jetUSpecFuncDateTime.setInterNum(String.valueOf(1));
                jetUSpecFuncDateTime.setUnit(22);
                break;
            }
            case 15: {
                jetUSpecFuncDateTime = new JetUSpecFuncDateTime();
                jetUSpecFuncDateTime.setInterNum(String.valueOf(1));
                jetUSpecFuncDateTime.setUnit(20);
                break;
            }
            case 16: {
                jetUSpecFuncDateTime = new JetUSpecFuncDateTime();
                jetUSpecFuncDateTime.setInterNum(String.valueOf(1));
                jetUSpecFuncDateTime.setUnit(1);
            }
        }
        if (jetUSpecFuncDateTime != null) {
            jetUSpecFuncDateTime.setBenchPoint(String.valueOf(0));
            return SumrySpecKeyTool.getSpecKey(jetUSpecFuncDateTime);
        }
        throw new DSException(4268, new Object[]{string});
    }

    public static boolean eqaulsIgnTimZon(String string, String string2) {
        String[] stringArray;
        String[] stringArray2 = string.split(DELIM);
        if (stringArray2.length != (stringArray = string2.split(DELIM)).length) {
            return false;
        }
        for (int i = stringArray2.length - 1; i >= 0; --i) {
            if (i == stringArray2.length - 4 || stringArray2[i].equalsIgnoreCase(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    public static String getSpecKey(SpecFormulaInfo specFormulaInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (specFormulaInfo.getType()) {
            case 2: {
                SpecFormulaDateTime specFormulaDateTime = (SpecFormulaDateTime)specFormulaInfo;
                int n = specFormulaDateTime.getInterval();
                int n2 = specFormulaDateTime.getUnit();
                if (n == 1) {
                    stringBuffer.append(Functions.getSpecFuncName(Integer.toString(1), n2) + DELIM);
                } else {
                    stringBuffer.append(n + DELIM);
                    stringBuffer.append(n2 + DELIM);
                }
                stringBuffer.append(specFormulaDateTime.getType() + DELIM);
                stringBuffer.append(specFormulaDateTime.getBenchmarkPoint() + DELIM);
                stringBuffer.append(specFormulaDateTime.getZoneOffset() + DELIM);
                stringBuffer.append(specFormulaDateTime.getFirstDayOfWeek() + DELIM);
                stringBuffer.append(specFormulaDateTime.getOtherGroupName() + DELIM);
                break;
            }
            case 4: {
                SpecFormulaNum specFormulaNum = (SpecFormulaNum)specFormulaInfo;
                stringBuffer.append(specFormulaNum.getType() + DELIM);
                stringBuffer.append(specFormulaNum.getInterval() + DELIM);
                stringBuffer.append(specFormulaNum.getStartPoint() + DELIM);
                stringBuffer.append(specFormulaNum.getOtherGroupName() + DELIM);
                break;
            }
            case 1: {
                SpecFormulaString specFormulaString = (SpecFormulaString)specFormulaInfo;
                stringBuffer.append(specFormulaString.getType() + DELIM);
                stringBuffer.append(specFormulaString.getIntervalType() + DELIM);
                stringBuffer.append(specFormulaString.getLength() + DELIM);
                stringBuffer.append(specFormulaString.getCaseSensitive() + DELIM);
                stringBuffer.append(specFormulaString.getConvertGroupName() + DELIM);
                stringBuffer.append(specFormulaString.getOtherGroupName() + DELIM);
                break;
            }
            case 3: {
                SpecFormulaValueChange specFormulaValueChange = (SpecFormulaValueChange)specFormulaInfo;
                stringBuffer.append(specFormulaValueChange.getType() + DELIM);
                stringBuffer.append(specFormulaValueChange.isIncrease() + DELIM);
                stringBuffer.append(specFormulaValueChange.getTolerance() + DELIM);
                stringBuffer.append(specFormulaValueChange.getOtherGroupName() + DELIM);
            }
        }
        stringBuffer.append(specFormulaInfo.isKeepNullGroup() + DELIM);
        return stringBuffer.toString();
    }

    public static String getSpecKey(JetUSpecFuncInfo jetUSpecFuncInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (jetUSpecFuncInfo.getType()) {
            case 2: {
                JetUSpecFuncDateTime jetUSpecFuncDateTime = (JetUSpecFuncDateTime)jetUSpecFuncInfo;
                String string = jetUSpecFuncDateTime.getInterNum();
                int n = jetUSpecFuncDateTime.getUnit();
                if (Integer.parseInt(string) == 1) {
                    stringBuffer.append(Functions.getSpecFuncName(string, n) + DELIM);
                } else {
                    stringBuffer.append(string + DELIM);
                    stringBuffer.append(n + DELIM);
                }
                stringBuffer.append(jetUSpecFuncDateTime.getType() + DELIM);
                stringBuffer.append(jetUSpecFuncDateTime.getBenchPoint() + DELIM);
                stringBuffer.append(jetUSpecFuncDateTime.getZoneOffset() + DELIM);
                stringBuffer.append(jetUSpecFuncDateTime.getfirstDayOfWeek() + DELIM);
                stringBuffer.append(jetUSpecFuncDateTime.getOtherName() + DELIM);
                break;
            }
            case 4: {
                JetUSpecFuncNum jetUSpecFuncNum = (JetUSpecFuncNum)jetUSpecFuncInfo;
                stringBuffer.append(jetUSpecFuncNum.getType() + DELIM);
                stringBuffer.append(jetUSpecFuncNum.getInterNum() + DELIM);
                stringBuffer.append(jetUSpecFuncNum.getStartPoint() + DELIM);
                stringBuffer.append(jetUSpecFuncNum.getOtherName() + DELIM);
                break;
            }
            case 1: {
                JetUSpecFuncString jetUSpecFuncString = (JetUSpecFuncString)jetUSpecFuncInfo;
                stringBuffer.append(jetUSpecFuncString.getType() + DELIM);
                stringBuffer.append(jetUSpecFuncString.getDirection() + DELIM);
                stringBuffer.append(jetUSpecFuncString.getInterNum() + DELIM);
                stringBuffer.append(jetUSpecFuncString.getCaseSensitive() + DELIM);
                stringBuffer.append(jetUSpecFuncString.getConvertGroupName() + DELIM);
                stringBuffer.append(jetUSpecFuncString.getOtherName() + DELIM);
                break;
            }
            case 3: {
                JetUSpecFuncValChan jetUSpecFuncValChan = (JetUSpecFuncValChan)jetUSpecFuncInfo;
                stringBuffer.append(jetUSpecFuncValChan.getType() + DELIM);
                stringBuffer.append(jetUSpecFuncValChan.getIncrease() + DELIM);
                stringBuffer.append(jetUSpecFuncValChan.getInterNum() + DELIM);
                stringBuffer.append(jetUSpecFuncValChan.getOtherName() + DELIM);
            }
        }
        stringBuffer.append(jetUSpecFuncInfo.getCusOtherName() + DELIM);
        return stringBuffer.toString();
    }

    public static String getStringDesc(int n, String string) {
        int n2 = Integer.parseInt(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("For");
        stringBuffer.append(' ');
        boolean bl = true;
        if (n == 1) {
            if (n2 == 1) {
                stringBuffer.append("1st");
                bl = false;
            } else {
                stringBuffer.append("first");
            }
        } else {
            stringBuffer.append("last");
        }
        stringBuffer.append(' ');
        if (bl) {
            stringBuffer.append(string);
            stringBuffer.append(' ');
        }
        if (n2 == 1) {
            stringBuffer.append("letter");
        } else {
            stringBuffer.append("letters");
        }
        return stringBuffer.toString();
    }

    public static String getDateDesc(int n, String string) throws DSException {
        int n2 = Integer.parseInt(string);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = SumrySpecKeyTool.SEDU(n);
        stringBuffer.append("For");
        stringBuffer.append(' ');
        if (n2 == 1) {
            stringBuffer.append("each");
            stringBuffer.append(' ');
            stringBuffer.append(string2);
        } else {
            stringBuffer.append(string);
            stringBuffer.append(' ');
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private static String SEDU(int n) throws DSException {
        String string = null;
        switch (n) {
            case 13: {
                string = "second";
                break;
            }
            case 12: {
                string = "minute";
                break;
            }
            case 10: {
                string = "hour";
                break;
            }
            case 5: {
                string = "day";
                break;
            }
            case 24: {
                string = "week";
                break;
            }
            case 23: {
                string = "bi-week";
                break;
            }
            case 21: {
                string = "half month";
                break;
            }
            case 2: {
                string = "month";
                break;
            }
            case 22: {
                string = "quarter";
                break;
            }
            case 20: {
                string = "half year";
                break;
            }
            case 1: {
                string = "year";
                break;
            }
            default: {
                throw new DSException(4135, new Object[]{new Integer(n)});
            }
        }
        return string;
    }

    public static String getNumberDesc(boolean bl, boolean bl2, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            if (bl2) {
                stringBuffer.append("Increasing Within");
            } else {
                stringBuffer.append("Decreasing Within");
            }
        } else {
            stringBuffer.append(UPTO);
        }
        stringBuffer.append(' ');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

