/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.api.datasource.xml;

import com.jinfonet.util.JRLog;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.xml.namespace.QName;
import jet.dataengine.api.DSException;
import jet.dataengine.api.datasource.xml.DataValueCheck;
import jet.dataengine.api.datasource.xml.InstanceStreamInfo;
import jet.dataengine.api.datasource.xml.InterNode;
import jet.dataengine.api.datasource.xml.XMLInstanceSource;
import jet.dataengine.api.datasource.xml.XMLModelSource;
import jet.dataengine.api.datasource.xml.XSDTypes;
import jet.dataengine.util.DSLog;
import jet.dataengine.util.XMLTool;

public class XMLDSTool {
    private static DSLog SEDU = DSLog.getDSLog(XMLDSTool.class.getName());

    public static boolean isValidate(XMLModelSource xMLModelSource, QName qName, XMLInstanceSource xMLInstanceSource) throws DSException {
        String string = null;
        String string2 = null;
        if (xMLModelSource.getURIInfo() != null) {
            string = xMLModelSource.getURIInfo().getURI();
        }
        string2 = xMLInstanceSource.getInstURI();
        if (string == null || string2 == null || qName == null) {
            throw new DSException(4108, new Object[]{string, string2, qName});
        }
        return XMLTool.isValid(string, qName, string2);
    }

    public static boolean isValidate(XMLModelSource xMLModelSource, XMLInstanceSource xMLInstanceSource) throws DSException {
        String string = xMLModelSource.getURIInfo().getURI();
        if (xMLInstanceSource.wasStreaminfo()) {
            try {
                InstanceStreamInfo instanceStreamInfo = xMLInstanceSource.getStreamInfo();
                String string2 = instanceStreamInfo.getConnectionName();
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, " XMLDSTool(isValidate), connection name is: " + string2 + " from instanceStreamInfo ");
                }
                return XMLTool.validate(string, instanceStreamInfo.getStreamFactory().createInputStream(string2));
            }
            catch (IOException iOException) {
                throw new DSException(2140, (Object[])new String[]{"An IOException  was thrown when do xml instance validate.Detail:" + iOException.getMessage()}, (Throwable)iOException);
            }
        }
        String string3 = xMLInstanceSource.getInstURI();
        assert (string != null) : " Schema URI is null !";
        assert (string3 != null) : " Instance URI is null !";
        return XMLTool.validate(string, string3);
    }

    public static boolean isValidPattern(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        }
        catch (Exception exception) {
            SEDU.debug(exception.getMessage());
            return false;
        }
        return true;
    }

    public static boolean checkTypeValPatt(InterNode interNode, String string, String string2) throws DSException {
        return XMLDSTool.checkTypeValPatt(interNode, string, string2, null);
    }

    public static boolean checkTypeValPatt(InterNode interNode, String string, String string2, Locale locale) throws DSException {
        assert (string2 != null) : "This new value is null !";
        boolean bl = true;
        int n = XSDTypes.getXSDIntTypeByStr(interNode.getType());
        String string3 = interNode.getPattern();
        int n2 = interNode.getPatternIntType();
        if (n2 != -1 && n2 == 1) {
            bl = DataValueCheck.checkValue(n, string2, string3, interNode.getPatternIntType(), locale);
        }
        String string4 = interNode.getDefault();
        String string5 = interNode.getFixed();
        boolean bl2 = bl = !(string4 != null && string.equals("FixedValue") || string5 != null && string.equals("DefaultValue"));
        if (!bl) {
            if (string4 != null) {
                throw new DSException(4123);
            }
            throw new DSException(4124);
        }
        return bl;
    }
}

