/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.api.expression;

import com.jinfonet.dataservice.expression.ExpressionFactoryImpl;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.IExpressionFactory;
import jet.dataengine.api.expression.IOperatorFactory;
import jet.dataengine.api.expression.IOperatorInforFactory;
import jet.dataengine.util.DSLog;
import jet.ireport.IReport;
import jet.report.onTheFlyFormula.Scope;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.JBusinessLogic;
import jet.universe.businesslogic.JUnifiedBusinessView;
import jet.universe.businesslogic.impl.UnifiedBusinessView;

public final class ExpressionFactoryCreator {
    private static DSLog SEDU = DSLog.getDSLog(ExpressionFactoryCreator.class.getName());
    private static IExpressionFactory append;
    private static IOperatorFactory error;
    private static IOperatorInforFactory forName;

    private ExpressionFactoryCreator() {
    }

    public static synchronized IExpressionFactory getIExpressionFactory() throws ConditionException {
        if (append == null) {
            try {
                append = (IExpressionFactory)Class.forName("com.jinfonet.dataservice.expression.ExpressionFactoryImpl").newInstance();
            }
            catch (InstantiationException instantiationException) {
                SEDU.error(5130, new Object[]{"Instantiation Exception when ExpressionFactory class loading"}, instantiationException);
                throw new ConditionException(8200, new Object[]{"Instantiation Exception " + instantiationException.getMessage()});
            }
            catch (IllegalAccessException illegalAccessException) {
                SEDU.error(5131, new Object[]{"Illegal Access Exception when ExpressionFactory class loading"}, illegalAccessException);
                throw new ConditionException(8201, new Object[]{"Illegal Access Exception " + illegalAccessException.getMessage()});
            }
            catch (ClassNotFoundException classNotFoundException) {
                SEDU.error(5132, new Object[]{"Class Not Found Exception when ExpressionFactory class loading"}, classNotFoundException);
                throw new ConditionException(8202, new Object[]{"Class Not Found Exception " + classNotFoundException.getMessage()});
            }
        }
        return append;
    }

    public static synchronized IExpressionFactory getIExpressionFactory(JetUUniverse jetUUniverse, String string) {
        ExpressionFactoryImpl expressionFactoryImpl = new ExpressionFactoryImpl(jetUUniverse, string);
        return expressionFactoryImpl;
    }

    public static synchronized IExpressionFactory getIExpressionFactory(JetUUniverse jetUUniverse, String string, BLNode bLNode) {
        if (bLNode != null && !(bLNode instanceof JBusinessLogic) && !(bLNode instanceof JUnifiedBusinessView)) {
            return null;
        }
        ExpressionFactoryImpl expressionFactoryImpl = new ExpressionFactoryImpl(jetUUniverse, string, bLNode);
        return expressionFactoryImpl;
    }

    public static synchronized IExpressionFactory getIExpressionFactory(JetUUniverse jetUUniverse, String string, String string2) throws ConditionException {
        if (jetUUniverse == null || string == null) {
            return ExpressionFactoryCreator.getIExpressionFactory();
        }
        if (string2 == null) {
            return ExpressionFactoryCreator.getIExpressionFactory(jetUUniverse, string);
        }
        UnifiedBusinessView unifiedBusinessView = jetUUniverse.getBV(string, string2);
        return ExpressionFactoryCreator.getIExpressionFactory(jetUUniverse, string, unifiedBusinessView);
    }

    public static synchronized IOperatorFactory getIOperatorFactory() throws ConditionException {
        if (error == null) {
            try {
                error = (IOperatorFactory)Class.forName("com.jinfonet.dataservice.expression.OperatorFactoryImpl").newInstance();
            }
            catch (InstantiationException instantiationException) {
                SEDU.error(5133, new Object[]{"Instantiation Exception when OperatorFactory class loading"}, instantiationException);
                throw new ConditionException(8203, new Object[]{"Instantiation Exception " + instantiationException.getMessage()});
            }
            catch (IllegalAccessException illegalAccessException) {
                SEDU.error(5134, new Object[]{"Illegal Access Exception when OperatorFactory class loading"}, illegalAccessException);
                throw new ConditionException(8204, new Object[]{"Illegal Access Exception " + illegalAccessException.getMessage()});
            }
            catch (ClassNotFoundException classNotFoundException) {
                SEDU.error(5135, new Object[]{"Class Not Found Exception when OperatorFactory class loading"}, classNotFoundException);
                throw new ConditionException(8205, new Object[]{"Class Not Found Exception " + classNotFoundException.getMessage()});
            }
        }
        return error;
    }

    public static synchronized IOperatorInforFactory getIOperatorInforFactory() throws ConditionException {
        if (forName == null) {
            try {
                forName = (IOperatorInforFactory)Class.forName("com.jinfonet.dataservice.expression.OperatorInfoFactoryImpl").newInstance();
            }
            catch (InstantiationException instantiationException) {
                SEDU.error(5136, new Object[]{"Instantiation Exception when OperatorInfoFactory class loading"}, instantiationException);
                throw new ConditionException(8206, new Object[]{"Instantiation Exception " + instantiationException.getMessage()});
            }
            catch (IllegalAccessException illegalAccessException) {
                SEDU.error(5137, new Object[]{"Illegal Access Exception when OperatorInfoFactory class loading"}, illegalAccessException);
                throw new ConditionException(8207, new Object[]{"Illegal Access Exception " + illegalAccessException.getMessage()});
            }
            catch (ClassNotFoundException classNotFoundException) {
                SEDU.error(5138, new Object[]{"Class Not Found Exception when OperatorInfoFactory class loading"}, classNotFoundException);
                throw new ConditionException(8208, new Object[]{"Class Not Found Exception " + classNotFoundException.getMessage()});
            }
        }
        return forName;
    }

    public static synchronized IExpressionFactory getIExpressionFactory(JetUUniverse jetUUniverse, IReport iReport, String string, String string2, String string3, int n) {
        ExpressionFactoryImpl expressionFactoryImpl = new ExpressionFactoryImpl(jetUUniverse, iReport, string, string2, string3, n);
        return expressionFactoryImpl;
    }

    public static synchronized IExpressionFactory getIExpressionFactory(Scope scope) {
        ExpressionFactoryImpl expressionFactoryImpl = new ExpressionFactoryImpl(scope);
        return expressionFactoryImpl;
    }
}

