/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.api.expression;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.expression.relational.IBinaryRelationExpression;
import com.jinfonet.dataservice.api.expression.relational.IRelationExpression;
import com.jinfonet.dataservice.api.expression.relational.ISingleRelationExpression;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.expression.calculate.op.SpecialFuncImpl;
import com.jinfonet.dataservice.expression.tuple.BinaryConditionExpressionImpl;
import com.jinfonet.dataservice.expression.tuple.BinaryLogicExpressionImpl;
import com.jinfonet.dataservice.expression.tuple.TripleConditionExpressionImpl;
import com.jinfonet.dataservice.expression.variable.FormulaImpl;
import com.jinfonet.dataservice.expression.variable.ParameterImpl;
import com.jinfonet.dataservice.expression.variable.ReferenceImpl;
import com.jinfonet.dataservice.relational.datasource.Formula;
import com.jinfonet.dataservice.relational.datasource.FormulaMapping;
import com.jinfonet.dataservice.relational.datasource.relational.JRDBJoin;
import com.jinfonet.dataservice.schema.relational.datasource.relational.RdbRelationModel;
import com.jinfonet.util.JRLog;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import jet.connect.DbArray;
import jet.connect.DbColDesc;
import jet.connect.DbDate;
import jet.connect.DbDateTime;
import jet.connect.DbTime;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.SpecialFields;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionFactoryCreator;
import jet.dataengine.api.expression.IBinary;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.IExpressionFactory;
import jet.dataengine.api.expression.IMulti;
import jet.dataengine.api.expression.IOperator;
import jet.dataengine.api.expression.IOperatorFactory;
import jet.dataengine.api.expression.IOperatorInforFactory;
import jet.dataengine.api.expression.IOperatorInformation;
import jet.dataengine.api.expression.ISingle;
import jet.dataengine.api.expression.ITriple;
import jet.dataengine.api.expression.IUnCheckedExpression;
import jet.dataengine.api.expression.OperatorInfoToolkit;
import jet.dataengine.api.expression.OperatorToolKit;
import jet.dataengine.api.expression.OperatorTypes;
import jet.dataengine.api.expression.calculate.ICalculateExpression;
import jet.dataengine.api.expression.calculate.ISingleCalculateExpression;
import jet.dataengine.api.expression.info.ISortInformation;
import jet.dataengine.api.expression.info.ISortInformationCollector;
import jet.dataengine.api.expression.info.ITopNInformation;
import jet.dataengine.api.expression.set.ISetExpression;
import jet.dataengine.api.expression.set.ISortExpression;
import jet.dataengine.api.expression.set.ITopNExpression;
import jet.dataengine.api.expression.set.op.ISetOperator;
import jet.dataengine.api.expression.set.op.ISortOperator;
import jet.dataengine.api.expression.set.op.ITopNOperator;
import jet.dataengine.api.expression.tuple.IBinaryBooleanExpression;
import jet.dataengine.api.expression.tuple.IBinaryConditionExpression;
import jet.dataengine.api.expression.tuple.IBinaryTupleExpression;
import jet.dataengine.api.expression.tuple.IBooleanExpression;
import jet.dataengine.api.expression.tuple.IMultiLogicExpression;
import jet.dataengine.api.expression.tuple.ISingleBooleanExpression;
import jet.dataengine.api.expression.tuple.ISingleTupleExpression;
import jet.dataengine.api.expression.tuple.ITripleTupleExpression;
import jet.dataengine.api.expression.tuple.ITupleExpression;
import jet.dataengine.api.expression.tuple.IUnCheckedBinaryExpression;
import jet.dataengine.api.expression.tuple.IUnCheckedMultiExpression;
import jet.dataengine.api.expression.tuple.IUnCheckedSingleExpression;
import jet.dataengine.api.expression.tuple.IUnCheckedTripleExpression;
import jet.dataengine.api.expression.tuple.op.IBinaryConditionOperator;
import jet.dataengine.api.expression.tuple.op.IBinaryLogicOperator;
import jet.dataengine.api.expression.tuple.op.ITripleConditionOperator;
import jet.dataengine.api.expression.variable.IConstant;
import jet.dataengine.api.expression.variable.IDataContainerReference;
import jet.dataengine.api.expression.variable.IFormula;
import jet.dataengine.api.expression.variable.IParameter;
import jet.dataengine.api.expression.variable.IQueryInfoFormula;
import jet.dataengine.api.expression.variable.IQueryInfoReference;
import jet.dataengine.api.expression.variable.IReference;
import jet.dataengine.api.expression.variable.IUnCheckedVariableExpression;
import jet.dataengine.api.expression.variable.IVariableExpression;
import jet.dataengine.api.expression.variable.IVariableList;
import jet.dataengine.api.query.AggregationKey;
import jet.dataengine.api.query.ParameterValueList;
import jet.dataengine.util.DSLog;
import jet.dataengine.util.StringTools;
import jet.dataengine8.core.queryengine.RawDataQueryTools;
import jet.dataengine8.core.queryengine.sqltoolkit.ResourceContainer;
import jet.dataengine8.core.queryengine.transform.QueryTransform;
import jet.formula.DataTypeDef;
import jet.formula.JetRptFormula;
import jet.formula.ParamDesc;
import jet.formula.SpecFormulaInfo;
import jet.formula.fArray;
import jet.ireport.IReport;
import jet.report.formula.JetRptAbstractFormula;
import jet.report.onTheFlyFormula.JetRptFlyFormula;
import jet.report.onTheFlyFormula.JetRptFlyMeasure;
import jet.report.onTheFlyFormula.Scope;
import jet.universe.JetUCompColQueryField;
import jet.universe.JetUConnection;
import jet.universe.JetUDBField;
import jet.universe.JetUDatabase;
import jet.universe.JetUField;
import jet.universe.JetUFldQueryField;
import jet.universe.JetUFormula;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUParameter;
import jet.universe.JetUQueriable;
import jet.universe.JetUQuery;
import jet.universe.JetUQueryField;
import jet.universe.JetURefQueryField;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUResourceField;
import jet.universe.JetUTableView;
import jet.universe.JetUTreeNode;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.DataElementInfo;
import jet.universe.businesslogic.JBusinessLogic;
import jet.universe.businesslogic.JUnifiedBusinessView;
import jet.universe.businesslogic.MeasureInfo;
import jet.universe.businesslogic.impl.DetailInfo;
import jet.universe.businesslogic.impl.Dimension;
import jet.universe.businesslogic.impl.Measure;
import jet.universe.psql.FileQuery;
import jet.universe.psql.PointEx;
import jet.universe.psql.RptPsqlQuery;
import jet.universe.psql.WhereClauseParser;
import jet.universe.tools.ParseParametersForQuery;
import jet.universe.tools.QueryInfo;
import jet.util.CharBinaryFormat;
import toolkit.db.DbTools;
import toolkit.db.PsqlColumn;
import toolkit.db.PsqlJoin;
import toolkit.db.PsqlTable;
import toolkit.db.sql.CritNode;
import toolkit.db.sql.SqlTools;

public class ExpressionToolKit {
    private static final int Expression2String = -1;
    private static final int GetQueryByResourceName = 1;
    private static final int GetTableOrViewByResourceName = 2;
    private static final int SEDU = 3;
    public static final int OPERATOR_POSITION_FRONT = 1;
    public static final int OPERATOR_POSITION_MIDDLE = 2;
    public static final int OPERATOR_POSITION_BACK = 3;
    private static IExpressionFactory SqlToFml;
    private static IOperatorFactory add;
    private static IOperatorInforFactory addAll;
    private static final DSLog addConstant;
    public static final int TRANSLATETOMAPPING = 0;
    public static final int TRANSLATETOREAL = 1;
    private static int addElement;
    private static int addFormula;

    private ExpressionToolKit() {
    }

    public static boolean isVariableExp(int n) {
        return (n & 0x8000) == 32768;
    }

    public static boolean isTupleExp(int n) {
        return (n & 0x1000) == 4096;
    }

    public static boolean isCalculateExp(int n) {
        return (n & 0x4000) == 16384;
    }

    public static boolean isSetExp(int n) {
        return (n & 0x2000) == 8192;
    }

    public static boolean isRelationExp(int n) {
        return (n & 0x10000) == 65536;
    }

    public static boolean isSingleExp(int n) {
        return (n & 0x20000) == 131072;
    }

    public static boolean isBinaryExp(int n) {
        return (n & 0x40000) == 262144;
    }

    public static boolean isTripleExp(int n) {
        return (n & 0x80000) == 524288;
    }

    public static boolean isMultiExp(int n) {
        return (n & 0x200000) == 0x200000;
    }

    public static boolean isReference(int n) {
        return (n & 0x8001) == 32769;
    }

    public static boolean isDataContainerReference(int n) {
        return (n & 0x8040) == 32832;
    }

    public static boolean isDataContainerFormula(int n) {
        return (n & 0x8100) == 33024;
    }

    public static boolean isQueryInfoReference(int n) {
        return (n & 0x8020) == 32800;
    }

    public static boolean isConstant(int n) {
        return (n & 0x8002) == 32770;
    }

    public static boolean isFormula(int n) {
        return (n & 0x8004) == 32772;
    }

    public static boolean isQueryInfoFormula(int n) {
        return (n & 0x8080) == 32896;
    }

    public static boolean isParameter(int n) {
        return (n & 0x8008) == 32776;
    }

    public static boolean isVariableList(int n) {
        return (n & 0x8010) == 32784;
    }

    public static boolean isRelationModelExp(int n) {
        return (n & 0x38000) == 229376;
    }

    public static boolean isRDBRelationModelExp(int n) {
        return (n & 0x38020) == 229408;
    }

    public static boolean isXMLRelationModelExp(int n) {
        return (n & 0x38040) == 229440;
    }

    public static boolean isSingleRelationExp(int n) {
        return (n & 0x30000) == 196608;
    }

    public static boolean isBinaryRelationExp(int n) {
        return (n & 0x50000) == 327680;
    }

    public static boolean isBooleanExp(int n) {
        return (n & 0x101000) == 0x101000;
    }

    public static boolean isLogicExp(int n) {
        return (n & 0x101001) == 0x101001;
    }

    public static boolean isConditionExp(int n) {
        return (n & 0x101002) == 0x101002;
    }

    public static boolean isSingleConditionExp(int n) {
        return ExpressionToolKit.isSingleExp(n) && ExpressionToolKit.isConditionExp(n);
    }

    public static boolean isBinaryConditionExp(int n) {
        return ExpressionToolKit.isBinaryExp(n) && ExpressionToolKit.isConditionExp(n);
    }

    public static boolean isTripleConditonExp(int n) {
        return ExpressionToolKit.isTripleExp(n) && ExpressionToolKit.isConditionExp(n);
    }

    public static boolean isSingleLogicExp(int n) {
        return ExpressionToolKit.isSingleExp(n) && ExpressionToolKit.isLogicExp(n);
    }

    public static boolean isBinaryLogicExp(int n) {
        return ExpressionToolKit.isBinaryExp(n) && ExpressionToolKit.isLogicExp(n);
    }

    public static boolean isMultiLogicExp(int n) {
        return ExpressionToolKit.isMultiExp(n) && ExpressionToolKit.isLogicExp(n);
    }

    public static boolean isSingleTupleExp(int n) {
        return ExpressionToolKit.isSingleExp(n) && ExpressionToolKit.isTupleExp(n);
    }

    public static boolean isSingleBooleanExp(int n) {
        return ExpressionToolKit.isSingleExp(n) && ExpressionToolKit.isBooleanExp(n);
    }

    public static boolean isBinaryTupleExp(int n) {
        return ExpressionToolKit.isBinaryExp(n) && ExpressionToolKit.isTupleExp(n);
    }

    public static boolean isBinaryBooleanExp(int n) {
        return ExpressionToolKit.isBinaryExp(n) && ExpressionToolKit.isBooleanExp(n);
    }

    public static boolean isTripleTupleExp(int n) {
        return ExpressionToolKit.isTripleExp(n) && ExpressionToolKit.isTupleExp(n);
    }

    public static boolean isTripleBooleanExp(int n) {
        return ExpressionToolKit.isTripleExp(n) && ExpressionToolKit.isBooleanExp(n);
    }

    public static boolean isSortExp(int n) {
        return (n & 0x22001) == 139265;
    }

    public static boolean isTopNExp(int n) {
        return (n & 0x22002) == 139266;
    }

    public static boolean isSingleCalculateExp(int n) {
        return ExpressionToolKit.isSingleExp(n) && ExpressionToolKit.isCalculateExp(n);
    }

    public static boolean isBinaryCalculateExp(int n) {
        return ExpressionToolKit.isBinaryExp(n) && ExpressionToolKit.isCalculateExp(n);
    }

    public static boolean isTripleCalculateExp(int n) {
        return ExpressionToolKit.isTripleExp(n) && ExpressionToolKit.isCalculateExp(n);
    }

    public static boolean isLikeOrNotLikeExp(IBinaryBooleanExpression iBinaryBooleanExpression) {
        int n = iBinaryBooleanExpression.getOperator().operatorType();
        return n == 556793860 || n == 556793864;
    }

    public static boolean isSpecFuncExp(int n) {
        return n == 0x14000001;
    }

    public static boolean isUnCheckedExp(int n) {
        return (n & 0x400000) == 0x400000;
    }

    public static String[] getDependentRefNames(IExpression iExpression) throws DSException {
        if (iExpression == null) {
            return new String[0];
        }
        ArrayList arrayList = new ArrayList();
        if (ExpressionToolKit.isReference(iExpression.expressionType())) {
            String string = null;
            try {
                string = new String(iExpression.getName());
            }
            catch (ConditionException conditionException) {
                throw new DSException(8002);
            }
            return new String[]{string};
        }
        if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
            return ExpressionToolKit.getDependentRefNames(((ISingle)((Object)iExpression)).getExpression());
        }
        if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
            ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentRefNames(((IBinary)((Object)iExpression)).getExpression1()), arrayList);
            ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentRefNames(((IBinary)((Object)iExpression)).getExpression2()), arrayList);
            if (arrayList.size() < 1) {
                return null;
            }
            return ExpressionToolKit.$assertionsDisabled(arrayList);
        }
        if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
            ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentRefNames(((ITriple)((Object)iExpression)).getExpression1()), arrayList);
            ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentRefNames(((ITriple)((Object)iExpression)).getExpression2()), arrayList);
            ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentRefNames(((ITriple)((Object)iExpression)).getExpression3()), arrayList);
            if (arrayList.size() < 1) {
                return null;
            }
            return ExpressionToolKit.$assertionsDisabled(arrayList);
        }
        if (ExpressionToolKit.isMultiExp(iExpression.expressionType())) {
            IExpression[] iExpressionArray = ((IMulti)((Object)iExpression)).getExpressions();
            for (int i = 0; i < iExpressionArray.length; ++i) {
                ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentRefNames(iExpressionArray[i]), arrayList);
            }
            if (arrayList.size() < 1) {
                return null;
            }
            return ExpressionToolKit.$assertionsDisabled(arrayList);
        }
        return null;
    }

    public static String[] getDependentRefNames(IExpression iExpression, JetUUniverse jetUUniverse, String string, String string2) throws DSException {
        if (iExpression == null) {
            return new String[0];
        }
        ArrayList arrayList = new ArrayList();
        if (ExpressionToolKit.isReference(iExpression.expressionType())) {
            String string3 = null;
            try {
                string3 = new String(iExpression.getName());
            }
            catch (ConditionException conditionException) {
                throw new DSException(8002);
            }
            return new String[]{string3};
        }
        if (ExpressionToolKit.isFormula(iExpression.expressionType())) {
            Vector vector = null;
            try {
                JetUFormula jetUFormula = (JetUFormula)jetUUniverse.getResourceByName(string, null, iExpression.getName());
                vector = jetUFormula.getRefAllDbFld();
            }
            catch (ConditionException conditionException) {
                throw new DSException(8002);
            }
            return vector.toArray(new String[0]);
        }
        if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
            return ExpressionToolKit.getDependentRefNames(((ISingle)((Object)iExpression)).getExpression(), jetUUniverse, string, string2);
        }
        if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
            ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentRefNames(((IBinary)((Object)iExpression)).getExpression1(), jetUUniverse, string, string2), arrayList);
            ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentRefNames(((IBinary)((Object)iExpression)).getExpression2(), jetUUniverse, string, string2), arrayList);
            if (arrayList.size() < 1) {
                return null;
            }
            return ExpressionToolKit.$assertionsDisabled(arrayList);
        }
        if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
            ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentRefNames(((ITriple)((Object)iExpression)).getExpression1(), jetUUniverse, string, string2), arrayList);
            ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentRefNames(((ITriple)((Object)iExpression)).getExpression2(), jetUUniverse, string, string2), arrayList);
            ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentRefNames(((ITriple)((Object)iExpression)).getExpression3(), jetUUniverse, string, string2), arrayList);
            if (arrayList.size() < 1) {
                return null;
            }
            return ExpressionToolKit.$assertionsDisabled(arrayList);
        }
        if (ExpressionToolKit.isMultiExp(iExpression.expressionType())) {
            IExpression[] iExpressionArray = ((IMulti)((Object)iExpression)).getExpressions();
            for (int i = 0; i < iExpressionArray.length; ++i) {
                ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentRefNames(iExpressionArray[i], jetUUniverse, string, string2), arrayList);
            }
            if (arrayList.size() < 1) {
                return null;
            }
            return ExpressionToolKit.$assertionsDisabled(arrayList);
        }
        return null;
    }

    private static String[] $assertionsDisabled(List list) {
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = (String)list.get(i);
        }
        return stringArray;
    }

    private static void Expression2String(String[] stringArray, List list) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                list.add(stringArray[i]);
            }
        }
    }

    public static String[] getDependentParNames(IExpression iExpression) throws DSException, ConditionException {
        if (iExpression == null) {
            return new String[0];
        }
        ArrayList arrayList = new ArrayList();
        if (ExpressionToolKit.isParameter(iExpression.expressionType())) {
            String string = null;
            try {
                string = new String(iExpression.getName());
            }
            catch (ConditionException conditionException) {
                throw new DSException(8002);
            }
            return new String[]{string};
        }
        if (ExpressionToolKit.isVariableList(iExpression.expressionType())) {
            IVariableList iVariableList = (IVariableList)iExpression;
            for (int i = 0; i < iVariableList.size(); ++i) {
                ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentParNames(iVariableList.getVariableExp(i)), arrayList);
            }
            if (arrayList.size() < 1) {
                return null;
            }
            return ExpressionToolKit.$assertionsDisabled(arrayList);
        }
        if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
            return ExpressionToolKit.getDependentParNames(((ISingle)((Object)iExpression)).getExpression());
        }
        if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
            ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentParNames(((IBinary)((Object)iExpression)).getExpression1()), arrayList);
            ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentParNames(((IBinary)((Object)iExpression)).getExpression2()), arrayList);
            if (arrayList.size() < 1) {
                return null;
            }
            return ExpressionToolKit.$assertionsDisabled(arrayList);
        }
        if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
            ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentParNames(((ITriple)((Object)iExpression)).getExpression1()), arrayList);
            ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentParNames(((ITriple)((Object)iExpression)).getExpression2()), arrayList);
            ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentParNames(((ITriple)((Object)iExpression)).getExpression3()), arrayList);
            if (arrayList.size() < 1) {
                return null;
            }
            return ExpressionToolKit.$assertionsDisabled(arrayList);
        }
        if (ExpressionToolKit.isMultiExp(iExpression.expressionType())) {
            IExpression[] iExpressionArray = ((IMulti)((Object)iExpression)).getExpressions();
            for (int i = 0; i < iExpressionArray.length; ++i) {
                ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentParNames(iExpressionArray[i]), arrayList);
            }
            if (arrayList.size() < 1) {
                return null;
            }
            return ExpressionToolKit.$assertionsDisabled(arrayList);
        }
        return null;
    }

    public static String[] getDependentForNames(IExpression iExpression) throws DSException {
        if (iExpression == null) {
            return new String[0];
        }
        ArrayList arrayList = new ArrayList();
        if (ExpressionToolKit.isFormula(iExpression.expressionType())) {
            String string = null;
            try {
                string = new String(iExpression.getName());
            }
            catch (ConditionException conditionException) {
                throw new DSException(8002);
            }
            return new String[]{string};
        }
        if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
            return ExpressionToolKit.getDependentForNames(((ISingle)((Object)iExpression)).getExpression());
        }
        if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
            ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentForNames(((IBinary)((Object)iExpression)).getExpression1()), arrayList);
            ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentForNames(((IBinary)((Object)iExpression)).getExpression2()), arrayList);
            if (arrayList.size() < 1) {
                return new String[0];
            }
            return ExpressionToolKit.$assertionsDisabled(arrayList);
        }
        if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
            ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentForNames(((ITriple)((Object)iExpression)).getExpression1()), arrayList);
            ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentForNames(((ITriple)((Object)iExpression)).getExpression2()), arrayList);
            ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentForNames(((ITriple)((Object)iExpression)).getExpression3()), arrayList);
            if (arrayList.size() < 1) {
                return new String[0];
            }
            return ExpressionToolKit.$assertionsDisabled(arrayList);
        }
        if (ExpressionToolKit.isMultiExp(iExpression.expressionType())) {
            IExpression[] iExpressionArray = ((IMulti)((Object)iExpression)).getExpressions();
            for (int i = 0; i < iExpressionArray.length; ++i) {
                ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentForNames(iExpressionArray[i]), arrayList);
            }
            if (arrayList.size() < 1) {
                return new String[0];
            }
            return ExpressionToolKit.$assertionsDisabled(arrayList);
        }
        return new String[0];
    }

    public static IMultiLogicExpression buildAndExpression(IExpression iExpression, IExpression iExpression2) throws ConditionException {
        return ExpressionToolKit.buildAndExpression(new IExpression[]{iExpression, iExpression2});
    }

    private static boolean GetQueryByResourceName(IExpression iExpression) throws ConditionException {
        if (ExpressionToolKit.isBooleanExp(iExpression.expressionType())) {
            return true;
        }
        if (ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
            if (ExpressionToolKit.isConstant(iExpression.expressionType())) {
                IConstant iConstant = (IConstant)iExpression;
                if (iConstant.isNull()) {
                    return false;
                }
                if (iConstant.getValue().equalsIgnoreCase("true") || iConstant.getValue().equalsIgnoreCase("false")) {
                    return true;
                }
            } else if (ExpressionToolKit.isVariableList(iExpression.expressionType())) {
                IVariableList iVariableList = (IVariableList)iExpression;
                for (int i = 0; i < iVariableList.size(); ++i) {
                    if (ExpressionToolKit.GetQueryByResourceName(iVariableList.getVariableExp(i))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static IMultiLogicExpression buildAndExpression(IExpression[] iExpressionArray) throws ConditionException {
        int n;
        if (iExpressionArray != null) {
            for (n = 0; n < iExpressionArray.length; ++n) {
                assert (iExpressionArray[n] != null) : "sub exps was null";
            }
        }
        for (n = 0; n < iExpressionArray.length; ++n) {
            if (ExpressionToolKit.GetQueryByResourceName(iExpressionArray[n])) continue;
            throw new ConditionException(8216);
        }
        IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
        IOperatorFactory iOperatorFactory = ExpressionFactoryCreator.getIOperatorFactory();
        return iExpressionFactory.createMultiLogicExp(iOperatorFactory.createMultiLogicOp(-2125463550), iExpressionArray);
    }

    public static IMultiLogicExpression buildOrExpression(IExpression[] iExpressionArray) throws ConditionException {
        int n;
        if (iExpressionArray != null) {
            for (n = 0; n < iExpressionArray.length; ++n) {
                assert (iExpressionArray[n] != null) : "sub exps was null";
            }
        }
        for (n = 0; n < iExpressionArray.length; ++n) {
            if (ExpressionToolKit.GetQueryByResourceName(iExpressionArray[n])) continue;
            throw new ConditionException(8216);
        }
        IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
        IOperatorFactory iOperatorFactory = ExpressionFactoryCreator.getIOperatorFactory();
        return iExpressionFactory.createMultiLogicExp(iOperatorFactory.createMultiLogicOp(-2125463548), iExpressionArray);
    }

    public static IExpression buildOrExpression(IExpression iExpression, IExpression iExpression2) throws ConditionException {
        return ExpressionToolKit.buildOrExpression(new IExpression[]{iExpression, iExpression2});
    }

    public static IExpression buildNotExpression(IExpression iExpression) throws ConditionException {
        if (iExpression == null) assert (false) : "first exp was null";
        if (!ExpressionToolKit.isBooleanExp(iExpression.expressionType()) && !ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
            throw new ConditionException(8218);
        }
        if (!ExpressionToolKit.GetQueryByResourceName(iExpression)) {
            throw new ConditionException(8219);
        }
        IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
        IOperatorFactory iOperatorFactory = ExpressionFactoryCreator.getIOperatorFactory();
        if (ExpressionToolKit.isBooleanExp(iExpression.expressionType())) {
            return iExpressionFactory.createSingleLogicExp(iOperatorFactory.createNotOp(), (IBooleanExpression)iExpression);
        }
        return iExpressionFactory.createSingleLogicExp(iOperatorFactory.createNotOp(), (IVariableExpression)iExpression);
    }

    public static boolean containedTupleExp(IExpression iExpression) {
        if (iExpression == null) {
            return false;
        }
        if (!ExpressionToolKit.isTupleExp(iExpression.expressionType())) {
            if (ExpressionToolKit.isSetExp(iExpression.expressionType()) && ((ISetExpression)iExpression).getExpression() != null) {
                return ExpressionToolKit.containedTupleExp(((ISetExpression)iExpression).getExpression());
            }
        } else {
            return true;
        }
        return false;
    }

    public static boolean containedSetExp(IExpression iExpression) {
        if (iExpression == null) {
            return false;
        }
        return ExpressionToolKit.isSetExp(iExpression.expressionType());
    }

    public static boolean containedSortExp(IExpression iExpression) {
        if (iExpression == null) {
            return false;
        }
        if (!ExpressionToolKit.isSortExp(iExpression.expressionType())) {
            if (ExpressionToolKit.isSetExp(iExpression.expressionType()) && ((ISetExpression)iExpression).getExpression() != null) {
                return ExpressionToolKit.containedSortExp(((ISetExpression)iExpression).getExpression());
            }
        } else {
            return true;
        }
        return false;
    }

    public static boolean containedTopNExp(IExpression iExpression) {
        if (iExpression == null) {
            return false;
        }
        if (!ExpressionToolKit.isTopNExp(iExpression.expressionType())) {
            if (ExpressionToolKit.isSetExp(iExpression.expressionType()) && ((ISetExpression)iExpression).getExpression() != null) {
                return ExpressionToolKit.containedTopNExp(((ISetExpression)iExpression).getExpression());
            }
        } else {
            return true;
        }
        return false;
    }

    public static IExpression removeTupleExp(IExpression iExpression) throws DSException {
        IExpression iExpression2 = iExpression;
        IExpression iExpression3 = iExpression;
        IExpression iExpression4 = null;
        if (iExpression == null) {
            return null;
        }
        if (ExpressionToolKit.isSetExp(iExpression3.expressionType())) {
            iExpression4 = ((ISetExpression)iExpression3).getExpression();
        }
        while (iExpression4 != null && ExpressionToolKit.isSetExp(iExpression4.expressionType())) {
            iExpression3 = iExpression4;
            iExpression4 = ((ISetExpression)iExpression4).getExpression();
        }
        try {
            if (iExpression4 == null || !ExpressionToolKit.isTupleExp(iExpression4.expressionType())) {
                throw new DSException(8220, new Object[]{iExpression2});
            }
            ((ISetExpression)iExpression3).setExpression(null);
        }
        catch (ConditionException conditionException) {
            throw new DSException(8221, (Throwable)conditionException);
        }
        return iExpression2;
    }

    public static boolean hasSubExpression(IExpression iExpression) {
        ISetExpression iSetExpression = (ISetExpression)iExpression;
        return iExpression != null && iSetExpression.getExpression() != null;
    }

    public static ITupleExpression getFilterExp(IExpression iExpression) {
        if (iExpression == null) {
            return null;
        }
        if (ExpressionToolKit.isTupleExp(iExpression.expressionType())) {
            return (ITupleExpression)iExpression;
        }
        if (ExpressionToolKit.isSetExp(iExpression.expressionType())) {
            return ExpressionToolKit.getFilterExp(((ISetExpression)iExpression).getExpression());
        }
        return null;
    }

    public static String[] getDependentRelationModelExpressionNames(IRelationExpression iRelationExpression) throws DSException {
        int n;
        if (iRelationExpression == null) {
            return new String[0];
        }
        if (ExpressionToolKit.isRelationModelExp(iRelationExpression.expressionType())) {
            String string = null;
            try {
                string = iRelationExpression.getName();
                if (iRelationExpression instanceof RdbRelationModel && ((RdbRelationModel)((Object)iRelationExpression)).isAlias()) {
                    string = ((RdbRelationModel)((Object)iRelationExpression)).getAliasName();
                }
            }
            catch (ConditionException conditionException) {
                throw new DSException(8500, (Object[])new String[]{conditionException.getMessage()}, (Throwable)conditionException);
            }
            return new String[]{string};
        }
        if (ExpressionToolKit.isSingleRelationExp(iRelationExpression.expressionType())) {
            return ExpressionToolKit.getDependentRelationModelExpressionNames(((ISingleRelationExpression)iRelationExpression).getExpression());
        }
        String[] stringArray = ExpressionToolKit.getDependentRelationModelExpressionNames(((IBinaryRelationExpression)iRelationExpression).getExpression1());
        String[] stringArray2 = ExpressionToolKit.getDependentRelationModelExpressionNames(((IBinaryRelationExpression)iRelationExpression).getExpression2());
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        int n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            stringArray3[n2++] = stringArray[n];
        }
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray3[n2++] = stringArray2[n];
        }
        return stringArray3;
    }

    public static void applyAllConstantTimeZone(IExpression iExpression, TimeZone timeZone) throws DSException {
        IConstant[] iConstantArray = ExpressionToolKit.getAllConstants(iExpression);
        if (iConstantArray != null && iConstantArray.length > 0) {
            for (int i = 0; i < iConstantArray.length; ++i) {
                if (!Types.isTimeType(iConstantArray[i].getDataType())) continue;
                ExpressionToolKit.GetTableOrViewByResourceName(timeZone, iConstantArray[i]);
            }
        }
    }

    private static void GetTableOrViewByResourceName(TimeZone timeZone, IConstant iConstant) throws DSException {
        Date date = null;
        if (iConstant.isNull()) {
            return;
        }
        try {
            if (iConstant.getDataType() == 93) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                simpleDateFormat.setTimeZone(timeZone);
                try {
                    date = simpleDateFormat.parse(iConstant.getValue());
                }
                catch (ParseException parseException) {
                    simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    simpleDateFormat.setTimeZone(timeZone);
                    try {
                        date = simpleDateFormat.parse(iConstant.getValue());
                    }
                    catch (ParseException parseException2) {
                        new IllegalArgumentException("constant value illigal for parsing: " + iConstant.getValue());
                    }
                }
            } else if (iConstant.getDataType() == 92) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
                try {
                    date = simpleDateFormat.parse(iConstant.getValue());
                }
                catch (ParseException parseException) {
                    simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
                    try {
                        date = simpleDateFormat.parse(iConstant.getValue());
                    }
                    catch (ParseException parseException3) {
                        new IllegalArgumentException("constant value illigal for parsing: " + iConstant.getValue());
                    }
                }
            } else if (iConstant.getDataType() == 91) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd z");
                try {
                    date = simpleDateFormat.parse(iConstant.getValue());
                }
                catch (ParseException parseException) {
                    simpleDateFormat.applyPattern("yyyy-MM-dd");
                    try {
                        date = simpleDateFormat.parse(iConstant.getValue());
                    }
                    catch (ParseException parseException4) {
                        new IllegalArgumentException("constant value illigal for parsing: " + iConstant.getValue());
                    }
                }
            } else {
                return;
            }
            iConstant.setObjectValue(date);
        }
        catch (ConditionException conditionException) {
            throw new DSException(8501, (Object[])new String[]{conditionException.getMessage()}, (Throwable)conditionException);
        }
    }

    public static IConstant[] getAllConstants(IExpression iExpression) throws DSException {
        if (ExpressionToolKit.isConstant(iExpression.expressionType())) {
            return new IConstant[]{(IConstant)iExpression};
        }
        if (ExpressionToolKit.isVariableList(iExpression.expressionType())) {
            return ExpressionToolKit.SEDU((IVariableList)iExpression);
        }
        if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
            return ExpressionToolKit.getAllConstants(((ISingle)((Object)iExpression)).getExpression());
        }
        if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
            IConstant[] iConstantArray = ExpressionToolKit.getAllConstants(((IBinary)((Object)iExpression)).getExpression1());
            IConstant[] iConstantArray2 = ExpressionToolKit.getAllConstants(((IBinary)((Object)iExpression)).getExpression2());
            return ExpressionToolKit.SqlToFml(iConstantArray, iConstantArray2, null);
        }
        if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
            IConstant[] iConstantArray = ExpressionToolKit.getAllConstants(((ITriple)((Object)iExpression)).getExpression1());
            IConstant[] iConstantArray3 = ExpressionToolKit.getAllConstants(((ITriple)((Object)iExpression)).getExpression2());
            IConstant[] iConstantArray4 = ExpressionToolKit.getAllConstants(((ITriple)((Object)iExpression)).getExpression3());
            return ExpressionToolKit.SqlToFml(iConstantArray, iConstantArray3, iConstantArray4);
        }
        if (ExpressionToolKit.isMultiExp(iExpression.expressionType())) {
            IExpression[] iExpressionArray = ((IMulti)((Object)iExpression)).getExpressions();
            ArrayList<IConstant> arrayList = new ArrayList<IConstant>();
            for (int i = 0; iExpressionArray != null && i < iExpressionArray.length; ++i) {
                IConstant[] iConstantArray = ExpressionToolKit.getAllConstants(iExpressionArray[i]);
                for (int j = 0; iConstantArray != null && j < iConstantArray.length; ++j) {
                    arrayList.add(iConstantArray[j]);
                }
            }
            return arrayList.toArray(new IConstant[0]);
        }
        return null;
    }

    private static IConstant[] SEDU(IVariableList iVariableList) throws DSException {
        ArrayList<IVariableExpression> arrayList = new ArrayList<IVariableExpression>();
        try {
            for (int i = 0; i < iVariableList.size(); ++i) {
                if (!ExpressionToolKit.isConstant(iVariableList.getVariableExp(i).expressionType())) continue;
                arrayList.add(iVariableList.getVariableExp(i));
            }
        }
        catch (ConditionException conditionException) {
            throw new DSException(8502, (Object[])new String[]{conditionException.getMessage()}, (Throwable)conditionException);
        }
        IConstant[] iConstantArray = null;
        if (!arrayList.isEmpty()) {
            iConstantArray = new IConstant[arrayList.size()];
            for (int i = 0; i < iConstantArray.length; ++i) {
                iConstantArray[i] = (IConstant)arrayList.get(i);
            }
        }
        return iConstantArray;
    }

    private static IConstant[] SqlToFml(IConstant[] iConstantArray, IConstant[] iConstantArray2, IConstant[] iConstantArray3) {
        int n;
        ArrayList<IConstant> arrayList = new ArrayList<IConstant>();
        if (iConstantArray != null && iConstantArray.length > 0) {
            for (n = 0; n < iConstantArray.length; ++n) {
                arrayList.add(iConstantArray[n]);
            }
        }
        if (iConstantArray2 != null && iConstantArray2.length > 0) {
            for (n = 0; n < iConstantArray2.length; ++n) {
                arrayList.add(iConstantArray2[n]);
            }
        }
        if (iConstantArray3 != null && iConstantArray3.length > 0) {
            for (n = 0; n < iConstantArray3.length; ++n) {
                arrayList.add(iConstantArray3[n]);
            }
        }
        if (!arrayList.isEmpty()) {
            IConstant[] iConstantArray4 = new IConstant[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                iConstantArray4[i] = (IConstant)arrayList.get(i);
            }
            return iConstantArray4;
        }
        return null;
    }

    public static IExpression replaceAllName(ResourceContainer resourceContainer, IExpression iExpression) throws DSException {
        try {
            ExpressionToolKit.add(resourceContainer, iExpression, iExpression, -1);
        }
        catch (ConditionException conditionException) {
            throw new DSException(8478, (Object[])new String[]{conditionException.getMessage()}, (Throwable)conditionException);
        }
        return iExpression;
    }

    private static void add(ResourceContainer resourceContainer, IExpression iExpression, IExpression iExpression2, int n) throws ConditionException, DSException {
        if (iExpression2 != null) {
            if (ExpressionToolKit.isSetExp(iExpression2.expressionType())) {
                ExpressionToolKit.add(resourceContainer, iExpression2, ((ISetExpression)iExpression2).getExpression(), 1);
            } else if (ExpressionToolKit.isVariableExp(iExpression2.expressionType())) {
                ExpressionToolKit.addAll(resourceContainer, iExpression, (IVariableExpression)iExpression2, n);
            } else if (ExpressionToolKit.isSingleExp(iExpression2.expressionType())) {
                ExpressionToolKit.add(resourceContainer, iExpression2, ((ISingle)((Object)iExpression2)).getExpression(), 1);
            } else if (ExpressionToolKit.isBinaryExp(iExpression2.expressionType())) {
                ExpressionToolKit.add(resourceContainer, iExpression2, ((IBinary)((Object)iExpression2)).getExpression1(), 1);
                ExpressionToolKit.add(resourceContainer, iExpression2, ((IBinary)((Object)iExpression2)).getExpression2(), 2);
            } else if (ExpressionToolKit.isTripleExp(iExpression2.expressionType())) {
                ExpressionToolKit.add(resourceContainer, iExpression2, ((ITriple)((Object)iExpression2)).getExpression1(), 1);
                ExpressionToolKit.add(resourceContainer, iExpression2, ((ITriple)((Object)iExpression2)).getExpression2(), 2);
                ExpressionToolKit.add(resourceContainer, iExpression2, ((ITriple)((Object)iExpression2)).getExpression3(), 3);
            }
        }
    }

    private static void addAll(ResourceContainer resourceContainer, IExpression iExpression, IVariableExpression iVariableExpression, int n) throws ConditionException, DSException {
        if (ExpressionToolKit.isParameter(iVariableExpression.expressionType())) {
            ExpressionToolKit.addConstant(resourceContainer, iExpression, (IParameter)iVariableExpression, n);
        } else if (ExpressionToolKit.isReference(iVariableExpression.expressionType())) {
            ExpressionToolKit.addFormula(resourceContainer, iExpression, (IReference)iVariableExpression, n);
        } else if (ExpressionToolKit.isFormula(iVariableExpression.expressionType())) {
            ExpressionToolKit.addElement(resourceContainer, iExpression, (IFormula)iVariableExpression, n);
        } else if (ExpressionToolKit.isVariableList(iVariableExpression.expressionType())) {
            IVariableList iVariableList = (IVariableList)iVariableExpression;
            for (int i = 0; i < iVariableList.size(); ++i) {
                ExpressionToolKit.addAll(resourceContainer, iVariableList, iVariableList.getVariableExp(i), i);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addConstant(ResourceContainer resourceContainer, IExpression iExpression, IParameter iParameter, int n) throws ConditionException, DSException {
        IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
        String string = iParameter.getName();
        Object object = null;
        if (resourceContainer.containsIgnoreCase(string)) {
            object = resourceContainer.getResouceObject();
        }
        String string2 = null;
        if (object instanceof JetUParameter) {
            string2 = ((JetUParameter)object).getParamDesc().getName();
        } else {
            if (!(object instanceof ParamDesc)) return;
            string2 = ((ParamDesc)object).getName();
        }
        if (string2.equals(string)) {
            return;
        }
        IParameter iParameter2 = iExpressionFactory.createParameter(string2, string2.startsWith("@"));
        if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
            if (n != 1) throw new DSException(8479, new Object[]{String.valueOf(n)});
            ((ISingle)((Object)iExpression)).setExpression(iParameter2);
            return;
        } else if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
            if (n == 1) {
                ((IBinary)((Object)iExpression)).setExpression1(iParameter2);
                return;
            } else {
                if (n != 2) throw new DSException(8480, new Object[]{String.valueOf(n)});
                ((IBinary)((Object)iExpression)).setExpression2(iParameter2);
            }
            return;
        } else if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
            if (n == 1) {
                ((ITriple)((Object)iExpression)).setExpression1(iParameter2);
                return;
            } else if (n == 2) {
                ((ITriple)((Object)iExpression)).setExpression2(iParameter2);
                return;
            } else {
                if (n != 3) throw new DSException(8481, new Object[]{String.valueOf(n)});
                ((ITriple)((Object)iExpression)).setExpression3(iParameter2);
            }
            return;
        } else {
            if (!ExpressionToolKit.isVariableList(iExpression.expressionType())) return;
            IVariableList iVariableList = (IVariableList)iExpression;
            iVariableList.setParameter(iParameter2, n);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addElement(ResourceContainer resourceContainer, IExpression iExpression, IFormula iFormula, int n) throws ConditionException, DSException {
        Object object;
        IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
        String string = iFormula.getName();
        String string2 = null;
        if (resourceContainer.containsIgnoreCase(string) && (object = resourceContainer.getResouceObject()) instanceof JetUResourceEntity) {
            string2 = ((JetUResourceEntity)object).getResourceName();
        }
        if (string2 == null || string2.equals(string)) {
            return;
        }
        object = iExpressionFactory.createFormula(string2);
        if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
            if (n != 1) throw new DSException(8479, new Object[]{String.valueOf(n)});
            ((ISingle)((Object)iExpression)).setExpression((IExpression)object);
            return;
        } else if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
            if (n == 1) {
                ((IBinary)((Object)iExpression)).setExpression1((IVariableExpression)object);
                return;
            } else {
                if (n != 2) throw new DSException(8480, new Object[]{String.valueOf(n)});
                ((IBinary)((Object)iExpression)).setExpression2((IVariableExpression)object);
            }
            return;
        } else if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
            if (n == 1) {
                ((ITriple)((Object)iExpression)).setExpression1((IVariableExpression)object);
                return;
            } else if (n == 2) {
                ((ITriple)((Object)iExpression)).setExpression2((IVariableExpression)object);
                return;
            } else {
                if (n != 3) throw new DSException(8481, new Object[]{String.valueOf(n)});
                ((ITriple)((Object)iExpression)).setExpression3((IVariableExpression)object);
            }
            return;
        } else {
            if (!ExpressionToolKit.isVariableList(iExpression.expressionType())) return;
            IVariableList iVariableList = (IVariableList)iExpression;
            iVariableList.setFormula((IFormula)object, n);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addFormula(ResourceContainer resourceContainer, IExpression iExpression, IReference iReference, int n) throws ConditionException, DSException {
        Object object;
        IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
        String string = iReference.getName();
        String string2 = null;
        if (resourceContainer.containsIgnoreCase(string) && (object = resourceContainer.getResouceObject()) instanceof JetUResourceEntity) {
            string2 = ((JetUResourceEntity)object).getResourceName();
        }
        if (string2.equals(string)) {
            return;
        }
        object = iExpressionFactory.createReference(string2);
        if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
            if (n != 1) throw new DSException(8479, new Object[]{String.valueOf(n)});
            ((ISingle)((Object)iExpression)).setExpression((IExpression)object);
            return;
        } else if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
            if (n == 1) {
                ((IBinary)((Object)iExpression)).setExpression1((IVariableExpression)object);
                return;
            } else {
                if (n != 2) throw new DSException(8480, new Object[]{String.valueOf(n)});
                ((IBinary)((Object)iExpression)).setExpression2((IVariableExpression)object);
            }
            return;
        } else if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
            if (n == 1) {
                ((ITriple)((Object)iExpression)).setExpression1((IVariableExpression)object);
                return;
            } else if (n == 2) {
                ((ITriple)((Object)iExpression)).setExpression2((IVariableExpression)object);
                return;
            } else {
                if (n != 3) throw new DSException(8481, new Object[]{String.valueOf(n)});
                ((ITriple)((Object)iExpression)).setExpression3((IVariableExpression)object);
            }
            return;
        } else {
            if (!ExpressionToolKit.isVariableList(iExpression.expressionType())) return;
            throw new DSException(8496);
        }
    }

    public static IExpression changeParam2Constant(IExpression iExpression, ParamDesc[] paramDescArray) throws DSException {
        return ExpressionToolKit.changeParam2Constant(iExpression, paramDescArray, null, null);
    }

    public static IExpression changeParam2Constant(IExpression iExpression, ParamDesc[] paramDescArray, String string, String string2) throws DSException {
        return ExpressionToolKit.changeParamSpecial2Constant(iExpression, paramDescArray, string, string2, null);
    }

    public static IExpression changeParamSpecial2Constant(IExpression iExpression, ParamDesc[] paramDescArray, String string, String string2, SpecialFields specialFields) throws DSException {
        IExpression iExpression2 = null;
        try {
            IExpression iExpression3 = ExpressionToolKit.cloneExpression(iExpression);
            iExpression2 = ExpressionToolKit.addParameterValue(paramDescArray, iExpression3, iExpression3, -1, string, string2, specialFields);
            if (iExpression2 == null) {
                return iExpression3;
            }
            return iExpression2;
        }
        catch (ConditionException conditionException) {
            throw new DSException(1, new String[]{conditionException.getMessage()});
        }
    }

    private static boolean addParameter(Vector vector, SpecialFields specialFields) {
        if (specialFields.getAllSpecial2Values() == null || specialFields.getAllSpecial2Values().isEmpty()) {
            return true;
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            DbValue dbValue = specialFields.getSpecial2Value((AggregationKey)vector.get(i));
            if (dbValue != null && !dbValue.isNull()) continue;
            return true;
        }
        return false;
    }

    private static IExpression addParameterValue(ParamDesc[] paramDescArray, IExpression iExpression, IExpression iExpression2, int n, String string, String string2, SpecialFields specialFields) throws ConditionException, DSException {
        if (iExpression2 == null) {
            return null;
        }
        if (ExpressionToolKit.isSetExp(iExpression2.expressionType())) {
            ExpressionToolKit.addParameterValue(paramDescArray, iExpression2, ((ISetExpression)iExpression2).getExpression(), 1, string, string2, specialFields);
        } else if (ExpressionToolKit.isVariableExp(iExpression2.expressionType())) {
            ExpressionToolKit.addSortInformation(paramDescArray, iExpression, (IVariableExpression)iExpression2, n, string, string2, specialFields);
        } else if (ExpressionToolKit.isSingleExp(iExpression2.expressionType())) {
            ExpressionToolKit.addParameterValue(paramDescArray, iExpression2, ((ISingle)((Object)iExpression2)).getExpression(), 1, string, string2, specialFields);
        } else if (ExpressionToolKit.isBinaryExp(iExpression2.expressionType())) {
            Object object;
            if (specialFields != null && specialFields.hasIncrementalSpecial() && ExpressionToolKit.addParameter((Vector)(object = ExpressionToolKit.getSpecial2function(iExpression2)), specialFields) && object != null && !((Vector)object).isEmpty()) {
                return SqlToFml.getBooleanTrue();
            }
            if (ExpressionToolKit.isBinaryConditionExp(iExpression2.expressionType()) && (((IBinaryConditionExpression)iExpression2).getOperator().operatorType() == 556793857 || ((IBinaryConditionExpression)iExpression2).getOperator().operatorType() == 556793858)) {
                if (ExpressionToolKit.appendStringToBuffer((IVariableList)((IBinaryConditionExpression)iExpression2).getExpression2(), paramDescArray)) {
                    switch (((IBinaryConditionExpression)iExpression2).getOperator().operatorType()) {
                        case 556793857: {
                            return SqlToFml.getBooleanTrue();
                        }
                        case 556793858: {
                            return SqlToFml.getBooleanFalse();
                        }
                    }
                } else {
                    ExpressionToolKit.addParameterValue(paramDescArray, iExpression2, ((IBinary)((Object)iExpression2)).getExpression1(), 1, string, string2, specialFields);
                    ExpressionToolKit.addParameterValue(paramDescArray, iExpression2, ((IBinary)((Object)iExpression2)).getExpression2(), 2, string, string2, specialFields);
                }
            } else {
                ITupleExpression iTupleExpression;
                object = (ITupleExpression)ExpressionToolKit.addParameterValue(paramDescArray, iExpression2, ((IBinary)((Object)iExpression2)).getExpression1(), 1, string, string2, specialFields);
                if (object != null) {
                    ((IBinary)((Object)iExpression)).setExpression1((ITupleExpression)object);
                }
                if ((iTupleExpression = (ITupleExpression)ExpressionToolKit.addParameterValue(paramDescArray, iExpression2, ((IBinary)((Object)iExpression2)).getExpression2(), 2, string, string2, specialFields)) != null) {
                    ((IBinary)((Object)iExpression)).setExpression2(iTupleExpression);
                }
            }
        } else if (ExpressionToolKit.isTripleExp(iExpression2.expressionType())) {
            Vector vector;
            if (specialFields != null && specialFields.hasIncrementalSpecial() && ExpressionToolKit.addParameter(vector = ExpressionToolKit.getSpecial2function(iExpression2), specialFields) && vector != null && !vector.isEmpty()) {
                return SqlToFml.getBooleanTrue();
            }
            ExpressionToolKit.addParameterValue(paramDescArray, iExpression2, ((ITriple)((Object)iExpression2)).getExpression1(), 1, string, string2, specialFields);
            ExpressionToolKit.addParameterValue(paramDescArray, iExpression2, ((ITriple)((Object)iExpression2)).getExpression2(), 2, string, string2, specialFields);
            ExpressionToolKit.addParameterValue(paramDescArray, iExpression2, ((ITriple)((Object)iExpression2)).getExpression3(), 3, string, string2, specialFields);
        } else if (ExpressionToolKit.isMultiExp(iExpression2.expressionType())) {
            IMulti iMulti = (IMulti)((Object)iExpression2);
            IExpression[] iExpressionArray = iMulti.getExpressions();
            for (int i = 0; i < iExpressionArray.length; ++i) {
                Object object;
                if (specialFields != null && specialFields.hasIncrementalSpecial() && (specialFields.getAllSpecial2Values() == null || specialFields.getAllSpecial2Values().isEmpty())) {
                    object = ExpressionToolKit.getSpecial2function(iExpressionArray[i]);
                    if (object == null || ((Vector)object).isEmpty()) continue;
                    iExpressionArray[i] = SqlToFml.getBooleanTrue();
                    continue;
                }
                if (ExpressionToolKit.isBinaryConditionExp(iExpressionArray[i].expressionType()) && (((IBinaryConditionExpression)iExpressionArray[i]).getOperator().operatorType() == 556793857 || ((IBinaryConditionExpression)iExpressionArray[i]).getOperator().operatorType() == 556793858) && ExpressionToolKit.appendStringToBuffer((IVariableList)((IBinaryConditionExpression)iExpressionArray[i]).getExpression2(), paramDescArray)) {
                    switch (((IBinaryConditionExpression)iExpressionArray[i]).getOperator().operatorType()) {
                        case 556793857: {
                            iExpressionArray[i] = SqlToFml.getBooleanTrue();
                            break;
                        }
                        case 556793858: {
                            iExpressionArray[i] = SqlToFml.getBooleanFalse();
                            break;
                        }
                    }
                    continue;
                }
                object = ExpressionToolKit.addParameterValue(paramDescArray, iExpression2, iExpressionArray[i], i, string, string2, specialFields);
                if (object == null || !object.equals(SqlToFml.getBooleanFalse()) && !object.equals(SqlToFml.getBooleanTrue())) continue;
                iExpressionArray[i] = object;
            }
            iMulti.setExpressions(iExpressionArray);
        }
        return null;
    }

    private static void addSortInformation(ParamDesc[] paramDescArray, IExpression iExpression, IVariableExpression iVariableExpression, int n, String string, String string2, SpecialFields specialFields) throws ConditionException, DSException {
        if (paramDescArray != null && paramDescArray.length > 0 && ExpressionToolKit.isParameter(iVariableExpression.expressionType())) {
            ExpressionToolKit.applyPattern(paramDescArray, iExpression, (IParameter)iVariableExpression, n, string, string2);
        } else if (specialFields != null && ExpressionToolKit.isConstant(iVariableExpression.expressionType())) {
            ExpressionToolKit.append(iExpression, (IConstant)iVariableExpression, string, string2, specialFields);
        } else if (ExpressionToolKit.isVariableList(iVariableExpression.expressionType())) {
            IVariableList iVariableList = (IVariableList)iVariableExpression;
            if (ExpressionToolKit.appendStringToBuffer(iVariableList, paramDescArray)) {
                IBinaryConditionExpression iBinaryConditionExpression = (IBinaryConditionExpression)iExpression;
                if (iBinaryConditionExpression.getOperator().operatorType() == 556793857) {
                    iExpression = SqlToFml.getBooleanTrue();
                } else if (iBinaryConditionExpression.getOperator().operatorType() == 556793858) {
                    iExpression = SqlToFml.getBooleanFalse();
                } else {
                    throw new RuntimeException();
                }
                return;
            }
            for (int i = 0; i < iVariableList.size(); ++i) {
                ExpressionToolKit.addSortInformation(paramDescArray, iVariableList, iVariableList.getVariableExp(i), i, string, string2, specialFields);
            }
        }
    }

    private static void append(IExpression iExpression, IConstant iConstant, String string, String string2, SpecialFields specialFields) throws DSException {
        if (iConstant.isSpecialField()) {
            try {
                String string3 = iConstant.getName();
                if (string3.equalsIgnoreCase("USERNAME")) {
                    iConstant.setValue(specialFields.getUserName());
                    iConstant.setDataType(12);
                } else if (string3.equalsIgnoreCase("PAGENUMBER")) {
                    iConstant.setValue(String.valueOf(specialFields.getPageNumber()));
                    iConstant.setDataType(4);
                } else if (string3.equalsIgnoreCase("MaxExistValue") || string3.equalsIgnoreCase("MinExistValue") || string3.equalsIgnoreCase("LastRefreshTime")) {
                    IExpressionFactory iExpressionFactory;
                    DbValue dbValue;
                    IVariableExpression iVariableExpression;
                    Object object;
                    IExpression[] iExpressionArray = new IExpression[3];
                    if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
                        object = (IBinary)((Object)iExpression);
                        iExpressionArray[0] = object.getExpression1();
                        iExpressionArray[1] = object.getExpression2();
                        iExpressionArray[2] = null;
                    } else if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
                        object = (ITriple)((Object)iExpression);
                        iExpressionArray[0] = object.getExpression1();
                        iExpressionArray[1] = object.getExpression2();
                        iExpressionArray[2] = object.getExpression3();
                    }
                    object = ExpressionToolKit.createQueryInfoFormula(iExpressionArray[0], iExpressionArray[1], iExpressionArray[2]);
                    int n = ExpressionToolKit.createReference(iConstant);
                    if (object != null && n > Integer.MIN_VALUE && ExpressionToolKit.isConstant((iVariableExpression = ExpressionToolKit.createSortInfoCollector(dbValue = specialFields.getSpecial2Value(new AggregationKey(n, (String)object)), string, string2, iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory())).expressionType())) {
                        if (((IConstant)iVariableExpression).isNull()) {
                            iConstant.setNull(true);
                        } else {
                            iConstant.setValue(((IConstant)iVariableExpression).getValue());
                            iConstant.setDataType(((IConstant)iVariableExpression).getDataType());
                        }
                    }
                }
            }
            catch (ConditionException conditionException) {
                throw new DSException(0, (Throwable)conditionException);
            }
        }
    }

    private static boolean appendStringToBuffer(IVariableList iVariableList, ParamDesc[] paramDescArray) throws ConditionException {
        for (int i = 0; i < iVariableList.size(); ++i) {
            ParamDesc paramDesc;
            if (!ExpressionToolKit.isParameter(iVariableList.getVariableExp(i).expressionType()) || (paramDesc = ExpressionToolKit.beforeWCParse(paramDescArray, iVariableList.getVariableExp(i).getName())) == null || !paramDesc.isAllSelected()) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void applyPattern(ParamDesc[] paramDescArray, IExpression iExpression, IParameter iParameter, int n, String string, String string2) throws ConditionException, DSException {
        Object object;
        Object object2;
        IVariableExpression iVariableExpression;
        Object object3;
        IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
        ParamDesc paramDesc = null;
        String string3 = iParameter.getName();
        paramDesc = ExpressionToolKit.beforeWCParse(paramDescArray, string3);
        if (paramDesc == null) return;
        Object object4 = null;
        if (paramDesc.isAllSelected()) {
            return;
        }
        DbValue dbValue = paramDesc.getValue();
        if (dbValue.isNull()) {
            object3 = iExpressionFactory.createConstant(string3);
            if (paramDesc.getValue().isNull()) {
                object3.setNull(true);
            }
            object4 = object3;
        } else if (dbValue instanceof fArray) {
            object3 = (fArray)dbValue;
            iVariableExpression = iExpressionFactory.createVariableList("");
            object2 = ((fArray)object3).value;
            for (int i = 0; i < ((DbValue[])object2).length; ++i) {
                object = iExpressionFactory.createConstant(string3);
                if (object2[i].isNull()) {
                    object.setNull(true);
                } else {
                    int n2 = ((DbValue)object2[i]).getColDesc().getSqlType();
                    if (Types.isTimeType(n2 = Types.sqlTypeToType(n2))) {
                        switch (n2) {
                            case 92: {
                                object.setValue(((DbTime)object2[i]).toFormatString("HH:mm:ss.SSS"));
                                break;
                            }
                            case 91: {
                                object.setValue(((DbDate)object2[i]).toFormatString("yyyy-MM-dd"));
                                break;
                            }
                            case 93: {
                                object.setValue(((DbDateTime)object2[i]).toFormatString("yyyy-MM-dd HH:mm:ss.SSS"));
                            }
                        }
                    } else {
                        object.setValue(((DbValue)object2[i]).toString());
                    }
                    object.setDataType(n2);
                }
                iVariableExpression.addConstant((IConstant)object);
            }
            object4 = iVariableExpression;
        } else {
            object3 = iExpressionFactory.createConstant(string3);
            if (paramDesc.getValue().isNull()) {
                object3.setNull(true);
            } else {
                int n3 = paramDesc.getValue().getSqlType();
                if (Types.isTimeType(n3 = Types.sqlTypeToType(n3))) {
                    switch (n3) {
                        case 92: {
                            object3.setValue(((DbTime)paramDesc.getValue()).toFormatString("HH:mm:ss.SSS"));
                            break;
                        }
                        case 91: {
                            object3.setValue(((DbDate)paramDesc.getValue()).toFormatString("yyyy-MM-dd"));
                            break;
                        }
                        case 93: {
                            object3.setValue(((DbDateTime)paramDesc.getValue()).toFormatString("yyyy-MM-dd HH:mm:ss.SSS"));
                        }
                    }
                } else {
                    String string4;
                    object2 = paramDesc.getValue();
                    if (((DbValue)object2).getSqlType() == 12) {
                        string4 = new CharBinaryFormat("XX").format((DbValue)object2);
                        if (string != null && string4 != null) {
                            object = string4;
                            string4 = string4.replace(string, string2);
                            if (addConstant.isDebugEnabled()) {
                                addConstant.debug("\t###EscapeReplaceCharacters### ExpressionToolKit.change2Constant()... replace string-type of parameter's value: oldVal =" + (String)object + ", newVal =" + string4 + "; paramName =" + string3 + "; strEscapeCharacters =" + string + ", strEscapeReplaced=" + string2);
                            }
                        }
                    } else {
                        string4 = ((DbValue)object2).toString();
                    }
                    object3.setValue(string4);
                }
                object3.setDataType(n3);
            }
            object4 = object3;
        }
        if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
            if (n != 1) throw new DSException(8479, new Object[]{String.valueOf(n)});
            ((ISingle)((Object)iExpression)).setExpression((IExpression)object4);
            return;
        } else if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
            if (n == 1) {
                ((IBinary)((Object)iExpression)).setExpression1((IVariableExpression)object4);
                return;
            } else {
                if (n != 2) throw new DSException(8480, new Object[]{String.valueOf(n)});
                ((IBinary)((Object)iExpression)).setExpression2((IVariableExpression)object4);
            }
            return;
        } else if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
            if (n == 1) {
                ((ITriple)((Object)iExpression)).setExpression1((IVariableExpression)object4);
                return;
            } else if (n == 2) {
                ((ITriple)((Object)iExpression)).setExpression2((IVariableExpression)object4);
                return;
            } else {
                if (n != 3) throw new DSException(8481, new Object[]{String.valueOf(n)});
                ((ITriple)((Object)iExpression)).setExpression3((IVariableExpression)object4);
            }
            return;
        } else {
            if (!ExpressionToolKit.isVariableList(iExpression.expressionType())) return;
            object3 = (IVariableList)iExpression;
            if (!(object4 instanceof IVariableExpression)) return;
            if (object4 instanceof IVariableList) {
                iVariableExpression = (IVariableList)object4;
                object3.remove(n);
                for (int i = 0; i < iVariableExpression.size(); ++i) {
                    object3.addConstant((IConstant)iVariableExpression.getVariableExp(i));
                }
                return;
            } else {
                if (!(object4 instanceof IConstant)) return;
                iVariableExpression = (IConstant)object4;
                object3.setConstant((IConstant)iVariableExpression, n);
            }
        }
    }

    private static ParamDesc beforeWCParse(ParamDesc[] paramDescArray, String string) {
        int n = paramDescArray.length;
        for (int i = 0; i < n; ++i) {
            if (!paramDescArray[i].getName().equalsIgnoreCase(string)) continue;
            return paramDescArray[i];
        }
        return null;
    }

    public static IExpression changeConstantEncoding(IExpression iExpression, JetUDatabase jetUDatabase) throws DSException {
        return iExpression;
    }

    private static JAttribute buildAndExpression(JetUResourceField jetUResourceField) throws DSException {
        if (jetUResourceField instanceof JetUFormula) {
            JetUFormula jetUFormula = (JetUFormula)jetUResourceField;
            String string = jetUFormula.getResourceName();
            Formula formula2 = new Formula(string, jetUFormula);
            return new FormulaMapping(formula2.getName(), formula2);
        }
        assert (false) : "resourceNode not JetUFormula";
        return null;
    }

    public static void checkIVarExpTypeCompatible(JetUUniverse jetUUniverse, String string, BLNode bLNode, IVariableExpression iVariableExpression, IVariableExpression iVariableExpression2, Scope scope) throws ConditionException {
        try {
            ExpressionToolKit.buildExpression(jetUUniverse, string, bLNode, iVariableExpression, iVariableExpression2, scope);
        }
        catch (DSException dSException) {
            throw new ConditionException(8503, (Object[])new String[]{dSException.getMessage()}, (Throwable)dSException);
        }
    }

    public static void checkLikeOrNotLikeExp(JetUUniverse jetUUniverse, String string, BLNode bLNode, IBinaryConditionOperator iBinaryConditionOperator, IVariableExpression iVariableExpression, IVariableExpression iVariableExpression2, Scope scope) throws ConditionException {
        if (OperatorToolKit.isLike(iBinaryConditionOperator.operatorType()) || OperatorToolKit.isNotLike(iBinaryConditionOperator.operatorType())) {
            try {
                int n;
                int n2 = ExpressionToolKit.buildOrExpression(jetUUniverse.getDatabase(string), bLNode, iVariableExpression, scope);
                if (!Types.isStringType(n2)) {
                    throw new ConditionException(8504);
                }
                if (!ExpressionToolKit.isConstant(iVariableExpression2.expressionType()) && !Types.isStringType(n = ExpressionToolKit.buildOrExpression(jetUUniverse.getDatabase(string), bLNode, iVariableExpression2, scope))) {
                    throw new ConditionException(8505);
                }
            }
            catch (DSException dSException) {
                throw new ConditionException(8506, (Object[])new String[]{dSException.getMessage()}, (Throwable)dSException);
            }
        }
    }

    private static void buildExpression(JetUUniverse jetUUniverse, String string, BLNode bLNode, IVariableExpression iVariableExpression, IVariableExpression iVariableExpression2, Scope scope) throws ConditionException, DSException {
        IVariableExpression iVariableExpression3;
        int n;
        int n2;
        int n3 = iVariableExpression.expressionType();
        int n4 = iVariableExpression2.expressionType();
        if (!(ExpressionToolKit.isConstant(n3) || ExpressionToolKit.isVariableList(n3) || ExpressionToolKit.isConstant(n4) || ExpressionToolKit.isVariableList(n4) || ExpressionToolKit.changeParam2Constant(n2 = ExpressionToolKit.buildOrExpression(jetUUniverse.getDatabase(string), bLNode, iVariableExpression, scope), n = ExpressionToolKit.buildOrExpression(jetUUniverse.getDatabase(string), bLNode, iVariableExpression2, scope)))) {
            throw new ConditionException(8485);
        }
        if (ExpressionToolKit.isConstant(n3)) {
            if (ExpressionToolKit.isConstant(n4)) {
                return;
            }
            if (ExpressionToolKit.isVariableList(n4)) {
                IVariableList iVariableList = (IVariableList)iVariableExpression2;
                for (n = 0; n < iVariableList.size(); ++n) {
                    iVariableExpression3 = iVariableList.getVariableExp(n);
                    ExpressionToolKit.buildExpression(jetUUniverse, string, bLNode, iVariableExpression, iVariableExpression3, scope);
                }
            } else {
                n2 = ExpressionToolKit.buildOrExpression(jetUUniverse.getDatabase(string), bLNode, iVariableExpression2, scope);
                if (!ExpressionToolKit.parseConstantType(n2, (IConstant)iVariableExpression)) {
                    throw new ConditionException(8486);
                }
            }
        }
        if (ExpressionToolKit.isConstant(n4)) {
            if (ExpressionToolKit.isConstant(n3)) {
                return;
            }
            if (ExpressionToolKit.isVariableList(n3)) {
                return;
            }
            n2 = ExpressionToolKit.buildOrExpression(jetUUniverse.getDatabase(string), bLNode, iVariableExpression, scope);
            if (!ExpressionToolKit.parseConstantType(n2, (IConstant)iVariableExpression2)) {
                throw new ConditionException(8487);
            }
        }
        if (ExpressionToolKit.isVariableList(n3)) {
            if (ExpressionToolKit.isVariableList(n4)) {
                return;
            }
            IVariableList iVariableList = (IVariableList)iVariableExpression;
            for (n = 0; n < iVariableList.size(); ++n) {
                iVariableExpression3 = iVariableList.getVariableExp(n);
                ExpressionToolKit.buildExpression(jetUUniverse, string, bLNode, iVariableExpression3, iVariableExpression2, scope);
            }
        }
        if (ExpressionToolKit.isVariableList(n4)) {
            if (ExpressionToolKit.isVariableList(n3)) {
                return;
            }
            IVariableList iVariableList = (IVariableList)iVariableExpression2;
            for (n = 0; n < iVariableList.size(); ++n) {
                iVariableExpression3 = iVariableList.getVariableExp(n);
                ExpressionToolKit.buildExpression(jetUUniverse, string, bLNode, iVariableExpression, iVariableExpression3, scope);
            }
        }
    }

    public static DataElementInfo getElement(BLNode bLNode, String string) {
        if (bLNode == null || string == null) {
            return null;
        }
        if (bLNode instanceof JUnifiedBusinessView) {
            return (DataElementInfo)((JUnifiedBusinessView)bLNode).getByDisplayName(string);
        }
        return (DataElementInfo)((JBusinessLogic)bLNode).get(string);
    }

    private static int buildOrExpression(JetUDatabase jetUDatabase, BLNode bLNode, IVariableExpression iVariableExpression, Scope scope) throws ConditionException, DSException {
        int n = iVariableExpression.expressionType();
        String string = iVariableExpression.getName();
        String string2 = null;
        if (ExpressionToolKit.isDataContainerReference(n)) {
            IDataContainerReference iDataContainerReference = (IDataContainerReference)iVariableExpression;
            if (iDataContainerReference.getDataType() == 0) {
                return Types.sqlTypeToType(3);
            }
            return Types.sqlTypeToType(iDataContainerReference.getDataType());
        }
        if (ExpressionToolKit.isReference(n) || ExpressionToolKit.isQueryInfoReference(n)) {
            Object object;
            IReference iReference = (IReference)iVariableExpression;
            QueryInfo queryInfo = null;
            if (iReference.isQualifyName()) {
                Object object2;
                object = null;
                if (ExpressionToolKit.isReference(n)) {
                    object = bLNode;
                } else {
                    object2 = (JetUUniverse)jetUDatabase.getParent();
                    queryInfo = ((IQueryInfoReference)iVariableExpression).getQueryInfo();
                    if (queryInfo.getQueryType() == 5) {
                        object = ((JetUUniverse)object2).getBV(queryInfo.getDSName(), queryInfo.getUBVName());
                    }
                }
                if (object != null) {
                    object2 = ExpressionToolKit.getElement((BLNode)object, string);
                    if (object2 != null) {
                        string = object2.getRefMappingName();
                        if (object2 instanceof MeasureInfo) {
                            string2 = ((MeasureInfo)object2).getAggFunction();
                        }
                    } else {
                        BLNode bLNode2 = scope.getBLNodeByQualifiedDisplayName(string);
                        if (bLNode2 != null && bLNode2 instanceof JetRptFlyFormula) {
                            JetRptFlyFormula jetRptFlyFormula = (JetRptFlyFormula)bLNode2;
                            JetUFormula jetUFormula = jetRptFlyFormula.getJetUFormula();
                            if (jetUFormula != null) {
                                String string3 = jetUFormula.getResourceName();
                                Formula formula2 = new Formula(string3, jetUFormula);
                                return Types.sqlTypeToType(formula2.getDataType());
                            }
                        } else if (bLNode2 != null && bLNode2 instanceof JetRptFlyMeasure) {
                            JetRptFlyMeasure jetRptFlyMeasure = (JetRptFlyMeasure)bLNode2;
                            String string4 = jetRptFlyMeasure.getAggFunction();
                            String string5 = jetRptFlyMeasure.getBasedFieldName();
                            JetUResourceEntity jetUResourceEntity = null;
                            BLNode bLNode3 = scope.getBLNodeByQualifiedDisplayName(string5);
                            if (bLNode3 != null) {
                                DataElementInfo dataElementInfo;
                                if (bLNode3 instanceof JetRptFlyFormula) {
                                    dataElementInfo = (JetRptFlyFormula)bLNode3;
                                    JetUFormula jetUFormula = ((JetRptAbstractFormula)((Object)dataElementInfo)).getJetUFormula();
                                    if (jetUFormula != null) {
                                        String string6 = jetUFormula.getResourceName();
                                        Formula formula3 = new Formula(string6, jetUFormula);
                                        return Types.sqlTypeToType(formula3.getDataType());
                                    }
                                } else if (bLNode3 instanceof DataElementInfo) {
                                    dataElementInfo = (DataElementInfo)bLNode3;
                                    String string7 = dataElementInfo.getRefMappingName();
                                    jetUResourceEntity = jetUDatabase.getResourceByName(string7);
                                }
                                if (jetUResourceEntity != null) {
                                    int n2 = jetUResourceEntity.getColDesc().getSqlType();
                                    return Types.getFuncSqlType(string4, n2);
                                }
                            }
                        }
                    }
                }
            }
            object = null;
            object = queryInfo != null ? queryInfo.getDSName() : jetUDatabase.getResourceName();
            int n3 = ((JetUUniverse)jetUDatabase.getParent()).getResourceByName((String)object, null, string).getColDesc().getSqlType();
            if (string2 != null) {
                n3 = Types.getFuncSqlType(string2, n3);
            }
            return Types.sqlTypeToType(n3);
        }
        if (ExpressionToolKit.isParameter(n)) {
            JetUResourceEntity jetUResourceEntity;
            JetUParameter jetUParameter = jetUDatabase.getParameterByResourceName(string);
            if (jetUParameter == null && (jetUResourceEntity = scope.getResourceEntity(string, false)) instanceof JetUParameter) {
                jetUParameter = (JetUParameter)jetUResourceEntity;
            }
            int n4 = jetUParameter.getParamDesc().getValue().getSqlType();
            return Types.sqlTypeToType(n4);
        }
        if (ExpressionToolKit.isFormula(n) || ExpressionToolKit.isQueryInfoFormula(n)) {
            JetRptFlyFormula jetRptFlyFormula;
            String string8 = null;
            string8 = ExpressionToolKit.isQueryInfoFormula(n) ? ((IQueryInfoFormula)iVariableExpression).getQueryInfo().getDSName() : jetUDatabase.getResourceName();
            JetUResourceEntity jetUResourceEntity = ((JetUUniverse)jetUDatabase.getParent()).getResourceByName(string8, null, string);
            if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUFormula) {
                JetUFormula jetUFormula = (JetUFormula)jetUResourceEntity;
                String string9 = jetUFormula.getResourceName();
                Formula formula4 = new Formula(string9, jetUFormula);
                return formula4.getDataType();
            }
            if (scope != null && (jetRptFlyFormula = scope.getOnTheFlyFormulaByMappingName(string)) != null) {
                JetUFormula jetUFormula = jetRptFlyFormula.getJetUFormula();
                String string10 = jetUFormula.getResourceName();
                Formula formula5 = new Formula(string10, jetUFormula);
                return formula5.getDataType();
            }
        }
        throw new ConditionException(5869, new String[]{String.valueOf(n)});
    }

    private static boolean changeParam2Constant(int n, int n2) {
        return Types.isCompatible(n, n2);
    }

    private static boolean changeParamSpecial2Constant(int n) {
        return n == 4 || n == -5 || n == 5 || n == -6;
    }

    private static boolean checkExpAllName(int n) {
        return n == 8 || n == 6 || n == 3;
    }

    public static boolean parseConstantType(int n, IConstant iConstant) throws DSException, ConditionException {
        int n2 = iConstant.getDataType();
        if (n2 != 0) {
            return Types.isCompatible(n, n2);
        }
        if (iConstant.isSpecialField() && (iConstant.getName().equalsIgnoreCase("MaxExistValue") || iConstant.getName().equalsIgnoreCase("MinExistValue") || iConstant.getName().equalsIgnoreCase("LastRefreshTime"))) {
            return true;
        }
        Object object = ExpressionToolKit.parseConstant(n, iConstant);
        return object != null;
    }

    public static Object parseConstant(int n, IConstant iConstant) throws DSException, ConditionException {
        String string = iConstant.getValue();
        Object object = null;
        switch (n) {
            case -7: {
                if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no") || string.equalsIgnoreCase("0")) {
                    return new Boolean(false);
                }
                if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("1")) {
                    return new Boolean(true);
                }
                return null;
            }
            case -6: {
                try {
                    object = new Byte(Byte.parseByte(string));
                }
                catch (Exception exception) {
                    return null;
                }
                return object;
            }
            case 5: {
                try {
                    object = new Short(Short.parseShort(string));
                }
                catch (Exception exception) {
                    return null;
                }
                return object;
            }
            case 4: {
                try {
                    object = new Integer(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    return null;
                }
                return object;
            }
            case -5: {
                try {
                    object = new Long(Long.parseLong(string));
                }
                catch (Exception exception) {
                    return null;
                }
                return object;
            }
            case 6: {
                try {
                    object = new Float(Float.parseFloat(string));
                }
                catch (Exception exception) {
                    return null;
                }
                return object;
            }
            case 8: {
                try {
                    object = new Double(Double.parseDouble(string));
                }
                catch (Exception exception) {
                    return null;
                }
                return object;
            }
            case 3: {
                try {
                    object = new BigDecimal(string);
                }
                catch (Exception exception) {
                    return null;
                }
                return object;
            }
            case 91: {
                try {
                    iConstant.setDataType(91);
                    object = iConstant.getObjectValue();
                }
                catch (Exception exception) {
                    return null;
                }
                return object;
            }
            case 93: {
                try {
                    iConstant.setDataType(93);
                    object = iConstant.getObjectValue();
                }
                catch (Exception exception) {
                    return null;
                }
                return object;
            }
            case 92: {
                try {
                    iConstant.setDataType(92);
                    object = iConstant.getObjectValue();
                }
                catch (Exception exception) {
                    return null;
                }
                return object;
            }
            case 12: {
                return string;
            }
        }
        throw new DSException(5868, new String[]{Types.getDataTypeName(n)});
    }

    public static void checkExpAllName(JetUUniverse jetUUniverse, String string, IExpression iExpression) throws ConditionException {
        ExpressionToolKit.checkExpAllName(jetUUniverse, string, iExpression, null);
    }

    public static void checkExpAllName(JetUUniverse jetUUniverse, String string, IExpression iExpression, Scope scope) throws ConditionException {
        ResourceContainer resourceContainer = null;
        ParameterValueList parameterValueList = new ParameterValueList();
        try {
            JetUFormula[] jetUFormulaArray = null;
            if (scope != null) {
                List list = scope.getDynamicFormulaList();
                ArrayList<JetUFormula> arrayList = new ArrayList<JetUFormula>();
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    JetUFormula jetUFormula = ((JetRptAbstractFormula)list.get(i)).getJetUFormula();
                    if (!QueryTransform.isConstantFormula(jetUFormula) && !QueryTransform.isPass1Formula(jetUFormula)) continue;
                    arrayList.add(jetUFormula);
                }
                jetUFormulaArray = arrayList.toArray(new JetUFormula[0]);
                List list2 = scope.getDynamicParameterList();
                n = list2.size();
                for (int i = 0; i < n; ++i) {
                    JetUParameter jetUParameter = (JetUParameter)list2.get(i);
                    parameterValueList.addParameterValue(jetUParameter.getParamDesc());
                }
            }
            resourceContainer = new ResourceContainer(jetUUniverse, string, parameterValueList, jetUFormulaArray);
        }
        catch (DSException dSException) {
            throw new ConditionException(8484, (Object[])new String[]{dSException.getMessage()}, (Throwable)dSException);
        }
        ExpressionToolKit.checkSPFieldInExp(resourceContainer, iExpression);
    }

    private static void checkSPFieldInExp(ResourceContainer resourceContainer, IExpression iExpression) throws ConditionException {
        if (iExpression != null) {
            if (ExpressionToolKit.isSetExp(iExpression.expressionType())) {
                ExpressionToolKit.checkSPFieldInExp(resourceContainer, ((ISetExpression)iExpression).getExpression());
            } else if (ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
                ExpressionToolKit.clone(resourceContainer, (IVariableExpression)iExpression);
            } else if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
                ExpressionToolKit.checkSPFieldInExp(resourceContainer, ((ISingle)((Object)iExpression)).getExpression());
            } else if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
                ExpressionToolKit.checkSPFieldInExp(resourceContainer, ((IBinary)((Object)iExpression)).getExpression1());
                ExpressionToolKit.checkSPFieldInExp(resourceContainer, ((IBinary)((Object)iExpression)).getExpression2());
            } else if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
                ExpressionToolKit.checkSPFieldInExp(resourceContainer, ((ITriple)((Object)iExpression)).getExpression1());
                ExpressionToolKit.checkSPFieldInExp(resourceContainer, ((ITriple)((Object)iExpression)).getExpression2());
                ExpressionToolKit.checkSPFieldInExp(resourceContainer, ((ITriple)((Object)iExpression)).getExpression3());
            }
        }
    }

    private static void clone(ResourceContainer resourceContainer, IVariableExpression iVariableExpression) throws ConditionException {
        if (ExpressionToolKit.isConstant(iVariableExpression.expressionType())) {
            return;
        }
        if (ExpressionToolKit.isVariableList(iVariableExpression.expressionType())) {
            return;
        }
        if (!resourceContainer.containsIgnoreCase(iVariableExpression.getName())) {
            throw new ConditionException(8483, new String[]{iVariableExpression.getName()});
        }
    }

    public static IExpression cloneExpression(IExpression iExpression) throws ConditionException {
        if (iExpression == null) {
            return null;
        }
        return ExpressionToolKit.cloneExpression(iExpression, null, true, null, null);
    }

    public static IExpression toRuntimeColumnName(IExpression iExpression, HashMap hashMap, HashSet hashSet) throws ConditionException {
        return ExpressionToolKit.cloneExpression(iExpression, null, true, hashMap, hashSet);
    }

    public static IExpression toRuntimeColumnName(IExpression iExpression, HashMap hashMap) throws ConditionException {
        return ExpressionToolKit.toRuntimeColumnName(iExpression, hashMap, null);
    }

    private static IExpression cloneExpression(IExpression iExpression, Scope scope, boolean bl, HashMap hashMap, HashSet hashSet) throws ConditionException {
        IExpression iExpression2 = null;
        if (ExpressionToolKit.isUnCheckedExp(iExpression.expressionType())) {
            iExpression2 = ExpressionToolKit.containsIgnoreCase((IUnCheckedExpression)iExpression, null, -1);
        } else if (ExpressionToolKit.isSetExp(iExpression.expressionType())) {
            iExpression2 = ExpressionToolKit.containedSortExp((ISetExpression)iExpression, scope, bl, hashMap, hashSet);
        } else if (ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
            iExpression2 = ExpressionToolKit.createBinaryConditionOp((IVariableExpression)iExpression, scope, bl, hashMap, hashSet);
        } else if (ExpressionToolKit.isCalculateExp(iExpression.expressionType())) {
            iExpression2 = ExpressionToolKit.createBinaryLogicExp((ICalculateExpression)iExpression, scope, bl, hashMap, hashSet);
        } else if (ExpressionToolKit.isTupleExp(iExpression.expressionType())) {
            iExpression2 = ExpressionToolKit.contains(iExpression, scope, bl, hashMap, hashSet);
        } else if (ExpressionToolKit.isRelationExp(iExpression.expressionType())) {
            iExpression2 = ExpressionToolKit.createBinaryLogicOp(iExpression);
        }
        return iExpression2;
    }

    private static ISetExpression containedSortExp(ISetExpression iSetExpression, Scope scope, boolean bl, HashMap hashMap, HashSet hashSet) throws ConditionException {
        ISetExpression iSetExpression2 = null;
        IExpression iExpression = iSetExpression.getExpression();
        IExpression iExpression2 = null;
        if (iExpression == null) {
            if (ExpressionToolKit.isSortExp(iSetExpression.expressionType())) {
                ISortOperator iSortOperator = ExpressionToolKit.containedTupleExp(iSetExpression);
                return SqlToFml.createSortExp(iSortOperator);
            }
            if (ExpressionToolKit.isTopNExp(iSetExpression.expressionType())) {
                ITopNOperator iTopNOperator = ExpressionToolKit.containedTopNExp(iSetExpression);
                return SqlToFml.createTopNExp(iTopNOperator);
            }
        }
        if (ExpressionToolKit.isTupleExp(iExpression.expressionType())) {
            ISetOperator iSetOperator;
            iExpression2 = ExpressionToolKit.contains((ITupleExpression)iExpression, scope, bl, hashMap, hashSet);
            if (ExpressionToolKit.isSortExp(iSetExpression.expressionType())) {
                iSetOperator = ExpressionToolKit.containedTupleExp(iSetExpression);
                iSetExpression2 = SqlToFml.createSortExp((ITupleExpression)iExpression2, (ISortOperator)iSetOperator);
            }
            if (ExpressionToolKit.isTopNExp(iSetExpression.expressionType())) {
                iSetOperator = ExpressionToolKit.containedTopNExp(iSetExpression);
                iSetExpression2 = SqlToFml.createTopNExp((ITupleExpression)iExpression2, (ITopNOperator)iSetOperator);
            }
        } else if (ExpressionToolKit.isSetExp(iExpression.expressionType())) {
            ISetOperator iSetOperator;
            iExpression2 = ExpressionToolKit.containedSortExp((ISetExpression)iExpression, scope, bl, hashMap, hashSet);
            if (ExpressionToolKit.isTopNExp(iSetExpression.expressionType())) {
                iSetOperator = ExpressionToolKit.containedTopNExp(iSetExpression);
                iSetExpression2 = SqlToFml.createTopNExp((ISetExpression)iExpression2, (ITopNOperator)iSetOperator);
            }
            if (ExpressionToolKit.isSortExp(iSetExpression.expressionType())) {
                iSetOperator = ExpressionToolKit.containedTupleExp(iSetExpression);
                iSetExpression2 = SqlToFml.createSortExp((ISetExpression)iExpression2, (ISortOperator)iSetOperator);
            }
        } else {
            throw new ConditionException(8493);
        }
        return iSetExpression2;
    }

    private static ITopNOperator containedTopNExp(ISetExpression iSetExpression) throws ConditionException {
        ITopNOperator iTopNOperator = (ITopNOperator)((ITopNExpression)iSetExpression).getOperator();
        ITopNInformation iTopNInformation = (ITopNInformation)iTopNOperator.getOperatorInformation();
        ITopNInformation iTopNInformation2 = addAll.createTopNInfo(iTopNInformation.getTopNType(), iTopNInformation.getN());
        ITopNOperator iTopNOperator2 = add.createTopNOp(iTopNInformation2);
        return iTopNOperator2;
    }

    private static ISortOperator containedTupleExp(ISetExpression iSetExpression) throws ConditionException {
        ISortOperator iSortOperator = (ISortOperator)((ISortExpression)iSetExpression).getOperator();
        ISortInformationCollector iSortInformationCollector = (ISortInformationCollector)iSortOperator.getOperatorInformation();
        ISortInformationCollector iSortInformationCollector2 = addAll.createSortInfoCollector();
        for (int i = 0; i < iSortInformationCollector.size(); ++i) {
            ISortInformation iSortInformation = iSortInformationCollector.getSortInformation(i);
            ISortInformation iSortInformation2 = addAll.createSortInfo(SqlToFml.createReference(iSortInformation.getReference().getName()), iSortInformation.getSortType(), iSortInformation.isIgnoreCase());
            iSortInformationCollector2.addSortInformation(iSortInformation2);
        }
        ISortOperator iSortOperator2 = add.createSortOp(iSortInformationCollector2);
        return iSortOperator2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IExpression contains(IExpression iExpression, Scope scope, boolean bl, HashMap hashMap, HashSet hashSet) throws ConditionException {
        int n = iExpression.expressionType();
        int n2 = -1;
        if (ExpressionToolKit.isVariableExp(n)) {
            return ExpressionToolKit.createBinaryConditionOp((IVariableExpression)iExpression, scope, bl, hashMap, hashSet);
        }
        if (!ExpressionToolKit.isTupleExp(n)) throw new ConditionException(8490);
        if (ExpressionToolKit.isSingleExp(n)) {
            ISingleBooleanExpression iSingleBooleanExpression = (ISingleBooleanExpression)iExpression;
            n2 = iSingleBooleanExpression.getOperator().operatorType();
            IExpression iExpression2 = ExpressionToolKit.cloneExpression(iSingleBooleanExpression.getExpression(), scope, bl, hashMap, hashSet);
            if (OperatorToolKit.isLogicOperator(n2)) {
                if (n2 != 0x11500001) throw new ConditionException(5805);
                if (ExpressionToolKit.isBooleanExp(iExpression2.expressionType())) {
                    return SqlToFml.createSingleLogicExp(add.createNotOp(), (IBooleanExpression)iExpression2);
                }
                if (!ExpressionToolKit.isVariableExp(iExpression2.expressionType())) return null;
                return SqlToFml.createSingleLogicExp(add.createNotOp(), (IVariableExpression)iExpression2);
            }
            if (!OperatorToolKit.isConditionOperator(n2) || !ExpressionToolKit.isVariableExp(iExpression2.expressionType())) throw new ConditionException(8492);
            return SqlToFml.createSingleConditionExp(add.createSingleConsitionOp(n2), (IVariableExpression)iExpression2);
        }
        if (ExpressionToolKit.isBinaryExp(n)) {
            IBinaryBooleanExpression iBinaryBooleanExpression = (IBinaryBooleanExpression)iExpression;
            n2 = iBinaryBooleanExpression.getOperator().operatorType();
            if (OperatorToolKit.isBinaryConditionOperator(n2)) {
                IExpression iExpression3 = iBinaryBooleanExpression.getExpression1();
                IExpression iExpression4 = iBinaryBooleanExpression.getExpression2();
                if (iExpression3 instanceof ICalculateExpression) {
                    if (!(iExpression4 instanceof ICalculateExpression)) return SqlToFml.createBinaryConditionExp(add.createBinaryConditionOp(n2), ExpressionToolKit.createBinaryLogicExp((ICalculateExpression)iExpression3, scope, bl, hashMap, hashSet), ExpressionToolKit.createBinaryConditionOp((IVariableExpression)iExpression4, scope, bl, hashMap, hashSet));
                    return SqlToFml.createBinaryConditionExp(add.createBinaryConditionOp(n2), ExpressionToolKit.createBinaryLogicExp((ICalculateExpression)iExpression3, scope, bl, hashMap, hashSet), ExpressionToolKit.createBinaryLogicExp((ICalculateExpression)iExpression4, scope, bl, hashMap, hashSet));
                }
                if (!(iExpression3 instanceof IVariableExpression)) throw new ConditionException(8491);
                if (!(iExpression4 instanceof ICalculateExpression)) return SqlToFml.createBinaryConditionExp(add.createBinaryConditionOp(n2), ExpressionToolKit.createBinaryConditionOp((IVariableExpression)iExpression3, scope, bl, hashMap, hashSet), ExpressionToolKit.createBinaryConditionOp((IVariableExpression)iExpression4, scope, bl, hashMap, hashSet));
                return SqlToFml.createBinaryConditionExp(add.createBinaryConditionOp(n2), ExpressionToolKit.createBinaryConditionOp((IVariableExpression)iExpression3, scope, bl, hashMap, hashSet), ExpressionToolKit.createBinaryLogicExp((ICalculateExpression)iExpression4, scope, bl, hashMap, hashSet));
            }
            if (!OperatorToolKit.isBinaryLogicOperator(n2) && !OperatorToolKit.isMultiLogicOperator(n2)) return null;
            IExpression iExpression5 = ExpressionToolKit.cloneExpression(iBinaryBooleanExpression.getExpression1(), scope, bl, hashMap, hashSet);
            IExpression iExpression6 = ExpressionToolKit.cloneExpression(iBinaryBooleanExpression.getExpression2(), scope, bl, hashMap, hashSet);
            if (ExpressionToolKit.isVariableExp(iExpression5.expressionType())) {
                if (!ExpressionToolKit.isVariableExp(iExpression6.expressionType())) return SqlToFml.createBinaryLogicExp(add.createBinaryLogicOp(n2), (IVariableExpression)iExpression5, (IBooleanExpression)iExpression6);
                return SqlToFml.createBinaryLogicExp(add.createBinaryLogicOp(n2), (IVariableExpression)iExpression5, (IVariableExpression)iExpression6);
            }
            if (!ExpressionToolKit.isBooleanExp(iExpression5.expressionType())) throw new ConditionException(8491);
            if (!ExpressionToolKit.isVariableExp(iExpression6.expressionType())) return SqlToFml.createBinaryLogicExp(add.createBinaryLogicOp(n2), (IBooleanExpression)iExpression5, (IBooleanExpression)iExpression6);
            return SqlToFml.createBinaryLogicExp(add.createBinaryLogicOp(n2), (IBooleanExpression)iExpression5, (IVariableExpression)iExpression6);
        }
        if (ExpressionToolKit.isTripleExp(n)) {
            ITripleTupleExpression iTripleTupleExpression = (ITripleTupleExpression)iExpression;
            IExpression iExpression7 = ExpressionToolKit.cloneExpression(iTripleTupleExpression.getExpression1(), scope, bl, hashMap, hashSet);
            IExpression iExpression8 = ExpressionToolKit.cloneExpression(iTripleTupleExpression.getExpression2(), scope, bl, hashMap, hashSet);
            IExpression iExpression9 = ExpressionToolKit.cloneExpression(iTripleTupleExpression.getExpression3(), scope, bl, hashMap, hashSet);
            assert ((ExpressionToolKit.isVariableExp(iExpression7.expressionType()) || ExpressionToolKit.isCalculateExp(iExpression7.expressionType())) && ExpressionToolKit.isVariableExp(iExpression8.expressionType()) && ExpressionToolKit.isVariableExp(iExpression9.expressionType())) : "The sub exp must is variable exp";
            n2 = iTripleTupleExpression.getOperator().operatorType();
            if (!ExpressionToolKit.isCalculateExp(iExpression7.expressionType())) return SqlToFml.createTripleConditionExp(add.createTripleConditionOp(n2), (IVariableExpression)iExpression7, (IVariableExpression)iExpression8, (IVariableExpression)iExpression9);
            return SqlToFml.createTripleConditionExp(add.createTripleConditionOp(n2), (ICalculateExpression)iExpression7, (IVariableExpression)iExpression8, (IVariableExpression)iExpression9);
        }
        if (!ExpressionToolKit.isMultiExp(n)) return null;
        IMultiLogicExpression iMultiLogicExpression = (IMultiLogicExpression)iExpression;
        IExpression[] iExpressionArray = iMultiLogicExpression.getExpressions();
        for (int i = 0; i < iExpressionArray.length; ++i) {
            iExpressionArray[i] = ExpressionToolKit.cloneExpression(iExpressionArray[i], scope, bl, hashMap, hashSet);
        }
        n2 = iMultiLogicExpression.getOperator().operatorType();
        return SqlToFml.createMultiLogicExp(add.createMultiLogicOp(n2), iExpressionArray);
    }

    private static IUnCheckedExpression containsIgnoreCase(IUnCheckedExpression iUnCheckedExpression, RptPsqlQuery rptPsqlQuery, int n) throws ConditionException {
        int n2 = iUnCheckedExpression.expressionType();
        if (ExpressionToolKit.isVariableExp(n2)) {
            IUnCheckedVariableExpression iUnCheckedVariableExpression = SqlToFml.createUnCheckedVariableExpression(((IUnCheckedVariableExpression)iUnCheckedExpression).getValue(), ((IUnCheckedVariableExpression)iUnCheckedExpression).isConstantValue());
            if (rptPsqlQuery != null && n == 0) {
                ExpressionToolKit.translateToMappingName(iUnCheckedVariableExpression, rptPsqlQuery);
            } else if (rptPsqlQuery != null && n == 1) {
                ExpressionToolKit.translateToRealName(iUnCheckedVariableExpression, rptPsqlQuery);
            }
            return iUnCheckedVariableExpression;
        }
        if (ExpressionToolKit.isSingleExp(n2)) {
            IUnCheckedSingleExpression iUnCheckedSingleExpression = (IUnCheckedSingleExpression)iUnCheckedExpression;
            String string = iUnCheckedSingleExpression.getOperator().getOperationString();
            return SqlToFml.createUnCheckedSingleExpression(add.createUnCheckedOperator(string), ExpressionToolKit.containsIgnoreCase(iUnCheckedSingleExpression.getExpression(), rptPsqlQuery, n));
        }
        if (ExpressionToolKit.isBinaryExp(n2)) {
            IUnCheckedBinaryExpression iUnCheckedBinaryExpression = (IUnCheckedBinaryExpression)iUnCheckedExpression;
            String string = iUnCheckedBinaryExpression.getOperator().getOperationString();
            IUnCheckedExpression iUnCheckedExpression2 = ExpressionToolKit.containsIgnoreCase(iUnCheckedBinaryExpression.getExpression1(), rptPsqlQuery, n);
            IUnCheckedExpression iUnCheckedExpression3 = ExpressionToolKit.containsIgnoreCase(iUnCheckedBinaryExpression.getExpression2(), rptPsqlQuery, n);
            return SqlToFml.createUnCheckedBinaryExpression(add.createUnCheckedOperator(string), iUnCheckedExpression2, iUnCheckedExpression3);
        }
        if (ExpressionToolKit.isTripleExp(n2)) {
            IUnCheckedTripleExpression iUnCheckedTripleExpression = (IUnCheckedTripleExpression)iUnCheckedExpression;
            String string = iUnCheckedTripleExpression.getOperator().getOperationString();
            IUnCheckedExpression iUnCheckedExpression4 = ExpressionToolKit.containsIgnoreCase(iUnCheckedTripleExpression.getExpression1(), rptPsqlQuery, n);
            IUnCheckedExpression iUnCheckedExpression5 = ExpressionToolKit.containsIgnoreCase(iUnCheckedTripleExpression.getExpression2(), rptPsqlQuery, n);
            IUnCheckedExpression iUnCheckedExpression6 = ExpressionToolKit.containsIgnoreCase(iUnCheckedTripleExpression.getExpression3(), rptPsqlQuery, n);
            return SqlToFml.createUnCheckedTripleExpression(add.createUnCheckedOperator(string), iUnCheckedExpression4, iUnCheckedExpression5, iUnCheckedExpression6);
        }
        if (ExpressionToolKit.isMultiExp(n2)) {
            IUnCheckedMultiExpression iUnCheckedMultiExpression = (IUnCheckedMultiExpression)iUnCheckedExpression;
            String string = iUnCheckedMultiExpression.getOperator().getOperationString();
            IUnCheckedExpression[] iUnCheckedExpressionArray = iUnCheckedMultiExpression.getExpressions();
            IUnCheckedExpression[] iUnCheckedExpressionArray2 = new IUnCheckedExpression[iUnCheckedExpressionArray.length];
            for (int i = 0; i < iUnCheckedExpressionArray.length; ++i) {
                iUnCheckedExpressionArray2[i] = ExpressionToolKit.containsIgnoreCase(iUnCheckedExpressionArray[i], rptPsqlQuery, n);
            }
            return SqlToFml.createUnCheckedMultiExpression(add.createUnCheckedOperator(string), iUnCheckedExpressionArray2);
        }
        throw new ConditionException(8490);
    }

    public static IUnCheckedExpression buildUnCheckedExp(JetUDatabase jetUDatabase, IExpression iExpression) throws ConditionException {
        return ExpressionToolKit.createBinaryConditionExp(jetUDatabase, iExpression, 0);
    }

    private static IUnCheckedExpression createBinaryConditionExp(JetUDatabase jetUDatabase, IExpression iExpression, int n) throws ConditionException {
        int n2 = iExpression.expressionType();
        if (ExpressionToolKit.isVariableExp(n2)) {
            if (ExpressionToolKit.isReference(n2) || ExpressionToolKit.isFormula(n2) || ExpressionToolKit.isParameter(n2)) {
                String string = iExpression.getName();
                String string2 = "";
                String string3 = "\"";
                String string4 = "";
                string = "@" + DbTools.quotedWhenNeed(string, string2, string3, string4);
                return SqlToFml.createUnCheckedVariableExpression(string, false);
            }
            if (ExpressionToolKit.isConstant(n2)) {
                int n3 = ((IConstant)iExpression).getDataType();
                if (n3 == 0) {
                    n3 = n;
                }
                String string = Types.isBoolean(n) || Types.isNumeric(n) ? iExpression.getName() : "'" + iExpression.getName() + "'";
                return SqlToFml.createUnCheckedVariableExpression(string, true);
            }
            return SqlToFml.createUnCheckedVariableExpression(iExpression.getStringValue(false), true);
        }
        if (ExpressionToolKit.isSingleExp(n2)) {
            ISingleBooleanExpression iSingleBooleanExpression = (ISingleBooleanExpression)iExpression;
            String string = OperatorTypes.getOpTypeValue(iSingleBooleanExpression.getOperator().operatorType());
            IUnCheckedExpression iUnCheckedExpression = ExpressionToolKit.createBinaryConditionExp(jetUDatabase, iSingleBooleanExpression.getExpression(), 0);
            return SqlToFml.createUnCheckedSingleExpression(add.createUnCheckedOperator(string), iUnCheckedExpression);
        }
        if (ExpressionToolKit.isBinaryExp(n2)) {
            IBinaryBooleanExpression iBinaryBooleanExpression = (IBinaryBooleanExpression)iExpression;
            String string = OperatorTypes.getOpTypeValue(iBinaryBooleanExpression.getOperator().operatorType());
            int n4 = 0;
            try {
                if (ExpressionToolKit.isVariableExp(iBinaryBooleanExpression.getExpression1().expressionType())) {
                    n4 = ExpressionToolKit.buildOrExpression(jetUDatabase, null, (IVariableExpression)iBinaryBooleanExpression.getExpression1(), null);
                }
            }
            catch (Exception exception) {
                try {
                    if (ExpressionToolKit.isVariableExp(iBinaryBooleanExpression.getExpression2().expressionType())) {
                        n4 = ExpressionToolKit.buildOrExpression(jetUDatabase, null, (IVariableExpression)iBinaryBooleanExpression.getExpression2(), null);
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            IUnCheckedExpression iUnCheckedExpression = ExpressionToolKit.createBinaryConditionExp(jetUDatabase, iBinaryBooleanExpression.getExpression1(), n4);
            IUnCheckedExpression iUnCheckedExpression2 = ExpressionToolKit.createBinaryConditionExp(jetUDatabase, iBinaryBooleanExpression.getExpression2(), n4);
            return SqlToFml.createUnCheckedBinaryExpression(add.createUnCheckedOperator(string), iUnCheckedExpression, iUnCheckedExpression2);
        }
        if (ExpressionToolKit.isTripleExp(n2)) {
            ITripleTupleExpression iTripleTupleExpression = (ITripleTupleExpression)iExpression;
            String string = OperatorTypes.getOpTypeValue(iTripleTupleExpression.getOperator().operatorType());
            int n5 = 0;
            try {
                if (ExpressionToolKit.isVariableExp(iTripleTupleExpression.getExpression1().expressionType())) {
                    n5 = ExpressionToolKit.buildOrExpression(jetUDatabase, null, (IVariableExpression)iTripleTupleExpression.getExpression1(), null);
                }
            }
            catch (Exception exception) {
                try {
                    if (ExpressionToolKit.isVariableExp(iTripleTupleExpression.getExpression2().expressionType())) {
                        n5 = ExpressionToolKit.buildOrExpression(jetUDatabase, null, (IVariableExpression)iTripleTupleExpression.getExpression2(), null);
                    }
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                try {
                    if (ExpressionToolKit.isVariableExp(iTripleTupleExpression.getExpression3().expressionType())) {
                        n5 = ExpressionToolKit.buildOrExpression(jetUDatabase, null, (IVariableExpression)iTripleTupleExpression.getExpression3(), null);
                    }
                }
                catch (Exception exception4) {
                    // empty catch block
                }
            }
            IUnCheckedExpression iUnCheckedExpression = ExpressionToolKit.createBinaryConditionExp(jetUDatabase, iTripleTupleExpression.getExpression1(), n5);
            IUnCheckedExpression iUnCheckedExpression3 = ExpressionToolKit.createBinaryConditionExp(jetUDatabase, iTripleTupleExpression.getExpression2(), n5);
            IUnCheckedExpression iUnCheckedExpression4 = ExpressionToolKit.createBinaryConditionExp(jetUDatabase, iTripleTupleExpression.getExpression3(), n5);
            return SqlToFml.createUnCheckedTripleExpression(add.createUnCheckedOperator(string), iUnCheckedExpression, iUnCheckedExpression3, iUnCheckedExpression4);
        }
        if (ExpressionToolKit.isMultiExp(n2)) {
            IMultiLogicExpression iMultiLogicExpression = (IMultiLogicExpression)iExpression;
            String string = OperatorTypes.getOpTypeValue(iMultiLogicExpression.getOperator().operatorType());
            IExpression[] iExpressionArray = iMultiLogicExpression.getExpressions();
            IUnCheckedExpression[] iUnCheckedExpressionArray = new IUnCheckedExpression[iExpressionArray.length];
            for (int i = 0; i < iExpressionArray.length; ++i) {
                iUnCheckedExpressionArray[i] = ExpressionToolKit.createBinaryConditionExp(jetUDatabase, iExpressionArray[i], 0);
            }
            return SqlToFml.createUnCheckedMultiExpression(add.createUnCheckedOperator(string), iUnCheckedExpressionArray);
        }
        throw new ConditionException(8490);
    }

    public static boolean translateToMappingName(IUnCheckedVariableExpression iUnCheckedVariableExpression, RptPsqlQuery rptPsqlQuery) {
        CritNode critNode;
        Object object;
        Object object2;
        if (iUnCheckedVariableExpression.isConstantValue()) {
            return true;
        }
        String string = iUnCheckedVariableExpression.getValue();
        if (string.startsWith("'") && string.endsWith("'")) {
            return true;
        }
        JetUDatabase jetUDatabase = rptPsqlQuery.getDatabase();
        if (jetUDatabase != null) {
            object2 = SqlTools.removeQuotes(iUnCheckedVariableExpression.getValue());
            object = jetUDatabase.getResourceByName(rptPsqlQuery.getMappingName(), (String)object2);
            if (!(!(object instanceof JetUDBField) || object instanceof JetUCompColQueryField || object instanceof JetUField && rptPsqlQuery.getTableByUTable(((JetUField)object).getTable()) == null)) {
                String string2 = "";
                String string3 = "\"";
                String string4 = "";
                iUnCheckedVariableExpression.setValue("@" + DbTools.quotedWhenNeed((String)object2, string2, string3, string4));
                return true;
            }
        }
        if (rptPsqlQuery != null) {
            rptPsqlQuery.beforeWCParse();
        }
        if ((critNode = ((WhereClauseParser)(object2 = new WhereClauseParser(0))).parse(rptPsqlQuery, (String)(object = iUnCheckedVariableExpression.getValue() + " is null"))) == null) {
            return false;
        }
        String string5 = critNode.toMappingNameString();
        if (string5 == null || string5.trim().length() <= 0) {
            return false;
        }
        iUnCheckedVariableExpression.setValue(string5);
        return true;
    }

    public static boolean translateToRealName(IUnCheckedVariableExpression iUnCheckedVariableExpression, RptPsqlQuery rptPsqlQuery) {
        String string;
        WhereClauseParser whereClauseParser;
        CritNode critNode;
        if (iUnCheckedVariableExpression.isConstantValue()) {
            return true;
        }
        if (rptPsqlQuery != null) {
            rptPsqlQuery.beforeWCParse();
        }
        if ((critNode = (whereClauseParser = new WhereClauseParser(0)).parse(rptPsqlQuery, string = iUnCheckedVariableExpression.getValue() + " is null")) == null) {
            return false;
        }
        String string2 = critNode.toRealNameString();
        if (string2 == null || string2.trim().length() <= 0) {
            return false;
        }
        iUnCheckedVariableExpression.setValue(string2);
        return true;
    }

    public static IUnCheckedExpression buildUncheckedMappingNameExpression(IUnCheckedExpression iUnCheckedExpression, RptPsqlQuery rptPsqlQuery) throws ConditionException {
        return ExpressionToolKit.containsIgnoreCase(iUnCheckedExpression, rptPsqlQuery, 0);
    }

    public static IUnCheckedExpression buildUncheckedRealNameExpression(IUnCheckedExpression iUnCheckedExpression, RptPsqlQuery rptPsqlQuery) throws ConditionException {
        return ExpressionToolKit.containsIgnoreCase(iUnCheckedExpression, rptPsqlQuery, 1);
    }

    private static IVariableExpression createBinaryConditionOp(IVariableExpression iVariableExpression, Scope scope, boolean bl, HashMap hashMap, HashSet hashSet) throws ConditionException {
        int n = iVariableExpression.expressionType();
        String string = null;
        if (hashMap != null && (ExpressionToolKit.isReference(n) || ExpressionToolKit.isFormula(n)) && iVariableExpression.getName() != null) {
            string = (String)hashMap.get(iVariableExpression.getName().toUpperCase());
        }
        if (ExpressionToolKit.isReference(n) || ExpressionToolKit.isFormula(n)) {
            Object object;
            boolean bl2 = false;
            if (ExpressionToolKit.isReference(n)) {
                bl2 = ((IReference)iVariableExpression).isQualifyName();
            } else {
                boolean bl3 = bl2 = scope != null;
            }
            if (hashSet != null && bl2 && hashSet.contains(iVariableExpression.getName())) {
                IConstant iConstant = SqlToFml.createConstant("");
                iConstant.setNull(true);
                return iConstant;
            }
            if (bl2 && scope != null) {
                object = null;
                object = scope.getBLNodeByQualifiedDisplayName(iVariableExpression.getName());
                String string2 = null;
                if (object != null) {
                    JetUTreeNode jetUTreeNode;
                    int n2 = object.getElementType();
                    if (string != null) {
                        if (n2 != 5 || bl) {
                            string2 = string;
                        }
                    } else {
                        switch (n2) {
                            case 4: {
                                jetUTreeNode = (Dimension)object;
                                string2 = jetUTreeNode.getRefMappingName();
                                break;
                            }
                            case 5: {
                                if (!bl) break;
                                if (object instanceof JetRptFlyMeasure) {
                                    JetRptFlyMeasure jetRptFlyMeasure = (JetRptFlyMeasure)object;
                                    string2 = jetRptFlyMeasure.getBasedFieldName();
                                    break;
                                }
                                Measure measure = (Measure)object;
                                string2 = measure.getRefMappingName();
                                break;
                            }
                            case 7: {
                                if (object instanceof JetRptFormula) {
                                    JetRptFormula jetRptFormula = (JetRptFormula)object;
                                    string2 = ((DataElementInfo)((Object)jetRptFormula)).getRefMappingName();
                                    break;
                                }
                                if (object instanceof JetRptFlyFormula) {
                                    JetRptFlyFormula jetRptFlyFormula = (JetRptFlyFormula)object;
                                    string2 = jetRptFlyFormula.getRefMappingName();
                                    break;
                                }
                                DetailInfo detailInfo = (DetailInfo)object;
                                string2 = detailInfo.getRefMappingName();
                                break;
                            }
                        }
                    }
                    if (string2 != null) {
                        jetUTreeNode = scope.getResourceEntity(string2, false);
                        if (jetUTreeNode instanceof JetUDBField) {
                            return SqlToFml.createReference(string2);
                        }
                        if (jetUTreeNode instanceof JetUParameter) {
                            return SqlToFml.createParameter(string2, false);
                        }
                        if (jetUTreeNode instanceof JetUFormula) {
                            return SqlToFml.createFormula(string2);
                        }
                        return SqlToFml.createFormula(string2);
                    }
                }
            }
            if (ExpressionToolKit.isReference(n)) {
                object = string != null ? string : iVariableExpression.getName();
                return SqlToFml.createReference((String)object, ((IReference)iVariableExpression).isQualifyName());
            }
            object = string != null ? string : iVariableExpression.getName();
            return SqlToFml.createFormula((String)object);
        }
        if (ExpressionToolKit.isDataContainerReference(n)) {
            IDataContainerReference iDataContainerReference = (IDataContainerReference)iVariableExpression;
            String string3 = string != null ? string : iDataContainerReference.getName();
            IDataContainerReference iDataContainerReference2 = SqlToFml.createDataContainerReference(string3);
            iDataContainerReference2.setDataType(iDataContainerReference.getDataType());
            return iDataContainerReference2;
        }
        if (ExpressionToolKit.isQueryInfoReference(n)) {
            IQueryInfoReference iQueryInfoReference = (IQueryInfoReference)iVariableExpression;
            IQueryInfoReference iQueryInfoReference2 = SqlToFml.createQueryInfoReference(iQueryInfoReference.getName(), iQueryInfoReference.getQueryInfo());
            return iQueryInfoReference2;
        }
        if (ExpressionToolKit.isParameter(n)) {
            IParameter iParameter = (IParameter)iVariableExpression;
            return SqlToFml.createParameter(iParameter.getName(), iParameter.isRefParameter());
        }
        if (ExpressionToolKit.isQueryInfoFormula(n)) {
            IQueryInfoFormula iQueryInfoFormula = (IQueryInfoFormula)iVariableExpression;
            IQueryInfoFormula iQueryInfoFormula2 = SqlToFml.createQueryInfoFormula(iQueryInfoFormula.getName(), iQueryInfoFormula.getQueryInfo());
            return iQueryInfoFormula2;
        }
        if (ExpressionToolKit.isConstant(n)) {
            IConstant iConstant = (IConstant)iVariableExpression;
            boolean bl4 = false;
            if (iConstant.isSpecialField()) {
                bl4 = true;
            }
            IConstant iConstant2 = SqlToFml.createConstant(iConstant.getName(), bl4);
            if (iConstant.getValue() != null) {
                iConstant2.setValue(iConstant.getValue());
                iConstant2.setDataType(iConstant.getDataType());
            }
            if (iConstant.isNull()) {
                iConstant2.setNull(true);
            } else {
                iConstant2.setNull(false);
            }
            if (iConstant.isAll()) {
                iConstant2.setIsAll(true);
            } else {
                iConstant2.setIsAll(false);
            }
            return iConstant2;
        }
        if (ExpressionToolKit.isVariableList(n)) {
            IVariableList iVariableList = (IVariableList)iVariableExpression;
            IVariableList iVariableList2 = SqlToFml.createVariableList(iVariableList.getName());
            for (int i = 0; i < iVariableList.size(); ++i) {
                IVariableExpression iVariableExpression2 = ExpressionToolKit.createBinaryConditionOp(iVariableList.getVariableExp(i), scope, bl, hashMap, hashSet);
                if (ExpressionToolKit.isConstant(iVariableExpression2.expressionType())) {
                    iVariableList2.addConstant((IConstant)iVariableExpression2);
                    continue;
                }
                if (ExpressionToolKit.isFormula(iVariableExpression2.expressionType())) {
                    iVariableList2.addFormula((IFormula)iVariableExpression2);
                    continue;
                }
                if (ExpressionToolKit.isParameter(iVariableExpression2.expressionType())) {
                    iVariableList2.addParameter((IParameter)iVariableExpression2);
                    continue;
                }
                throw new ConditionException(8488);
            }
            return iVariableList2;
        }
        throw new ConditionException(8489);
    }

    private static ICalculateExpression createBinaryLogicExp(ICalculateExpression iCalculateExpression, Scope scope, boolean bl, HashMap hashMap, HashSet hashSet) throws ConditionException {
        int n = iCalculateExpression.expressionType();
        if (ExpressionToolKit.isSingleCalculateExp(n)) {
            ISingleCalculateExpression iSingleCalculateExpression = (ISingleCalculateExpression)iCalculateExpression;
            int n2 = iSingleCalculateExpression.getOperator().operatorType();
            if (ExpressionToolKit.isSpecFuncExp(n2)) {
                SpecialFuncImpl specialFuncImpl = (SpecialFuncImpl)iSingleCalculateExpression.getOperator();
                SpecFormulaInfo specFormulaInfo = specialFuncImpl.getSpecFmlInfo();
                return SqlToFml.createSingleCalculateExp(add.createSingleSpecFuncCalculateOp(specFormulaInfo.clone()), ExpressionToolKit.createBinaryConditionOp((IVariableExpression)iSingleCalculateExpression.getExpression(), scope, bl, hashMap, hashSet));
            }
            throw new ConditionException(8600);
        }
        throw new ConditionException(8600);
    }

    private static IExpression createBinaryLogicOp(IExpression iExpression) {
        return null;
    }

    private static String createConstant(IVariableExpression iVariableExpression) throws ConditionException {
        if (ExpressionToolKit.isReference(iVariableExpression.expressionType()) || ExpressionToolKit.isFormula(iVariableExpression.expressionType()) || ExpressionToolKit.isParameter(iVariableExpression.expressionType()) || ExpressionToolKit.isDataContainerReference(iVariableExpression.expressionType())) {
            return "@" + iVariableExpression.getName();
        }
        if (ExpressionToolKit.isQueryInfoReference(iVariableExpression.expressionType()) || ExpressionToolKit.isQueryInfoFormula(iVariableExpression.expressionType())) {
            QueryInfo queryInfo = null;
            queryInfo = ExpressionToolKit.isQueryInfoReference(iVariableExpression.expressionType()) ? ((IQueryInfoReference)iVariableExpression).getQueryInfo() : ((IQueryInfoFormula)iVariableExpression).getQueryInfo();
            return "@" + queryInfo.toString() + "." + iVariableExpression.getName();
        }
        if (ExpressionToolKit.isConstant(iVariableExpression.expressionType())) {
            return ((IConstant)iVariableExpression).getValue();
        }
        if (ExpressionToolKit.isVariableList(iVariableExpression.expressionType())) {
            IVariableList iVariableList = (IVariableList)iVariableExpression;
            String string = "";
            for (int i = 0; i < iVariableList.size(); ++i) {
                string = string + ExpressionToolKit.createConstant(iVariableList.getVariableExp(i)) + ",";
            }
            string = string.substring(0, string.length() - 1);
            return string;
        }
        return null;
    }

    public static String Expression2String(IExpression iExpression) throws ConditionException {
        String string = "";
        if (ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
            return ExpressionToolKit.createConstant((IVariableExpression)iExpression);
        }
        if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
            ISingleBooleanExpression iSingleBooleanExpression = (ISingleBooleanExpression)iExpression;
            string = ExpressionToolKit.Expression2String(iSingleBooleanExpression.getExpression());
            int n = iSingleBooleanExpression.getOperator().operatorType();
            switch (n) {
                case 0x11500001: {
                    return "!(" + string + ")";
                }
                case 0x11300001: {
                    return "isnull(" + string + ")";
                }
                case 288358402: {
                    return "notnull(" + string + ")";
                }
            }
        } else if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
            String string2 = "";
            String string3 = "";
            IBinaryBooleanExpression iBinaryBooleanExpression = (IBinaryBooleanExpression)iExpression;
            string2 = ExpressionToolKit.Expression2String(iBinaryBooleanExpression.getExpression1());
            string3 = ExpressionToolKit.Expression2String(iBinaryBooleanExpression.getExpression2());
            int n = iBinaryBooleanExpression.getOperator().operatorType();
            switch (n) {
                case 556794112: {
                    return string2 + "<" + string3;
                }
                case 556794368: {
                    return string2 + "<=" + string3;
                }
                case 556793872: {
                    return string2 + "==" + string3;
                }
                case 556793888: {
                    return string2 + "!=" + string3;
                }
                case 556793984: {
                    return string2 + ">=" + string3;
                }
                case 556793920: {
                    return string2 + ">" + string3;
                }
                case 556793860: {
                    return string2 + " like " + string3;
                }
                case 556793864: {
                    return string2 + " notlike " + string3;
                }
                case 556793857: {
                    return string2 + " in( " + string3 + ")";
                }
                case 556793858: {
                    return string2 + " notin( " + string3 + ")";
                }
                case -2125463550: {
                    return string2 + " && " + string3 + "";
                }
                case -2125463548: {
                    return string2 + " || " + string3 + "";
                }
            }
        } else if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
            ITripleTupleExpression iTripleTupleExpression = (ITripleTupleExpression)iExpression;
            String string4 = ExpressionToolKit.Expression2String(iTripleTupleExpression.getExpression1());
            String string5 = ExpressionToolKit.Expression2String(iTripleTupleExpression.getExpression2());
            String string6 = ExpressionToolKit.Expression2String(iTripleTupleExpression.getExpression3());
            String string7 = string4 + " between(" + string5 + "," + string6 + ")";
            int n = iTripleTupleExpression.getOperator().operatorType();
            if (n == 1093664769) {
                return string7;
            }
            if (n == 1093664770) {
                return "!(" + string7 + ")";
            }
            return "<triple not implemented>";
        }
        return "<unspported expression type>";
    }

    public static String getJoinCondition(JRDBJoin jRDBJoin, JetUUniverse jetUUniverse, String string, String string2, JetUConnection jetUConnection) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = null;
        IUnCheckedExpression iUnCheckedExpression = (IUnCheckedExpression)jRDBJoin.getJoinExp();
        String string4 = jetUConnection.getSupportInfo().getQuoteChar();
        String string5 = jetUConnection.getSupportInfo().getExtraKeywords();
        String string6 = jetUConnection.getSupportInfo().getExtraNameChar();
        int n = jetUConnection.getQualifiedNamePattern();
        boolean bl2 = bl = jetUConnection instanceof JetUJDBCConnection ? ((JetUJDBCConnection)jetUConnection).isSql92() : false;
        if (ExpressionToolKit.isMultiExp(iUnCheckedExpression.expressionType())) {
            IUnCheckedMultiExpression iUnCheckedMultiExpression = (IUnCheckedMultiExpression)iUnCheckedExpression;
            string3 = iUnCheckedMultiExpression.getOperator().getOperationString();
            IUnCheckedExpression[] iUnCheckedExpressionArray = iUnCheckedMultiExpression.getExpressions();
            stringBuffer.append("(");
            for (int i = 0; i < iUnCheckedExpressionArray.length; ++i) {
                ExpressionToolKit.createDataContainerReference(jRDBJoin, iUnCheckedExpressionArray[i], jetUUniverse, stringBuffer, string, string2, n, string4, string5, string6, bl);
                if (i == iUnCheckedExpressionArray.length - 1) continue;
                stringBuffer.append(" ");
                stringBuffer.append(string3);
                stringBuffer.append(" ");
            }
            stringBuffer.append(")");
        } else {
            ExpressionToolKit.createDataContainerReference(jRDBJoin, iUnCheckedExpression, jetUUniverse, stringBuffer, string, string2, n, string4, string5, string6, bl);
        }
        return stringBuffer.toString();
    }

    private static void createDataContainerReference(JRDBJoin jRDBJoin, IUnCheckedExpression iUnCheckedExpression, JetUUniverse jetUUniverse, StringBuffer stringBuffer, String string, String string2, int n, String string3, String string4, String string5, boolean bl) {
        String string6 = null;
        if (ExpressionToolKit.isVariableExp(iUnCheckedExpression.expressionType())) {
            if (ExpressionToolKit.isVariableExp(iUnCheckedExpression.expressionType())) {
                IUnCheckedVariableExpression iUnCheckedVariableExpression = (IUnCheckedVariableExpression)iUnCheckedExpression;
                if (iUnCheckedVariableExpression.isConstantValue()) {
                    stringBuffer.append(iUnCheckedVariableExpression.getValue());
                } else {
                    stringBuffer.append(ExpressionToolKit.createMultiLogicExp(jetUUniverse, string, string2, iUnCheckedVariableExpression.getValue(), n, string3, string4, string5, false, null));
                }
            }
        } else {
            if (ExpressionToolKit.isSingleExp(iUnCheckedExpression.expressionType())) {
                string6 = iUnCheckedExpression.getOperator().getOperationString();
                IUnCheckedSingleExpression iUnCheckedSingleExpression = (IUnCheckedSingleExpression)iUnCheckedExpression;
                if (StringTools.indexOf4IngnoreCase(string6, "not") > -1) {
                    stringBuffer.append(string6);
                    stringBuffer.append(" ");
                    ExpressionToolKit.createDataContainerReference(jRDBJoin, iUnCheckedSingleExpression.getExpression(), jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5, bl);
                } else {
                    ExpressionToolKit.createDataContainerReference(jRDBJoin, iUnCheckedSingleExpression.getExpression(), jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5, bl);
                    stringBuffer.append(" ");
                    stringBuffer.append(string6);
                }
                return;
            }
            if (ExpressionToolKit.isBinaryExp(iUnCheckedExpression.expressionType())) {
                string6 = iUnCheckedExpression.getOperator().getOperationString();
                IUnCheckedBinaryExpression iUnCheckedBinaryExpression = (IUnCheckedBinaryExpression)iUnCheckedExpression;
                IUnCheckedExpression iUnCheckedExpression2 = iUnCheckedBinaryExpression.getExpression1();
                IUnCheckedExpression iUnCheckedExpression3 = iUnCheckedBinaryExpression.getExpression2();
                ExpressionToolKit.createDataContainerReference(jRDBJoin, iUnCheckedExpression2, jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5, bl);
                if (jRDBJoin.isRightOuter() && !bl) {
                    stringBuffer.append("(+)");
                }
                stringBuffer.append(" ");
                stringBuffer.append(string6);
                stringBuffer.append(" ");
                ExpressionToolKit.createDataContainerReference(jRDBJoin, iUnCheckedExpression3, jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5, bl);
                if (jRDBJoin.isLeftOuter() && !bl) {
                    stringBuffer.append("(+)");
                }
                return;
            }
            if (ExpressionToolKit.isTripleExp(iUnCheckedExpression.expressionType())) {
                string6 = iUnCheckedExpression.getOperator().getOperationString();
                IUnCheckedTripleExpression iUnCheckedTripleExpression = (IUnCheckedTripleExpression)iUnCheckedExpression;
                IUnCheckedExpression iUnCheckedExpression4 = iUnCheckedTripleExpression.getExpression1();
                IUnCheckedExpression iUnCheckedExpression5 = iUnCheckedTripleExpression.getExpression2();
                IUnCheckedExpression iUnCheckedExpression6 = iUnCheckedTripleExpression.getExpression3();
                ExpressionToolKit.createDataContainerReference(jRDBJoin, iUnCheckedExpression4, jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5, bl);
                stringBuffer.append(" ");
                stringBuffer.append(string6);
                stringBuffer.append(" ");
                ExpressionToolKit.createDataContainerReference(jRDBJoin, iUnCheckedExpression5, jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5, bl);
                stringBuffer.append(" and ");
                ExpressionToolKit.createDataContainerReference(jRDBJoin, iUnCheckedExpression6, jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5, bl);
                return;
            }
            if (ExpressionToolKit.isMultiExp(iUnCheckedExpression.expressionType())) {
                string6 = iUnCheckedExpression.getOperator().getOperationString();
                IUnCheckedMultiExpression iUnCheckedMultiExpression = (IUnCheckedMultiExpression)iUnCheckedExpression;
                string6 = iUnCheckedMultiExpression.getOperator().getOperationString();
                IUnCheckedExpression[] iUnCheckedExpressionArray = iUnCheckedMultiExpression.getExpressions();
                stringBuffer.append("(");
                for (int i = 0; i < iUnCheckedExpressionArray.length; ++i) {
                    ExpressionToolKit.createDataContainerReference(jRDBJoin, iUnCheckedExpressionArray[i], jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5, bl);
                    if (i == iUnCheckedExpressionArray.length - 1) continue;
                    stringBuffer.append(" ");
                    stringBuffer.append(string6);
                    stringBuffer.append(" ");
                }
                stringBuffer.append(")");
            }
        }
    }

    public static boolean isJinfonetObjProtocal(JetUConnection jetUConnection) {
        if (jetUConnection != null && jetUConnection instanceof JetUJDBCConnection) {
            String string = ((JetUJDBCConnection)jetUConnection).getURL();
            return DbTools.isJinfonetObjProtocal(string);
        }
        return false;
    }

    public static String getJoinCondition(PsqlJoin psqlJoin, IUnCheckedExpression iUnCheckedExpression, JetUUniverse jetUUniverse, String string, String string2) {
        return ExpressionToolKit.getJoinCondition(psqlJoin, iUnCheckedExpression, jetUUniverse, string, string2, false, null);
    }

    public static String getJoinCondition(PsqlJoin psqlJoin, IUnCheckedExpression iUnCheckedExpression, JetUUniverse jetUUniverse, String string, String string2, boolean bl, RptPsqlQuery rptPsqlQuery) {
        boolean bl2;
        if (iUnCheckedExpression == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        PsqlTable psqlTable = psqlJoin.getTableFrom();
        JetUConnection jetUConnection = psqlTable.getDataObj();
        if (jetUConnection == null) {
            jetUConnection = ExpressionToolKit.getJetUConnectionByTable(jetUUniverse, string, psqlTable.getMappingName());
        }
        String string3 = jetUConnection == null ? "\"" : jetUConnection.getSupportInfo().getQuoteChar();
        String string4 = jetUConnection == null ? "" : jetUConnection.getSupportInfo().getExtraKeywords();
        String string5 = jetUConnection == null ? "" : jetUConnection.getSupportInfo().getExtraNameChar();
        int n = jetUConnection == null ? 0 : jetUConnection.getQualifiedNamePattern();
        boolean bl3 = bl2 = jetUConnection instanceof JetUJDBCConnection ? ((JetUJDBCConnection)jetUConnection).isSql92() : false;
        if (ExpressionToolKit.isMultiExp(iUnCheckedExpression.expressionType())) {
            IUnCheckedMultiExpression iUnCheckedMultiExpression = (IUnCheckedMultiExpression)iUnCheckedExpression;
            String string6 = iUnCheckedMultiExpression.getOperator().getOperationString();
            if (bl) {
                string6 = DbTools.toFmlOperator(string6);
            }
            IUnCheckedExpression[] iUnCheckedExpressionArray = iUnCheckedMultiExpression.getExpressions();
            stringBuffer.append("(");
            for (int i = 0; i < iUnCheckedExpressionArray.length; ++i) {
                ExpressionToolKit.createFormula(iUnCheckedExpressionArray[i], jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5, jetUConnection, psqlJoin.isOuterJoin(), bl2, psqlJoin.isLeftOuterJoin(), psqlJoin.isRightOuterJoin(), bl, rptPsqlQuery);
                if (i == iUnCheckedExpressionArray.length - 1) continue;
                stringBuffer.append(" ");
                stringBuffer.append(string6);
                stringBuffer.append(" ");
            }
            stringBuffer.append(")");
        } else {
            ExpressionToolKit.createFormula(iUnCheckedExpression, jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5, jetUConnection, psqlJoin.isOuterJoin(), bl2, psqlJoin.isLeftOuterJoin(), psqlJoin.isRightOuterJoin(), bl, rptPsqlQuery);
        }
        return stringBuffer.toString();
    }

    public static String getJoinCondition(IUnCheckedExpression iUnCheckedExpression, JetUUniverse jetUUniverse, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return ExpressionToolKit.getJoinCondition(iUnCheckedExpression, jetUUniverse, string, string2, bl, bl2, bl3, bl4, false);
    }

    public static String getJoinCondition(IUnCheckedExpression iUnCheckedExpression, JetUUniverse jetUUniverse, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (iUnCheckedExpression == null || jetUUniverse == null || string == null || string2 == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        IUnCheckedVariableExpression[] iUnCheckedVariableExpressionArray = ExpressionToolKit.getUnCheckedVariableExpressions(iUnCheckedExpression);
        JetUConnection jetUConnection = null;
        for (int i = 0; i < iUnCheckedVariableExpressionArray.length && (jetUConnection = ExpressionToolKit.getJetUConnectionByField(jetUUniverse, string, string2, iUnCheckedVariableExpressionArray[i].getValue().trim())) == null; ++i) {
        }
        String string3 = jetUConnection.getSupportInfo().getQuoteChar();
        String string4 = jetUConnection.getSupportInfo().getExtraKeywords();
        String string5 = jetUConnection.getSupportInfo().getExtraNameChar();
        int n = jetUConnection.getQualifiedNamePattern();
        if (ExpressionToolKit.isMultiExp(iUnCheckedExpression.expressionType())) {
            IUnCheckedMultiExpression iUnCheckedMultiExpression = (IUnCheckedMultiExpression)iUnCheckedExpression;
            String string6 = iUnCheckedMultiExpression.getOperator().getOperationString();
            if (bl5) {
                string6 = DbTools.toFmlOperator(string6);
            }
            IUnCheckedExpression[] iUnCheckedExpressionArray = iUnCheckedMultiExpression.getExpressions();
            stringBuffer.append("(");
            for (int i = 0; i < iUnCheckedExpressionArray.length; ++i) {
                ExpressionToolKit.createFormula(iUnCheckedExpressionArray[i], jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5, jetUConnection, bl, bl2, bl3, bl4, bl5, null);
                if (i == iUnCheckedExpressionArray.length - 1) continue;
                stringBuffer.append(" ");
                stringBuffer.append(string6);
                stringBuffer.append(" ");
            }
            stringBuffer.append(")");
        } else {
            ExpressionToolKit.createFormula(iUnCheckedExpression, jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5, jetUConnection, bl, bl2, bl3, bl4, bl5, null);
        }
        return stringBuffer.toString();
    }

    private static void createFormula(IUnCheckedExpression iUnCheckedExpression, JetUUniverse jetUUniverse, StringBuffer stringBuffer, String string, String string2, int n, String string3, String string4, String string5, JetUConnection jetUConnection, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, RptPsqlQuery rptPsqlQuery) {
        String string6 = null;
        if (ExpressionToolKit.isVariableExp(iUnCheckedExpression.expressionType())) {
            if (ExpressionToolKit.isVariableExp(iUnCheckedExpression.expressionType())) {
                IUnCheckedVariableExpression iUnCheckedVariableExpression = (IUnCheckedVariableExpression)iUnCheckedExpression;
                if (iUnCheckedVariableExpression.isConstantValue()) {
                    stringBuffer.append(iUnCheckedVariableExpression.getValue());
                } else {
                    stringBuffer.append(ExpressionToolKit.createMultiLogicExp(jetUUniverse, string, string2, iUnCheckedVariableExpression.getValue(), n, string3, string4, string5, bl5, rptPsqlQuery));
                }
            }
        } else {
            if (ExpressionToolKit.isBinaryExp(iUnCheckedExpression.expressionType())) {
                string6 = iUnCheckedExpression.getOperator().getOperationString();
                boolean bl6 = ExpressionToolKit.isJinfonetObjProtocal(jetUConnection);
                string6 = PsqlJoin.getOperatorString(string6, bl6, bl, bl2, bl3, bl4);
                IUnCheckedBinaryExpression iUnCheckedBinaryExpression = (IUnCheckedBinaryExpression)iUnCheckedExpression;
                IUnCheckedExpression iUnCheckedExpression2 = iUnCheckedBinaryExpression.getExpression1();
                IUnCheckedExpression iUnCheckedExpression3 = iUnCheckedBinaryExpression.getExpression2();
                if (bl) {
                    if (!bl2) {
                        if (bl3) {
                            ExpressionToolKit.createFormula(iUnCheckedExpression3, jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5, jetUConnection, bl, bl2, bl3, bl4, bl5, rptPsqlQuery);
                            stringBuffer.append(" ");
                            stringBuffer.append(string6);
                            stringBuffer.append(" ");
                            ExpressionToolKit.createFormula(iUnCheckedExpression2, jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5, jetUConnection, bl, bl2, bl3, bl4, bl5, rptPsqlQuery);
                        } else if (bl4) {
                            ExpressionToolKit.createFormula(iUnCheckedExpression2, jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5, jetUConnection, bl, bl2, bl3, bl4, bl5, rptPsqlQuery);
                            stringBuffer.append(" ");
                            stringBuffer.append(string6);
                            stringBuffer.append(" ");
                            ExpressionToolKit.createFormula(iUnCheckedExpression3, jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5, jetUConnection, bl, bl2, bl3, bl4, bl5, rptPsqlQuery);
                        } else {
                            ExpressionToolKit.createFormula(iUnCheckedExpression2, jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5, jetUConnection, bl, bl2, bl3, bl4, bl5, rptPsqlQuery);
                            stringBuffer.append(" ");
                            stringBuffer.append(string6);
                            stringBuffer.append(" ");
                            ExpressionToolKit.createFormula(iUnCheckedExpression3, jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5, jetUConnection, bl, bl2, bl3, bl4, bl5, rptPsqlQuery);
                        }
                    }
                } else {
                    ExpressionToolKit.createFormula(iUnCheckedExpression2, jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5, jetUConnection, bl, bl2, bl3, bl4, bl5, rptPsqlQuery);
                    stringBuffer.append(" ");
                    stringBuffer.append(string6);
                    stringBuffer.append(" ");
                    ExpressionToolKit.createFormula(iUnCheckedExpression3, jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5, jetUConnection, bl, bl2, bl3, bl4, bl5, rptPsqlQuery);
                }
                return;
            }
            if (ExpressionToolKit.isMultiExp(iUnCheckedExpression.expressionType())) {
                IUnCheckedMultiExpression iUnCheckedMultiExpression = (IUnCheckedMultiExpression)iUnCheckedExpression;
                string6 = iUnCheckedMultiExpression.getOperator().getOperationString();
                IUnCheckedExpression[] iUnCheckedExpressionArray = iUnCheckedMultiExpression.getExpressions();
                stringBuffer.append("(");
                for (int i = 0; i < iUnCheckedExpressionArray.length; ++i) {
                    ExpressionToolKit.createFormula(iUnCheckedExpressionArray[i], jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5, jetUConnection, bl, bl2, bl3, bl4, bl5, rptPsqlQuery);
                    if (i == iUnCheckedExpressionArray.length - 1) continue;
                    stringBuffer.append(" ");
                    stringBuffer.append(string6);
                    stringBuffer.append(" ");
                }
                stringBuffer.append(")");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String createMultiLogicExp(JetUUniverse jetUUniverse, String string, String string2, String string3, int n, String string4, String string5, String string6, boolean bl, RptPsqlQuery rptPsqlQuery) {
        Object[] objectArray = ExpressionToolKit.getEntityFJoinVarialbe(jetUUniverse, string, string2, string3, rptPsqlQuery);
        String string7 = null;
        if (string3.indexOf(46) >= 0) {
            string7 = string3.substring(0, string3.indexOf(46));
        }
        String string8 = SqlTools.removeQuotes(string7);
        JetUResourceEntity jetUResourceEntity = null;
        String string9 = null;
        String string10 = null;
        PsqlTable psqlTable = null;
        if (objectArray != null) {
            if (objectArray.length > 0) {
                jetUResourceEntity = (JetUResourceEntity)objectArray[0];
            }
            if (objectArray.length > 1) {
                string9 = (String)objectArray[1];
            }
            if (objectArray.length > 2) {
                string10 = (String)objectArray[2];
            }
            if (objectArray.length > 3) {
                psqlTable = (PsqlTable)objectArray[3];
            }
        }
        String string11 = null;
        if (bl && jetUResourceEntity != null) {
            return "@" + jetUResourceEntity.getResourceName();
        }
        if (jetUResourceEntity instanceof JetURefQueryField) {
            return ((JetURefQueryField)jetUResourceEntity).getRefQueryName() + "." + jetUResourceEntity.getResourceName();
        }
        if (psqlTable != null && psqlTable.isQueriable()) {
            return psqlTable.getMappingName() + "." + jetUResourceEntity.getResourceName();
        }
        if (jetUResourceEntity instanceof JetUFldQueryField && string10 == null) {
            boolean bl2;
            JetUFldQueryField jetUFldQueryField = (JetUFldQueryField)jetUResourceEntity;
            boolean bl3 = bl2 = !StringTools.isEmptyStringWithTrim(jetUFldQueryField.getCorrName());
            if (bl2) {
                String string12 = StringTools.isEmptyStringWithTrim(jetUFldQueryField.getTableAlias()) ? "" : DbTools.quotedWhenNeed(jetUFldQueryField.getTableAlias(), string6, string4, string5) + ".";
                String string13 = DbTools.quotedWhenNeed(jetUFldQueryField.getFldName(), string6, string4, string5);
                return string12 + string13;
            }
            String string14 = StringTools.isEmptyStringWithTrim(jetUFldQueryField.getTable().getTableName()) ? "" : DbTools.quotedWhenNeed(jetUFldQueryField.getTable().getTableName(), string6, string4, string5) + ".";
            String string15 = DbTools.quotedWhenNeed(jetUFldQueryField.getFldName(), string6, string4, string5);
            string11 = string14 + string15;
            if (n == 1) {
                String string16 = jetUFldQueryField.getTable().getOwner();
                if (StringTools.isEmptyStringWithTrim(string16)) return string11;
                return DbTools.quotedWhenNeed(string16, string6, string4, string5) + "." + string11;
            }
            if (n != 2) return string11;
            String string17 = jetUFldQueryField.getTable().getOwner();
            String string18 = jetUFldQueryField.getTable().getQualifier();
            if (!StringTools.isEmptyStringWithTrim(string17)) {
                string11 = DbTools.quotedWhenNeed(string17, string6, string4, string5) + "." + string11;
            }
            if (StringTools.isEmptyStringWithTrim(string18)) return string11;
            return DbTools.quotedWhenNeed(string18, string6, string4, string5) + "." + string11;
        }
        if (jetUResourceEntity instanceof JetUField && string10 == null) {
            Object object;
            JetUField jetUField = (JetUField)jetUResourceEntity;
            boolean bl4 = jetUField.getTable().isAlias();
            String string19 = bl4 ? (StringTools.isEmptyStringWithTrim(jetUField.getTable().name.get()) ? "" : DbTools.quotedWhenNeed(jetUField.getTable().name.get(), string6, string4, string5) + ".") : (StringTools.isEmptyStringWithTrim(jetUField.getTable().getTableName()) ? "" : DbTools.quotedWhenNeed(jetUField.getTable().getTableName(), string6, string4, string5) + ".");
            String string20 = DbTools.quotedWhenNeed(jetUField.getFldName(), string6, string4, string5);
            if (!jetUField.getTable().getResourceName().equalsIgnoreCase(string8) && (object = jetUUniverse.getQueriableByResourceName(string, string8)) != null) {
                string19 = string8 + ".";
                string20 = jetUField.getResourceName();
                bl4 = true;
            }
            string11 = string19 + string20;
            if (bl4) return string11;
            if (n == 1) {
                object = jetUField.getTable().getOwner();
                if (StringTools.isEmptyStringWithTrim((String)object)) return string11;
                return DbTools.quotedWhenNeed((String)object, string6, string4, string5) + "." + string11;
            }
            if (n != 2) return string11;
            object = jetUField.getTable().getOwner();
            String string21 = jetUField.getTable().getQualifier();
            if (!StringTools.isEmptyStringWithTrim((String)object)) {
                string11 = DbTools.quotedWhenNeed((String)object, string6, string4, string5) + "." + string11;
            }
            if (StringTools.isEmptyStringWithTrim(string21)) return string11;
            return DbTools.quotedWhenNeed(string21, string6, string4, string5) + "." + string11;
        }
        if (jetUResourceEntity != null && string10 != null) {
            if (jetUResourceEntity instanceof JetUField) {
                JetUField jetUField = (JetUField)jetUResourceEntity;
                String string22 = StringTools.isEmptyStringWithTrim(string9) ? "" : DbTools.quotedWhenNeed(string9, string6, string4, string5) + ".";
                String string23 = DbTools.quotedWhenNeed(jetUField.getFldName(), string6, string4, string5);
                return string22 + string23;
            }
            if (!(jetUResourceEntity instanceof JetUQueryField)) return string3;
            JetUQueryField jetUQueryField = (JetUQueryField)jetUResourceEntity;
            String string24 = StringTools.isEmptyStringWithTrim(string9) ? "" : DbTools.quotedWhenNeed(string9, string6, string4, string5) + ".";
            String string25 = DbTools.quotedWhenNeed(jetUQueryField.getFldName(), string6, string4, string5);
            return string24 + string25;
        }
        if (!(jetUResourceEntity instanceof JetUDBField)) return string11;
        return string3;
    }

    public static Object[] getEntityFJoinVarialbe(JetUUniverse jetUUniverse, String string, String string2, String string3, RptPsqlQuery rptPsqlQuery) {
        Object[] objectArray;
        JetUResourceEntity jetUResourceEntity = null;
        String string4 = null;
        String string5 = null;
        if (string3.indexOf(46) < 0) {
            string5 = string3;
        } else {
            string4 = string3.substring(0, string3.indexOf(46));
            string5 = string3.substring(string3.indexOf(46) + 1);
        }
        String string6 = SqlTools.removeQuotes(string4);
        String string7 = SqlTools.removeQuotes(string5);
        jetUResourceEntity = jetUUniverse.getResourceByName(string, string2, string7);
        String string8 = null;
        String string9 = null;
        PsqlTable psqlTable = null;
        String string10 = null;
        String string11 = null;
        if (jetUResourceEntity == null) {
            int n;
            objectArray = null;
            RptPsqlQuery rptPsqlQuery2 = rptPsqlQuery;
            if (rptPsqlQuery2 == null) {
                rptPsqlQuery2 = jetUUniverse.GetQueryByResourceName(string, string2).getPsqlQuery();
            }
            JetUDatabase jetUDatabase = jetUUniverse.getDatabase(string);
            Vector vector = rptPsqlQuery2.getPsqlTables();
            int n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                psqlTable = (PsqlTable)vector.get(n);
                if (!string3.startsWith(psqlTable.getMappingName())) continue;
                string4 = psqlTable.getMappingName();
                string5 = string3.substring(string4.length() + 1);
                string10 = SqlTools.removeQuotes(string4);
                string11 = SqlTools.removeQuotes(string5);
                PsqlColumn psqlColumn = psqlTable.getColumnByMappingName(string11);
                if (psqlColumn != null) {
                    jetUResourceEntity = jetUDatabase.getResourceByName(psqlColumn.getMappingName());
                }
                if (jetUResourceEntity != null) break;
            }
            if (jetUResourceEntity == null) {
                psqlTable = null;
            } else {
                string6 = string10;
                string7 = string11;
            }
            if (jetUResourceEntity == null && string6 != null) {
                int n3;
                n = string6 != null ? string6.lastIndexOf(" (") : -1;
                int n4 = n3 = string6 != null ? string6.lastIndexOf(")") : -1;
                if (n != -1 && n3 != -1) {
                    string8 = string6.substring(0, n);
                    string9 = string7.substring(string8.length() + 1);
                } else {
                    string8 = string6;
                    if (string6 != null && string7.length() >= string6.length() + 1) {
                        string9 = string7.substring(string6.length() + 1);
                    }
                }
                jetUResourceEntity = string9 == null ? null : jetUUniverse.getResourceByName(string, string2, string9);
            }
        }
        objectArray = new Object[]{jetUResourceEntity, string8, string9, psqlTable};
        return objectArray;
    }

    public static String getJoinCondition(IUnCheckedExpression iUnCheckedExpression, JetUUniverse jetUUniverse, String string, String string2) {
        int n;
        if (iUnCheckedExpression == null || jetUUniverse == null || string == null || string2 == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = null;
        JetUConnection jetUConnection = null;
        IUnCheckedVariableExpression[] iUnCheckedVariableExpressionArray = ExpressionToolKit.getUnCheckedVariableExpressions(iUnCheckedExpression);
        for (int i = 0; i < iUnCheckedVariableExpressionArray.length && (jetUConnection = ExpressionToolKit.getJetUConnectionByField(jetUUniverse, string, string2, iUnCheckedVariableExpressionArray[i].getValue().trim())) == null; ++i) {
        }
        String string4 = jetUConnection == null ? "\"" : jetUConnection.getSupportInfo().getQuoteChar();
        String string5 = jetUConnection == null ? "" : jetUConnection.getSupportInfo().getExtraKeywords();
        String string6 = jetUConnection == null ? "" : jetUConnection.getSupportInfo().getExtraNameChar();
        int n2 = n = jetUConnection == null ? 0 : jetUConnection.getQualifiedNamePattern();
        if (ExpressionToolKit.isMultiExp(iUnCheckedExpression.expressionType())) {
            IUnCheckedMultiExpression iUnCheckedMultiExpression = (IUnCheckedMultiExpression)iUnCheckedExpression;
            string3 = iUnCheckedMultiExpression.getOperator().getOperationString();
            IUnCheckedExpression[] iUnCheckedExpressionArray = iUnCheckedMultiExpression.getExpressions();
            stringBuffer.append("(");
            for (int i = 0; i < iUnCheckedExpressionArray.length; ++i) {
                ExpressionToolKit.createMultiLogicOp(iUnCheckedExpressionArray[i], jetUUniverse, stringBuffer, string, string2, n, string4, string5, string6);
                if (i == iUnCheckedExpressionArray.length - 1) continue;
                stringBuffer.append(" ");
                stringBuffer.append(string3);
                stringBuffer.append(" ");
            }
            stringBuffer.append(")");
        } else {
            ExpressionToolKit.createMultiLogicOp(iUnCheckedExpression, jetUUniverse, stringBuffer, string, string2, n, string4, string5, string6);
        }
        return stringBuffer.toString();
    }

    private static void createMultiLogicOp(IUnCheckedExpression iUnCheckedExpression, JetUUniverse jetUUniverse, StringBuffer stringBuffer, String string, String string2, int n, String string3, String string4, String string5) {
        String string6 = null;
        if (ExpressionToolKit.isVariableExp(iUnCheckedExpression.expressionType())) {
            if (ExpressionToolKit.isVariableExp(iUnCheckedExpression.expressionType())) {
                IUnCheckedVariableExpression iUnCheckedVariableExpression = (IUnCheckedVariableExpression)iUnCheckedExpression;
                if (iUnCheckedVariableExpression.isConstantValue()) {
                    stringBuffer.append(iUnCheckedVariableExpression.getValue());
                } else {
                    stringBuffer.append(ExpressionToolKit.createMultiLogicExp(jetUUniverse, string, string2, iUnCheckedVariableExpression.getValue(), n, string3, string4, string5, false, null));
                }
            }
        } else {
            if (ExpressionToolKit.isSingleExp(iUnCheckedExpression.expressionType())) {
                string6 = iUnCheckedExpression.getOperator().getOperationString();
                IUnCheckedSingleExpression iUnCheckedSingleExpression = (IUnCheckedSingleExpression)iUnCheckedExpression;
                if (StringTools.indexOf4IngnoreCase(string6, "not") > -1) {
                    stringBuffer.append(string6);
                    stringBuffer.append(" ");
                    ExpressionToolKit.createMultiLogicOp(iUnCheckedSingleExpression.getExpression(), jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5);
                } else {
                    ExpressionToolKit.createMultiLogicOp(iUnCheckedSingleExpression.getExpression(), jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5);
                    stringBuffer.append(" ");
                    stringBuffer.append(string6);
                }
                return;
            }
            if (ExpressionToolKit.isBinaryExp(iUnCheckedExpression.expressionType())) {
                string6 = iUnCheckedExpression.getOperator().getOperationString();
                IUnCheckedBinaryExpression iUnCheckedBinaryExpression = (IUnCheckedBinaryExpression)iUnCheckedExpression;
                IUnCheckedExpression iUnCheckedExpression2 = iUnCheckedBinaryExpression.getExpression1();
                IUnCheckedExpression iUnCheckedExpression3 = iUnCheckedBinaryExpression.getExpression2();
                ExpressionToolKit.createMultiLogicOp(iUnCheckedExpression2, jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5);
                stringBuffer.append(" ");
                stringBuffer.append(string6);
                stringBuffer.append(" ");
                ExpressionToolKit.createMultiLogicOp(iUnCheckedExpression3, jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5);
                return;
            }
            if (ExpressionToolKit.isTripleExp(iUnCheckedExpression.expressionType())) {
                string6 = iUnCheckedExpression.getOperator().getOperationString();
                IUnCheckedTripleExpression iUnCheckedTripleExpression = (IUnCheckedTripleExpression)iUnCheckedExpression;
                IUnCheckedExpression iUnCheckedExpression4 = iUnCheckedTripleExpression.getExpression1();
                IUnCheckedExpression iUnCheckedExpression5 = iUnCheckedTripleExpression.getExpression2();
                IUnCheckedExpression iUnCheckedExpression6 = iUnCheckedTripleExpression.getExpression3();
                ExpressionToolKit.createMultiLogicOp(iUnCheckedExpression4, jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5);
                stringBuffer.append(" ");
                stringBuffer.append(string6);
                stringBuffer.append(" ");
                ExpressionToolKit.createMultiLogicOp(iUnCheckedExpression5, jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5);
                stringBuffer.append(" and ");
                ExpressionToolKit.createMultiLogicOp(iUnCheckedExpression6, jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5);
                return;
            }
            if (ExpressionToolKit.isMultiExp(iUnCheckedExpression.expressionType())) {
                string6 = iUnCheckedExpression.getOperator().getOperationString();
                IUnCheckedMultiExpression iUnCheckedMultiExpression = (IUnCheckedMultiExpression)iUnCheckedExpression;
                string6 = iUnCheckedMultiExpression.getOperator().getOperationString();
                IUnCheckedExpression[] iUnCheckedExpressionArray = iUnCheckedMultiExpression.getExpressions();
                stringBuffer.append("(");
                for (int i = 0; i < iUnCheckedExpressionArray.length; ++i) {
                    ExpressionToolKit.createMultiLogicOp(iUnCheckedExpressionArray[i], jetUUniverse, stringBuffer, string, string2, n, string3, string4, string5);
                    if (i == iUnCheckedExpressionArray.length - 1) continue;
                    stringBuffer.append(" ");
                    stringBuffer.append(string6);
                    stringBuffer.append(" ");
                }
                stringBuffer.append(")");
            }
        }
    }

    public static void multiParameterInExpression(IExpression iExpression, JetUUniverse jetUUniverse, String string) throws DSException, ConditionException {
        block21: {
            boolean bl;
            block22: {
                block25: {
                    String string2;
                    String string3;
                    IUnCheckedExpression iUnCheckedExpression;
                    Object object;
                    Object object2;
                    block24: {
                        String string4;
                        IUnCheckedExpression iUnCheckedExpression2;
                        Object object3;
                        String string5;
                        block23: {
                            IUnCheckedVariableExpression iUnCheckedVariableExpression;
                            String string6;
                            String string7;
                            if (iExpression == null) break block21;
                            bl = false;
                            if (!ExpressionToolKit.isUnCheckedExp(iExpression.expressionType())) break block22;
                            if (!ExpressionToolKit.isSingleExp(iExpression.expressionType())) break block23;
                            IUnCheckedSingleExpression iUnCheckedSingleExpression = (IUnCheckedSingleExpression)iExpression;
                            IUnCheckedExpression iUnCheckedExpression3 = iUnCheckedSingleExpression.getExpression();
                            if (ExpressionToolKit.isVariableExp(iUnCheckedExpression3.expressionType()) && !StringTools.isEmptyStringWithTrim(string7 = ParseParametersForQuery.getReferenceName(string6 = (iUnCheckedVariableExpression = (IUnCheckedVariableExpression)iUnCheckedExpression3).getValue(), 0)) && (bl = ExpressionToolKit.getIsMultiValue(jetUUniverse, string, string7))) {
                                throw new DSException(8497);
                            }
                            break block21;
                        }
                        if (!ExpressionToolKit.isBinaryExp(iExpression.expressionType())) break block24;
                        IUnCheckedBinaryExpression iUnCheckedBinaryExpression = (IUnCheckedBinaryExpression)iExpression;
                        IUnCheckedExpression iUnCheckedExpression4 = iUnCheckedBinaryExpression.getExpression1();
                        boolean bl2 = false;
                        if (ExpressionToolKit.isVariableExp(iUnCheckedExpression4.expressionType()) && !StringTools.isEmptyStringWithTrim(string5 = ParseParametersForQuery.getReferenceName((String)(object3 = (iUnCheckedExpression2 = (IUnCheckedVariableExpression)iUnCheckedExpression4).getValue()), 0))) {
                            bl2 = ExpressionToolKit.getIsMultiValue(jetUUniverse, string, string5);
                        }
                        if (ExpressionToolKit.isVariableExp((iUnCheckedExpression2 = iUnCheckedBinaryExpression.getExpression2()).expressionType()) && !StringTools.isEmptyStringWithTrim(string4 = ParseParametersForQuery.getReferenceName(string5 = (object3 = (IUnCheckedVariableExpression)iUnCheckedExpression2).getValue(), 0))) {
                            bl = ExpressionToolKit.getIsMultiValue(jetUUniverse, string, string4);
                        }
                        object3 = iUnCheckedBinaryExpression.getOperator().getOperationString();
                        ExpressionToolKit.setOperatorValidate(bl2, bl, OperatorTypes.getOpType((String)object3));
                        break block21;
                    }
                    if (!ExpressionToolKit.isTripleExp(iExpression.expressionType())) break block25;
                    IUnCheckedTripleExpression iUnCheckedTripleExpression = (IUnCheckedTripleExpression)iExpression;
                    IUnCheckedExpression iUnCheckedExpression5 = iUnCheckedTripleExpression.getExpression1();
                    if (ExpressionToolKit.isVariableExp(iUnCheckedExpression5.expressionType()) && !StringTools.isEmptyStringWithTrim((String)(object2 = ParseParametersForQuery.getReferenceName((String)(object = (iUnCheckedExpression = (IUnCheckedVariableExpression)iUnCheckedExpression5).getValue()), 0))) && (bl = ExpressionToolKit.getIsMultiValue(jetUUniverse, string, (String)object2))) {
                        throw new DSException(8497);
                    }
                    iUnCheckedExpression = iUnCheckedTripleExpression.getExpression2();
                    if (ExpressionToolKit.isVariableExp(iUnCheckedExpression.expressionType()) && !StringTools.isEmptyStringWithTrim(string3 = ParseParametersForQuery.getReferenceName((String)(object2 = (object = (IUnCheckedVariableExpression)iUnCheckedExpression).getValue()), 0)) && (bl = ExpressionToolKit.getIsMultiValue(jetUUniverse, string, string3))) {
                        throw new DSException(8497);
                    }
                    object = iUnCheckedTripleExpression.getExpression3();
                    if (ExpressionToolKit.isVariableExp(object.expressionType()) && !StringTools.isEmptyStringWithTrim(string2 = ParseParametersForQuery.getReferenceName(string3 = (object2 = (IUnCheckedVariableExpression)object).getValue(), 0)) && (bl = ExpressionToolKit.getIsMultiValue(jetUUniverse, string, string2))) {
                        throw new DSException(8497);
                    }
                    break block21;
                }
                if (!ExpressionToolKit.isMultiExp(iExpression.expressionType())) break block21;
                IUnCheckedMultiExpression iUnCheckedMultiExpression = (IUnCheckedMultiExpression)iExpression;
                IUnCheckedExpression[] iUnCheckedExpressionArray = iUnCheckedMultiExpression.getExpressions();
                for (int i = 0; i < iUnCheckedExpressionArray.length; ++i) {
                    ExpressionToolKit.multiParameterInExpression(iUnCheckedExpressionArray[i], jetUUniverse, string);
                }
                break block21;
            }
            if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
                ISingleTupleExpression iSingleTupleExpression = (ISingleTupleExpression)iExpression;
                IExpression iExpression2 = iSingleTupleExpression.getExpression();
                if (ExpressionToolKit.isVariableExp(iExpression2.expressionType()) && (bl = ExpressionToolKit.createNotOp(jetUUniverse, string, (IVariableExpression)iExpression2))) {
                    throw new DSException(8497);
                }
            } else if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
                IBinaryTupleExpression iBinaryTupleExpression = (IBinaryTupleExpression)iExpression;
                IExpression iExpression3 = iBinaryTupleExpression.getExpression1();
                boolean bl3 = false;
                if (ExpressionToolKit.isVariableExp(iExpression3.expressionType())) {
                    bl3 = ExpressionToolKit.createNotOp(jetUUniverse, string, (IVariableExpression)iExpression3);
                }
                IExpression iExpression4 = iBinaryTupleExpression.getExpression2();
                int n = iBinaryTupleExpression.getOperator().operatorType();
                if (ExpressionToolKit.isVariableExp(iExpression4.expressionType())) {
                    bl = ExpressionToolKit.createNotOp(jetUUniverse, string, (IVariableExpression)iExpression4);
                }
                ExpressionToolKit.setOperatorValidate(bl3, bl, n);
            } else if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
                ITriple iTriple = (ITriple)((Object)iExpression);
                IExpression iExpression5 = iTriple.getExpression1();
                if (ExpressionToolKit.isVariableExp(iExpression5.expressionType()) && (bl = ExpressionToolKit.createNotOp(jetUUniverse, string, (IVariableExpression)iExpression5))) {
                    throw new DSException(8497);
                }
                IExpression iExpression6 = iTriple.getExpression2();
                if (ExpressionToolKit.isVariableExp(iExpression6.expressionType()) && (bl = ExpressionToolKit.createNotOp(jetUUniverse, string, (IVariableExpression)iExpression6))) {
                    throw new DSException(8497);
                }
                IExpression iExpression7 = iTriple.getExpression3();
                if (ExpressionToolKit.isVariableExp(iExpression7.expressionType()) && (bl = ExpressionToolKit.createNotOp(jetUUniverse, string, (IVariableExpression)iExpression7))) {
                    throw new DSException(8497);
                }
            } else if (ExpressionToolKit.isMultiExp(iExpression.expressionType())) {
                IMulti iMulti = (IMulti)((Object)iExpression);
                IExpression[] iExpressionArray = iMulti.getExpressions();
                for (int i = 0; i < iExpressionArray.length; ++i) {
                    ExpressionToolKit.multiParameterInExpression(iExpressionArray[i], jetUUniverse, string);
                }
            }
        }
    }

    public static void setOperatorValidate(boolean bl, boolean bl2, int n) throws DSException {
        if (!bl2 && !bl) {
            return;
        }
        if (bl2 && bl) {
            if (n != 556793857 && n != 556793858 && n != 556793872 && n != 556793888) {
                throw new DSException(8497);
            }
            return;
        }
        if (bl2 || bl) {
            if (n != 556793857 && n != 556793858) {
                throw new DSException(8497);
            }
            return;
        }
    }

    public static boolean getIsMultiValue(JetUUniverse jetUUniverse, String string, String string2) {
        JetUResourceEntity jetUResourceEntity = jetUUniverse.getResourceByName(string, null, string2);
        if (jetUResourceEntity instanceof JetUParameter) {
            JetUParameter jetUParameter = (JetUParameter)jetUResourceEntity;
            return jetUParameter.isMultipleValue.get();
        }
        if (jetUResourceEntity instanceof JetUDBField) {
            JetUDBField jetUDBField = (JetUDBField)((Object)jetUResourceEntity);
            return jetUDBField.getColDesc().isArray();
        }
        if (jetUResourceEntity instanceof JetUFormula) {
            JetUFormula jetUFormula = (JetUFormula)jetUResourceEntity;
            return jetUFormula.getColDesc().isArray();
        }
        return false;
    }

    private static boolean createNotOp(JetUUniverse jetUUniverse, String string, IVariableExpression iVariableExpression) throws ConditionException {
        if (ExpressionToolKit.isVariableList(iVariableExpression.expressionType())) {
            return true;
        }
        String string2 = iVariableExpression.getName();
        if (!StringTools.isEmptyStringWithTrim(string2)) {
            return ExpressionToolKit.getIsMultiValue(jetUUniverse, string, string2);
        }
        return false;
    }

    public static int getOperatorPosition(String string) {
        String string2 = StringTools.trimBlankSpace(string);
        if ("not".equalsIgnoreCase(string2)) {
            return 1;
        }
        if ("is null".equalsIgnoreCase(string2)) {
            return 3;
        }
        if ("is not null".equalsIgnoreCase(string2)) {
            return 3;
        }
        if ("exists".equalsIgnoreCase(string2)) {
            return 1;
        }
        if ("not exists".equalsIgnoreCase(string2)) {
            return 1;
        }
        throw new RuntimeException("Unknow single operatior[" + string + "]");
    }

    public static IExpression compressExpression(IExpression iExpression) {
        if (iExpression == null) {
            return null;
        }
        if (ExpressionToolKit.isUnCheckedExp(iExpression.expressionType())) {
            if (ExpressionToolKit.isMultiExp(iExpression.expressionType())) {
                IExpression iExpression2;
                block5: {
                    iExpression2 = null;
                    try {
                        iExpression2 = ExpressionToolKit.cloneExpression(iExpression);
                    }
                    catch (ConditionException conditionException) {
                        if (!addConstant.isDebugEnabled()) break block5;
                        addConstant.debug("Compress Expression error.", conditionException);
                    }
                }
                IUnCheckedMultiExpression iUnCheckedMultiExpression = (IUnCheckedMultiExpression)iExpression2;
                IExpression[] iExpressionArray = iUnCheckedMultiExpression.getExpressions();
                ExpressionToolKit.createParameter(iUnCheckedMultiExpression, iExpressionArray);
                return iUnCheckedMultiExpression;
            }
            return iExpression;
        }
        return iExpression;
    }

    private static void createParameter(IExpression iExpression, IExpression[] iExpressionArray) {
        if (ExpressionToolKit.isUnCheckedExp(iExpression.expressionType()) && ExpressionToolKit.isMultiExp(iExpression.expressionType())) {
            IUnCheckedMultiExpression iUnCheckedMultiExpression = (IUnCheckedMultiExpression)iExpression;
            String string = iUnCheckedMultiExpression.getOperator().getOperationString();
            string = StringTools.trimBlankSpace(string);
            ArrayList<IExpression> arrayList = new ArrayList<IExpression>();
            int n = iExpressionArray.length;
            for (int i = 0; i < n; ++i) {
                if (ExpressionToolKit.isMultiExp(iExpressionArray[i].expressionType())) {
                    IUnCheckedMultiExpression iUnCheckedMultiExpression2 = (IUnCheckedMultiExpression)iExpressionArray[i];
                    IExpression[] iExpressionArray2 = iUnCheckedMultiExpression2.getExpressions();
                    ExpressionToolKit.createParameter(iUnCheckedMultiExpression2, iExpressionArray2);
                    String string2 = iUnCheckedMultiExpression2.getOperator().getOperationString();
                    string2 = StringTools.trimBlankSpace(string2);
                    if (string.equalsIgnoreCase(string2)) {
                        IUnCheckedExpression[] iUnCheckedExpressionArray = iUnCheckedMultiExpression2.getExpressions();
                        for (int j = 0; j < iUnCheckedExpressionArray.length; ++j) {
                            arrayList.add(iUnCheckedExpressionArray[j]);
                        }
                        continue;
                    }
                    arrayList.add(iUnCheckedMultiExpression2);
                    continue;
                }
                arrayList.add(iExpressionArray[i]);
            }
            IUnCheckedExpression[] iUnCheckedExpressionArray = new IUnCheckedExpression[arrayList.size()];
            for (n = 0; n < iUnCheckedExpressionArray.length; ++n) {
                iUnCheckedExpressionArray[n] = (IUnCheckedExpression)arrayList.get(n);
            }
            iUnCheckedMultiExpression.setExpressions(iUnCheckedExpressionArray);
        }
    }

    public static Vector getRefChildren(IExpression iExpression) {
        Vector<IExpression> vector = new Vector<IExpression>();
        Vector vector2 = new Vector();
        if (ExpressionToolKit.isReference(iExpression.expressionType())) {
            vector.add(iExpression);
            if (vector.size() == 0) {
                return null;
            }
            return vector;
        }
        if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
            ISingle iSingle = (ISingle)((Object)iExpression);
            return ExpressionToolKit.getRefChildren(iSingle.getExpression());
        }
        if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
            IBinary iBinary = (IBinary)((Object)iExpression);
            IExpression[] iExpressionArray = new IExpression[]{iBinary.getExpression1(), iBinary.getExpression2()};
            for (int i = 0; i < iExpressionArray.length; ++i) {
                vector2 = ExpressionToolKit.getRefChildren(iExpressionArray[i]);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.add((IExpression)vector2.get(j));
                }
            }
            return vector;
        }
        if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
            ITriple iTriple = (ITriple)((Object)iExpression);
            IExpression[] iExpressionArray = new IExpression[]{iTriple.getExpression1(), iTriple.getExpression2(), iTriple.getExpression3()};
            for (int i = 0; i < iExpressionArray.length; ++i) {
                vector2 = ExpressionToolKit.getRefChildren(iExpressionArray[i]);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.add((IExpression)vector2.get(j));
                }
            }
            return vector;
        }
        if (ExpressionToolKit.isMultiExp(iExpression.expressionType())) {
            IMulti iMulti = (IMulti)((Object)iExpression);
            IExpression[] iExpressionArray = iMulti.getExpressions();
            for (int i = 0; i < iExpressionArray.length; ++i) {
                vector2 = ExpressionToolKit.getRefChildren(iExpressionArray[i]);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.add((IExpression)vector2.get(j));
                }
            }
            return vector;
        }
        return new Vector();
    }

    public static String[] getResourceNames(ISortExpression iSortExpression) throws DSException {
        if (iSortExpression == null) {
            return new String[0];
        }
        ArrayList arrayList = new ArrayList();
        ISortExpression iSortExpression2 = iSortExpression;
        IOperatorInformation iOperatorInformation = ((ISortOperator)iSortExpression2.getOperator()).getOperatorInformation();
        if (OperatorInfoToolkit.isSortInformation(iOperatorInformation.informationType())) {
            ISortInformation iSortInformation = (ISortInformation)iOperatorInformation;
            ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentRefNames(iSortInformation.getReference()), arrayList);
        } else if (OperatorInfoToolkit.isSortInformationCollector(iOperatorInformation.informationType())) {
            ISortInformationCollector iSortInformationCollector = (ISortInformationCollector)iOperatorInformation;
            int n = iSortInformationCollector.size();
            for (int i = 0; i < n; ++i) {
                ExpressionToolKit.Expression2String(ExpressionToolKit.getDependentRefNames(iSortInformationCollector.getSortInformation(i).getReference()), arrayList);
            }
        }
        if (arrayList.size() < 1) {
            return null;
        }
        return ExpressionToolKit.$assertionsDisabled(arrayList);
    }

    public static Vector getALLRefForChildren(IExpression iExpression) {
        if (iExpression == null) {
            return null;
        }
        Vector<IExpression> vector = new Vector<IExpression>();
        Vector vector2 = new Vector();
        if (ExpressionToolKit.isReference(iExpression.expressionType()) || ExpressionToolKit.isFormula(iExpression.expressionType()) || ExpressionToolKit.isDataContainerReference(iExpression.expressionType()) || ExpressionToolKit.isDataContainerFormula(iExpression.expressionType())) {
            vector.add(iExpression);
            if (vector.size() == 0) {
                return null;
            }
            return vector;
        }
        if (ExpressionToolKit.isSortExp(iExpression.expressionType())) {
            ISortExpression iSortExpression = (ISortExpression)iExpression;
            IOperatorInformation iOperatorInformation = ((ISortOperator)iSortExpression.getOperator()).getOperatorInformation();
            if (OperatorInfoToolkit.isSortInformation(iOperatorInformation.informationType())) {
                ISortInformation iSortInformation = (ISortInformation)iOperatorInformation;
                vector2 = ExpressionToolKit.getALLRefForChildren(iSortInformation.getReference());
                if (vector2 != null) {
                    for (int i = 0; i < vector2.size(); ++i) {
                        vector.add((IExpression)vector2.get(i));
                    }
                }
            } else if (OperatorInfoToolkit.isSortInformationCollector(iOperatorInformation.informationType())) {
                ISortInformationCollector iSortInformationCollector = (ISortInformationCollector)iOperatorInformation;
                int n = iSortInformationCollector.size();
                for (int i = 0; i < n; ++i) {
                    vector2 = ExpressionToolKit.getALLRefForChildren(iSortInformationCollector.getSortInformation(i).getReference());
                    if (vector2 == null) continue;
                    for (int j = 0; j < vector2.size(); ++j) {
                        vector.add((IExpression)vector2.get(j));
                    }
                }
            }
            return vector;
        }
        if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
            ISingle iSingle = (ISingle)((Object)iExpression);
            return ExpressionToolKit.getALLRefForChildren(iSingle.getExpression());
        }
        if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
            IBinary iBinary = (IBinary)((Object)iExpression);
            IExpression[] iExpressionArray = new IExpression[]{iBinary.getExpression1(), iBinary.getExpression2()};
            for (int i = 0; i < iExpressionArray.length; ++i) {
                vector2 = ExpressionToolKit.getALLRefForChildren(iExpressionArray[i]);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.add((IExpression)vector2.get(j));
                }
            }
            return vector;
        }
        if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
            ITriple iTriple = (ITriple)((Object)iExpression);
            IExpression[] iExpressionArray = new IExpression[]{iTriple.getExpression1(), iTriple.getExpression2(), iTriple.getExpression3()};
            for (int i = 0; i < iExpressionArray.length; ++i) {
                vector2 = ExpressionToolKit.getALLRefForChildren(iExpressionArray[i]);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.add((IExpression)vector2.get(j));
                }
            }
            return vector;
        }
        if (ExpressionToolKit.isMultiExp(iExpression.expressionType())) {
            IMulti iMulti = (IMulti)((Object)iExpression);
            IExpression[] iExpressionArray = iMulti.getExpressions();
            for (int i = 0; i < iExpressionArray.length; ++i) {
                vector2 = ExpressionToolKit.getALLRefForChildren(iExpressionArray[i]);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.add((IExpression)vector2.get(j));
                }
            }
            return vector;
        }
        return new Vector();
    }

    public static Vector getQueryInfoRefChildren(IExpression iExpression) {
        Vector<IExpression> vector = new Vector<IExpression>();
        Vector vector2 = new Vector();
        if (ExpressionToolKit.isQueryInfoReference(iExpression.expressionType())) {
            vector.add(iExpression);
            if (vector.size() == 0) {
                return null;
            }
            return vector;
        }
        if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
            ISingle iSingle = (ISingle)((Object)iExpression);
            return ExpressionToolKit.getQueryInfoRefChildren(iSingle.getExpression());
        }
        if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
            IBinary iBinary = (IBinary)((Object)iExpression);
            IExpression[] iExpressionArray = new IExpression[]{iBinary.getExpression1(), iBinary.getExpression2()};
            for (int i = 0; i < iExpressionArray.length; ++i) {
                vector2 = ExpressionToolKit.getQueryInfoRefChildren(iExpressionArray[i]);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.add((IExpression)vector2.get(j));
                }
            }
            return vector;
        }
        if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
            ITriple iTriple = (ITriple)((Object)iExpression);
            IExpression[] iExpressionArray = new IExpression[]{iTriple.getExpression1(), iTriple.getExpression2(), iTriple.getExpression3()};
            for (int i = 0; i < iExpressionArray.length; ++i) {
                vector2 = ExpressionToolKit.getQueryInfoRefChildren(iExpressionArray[i]);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.add((IExpression)vector2.get(j));
                }
            }
            return vector;
        }
        if (ExpressionToolKit.isMultiExp(iExpression.expressionType())) {
            IMulti iMulti = (IMulti)((Object)iExpression);
            IExpression[] iExpressionArray = iMulti.getExpressions();
            for (int i = 0; i < iExpressionArray.length; ++i) {
                vector2 = ExpressionToolKit.getQueryInfoRefChildren(iExpressionArray[i]);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.add((IExpression)vector2.get(j));
                }
            }
            return vector;
        }
        return new Vector();
    }

    public static Vector getQueryInfoChildren(IExpression iExpression) {
        Vector<IExpression> vector = new Vector<IExpression>();
        Vector vector2 = new Vector();
        if (ExpressionToolKit.isQueryInfoReference(iExpression.expressionType()) || ExpressionToolKit.isQueryInfoFormula(iExpression.expressionType())) {
            vector.add(iExpression);
            if (vector.size() == 0) {
                return null;
            }
            return vector;
        }
        if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
            ISingle iSingle = (ISingle)((Object)iExpression);
            return ExpressionToolKit.getQueryInfoChildren(iSingle.getExpression());
        }
        if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
            IBinary iBinary = (IBinary)((Object)iExpression);
            IExpression[] iExpressionArray = new IExpression[]{iBinary.getExpression1(), iBinary.getExpression2()};
            for (int i = 0; i < iExpressionArray.length; ++i) {
                vector2 = ExpressionToolKit.getQueryInfoChildren(iExpressionArray[i]);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.add((IExpression)vector2.get(j));
                }
            }
            return vector;
        }
        if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
            ITriple iTriple = (ITriple)((Object)iExpression);
            IExpression[] iExpressionArray = new IExpression[]{iTriple.getExpression1(), iTriple.getExpression2(), iTriple.getExpression3()};
            for (int i = 0; i < iExpressionArray.length; ++i) {
                vector2 = ExpressionToolKit.getQueryInfoChildren(iExpressionArray[i]);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.add((IExpression)vector2.get(j));
                }
            }
            return vector;
        }
        if (ExpressionToolKit.isMultiExp(iExpression.expressionType())) {
            IMulti iMulti = (IMulti)((Object)iExpression);
            IExpression[] iExpressionArray = iMulti.getExpressions();
            for (int i = 0; i < iExpressionArray.length; ++i) {
                vector2 = ExpressionToolKit.getQueryInfoChildren(iExpressionArray[i]);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.add((IExpression)vector2.get(j));
                }
            }
            return vector;
        }
        return new Vector();
    }

    public static Vector getDCRefChildren(IExpression iExpression) {
        Vector<IExpression> vector = new Vector<IExpression>();
        Vector vector2 = new Vector();
        if (ExpressionToolKit.isDataContainerReference(iExpression.expressionType())) {
            vector.add(iExpression);
            if (vector.size() == 0) {
                return null;
            }
            return vector;
        }
        if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
            ISingle iSingle = (ISingle)((Object)iExpression);
            return ExpressionToolKit.getDCRefChildren(iSingle.getExpression());
        }
        if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
            IBinary iBinary = (IBinary)((Object)iExpression);
            IExpression[] iExpressionArray = new IExpression[]{iBinary.getExpression1(), iBinary.getExpression2()};
            for (int i = 0; i < iExpressionArray.length; ++i) {
                vector2 = ExpressionToolKit.getDCRefChildren(iExpressionArray[i]);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.add((IExpression)vector2.get(j));
                }
            }
            return vector;
        }
        if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
            ITriple iTriple = (ITriple)((Object)iExpression);
            IExpression[] iExpressionArray = new IExpression[]{iTriple.getExpression1(), iTriple.getExpression2(), iTriple.getExpression3()};
            for (int i = 0; i < iExpressionArray.length; ++i) {
                vector2 = ExpressionToolKit.getDCRefChildren(iExpressionArray[i]);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.add((IExpression)vector2.get(j));
                }
            }
            return vector;
        }
        if (ExpressionToolKit.isMultiExp(iExpression.expressionType())) {
            IMulti iMulti = (IMulti)((Object)iExpression);
            IExpression[] iExpressionArray = iMulti.getExpressions();
            for (int i = 0; i < iExpressionArray.length; ++i) {
                vector2 = ExpressionToolKit.getDCRefChildren(iExpressionArray[i]);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.add((IExpression)vector2.get(j));
                }
            }
            return vector;
        }
        return new Vector();
    }

    public static Vector getFormulaChildren(IExpression iExpression) {
        Vector<IExpression> vector = new Vector<IExpression>();
        Vector vector2 = new Vector();
        if (ExpressionToolKit.isFormula(iExpression.expressionType())) {
            vector.add(iExpression);
            if (vector.size() == 0) {
                return null;
            }
            return vector;
        }
        if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
            ISingle iSingle = (ISingle)((Object)iExpression);
            return ExpressionToolKit.getFormulaChildren(iSingle.getExpression());
        }
        if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
            IBinary iBinary = (IBinary)((Object)iExpression);
            IExpression[] iExpressionArray = new IExpression[]{iBinary.getExpression1(), iBinary.getExpression2()};
            for (int i = 0; i < iExpressionArray.length; ++i) {
                vector2 = ExpressionToolKit.getFormulaChildren(iExpressionArray[i]);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.add((IExpression)vector2.get(j));
                }
            }
            return vector;
        }
        if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
            ITriple iTriple = (ITriple)((Object)iExpression);
            IExpression[] iExpressionArray = new IExpression[]{iTriple.getExpression1(), iTriple.getExpression2(), iTriple.getExpression3()};
            for (int i = 0; i < iExpressionArray.length; ++i) {
                vector2 = ExpressionToolKit.getFormulaChildren(iExpressionArray[i]);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.add((IExpression)vector2.get(j));
                }
            }
            return vector;
        }
        if (ExpressionToolKit.isMultiExp(iExpression.expressionType())) {
            IMulti iMulti = (IMulti)((Object)iExpression);
            IExpression[] iExpressionArray = iMulti.getExpressions();
            for (int i = 0; i < iExpressionArray.length; ++i) {
                vector2 = ExpressionToolKit.getFormulaChildren(iExpressionArray[i]);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.add((IExpression)vector2.get(j));
                }
            }
            return vector;
        }
        return new Vector();
    }

    public static Vector getQueryInfoFormulaChildren(IExpression iExpression) {
        Vector<IExpression> vector = new Vector<IExpression>();
        Vector vector2 = new Vector();
        if (ExpressionToolKit.isQueryInfoFormula(iExpression.expressionType())) {
            vector.add(iExpression);
            if (vector.size() == 0) {
                return null;
            }
            return vector;
        }
        if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
            ISingle iSingle = (ISingle)((Object)iExpression);
            return ExpressionToolKit.getQueryInfoFormulaChildren(iSingle.getExpression());
        }
        if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
            IBinary iBinary = (IBinary)((Object)iExpression);
            IExpression[] iExpressionArray = new IExpression[]{iBinary.getExpression1(), iBinary.getExpression2()};
            for (int i = 0; i < iExpressionArray.length; ++i) {
                vector2 = ExpressionToolKit.getQueryInfoFormulaChildren(iExpressionArray[i]);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.add((IExpression)vector2.get(j));
                }
            }
            return vector;
        }
        if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
            ITriple iTriple = (ITriple)((Object)iExpression);
            IExpression[] iExpressionArray = new IExpression[]{iTriple.getExpression1(), iTriple.getExpression2(), iTriple.getExpression3()};
            for (int i = 0; i < iExpressionArray.length; ++i) {
                vector2 = ExpressionToolKit.getQueryInfoFormulaChildren(iExpressionArray[i]);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.add((IExpression)vector2.get(j));
                }
            }
            return vector;
        }
        if (ExpressionToolKit.isMultiExp(iExpression.expressionType())) {
            IMulti iMulti = (IMulti)((Object)iExpression);
            IExpression[] iExpressionArray = iMulti.getExpressions();
            for (int i = 0; i < iExpressionArray.length; ++i) {
                vector2 = ExpressionToolKit.getQueryInfoFormulaChildren(iExpressionArray[i]);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.add((IExpression)vector2.get(j));
                }
            }
            return vector;
        }
        return new Vector();
    }

    public static Vector getParameterChildren(IExpression iExpression) {
        return ExpressionToolKit.getParameterSpecialChildren(iExpression, addElement);
    }

    public static Vector getSpecial2function(IExpression iExpression) {
        return ExpressionToolKit.getParameterSpecialChildren(iExpression, addFormula);
    }

    public static Vector getParameterSpecialChildren(IExpression iExpression, int n) {
        Vector<IExpression> vector = new Vector<IExpression>();
        if (iExpression == null) {
            return vector;
        }
        Vector vector2 = new Vector();
        int n2 = iExpression.expressionType();
        if (n == addElement && ExpressionToolKit.isParameter(n2)) {
            vector.add(iExpression);
            if (vector.size() == 0) {
                return null;
            }
            return vector;
        }
        if (n == addElement && ExpressionToolKit.isVariableList(n2)) {
            try {
                IVariableList iVariableList = (IVariableList)iExpression;
                int n3 = iVariableList.size();
                for (int i = 0; i < n3; ++i) {
                    IVariableExpression iVariableExpression = iVariableList.getVariableExp(i);
                    vector2 = ExpressionToolKit.getParameterSpecialChildren(iVariableExpression, n);
                    if (vector2 == null) continue;
                    for (int j = 0; j < vector2.size(); ++j) {
                        vector.add((IExpression)vector2.get(j));
                    }
                }
            }
            catch (ConditionException conditionException) {
                // empty catch block
            }
            return vector;
        }
        if (ExpressionToolKit.isSingleExp(n2)) {
            ISingle iSingle = (ISingle)((Object)iExpression);
            return ExpressionToolKit.getParameterSpecialChildren(iSingle.getExpression(), n);
        }
        if (ExpressionToolKit.isBinaryExp(n2)) {
            IBinary iBinary = (IBinary)((Object)iExpression);
            IExpression[] iExpressionArray = new IExpression[]{iBinary.getExpression1(), iBinary.getExpression2()};
            if (n == addElement) {
                for (int i = 0; i < iExpressionArray.length; ++i) {
                    vector2 = ExpressionToolKit.getParameterSpecialChildren(iExpressionArray[i], n);
                    if (vector2 == null) continue;
                    for (int j = 0; j < vector2.size(); ++j) {
                        vector.add((IExpression)vector2.get(j));
                    }
                }
            } else if (n == addFormula) {
                vector.addAll(ExpressionToolKit.createQueryInfoReference(iExpressionArray[0], iExpressionArray[1], null));
            }
            return vector;
        }
        if (ExpressionToolKit.isTripleExp(n2)) {
            ITriple iTriple = (ITriple)((Object)iExpression);
            IExpression[] iExpressionArray = new IExpression[]{iTriple.getExpression1(), iTriple.getExpression2(), iTriple.getExpression3()};
            if (n == addElement) {
                for (int i = 0; i < iExpressionArray.length; ++i) {
                    vector2 = ExpressionToolKit.getParameterSpecialChildren(iExpressionArray[i], n);
                    if (vector2 == null) continue;
                    for (int j = 0; j < vector2.size(); ++j) {
                        vector.add((IExpression)vector2.get(j));
                    }
                }
            } else if (n == addFormula) {
                vector.addAll(ExpressionToolKit.createQueryInfoReference(iExpressionArray[0], iExpressionArray[1], iExpressionArray[2]));
            }
            return vector;
        }
        if (ExpressionToolKit.isMultiExp(n2)) {
            IMulti iMulti = (IMulti)((Object)iExpression);
            IExpression[] iExpressionArray = iMulti.getExpressions();
            for (int i = 0; i < iExpressionArray.length; ++i) {
                vector2 = ExpressionToolKit.getParameterSpecialChildren(iExpressionArray[i], n);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.add((IExpression)vector2.get(j));
                }
            }
            return vector;
        }
        return new Vector();
    }

    private static String createQueryInfoFormula(IExpression iExpression, IExpression iExpression2, IExpression iExpression3) {
        String string = null;
        Object var4_4 = null;
        try {
            if (iExpression != null && (ExpressionToolKit.isReference(iExpression.expressionType()) || ExpressionToolKit.isDataContainerReference(iExpression.expressionType()))) {
                string = ((IReference)iExpression).getAttributeName();
            } else if (iExpression != null && ExpressionToolKit.isFormula(iExpression.expressionType())) {
                string = iExpression.getName();
            } else if (iExpression2 != null && (ExpressionToolKit.isReference(iExpression2.expressionType()) || ExpressionToolKit.isDataContainerReference(iExpression2.expressionType()))) {
                string = ((IReference)iExpression2).getAttributeName();
            } else if (iExpression2 != null && ExpressionToolKit.isFormula(iExpression2.expressionType())) {
                string = iExpression2.getName();
            } else if (iExpression3 != null && (ExpressionToolKit.isReference(iExpression3.expressionType()) || ExpressionToolKit.isDataContainerReference(iExpression3.expressionType()))) {
                string = ((IReference)iExpression3).getAttributeName();
            } else if (iExpression3 != null && ExpressionToolKit.isFormula(iExpression3.expressionType())) {
                string = iExpression3.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private static Vector createQueryInfoReference(IExpression iExpression, IExpression iExpression2, IExpression iExpression3) {
        Vector<AggregationKey> vector = new Vector<AggregationKey>();
        String string = null;
        Object var5_5 = null;
        int n = Integer.MIN_VALUE;
        string = ExpressionToolKit.createQueryInfoFormula(iExpression, iExpression2, iExpression3);
        if (iExpression != null && ExpressionToolKit.isConstant(iExpression.expressionType()) && (n = ExpressionToolKit.createReference((IConstant)iExpression)) > Integer.MIN_VALUE && string != null) {
            vector.add(new AggregationKey(n, string));
        }
        if (iExpression2 != null && ExpressionToolKit.isConstant(iExpression2.expressionType()) && (n = ExpressionToolKit.createReference((IConstant)iExpression2)) > Integer.MIN_VALUE && string != null) {
            vector.add(new AggregationKey(n, string));
        }
        if (iExpression3 != null && ExpressionToolKit.isConstant(iExpression3.expressionType()) && (n = ExpressionToolKit.createReference((IConstant)iExpression3)) > Integer.MIN_VALUE && string != null) {
            vector.add(new AggregationKey(n, string));
        }
        return vector;
    }

    private static int createReference(IConstant iConstant) {
        int n = Integer.MIN_VALUE;
        try {
            if (iConstant.isSpecialField()) {
                String string = iConstant.getName();
                if (string.equalsIgnoreCase("MaxExistValue")) {
                    n = 4;
                } else if (string.equalsIgnoreCase("MinExistValue")) {
                    n = 3;
                } else if (string.equalsIgnoreCase("LastRefreshTime")) {
                    n = 0;
                }
            }
        }
        catch (ConditionException conditionException) {
            // empty catch block
        }
        return n;
    }

    public static void rename(IReference iReference, String string) {
        if (!(iReference instanceof ReferenceImpl)) {
            throw new UnsupportedOperationException(iReference.getClass().getName() + " can not set name!");
        }
        ReferenceImpl referenceImpl = (ReferenceImpl)iReference;
        referenceImpl.setName(string);
    }

    public static void rename(IFormula iFormula, String string) {
        if (!(iFormula instanceof FormulaImpl)) {
            throw new UnsupportedOperationException(iFormula.getClass().getName() + " can not set name!");
        }
        FormulaImpl formulaImpl = (FormulaImpl)iFormula;
        formulaImpl.setName(string);
    }

    public static void rename(IParameter iParameter, String string) {
        if (!(iParameter instanceof ParameterImpl)) {
            throw new UnsupportedOperationException(iParameter.getClass().getName() + " can not set name!");
        }
        ParameterImpl parameterImpl = (ParameterImpl)iParameter;
        parameterImpl.setName(string);
    }

    public static void check(JetUUniverse jetUUniverse, String string, String string2, BLNode bLNode, IExpression iExpression) throws ConditionException {
        JetUResourceEntity jetUResourceEntity;
        String string3;
        IVariableExpression iVariableExpression;
        int n;
        ArrayList arrayList = new ArrayList();
        Vector vector = new Vector();
        vector = ExpressionToolKit.getRefChildren(iExpression);
        for (n = 0; n < vector.size(); ++n) {
            iVariableExpression = (IReference)vector.get(n);
            string3 = iVariableExpression.getName();
            jetUResourceEntity = jetUUniverse.getResourceByName(string, string2, string3);
            if (jetUResourceEntity != null) continue;
            if (iVariableExpression.isQualifyName()) {
                if (bLNode == null) {
                    throw new IllegalArgumentException("This expression is BL filter, but BL is Null!");
                }
                string3 = ExpressionToolKit.getElement(bLNode, iVariableExpression.getName()).getRefMappingName();
                jetUResourceEntity = jetUUniverse.getResourceByName(string, string2, string3);
                if (jetUResourceEntity != null) continue;
                iVariableExpression.setIsError(true);
                iVariableExpression.setErrorDescription("Can not find reference " + string3 + " in catalog!");
                arrayList.add(vector.get(n));
                continue;
            }
            iVariableExpression.setIsError(true);
            iVariableExpression.setErrorDescription("Can not find reference " + iVariableExpression.getName() + " in catalog!");
            arrayList.add(vector.get(n));
        }
        vector = ExpressionToolKit.getFormulaChildren(iExpression);
        for (n = 0; n < vector.size(); ++n) {
            iVariableExpression = (IFormula)vector.get(n);
            string3 = iVariableExpression.getName();
            jetUResourceEntity = jetUUniverse.getResourceByName(string, string2, string3);
            if (jetUResourceEntity != null) continue;
            iVariableExpression.setIsError(true);
            iVariableExpression.setErrorDescription("Can not find formula " + string3 + " in catalog!");
            arrayList.add(vector.get(n));
        }
        vector = ExpressionToolKit.getParameterChildren(iExpression);
        for (n = 0; n < vector.size(); ++n) {
            iVariableExpression = (IParameter)vector.get(n);
            string3 = iVariableExpression.getName();
            jetUResourceEntity = jetUUniverse.getResourceByName(string, null, string3);
            if (jetUResourceEntity != null) continue;
            iVariableExpression.setIsError(true);
            iVariableExpression.setErrorDescription("Can not find parameter " + string3 + " in catalog!");
            arrayList.add(vector.get(n));
        }
        if (!arrayList.isEmpty()) {
            throw new ConditionException(8483, new String[]{((Object)arrayList).toString()});
        }
    }

    public static IUnCheckedVariableExpression[] getUnCheckedVariableExpressions(IUnCheckedExpression iUnCheckedExpression) {
        if (iUnCheckedExpression == null || !ExpressionToolKit.isUnCheckedExp(iUnCheckedExpression.expressionType())) {
            return new IUnCheckedVariableExpression[0];
        }
        ArrayList arrayList = new ArrayList();
        ExpressionToolKit.createSingleCalculateExp(iUnCheckedExpression, arrayList);
        return arrayList.toArray(new IUnCheckedVariableExpression[0]);
    }

    private static void createSingleCalculateExp(IUnCheckedExpression iUnCheckedExpression, List list) {
        if (ExpressionToolKit.isVariableExp(iUnCheckedExpression.expressionType())) {
            list.add(iUnCheckedExpression);
        } else if (ExpressionToolKit.isSingleExp(iUnCheckedExpression.expressionType())) {
            IUnCheckedSingleExpression iUnCheckedSingleExpression = (IUnCheckedSingleExpression)iUnCheckedExpression;
            ExpressionToolKit.createSingleCalculateExp(iUnCheckedSingleExpression.getExpression(), list);
        } else if (ExpressionToolKit.isBinaryExp(iUnCheckedExpression.expressionType())) {
            IUnCheckedBinaryExpression iUnCheckedBinaryExpression = (IUnCheckedBinaryExpression)iUnCheckedExpression;
            ExpressionToolKit.createSingleCalculateExp(iUnCheckedBinaryExpression.getExpression1(), list);
            ExpressionToolKit.createSingleCalculateExp(iUnCheckedBinaryExpression.getExpression2(), list);
        } else if (ExpressionToolKit.isTripleExp(iUnCheckedExpression.expressionType())) {
            IUnCheckedTripleExpression iUnCheckedTripleExpression = (IUnCheckedTripleExpression)iUnCheckedExpression;
            ExpressionToolKit.createSingleCalculateExp(iUnCheckedTripleExpression.getExpression1(), list);
            ExpressionToolKit.createSingleCalculateExp(iUnCheckedTripleExpression.getExpression2(), list);
            ExpressionToolKit.createSingleCalculateExp(iUnCheckedTripleExpression.getExpression3(), list);
        } else if (ExpressionToolKit.isMultiExp(iUnCheckedExpression.expressionType())) {
            IUnCheckedMultiExpression iUnCheckedMultiExpression = (IUnCheckedMultiExpression)iUnCheckedExpression;
            IUnCheckedExpression[] iUnCheckedExpressionArray = iUnCheckedMultiExpression.getExpressions();
            int n = iUnCheckedExpressionArray.length;
            for (int i = 0; i < n; ++i) {
                ExpressionToolKit.createSingleCalculateExp(iUnCheckedExpressionArray[i], list);
            }
        } else {
            throw new UnsupportedOperationException("" + iUnCheckedExpression.expressionType());
        }
    }

    public static boolean equals(IExpression iExpression, IExpression iExpression2) {
        if (iExpression == iExpression2) {
            return true;
        }
        if (iExpression == null || iExpression2 == null) {
            return false;
        }
        if (ExpressionToolKit.isTupleExp(iExpression.expressionType()) && ExpressionToolKit.isTupleExp(iExpression2.expressionType())) {
            ITupleExpression iTupleExpression = (ITupleExpression)iExpression;
            ITupleExpression iTupleExpression2 = (ITupleExpression)iExpression2;
            return ExpressionToolKit.createSingleConditionExp(iTupleExpression, iTupleExpression2);
        }
        if (ExpressionToolKit.isUnCheckedExp(iExpression.expressionType()) && ExpressionToolKit.isUnCheckedExp(iExpression2.expressionType())) {
            IUnCheckedExpression iUnCheckedExpression = (IUnCheckedExpression)iExpression;
            IUnCheckedExpression iUnCheckedExpression2 = (IUnCheckedExpression)iExpression2;
            return ExpressionToolKit.createSingleConsitionOp(iUnCheckedExpression, iUnCheckedExpression2);
        }
        if (ExpressionToolKit.isSetExp(iExpression.expressionType()) && ExpressionToolKit.isSetExp(iExpression2.expressionType())) {
            ISetExpression iSetExpression = (ISetExpression)iExpression;
            ISetExpression iSetExpression2 = (ISetExpression)iExpression2;
            return ExpressionToolKit.createSingleLogicExp(iSetExpression, iSetExpression2);
        }
        return false;
    }

    private static boolean createSingleConditionExp(ITupleExpression iTupleExpression, ITupleExpression iTupleExpression2) {
        if (ExpressionToolKit.isSingleTupleExp(iTupleExpression.expressionType()) && ExpressionToolKit.isSingleTupleExp(iTupleExpression2.expressionType())) {
            ISingleTupleExpression iSingleTupleExpression = (ISingleTupleExpression)iTupleExpression;
            ISingleTupleExpression iSingleTupleExpression2 = (ISingleTupleExpression)iTupleExpression2;
            return iSingleTupleExpression.equals(iSingleTupleExpression2);
        }
        if (ExpressionToolKit.isBinaryTupleExp(iTupleExpression.expressionType()) && ExpressionToolKit.isBinaryTupleExp(iTupleExpression2.expressionType())) {
            IBinaryTupleExpression iBinaryTupleExpression = (IBinaryTupleExpression)iTupleExpression;
            IBinaryTupleExpression iBinaryTupleExpression2 = (IBinaryTupleExpression)iTupleExpression2;
            return iBinaryTupleExpression.equals(iBinaryTupleExpression2);
        }
        if (ExpressionToolKit.isTripleTupleExp(iTupleExpression.expressionType()) && ExpressionToolKit.isTripleTupleExp(iTupleExpression2.expressionType())) {
            ITripleTupleExpression iTripleTupleExpression = (ITripleTupleExpression)iTupleExpression;
            ITripleTupleExpression iTripleTupleExpression2 = (ITripleTupleExpression)iTupleExpression2;
            return iTripleTupleExpression.equals(iTripleTupleExpression2);
        }
        if (ExpressionToolKit.isMultiLogicExp(iTupleExpression.expressionType()) && ExpressionToolKit.isMultiLogicExp(iTupleExpression2.expressionType())) {
            IMultiLogicExpression iMultiLogicExpression = (IMultiLogicExpression)iTupleExpression;
            IMultiLogicExpression iMultiLogicExpression2 = (IMultiLogicExpression)iTupleExpression2;
            return iMultiLogicExpression.equals(iMultiLogicExpression2);
        }
        return false;
    }

    private static boolean createSingleConsitionOp(IUnCheckedExpression iUnCheckedExpression, IUnCheckedExpression iUnCheckedExpression2) {
        if (ExpressionToolKit.isVariableExp(iUnCheckedExpression.expressionType()) && ExpressionToolKit.isVariableExp(iUnCheckedExpression2.expressionType())) {
            IUnCheckedVariableExpression iUnCheckedVariableExpression = (IUnCheckedVariableExpression)iUnCheckedExpression;
            IUnCheckedVariableExpression iUnCheckedVariableExpression2 = (IUnCheckedVariableExpression)iUnCheckedExpression2;
            return iUnCheckedVariableExpression.getValue().equals(iUnCheckedVariableExpression2.getValue());
        }
        if (ExpressionToolKit.isSingleExp(iUnCheckedExpression.expressionType()) && ExpressionToolKit.isSingleExp(iUnCheckedExpression2.expressionType())) {
            String string;
            IUnCheckedSingleExpression iUnCheckedSingleExpression = (IUnCheckedSingleExpression)iUnCheckedExpression;
            IUnCheckedSingleExpression iUnCheckedSingleExpression2 = (IUnCheckedSingleExpression)iUnCheckedExpression2;
            String string2 = iUnCheckedSingleExpression.getOperator().getOperationString();
            if (string2.equals(string = iUnCheckedSingleExpression2.getOperator().getOperationString())) {
                return ExpressionToolKit.createSingleConsitionOp(iUnCheckedSingleExpression.getExpression(), iUnCheckedSingleExpression2.getExpression());
            }
        } else if (ExpressionToolKit.isBinaryExp(iUnCheckedExpression.expressionType()) && ExpressionToolKit.isBinaryExp(iUnCheckedExpression2.expressionType())) {
            IUnCheckedExpression iUnCheckedExpression3;
            IUnCheckedExpression iUnCheckedExpression4;
            String string;
            IUnCheckedBinaryExpression iUnCheckedBinaryExpression = (IUnCheckedBinaryExpression)iUnCheckedExpression;
            IUnCheckedBinaryExpression iUnCheckedBinaryExpression2 = (IUnCheckedBinaryExpression)iUnCheckedExpression2;
            String string3 = iUnCheckedBinaryExpression.getOperator().getOperationString();
            if (string3.equals(string = iUnCheckedBinaryExpression2.getOperator().getOperationString()) && ExpressionToolKit.createSingleConsitionOp(iUnCheckedExpression4 = iUnCheckedBinaryExpression.getExpression1(), iUnCheckedExpression3 = iUnCheckedBinaryExpression2.getExpression1())) {
                IUnCheckedExpression iUnCheckedExpression5 = iUnCheckedBinaryExpression.getExpression2();
                IUnCheckedExpression iUnCheckedExpression6 = iUnCheckedBinaryExpression2.getExpression2();
                return ExpressionToolKit.createSingleConsitionOp(iUnCheckedExpression5, iUnCheckedExpression6);
            }
        } else if (ExpressionToolKit.isTripleExp(iUnCheckedExpression.expressionType()) && ExpressionToolKit.isTripleExp(iUnCheckedExpression2.expressionType())) {
            IUnCheckedExpression iUnCheckedExpression7;
            IUnCheckedExpression iUnCheckedExpression8;
            IUnCheckedExpression iUnCheckedExpression9;
            IUnCheckedExpression iUnCheckedExpression10;
            String string;
            IUnCheckedTripleExpression iUnCheckedTripleExpression = (IUnCheckedTripleExpression)iUnCheckedExpression;
            IUnCheckedTripleExpression iUnCheckedTripleExpression2 = (IUnCheckedTripleExpression)iUnCheckedExpression2;
            String string4 = iUnCheckedTripleExpression.getOperator().getOperationString();
            if (string4.equals(string = iUnCheckedTripleExpression2.getOperator().getOperationString()) && ExpressionToolKit.createSingleConsitionOp(iUnCheckedExpression10 = iUnCheckedTripleExpression.getExpression1(), iUnCheckedExpression9 = iUnCheckedTripleExpression2.getExpression1()) && ExpressionToolKit.createSingleConsitionOp(iUnCheckedExpression8 = iUnCheckedTripleExpression.getExpression2(), iUnCheckedExpression7 = iUnCheckedTripleExpression2.getExpression2())) {
                IUnCheckedExpression iUnCheckedExpression11 = iUnCheckedTripleExpression.getExpression3();
                IUnCheckedExpression iUnCheckedExpression12 = iUnCheckedTripleExpression2.getExpression3();
                return ExpressionToolKit.createSingleConsitionOp(iUnCheckedExpression11, iUnCheckedExpression12);
            }
        } else if (ExpressionToolKit.isMultiExp(iUnCheckedExpression.expressionType()) && ExpressionToolKit.isMultiExp(iUnCheckedExpression2.expressionType())) {
            String string;
            IUnCheckedMultiExpression iUnCheckedMultiExpression = (IUnCheckedMultiExpression)iUnCheckedExpression;
            IUnCheckedMultiExpression iUnCheckedMultiExpression2 = (IUnCheckedMultiExpression)iUnCheckedExpression2;
            String string5 = iUnCheckedMultiExpression.getOperator().getOperationString();
            if (string5.equals(string = iUnCheckedMultiExpression2.getOperator().getOperationString())) {
                IUnCheckedExpression[] iUnCheckedExpressionArray;
                IUnCheckedExpression[] iUnCheckedExpressionArray2 = iUnCheckedMultiExpression.getExpressions();
                if (iUnCheckedExpressionArray2.length != (iUnCheckedExpressionArray = iUnCheckedMultiExpression2.getExpressions()).length) {
                    return false;
                }
                int n = 0;
                int n2 = 0;
                while (n < iUnCheckedExpressionArray2.length) {
                    IUnCheckedExpression iUnCheckedExpression13;
                    IUnCheckedExpression iUnCheckedExpression14 = iUnCheckedExpressionArray2[n];
                    if (n2 < iUnCheckedExpressionArray.length && !ExpressionToolKit.createSingleConsitionOp(iUnCheckedExpression14, iUnCheckedExpression13 = iUnCheckedExpressionArray[n2])) {
                        return false;
                    }
                    ++n;
                    ++n2;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean createSingleLogicExp(ISetExpression iSetExpression, ISetExpression iSetExpression2) {
        block7: {
            if (ExpressionToolKit.isSortExp(iSetExpression.expressionType()) && ExpressionToolKit.isSortExp(iSetExpression2.expressionType())) {
                ISortExpression iSortExpression = (ISortExpression)iSetExpression;
                ISortExpression iSortExpression2 = (ISortExpression)iSetExpression2;
                try {
                    return iSortExpression.toExpString().equals(iSortExpression2.toExpString());
                }
                catch (ConditionException conditionException) {
                    if (addConstant.isDebugEnabled()) {
                        addConstant.debug("Expression equal compare error.", conditionException);
                    }
                    break block7;
                }
            }
            if (ExpressionToolKit.isTopNExp(iSetExpression.expressionType()) && ExpressionToolKit.isTopNExp(iSetExpression2.expressionType())) {
                ITopNExpression iTopNExpression = (ITopNExpression)iSetExpression;
                ITopNExpression iTopNExpression2 = (ITopNExpression)iSetExpression2;
                try {
                    return iTopNExpression.toExpString().equals(iTopNExpression2.toExpString());
                }
                catch (ConditionException conditionException) {
                    if (!addConstant.isDebugEnabled()) break block7;
                    addConstant.debug("Expression equal compare error.", conditionException);
                }
            }
        }
        return false;
    }

    public static IExpression parseStringToIExpression(String string, JetUUniverse jetUUniverse, String string2, String string3, JetUFormula[] jetUFormulaArray) {
        IExpression iExpression;
        block3: {
            iExpression = null;
            ParameterValueList parameterValueList = new ParameterValueList();
            try {
                ResourceContainer resourceContainer = new ResourceContainer(jetUUniverse, string2, parameterValueList, jetUFormulaArray);
                JetUQuery jetUQuery = jetUUniverse.getDatabase(string2).GetQueryByResourceName(string3);
                if (jetUQuery != null) {
                    RptPsqlQuery rptPsqlQuery = jetUQuery.getPsqlQuery();
                    iExpression = RawDataQueryTools.getExpresion(string, rptPsqlQuery, resourceContainer);
                }
            }
            catch (DSException dSException) {
                if (!addConstant.isDebugEnabled()) break block3;
                addConstant.debug("parse string to iexpression error.", dSException);
            }
        }
        return iExpression;
    }

    public static String unifyStringFormatOfExp(IExpression iExpression, boolean bl) throws ConditionException {
        if (iExpression == null) {
            return null;
        }
        String string = iExpression.getStringValue(bl);
        String string2 = null;
        string2 = ExpressionToolKit.isMultiExp(iExpression.expressionType()) ? StringTools.removeBeginAndEndParentheses(string) : string;
        return string2;
    }

    public static String unifyStringFormatOfExp(IExpression iExpression, JUnifiedBusinessView jUnifiedBusinessView, boolean bl) throws ConditionException {
        String string = iExpression.getStringValue(jUnifiedBusinessView, bl);
        String string2 = null;
        string2 = ExpressionToolKit.isMultiExp(iExpression.expressionType()) ? StringTools.removeBeginAndEndParentheses(string) : string;
        return string2;
    }

    public static boolean checkSPFieldInExp(IExpression iExpression) {
        block7: {
            block8: {
                block6: {
                    if (iExpression instanceof IUnCheckedVariableExpression) {
                        IUnCheckedVariableExpression iUnCheckedVariableExpression = (IUnCheckedVariableExpression)iExpression;
                        return iUnCheckedVariableExpression.getValue().equals("@UserName");
                    }
                    if (iExpression instanceof IUnCheckedSingleExpression) {
                        IUnCheckedSingleExpression iUnCheckedSingleExpression = (IUnCheckedSingleExpression)iExpression;
                        IUnCheckedExpression iUnCheckedExpression = iUnCheckedSingleExpression.getExpression();
                        return ExpressionToolKit.checkSPFieldInExp(iUnCheckedExpression);
                    }
                    if (!(iExpression instanceof IUnCheckedBinaryExpression)) break block6;
                    IUnCheckedBinaryExpression iUnCheckedBinaryExpression = (IUnCheckedBinaryExpression)iExpression;
                    IUnCheckedExpression iUnCheckedExpression = iUnCheckedBinaryExpression.getExpression1();
                    if (ExpressionToolKit.checkSPFieldInExp(iUnCheckedExpression)) {
                        return true;
                    }
                    IUnCheckedExpression iUnCheckedExpression2 = iUnCheckedBinaryExpression.getExpression2();
                    if (ExpressionToolKit.checkSPFieldInExp(iUnCheckedExpression2)) {
                        return true;
                    }
                    break block7;
                }
                if (!(iExpression instanceof IUnCheckedTripleExpression)) break block8;
                IUnCheckedTripleExpression iUnCheckedTripleExpression = (IUnCheckedTripleExpression)iExpression;
                IUnCheckedExpression[] iUnCheckedExpressionArray = new IUnCheckedExpression[]{iUnCheckedTripleExpression.getExpression1(), iUnCheckedTripleExpression.getExpression2(), iUnCheckedTripleExpression.getExpression3()};
                for (int i = 0; i < iUnCheckedExpressionArray.length; ++i) {
                    if (!ExpressionToolKit.checkSPFieldInExp(iUnCheckedExpressionArray[i])) continue;
                    return true;
                }
                break block7;
            }
            if (!(iExpression instanceof IUnCheckedMultiExpression)) break block7;
            IUnCheckedMultiExpression iUnCheckedMultiExpression = (IUnCheckedMultiExpression)iExpression;
            IUnCheckedExpression[] iUnCheckedExpressionArray = iUnCheckedMultiExpression.getExpressions();
            for (int i = 0; i < iUnCheckedExpressionArray.length; ++i) {
                if (!ExpressionToolKit.checkSPFieldInExp(iUnCheckedExpressionArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static IBooleanExpression createBinaryExpression(IOperator iOperator, IExpression iExpression, IExpression iExpression2) throws ConditionException {
        if (OperatorToolKit.isConditionOperator(iOperator.operatorType()) && OperatorToolKit.isBinaryOperator(iOperator.operatorType())) {
            if (ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
                return new BinaryConditionExpressionImpl((IBinaryConditionOperator)iOperator, (IVariableExpression)iExpression, (IVariableExpression)iExpression2);
            }
        } else if (OperatorToolKit.isLogicOperator(iOperator.operatorType()) && OperatorToolKit.isBinaryOperator(iOperator.operatorType())) {
            if (ExpressionToolKit.isBinaryBooleanExp(iExpression.expressionType())) {
                if (ExpressionToolKit.isBinaryBooleanExp(iExpression2.expressionType())) {
                    return new BinaryLogicExpressionImpl((IBinaryLogicOperator)iOperator, (IBooleanExpression)iExpression, (IBooleanExpression)iExpression2);
                }
                if (ExpressionToolKit.isVariableExp(iExpression2.expressionType())) {
                    return new BinaryLogicExpressionImpl((IBinaryLogicOperator)iOperator, (IBooleanExpression)iExpression, (IVariableExpression)iExpression2);
                }
            } else if (ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
                if (ExpressionToolKit.isBinaryBooleanExp(iExpression2.expressionType())) {
                    return new BinaryLogicExpressionImpl((IBinaryLogicOperator)iOperator, (IVariableExpression)iExpression, (IBooleanExpression)iExpression2);
                }
                if (ExpressionToolKit.isVariableExp(iExpression2.expressionType())) {
                    return new BinaryLogicExpressionImpl((IBinaryLogicOperator)iOperator, (IVariableExpression)iExpression, (IVariableExpression)iExpression2);
                }
            }
        } else {
            throw new IllegalArgumentException("Unknow op " + iOperator.getClass().getName());
        }
        throw new IllegalArgumentException("Unknow exp1 " + iExpression.getClass().getName() + "   exp2 " + iExpression.getClass().getName());
    }

    public static IExpression createTripleExpression(IOperator iOperator, IExpression iExpression, IExpression iExpression2, IExpression iExpression3) throws ConditionException {
        if (OperatorToolKit.isConditionOperator(iOperator.operatorType()) && OperatorToolKit.isTernaryOperator(iOperator.operatorType()) && ExpressionToolKit.isVariableExp(iExpression.expressionType()) && ExpressionToolKit.isVariableExp(iExpression.expressionType()) && ExpressionToolKit.isVariableExp(iExpression2.expressionType()) && ExpressionToolKit.isVariableExp(iExpression3.expressionType())) {
            return new TripleConditionExpressionImpl((ITripleConditionOperator)iOperator, (IVariableExpression)iExpression, (IVariableExpression)iExpression2, (IVariableExpression)iExpression3);
        }
        throw new IllegalArgumentException("Unknow exp1 " + iExpression.getClass().getName() + "   exp2 " + iExpression2.getClass().getName() + "   exp3 " + iExpression3.getClass().getName());
    }

    public static IExpression newExpWithQualifyNameExp(JetUUniverse jetUUniverse, String string, String string2, IExpression iExpression) {
        if (jetUUniverse == null || string == null || string2 == null || iExpression == null) {
            return null;
        }
        int n = 2;
        Scope scope = new Scope(null, jetUUniverse, string, null, string2, n);
        return ExpressionToolKit.newExpWithQualifyNameExp(scope, iExpression, true, null);
    }

    public static IExpression newExpWithQualifyNameExp(Scope scope, IExpression iExpression, HashSet hashSet) {
        return ExpressionToolKit.newExpWithQualifyNameExp(scope, iExpression, true, hashSet);
    }

    public static IExpression newExpWithQualifyNameExp(Scope scope, IExpression iExpression, boolean bl) {
        return ExpressionToolKit.newExpWithQualifyNameExp(scope, iExpression, bl, null);
    }

    public static IExpression newExpWithQualifyNameExp(Scope scope, IExpression iExpression, boolean bl, HashSet hashSet) {
        IExpression iExpression2;
        block3: {
            iExpression2 = null;
            if (scope == null || iExpression == null) {
                return null;
            }
            try {
                iExpression2 = ExpressionToolKit.cloneExpression(iExpression, scope, bl, null, hashSet);
            }
            catch (ConditionException conditionException) {
                if (!addConstant.isDebugEnabled()) break block3;
                addConstant.debug("Expression clone error.", conditionException);
            }
        }
        return iExpression2;
    }

    public static IExpression[] getSubExpsofMultiExp(IUnCheckedMultiExpression iUnCheckedMultiExpression) {
        if (iUnCheckedMultiExpression == null) {
            return new IExpression[0];
        }
        Vector vector = new Vector();
        ExpressionToolKit.createSingleSpecFuncCalculateOp(iUnCheckedMultiExpression, vector);
        IExpression[] iExpressionArray = new IExpression[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            iExpressionArray[i] = (IExpression)vector.get(i);
        }
        return iExpressionArray;
    }

    private static void createSingleSpecFuncCalculateOp(IExpression iExpression, Vector vector) {
        if (iExpression instanceof IUnCheckedMultiExpression) {
            IUnCheckedExpression[] iUnCheckedExpressionArray = ((IUnCheckedMultiExpression)iExpression).getExpressions();
            for (int i = 0; i < iUnCheckedExpressionArray.length; ++i) {
                ExpressionToolKit.createSingleSpecFuncCalculateOp(iUnCheckedExpressionArray[i], vector);
            }
        } else {
            vector.add(iExpression);
        }
    }

    public static void replaceAllName(IUnCheckedExpression iUnCheckedExpression, String string, String string2) {
        if (iUnCheckedExpression == null) {
            return;
        }
        String string3 = DbTools.quotedWhenNeed(string2, "", "\"", "");
        IUnCheckedVariableExpression[] iUnCheckedVariableExpressionArray = ExpressionToolKit.getUnCheckedVariableExpressions(iUnCheckedExpression);
        for (int i = 0; i < iUnCheckedVariableExpressionArray.length; ++i) {
            IUnCheckedVariableExpression iUnCheckedVariableExpression = iUnCheckedVariableExpressionArray[i];
            String string4 = iUnCheckedVariableExpression.getValue();
            ArrayList arrayList = DbTools.getMappingNamesInRawSql(string4, string);
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            int n2 = arrayList.size();
            PointEx pointEx = null;
            for (int j = 0; j < n2; ++j) {
                pointEx = (PointEx)arrayList.get(j);
                FileQuery.appendStringToBuffer(stringBuffer, string4, n, pointEx.x);
                stringBuffer.append(string3);
                n = pointEx.y;
            }
            if (n2 <= 0) continue;
            FileQuery.appendStringToBuffer(stringBuffer, string4, n, string4.length() - 1);
            iUnCheckedVariableExpression.setValue(stringBuffer.toString());
        }
    }

    public static String[] getMNames(IExpression iExpression) throws DSException {
        if (iExpression != null) {
            return null;
        }
        String[] stringArray = null;
        Vector<String> vector = new Vector<String>();
        Vector vector2 = ExpressionToolKit.getFormulaChildren(iExpression);
        Vector vector3 = ExpressionToolKit.getRefChildren(iExpression);
        Vector vector4 = ExpressionToolKit.getParameterChildren(iExpression);
        Vector vector5 = new Vector();
        if (vector3 != null) {
            vector5.addAll(vector3);
        }
        if (vector2 != null) {
            vector5.addAll(vector2);
        }
        if (vector4 != null) {
            vector5.addAll(vector4);
        }
        try {
            for (int i = 0; i < vector5.size(); ++i) {
                IVariableExpression iVariableExpression;
                String string = null;
                Object e = vector5.get(i);
                if (e instanceof IReference) {
                    iVariableExpression = (IReference)e;
                    string = iVariableExpression.getName().trim();
                } else if (e instanceof IFormula) {
                    iVariableExpression = (IFormula)e;
                    string = iVariableExpression.getName().trim();
                }
                if (StringTools.isEmptyStringWithTrim(string)) continue;
                vector.addElement(string);
            }
            stringArray = vector.toArray(new String[0]);
        }
        catch (Exception exception) {
            throw new DSException(4185, (Throwable)exception);
        }
        return stringArray;
    }

    public static void rename(IExpression iExpression, String string, String string2) throws ConditionException, DSException {
        if (iExpression != null) {
            if (iExpression instanceof IUnCheckedExpression) {
                ExpressionToolKit.replaceAllName((IUnCheckedExpression)iExpression, string, string2);
                return;
            }
            if (ExpressionToolKit.isSetExp(iExpression.expressionType())) {
                ExpressionToolKit.rename(((ISetExpression)iExpression).getExpression(), string, string2);
            } else if (ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
                ExpressionToolKit.createSortExp((IVariableExpression)iExpression, string, string2);
            } else if (ExpressionToolKit.isSingleExp(iExpression.expressionType())) {
                ExpressionToolKit.rename(((ISingle)((Object)iExpression)).getExpression(), string, string2);
            } else if (ExpressionToolKit.isBinaryExp(iExpression.expressionType())) {
                ExpressionToolKit.rename(((IBinary)((Object)iExpression)).getExpression1(), string, string2);
                ExpressionToolKit.rename(((IBinary)((Object)iExpression)).getExpression2(), string, string2);
            } else if (ExpressionToolKit.isTripleExp(iExpression.expressionType())) {
                ExpressionToolKit.rename(((ITriple)((Object)iExpression)).getExpression1(), string, string2);
                ExpressionToolKit.rename(((ITriple)((Object)iExpression)).getExpression2(), string, string2);
                ExpressionToolKit.rename(((ITriple)((Object)iExpression)).getExpression3(), string, string2);
            } else if (ExpressionToolKit.isMultiExp(iExpression.expressionType())) {
                IMultiLogicExpression iMultiLogicExpression = (IMultiLogicExpression)iExpression;
                IExpression[] iExpressionArray = iMultiLogicExpression.getExpressions();
                for (int i = 0; i < iExpressionArray.length; ++i) {
                    ExpressionToolKit.rename(iExpressionArray[i], string, string2);
                }
            }
        }
    }

    private static void createSortExp(IVariableExpression iVariableExpression, String string, String string2) throws ConditionException, DSException {
        if (ExpressionToolKit.isParameter(iVariableExpression.expressionType())) {
            IParameter iParameter = (IParameter)iVariableExpression;
            if (iParameter.getName().equalsIgnoreCase(string)) {
                ExpressionToolKit.rename(iParameter, string2);
            }
        } else if (ExpressionToolKit.isReference(iVariableExpression.expressionType())) {
            IReference iReference = (IReference)iVariableExpression;
            if (iReference.getName().equalsIgnoreCase(string)) {
                ExpressionToolKit.rename(iReference, string2);
            }
        } else if (ExpressionToolKit.isFormula(iVariableExpression.expressionType())) {
            IFormula iFormula = (IFormula)iVariableExpression;
            if (iFormula.getName().equalsIgnoreCase(string)) {
                ExpressionToolKit.rename(iFormula, string2);
            }
        } else if (ExpressionToolKit.isVariableList(iVariableExpression.expressionType())) {
            IVariableList iVariableList = (IVariableList)iVariableExpression;
            for (int i = 0; i < iVariableList.size(); ++i) {
                ExpressionToolKit.createSortExp(iVariableList.getVariableExp(i), string, string2);
            }
        }
    }

    public static IBooleanExpression buildExpression(String string, boolean bl, int n, ParamDesc paramDesc, Scope scope) throws ConditionException {
        IBooleanExpression iBooleanExpression = null;
        if (paramDesc.isAllSelected()) {
            switch (n) {
                case 556793857: {
                    iBooleanExpression = SqlToFml.getBooleanTrue();
                    break;
                }
                case 556793858: {
                    iBooleanExpression = SqlToFml.getBooleanFalse();
                    break;
                }
            }
        } else {
            iBooleanExpression = ExpressionToolKit.buildExpression(string, bl, n, paramDesc.getValue(), scope);
        }
        return iBooleanExpression;
    }

    public static IExpression buildAndExpression(DbValue[] dbValueArray, JetUUniverse jetUUniverse, String string) throws ConditionException {
        Vector<IBooleanExpression> vector = new Vector<IBooleanExpression>();
        boolean bl = false;
        JetUDatabase jetUDatabase = jetUUniverse.getDatabase(string);
        if (jetUDatabase == null) {
            throw new ConditionException(8503, new String[]{"JetUDatabase cannot be null"});
        }
        if (dbValueArray.length < 1) {
            throw new ConditionException(8503, new String[]{"dbValue array cannot be null"});
        }
        IBooleanExpression iBooleanExpression = null;
        for (int i = 0; i < dbValueArray.length; ++i) {
            if (dbValueArray[i] != null) {
                iBooleanExpression = ExpressionToolKit.createSortInfo(dbValueArray[i], jetUUniverse, string);
            }
            if (iBooleanExpression == null) continue;
            vector.add(iBooleanExpression);
        }
        if (vector.size() == 0) {
            throw new ConditionException(8503, new String[]{"Fail to create up the expression"});
        }
        if (vector.size() == 1) {
            return (IExpression)vector.get(0);
        }
        return ExpressionToolKit.buildAndExpression(vector.toArray(new IExpression[0]));
    }

    private static IBooleanExpression createSortInfo(DbValue dbValue, JetUUniverse jetUUniverse, String string) throws ConditionException {
        if (dbValue == null) {
            return null;
        }
        String string2 = dbValue.getColDesc().getColName();
        if (string2 == null || string2.length() <= 0) {
            return null;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "colName: " + string2 + " value: " + dbValue + " dataSourceName: " + string);
        }
        int n = 556793872;
        return ExpressionToolKit.buildExpression(string2, n, dbValue, jetUUniverse, string);
    }

    public static IBooleanExpression buildExpression(String string, DbValue[] dbValueArray, JetUUniverse jetUUniverse, String string2, String string3) throws ConditionException {
        if (dbValueArray == null) {
            return null;
        }
        if (string == null || string.length() <= 0) {
            return null;
        }
        if (dbValueArray.length == 0) {
            return SqlToFml.getBooleanTrue();
        }
        DbValue dbValue = null;
        int n = 0;
        if (dbValueArray.length == 1) {
            n = 556793872;
            dbValue = dbValueArray[0];
        } else {
            n = 556793857;
            DbColDesc dbColDesc = dbValueArray[0].getColDesc();
            int n2 = DataTypeDef.SqlToFml(dbColDesc.getSqlType(), dbColDesc.isCurrency()) + 11;
            fArray fArray2 = fArray.getInstance(n2, dbValueArray[0].getColDesc());
            fArray2.set(dbValueArray);
            dbValue = fArray2;
        }
        int n3 = 2;
        return ExpressionToolKit.buildExpression(string, true, n, dbValue, new Scope(null, jetUUniverse, string2, null, string3, n3));
    }

    public static IBooleanExpression buildExpression(String string, int n, DbValue dbValue, JetUUniverse jetUUniverse, String string2) throws ConditionException {
        return ExpressionToolKit.buildExpression(string, false, n, dbValue, new Scope(null, jetUUniverse, string2, null, null, 0));
    }

    public static IBooleanExpression buildExpression(String string, boolean bl, int n, DbValue dbValue, Scope scope) throws ConditionException {
        Object object;
        if (dbValue == null) {
            return null;
        }
        if (string == null || string.length() <= 0) {
            return null;
        }
        if (dbValue instanceof fArray && ((fArray)dbValue).isAll()) {
            switch (n) {
                case 556793857: {
                    return SqlToFml.getBooleanTrue();
                }
                case 556793858: {
                    return SqlToFml.getBooleanFalse();
                }
            }
            return null;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "colName: " + string + " op: " + n + " value: " + dbValue + " dataSourceName: " + scope.getDataSourceName());
        }
        IReport iReport = scope.getReport();
        String string2 = scope.getDataSourceName();
        String string3 = scope.getQueryName();
        JetUUniverse jetUUniverse = scope.getCatalog();
        int n2 = scope.getScopeType();
        IExpressionFactory iExpressionFactory = null;
        iExpressionFactory = scope != null ? ExpressionFactoryCreator.getIExpressionFactory(scope) : ExpressionFactoryCreator.getIExpressionFactory(jetUUniverse, string2);
        IOperatorFactory iOperatorFactory = ExpressionFactoryCreator.getIOperatorFactory();
        IVariableExpression iVariableExpression = null;
        JetUDatabase jetUDatabase = jetUUniverse.getDatabase(string2);
        JetUResourceEntity jetUResourceEntity = scope.getResourceEntity(string, bl);
        if (jetUResourceEntity instanceof JetUDBField || bl) {
            iVariableExpression = iExpressionFactory.createReference(string, bl);
        } else if (jetUResourceEntity instanceof JetUParameter) {
            iVariableExpression = iExpressionFactory.createParameter(string, false);
        } else if (jetUResourceEntity instanceof JetUFormula) {
            iVariableExpression = iExpressionFactory.createFormula(string);
        }
        if (iVariableExpression == null && (object = scope.getOnTheFlyFormulaByMappingName(string)) != null) {
            iVariableExpression = iExpressionFactory.createFormula(string);
        }
        if (iVariableExpression == null) {
            return null;
        }
        object = null;
        IBinaryConditionExpression iBinaryConditionExpression = null;
        object = iOperatorFactory.createBinaryConditionOp(n);
        iBinaryConditionExpression = iExpressionFactory.createBinaryConditionExp((IBinaryConditionOperator)object, iVariableExpression, ExpressionToolKit.createSortInfoCollector(dbValue, null, null, iExpressionFactory));
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "return: " + iBinaryConditionExpression.toExpString());
        }
        return iBinaryConditionExpression;
    }

    private static IVariableExpression createSortInfoCollector(DbValue dbValue, String string, String string2, IExpressionFactory iExpressionFactory) throws ConditionException {
        IVariableExpression iVariableExpression = null;
        String string3 = dbValue.getColDesc().getColName();
        if (string3 == null) {
            string3 = dbValue.toString();
        }
        if (dbValue.isNull()) {
            iVariableExpression = iExpressionFactory.createConstant(string3);
            iVariableExpression.setNull(true);
            int n = dbValue.getSqlType();
            n = Types.sqlTypeToType(n);
            iVariableExpression.setDataType(n);
            return iVariableExpression;
        }
        if (dbValue instanceof fArray) {
            fArray fArray2 = (fArray)dbValue;
            IVariableList iVariableList = iExpressionFactory.createVariableList("");
            DbValue[] dbValueArray = fArray2.value;
            for (int i = 0; i < dbValueArray.length; ++i) {
                IConstant iConstant = iExpressionFactory.createConstant(string3);
                if (dbValueArray[i].isNull()) {
                    iConstant.setNull(true);
                } else {
                    int n = dbValueArray[i].getColDesc().getSqlType();
                    if (Types.isTimeType(n = Types.sqlTypeToType(n))) {
                        switch (n) {
                            case 92: {
                                iConstant.setValue(((DbTime)dbValueArray[i]).toFormatString("HH:mm:ss.SSS"));
                                break;
                            }
                            case 91: {
                                iConstant.setValue(((DbDate)dbValueArray[i]).toFormatString("yyyy-MM-dd"));
                                break;
                            }
                            case 93: {
                                iConstant.setValue(((DbDateTime)dbValueArray[i]).toFormatString("yyyy-MM-dd HH:mm:ss.SSS"));
                            }
                        }
                    } else {
                        iConstant.setValue(dbValueArray[i].toString());
                    }
                    iConstant.setDataType(n);
                }
                iVariableList.addConstant(iConstant);
            }
            iVariableExpression = iVariableList;
        } else if (dbValue instanceof DbArray) {
            ExpressionToolKit.createTopNExp((DbArray)dbValue, string, string2, iExpressionFactory);
        } else {
            IConstant iConstant = iExpressionFactory.createConstant(string3);
            int n = dbValue.getSqlType();
            if (Types.isTimeType(n = Types.sqlTypeToType(n))) {
                switch (n) {
                    case 92: {
                        iConstant.setValue(((DbTime)dbValue).toFormatString("HH:mm:ss.SSS"));
                        break;
                    }
                    case 91: {
                        iConstant.setValue(((DbDate)dbValue).toFormatString("yyyy-MM-dd"));
                        break;
                    }
                    case 93: {
                        iConstant.setValue(((DbDateTime)dbValue).toFormatString("yyyy-MM-dd HH:mm:ss.SSS"));
                    }
                }
            } else {
                String string4;
                if (dbValue.getSqlType() == 12) {
                    string4 = new CharBinaryFormat("XX").format(dbValue);
                    if (string != null && string4 != null) {
                        String string5 = string4;
                        string4 = string4.replace(string, string2);
                        if (addConstant.isDebugEnabled()) {
                            addConstant.debug("\t###EscapeReplaceCharacters### ExpressionToolKit.change2Constant()... replace string-type of parameter's value: oldVal =" + string5 + ", newVal =" + string4 + "; colName =" + string3 + "; strEscapeCharacters =" + string + ", strEscapeReplaced=" + string2);
                        }
                    }
                } else {
                    string4 = dbValue.toString();
                }
                iConstant.setValue(string4);
            }
            iConstant.setDataType(n);
            iVariableExpression = iConstant;
        }
        return iVariableExpression;
    }

    private static void createSortOp(String string, String string2, int n, IVariableList iVariableList, String string3, String string4, IExpressionFactory iExpressionFactory) throws ConditionException {
        IConstant iConstant = iExpressionFactory.createConstant(string2);
        iConstant.setValue(string);
        iConstant.setDataType(Types.sqlTypeToType(n));
        iVariableList.addConstant(iConstant);
    }

    private static IVariableExpression createTopNExp(DbArray dbArray, String string, String string2, IExpressionFactory iExpressionFactory) throws ConditionException {
        int n = dbArray.getColDesc().sqlType;
        String string3 = dbArray.getColDesc().getColName();
        IVariableList iVariableList = iExpressionFactory.createVariableList("");
        switch (n) {
            case -7: {
                boolean[] blArray = (boolean[])dbArray.getValue();
                for (int i = 0; i < blArray.length; ++i) {
                    ExpressionToolKit.createSortOp(String.valueOf(blArray[i]), string3, n, iVariableList, string, string2, iExpressionFactory);
                    IConstant iConstant = iExpressionFactory.createConstant(string3);
                }
                break;
            }
            case -6: {
                byte[] byArray = (byte[])dbArray.getValue();
                for (int i = 0; i < byArray.length; ++i) {
                    ExpressionToolKit.createSortOp(String.valueOf(byArray[i]), string3, n, iVariableList, string, string2, iExpressionFactory);
                    IConstant iConstant = iExpressionFactory.createConstant(string3);
                }
                break;
            }
            case 5: {
                short[] sArray = (short[])dbArray.getValue();
                for (int i = 0; i < sArray.length; ++i) {
                    ExpressionToolKit.createSortOp(String.valueOf(sArray[i]), string3, n, iVariableList, string, string2, iExpressionFactory);
                    IConstant iConstant = iExpressionFactory.createConstant(string3);
                }
                break;
            }
            case 4: {
                int[] nArray = (int[])dbArray.getValue();
                for (int i = 0; i < nArray.length; ++i) {
                    ExpressionToolKit.createSortOp(String.valueOf(nArray[i]), string3, n, iVariableList, string, string2, iExpressionFactory);
                    IConstant iConstant = iExpressionFactory.createConstant(string3);
                }
                break;
            }
            case -5: {
                long[] lArray = (long[])dbArray.getValue();
                for (int i = 0; i < lArray.length; ++i) {
                    ExpressionToolKit.createSortOp(String.valueOf(lArray[i]), string3, n, iVariableList, string, string2, iExpressionFactory);
                    IConstant iConstant = iExpressionFactory.createConstant(string3);
                }
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                long[] lArray = (long[])dbArray.getValue();
                int[] nArray = null;
                SimpleDateFormat simpleDateFormat = null;
                if (n == 91) {
                    simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                } else if (n == 92) {
                    simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
                } else {
                    simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    nArray = dbArray.getNanos();
                }
                if (n == 93) {
                    if (nArray != null) {
                        for (int i = 0; i < lArray.length; ++i) {
                            ExpressionToolKit.createSortOp(simpleDateFormat.format(new Date(lArray[i] + (long)(nArray[i] / 1000000))), string3, n, iVariableList, string, string2, iExpressionFactory);
                            IConstant iConstant = iExpressionFactory.createConstant(string3);
                        }
                    } else {
                        for (int i = 0; i < lArray.length; ++i) {
                            ExpressionToolKit.createSortOp(simpleDateFormat.format(new Date(lArray[i])), string3, n, iVariableList, string, string2, iExpressionFactory);
                            IConstant iConstant = iExpressionFactory.createConstant(string3);
                        }
                    }
                } else {
                    for (int i = 0; i < lArray.length; ++i) {
                        ExpressionToolKit.createSortOp(simpleDateFormat.format(new Date(lArray[i])), string3, n, iVariableList, string, string2, iExpressionFactory);
                        IConstant iConstant = iExpressionFactory.createConstant(string3);
                    }
                }
                break;
            }
            case 7: {
                float[] fArray2 = (float[])dbArray.getValue();
                for (int i = 0; i < fArray2.length; ++i) {
                    ExpressionToolKit.createSortOp(String.valueOf(fArray2[i]), string3, n, iVariableList, string, string2, iExpressionFactory);
                    IConstant iConstant = iExpressionFactory.createConstant(string3);
                }
                break;
            }
            case 6: 
            case 8: {
                double[] dArray = (double[])dbArray.getValue();
                for (int i = 0; i < dArray.length; ++i) {
                    ExpressionToolKit.createSortOp(String.valueOf(dArray[i]), string3, n, iVariableList, string, string2, iExpressionFactory);
                    IConstant iConstant = iExpressionFactory.createConstant(string3);
                }
                break;
            }
            case 2: 
            case 3: {
                BigDecimal[] bigDecimalArray = (BigDecimal[])dbArray.getValue();
                for (int i = 0; i < bigDecimalArray.length; ++i) {
                    ExpressionToolKit.createSortOp(String.valueOf(bigDecimalArray[i]), string3, n, iVariableList, string, string2, iExpressionFactory);
                    IConstant iConstant = iExpressionFactory.createConstant(string3);
                }
                break;
            }
            case 1: 
            case 12: {
                String[] stringArray = (String[])dbArray.getValue();
                for (int i = 0; i < stringArray.length; ++i) {
                    ExpressionToolKit.createSortOp(stringArray[i], string3, n, iVariableList, string, string2, iExpressionFactory);
                    IConstant iConstant = iExpressionFactory.createConstant(string3);
                }
                break;
            }
            default: {
                if (!JRLog.isTrace(6)) break;
                JRLog.trace(6, "invalid sql type: " + n);
            }
        }
        return iVariableList;
    }

    private static Object createTopNInfo(int n, IConstant iConstant) throws DSException, ConditionException {
        Object object = ExpressionToolKit.parseConstant(n, iConstant);
        switch (n) {
            case 93: {
                if (!(object instanceof Date)) break;
                object = new Timestamp(((Date)object).getTime());
                break;
            }
            case 92: {
                if (!(object instanceof Date)) break;
                object = new Time(((Date)object).getTime());
            }
        }
        return object;
    }

    public static Vector getJetUConnectionByField(JetUDatabase jetUDatabase, String string) {
        Object object;
        Object object2;
        JetUResourceEntity jetUResourceEntity = jetUDatabase.getResourceByName(null, string);
        if (jetUResourceEntity == null) {
            if (string.indexOf(46) < 0) {
                return null;
            }
            object2 = string.substring(0, string.indexOf(46));
            object = string.substring(string.indexOf(46) + 1);
            String string2 = SqlTools.removeQuotes((String)object2);
            String string3 = SqlTools.removeQuotes((String)object);
            jetUResourceEntity = jetUDatabase.getResourceByName(null, string3);
        }
        object2 = new Vector<JetUConnection>();
        if (jetUResourceEntity instanceof JetUDBField) {
            ((Vector)object2).add(((JetUDBField)((Object)jetUResourceEntity)).getConnection());
        } else if (jetUResourceEntity instanceof JetUFormula) {
            object = ((JetUFormula)jetUResourceEntity).getRefAllDbFld();
            int n = ((Vector)object).size();
            for (int i = 0; i < n; ++i) {
                Vector vector = ExpressionToolKit.getJetUConnectionByField(jetUDatabase, (String)((Vector)object).get(i));
                int n2 = vector.size();
                for (int j = 0; j < n2; ++j) {
                    if (((Vector)object2).contains(vector.get(j))) continue;
                    ((Vector)object2).add((JetUConnection)vector.get(j));
                }
            }
        }
        return object2;
    }

    public static JetUConnection getJetUConnectionByField(JetUUniverse jetUUniverse, String string, String string2) {
        return ExpressionToolKit.getJetUConnectionByField(jetUUniverse, string, null, string2);
    }

    public static JetUConnection getJetUConnectionByField(JetUUniverse jetUUniverse, String string, String string2, String string3) {
        Object object;
        Object object2;
        JetUResourceEntity jetUResourceEntity = null;
        if (string2 == null) {
            jetUResourceEntity = jetUUniverse.getResourceByName(string, null, string3);
            if (jetUResourceEntity == null) {
                if (string3.indexOf(46) < 0) {
                    return null;
                }
                object2 = string3.substring(0, string3.indexOf(46));
                object = string3.substring(string3.indexOf(46) + 1);
                String string4 = SqlTools.removeQuotes((String)object2);
                String string5 = SqlTools.removeQuotes((String)object);
                jetUResourceEntity = jetUUniverse.getResourceByName(string, null, string5);
            }
        } else {
            object2 = ExpressionToolKit.getEntityFJoinVarialbe(jetUUniverse, string, string2, string3, null);
            if (object2 != null && ((Object[])object2).length > 0) {
                jetUResourceEntity = (JetUResourceEntity)object2[0];
            }
        }
        object2 = null;
        if (jetUResourceEntity instanceof JetUDBField) {
            object2 = ((JetUDBField)((Object)jetUResourceEntity)).getConnection();
        } else if (jetUResourceEntity instanceof JetUFormula && (object = ((JetUFormula)jetUResourceEntity).getRefAllDbFld()) != null && ((Vector)object).size() > 0) {
            object2 = ExpressionToolKit.getJetUConnectionByField(jetUUniverse, string, string2, (String)((Vector)object).get(0));
        }
        return object2;
    }

    public static JetUConnection getJetUConnectionByTable(JetUUniverse jetUUniverse, String string, String string2) {
        JetUConnection[] jetUConnectionArray;
        JetUDatabase jetUDatabase = jetUUniverse.getDatabase(string);
        JetUTableView jetUTableView = jetUDatabase.GetTableOrViewByResourceName(string2);
        if (jetUTableView != null) {
            return jetUTableView.getConnection();
        }
        JetUQueriable jetUQueriable = jetUDatabase.getQueriableByResourceName(string2);
        if (jetUQueriable != null && (jetUConnectionArray = jetUQueriable.getConnections()) != null && jetUConnectionArray.length > 0) {
            return jetUConnectionArray[0];
        }
        return null;
    }

    static {
        addConstant = DSLog.getDSLog(ExpressionToolKit.class.getName());
        try {
            SqlToFml = ExpressionFactoryCreator.getIExpressionFactory();
            add = ExpressionFactoryCreator.getIOperatorFactory();
            addAll = ExpressionFactoryCreator.getIOperatorInforFactory();
        }
        catch (ConditionException conditionException) {
            throw new RuntimeException(conditionException);
        }
        addElement = 1;
        addFormula = 2;
    }
}

