/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.api.expression.transform;

import com.jinfonet.api.datatypes.Types;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionFactoryCreator;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.IExpressionFactory;
import jet.dataengine.api.expression.IOperator;
import jet.dataengine.api.expression.IOperatorFactory;
import jet.dataengine.api.expression.IOperatorInforFactory;
import jet.dataengine.api.expression.OperatorToolKit;
import jet.dataengine.api.expression.transform.OutputIExpression;
import jet.dataengine.api.expression.tuple.IBinaryLogicExpression;
import jet.dataengine.api.expression.tuple.IBinaryTupleExpression;
import jet.dataengine.api.expression.tuple.IBooleanExpression;
import jet.dataengine.api.expression.tuple.IMultiLogicExpression;
import jet.dataengine.api.expression.tuple.ISingleLogicExpression;
import jet.dataengine.api.expression.tuple.ISingleTupleExpression;
import jet.dataengine.api.expression.tuple.ITripleTupleExpression;
import jet.dataengine.api.expression.tuple.op.IBinaryConditionOperator;
import jet.dataengine.api.expression.tuple.op.IBinaryLogicOperator;
import jet.dataengine.api.expression.tuple.op.IMultiLogicOperator;
import jet.dataengine.api.expression.tuple.op.ISingleConditionOperator;
import jet.dataengine.api.expression.tuple.op.ISingleLogicOperator;
import jet.dataengine.api.expression.tuple.op.ITripleConditionOperator;
import jet.dataengine.api.expression.tuple.op.ITupleOperator;
import jet.dataengine.api.expression.variable.IConstant;
import jet.dataengine.api.expression.variable.IFormula;
import jet.dataengine.api.expression.variable.IReference;
import jet.dataengine.api.expression.variable.IVariableExpression;
import jet.dataengine.api.expression.variable.IVariableList;
import jet.export.xml.LoadXSDException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import toolkit.db.gui.MappingSQLType;

public class ExpressionTransform {
    public static final int MAPPING_NAME = 0;
    public static final int QUALIFY_NAME = 1;
    private static String SEDU = "AbbrIExpression.xsd";
    private static IExpressionFactory add;
    private static IOperatorFactory addConstant;
    private static IOperatorInforFactory contains;

    private ExpressionTransform() {
    }

    public static Document expToXml(IExpression iExpression, String string, boolean bl, boolean bl2) throws LoadXSDException {
        OutputIExpression outputIExpression = new OutputIExpression();
        ExpressionTransform.SEDU(null, iExpression, outputIExpression, string, bl, bl2);
        Document document = outputIExpression.getDoc();
        return document;
    }

    private static void SEDU(Element element, IExpression iExpression, OutputIExpression outputIExpression, String string, boolean bl, boolean bl2) {
        ITupleOperator iTupleOperator = null;
        Element element2 = null;
        if (ExpressionToolKit.isVariableExp(iExpression.expressionType())) {
            IVariableExpression iVariableExpression = (IVariableExpression)iExpression;
            if (ExpressionToolKit.isReference(iExpression.expressionType()) && bl) {
                return;
            }
            outputIExpression.putObject(element, iVariableExpression, string, bl, bl2);
        } else {
            if (ExpressionToolKit.isSingleTupleExp(iExpression.expressionType())) {
                ISingleTupleExpression iSingleTupleExpression = (ISingleTupleExpression)iExpression;
                iTupleOperator = iSingleTupleExpression.getOperator();
                IExpression iExpression2 = iSingleTupleExpression.getExpression();
                element2 = outputIExpression.putObject(element, iSingleTupleExpression, string, bl, bl2);
                outputIExpression.putObject(element2, iTupleOperator);
                ExpressionTransform.SEDU(element2, iExpression2, outputIExpression, string, bl, bl2);
                return;
            }
            if (ExpressionToolKit.isSingleLogicExp(iExpression.expressionType())) {
                ISingleLogicExpression iSingleLogicExpression = (ISingleLogicExpression)iExpression;
                iTupleOperator = iSingleLogicExpression.getOperator();
                IExpression iExpression3 = iSingleLogicExpression.getExpression();
                element2 = outputIExpression.putObject(element, iSingleLogicExpression, string, bl, bl2);
                outputIExpression.putObject(element2, iTupleOperator);
                ExpressionTransform.SEDU(element2, iExpression3, outputIExpression, string, bl, bl2);
                return;
            }
            if (ExpressionToolKit.isBinaryTupleExp(iExpression.expressionType())) {
                IBinaryTupleExpression iBinaryTupleExpression = (IBinaryTupleExpression)iExpression;
                iTupleOperator = iBinaryTupleExpression.getOperator();
                IExpression iExpression4 = iBinaryTupleExpression.getExpression1();
                IExpression iExpression5 = iBinaryTupleExpression.getExpression2();
                element2 = outputIExpression.putObject(element, iBinaryTupleExpression, string, bl, bl2);
                outputIExpression.putObject(element2, iTupleOperator);
                ExpressionTransform.SEDU(element2, iExpression4, outputIExpression, string, bl, bl2);
                ExpressionTransform.SEDU(element2, iExpression5, outputIExpression, string, bl, bl2);
                return;
            }
            if (ExpressionToolKit.isBinaryLogicExp(iExpression.expressionType())) {
                IBinaryLogicExpression iBinaryLogicExpression = (IBinaryLogicExpression)iExpression;
                iTupleOperator = iBinaryLogicExpression.getOperator();
                IExpression iExpression6 = iBinaryLogicExpression.getExpression1();
                IExpression iExpression7 = iBinaryLogicExpression.getExpression2();
                element2 = outputIExpression.putObject(element, iBinaryLogicExpression, string, bl, bl2);
                outputIExpression.putObject(element2, iTupleOperator);
                ExpressionTransform.SEDU(element2, iExpression6, outputIExpression, string, bl, bl2);
                ExpressionTransform.SEDU(element2, iExpression7, outputIExpression, string, bl, bl2);
                return;
            }
            if (ExpressionToolKit.isTripleTupleExp(iExpression.expressionType())) {
                ITripleTupleExpression iTripleTupleExpression = (ITripleTupleExpression)iExpression;
                iTupleOperator = iTripleTupleExpression.getOperator();
                IExpression iExpression8 = iTripleTupleExpression.getExpression1();
                IExpression iExpression9 = iTripleTupleExpression.getExpression2();
                IExpression iExpression10 = iTripleTupleExpression.getExpression3();
                element2 = outputIExpression.putObject(element, iTripleTupleExpression, string, bl, bl2);
                outputIExpression.putObject(element2, iTupleOperator);
                ExpressionTransform.SEDU(element2, iExpression8, outputIExpression, string, bl, bl2);
                ExpressionTransform.SEDU(element2, iExpression9, outputIExpression, string, bl, bl2);
                ExpressionTransform.SEDU(element2, iExpression10, outputIExpression, string, bl, bl2);
                return;
            }
            if (ExpressionToolKit.isMultiLogicExp(iExpression.expressionType())) {
                IMultiLogicExpression iMultiLogicExpression = (IMultiLogicExpression)iExpression;
                iTupleOperator = iMultiLogicExpression.getOperator();
                IExpression[] iExpressionArray = iMultiLogicExpression.getExpressions();
                element2 = outputIExpression.putObject(element, iMultiLogicExpression, string, bl, bl2);
                outputIExpression.putObject(element2, iTupleOperator);
                for (int i = 0; i < iExpressionArray.length; ++i) {
                    ExpressionTransform.SEDU(element2, iExpressionArray[i], outputIExpression, string, bl, bl2);
                }
                return;
            }
        }
    }

    public static IExpression xmlToExp(Document document, String string, int n) throws LoadXSDException, ConditionException {
        OutputIExpression outputIExpression = null;
        Object object = null;
        outputIExpression = new OutputIExpression();
        object = ExpressionTransform.add(document.getDocumentElement(), outputIExpression, string, n);
        return (IExpression)object;
    }

    private static Object add(Element element, OutputIExpression outputIExpression, String string, int n) throws LoadXSDException, ConditionException {
        Object object;
        String string2 = element.getNodeName();
        Vector<Object> vector = new Vector<Object>();
        HashSet hashSet = outputIExpression.getChildEleName(string2);
        if (hashSet != null && hashSet.size() > 0) {
            object = element.getChildNodes();
            Node node = null;
            for (int i = 0; i < object.getLength(); ++i) {
                node = object.item(i);
                String string3 = node.getNodeName();
                if (!hashSet.contains(string3)) continue;
                vector.add(ExpressionTransform.add((Element)node, outputIExpression, string, n));
            }
        }
        object = ExpressionTransform.createObject(string2, vector, element, string, n);
        return object;
    }

    public static Object createObject(String string, Vector vector, Element element, String string2, int n) throws LoadXSDException, ConditionException {
        Object object = null;
        if (string.equalsIgnoreCase("Operator")) {
            String string3 = element.getTextContent();
            object = OperatorToolKit.createOPerator(string3);
        } else if (string.equalsIgnoreCase("ConstantExp")) {
            String string4 = element.getAttributeNode("Value").getValue();
            IConstant iConstant = add.createConstant(string4);
            iConstant.setValue(string4);
            Attr attr = element.getAttributeNode("SqlType");
            if (attr != null) {
                String string5 = attr.getValue();
                int n2 = Types.sqlTypeToType(MappingSQLType.mappingSQLTypeToInt(string5));
                iConstant.setDataType(n2);
            }
            object = iConstant;
        } else if (string.equalsIgnoreCase("ReferencefExp")) {
            boolean bl;
            Attr attr = element.getAttributeNode("RefName");
            String string6 = string2;
            boolean bl2 = bl = n == 1;
            if (attr != null) {
                string6 = attr.getValue();
            }
            if ((attr = element.getAttributeNode("RefNameType")) != null) {
                bl = !attr.getValue().equalsIgnoreCase("Mapping");
            }
            object = add.createReference(string6, bl);
        } else if (string.equalsIgnoreCase("TripleOprandExp")) {
            int n3 = vector == null ? 0 : vector.size();
            ITripleConditionOperator iTripleConditionOperator = null;
            IVariableExpression iVariableExpression = null;
            IVariableExpression iVariableExpression2 = null;
            IVariableExpression iVariableExpression3 = null;
            for (int i = 0; i < n3; ++i) {
                Object e = vector.get(i);
                if (e instanceof ITripleConditionOperator) {
                    iTripleConditionOperator = (ITripleConditionOperator)e;
                    continue;
                }
                if (e instanceof IReference || e instanceof IFormula) {
                    iVariableExpression = (IVariableExpression)e;
                    continue;
                }
                if (!(e instanceof IVariableExpression)) continue;
                if (iVariableExpression2 == null) {
                    iVariableExpression2 = (IVariableExpression)e;
                    continue;
                }
                iVariableExpression3 = (IVariableExpression)e;
            }
            if (iVariableExpression == null) {
                String string7 = string2;
                boolean bl = n == 1;
                iVariableExpression = add.createReference(string7, bl);
            }
            if (iVariableExpression == null || iVariableExpression2 == null || iVariableExpression3 == null || iTripleConditionOperator == null) {
                throw new ConditionException(0, (Throwable)new Exception());
            }
            object = add.createTripleConditionExp(iTripleConditionOperator, iVariableExpression, iVariableExpression2, iVariableExpression3);
        } else if (string.equalsIgnoreCase("BinaryOprandExp")) {
            int n4 = vector == null ? 0 : vector.size();
            IOperator iOperator = null;
            IVariableExpression iVariableExpression = null;
            IVariableExpression iVariableExpression4 = null;
            IVariableList iVariableList = add.createVariableList("");
            for (int i = 0; i < n4; ++i) {
                Object e = vector.get(i);
                if (e instanceof IBinaryConditionOperator) {
                    iOperator = (IBinaryConditionOperator)e;
                    continue;
                }
                if (e instanceof IReference || e instanceof IFormula) {
                    iVariableExpression = (IVariableExpression)e;
                    continue;
                }
                if (!(e instanceof IVariableExpression)) continue;
                if (iVariableExpression4 != null && iVariableExpression4 instanceof IConstant) {
                    if (!(e instanceof IConstant)) continue;
                    iVariableList.addConstant((IConstant)e);
                    continue;
                }
                iVariableExpression4 = (IVariableExpression)e;
                if (!(iVariableExpression4 instanceof IConstant)) continue;
                iVariableList.addConstant((IConstant)iVariableExpression4);
            }
            if (iOperator.operatorType() == 556793857) {
                iVariableExpression4 = iVariableList;
            }
            if (iVariableExpression == null) {
                String string8 = string2;
                boolean bl = n == 1;
                iVariableExpression = add.createReference(string8, bl);
            }
            if (iVariableExpression == null || iVariableExpression4 == null || iOperator == null) {
                throw new ConditionException(0, (Throwable)new Exception());
            }
            object = add.createBinaryConditionExp((IBinaryConditionOperator)iOperator, iVariableExpression, iVariableExpression4);
        } else if (string.equalsIgnoreCase("SingleOprandExp")) {
            int n5 = vector == null ? 0 : vector.size();
            ISingleConditionOperator iSingleConditionOperator = null;
            IVariableExpression iVariableExpression = null;
            for (int i = 0; i < n5; ++i) {
                Object e = vector.get(i);
                if (e instanceof ISingleConditionOperator) {
                    iSingleConditionOperator = (ISingleConditionOperator)e;
                    continue;
                }
                if (!(e instanceof IReference) && !(e instanceof IFormula)) continue;
                iVariableExpression = (IVariableExpression)e;
            }
            if (iVariableExpression == null) {
                String string9 = string2;
                boolean bl = n == 1;
                iVariableExpression = add.createReference(string9, bl);
            }
            if (iVariableExpression == null || iSingleConditionOperator == null) {
                throw new ConditionException(0, (Throwable)new Exception());
            }
            object = add.createSingleConditionExp(iSingleConditionOperator, iVariableExpression);
        } else if (string.equalsIgnoreCase("LogicExp")) {
            int n6 = vector == null ? 0 : vector.size();
            ISingleLogicOperator iSingleLogicOperator = null;
            IMultiLogicOperator iMultiLogicOperator = null;
            IBinaryLogicOperator iBinaryLogicOperator = null;
            int n7 = n6 > 1 ? n6 - 1 : n6;
            IExpression[] iExpressionArray = new IExpression[n7];
            int n8 = 0;
            for (int i = 0; i < n6; ++i) {
                Object e = vector.get(i);
                if (e instanceof ISingleLogicOperator) {
                    iSingleLogicOperator = (ISingleLogicOperator)e;
                    continue;
                }
                if (e instanceof IBinaryLogicOperator) {
                    iBinaryLogicOperator = (IBinaryLogicOperator)e;
                    continue;
                }
                if (e instanceof IMultiLogicOperator) {
                    iMultiLogicOperator = (IMultiLogicOperator)e;
                    continue;
                }
                iExpressionArray[n8++] = (IExpression)e;
            }
            if (iExpressionArray.length > 2) {
                iMultiLogicOperator = iBinaryLogicOperator;
                iBinaryLogicOperator = null;
            }
            if (iSingleLogicOperator != null) {
                if (iExpressionArray[0] == null) {
                    String string10 = string2;
                    boolean bl = n == 1;
                    iExpressionArray[0] = add.createReference(string10, bl);
                }
                object = iExpressionArray[0] instanceof IVariableExpression ? add.createSingleLogicExp(iSingleLogicOperator, (IVariableExpression)iExpressionArray[0]) : add.createSingleLogicExp(iSingleLogicOperator, (IBooleanExpression)iExpressionArray[0]);
            } else if (iBinaryLogicOperator != null) {
                if (iExpressionArray[0] == null) {
                    String string11 = string2;
                    boolean bl = n == 1;
                    iExpressionArray[0] = add.createReference(string11, bl);
                }
                if (iExpressionArray[1] == null) {
                    String string12 = string2;
                    boolean bl = n == 1;
                    iExpressionArray[1] = add.createReference(string12, bl);
                }
                if (iExpressionArray[0] instanceof IVariableExpression && iExpressionArray[1] instanceof IVariableExpression) {
                    object = add.createBinaryLogicExp(iBinaryLogicOperator, (IVariableExpression)iExpressionArray[0], (IVariableExpression)iExpressionArray[1]);
                } else if (iExpressionArray[0] instanceof IVariableExpression && iExpressionArray[1] instanceof IBooleanExpression) {
                    object = add.createBinaryLogicExp(iBinaryLogicOperator, (IVariableExpression)iExpressionArray[0], (IBooleanExpression)iExpressionArray[1]);
                } else if (iExpressionArray[0] instanceof IBooleanExpression && iExpressionArray[1] instanceof IVariableExpression) {
                    object = add.createBinaryLogicExp(iBinaryLogicOperator, (IBooleanExpression)iExpressionArray[0], (IVariableExpression)iExpressionArray[1]);
                } else if (iExpressionArray[0] instanceof IBooleanExpression && iExpressionArray[1] instanceof IBooleanExpression) {
                    object = add.createBinaryLogicExp(iBinaryLogicOperator, (IBooleanExpression)iExpressionArray[0], (IBooleanExpression)iExpressionArray[1]);
                }
            } else if (iMultiLogicOperator != null) {
                object = add.createMultiLogicExp(iMultiLogicOperator, iExpressionArray);
            } else if (iExpressionArray.length > 0) {
                return iExpressionArray[0];
            }
        }
        return object;
    }

    public static IExpression toQualifyName(IExpression iExpression, String string) throws ConditionException {
        IExpression iExpression2 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = "";
        Vector vector = ExpressionToolKit.getRefChildren(iExpression);
        if (vector == null || vector.size() <= 0) {
            return iExpression;
        }
        string2 = ((IReference)vector.get(0)).getName().toUpperCase();
        hashMap.put(string2, string);
        iExpression2 = ExpressionToolKit.toRuntimeColumnName(iExpression, hashMap);
        return iExpression2;
    }

    static {
        try {
            add = ExpressionFactoryCreator.getIExpressionFactory();
            addConstant = ExpressionFactoryCreator.getIOperatorFactory();
            contains = ExpressionFactoryCreator.getIOperatorInforFactory();
        }
        catch (ConditionException conditionException) {
            throw new RuntimeException(conditionException);
        }
    }
}

