/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.api.group;

import jet.dataengine.api.group.Key;
import jet.dataengine.api.group.SortBlock;

class IndexNode {
    boolean[] mode;
    Object left;
    Object right;
    IndexNode parent;
    IndexNode prev;
    IndexNode next;
    Key leftKey;
    Key rightKey;

    IndexNode(boolean[] blArray) {
        this.mode = blArray;
    }

    SortBlock getBlock(Key key) {
        if (this.rightKey == null || key.compare(this.leftKey, this.mode) == -1) {
            if (this.left instanceof IndexNode) {
                return ((IndexNode)this.left).getBlock(key);
            }
            return (SortBlock)this.left;
        }
        if (this.right instanceof IndexNode) {
            return ((IndexNode)this.right).getBlock(key);
        }
        return (SortBlock)this.right;
    }

    SortBlock setLeft(SortBlock sortBlock) {
        SortBlock sortBlock2 = (SortBlock)this.left;
        this.left = sortBlock;
        sortBlock.parent = this;
        this.leftKey = sortBlock.keys[sortBlock.length - 1];
        return sortBlock2;
    }

    SortBlock setRight(SortBlock sortBlock) {
        SortBlock sortBlock2 = (SortBlock)this.right;
        this.right = sortBlock;
        sortBlock.parent = this;
        this.rightKey = sortBlock.keys[sortBlock.length - 1];
        if (this.parent != null) {
            this.parent.update(this);
        }
        return sortBlock2;
    }

    void setLeft(IndexNode indexNode) {
        this.left = indexNode;
        indexNode.parent = this;
        this.leftKey = indexNode.rightKey;
    }

    void setRight(IndexNode indexNode) {
        this.right = indexNode;
        indexNode.parent = this;
        this.rightKey = indexNode.rightKey;
        if (this.parent != null) {
            this.parent.update(this);
        }
    }

    boolean isLeft(Object object) {
        return this.left == object;
    }

    boolean isRight(Object object) {
        return this.right == object;
    }

    IndexNode getFirst() {
        IndexNode indexNode = this;
        while (indexNode.prev != null) {
            indexNode = indexNode.prev;
        }
        return indexNode;
    }

    void update(SortBlock sortBlock) {
        if (sortBlock == this.left) {
            this.leftKey = sortBlock.keys[sortBlock.length - 1];
        } else if (sortBlock == this.right) {
            this.rightKey = sortBlock.keys[sortBlock.length - 1];
            if (this.parent != null) {
                this.parent.update(this);
            }
        }
    }

    void update(IndexNode indexNode) {
        if (indexNode == this.left) {
            this.leftKey = indexNode.rightKey;
        } else if (indexNode == this.right) {
            this.rightKey = indexNode.rightKey;
            if (this.parent != null) {
                this.parent.update(this);
            }
        }
    }
}

