/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.api.group.pls;

import com.jinfonet.resstore.DiskStore;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import jet.cs.jacl.SecurityData;
import jet.dataengine.api.DSException;
import jet.dataengine.api.group.pls.JGroupTreePLS;
import jet.dataengine.api.group.pls.PLSObj;
import jet.dataengine.groupengine.group.PLSTool;
import jet.dataengine.util.DSLog;
import jet.universe.resultfile.ResultSetTool;
import jet.util.IntVector;

public class PLSProcessor {
    private static DSLog SEDU = DSLog.getDSLog(PLSProcessor.class.getName());

    public static synchronized void applyAndSave(DataOutputStream dataOutputStream, JGroupTreePLS jGroupTreePLS) throws DSException {
        PLSProcessor.applyAndSave(dataOutputStream, jGroupTreePLS, null);
    }

    public static synchronized PLSObj load(DataInput dataInput, DiskStore diskStore) throws DSException {
        HashMap<String, IntVector> hashMap = new HashMap<String, IntVector>();
        HashMap<String, IntVector> hashMap2 = new HashMap<String, IntVector>();
        HashMap<String, IntVector> hashMap3 = new HashMap<String, IntVector>();
        try {
            ResultSet resultSet = ResultSetTool.loadResultSet(dataInput, diskStore);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            int n2 = -1;
            String string = null;
            IntVector intVector = null;
            while (resultSet.next()) {
                block14: for (int i = 1; i <= n; ++i) {
                    switch (resultSetMetaData.getColumnType(i)) {
                        case 4: {
                            n2 = resultSet.getInt(i);
                            continue block14;
                        }
                        case 12: {
                            string = resultSet.getString(i);
                            continue block14;
                        }
                        case 2003: {
                            if (resultSet.getArray(i).getBaseType() == 4) {
                                int[] nArray = (int[])resultSet.getArray(i).getArray();
                                intVector = new IntVector();
                                int n3 = -1;
                                boolean bl = false;
                                for (int j = 0; j < nArray.length; ++j) {
                                    if (bl) {
                                        while (n3 < nArray[j] - 1) {
                                            intVector.addElement(++n3);
                                        }
                                        bl = false;
                                    }
                                    if (nArray[j] == -1) {
                                        bl = true;
                                    }
                                    if (bl) continue;
                                    intVector.addElement(nArray[j]);
                                    n3 = nArray[j];
                                }
                                continue block14;
                            }
                            throw new DSException(4153, new Integer[]{new Integer(resultSet.getArray(i).getBaseType())});
                        }
                        default: {
                            throw new DSException(4154, new Integer[]{new Integer(resultSetMetaData.getColumnType(i))});
                        }
                    }
                }
                switch (n2) {
                    case 0: {
                        hashMap.put(string, intVector);
                        if (!SEDU.isDebugEnabled()) break;
                        SEDU.debug("when load PLS data, user name=" + string + " record indexs=" + intVector);
                        break;
                    }
                    case 1: {
                        hashMap2.put(string, intVector);
                        if (!SEDU.isDebugEnabled()) break;
                        SEDU.debug("when load PLS data, group name=" + string + " record indexs=" + intVector);
                        break;
                    }
                    case 2: {
                        hashMap3.put(string, intVector);
                        if (!SEDU.isDebugEnabled()) break;
                        SEDU.debug("when load PLS data, role name=" + string + " record indexs=" + intVector);
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new DSException(4155, (Throwable)iOException);
        }
        catch (SQLException sQLException) {
            throw new DSException(4155, (Throwable)sQLException);
        }
        return new PLSObj(hashMap, hashMap2, hashMap3);
    }

    public static synchronized void applyAndSave(DataOutputStream dataOutputStream, JGroupTreePLS jGroupTreePLS, String string) throws DSException {
        PLSTool pLSTool = new PLSTool(jGroupTreePLS);
        ResultSet resultSet = pLSTool.apply(string);
        try {
            ResultSetTool.writeResultSet(dataOutputStream, resultSet);
        }
        catch (IOException iOException) {
            throw new DSException(4156, (Throwable)iOException);
        }
        catch (SQLException sQLException) {
            throw new DSException(4156, (Throwable)sQLException);
        }
    }

    public static ArrayList getGroupByValueList(JGroupTreePLS jGroupTreePLS, int n, int n2, String string, SecurityData securityData) throws DSException {
        if (jGroupTreePLS == null || securityData == null) {
            throw new DSException(4162);
        }
        if (string == null || string.trim().length() == 0) {
            throw new DSException(4163);
        }
        PLSTool pLSTool = new PLSTool(jGroupTreePLS, n, n2, string, securityData);
        ArrayList arrayList = pLSTool.getGroupByValueList();
        return arrayList;
    }
}

