/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.api.query;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import jet.dataengine.api.DSException;
import jet.dataengine.util.DSLog;

public class ADimensionKeyDescription
implements Externalizable {
    private static final long serialVersionUID = -4670446189969599292L;
    public static final int NORMAL = 0;
    public static final int SPECIAL_ORDER = 1;
    public static final int SPECIAL_FUNCTION = 2;
    protected static final String[] TYPE_NAME = new String[]{"Normal", "Special Order", "Special Function"};
    protected DSLog log = DSLog.getDSLog(this.getClass().getName());
    private static String SEDU = "ADimensionKeyDescription";
    protected int type;
    protected String mappingName;

    public ADimensionKeyDescription() {
    }

    public ADimensionKeyDescription(int n, String string) throws DSException {
        this.type = n;
        this.mappingName = string;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return TYPE_NAME[this.type];
    }

    public String getMappingName() {
        return this.mappingName;
    }

    public void dump() {
        if (!this.log.isDebugEnabled()) {
            return;
        }
        this.log.debug("Dimension key description");
        this.log.indent(SEDU);
        this.log.debug("mappingName = " + this.mappingName);
        this.log.debug("Sort type = " + this.type);
        this.log.deIndent(SEDU);
        this.log.debug("End Dimension key description");
    }

    public boolean equals(Object object) {
        ADimensionKeyDescription aDimensionKeyDescription;
        return object instanceof ADimensionKeyDescription && (aDimensionKeyDescription = (ADimensionKeyDescription)object).getType() == this.getType() && aDimensionKeyDescription.getMappingName().equalsIgnoreCase(this.getMappingName());
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.type = objectInput.readInt();
        this.mappingName = (String)objectInput.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.type);
        objectOutput.writeObject(this.mappingName);
    }
}

